/*****************************************************************************************
*
* \file    dia_ITunerAMFM.h
*
* \brief   interface of dia_ITunerAMFM
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITunerAMFM.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNERAMFM__
#define __INCLUDED_DIA_INTERFACE_TUNERAMFM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_TUNER_AMFM ((dia::IID) 0x2a56ca6a)
//------------------------------------------------------------------------------
enum dia_eTunerNr
{
   DIA_EN_AMFMTUNER_UNKNOWN = 0,
   DIA_EN_AMFMTUNER_1,
   DIA_EN_AMFMTUNER_2,
   DIA_EN_AMFMTUNER_3,
   DIA_EN_AMFMTUNER_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eBandAMFM
{
   DIA_EN_AMFMTUNER_BAND_UNKNOWN = 0,
   DIA_EN_AMFMTUNER_BAND_AM,
   DIA_EN_AMFMTUNER_BAND_FM,
   DIA_EN_AMFMTUNER_BAND_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eTunerAMFMNotification
{
   DIA_EN_TUNERAMFM_NOTIFICATION_UNKNOWN = 0,
   DIA_EN_TUNERAMFM_NOTIFICATION_FREQUENCY,
   DIA_EN_TUNERAMFM_NOTIFICATION_RDSPROGRAMINFORMATION,
   DIA_EN_TUNERAMFM_NOTIFICATION_BAND,
   DIA_EN_TUNERAMFM_NOTIFICATION_RADIO_TUNER1_STATUS,
   DIA_EN_TUNERAMFM_NOTIFICATION_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eTunerAMFMModulation
{
   DIA_EN_TUNERAMFM_MODULATION_UNKNOWN = 0,
   DIA_EN_TUNERAMFM_MODULATION_AM,
   DIA_EN_TUNERAMFM_MODULATION_FM,
   DIA_EN_TUNERAMFM_MODULATION_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eTunerAMFMSeekDirection
{
   DIA_EN_TUNERAMFM_DIR_UNKNOWN = 0,
   DIA_EN_TUNERAMFM_DIR_UP,
   DIA_EN_TUNERAMFM_DIR_DOWN,
   DIA_EN_TUNERAMFM_DIR_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eTunerAMFMAction
{
   DIA_EN_TUNERAMFM_ACT_UNKNOWN = 0,
   DIA_EN_TUNERAMFM_ACT_START,
   DIA_EN_TUNERAMFM_ACT_STOP,
   DIA_EN_TUNERAMFM_ACT_COUNT = 3
};
class dia_ITunerAMFM
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TUNER_AMFM; }
public:
   //! OPCODE UPREG request
   virtual tDiaResult tunerAMFM_attachNotification (dia_eTunerAMFMNotification id ) = 0;
   //! OPCODE RELREG answer
   virtual tDiaResult tunerAMFM_detachNotification (dia_eTunerAMFMNotification id ) = 0;
   //! Function from SH to SA to select the currently tuner frequency.
   virtual tDiaResult tunerAMFM_Frequency_Get ( ) = 0;
   //! Function from SH to SA to set the tuner frequency in kHz.
   virtual tDiaResult tunerAMFM_Frequency_Set (tU32 newFrequencyKHZ ) = 0;
   //! Function from SH to SA to read the tuner band (AM/FM).
   virtual tDiaResult tunerAMFM_TunerBand_Get ( ) = 0;
   //! Function from SH to SA to read the RDS ProgramInformation of the current tuner station on tuner FM1.
   virtual tDiaResult tunerAMFM_TunerFMRDSProgramInformation_Get ( ) = 0;
   //! Function from SH to SA to read the field intensity of the current tuner station on tuner AM/FM1.
   virtual tDiaResult tunerAMFM_TunerFieldStrength_Get ( ) = 0;
   //! Function from SH to SA to seek (start or stop) tuner station on tuner towards higher or lower frequency (FM or AM).
   virtual tDiaResult tunerAMFM_Frequency_Seek (dia_eTunerAMFMModulation /*modulation*/, dia_eTunerAMFMSeekDirection /*direction*/, dia_eTunerAMFMAction /*action*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! Function from SH to SA to set the EnsembleFrequency of DRM tuner.
   virtual tDiaResult tunerDRM_EnsembleFrequency_Set (tU32 frequency ) = 0;
   //! Function from SH to SA to set the service ID of DRM tuner.
   virtual tDiaResult tunerDRM_ServiceID_Set (tU32 serviceID ) = 0;
   //! Function from SH to SA to set the testmode feature of tuner. Tuner features can be switched ON OR OFF, one feature at a time. This function is used for Testmode.
   virtual tDiaResult tunerAMFM_SetTestmodeFeature ( ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerAMFM( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_TUNERAMFM__ */
