/*****************************************************************************************
*
* \file    ITemperatureHistogramListener.h
*
* \brief   listener of ITemperatureHistogramListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author hpe2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITemperatureHistogram.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM_LISTENER__
#define __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM__
#include "dia_ITemperatureHistogram.h"
#endif

#define IID_TEMPERATURE_HISTOGRAM_LISTENER ((dia::IID) 0x6a6b0cd0)
namespace dia {
/**
 *
 *  \class ITemperatureHistogramListener
 *
 */

class ITemperatureHistogramListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TEMPERATURE_HISTOGRAM_LISTENER; }
public:
   virtual void onTemperatureHistogram (const dia_tTemperatureHistogram& histogram ) = 0;

protected:
   //! virtual base class destructor
   virtual ~ITemperatureHistogramListener( void ) {}
};
/**
 *
 *  \class ITemperatureHistogramListenerImpl
 *
 */

class ITemperatureHistogramListenerImpl
   : public ITemperatureHistogramListener
{
public:
   virtual void onTemperatureHistogram (const dia_tTemperatureHistogram& /*histogram*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~ITemperatureHistogramListenerImpl( void ) {}
};
/**
 *
 *  \class ITemperatureHistogramNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class ITemperatureHistogramNotifier
   : public ITemperatureHistogramListener,
     public dia_Notifier<ITemperatureHistogramListener>
{
public:
   virtual void onTemperatureHistogram (const dia_tTemperatureHistogram& histogram)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onTemperatureHistogram(histogram);
      }
   }
};

//lint +e665
} /* namespace dia */


#endif /* __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM_LISTENER__ */
