/*****************************************************************************************
*
* \file    dia_ISwUpdateListener.h
*
* \brief   listener of dia_ISwUpdateListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISwUpdate.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SW_UPDATE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SW_UPDATE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SW_UPDATE__
#include "dia_ISwUpdate.h"
#endif

#define IID_SW_UPDATE_LISTENER ((dia::IID) 0x7eff394e)
/**
 *
 *  \class dia_ISwUpdateListener
 *
 */

class dia_ISwUpdateListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SW_UPDATE_LISTENER; }
public:
   //! notification of the Sw Update
   virtual void vOnSwUpdateInfo (const std::vector<dia_tProgramHistory>& progInfo ) = 0;
   //! notification of the Re-Sw Update
   virtual void vOnNoOfSwReUpdate (tU16 noOfReprogramming ) = 0;
   //! notification of the Recovery Mode
   virtual void vOnRecoveryMode (tBool recoveryMode ) = 0;
   //! notification about an update of all sub-modules of the system with embedded firmware
   virtual void vOnUpdateAllSubModules (bool bOk, dia_eSwUpdateError& eResult ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISwUpdateListener( void ) {}
};
/**
 *
 *  \class dia_ISwUpdateListenerImpl
 *
 */

class dia_ISwUpdateListenerImpl
   : public dia_ISwUpdateListener
{
public:
   //! notification of the Sw Update
   virtual void vOnSwUpdateInfo (const std::vector<dia_tProgramHistory>& /*progInfo*/ ) {}
   //! notification of the Re-Sw Update
   virtual void vOnNoOfSwReUpdate (tU16 /*noOfReprogramming*/ ) {}
   //! notification of the Recovery Mode
   virtual void vOnRecoveryMode (tBool /*recoveryMode*/ ) {}
   //! notification about an update of all sub-modules of the system with embedded firmware
   virtual void vOnUpdateAllSubModules (bool /*bOk*/, dia_eSwUpdateError& /*eResult*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISwUpdateListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ISwUpdateNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISwUpdateNotifier
   : public dia_ISwUpdateListener,
     public dia_Notifier<dia_ISwUpdateListener>
{
public:
   //! notification of the Sw Update
   virtual void vOnSwUpdateInfo (const std::vector<dia_tProgramHistory>& progInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSwUpdateInfo(progInfo);
      }
   }
   //! notification of the Re-Sw Update
   virtual void vOnNoOfSwReUpdate (tU16 noOfReprogramming)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnNoOfSwReUpdate(noOfReprogramming);
      }
   }
   //! notification of the Recovery Mode
   virtual void vOnRecoveryMode (tBool recoveryMode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRecoveryMode(recoveryMode);
      }
   }
   //! notification about an update of all sub-modules of the system with embedded firmware
   virtual void vOnUpdateAllSubModules (bool bOk, dia_eSwUpdateError& eResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnUpdateAllSubModules(bOk, eResult);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SW_UPDATE_LISTENER__ */
