/*****************************************************************************************
*
* \file    dia_ISwUpdate.h
*
* \brief   interface of dia_ISwUpdate
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISwUpdate.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SW_UPDATE__
#define __INCLUDED_DIA_INTERFACE_SW_UPDATE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_SW_UPDATE ((dia::IID) 0xf18914e8)
//------------------------------------------------------------------------------
enum dia_eSwUpdateID
{
   DIA_EN_PROG_LOG_HISTORY_ID_UNKNOWN = 0,
   DIA_EN_PROG_LOG_HISTORY_ID_N_1,
   DIA_EN_PROG_LOG_HISTORY_ID_N_2,
   DIA_EN_PROG_LOG_HISTORY_ID_N_3,
   DIA_EN_PROG_LOG_HISTORY_ID_N_4,
   DIA_EN_PROG_LOG_HISTORY_ID_N_5,
   DIA_EN_PROG_LOG_HISTORY_ID_N_6,
   DIA_EN_PROG_LOG_HISTORY_ID_N_7,
   DIA_EN_PROG_LOG_HISTORY_ID_N_8,
   DIA_EN_PROG_LOG_HISTORY_ID_N_9,
   DIA_EN_PROG_LOG_HISTORY_ID_COUNT = 10
};
//------------------------------------------------------------------------------
enum dia_eProgUpdateHistoryScope
{
   DIA_EN_UPDATE_HISTORY_SCOPE_UNKNOWN = 0,
   DIA_EN_UPDATE_HISTORY_SCOPE_ALL,
   DIA_EN_UPDATE_HISTORY_SCOPE_FIRST_USB,
   DIA_EN_UPDATE_HISTORY_SCOPE_FIRST_OTA,
   DIA_EN_UPDATE_HISTORY_SCOPE_FIRST_USB_SINCE_FACTORY,
   DIA_EN_UPDATE_HISTORY_SCOPE_FIRST_OTA_SINCE_FACTORY,
   DIA_EN_UPDATE_HISTORY_SCOPE_INITIAL,
   DIA_EN_UPDATE_HISTORY_SCOPE_INITIAL_SINCE_FACTORY,
   DIA_EN_UPDATE_HISTORY_SCOPE_ALL_SINCE_FACTORY,
   DIA_EN_UPDATE_HISTORY_SCOPE_COUNT = 9
};
//------------------------------------------------------------------------------
enum dia_eSwUpdateError
{
   DIA_EN_UPDATE_ERROR_OK = 0,
   DIA_EN_UPDATE_ERROR_UNKNOWN = 1,
   DIA_EN_UPDATE_ERROR_COUNT = 3
};
struct dia_tProgramHistory
{
public:
   //! default constructor
   dia_tProgramHistory() :
      mProgID(DIA_EN_PROG_LOG_HISTORY_ID_UNKNOWN),
      mYear(0),
      mMonth(0),
      mDay(0),
      mHour(0),
      mMinute(0),
      mSecond(0),
      mProgStatus(FALSE),
      mReprogramIndex(0),
      mSwVersionName(),
      mPadding(0)
   {}

   //! class constructor
   dia_tProgramHistory(
      dia_eSwUpdateID mProgID_,
      tU16 mYear_,
      tU8 mMonth_,
      tU8 mDay_,
      tU8 mHour_,
      tU8 mMinute_,
      tU8 mSecond_,
      tBool mProgStatus_,
      tU16 mReprogramIndex_,
      std::string mSwVersionName_,
      tU8 mPadding_
   ) :
      mProgID(mProgID_),
      mYear(mYear_),
      mMonth(mMonth_),
      mDay(mDay_),
      mHour(mHour_),
      mMinute(mMinute_),
      mSecond(mSecond_),
      mProgStatus(mProgStatus_),
      mReprogramIndex(mReprogramIndex_),
      mSwVersionName(mSwVersionName_),
      mPadding(mPadding_)
   {}
   dia_eSwUpdateID mProgID;
   tU16 mYear;
   tU8 mMonth;
   tU8 mDay;
   tU8 mHour;
   tU8 mMinute;
   tU8 mSecond;
   tBool mProgStatus;
   tU16 mReprogramIndex;
   std::string mSwVersionName;
   tU8 mPadding;
};
struct dia_tHistoryScope
{
public:
   //! default constructor
   dia_tHistoryScope() :
      mHistoryScope(DIA_EN_UPDATE_HISTORY_SCOPE_UNKNOWN),
      mIndexStart(0),
      mMaxEntries(0)
   {}

   //! class constructor
   dia_tHistoryScope(
      dia_eProgUpdateHistoryScope mHistoryScope_,
      tU32 mIndexStart_,
      tU32 mMaxEntries_
   ) :
      mHistoryScope(mHistoryScope_),
      mIndexStart(mIndexStart_),
      mMaxEntries(mMaxEntries_)
   {}
   dia_eProgUpdateHistoryScope mHistoryScope;
   tU32 mIndexStart;
   tU32 mMaxEntries;
};
class dia_ISwUpdate
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SW_UPDATE; }
public:
   //! request the programming log info
   virtual tDiaResult getSwUpdateInfo (const dia_tHistoryScope& historyScope ) = 0;
   //! request the recovery mode
   virtual tDiaResult enterRecoveryMode ( ) = 0;
   //! request to start an update of all sub-modules of the system with embedded firmware
   virtual tDiaResult updateAllSubModules ( ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
   //! virtual base class destructor
   virtual ~dia_ISwUpdate( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SW_UPDATE__ */
