/*****************************************************************************************
*
* \file    dia_ISpmSVP.h
*
* \brief   interface of dia_ISpmSVP
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author hpe2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISpmSVP.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SPMSVP__
#define __INCLUDED_DIA_INTERFACE_SPMSVP__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#include "dia_ISpm.h"
#define IID_SPMSVP ((dia::IID) 0x38aa5624)
struct dia_tSpmSVPWakeupReasonElement
{
public:
   //! default constructor
   dia_tSpmSVPWakeupReasonElement() :
      mTimeDate(),
      mReason(DIA_EN_SPM_WAKEUP_REASON_UNKNOWN)
   {}

   //! class constructor
   dia_tSpmSVPWakeupReasonElement(
      dia_tSpmTimeDate mTimeDate_,
      dia_eSpmWakeUpReason mReason_
   ) :
      mTimeDate(mTimeDate_),
      mReason(mReason_)
   {}
   dia_tSpmTimeDate mTimeDate;
   dia_eSpmWakeUpReason mReason;
};
struct dia_tSpmSVPResetElement
{
public:
   //! default constructor
   dia_tSpmSVPResetElement() :
      mTimeDate(),
      mReason(0)
   {}

   //! class constructor
   dia_tSpmSVPResetElement(
      dia_tSpmTimeDate mTimeDate_,
      uint8_t mReason_
   ) :
      mTimeDate(mTimeDate_),
      mReason(mReason_)
   {}
   dia_tSpmTimeDate mTimeDate;
   uint8_t mReason;
};
struct dia_tSpmSVPSubStateElement
{
public:
   //! default constructor
   dia_tSpmSVPSubStateElement() :
      mMask(0),
      mData(0)
   {}

   //! class constructor
   dia_tSpmSVPSubStateElement(
      uint32_t mMask_,
      uint32_t mData_
   ) :
      mMask(mMask_),
      mData(mData_)
   {}
   uint32_t mMask;
   uint32_t mData;
};
struct dia_tSpmSVPStateHistoryElement
{
public:
   //! default constructor
   dia_tSpmSVPStateHistoryElement() :
      mTimeDate(),
      mSystemState(0),
      mEntryType(),
      mWakeUpReason(),
      mResetReason(0),
      mSubStatesList()
   {}

   //! class constructor
   dia_tSpmSVPStateHistoryElement(
      dia_tSpmTimeDate mTimeDate_,
      uint32_t mSystemState_,
      dia_eSpmStateEntry mEntryType_,
      dia_eSpmWakeUpReason mWakeUpReason_,
      uint8_t mResetReason_,
      std::vector<dia_tSpmSVPSubStateElement> mSubStatesList_
   ) :
      mTimeDate(mTimeDate_),
      mSystemState(mSystemState_),
      mEntryType(mEntryType_),
      mWakeUpReason(mWakeUpReason_),
      mResetReason(mResetReason_),
      mSubStatesList(mSubStatesList_)
   {}
   dia_tSpmTimeDate mTimeDate;
   uint32_t mSystemState;
   dia_eSpmStateEntry mEntryType;
   dia_eSpmWakeUpReason mWakeUpReason;
   uint8_t mResetReason;
   std::vector<dia_tSpmSVPSubStateElement> mSubStatesList;
};
struct dia_tSpmSVPSwVersionInfo
{
public:
   //! default constructor
   dia_tSpmSVPSwVersionInfo() :
      mCustomerVersion(),
      mBuildVersion(),
      mBuildVersionLabel()
   {}

   //! class constructor
   dia_tSpmSVPSwVersionInfo(
      std::string mCustomerVersion_,
      std::string mBuildVersion_,
      std::string mBuildVersionLabel_
   ) :
      mCustomerVersion(mCustomerVersion_),
      mBuildVersion(mBuildVersion_),
      mBuildVersionLabel(mBuildVersionLabel_)
   {}
   std::string mCustomerVersion;
   std::string mBuildVersion;
   std::string mBuildVersionLabel;
};
struct dia_tSpmSVPReqResetInformationForSWVersion
{
public:
//! request reset information for software version
   //! default constructor
   dia_tSpmSVPReqResetInformationForSWVersion() :
      mIndex(0)
   {}

   //! class constructor
   dia_tSpmSVPReqResetInformationForSWVersion(
      uint32_t mIndex_
   ) :
      mIndex(mIndex_)
   {}
   uint32_t mIndex;
};
struct dia_tSpmSVPResetInformationForSWVersion
{
public:
//! reset information for software version
   //! default constructor
   dia_tSpmSVPResetInformationForSWVersion() :
      mVersion(),
      mData()
   {}

   //! class constructor
   dia_tSpmSVPResetInformationForSWVersion(
      dia_tSpmSVPSwVersionInfo mVersion_,
      dia_tSpmResetCounterStatus mData_
   ) :
      mVersion(mVersion_),
      mData(mData_)
   {}
   dia_tSpmSVPSwVersionInfo mVersion;
   dia_tSpmResetCounterStatus mData;
};
struct dia_tSpmSVPReqWakeupHistoryForSWVersion
{
public:
//! request wakeup history for software version
   //! default constructor
   dia_tSpmSVPReqWakeupHistoryForSWVersion() :
      mIndex(0)
   {}

   //! class constructor
   dia_tSpmSVPReqWakeupHistoryForSWVersion(
      uint32_t mIndex_
   ) :
      mIndex(mIndex_)
   {}
   uint32_t mIndex;
};
struct dia_tSpmSVPWakeupHistoryForSWVersion
{
public:
//! wakeup history for software version
   //! default constructor
   dia_tSpmSVPWakeupHistoryForSWVersion() :
      mVersion(),
      mList()
   {}

   //! class constructor
   dia_tSpmSVPWakeupHistoryForSWVersion(
      dia_tSpmSVPSwVersionInfo mVersion_,
      std::vector<dia_tSpmSVPWakeupReasonElement> mList_
   ) :
      mVersion(mVersion_),
      mList(mList_)
   {}
   dia_tSpmSVPSwVersionInfo mVersion;
   std::vector<dia_tSpmSVPWakeupReasonElement> mList;
};
struct dia_tSpmSVPReqResetHistoryForSWVersion
{
public:
//! request reset history for software version
   //! default constructor
   dia_tSpmSVPReqResetHistoryForSWVersion() :
      mIndex(0)
   {}

   //! class constructor
   dia_tSpmSVPReqResetHistoryForSWVersion(
      uint32_t mIndex_
   ) :
      mIndex(mIndex_)
   {}
   uint32_t mIndex;
};
struct dia_tSpmSVPResetHistoryForSWVersion
{
public:
//! reset history for software version
   //! default constructor
   dia_tSpmSVPResetHistoryForSWVersion() :
      mVersion(),
      mList()
   {}

   //! class constructor
   dia_tSpmSVPResetHistoryForSWVersion(
      dia_tSpmSVPSwVersionInfo mVersion_,
      std::vector<dia_tSpmSVPResetElement> mList_
   ) :
      mVersion(mVersion_),
      mList(mList_)
   {}
   dia_tSpmSVPSwVersionInfo mVersion;
   std::vector<dia_tSpmSVPResetElement> mList;
};
struct dia_tSpmSVPReqStateHistoryForSWVersion
{
public:
//! request state history for software version
   //! default constructor
   dia_tSpmSVPReqStateHistoryForSWVersion() :
      mIndex(0)
   {}

   //! class constructor
   dia_tSpmSVPReqStateHistoryForSWVersion(
      uint32_t mIndex_
   ) :
      mIndex(mIndex_)
   {}
   uint32_t mIndex;
};
struct dia_tSpmSVPStateHistoryForSWVersion
{
public:
//! state history for software version
   //! default constructor
   dia_tSpmSVPStateHistoryForSWVersion() :
      mVersion(),
      mList()
   {}

   //! class constructor
   dia_tSpmSVPStateHistoryForSWVersion(
      dia_tSpmSVPSwVersionInfo mVersion_,
      std::vector<dia_tSpmSVPStateHistoryElement> mList_
   ) :
      mVersion(mVersion_),
      mList(mList_)
   {}
   dia_tSpmSVPSwVersionInfo mVersion;
   std::vector<dia_tSpmSVPStateHistoryElement> mList;
};
struct dia_tSpmSVPReqErrorStateHistoryForSWVersion
{
public:
//! request error state history for software version
   //! default constructor
   dia_tSpmSVPReqErrorStateHistoryForSWVersion() :
      mIndex(0),
      mErrorStateIndex(0)
   {}

   //! class constructor
   dia_tSpmSVPReqErrorStateHistoryForSWVersion(
      uint32_t mIndex_,
      uint8_t mErrorStateIndex_
   ) :
      mIndex(mIndex_),
      mErrorStateIndex(mErrorStateIndex_)
   {}
   uint32_t mIndex;
   uint8_t mErrorStateIndex;
};
struct dia_tSpmSVPErrorStateHistoryForSWVersion
{
public:
//! error state history for software version
   //! default constructor
   dia_tSpmSVPErrorStateHistoryForSWVersion() :
      mVersion(),
      mList()
   {}

   //! class constructor
   dia_tSpmSVPErrorStateHistoryForSWVersion(
      dia_tSpmSVPSwVersionInfo mVersion_,
      std::vector<dia_tSpmSVPStateHistoryElement> mList_
   ) :
      mVersion(mVersion_),
      mList(mList_)
   {}
   dia_tSpmSVPSwVersionInfo mVersion;
   std::vector<dia_tSpmSVPStateHistoryElement> mList;
};
struct dia_tSpmSVPReqSystemOperationTimeForSWVersion
{
public:
//! request system operation time for software version
   //! default constructor
   dia_tSpmSVPReqSystemOperationTimeForSWVersion() :
      mIndex(0)
   {}

   //! class constructor
   dia_tSpmSVPReqSystemOperationTimeForSWVersion(
      uint32_t mIndex_
   ) :
      mIndex(mIndex_)
   {}
   uint32_t mIndex;
};
struct dia_tSpmSVPSystemOperationTimeForSWVersion
{
public:
//! system operation time for software version
   //! default constructor
   dia_tSpmSVPSystemOperationTimeForSWVersion() :
      mVersion(),
      mTimeInSeconds(0)
   {}

   //! class constructor
   dia_tSpmSVPSystemOperationTimeForSWVersion(
      dia_tSpmSVPSwVersionInfo mVersion_,
      uint32_t mTimeInSeconds_
   ) :
      mVersion(mVersion_),
      mTimeInSeconds(mTimeInSeconds_)
   {}
   dia_tSpmSVPSwVersionInfo mVersion;
   uint32_t mTimeInSeconds;
};
struct dia_tSpmSVPReqAverageCpuLoadForSWVersion
{
public:
//! request average CPU-load for software version
   //! default constructor
   dia_tSpmSVPReqAverageCpuLoadForSWVersion() :
      mIndex(0)
   {}

   //! class constructor
   dia_tSpmSVPReqAverageCpuLoadForSWVersion(
      uint32_t mIndex_
   ) :
      mIndex(mIndex_)
   {}
   uint32_t mIndex;
};
struct dia_tSpmSVPAverageCpuLoadForSWVersion
{
public:
//! average CPU-load for software version
   //! default constructor
   dia_tSpmSVPAverageCpuLoadForSWVersion() :
      mVersion(),
      mData()
   {}

   //! class constructor
   dia_tSpmSVPAverageCpuLoadForSWVersion(
      dia_tSpmSVPSwVersionInfo mVersion_,
      dia_tSpmStatisticData mData_
   ) :
      mVersion(mVersion_),
      mData(mData_)
   {}
   dia_tSpmSVPSwVersionInfo mVersion;
   dia_tSpmStatisticData mData;
};
struct dia_tSpmSVPReqMaximumRamConsumptionForSWVersion
{
public:
//! request maximum RAM-consumption for software version
   //! default constructor
   dia_tSpmSVPReqMaximumRamConsumptionForSWVersion() :
      mIndex(0)
   {}

   //! class constructor
   dia_tSpmSVPReqMaximumRamConsumptionForSWVersion(
      uint32_t mIndex_
   ) :
      mIndex(mIndex_)
   {}
   uint32_t mIndex;
};
struct dia_tSpmSVPMaximumRamConsumptionForSWVersion
{
public:
//! maximum RAM-consumption for software version
   //! default constructor
   dia_tSpmSVPMaximumRamConsumptionForSWVersion() :
      mVersion(),
      mData()
   {}

   //! class constructor
   dia_tSpmSVPMaximumRamConsumptionForSWVersion(
      dia_tSpmSVPSwVersionInfo mVersion_,
      dia_tSpmStatisticData mData_
   ) :
      mVersion(mVersion_),
      mData(mData_)
   {}
   dia_tSpmSVPSwVersionInfo mVersion;
   dia_tSpmStatisticData mData;
};
struct dia_tSpmSVPReqStartupTimeStatisticForSWVersion
{
public:
//! request startup-time statistics for software version
   //! default constructor
   dia_tSpmSVPReqStartupTimeStatisticForSWVersion() :
      mIndex(0)
   {}

   //! class constructor
   dia_tSpmSVPReqStartupTimeStatisticForSWVersion(
      uint32_t mIndex_
   ) :
      mIndex(mIndex_)
   {}
   uint32_t mIndex;
};
struct dia_tSpmSVPStartupTimeStatisticForSWVersion
{
public:
//! startup-time statistics for software version
   //! default constructor
   dia_tSpmSVPStartupTimeStatisticForSWVersion() :
      mVersion(),
      mData()
   {}

   //! class constructor
   dia_tSpmSVPStartupTimeStatisticForSWVersion(
      dia_tSpmSVPSwVersionInfo mVersion_,
      dia_tSpmStatisticData mData_
   ) :
      mVersion(mVersion_),
      mData(mData_)
   {}
   dia_tSpmSVPSwVersionInfo mVersion;
   dia_tSpmStatisticData mData;
};
class dia_ISpmSVP
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SPMSVP; }
public:
   //! request reset information for a software version
   virtual tDiaResult handleRequest (dia_tSpmSVPReqResetInformationForSWVersion* state ) = 0;
   //! request wakeup history for a software version
   virtual tDiaResult handleRequest (dia_tSpmSVPReqWakeupHistoryForSWVersion* state ) = 0;
   //! request reset history for a software version
   virtual tDiaResult handleRequest (dia_tSpmSVPReqResetHistoryForSWVersion* state ) = 0;
   //! request state history for a software version
   virtual tDiaResult handleRequest (dia_tSpmSVPReqStateHistoryForSWVersion* state ) = 0;
   //! request error state history for a software version
   virtual tDiaResult handleRequest (dia_tSpmSVPReqErrorStateHistoryForSWVersion* state ) = 0;
   //! request system operation time for a software version
   virtual tDiaResult handleRequest (dia_tSpmSVPReqSystemOperationTimeForSWVersion* state ) = 0;
   //! request average cpu-load for a software version
   virtual tDiaResult handleRequest (dia_tSpmSVPReqAverageCpuLoadForSWVersion* state ) = 0;
   //! request maximum RAM-consumption for a software version
   virtual tDiaResult handleRequest (dia_tSpmSVPReqMaximumRamConsumptionForSWVersion* state ) = 0;
   //! request startup-time statistics for a software version
   virtual tDiaResult handleRequest (dia_tSpmSVPReqStartupTimeStatisticForSWVersion* state ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISpmSVP( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SPMSVP__ */
