/*****************************************************************************************
*
* \file    dia_ISessionListener.h
*
* \brief   listener of dia_ISessionListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISession.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SESSION__
#include "dia_ISession.h"
#endif

#define IID_SESSION_LISTENER ((dia::IID) 0x60883b85)
/**
 *
 *  \class dia_ISessionListener
 *
 */

class dia_ISessionListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SESSION_LISTENER; }
public:
   //! method called when the session is changed
   virtual void vOnSessionChanged (tU8 newSession, tU8 oldSession ) = 0;
   //! method called when a session's internal state has changed
   virtual void vOnSessionEvent (tU8 sessionID, OSAL_tEventMask mask ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISessionListener( void ) {}
};
/**
 *
 *  \class dia_ISessionListenerImpl
 *
 */

class dia_ISessionListenerImpl
   : public dia_ISessionListener
{
public:
   //! method called when the session is changed
   virtual void vOnSessionChanged (tU8 /*newSession*/, tU8 /*oldSession*/ ) {}
   //! method called when a session's internal state has changed
   virtual void vOnSessionEvent (tU8 /*sessionID*/, OSAL_tEventMask /*mask*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISessionListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ISessionNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISessionNotifier
   : public dia_ISessionListener,
     public dia_Notifier<dia_ISessionListener>
{
public:
   //! method called when the session is changed
   virtual void vOnSessionChanged (tU8 newSession, tU8 oldSession)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSessionChanged(newSession, oldSession);
      }
   }
   //! method called when a session's internal state has changed
   virtual void vOnSessionEvent (tU8 sessionID, OSAL_tEventMask mask)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSessionEvent(sessionID, mask);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__ */
