/*****************************************************************************************
*
* \file    dia_ISensorListener.h
*
* \brief   listener of dia_ISensorListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISensor.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SENSOR_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SENSOR_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SENSOR__
#include "dia_ISensor.h"
#endif

#define IID_SENSOR_LISTENER ((dia::IID) 0x8dffc1db)
/**
 *
 *  \class dia_ISensorListener
 *
 */

class dia_ISensorListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SENSOR_LISTENER; }
public:
   //! result of the getSensorSpeed operation
   virtual void vOnSensorSpeed (tU16 speed ) = 0;
   //! result of the getOdometerCount operation
   virtual void vOnGalaCounter (tU16 galaCounter ) = 0;
   //! one of the results of the bGetSensor3dGyroValue operation
   virtual void vOnGyro3DGetResult (const tU32 u32rAxis, const tU32 u32sAxis, const tU32 u32tAxis ) = 0;
   //! one of the results of the bGetSensor3dGyroValue operation
   virtual void vOnGyro3DStatus (dia_eGyroStatus rStatus, dia_eGyroStatus sStatus, dia_eGyroStatus tStatus ) = 0;
   //! negative result of the bGetSensor3dGyroValue operation
   virtual void vOnGyro3DGetError (const tU32 errCode ) = 0;
   //! result of the bGetSensor3dAccValue operation
   virtual void vOnAccelerometer3DGetResult (const tU32 u32rAxis, const tU32 u32sAxis, const tU32 u32tAxis ) = 0;
   //! one of the results of the bGetSensor3dAccValue operation
   virtual void vOnAccelerometer3DStatus (dia_eAccStatus rStatus, dia_eAccStatus sStatus, dia_eAccStatus tStatus ) = 0;
   //! negative result of the bGetSensor3dAccValue operation
   virtual void vOnAccelerometer3DGetError (const tU32 errCode ) = 0;
   //! result of the vGyroSelfTest operation
   virtual void vOnGyroSelfTestDone (tDiaResult result ) = 0;
   //! result of the vAccSelfTest operation
   virtual void vOnAccSelfTestDone (tDiaResult result ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISensorListener( void ) {}
};
/**
 *
 *  \class dia_ISensorListenerImpl
 *
 */

class dia_ISensorListenerImpl
   : public dia_ISensorListener
{
public:
   //! result of the getSensorSpeed operation
   virtual void vOnSensorSpeed (tU16 /*speed*/ ) {}
   //! result of the getOdometerCount operation
   virtual void vOnGalaCounter (tU16 /*galaCounter*/ ) {}
   //! one of the results of the bGetSensor3dGyroValue operation
   virtual void vOnGyro3DGetResult (const tU32 /*u32rAxis*/, const tU32 /*u32sAxis*/, const tU32 /*u32tAxis*/ ) {}
   //! one of the results of the bGetSensor3dGyroValue operation
   virtual void vOnGyro3DStatus (dia_eGyroStatus /*rStatus*/, dia_eGyroStatus /*sStatus*/, dia_eGyroStatus /*tStatus*/ ) {}
   //! negative result of the bGetSensor3dGyroValue operation
   virtual void vOnGyro3DGetError (const tU32 /*errCode*/ ) {}
   //! result of the bGetSensor3dAccValue operation
   virtual void vOnAccelerometer3DGetResult (const tU32 /*u32rAxis*/, const tU32 /*u32sAxis*/, const tU32 /*u32tAxis*/ ) {}
   //! one of the results of the bGetSensor3dAccValue operation
   virtual void vOnAccelerometer3DStatus (dia_eAccStatus /*rStatus*/, dia_eAccStatus /*sStatus*/, dia_eAccStatus /*tStatus*/ ) {}
   //! negative result of the bGetSensor3dAccValue operation
   virtual void vOnAccelerometer3DGetError (const tU32 /*errCode*/ ) {}
   //! result of the vGyroSelfTest operation
   virtual void vOnGyroSelfTestDone (tDiaResult /*result*/ ) {}
   //! result of the vAccSelfTest operation
   virtual void vOnAccSelfTestDone (tDiaResult /*result*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISensorListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ISensorNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISensorNotifier
   : public dia_ISensorListener,
     public dia_Notifier<dia_ISensorListener>
{
public:
   //! result of the getSensorSpeed operation
   virtual void vOnSensorSpeed (tU16 speed)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSensorSpeed(speed);
      }
   }
   //! result of the getOdometerCount operation
   virtual void vOnGalaCounter (tU16 galaCounter)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGalaCounter(galaCounter);
      }
   }
   //! one of the results of the bGetSensor3dGyroValue operation
   virtual void vOnGyro3DGetResult (const tU32 u32rAxis, const tU32 u32sAxis, const tU32 u32tAxis)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGyro3DGetResult(u32rAxis, u32sAxis, u32tAxis);
      }
   }
   //! one of the results of the bGetSensor3dGyroValue operation
   virtual void vOnGyro3DStatus (dia_eGyroStatus rStatus, dia_eGyroStatus sStatus, dia_eGyroStatus tStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGyro3DStatus(rStatus, sStatus, tStatus);
      }
   }
   //! negative result of the bGetSensor3dGyroValue operation
   virtual void vOnGyro3DGetError (const tU32 errCode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGyro3DGetError(errCode);
      }
   }
   //! result of the bGetSensor3dAccValue operation
   virtual void vOnAccelerometer3DGetResult (const tU32 u32rAxis, const tU32 u32sAxis, const tU32 u32tAxis)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAccelerometer3DGetResult(u32rAxis, u32sAxis, u32tAxis);
      }
   }
   //! one of the results of the bGetSensor3dAccValue operation
   virtual void vOnAccelerometer3DStatus (dia_eAccStatus rStatus, dia_eAccStatus sStatus, dia_eAccStatus tStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAccelerometer3DStatus(rStatus, sStatus, tStatus);
      }
   }
   //! negative result of the bGetSensor3dAccValue operation
   virtual void vOnAccelerometer3DGetError (const tU32 errCode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAccelerometer3DGetError(errCode);
      }
   }
   //! result of the vGyroSelfTest operation
   virtual void vOnGyroSelfTestDone (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGyroSelfTestDone(result);
      }
   }
   //! result of the vAccSelfTest operation
   virtual void vOnAccSelfTestDone (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAccSelfTestDone(result);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SENSOR_LISTENER__ */
