/*****************************************************************************************
*
* \file    dia_ISelftestControllerListener.h
*
* \brief   listener of dia_ISelftestControllerListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author wgl2hi, kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISelftestController.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SELFTEST_CONTROLLER_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SELFTEST_CONTROLLER_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SELFTEST_CONTROLLER__
#include "dia_ISelftestController.h"
#endif

#define IID_SELFTESTCONTROLLER_LISTENER ((dia::IID) 0x1afbac0f)
/**
 *
 *  \class dia_ISelftestControllerListener
 *
 */

class dia_ISelftestControllerListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SELFTESTCONTROLLER_LISTENER; }
public:
   //! Response at call startSelfTests or at requestSelfTestStatusIfInProgress in case of success. The selftest has been finished with the given result.
   virtual void vOnSelfTestResult (dia_eSelftestControllerResultType eResult ) = 0;
   //! Response at call startSelfTests or at requestSelfTestStatusIfInProgress in case of failure.
   virtual void vOnSelfTestError (tU32 errorCode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISelftestControllerListener( void ) {}
};
/**
 *
 *  \class dia_ISelftestControllerListenerImpl
 *
 */

class dia_ISelftestControllerListenerImpl
   : public dia_ISelftestControllerListener
{
public:
   //! Response at call startSelfTests or at requestSelfTestStatusIfInProgress in case of success. The selftest has been finished with the given result.
   virtual void vOnSelfTestResult (dia_eSelftestControllerResultType /*eResult*/ ) {}
   //! Response at call startSelfTests or at requestSelfTestStatusIfInProgress in case of failure.
   virtual void vOnSelfTestError (tU32 /*errorCode*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISelftestControllerListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ISelftestControllerNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISelftestControllerNotifier
   : public dia_ISelftestControllerListener,
     public dia_Notifier<dia_ISelftestControllerListener>
{
public:
   //! Response at call startSelfTests or at requestSelfTestStatusIfInProgress in case of success. The selftest has been finished with the given result.
   virtual void vOnSelfTestResult (dia_eSelftestControllerResultType eResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSelfTestResult(eResult);
      }
   }
   //! Response at call startSelfTests or at requestSelfTestStatusIfInProgress in case of failure.
   virtual void vOnSelfTestError (tU32 errorCode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSelfTestError(errorCode);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SELFTEST_CONTROLLER_LISTENER__ */
