/*****************************************************************************************
*
* \file    dia_ISecurityListener.h
*
* \brief   listener of dia_ISecurityListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author wgl2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISecurity.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SECURITY_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SECURITY_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SECURITY__
#include "dia_ISecurity.h"
#endif

#include "common/framework/security/dia_SecurityLevel.h"
#define IID_SECURITY_LISTENER ((dia::IID) 0xc0457179)
/**
 *
 *  \class dia_ISecurityListener
 *
 */

class dia_ISecurityListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SECURITY_LISTENER; }
public:
   //! overloaded method from dia_IServiceListener
   virtual void vOnSecurityLevelChange (const dia_SecurityLevel& secLevel, dia_eSecurityLevelStatus newStatus, dia_eSecurityLevelStatus oldStatus ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISecurityListener( void ) {}
};
/**
 *
 *  \class dia_ISecurityListenerImpl
 *
 */

class dia_ISecurityListenerImpl
   : public dia_ISecurityListener
{
public:
   //! overloaded method from dia_IServiceListener
   virtual void vOnSecurityLevelChange (const dia_SecurityLevel& /*secLevel*/, dia_eSecurityLevelStatus /*newStatus*/, dia_eSecurityLevelStatus /*oldStatus*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISecurityListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ISecurityNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISecurityNotifier
   : public dia_ISecurityListener,
     public dia_Notifier<dia_ISecurityListener>
{
public:
   //! overloaded method from dia_IServiceListener
   virtual void vOnSecurityLevelChange (const dia_SecurityLevel& secLevel, dia_eSecurityLevelStatus newStatus, dia_eSecurityLevelStatus oldStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSecurityLevelChange(secLevel, newStatus, oldStatus);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SECURITY_LISTENER__ */
