/*****************************************************************************************
*
* \file    ISCC.h
*
* \brief   interface of ISCC
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISCC.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SCC__
#define __INCLUDED_DIA_INTERFACE_SCC__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_SCC ((dia::IID) 0x7c868127)
namespace dia {
//------------------------------------------------------------------------------
enum enSccComponentStatus
{
   DIA_EN_SCC_COMP_STATUS_UNKNOWN = 0,
   DIA_EN_SCC_COMP_STATUS_ACTIVE,
   DIA_EN_SCC_COMP_STATUS_INACTIVE,
   DIA_EN_SCC_COMP_STATUS_COUNT = 3
};
class ISCC
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SCC; }
public:
   //! received notification about the current component status
   virtual tDiaResult sendComponentStatusToSCC (enSccComponentStatus status ) = 0;
   //! send ACK to SCC that the diagnosis request sent by SCC was received
   virtual tDiaResult sendDiagnosisRequestAckToSCC (tU8 channelID ) = 0;

protected:
   //! virtual base class destructor
   virtual ~ISCC( void ) {}
};
} /* namespace dia */


#endif /* __INCLUDED_DIA_INTERFACE_SCC__ */
