/*****************************************************************************************
*
* \file    dia_IRemoteControlListener.h
*
* \brief   listener of dia_IRemoteControlListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IRemoteControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_REMOTE_CONTROL_LISTENER__
#define __INCLUDED_DIA_INTERFACE_REMOTE_CONTROL_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_REMOTE_CONTROL__
#include "dia_IRemoteControl.h"
#endif

#define IID_REMOTE_CONTROL_LISTENER ((dia::IID) 0xe4116cee)
/**
 *
 *  \class dia_IRemoteControlListener
 *
 */

class dia_IRemoteControlListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_REMOTE_CONTROL_LISTENER; }
public:
   //! remote control mode has been changed to the given mode
   virtual void vOnRemoteControlModeChanged (dia_eRemoteCtrlMode newMode, dia_eRemoteCtrlMode prevMode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IRemoteControlListener( void ) {}
};
/**
 *
 *  \class dia_IRemoteControlListenerImpl
 *
 */

class dia_IRemoteControlListenerImpl
   : public dia_IRemoteControlListener
{
public:
   //! remote control mode has been changed to the given mode
   virtual void vOnRemoteControlModeChanged (dia_eRemoteCtrlMode /*newMode*/, dia_eRemoteCtrlMode /*prevMode*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IRemoteControlListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IRemoteControlNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IRemoteControlNotifier
   : public dia_IRemoteControlListener,
     public dia_Notifier<dia_IRemoteControlListener>
{
public:
   //! remote control mode has been changed to the given mode
   virtual void vOnRemoteControlModeChanged (dia_eRemoteCtrlMode newMode, dia_eRemoteCtrlMode prevMode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRemoteControlModeChanged(newMode, prevMode);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_REMOTE_CONTROL_LISTENER__ */
