/*****************************************************************************************
*
* \file    dia_IRemoteControl.h
*
* \brief   interface of dia_IRemoteControl
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IRemoteControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_REMOTE_CONTROL__
#define __INCLUDED_DIA_INTERFACE_REMOTE_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
typedef tU32 dia_RemoteControlSettings;
#define DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT ((tU32) 0x00000000)
#define DIA_C_U32_REMOTE_CTRL_SETTINGS_NO_HMI ((tU32) 0x00000001)
#define IID_REMOTE_CONTROL ((dia::IID) 0x2bf1a888)
//------------------------------------------------------------------------------
enum dia_eRemoteCtrlMode
{
   DIA_EN_REMOTE_CONTROL_MODE_UNKNOWN = 0,
   DIA_EN_REMOTE_CONTROL_MODE_ACTIVE,
   DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE,
   DIA_EN_REMOTE_CONTROL_MODE_COUNT = 3
};
class dia_IRemoteControl
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_REMOTE_CONTROL; }
public:
   //! activate the remote control of the ECU
   virtual tDiaResult setRemoteControlMode (dia_eRemoteCtrlMode mode, dia_RemoteControlSettings settings = DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT ) = 0;
   //! retrieve the current remote control state
   virtual dia_eRemoteCtrlMode getRemoteControlMode ( ) = 0;
   //! retrieve the current settings of remote control
   virtual dia_RemoteControlSettings getRemoteControlSettings ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IRemoteControl( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_REMOTE_CONTROL__ */
