/*****************************************************************************************
*
* \file    dia_IRVCListener.h
*
* \brief   listener of dia_IRVCListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IRVC.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_RVC_LISTENER__
#define __INCLUDED_DIA_INTERFACE_RVC_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_RVC__
#include "dia_IRVC.h"
#endif

#define IID_RVC_LISTENER ((dia::IID) 0xb2866c2c)
/**
 *
 *  \class dia_IRVCListener
 *
 */

class dia_IRVCListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_RVC_LISTENER; }
public:
   //! Actual power supply status of RVC
   virtual void vOnRVCPowerSupplyStatus (dia_eRVC_pwrSupplyStatus rvcPwrSuppyStatus ) = 0;
   //! Actual current of RVC power supply
   virtual void vOnRVCPowerSupplyCurrent (tU32 rvcCurrent ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IRVCListener( void ) {}
};
/**
 *
 *  \class dia_IRVCListenerImpl
 *
 */

class dia_IRVCListenerImpl
   : public dia_IRVCListener
{
public:
   //! Actual power supply status of RVC
   virtual void vOnRVCPowerSupplyStatus (dia_eRVC_pwrSupplyStatus /*rvcPwrSuppyStatus*/ ) {}
   //! Actual current of RVC power supply
   virtual void vOnRVCPowerSupplyCurrent (tU32 /*rvcCurrent*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IRVCListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IRVCNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IRVCNotifier
   : public dia_IRVCListener,
     public dia_Notifier<dia_IRVCListener>
{
public:
   //! Actual power supply status of RVC
   virtual void vOnRVCPowerSupplyStatus (dia_eRVC_pwrSupplyStatus rvcPwrSuppyStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRVCPowerSupplyStatus(rvcPwrSuppyStatus);
      }
   }
   //! Actual current of RVC power supply
   virtual void vOnRVCPowerSupplyCurrent (tU32 rvcCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRVCPowerSupplyCurrent(rvcCurrent);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_RVC_LISTENER__ */
