/*****************************************************************************************
*
* \file    dia_IMicrophoneListener.h
*
* \brief   listener of dia_IMicrophoneListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IMicrophone.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_MICROPHONE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_MICROPHONE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_MICROPHONE__
#include "dia_IMicrophone.h"
#endif

#define IID_SYSADAPTER_MICROPHONE_LISTENER ((dia::IID) 0x39078655)
/**
 *
 *  \class dia_IMicrophoneListener
 *
 */

class dia_IMicrophoneListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSADAPTER_MICROPHONE_LISTENER; }
public:
   /**
    * THIS METHOD IS DEPREACTED. PLEASE USE vOnMicrophoneConnectionInfo instead of vOnMicrophoneConnectionStatus.
    * delivers the microphone connection status
   */
   virtual void vOnMicrophoneConnectionStatus (dia_eMicroStatus status, tU16 adcValue ) = 0;
   //! Deliver actual connection status and current for specific microphone
   virtual void vOnMicrophoneConnectionInfo (tU16 micID, const dia_MicrophoneInfo& micInfo ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IMicrophoneListener( void ) {}
};
/**
 *
 *  \class dia_IMicrophoneListenerImpl
 *
 */

class dia_IMicrophoneListenerImpl
   : public dia_IMicrophoneListener
{
public:
   /**
    * THIS METHOD IS DEPREACTED. PLEASE USE vOnMicrophoneConnectionInfo instead of vOnMicrophoneConnectionStatus.
    * delivers the microphone connection status
   */
   virtual void vOnMicrophoneConnectionStatus (dia_eMicroStatus /*status*/, tU16 /*adcValue*/ ) {}
   //! Deliver actual connection status and current for specific microphone
   virtual void vOnMicrophoneConnectionInfo (tU16 /*micID*/, const dia_MicrophoneInfo& /*micInfo*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IMicrophoneListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IMicrophoneNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IMicrophoneNotifier
   : public dia_IMicrophoneListener,
     public dia_Notifier<dia_IMicrophoneListener>
{
public:
   /**
    * THIS METHOD IS DEPREACTED. PLEASE USE vOnMicrophoneConnectionInfo instead of vOnMicrophoneConnectionStatus.
    * delivers the microphone connection status
   */
   virtual void vOnMicrophoneConnectionStatus (dia_eMicroStatus status, tU16 adcValue)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnMicrophoneConnectionStatus(status, adcValue);
      }
   }
   //! Deliver actual connection status and current for specific microphone
   virtual void vOnMicrophoneConnectionInfo (tU16 micID, const dia_MicrophoneInfo& micInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnMicrophoneConnectionInfo(micID, micInfo);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_MICROPHONE_LISTENER__ */
