/*****************************************************************************************
*
* \file    dia_IMicrophone.h
*
* \brief   interface of dia_IMicrophone
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IMicrophone.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_MICROPHONE__
#define __INCLUDED_DIA_INTERFACE_MICROPHONE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_SYSADAPTER_MICROPHONE ((dia::IID) 0xa1544aef)
//------------------------------------------------------------------------------
/**
 * DEPRECATED TYPE. PLEASE USE dia_eMicrophoneConnectionStatus INSTEAD.
   */
enum dia_eMicroStatus
{
   DIA_EN_MICRO_CONNECTION_UNKNOWN = 0,
   DIA_EN_MICRO_CONNECTION_OPEN,
   DIA_EN_MICRO_CONNECTION_SHORT,
   DIA_EN_MICRO_CONNECTION_OK,
   DIA_EN_MICRO_CONNECTION_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eMicrophoneConnectionStatus
{
   DIA_EN_MICROPHONE_CONNECTION_STATUS_UNKNOWN = 0,
   DIA_EN_MICROPHONE_CONNECTION_STATUS_OK,
   DIA_EN_MICROPHONE_CONNECTION_STATUS_OPEN_LOAD,
   DIA_EN_MICROPHONE_CONNECTION_STATUS_SHORT_CIRCUIT,
   DIA_EN_MICROPHONE_CONNECTION_STATUS_SHORT_CIRCUIT_ACROSS,
   DIA_EN_MICROPHONE_CONNECTION_STATUS_SHORT_CIRCUIT_BATTERY,
   DIA_EN_MICROPHONE_CONNECTION_STATUS_SHORT_CIRCUIT_GROUND,
   DIA_EN_MICROPHONE_CONNECTION_STATUS_COUNT = 7
};
struct dia_MicrophoneInfo
{
public:
   //! default constructor
   dia_MicrophoneInfo() :
      mConnectionStatus(DIA_EN_MICROPHONE_CONNECTION_STATUS_UNKNOWN),
      mCurrent(0)
   {}

   //! class constructor
   dia_MicrophoneInfo(
      dia_eMicrophoneConnectionStatus mConnectionStatus_,
      tU16 mCurrent_
   ) :
      mConnectionStatus(mConnectionStatus_),
      mCurrent(mCurrent_)
   {}
   dia_eMicrophoneConnectionStatus mConnectionStatus;
   tU16 mCurrent;
};
class dia_IMicrophone
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSADAPTER_MICROPHONE; }
public:
   //! request the microphone connection information for specific microphone
   virtual tDiaResult getMicrophoneConnectionInfo (tU16 micID ) = 0;
   //! THIS METHOD IS DEPREACTED. PLEASE USE getMicrophoneConnectionInfo instead of getMicrophoneConnectionStatus.
   virtual tDiaResult getMicrophoneConnectionStatus ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IMicrophone( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_MICROPHONE__ */
