/*****************************************************************************************
*
* \file    dia_IMediaAudioCdListener.h
*
* \brief   listener of dia_IMediaAudioCdListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IMediaAudioCd.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_MEDIA_AUDIO_LISTENER__
#define __INCLUDED_DIA_INTERFACE_MEDIA_AUDIO_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_MEDIA_AUDIO_CD__
#include "dia_IMediaAudioCd.h"
#endif

#define IID_SYSADAPTER_MEDIA_AUDIO_CD_LISTENER ((dia::IID) 0x388c02ba)
/**
 *
 *  \class dia_IMediaAudioCdListener
 *
 */

class dia_IMediaAudioCdListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSADAPTER_MEDIA_AUDIO_CD_LISTENER; }
public:
   /**
    * Signal to inform requester about success of the track change request
    * \param tDiaResult DIA_SUCCESS or DIA_FAILED depending on whether track change was done
   */
   virtual void vOnTrackChangeResult (tDiaResult result ) = 0;
   /**
    * Signal to inform requester about the current track number
    * \param  tU16 Current track number
   */
   virtual void vOnTrackNumber (tU16 playedTrack ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IMediaAudioCdListener( void ) {}
};
/**
 *
 *  \class dia_IMediaAudioCdListenerImpl
 *
 */

class dia_IMediaAudioCdListenerImpl
   : public dia_IMediaAudioCdListener
{
public:
   /**
    * Signal to inform requester about success of the track change request
    * \param tDiaResult DIA_SUCCESS or DIA_FAILED depending on whether track change was done
   */
   virtual void vOnTrackChangeResult (tDiaResult /*result*/ ) {}
   /**
    * Signal to inform requester about the current track number
    * \param  tU16 Current track number
   */
   virtual void vOnTrackNumber (tU16 /*playedTrack*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IMediaAudioCdListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IMediaAudioCdNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IMediaAudioCdNotifier
   : public dia_IMediaAudioCdListener,
     public dia_Notifier<dia_IMediaAudioCdListener>
{
public:
   /**
    * Signal to inform requester about success of the track change request
    * \param tDiaResult DIA_SUCCESS or DIA_FAILED depending on whether track change was done
   */
   virtual void vOnTrackChangeResult (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTrackChangeResult(result);
      }
   }
   /**
    * Signal to inform requester about the current track number
    * \param  tU16 Current track number
   */
   virtual void vOnTrackNumber (tU16 playedTrack)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTrackNumber(playedTrack);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_MEDIA_AUDIO_LISTENER__ */
