/*****************************************************************************************
*
* \file    dia_IInputHandlingListener.h
*
* \brief   listener of dia_IInputHandlingListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author wgl2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IInputHandling.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_INPUT_HANDLING_LISTENER__
#define __INCLUDED_DIA_INTERFACE_INPUT_HANDLING_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_INPUT_HANDLING__
#include "dia_IInputHandling.h"
#endif

#define IID_INPUT_HANDLING_LISTENER ((dia::IID) 0xc81e2856)
/**
 *
 *  \class dia_IInputHandlingListener
 *
 */

class dia_IInputHandlingListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_INPUT_HANDLING_LISTENER; }
public:
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey (const std::vector<tU8> pressedKeys ) = 0;
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey (const std::vector<dia_tPressedKey> pressedKeys ) = 0;
   //! reply on getting/setting encoder status
   virtual void vOnEncoderStatus (const std::vector<tU8> vecEncoderStatus ) = 0;
   //! reply on getting/setting encoder direction status
   virtual void vOnEncoderDirStatus (tS8 vecEncoderStatus ) = 0;
   //! reply on the status of touch screen
   virtual void vOnTouchInfo (const tU16 u16X, const tU16 u16Y, const tU16 u16DeltaX, const tU16 u16DeltaY, const dia_eInputHandlingTouchInfo eTouchInfo ) = 0;
   //! reply on simulating key press or key release on the operating unit
   virtual void vOnSetKey (const tDiaResult eDiaResult ) = 0;
   //! reply on locking the operating unit
   virtual void vOnLockControlUnit (const tDiaResult eDiaResult ) = 0;
   //! reply on starting the touch panel calibration
   virtual void vOnTouchPanelAlignmentDone (const tDiaResult eDiaResult ) = 0;
   //! reply on starting the input event simulation (requirement from VD_Input)
   virtual void vOnEnableInputEvents (const tBool bSimulationStatus ) = 0;
   //! Error handling function in pressed key simulation
   virtual void vOnGetPressedKeyError ( ) = 0;
   //! Error handling function for touch panel status
   virtual void vOnTouchInfoError ( ) = 0;
   //! reply on simulating touch press or release on HMI screen
   virtual void vOnSetTouch (const tDiaResult eDiaResult ) = 0;
   //! reply on simulating touch slide on HMI screen
   virtual void vOnSetTouchSlide (const tDiaResult eDiaResult ) = 0;
   //! reply on recording the gesture in file system
   virtual void vOnRecordGesture (const tDiaResult eDiaResult ) = 0;
   //! reply on replaying the gesture saved in file system
   virtual void vOnReplayGesture (const tDiaResult eDiaResult ) = 0;
   //! reply on status of touch screen : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnTouchInfohistory (const std::vector<dia_tTouchPressHistoryInfo> vecTouchPressInfo ) = 0;
   //! reply on Encoder Dir history : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnEncoderDirHistory (const std::vector<dia_tEncoderDirHistoryInfo> vecEncoderDirInfo ) = 0;
   //! reply on getting/setting encoder status
   virtual void vOnSetEncoder (const tDiaResult eDiaResult ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IInputHandlingListener( void ) {}
};
/**
 *
 *  \class dia_IInputHandlingListenerImpl
 *
 */

class dia_IInputHandlingListenerImpl
   : public dia_IInputHandlingListener
{
public:
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey (const std::vector<tU8> /*pressedKeys*/ ) {}
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey (const std::vector<dia_tPressedKey> /*pressedKeys*/ ) {}
   //! reply on getting/setting encoder status
   virtual void vOnEncoderStatus (const std::vector<tU8> /*vecEncoderStatus*/ ) {}
   //! reply on getting/setting encoder direction status
   virtual void vOnEncoderDirStatus (tS8 /*vecEncoderStatus*/ ) {}
   //! reply on the status of touch screen
   virtual void vOnTouchInfo (const tU16 /*u16X*/, const tU16 /*u16Y*/, const tU16 /*u16DeltaX*/, const tU16 /*u16DeltaY*/, const dia_eInputHandlingTouchInfo /*eTouchInfo*/ ) {}
   //! reply on simulating key press or key release on the operating unit
   virtual void vOnSetKey (const tDiaResult /*eDiaResult*/ ) {}
   //! reply on locking the operating unit
   virtual void vOnLockControlUnit (const tDiaResult /*eDiaResult*/ ) {}
   //! reply on starting the touch panel calibration
   virtual void vOnTouchPanelAlignmentDone (const tDiaResult /*eDiaResult*/ ) {}
   //! reply on starting the input event simulation (requirement from VD_Input)
   virtual void vOnEnableInputEvents (const tBool /*bSimulationStatus*/ ) {}
   //! Error handling function in pressed key simulation
   virtual void vOnGetPressedKeyError ( ) {}
   //! Error handling function for touch panel status
   virtual void vOnTouchInfoError ( ) {}
   //! reply on simulating touch press or release on HMI screen
   virtual void vOnSetTouch (const tDiaResult /*eDiaResult*/ ) {}
   //! reply on simulating touch slide on HMI screen
   virtual void vOnSetTouchSlide (const tDiaResult /*eDiaResult*/ ) {}
   //! reply on recording the gesture in file system
   virtual void vOnRecordGesture (const tDiaResult /*eDiaResult*/ ) {}
   //! reply on replaying the gesture saved in file system
   virtual void vOnReplayGesture (const tDiaResult /*eDiaResult*/ ) {}
   //! reply on status of touch screen : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnTouchInfohistory (const std::vector<dia_tTouchPressHistoryInfo> /*vecTouchPressInfo*/ ) {}
   //! reply on Encoder Dir history : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnEncoderDirHistory (const std::vector<dia_tEncoderDirHistoryInfo> /*vecEncoderDirInfo*/ ) {}
   //! reply on getting/setting encoder status
   virtual void vOnSetEncoder (const tDiaResult /*eDiaResult*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IInputHandlingListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IInputHandlingNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IInputHandlingNotifier
   : public dia_IInputHandlingListener,
     public dia_Notifier<dia_IInputHandlingListener>
{
public:
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey (const std::vector<tU8> pressedKeys)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetPressedKey(pressedKeys);
      }
   }
   //! reply on getting last pressed key
   virtual void vOnGetPressedKey (const std::vector<dia_tPressedKey> pressedKeys)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetPressedKey(pressedKeys);
      }
   }
   //! reply on getting/setting encoder status
   virtual void vOnEncoderStatus (const std::vector<tU8> vecEncoderStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnEncoderStatus(vecEncoderStatus);
      }
   }
   //! reply on getting/setting encoder direction status
   virtual void vOnEncoderDirStatus (tS8 vecEncoderStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnEncoderDirStatus(vecEncoderStatus);
      }
   }
   //! reply on the status of touch screen
   virtual void vOnTouchInfo (const tU16 u16X, const tU16 u16Y, const tU16 u16DeltaX, const tU16 u16DeltaY, const dia_eInputHandlingTouchInfo eTouchInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTouchInfo(u16X, u16Y, u16DeltaX, u16DeltaY, eTouchInfo);
      }
   }
   //! reply on simulating key press or key release on the operating unit
   virtual void vOnSetKey (const tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSetKey(eDiaResult);
      }
   }
   //! reply on locking the operating unit
   virtual void vOnLockControlUnit (const tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnLockControlUnit(eDiaResult);
      }
   }
   //! reply on starting the touch panel calibration
   virtual void vOnTouchPanelAlignmentDone (const tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTouchPanelAlignmentDone(eDiaResult);
      }
   }
   //! reply on starting the input event simulation (requirement from VD_Input)
   virtual void vOnEnableInputEvents (const tBool bSimulationStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnEnableInputEvents(bSimulationStatus);
      }
   }
   //! Error handling function in pressed key simulation
   virtual void vOnGetPressedKeyError ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetPressedKeyError();
      }
   }
   //! Error handling function for touch panel status
   virtual void vOnTouchInfoError ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTouchInfoError();
      }
   }
   //! reply on simulating touch press or release on HMI screen
   virtual void vOnSetTouch (const tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSetTouch(eDiaResult);
      }
   }
   //! reply on simulating touch slide on HMI screen
   virtual void vOnSetTouchSlide (const tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSetTouchSlide(eDiaResult);
      }
   }
   //! reply on recording the gesture in file system
   virtual void vOnRecordGesture (const tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRecordGesture(eDiaResult);
      }
   }
   //! reply on replaying the gesture saved in file system
   virtual void vOnReplayGesture (const tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnReplayGesture(eDiaResult);
      }
   }
   //! reply on status of touch screen : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnTouchInfohistory (const std::vector<dia_tTouchPressHistoryInfo> vecTouchPressInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTouchInfohistory(vecTouchPressInfo);
      }
   }
   //! reply on Encoder Dir history : implemented to recieve a list of operations for Monitoring and Calibration feature.
   virtual void vOnEncoderDirHistory (const std::vector<dia_tEncoderDirHistoryInfo> vecEncoderDirInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnEncoderDirHistory(vecEncoderDirInfo);
      }
   }
   //! reply on getting/setting encoder status
   virtual void vOnSetEncoder (const tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSetEncoder(eDiaResult);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_INPUT_HANDLING_LISTENER__ */
