/*****************************************************************************************
*
* \file    dia_IHeatControlListener.h
*
* \brief   listener of dia_IHeatControlListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author gib2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IHeatControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_HEAT_CONTROL_LISTENER__
#define __INCLUDED_DIA_INTERFACE_HEAT_CONTROL_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_HEAT_CONTROL__
#include "dia_IHeatControl.h"
#endif

#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
#include "common/framework/application/dia_stl.h"
#define IID_HEAT_CONTROL_LISTENER ((dia::IID) 0xac6ae604)
/**
 *
 *  \class dia_IHeatControlListener
 *
 */

class dia_IHeatControlListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_HEAT_CONTROL_LISTENER; }
public:
   //! list of available temperatures
   virtual void vOnTemperatureInfo (std::list<dia_tHeatCtrlTemperature>& tempList ) = 0;
   //! list of available sensor states
   virtual void vOnSensorStateInfo (std::list<dia_tHeatCtrlSensorState>& stateList ) = 0;
   //! ID and states of emergency function
   virtual void vOnEmergencyFunc (std::list<dia_tHeatCtrlEmergencyFunc>& funcList ) = 0;
   //! speed of the specified fan
   virtual void vOnFanSpeed (dia_eHeatCtrlFanID fanID, tU16 fanSpeed, tBool bSensorOverride ) = 0;
   //! Set speed of the specified fan
   virtual void vOnFanSpeedSet (tDiaResult success ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IHeatControlListener( void ) {}
};
/**
 *
 *  \class dia_IHeatControlListenerImpl
 *
 */

class dia_IHeatControlListenerImpl
   : public dia_IHeatControlListener
{
public:
   //! list of available temperatures
   virtual void vOnTemperatureInfo (std::list<dia_tHeatCtrlTemperature>& /*tempList*/ ) {}
   //! list of available sensor states
   virtual void vOnSensorStateInfo (std::list<dia_tHeatCtrlSensorState>& /*stateList*/ ) {}
   //! ID and states of emergency function
   virtual void vOnEmergencyFunc (std::list<dia_tHeatCtrlEmergencyFunc>& /*funcList*/ ) {}
   //! speed of the specified fan
   virtual void vOnFanSpeed (dia_eHeatCtrlFanID /*fanID*/, tU16 /*fanSpeed*/, tBool /*bSensorOverride*/ ) {}
   //! Set speed of the specified fan
   virtual void vOnFanSpeedSet (tDiaResult /*success*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IHeatControlListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IHeatControlNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IHeatControlNotifier
   : public dia_IHeatControlListener,
     public dia_Notifier<dia_IHeatControlListener>
{
public:
   //! list of available temperatures
   virtual void vOnTemperatureInfo (std::list<dia_tHeatCtrlTemperature>& tempList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTemperatureInfo(tempList);
      }
   }
   //! list of available sensor states
   virtual void vOnSensorStateInfo (std::list<dia_tHeatCtrlSensorState>& stateList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSensorStateInfo(stateList);
      }
   }
   //! ID and states of emergency function
   virtual void vOnEmergencyFunc (std::list<dia_tHeatCtrlEmergencyFunc>& funcList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnEmergencyFunc(funcList);
      }
   }
   //! speed of the specified fan
   virtual void vOnFanSpeed (dia_eHeatCtrlFanID fanID, tU16 fanSpeed, tBool bSensorOverride)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnFanSpeed(fanID, fanSpeed, bSensorOverride);
      }
   }
   //! Set speed of the specified fan
   virtual void vOnFanSpeedSet (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnFanSpeedSet(success);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_HEAT_CONTROL_LISTENER__ */
