/*****************************************************************************************
*
* \file    dia_IHeatControl.h
*
* \brief   interface of dia_IHeatControl
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author gib2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IHeatControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_HEAT_CONTROL__
#define __INCLUDED_DIA_INTERFACE_HEAT_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_HEAT_CONTROL ((dia::IID) 0xd3866b9e)
//------------------------------------------------------------------------------
enum dia_eHeatCtrlTemperatureID
{
   DIA_EN_HEATCTRL_TEMPERATURE_ID_UNKNOWN = 0,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_V850,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PANEL,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_CDDRIVE,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_DVDDRIVE,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_GPS,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_GYRO,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_EMMC,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_AMP,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_IMX,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_HEATSINK,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_AMPLIFIER,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_CPU,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_EXPBOARD,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_BOARD,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_DISPLAY,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_DRIVE,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_SYSTEM,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_MAIN,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_TOP,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_BOTTOM,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_XMMODULE,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_TVMODULE,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_TVMODULESLAVE,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PANEL2,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_01,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_02,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_03,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_04,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_05,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_06,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_07,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_08,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_09,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_PROJECT_10,
   DIA_EN_HEATCTRL_TEMPERATURE_ID_COUNT = 35
};
//------------------------------------------------------------------------------
enum dia_eHeatCtrlTemperatureQuality
{
   DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_UNKNOWN = 0,
   DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_INVALID,
   DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_UNSUPPORTED,
   DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_VALID,
   DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_COUNT = 4
};
//------------------------------------------------------------------------------
/**
 * List at first ID of less critical emergency function
   */
enum dia_eHeatCtrlEmergencyFuncID
{
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_UNKNOWN = 0,
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_CDDRIVEROFF,
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_BACKLIGHTOFF,
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_ATTENUATION,
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_SYSTEMSHUTDOWN,
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eHeatCtrlEmergencyFuncState
{
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_STATE_UNKNOWN = 0,
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_STATE_INACTIVE,
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_STATE_ACTIVE,
   DIA_EN_HEATCTRL_EMERGENCY_FUNC_STATE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eHeatCtrlFuncLevel
{
   DIA_EN_HEATCTRL_FUNC_LEVEL_UNKNOWN = 0,
   DIA_EN_HEATCTRL_FUNC_LEVEL_NORMAL,
   DIA_EN_HEATCTRL_FUNC_LEVEL_LIMITED,
   DIA_EN_HEATCTRL_FUNC_LEVEL_NOTLAUF,
   DIA_EN_HEATCTRL_FUNC_LEVEL_MUTE,
   DIA_EN_HEATCTRL_FUNC_LEVEL_SHOTDOWN,
   DIA_EN_HEATCTRL_FUNC_LEVEL_COUNT = 6
};
//------------------------------------------------------------------------------
enum dia_eHeatCtrlTemperatureClass
{
   DIA_EN_HEATCTRL_TEMPERATURE_CLASS_UNKNOWN = 0,
   DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ALL,
   DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ESTIMATED,
   DIA_EN_HEATCTRL_TEMPERATURE_CLASS_REAL,
   DIA_EN_HEATCTRL_TEMPERATURE_CLASS_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eHeatCtrlFanID
{
   DIA_EN_HEATCTRL_FAN_ID_UNKNOWN = 0,
   DIA_EN_HEATCTRL_FAN_ID_CASE,
   DIA_EN_HEATCTRL_FAN_ID_COUNT = 2
};
//------------------------------------------------------------------------------
enum dia_eFanState
{
   DIA_EN_HEATCTRL_FANPWRSTATE_UNKNOWN = 0,
   DIA_EN_HEATCTRL_FANPWRSTATE_INIT,
   DIA_EN_HEATCTRL_FANPWRSTATE_OFF,
   DIA_EN_HEATCTRL_FANPWRSTATE_ON,
   DIA_EN_HEATCTRL_FANPWRSTATE_UNDEF,
   DIA_EN_HEATCTRL_FANPWRSTATE_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eFanCtrlMode
{
   DIA_EN_FAN_CTRL_MODE_UNKNOWN = 0,
   DIA_EN_FAN_CTRL_MODE_ON,
   DIA_EN_FAN_CTRL_MODE_OFF,
   DIA_EN_FAN_CTRL_MODE_COUNT = 3
};
struct dia_tHeatCtrlTemperature
{
public:
   //! default constructor
   dia_tHeatCtrlTemperature() :
      mID(DIA_EN_HEATCTRL_TEMPERATURE_ID_UNKNOWN),
      mTemperature(0),
      mTemperatureMin(0),
      mTemperatureMax(0),
      mQuality(0),
      mDiaQuality(DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_UNKNOWN)
   {}

   //! class constructor
   dia_tHeatCtrlTemperature(
      dia_eHeatCtrlTemperatureID mID_,
      tS16 mTemperature_,
      tS16 mTemperatureMin_,
      tS16 mTemperatureMax_,
      tU8 mQuality_,
      dia_eHeatCtrlTemperatureQuality mDiaQuality_
   ) :
      mID(mID_),
      mTemperature(mTemperature_),
      mTemperatureMin(mTemperatureMin_),
      mTemperatureMax(mTemperatureMax_),
      mQuality(mQuality_),
      mDiaQuality(mDiaQuality_)
   {}
   dia_eHeatCtrlTemperatureID mID; // identifier for the temperature
   tS16 mTemperature; // concrete temperature value
   tS16 mTemperatureMin; // min. temperature value
   tS16 mTemperatureMax; // max. temperature value
   tU8 mQuality; // quality for this temperature value
   dia_eHeatCtrlTemperatureQuality mDiaQuality; // quality in Dia
};
struct dia_tHeatCtrlSensorState
{
public:
   //! default constructor
   dia_tHeatCtrlSensorState() :
      mID(DIA_EN_HEATCTRL_TEMPERATURE_ID_UNKNOWN),
      mState(0)
   {}

   //! class constructor
   dia_tHeatCtrlSensorState(
      dia_eHeatCtrlTemperatureID mID_,
      tU8 mState_
   ) :
      mID(mID_),
      mState(mState_)
   {}
   dia_eHeatCtrlTemperatureID mID; // identifier for the temperature
   tU8 mState;
};
struct dia_tHeatCtrlEmergencyFunc
{
public:
   //! default constructor
   dia_tHeatCtrlEmergencyFunc() :
      mID(DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_UNKNOWN),
      mState(DIA_EN_HEATCTRL_EMERGENCY_FUNC_STATE_UNKNOWN)
   {}

   //! class constructor
   dia_tHeatCtrlEmergencyFunc(
      dia_eHeatCtrlEmergencyFuncID mID_,
      dia_eHeatCtrlEmergencyFuncState mState_
   ) :
      mID(mID_),
      mState(mState_)
   {}
   dia_eHeatCtrlEmergencyFuncID mID; // identifier for the emergency function
   dia_eHeatCtrlEmergencyFuncState mState; // identifier for the state of the emergency function
};
class dia_IHeatControl
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_HEAT_CONTROL; }
public:
   //! request detailed information about the internal temperatures of the RNS
   virtual tDiaResult getTemperatures (dia_eHeatCtrlTemperatureClass tempClass = DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ALL ) = 0;
   //! request detailed information about the internal state of temperature sensor
   virtual tDiaResult getSensorState (dia_eHeatCtrlTemperatureClass tempClass = DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ALL ) = 0;
   //! request detailed information about the state of emergency functions
   virtual tDiaResult getFuncState ( ) = 0;
   //! set the fan speed of the requested fan
   virtual tDiaResult setFanSpeed (dia_eFanState /*fanState*/, const tU8 /*fanSpeed*/, dia_eFanCtrlMode /*fanEvent*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! Get the fan speed of the requested fan
   virtual tDiaResult getFanSpeed ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IHeatControl( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_HEAT_CONTROL__ */
