/*****************************************************************************************
*
* \file    dia_IGNSSListener.h
*
* \brief   listener of dia_IGNSSListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IGNSS.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#define __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_GNSS__
#include "dia_IGNSS.h"
#endif

#define dia_GNSSNotifier dia_IGNSSNotifier
#define IID_GNSS_LISTENER ((dia::IID) 0x67836d1c)
/**
 *
 *  \class dia_IGNSSListener
 *
 */

class dia_IGNSSListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_GNSS_LISTENER; }
public:
   //! STC2HI: Obsolete, Antennaes will be handled by some kind of Tuner component
   virtual void vOnGNSSAntennaCurrent (tF32 antennaCurrent ) = 0;
   virtual void vOnGNSSAntennaStatus (tU8 status ) = 0;
   virtual void vOnGNSSReceiverStatus (const dia_tGNSSReceiverState& info ) = 0;
   virtual void vOnGPSReceptionLevel (const dia_tGPSReceptionLevel& info ) = 0;
   virtual void vOnGNSSBestSattelites (const std::vector<dia_tGNSSBestSattelletes>& quality ) = 0;
   virtual void vOnGNSSSatellitesSignalQuality (const std::vector<dia_tGNSSSatellitesSignalQuality>& quality ) = 0;
   virtual void vOnGNSSSatSystem (tU8 satSystem ) = 0;
   virtual void vOnDiagGNSSSatSystem (tU8 satSystem ) = 0;
   virtual void vOnGNSSTimeDate (tU16 u16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minutes, tU8 u8Seconds, tU16 u16MSeconds ) = 0;
   virtual void vOnGNSSPosition (tS32 LatitudeMSeconds, tS32 LongitudeMSeconds, tS16 Altitude ) = 0;
   virtual void vOnGNSSRecFirmwareVersion (const tU32 firmwareVersion ) = 0;
   virtual void vOnGNSSRecFrimwareCrc (const tU32 firmwareCrc ) = 0;
   virtual void vOnGNSSVelocity (tS16 s16VelocityNorth, tS16 s16VelocityEast, tS16 s16VelocityUp ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IGNSSListener( void ) {}
};
/**
 *
 *  \class dia_IGNSSListenerImpl
 *
 */

class dia_IGNSSListenerImpl
   : public dia_IGNSSListener
{
public:
   //! STC2HI: Obsolete, Antennaes will be handled by some kind of Tuner component
   virtual void vOnGNSSAntennaCurrent (tF32 /*antennaCurrent*/ ) {}
   virtual void vOnGNSSAntennaStatus (tU8 /*status*/ ) {}
   virtual void vOnGNSSReceiverStatus (const dia_tGNSSReceiverState& /*info*/ ) {}
   virtual void vOnGPSReceptionLevel (const dia_tGPSReceptionLevel& /*info*/ ) {}
   virtual void vOnGNSSBestSattelites (const std::vector<dia_tGNSSBestSattelletes>& /*quality*/ ) {}
   virtual void vOnGNSSSatellitesSignalQuality (const std::vector<dia_tGNSSSatellitesSignalQuality>& /*quality*/ ) {}
   virtual void vOnGNSSSatSystem (tU8 /*satSystem*/ ) {}
   virtual void vOnDiagGNSSSatSystem (tU8 /*satSystem*/ ) {}
   virtual void vOnGNSSTimeDate (tU16 /*u16Year*/, tU8 /*u8Month*/, tU8 /*u8Day*/, tU8 /*u8Hour*/, tU8 /*u8Minutes*/, tU8 /*u8Seconds*/, tU16 /*u16MSeconds*/ ) {}
   virtual void vOnGNSSPosition (tS32 /*LatitudeMSeconds*/, tS32 /*LongitudeMSeconds*/, tS16 /*Altitude*/ ) {}
   virtual void vOnGNSSRecFirmwareVersion (const tU32 /*firmwareVersion*/ ) {}
   virtual void vOnGNSSRecFrimwareCrc (const tU32 /*firmwareCrc*/ ) {}
   virtual void vOnGNSSVelocity (tS16 /*s16VelocityNorth*/, tS16 /*s16VelocityEast*/, tS16 /*s16VelocityUp*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IGNSSListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IGNSSNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IGNSSNotifier
   : public dia_IGNSSListener,
     public dia_Notifier<dia_IGNSSListener>
{
public:
   //! STC2HI: Obsolete, Antennaes will be handled by some kind of Tuner component
   virtual void vOnGNSSAntennaCurrent (tF32 antennaCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSAntennaCurrent(antennaCurrent);
      }
   }
   virtual void vOnGNSSAntennaStatus (tU8 status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSAntennaStatus(status);
      }
   }
   virtual void vOnGNSSReceiverStatus (const dia_tGNSSReceiverState& info)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSReceiverStatus(info);
      }
   }
   virtual void vOnGPSReceptionLevel (const dia_tGPSReceptionLevel& info)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGPSReceptionLevel(info);
      }
   }
   virtual void vOnGNSSBestSattelites (const std::vector<dia_tGNSSBestSattelletes>& quality)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSBestSattelites(quality);
      }
   }
   virtual void vOnGNSSSatellitesSignalQuality (const std::vector<dia_tGNSSSatellitesSignalQuality>& quality)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSSatellitesSignalQuality(quality);
      }
   }
   virtual void vOnGNSSSatSystem (tU8 satSystem)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSSatSystem(satSystem);
      }
   }
   virtual void vOnDiagGNSSSatSystem (tU8 satSystem)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDiagGNSSSatSystem(satSystem);
      }
   }
   virtual void vOnGNSSTimeDate (tU16 u16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minutes, tU8 u8Seconds, tU16 u16MSeconds)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSTimeDate(u16Year, u8Month, u8Day, u8Hour, u8Minutes, u8Seconds, u16MSeconds);
      }
   }
   virtual void vOnGNSSPosition (tS32 LatitudeMSeconds, tS32 LongitudeMSeconds, tS16 Altitude)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSPosition(LatitudeMSeconds, LongitudeMSeconds, Altitude);
      }
   }
   virtual void vOnGNSSRecFirmwareVersion (const tU32 firmwareVersion)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSRecFirmwareVersion(firmwareVersion);
      }
   }
   virtual void vOnGNSSRecFrimwareCrc (const tU32 firmwareCrc)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSRecFrimwareCrc(firmwareCrc);
      }
   }
   virtual void vOnGNSSVelocity (tS16 s16VelocityNorth, tS16 s16VelocityEast, tS16 s16VelocityUp)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSVelocity(s16VelocityNorth, s16VelocityEast, s16VelocityUp);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__ */
