/*****************************************************************************************
*
* \file    dia_IErrorLog.h
*
* \brief   interface of dia_IErrorLog
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IErrorLog.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_ERROR_LOG__
#define __INCLUDED_DIA_INTERFACE_ERROR_LOG__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
class dia_ErrorInfoInterface;
#define IID_ERROR_LOG ((dia::IID) 0xc8a715e7)
//------------------------------------------------------------------------------
enum dia_enTestResult
{
   DIA_EN_ERRLOG_TESTRESULT_UNKNOWN = 0,
   DIA_EN_ERRLOG_TESTRESULT_PASSED,
   DIA_EN_ERRLOG_TESTRESULT_FAILED,
   DIA_EN_ERRLOG_TESTRESULT_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_enTroubleCodeStatus
{
   DIA_EN_ERRLOG_TCSTATUS_UNKNOWN = 0,
   DIA_EN_ERRLOG_TCSTATUS_INACTIVE,
   DIA_EN_ERRLOG_TCSTATUS_ACTIVE,
   DIA_EN_ERRLOG_TCSTATUS_NOT_COMPLETE,
   DIA_EN_ERRLOG_TCSTATUS_ACTIVE_NOT_COMPLETE,
   DIA_EN_ERRLOG_TCSTATUS_WAS_ACTIVE,
   DIA_EN_ERRLOG_TCSTATUS_COUNT = 6
};
//------------------------------------------------------------------------------
enum dia_tenControlType
{
   DIA_EN_ERRLOG_CONTROL_DTC_UNKNOWN = 0,
   DIA_EN_ERRLOG_CONTROL_DTC_SETTING_ON,
   DIA_EN_ERRLOG_CONTROL_DTC_SETTING_OFF,
   DIA_EN_ERRLOG_CONTROL_DTC_SETTING_ON_PERSISTENT,
   DIA_EN_ERRLOG_CONTROL_DTC_SETTING_OFF_PERSISTENT,
   DIA_EN_ERRLOG_CONTROL_DTC_ENABLE_CALIBRATION_BLOCKING,
   DIA_EN_ERRLOG_CONTROL_DTC_DISABLE_CALIBRATION_BLOCKING,
   DIA_EN_ERRLOG_CONTROL_DTC_COUNT = 7
};
struct dia_tITCInfo
{
public:
   //! default constructor
   dia_tITCInfo() :
      m_u16ITC(0),
      m_u8Status(0),
      m_eStatus(DIA_EN_ERRLOG_TCSTATUS_UNKNOWN),
      m_u32AgeingCounter(0),
      m_u32FaultCounter(0),
      m_u32DTC(0)
   {}

   //! class constructor
   dia_tITCInfo(
      tU16 m_u16ITC_,
      tU8 m_u8Status_,
      dia_enTroubleCodeStatus m_eStatus_,
      tU32 m_u32AgeingCounter_,
      tU32 m_u32FaultCounter_,
      tU32 m_u32DTC_
   ) :
      m_u16ITC(m_u16ITC_),
      m_u8Status(m_u8Status_),
      m_eStatus(m_eStatus_),
      m_u32AgeingCounter(m_u32AgeingCounter_),
      m_u32FaultCounter(m_u32FaultCounter_),
      m_u32DTC(m_u32DTC_)
   {}
   tU16 m_u16ITC;
   tU8 m_u8Status;
   dia_enTroubleCodeStatus m_eStatus;
   tU32 m_u32AgeingCounter;
   tU32 m_u32FaultCounter;
   tU32 m_u32DTC;
};
struct IErrorLogExtendedDataResult
{
public:
   //! default constructor
   IErrorLogExtendedDataResult() :
      dtc(0),
      data(),
      status(0)
   {}

   //! class constructor
   IErrorLogExtendedDataResult(
      tU32 dtc_,
      std::vector<tU8> data_,
      tU8 status_
   ) :
      dtc(dtc_),
      data(data_),
      status(status_)
   {}
   tU32 dtc;
   std::vector<tU8> data;
   tU8 status;
};
struct IErrorLogSnapshotIdResult
{
public:
   //! default constructor
   IErrorLogSnapshotIdResult() :
      dtc(0),
      recNo(0)
   {}

   //! class constructor
   IErrorLogSnapshotIdResult(
      tU32 dtc_,
      tU8 recNo_
   ) :
      dtc(dtc_),
      recNo(recNo_)
   {}
   tU32 dtc;
   tU8 recNo;
};
struct IErrorLogSnapshotDataResult
{
public:
   //! default constructor
   IErrorLogSnapshotDataResult() :
      recNo(0),
      noOfData(0),
      data()
   {}

   //! class constructor
   IErrorLogSnapshotDataResult(
      tU8 recNo_,
      tU8 noOfData_,
      std::vector<tU8> data_
   ) :
      recNo(recNo_),
      noOfData(noOfData_),
      data(data_)
   {}
   tU8 recNo;
   tU8 noOfData;
   std::vector<tU8> data;
};
struct tdia_IErrorLogResult
{
public:
   //! default constructor
   tdia_IErrorLogResult() :
      u32DTC(0),
      u8Status(0)
   {}

   //! class constructor
   tdia_IErrorLogResult(
      tU32 u32DTC_,
      tU8 u8Status_
   ) :
      u32DTC(u32DTC_),
      u8Status(u8Status_)
   {}
   tU32 u32DTC;
   tU8 u8Status;
};
class dia_IErrorLog
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_ERROR_LOG; }
public:
   //! report the test result for the given ITC
   virtual tDiaResult reportTestResult (tU16 u16Itc, dia_enTestResult status ) = 0;
   //! report the test results for the list of given ITCs
   virtual tDiaResult reportTestResults (const std::map<tU16,dia_enTestResult>& testResults ) = 0;
   //! start DTC test
   virtual tDiaResult u32TestDTCStart (const tU8* au8TestResultData ) = 0;
   //! clear DTCs
   virtual tDiaResult clearDTC (tU8 u8Group, tU32 u32GroupOfDtc ) = 0;
   //! get current status by a specific DTC
   virtual tDiaResult getStatusByDTC (tU8 u8Group, tU32 u32DTCMask ) = 0;
   //! get current status by a specific ITC
   virtual tDiaResult getStatusByITC (tU8 u8Group, tU32 u32ITCMask ) = 0;
   //! get current status by a specific status mask
   virtual tDiaResult getDTCbyStatusMask (tU8 u8Group, tU8 u8Mask ) = 0;
   //! get number of DTC by a specific status mask
   virtual tDiaResult getNumberOfDTCbyStatusMask (tU8 u8Group, tU8 u8Mask ) = 0;
   //! get a list of supported DTCs
   virtual tDiaResult getSupportedDTC (tU8 u8Group ) = 0;
   //! get last confirmed DTC
   virtual tDiaResult getLastConfirmedDTC (tU8 u8Group ) = 0;
   //! change DTC settings
   virtual tDiaResult controlDTCSetting (const dia_tenControlType eMode ) = 0;
   //! According given DTC the diaglog will forward the Extended Data to the specific DiagLog component.
   virtual tDiaResult getExtendedData (tU8 group, tU32 dtc, tU8 recordNumber ) = 0;
   //! get all SnapShot Identifier.
   virtual tDiaResult getSnapShotId (tU8 u8Group ) = 0;
   //! get all SnapShotDAta by DTC
   virtual tDiaResult getSnapShotData (tU8 u8Group, tU32 dtc, tU8 recordNumber ) = 0;
   //! get ITC Information
   virtual tDiaResult getItcInformation (tU8 u8Group, const std::vector<tU16>& ItcList ) = 0;
   //! register for active DTC
   virtual tDiaResult registerForActiveDtc ( ) = 0;
   //! unregister for active DTC
   virtual tDiaResult unregisterForActiveDtc ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IErrorLog( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_ERROR_LOG__ */
