/*****************************************************************************************
*
* \file    dia_IDimmingListener.h
*
* \brief   listener of dia_IDimmingListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IDimming.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__
#define __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING__
#include "dia_IDimming.h"
#endif

#define IID_DIMMING_LISTENER ((dia::IID) 0x86f9a246)
/**
 *
 *  \class dia_IDimmingListener
 *
 */

class dia_IDimmingListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_DIMMING_LISTENER; }
public:
   //! receives and forwards the current active brightness as signalled by the car through PWM input
   virtual void vOnDimmingInformation (tU16 brightness ) = 0;
   //! receives and forwards current active keyboard brightness information
   virtual void vOnKeyBBrightnessInformation (tU16 brightness ) = 0;
   //! receives and forwards current active keyboard brightness information
   virtual void vOnKeyBPwmInformation (tU16 pwm ) = 0;
   //! receives and forwards current active display brightness information
   virtual void vOnDispBrightnessInformation (tU16 brightness ) = 0;
   //! receives and forwards current active display panel temperature information
   virtual void vOnDispPanelTempInformation (tS16 temperature ) = 0;
   //! receives and forwards current halfclass information
   virtual void vOnDimmingHalfClassInformation (const std::vector<tU8>& halfClassInfo ) = 0;
   //! current dimming status
   virtual void vOnDimmingStatus (dia_eDimmingStatus status ) = 0;
   //! current light sensor status
   virtual void vOnLightSensorStatus (tU16 statusValue ) = 0;
   //! current light sensor status
   virtual void vOnDayAndNightModeStatus (tU8 mode ) = 0;
   //! Signal to inform requester about success of the key illumination brightness change request
   virtual void vOnKeyBrightnessChangeResult (tU16 brightness ) = 0;
   //! Signal to inform requester about success of the key illumination pwm change request
   virtual void vOnKeyPWMChangeResult (tU16 pwm ) = 0;
   /**
   * \brief response to setEmulationMode (signal to inform requester about the current Emulation Mode status)
    * \param u8Mode Current Emulation Mode
   */
   virtual void vOnEmulationModeStatus (tU8 u8Mode ) = 0;
   /**
   * \brief response to setDisplayBrightness (signal to inform requester about the current display brightness status)
    * \param u16PWMValue Current display brightness
   */
   virtual void vOnDispBrightnessAck (tU16 u16Brightness ) = 0;
   //! response with current active dimming mode
   virtual void vOnDimmingMode (dia_eDimmingStatus dimmStatus ) = 0;
   //! response with current pwm dimming rate
   virtual void vOnDimmingPWM (tU16 pwmRate ) = 0;
   //! response with current active illumination status
   virtual void vOnDimmingIllStatus (dia_eDimmingStatus dimmStatus ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IDimmingListener( void ) {}
};
/**
 *
 *  \class dia_IDimmingListenerImpl
 *
 */

class dia_IDimmingListenerImpl
   : public dia_IDimmingListener
{
public:
   //! receives and forwards the current active brightness as signalled by the car through PWM input
   virtual void vOnDimmingInformation (tU16 /*brightness*/ ) {}
   //! receives and forwards current active keyboard brightness information
   virtual void vOnKeyBBrightnessInformation (tU16 /*brightness*/ ) {}
   //! receives and forwards current active keyboard brightness information
   virtual void vOnKeyBPwmInformation (tU16 /*pwm*/ ) {}
   //! receives and forwards current active display brightness information
   virtual void vOnDispBrightnessInformation (tU16 /*brightness*/ ) {}
   //! receives and forwards current active display panel temperature information
   virtual void vOnDispPanelTempInformation (tS16 /*temperature*/ ) {}
   //! receives and forwards current halfclass information
   virtual void vOnDimmingHalfClassInformation (const std::vector<tU8>& /*halfClassInfo*/ ) {}
   //! current dimming status
   virtual void vOnDimmingStatus (dia_eDimmingStatus /*status*/ ) {}
   //! current light sensor status
   virtual void vOnLightSensorStatus (tU16 /*statusValue*/ ) {}
   //! current light sensor status
   virtual void vOnDayAndNightModeStatus (tU8 /*mode*/ ) {}
   //! Signal to inform requester about success of the key illumination brightness change request
   virtual void vOnKeyBrightnessChangeResult (tU16 /*brightness*/ ) {}
   //! Signal to inform requester about success of the key illumination pwm change request
   virtual void vOnKeyPWMChangeResult (tU16 /*pwm*/ ) {}
   /**
   * \brief response to setEmulationMode (signal to inform requester about the current Emulation Mode status)
    * \param u8Mode Current Emulation Mode
   */
   virtual void vOnEmulationModeStatus (tU8 /*u8Mode*/ ) {}
   /**
   * \brief response to setDisplayBrightness (signal to inform requester about the current display brightness status)
    * \param u16PWMValue Current display brightness
   */
   virtual void vOnDispBrightnessAck (tU16 /*u16Brightness*/ ) {}
   //! response with current active dimming mode
   virtual void vOnDimmingMode (dia_eDimmingStatus /*dimmStatus*/ ) {}
   //! response with current pwm dimming rate
   virtual void vOnDimmingPWM (tU16 /*pwmRate*/ ) {}
   //! response with current active illumination status
   virtual void vOnDimmingIllStatus (dia_eDimmingStatus /*dimmStatus*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IDimmingListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IDimmingNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IDimmingNotifier
   : public dia_IDimmingListener,
     public dia_Notifier<dia_IDimmingListener>
{
public:
   //! receives and forwards the current active brightness as signalled by the car through PWM input
   virtual void vOnDimmingInformation (tU16 brightness)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDimmingInformation(brightness);
      }
   }
   //! receives and forwards current active keyboard brightness information
   virtual void vOnKeyBBrightnessInformation (tU16 brightness)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnKeyBBrightnessInformation(brightness);
      }
   }
   //! receives and forwards current active keyboard brightness information
   virtual void vOnKeyBPwmInformation (tU16 pwm)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnKeyBPwmInformation(pwm);
      }
   }
   //! receives and forwards current active display brightness information
   virtual void vOnDispBrightnessInformation (tU16 brightness)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDispBrightnessInformation(brightness);
      }
   }
   //! receives and forwards current active display panel temperature information
   virtual void vOnDispPanelTempInformation (tS16 temperature)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDispPanelTempInformation(temperature);
      }
   }
   //! receives and forwards current halfclass information
   virtual void vOnDimmingHalfClassInformation (const std::vector<tU8>& halfClassInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDimmingHalfClassInformation(halfClassInfo);
      }
   }
   //! current dimming status
   virtual void vOnDimmingStatus (dia_eDimmingStatus status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDimmingStatus(status);
      }
   }
   //! current light sensor status
   virtual void vOnLightSensorStatus (tU16 statusValue)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnLightSensorStatus(statusValue);
      }
   }
   //! current light sensor status
   virtual void vOnDayAndNightModeStatus (tU8 mode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDayAndNightModeStatus(mode);
      }
   }
   //! Signal to inform requester about success of the key illumination brightness change request
   virtual void vOnKeyBrightnessChangeResult (tU16 brightness)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnKeyBrightnessChangeResult(brightness);
      }
   }
   //! Signal to inform requester about success of the key illumination pwm change request
   virtual void vOnKeyPWMChangeResult (tU16 pwm)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnKeyPWMChangeResult(pwm);
      }
   }
   /**
   * \brief response to setEmulationMode (signal to inform requester about the current Emulation Mode status)
    * \param u8Mode Current Emulation Mode
   */
   virtual void vOnEmulationModeStatus (tU8 u8Mode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnEmulationModeStatus(u8Mode);
      }
   }
   /**
   * \brief response to setDisplayBrightness (signal to inform requester about the current display brightness status)
    * \param u16PWMValue Current display brightness
   */
   virtual void vOnDispBrightnessAck (tU16 u16Brightness)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDispBrightnessAck(u16Brightness);
      }
   }
   //! response with current active dimming mode
   virtual void vOnDimmingMode (dia_eDimmingStatus dimmStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDimmingMode(dimmStatus);
      }
   }
   //! response with current pwm dimming rate
   virtual void vOnDimmingPWM (tU16 pwmRate)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDimmingPWM(pwmRate);
      }
   }
   //! response with current active illumination status
   virtual void vOnDimmingIllStatus (dia_eDimmingStatus dimmStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDimmingIllStatus(dimmStatus);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__ */
