/*****************************************************************************************
*
* \file    dia_IDeviceMGR.h
*
* \brief   interface of dia_IDeviceMGR
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author fgl2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IDeviceMGR.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DEVICEMGR__
#define __INCLUDED_DIA_INTERFACE_DEVICEMGR__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_DEVMGR ((dia::IID) 0x8e9d4311)
//------------------------------------------------------------------------------
enum dia_eSDCSlotState
{
   DIA_EN_DEVMGR_SDC_SLOT_STATE_UNKNOWN = 0,
   DIA_EN_DEVMGR_SDC_SLOT_STATE_INSERTED,
   DIA_EN_DEVMGR_SDC_SLOT_STATE_REMOVED,
   DIA_EN_DEVMGR_SDC_SLOT_STATE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eSDCWriteProtectionState
{
   DIA_EN_DEVMGR_SDC_WP_STATE_UNKNOWN = 0,
   DIA_EN_DEVMGR_SDC_WP_STATE_NOT_PROTECTED,
   DIA_EN_DEVMGR_SDC_WP_STATE_PROTECTED,
   DIA_EN_DEVMGR_SDC_WP_STATE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eDeviceType
{
   DIA_EN_DEVMGR_DEVICE_TYPE_UNKNOWN = 0,
   DIA_EN_DEVMGR_DEVICE_TYPE_SDCARD,
   DIA_EN_DEVMGR_DEVICE_TYPE_CDROM,
   DIA_EN_DEVMGR_DEVICE_TYPE_USB_MS,
   DIA_EN_DEVMGR_DEVICE_TYPE_USB_IPOD,
   DIA_EN_DEVMGR_DEVICE_TYPE_USB_MTP,
   DIA_EN_DEVMGR_DEVICE_TYPE_USB_MSZUNE,
   DIA_EN_DEVMGR_DEVICE_TYPE_USB_NOT_SUPPORTED,
   DIA_EN_DEVMGR_DEVICE_TYPE_COUNT = 8
};
//------------------------------------------------------------------------------
enum dia_eConnectState
{
   DIA_EN_DEVMGR_CONNECT_STATE_UNKNOWN = 0,
   DIA_EN_DEVMGR_CONNECT_STATE_CONNECTED,
   DIA_EN_DEVMGR_CONNECT_STATE_REMOVED,
   DIA_EN_DEVMGR_CONNECT_STATE_UNAVAIL_BAT_LOWVOLT,
   DIA_EN_DEVMGR_CONNECT_STATE_UNAVAIL_HW_MALFUNC,
   DIA_EN_DEVMGR_CONNECT_STATE_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eDeviceSpeed
{
   DIA_EN_DEVMGR_DEVICE_SPEED_UNKNOWN = 0,
   DIA_EN_DEVMGR_DEVICE_SPEED_LOW,
   DIA_EN_DEVMGR_DEVICE_SPEED_FULL,
   DIA_EN_DEVMGR_DEVICE_SPEED_HIGH,
   DIA_EN_DEVMGR_DEVICE_SPEED_SUPER,
   DIA_EN_DEVMGR_DEVICE_SPEED_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eDVM_CDModeSwitch2
{
   DIA_EN_DEVMGR_CD_MODE_SWITCH_TO_UNKNOWN = 0,
   DIA_EN_DEVMGR_CD_MODE_SWITCH_TO_CDDA,
   DIA_EN_DEVMGR_CD_MODE_SWITCH_TO_CDROM,
   DIA_EN_DEVMGR_CD_MODE_SWITCH_TO_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eFileSystem
{
   DIA_EN_DEVMGR_FILE_SYSTEM_UNKNOWN = 0,
   DIA_EN_DEVMGR_FILE_SYSTEM_FAT,
   DIA_EN_DEVMGR_FILE_SYSTEM_NTFS,
   DIA_EN_DEVMGR_FILE_SYSTEM_EXT4,
   DIA_EN_DEVMGR_FILE_SYSTEM_HFS,
   DIA_EN_DEVMGR_FILE_SYSTEM_EXFAT,
   DIA_EN_DEVMGR_FILE_SYSTEM_ISO9660,
   DIA_EN_DEVMGR_FILE_SYSTEM_UDF,
   DIA_EN_DEVMGR_FILE_SYSTEM_COUNT = 8
};
//------------------------------------------------------------------------------
enum dia_eOpticalDiscSlotState
{
   DIA_EN_OPTDISC_UNKNOWN = 0,
   DIA_EN_OPTDISC_INITIALISING,
   DIA_EN_OPTDISC_INITIALISED,
   DIA_EN_OPTDISC_LASTMODE_EMTPY,
   DIA_EN_OPTDISC_LASTMODE_INSERTED_CDDA,
   DIA_EN_OPTDISC_LASTMODE_INSERTED_CDROM,
   DIA_EN_OPTDISC_LASTMODE_INSERTED_CDERROR,
   DIA_EN_OPTDISC_INSERTING,
   DIA_EN_OPTDISC_INSERTED_CDAUDIO,
   DIA_EN_OPTDISC_INSERTED_CDROM,
   DIA_EN_OPTDISC_INSERTED_CDERROR ,
   DIA_EN_OPTDISC_INSERTED_AUTOMATIC_CDAUDIO,
   DIA_EN_OPTDISC_INSERTED_AUTOMATIC_CDROM ,
   DIA_EN_OPTDISC_INSERTED_AUTOMATIC_CDERROR,
   DIA_EN_OPTDISC_EJECTING,
   DIA_EN_OPTDISC_EJECTED_READY_TO_REMOVE,
   DIA_EN_OPTDISC_EJECTED_EMPTY,
   DIA_EN_OPTDISC_UNDEFINED_STATE,
   DIA_EN_OPTDISC_COUNT = 18
};
struct dia_tSdcCIDs
{
public:
//! dia_tSdcCIDs contains a byte list with the register content of one SD Card.
   //! default constructor
   dia_tSdcCIDs() :
      SlotNo(0),
      CID{0}
   {}
   tU8 SlotNo;
   tU8 CID[16];
};
struct dia_tSdcStates
{
public:
//! dia_tSdcStates contains the slot state and the write protection state one SD Card.
   //! default constructor
   dia_tSdcStates() :
      SlotNo(0),
      SlotState(DIA_EN_DEVMGR_SDC_SLOT_STATE_UNKNOWN),
      WriteProtectionState(DIA_EN_DEVMGR_SDC_WP_STATE_UNKNOWN)
   {}

   //! class constructor
   dia_tSdcStates(
      tU8 SlotNo_,
      dia_eSDCSlotState SlotState_,
      dia_eSDCWriteProtectionState WriteProtectionState_
   ) :
      SlotNo(SlotNo_),
      SlotState(SlotState_),
      WriteProtectionState(WriteProtectionState_)
   {}
   tU8 SlotNo;
   dia_eSDCSlotState SlotState;
   dia_eSDCWriteProtectionState WriteProtectionState;
};
struct dia_tDeviceInfo
{
public:
   //! default constructor
   dia_tDeviceInfo() :
      VendorID(0),
      ProductID(0),
      Size(0),
      PortNo(0),
      DeviceType(DIA_EN_DEVMGR_DEVICE_TYPE_UNKNOWN),
      ConnectionState(DIA_EN_DEVMGR_CONNECT_STATE_UNKNOWN),
      DeviceSpeed(DIA_EN_DEVMGR_DEVICE_SPEED_UNKNOWN),
      DeviceBaseClass(0),
      DeviceSubClass(0),
      Protocol(0),
      FileSystem(0)
   {}

   //! class constructor
   dia_tDeviceInfo(
      tU16 VendorID_,
      tU16 ProductID_,
      tU64 Size_,
      tU32 PortNo_,
      dia_eDeviceType DeviceType_,
      dia_eConnectState ConnectionState_,
      dia_eDeviceSpeed DeviceSpeed_,
      tU8 DeviceBaseClass_,
      tU8 DeviceSubClass_,
      tU8 Protocol_,
      tU8 FileSystem_
   ) :
      VendorID(VendorID_),
      ProductID(ProductID_),
      Size(Size_),
      PortNo(PortNo_),
      DeviceType(DeviceType_),
      ConnectionState(ConnectionState_),
      DeviceSpeed(DeviceSpeed_),
      DeviceBaseClass(DeviceBaseClass_),
      DeviceSubClass(DeviceSubClass_),
      Protocol(Protocol_),
      FileSystem(FileSystem_)
   {}
   tU16 VendorID;
   tU16 ProductID;
   tU64 Size;
   tU32 PortNo;
   dia_eDeviceType DeviceType;
   dia_eConnectState ConnectionState;
   dia_eDeviceSpeed DeviceSpeed;
   tU8 DeviceBaseClass;
   tU8 DeviceSubClass;
   tU8 Protocol;
   tU8 FileSystem;
};
struct dia_tUsbPortStates
{
public:
   //! default constructor
   dia_tUsbPortStates() :
      PortNo(0),
      OverCurrent(FALSE),
      UnderVoltage(FALSE),
      HubConnected(FALSE),
      OpenCircuit(FALSE),
      PowerOn(FALSE)
   {}

   //! class constructor
   dia_tUsbPortStates(
      tU8 PortNo_,
      tBool OverCurrent_,
      tBool UnderVoltage_,
      tBool HubConnected_,
      tBool OpenCircuit_,
      tBool PowerOn_
   ) :
      PortNo(PortNo_),
      OverCurrent(OverCurrent_),
      UnderVoltage(UnderVoltage_),
      HubConnected(HubConnected_),
      OpenCircuit(OpenCircuit_),
      PowerOn(PowerOn_)
   {}
   tU8 PortNo;
   tBool OverCurrent;
   tBool UnderVoltage;
   tBool HubConnected;
   tBool OpenCircuit;
   tBool PowerOn;
};
class dia_IDeviceMGR
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_DEVMGR; }
public:
   //! Get the (specific) SD Card diagnosis values
   virtual tDiaResult getSDCardDiagValues ( ) = 0;
   //! Get the (common) diagnosis values for the devices (USB, SD Card, CD ROM)
   virtual tDiaResult getDevicesValues ( ) = 0;
   //! Switch between CD modes (CDDA / CDROM)
   virtual tDiaResult selectCDMode (dia_eDVM_CDModeSwitch2 switch2CDMode ) = 0;
   //! information about OpticDisck  states
   virtual tDiaResult regOpticDiskConnectionStatusValues ( ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
   //! virtual base class destructor
   virtual ~dia_IDeviceMGR( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_DEVICEMGR__ */
