/*****************************************************************************************
*
* \file    dia_IDataDownloadListener.h
*
* \brief   listener of dia_IDataDownloadListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author stc2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IDataDownload.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_DATA_DOWNLOAD_LISTENER__
#define __INCLUDED_DIA_INTERFACE_DATA_DOWNLOAD_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_DATA_DOWNLOAD__
#include "dia_IDataDownload.h"
#endif

#define IID_DATA_DOWNLOAD_LISTENER ((dia::IID) 0x237334d3)
/**
 *
 *  \class dia_IDataDownloadListener
 *
 */

class dia_IDataDownloadListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_DATA_DOWNLOAD_LISTENER; }
public:
   //! there was an update about the download request
   virtual void vOnRequestDownloadUpdate (std::vector<tU8>& responseData ) = 0;
   //! there was an update about the transfer exit request
   virtual void vOnTransferExitUpdate ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IDataDownloadListener( void ) {}
};
/**
 *
 *  \class dia_IDataDownloadListenerImpl
 *
 */

class dia_IDataDownloadListenerImpl
   : public dia_IDataDownloadListener
{
public:
   //! there was an update about the download request
   virtual void vOnRequestDownloadUpdate (std::vector<tU8>& /*responseData*/ ) {}
   //! there was an update about the transfer exit request
   virtual void vOnTransferExitUpdate ( ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IDataDownloadListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IDataDownloadNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IDataDownloadNotifier
   : public dia_IDataDownloadListener,
     public dia_Notifier<dia_IDataDownloadListener>
{
public:
   //! there was an update about the download request
   virtual void vOnRequestDownloadUpdate (std::vector<tU8>& responseData)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRequestDownloadUpdate(responseData);
      }
   }
   //! there was an update about the transfer exit request
   virtual void vOnTransferExitUpdate ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTransferExitUpdate();
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_DATA_DOWNLOAD_LISTENER__ */
