/*****************************************************************************************
*
* \file    dia_IConfigItem.h
*
* \brief   interface of dia_IConfigItem
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author hld5kor (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IConfigItem.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_CONFIG_ITEM__
#define __INCLUDED_DIA_INTERFACE_CONFIG_ITEM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
class dia_IConfigItemListener;
#define IID_CONFIG_ITEM ((dia::IID) 0xb03bd660)
class dia_IConfigItem
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_CONFIG_ITEM; }
   DIA_DECL_CONFIGMANAGER_IID(IID_CONFIG_ITEM)
     
public:
   //! get the ConfigItemEntry Data synchronously
   virtual tDiaResult getConfigItem (tU32 ConfigItem, tU8** ConfItemData, tU16* ConfigItemDatalength ) = 0;
   //! get the ConfigItemEntry Data asynchronously
   virtual tDiaResult getConfigItem (tU32 ConfigItem, dia_IConfigItemListener* pListener, void* cookie ) = 0;
   //! set the ConfigItemEntry Data synchronously
   virtual tDiaResult setConfigItem (tU32 ConfigItem, const std::vector<tU8>& ConfItemData ) = 0;
   //! set the ConfigItemEntry Data asynchronously
   virtual tDiaResult setConfigItem (tU32 ConfigItem, const std::vector<tU8>& ConfItemData, dia_IConfigItemListener* pListener, void* cookie ) = 0;
   //! get the Property Details and read Data
   virtual tDiaResult getPropertyDetails (tU32 PropID ) = 0;
   //! register a listener for the given ConfigItem
   virtual tDiaResult addConfigItemListener (tU32 ConfigItem, dia_IConfigItemListener* pListener ) = 0;
   //! unregister a listener for the given ConfigItem
   virtual tDiaResult removeConfigItemListener (tU32 ConfigItem, dia_IConfigItemListener* pListener ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IConfigItem( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_CONFIG_ITEM__ */
