/*****************************************************************************************
*
* \file    dia_IBTDeviceList.h
*
* \brief   interface of dia_IBTDeviceList
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author Bharath Kumar Yellikanti (RBEI/ECA4) (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IBTDeviceList.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_BT_DEVICE_LIST__
#define __INCLUDED_DIA_INTERFACE_BT_DEVICE_LIST__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_SYSADAPTER_BLUETOOTH_DEVICE_LIST ((dia::IID) 0x236d753d)
//------------------------------------------------------------------------------
enum dia_eBTDeviceStatus
{
   DIA_EN_BT_DEVICE_STAUS_UNKNOWN = 0,
   DIA_EN_BT_DEVICE_STAUS_CONNECTED,
   DIA_EN_BT_DEVICE_STAUS_CONNECTED_OSD,
   DIA_EN_BT_DEVICE_STAUS_DISCONNECTED,
   DIA_EN_BT_DEVICE_STAUS_CHANGED_TO_OSD,
   DIA_EN_BT_DEVICE_STAUS_DELETED,
   DIA_EN_BT_DEVICE_STAUS_NO_CHANGE,
   DIA_EN_BT_DEVICE_STAUS_COUNT = 7
};
struct dia_BTDateTimeStamp
{
public:
   //! default constructor
   dia_BTDateTimeStamp() :
      CldrYear(),
      CldrMonth(),
      CldrDay(),
      Hours(),
      Minutes(),
      Seconds()
   {}

   //! class constructor
   dia_BTDateTimeStamp(
      tCString CldrYear_,
      tCString CldrMonth_,
      tCString CldrDay_,
      tCString Hours_,
      tCString Minutes_,
      tCString Seconds_
   ) :
      CldrYear(CldrYear_),
      CldrMonth(CldrMonth_),
      CldrDay(CldrDay_),
      Hours(Hours_),
      Minutes(Minutes_),
      Seconds(Seconds_)
   {}
   tCString CldrYear;
   tCString CldrMonth;
   tCString CldrDay;
   tCString Hours;
   tCString Minutes;
   tCString Seconds;
};
struct dia_tBTDeviceList
{
public:
   //! default constructor
   dia_tBTDeviceList() :
      DeviceConnectedStatus(FALSE),
      OutgoingSourceDeviceStatus(FALSE),
      DeviceHandle(0),
      DeviceName(),
      DateTimeStamp()
   {}

   //! class constructor
   dia_tBTDeviceList(
      tBool DeviceConnectedStatus_,
      tBool OutgoingSourceDeviceStatus_,
      tU8 DeviceHandle_,
      tCString DeviceName_,
      dia_BTDateTimeStamp DateTimeStamp_
   ) :
      DeviceConnectedStatus(DeviceConnectedStatus_),
      OutgoingSourceDeviceStatus(OutgoingSourceDeviceStatus_),
      DeviceHandle(DeviceHandle_),
      DeviceName(DeviceName_),
      DateTimeStamp(DateTimeStamp_)
   {}
   tBool DeviceConnectedStatus;
   tBool OutgoingSourceDeviceStatus;
   tU8 DeviceHandle;
   tCString DeviceName;
   dia_BTDateTimeStamp DateTimeStamp;
};
struct dia_tBTDeviceListChange
{
public:
   //! default constructor
   dia_tBTDeviceListChange() :
      DeviceHandle(0),
      DeviceStatus(DIA_EN_BT_DEVICE_STAUS_UNKNOWN)
   {}

   //! class constructor
   dia_tBTDeviceListChange(
      tU8 DeviceHandle_,
      dia_eBTDeviceStatus DeviceStatus_
   ) :
      DeviceHandle(DeviceHandle_),
      DeviceStatus(DeviceStatus_)
   {}
   tU8 DeviceHandle;
   dia_eBTDeviceStatus DeviceStatus;
};
class dia_IBTDeviceList
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSADAPTER_BLUETOOTH_DEVICE_LIST; }
public:
   //! Request the BT module for the currently paired/connected device list.
   virtual tDiaResult getBTDeviceList ( ) = 0;
   //! Request the BT module for the Device list notification.
   virtual tDiaResult startBTDeviceListNotification ( ) = 0;
   //! Request the BT module to stop sending the Device list notification.
   virtual tDiaResult stopBTDeviceListNotification ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IBTDeviceList( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_BT_DEVICE_LIST__ */
