/*****************************************************************************************
*
* \file    dia_IAuthorizationLevelListener.h
*
* \brief   listener of dia_IAuthorizationLevelListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAuthorizationLevel.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_AUTHORIZATION_LEVEL_LISTENER__
#define __INCLUDED_DIA_INTERFACE_AUTHORIZATION_LEVEL_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_AUTHORIZATION_LEVEL__
#include "dia_IAuthorizationLevel.h"
#endif

#define IID_AUTHORIZATION_LEVEL_LISTENER ((dia::IID) 0x542146ea)
/**
 *
 *  \class dia_IAuthorizationLevelListener
 *
 */

class dia_IAuthorizationLevelListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_AUTHORIZATION_LEVEL_LISTENER; }
public:
   //! seed provided by ALD to be used for key calculation
   virtual void vOnSeed (const std::vector<tU8>& seedData ) = 0;
   //! result of the key evaluation
   virtual void vOnKeyValidationResult (tDiaResult result ) = 0;
   //! result for the lockDevice request
   virtual void vOnLockDeviceResult (tDiaResult result ) = 0;
   //! currently active security level
   virtual void vOnLevel (tU16 levelID ) = 0;
   //! information about a newly requested security level (will be sent before the scripts are executed)
   virtual void vOnLevelRequested (tU16 newLevelID ) = 0;
   //! notification that the level was changed to the newly requested level
   virtual void vOnLevelChanged (tU16 newLevelID ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IAuthorizationLevelListener( void ) {}
};
/**
 *
 *  \class dia_IAuthorizationLevelListenerImpl
 *
 */

class dia_IAuthorizationLevelListenerImpl
   : public dia_IAuthorizationLevelListener
{
public:
   //! seed provided by ALD to be used for key calculation
   virtual void vOnSeed (const std::vector<tU8>& /*seedData*/ ) {}
   //! result of the key evaluation
   virtual void vOnKeyValidationResult (tDiaResult /*result*/ ) {}
   //! result for the lockDevice request
   virtual void vOnLockDeviceResult (tDiaResult /*result*/ ) {}
   //! currently active security level
   virtual void vOnLevel (tU16 /*levelID*/ ) {}
   //! information about a newly requested security level (will be sent before the scripts are executed)
   virtual void vOnLevelRequested (tU16 /*newLevelID*/ ) {}
   //! notification that the level was changed to the newly requested level
   virtual void vOnLevelChanged (tU16 /*newLevelID*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IAuthorizationLevelListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IAuthorizationLevelNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IAuthorizationLevelNotifier
   : public dia_IAuthorizationLevelListener,
     public dia_Notifier<dia_IAuthorizationLevelListener>
{
public:
   //! seed provided by ALD to be used for key calculation
   virtual void vOnSeed (const std::vector<tU8>& seedData)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSeed(seedData);
      }
   }
   //! result of the key evaluation
   virtual void vOnKeyValidationResult (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnKeyValidationResult(result);
      }
   }
   //! result for the lockDevice request
   virtual void vOnLockDeviceResult (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnLockDeviceResult(result);
      }
   }
   //! currently active security level
   virtual void vOnLevel (tU16 levelID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnLevel(levelID);
      }
   }
   //! information about a newly requested security level (will be sent before the scripts are executed)
   virtual void vOnLevelRequested (tU16 newLevelID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnLevelRequested(newLevelID);
      }
   }
   //! notification that the level was changed to the newly requested level
   virtual void vOnLevelChanged (tU16 newLevelID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnLevelChanged(newLevelID);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_AUTHORIZATION_LEVEL_LISTENER__ */
