/*****************************************************************************************
*
* \file    dia_IAuthorizationLevel.h
*
* \brief   interface of dia_IAuthorizationLevel
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAuthorizationLevel.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_AUTHORIZATION_LEVEL__
#define __INCLUDED_DIA_INTERFACE_AUTHORIZATION_LEVEL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define DIA_C_U16_ALD_UNKNOWN_LEVEL ((tU16)0xFFFF)
#define IID_AUTHORIZATION_LEVEL ((dia::IID) 0xd354684)
class dia_IAuthorizationLevel
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_AUTHORIZATION_LEVEL; }
public:
   //! request a seed at ALD
   virtual tDiaResult requestSeed (const std::vector<tU8>& initVector ) = 0;
   //! provide the key calculated from seed to the ALD
   virtual tDiaResult provideKey (const std::vector<tU8>& key ) = 0;
   //! send request to ALD for locking all engineering interfaces via ALD (set level 0)
   virtual tDiaResult lockDevice ( ) = 0;
   //! request current level from ALD
   virtual tDiaResult getActiveLevel ( ) = 0;
   //! retrieve ALD level
   virtual tU16 getCurrentLevel ( ) const  = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IAuthorizationLevel( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_AUTHORIZATION_LEVEL__ */
