/*****************************************************************************************
*
* \file    dia_IAudioControlListener.h
*
* \brief   listener of dia_IAudioControlListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAudioControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_CONTROL_LISTENER__
#define __INCLUDED_DIA_INTERFACE_AUDIO_CONTROL_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_CONTROL__
#include "dia_IAudioControl.h"
#endif

#define IID_AUDIO_CONTROL_LISTENER ((dia::IID) 0x5c47c9f4)
/**
 *
 *  \class dia_IAudioControlListener
 *
 */

class dia_IAudioControlListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_AUDIO_CONTROL_LISTENER; }
public:
   //! response to setAudioGain
   virtual void vOnAudioGain (tDiaResult success ) = 0;
   //! response to dia_setAudioLinearMode
   virtual void vOnAudioLinearMode (tDiaResult success ) = 0;
   //! response to freezeAudioControl_ControlLine
   virtual void vOnAudioExtAmplControlFreezeMode (tDiaResult success, dia_eAudioControlFreeze freezeMode ) = 0;
   //! response to dia_setAudioControlLine
   virtual void vOnAudioExtAmplControlLine (tDiaResult success ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IAudioControlListener( void ) {}
};
/**
 *
 *  \class dia_IAudioControlListenerImpl
 *
 */

class dia_IAudioControlListenerImpl
   : public dia_IAudioControlListener
{
public:
   //! response to setAudioGain
   virtual void vOnAudioGain (tDiaResult /*success*/ ) {}
   //! response to dia_setAudioLinearMode
   virtual void vOnAudioLinearMode (tDiaResult /*success*/ ) {}
   //! response to freezeAudioControl_ControlLine
   virtual void vOnAudioExtAmplControlFreezeMode (tDiaResult /*success*/, dia_eAudioControlFreeze /*freezeMode*/ ) {}
   //! response to dia_setAudioControlLine
   virtual void vOnAudioExtAmplControlLine (tDiaResult /*success*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IAudioControlListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IAudioControlNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IAudioControlNotifier
   : public dia_IAudioControlListener,
     public dia_Notifier<dia_IAudioControlListener>
{
public:
   //! response to setAudioGain
   virtual void vOnAudioGain (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioGain(success);
      }
   }
   //! response to dia_setAudioLinearMode
   virtual void vOnAudioLinearMode (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioLinearMode(success);
      }
   }
   //! response to freezeAudioControl_ControlLine
   virtual void vOnAudioExtAmplControlFreezeMode (tDiaResult success, dia_eAudioControlFreeze freezeMode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioExtAmplControlFreezeMode(success, freezeMode);
      }
   }
   //! response to dia_setAudioControlLine
   virtual void vOnAudioExtAmplControlLine (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAudioExtAmplControlLine(success);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_AUDIO_CONTROL_LISTENER__ */
