/*****************************************************************************************
*
* \file    dia_IAudioControl.h
*
* \brief   interface of dia_IAudioControl
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAudioControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_CONTROL__
#define __INCLUDED_DIA_INTERFACE_AUDIO_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_AUDIO_CONTROL ((dia::IID) 0xb0765f8e)
//------------------------------------------------------------------------------
enum dia_eAudioControlLinearMode
{
   DIA_EN_AUDIOCONTROL_LINEARMODE_UNKNOWN = 0,
   DIA_EN_AUDIOCONTROL_LINEARMODE_ON,
   DIA_EN_AUDIOCONTROL_LINEARMODE_OFF,
   DIA_EN_AUDIOCONTROL_LINEARMODE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eAudioControlFreeze
{
   DIA_EN_AUDIOCONTROL_UNKNOWN = 0,
   DIA_EN_AUDIOCONTROL_FREEZE,
   DIA_EN_AUDIOCONTROL_UNFREEZE,
   DIA_EN_AUDIOCONTROL_COUNT = 3
};
class dia_IAudioControl
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_AUDIO_CONTROL; }
public:
   //! set the audio gain
   virtual tDiaResult dia_setAudioGain (tU8 gain ) = 0;
   //! set the linear mode
   virtual tDiaResult dia_setAudioLinearMode (tU8 linearMode ) = 0;
   //! call freeze or unfreeze of audio control
   virtual tDiaResult freezeAudioControl_ControlLine (dia_eAudioControlFreeze mode ) = 0;
   //! set the control line mode
   virtual tDiaResult dia_setAudioControlLine (tU8 clMode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IAudioControl( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_AUDIO_CONTROL__ */
