/*****************************************************************************************
*
* \file    dia_IAudio.h
*
* \brief   interface of dia_IAudio
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author bma9kor (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IAudio.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO__
#define __INCLUDED_DIA_INTERFACE_AUDIO__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define DIA_AUDIO_CHANNEL_MASK_NONE 0x00
#define DIA_AUDIO_CHANNEL_MASK_ALL 0xFF
#define DIA_AUDIO_CHANNEL_MASK_FRONT_LEFT 0x01
#define DIA_AUDIO_CHANNEL_MASK_FRONT_RIGHT 0x02
#define DIA_AUDIO_CHANNEL_MASK_REAR_LEFT 0x04
#define DIA_AUDIO_CHANNEL_MASK_REAR_RIGHT 0x08
#define DIA_AUDIO_CHANNEL_MASK_CENTER 0x10
#define DIA_AUDIO_CHANNEL_MASK_SUBWOOFER 0x20
#define VOLUME_INCREMENT_LEVEL_MAX 40
#define IID_AUDIO ((dia::IID) 0x55c9cccd)
//------------------------------------------------------------------------------
enum dia_eMicrophoneStatus
{
   DIA_EN_MICROPHONE_CONNECTION_UNKNOWN = 0,
   DIA_EN_MICROPHONE_CONNECTION_OPEN,
   DIA_EN_MICROPHONE_CONNECTION_SHORT,
   DIA_EN_MICROPHONE_CONNECTION_OK,
   DIA_EN_MICROPHONE_CONNECTION_SHORT_TO_BATTERY,
   DIA_EN_MICROPHONE_CONNECTION_UNDEFINED,
   DIA_EN_MICROPHONE_CONNECTION_COUNT = 6
};
//------------------------------------------------------------------------------
enum dia_eMicrophoneNumber
{
   DIA_EN_MICROPHONE_UNKNOWN = 0,
   DIA_EN_MICROPHONE_1,
   DIA_EN_MICROPHONE_2,
   DIA_EN_MICROPHONE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eAudioVolumeType
{
   DIA_EN_AUDIO_VOLUME_TYPE_UNKNOWN = 0,
   DIA_EN_AUDIO_VOLUME_TYPE_DBV,
   DIA_EN_AUDIO_VOLUME_TYPE_DB,
   DIA_EN_AUDIO_VOLUME_TYPE_INCREMENT,
   DIA_EN_AUDIO_VOLUME_TYPE_COUNT = 4
};
struct dia_tMicrophoneStatus
{
public:
   //! default constructor
   dia_tMicrophoneStatus() :
      ConnectionStatus(DIA_EN_MICROPHONE_CONNECTION_UNKNOWN),
      Mic_num(DIA_EN_MICROPHONE_UNKNOWN),
      u16CurrentValue(0)
   {}

   //! class constructor
   dia_tMicrophoneStatus(
      dia_eMicrophoneStatus ConnectionStatus_,
      dia_eMicrophoneNumber Mic_num_,
      tU16 u16CurrentValue_
   ) :
      ConnectionStatus(ConnectionStatus_),
      Mic_num(Mic_num_),
      u16CurrentValue(u16CurrentValue_)
   {}
   dia_eMicrophoneStatus ConnectionStatus;
   dia_eMicrophoneNumber Mic_num;
   tU16 u16CurrentValue;
};
struct dia_tBoseAmpSWVersionInfo
{
public:
   //! default constructor
   dia_tBoseAmpSWVersionInfo() :
      LargeVersion(0),
      MiddleVersion(0),
      SmallVersion(0)
   {}

   //! class constructor
   dia_tBoseAmpSWVersionInfo(
      tU8 LargeVersion_,
      tU8 MiddleVersion_,
      tU8 SmallVersion_
   ) :
      LargeVersion(LargeVersion_),
      MiddleVersion(MiddleVersion_),
      SmallVersion(SmallVersion_)
   {}
   tU8 LargeVersion;
   tU8 MiddleVersion;
   tU8 SmallVersion;
};
class dia_IAudio
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_AUDIO; }
public:
   //! obsolete function - don't use anymore. Activates the test tone with a certain frequency and volume. Still available for old projects.
   virtual tDiaResult dia_setAudioTestTone (tU32 frequency, tU8 volume, tU8 channelMask ) = 0;
   //! activates the test tone with a certain frequency and volume for certain channel with DBV
   virtual tDiaResult setAudioTestToneDBV (tU32 frequency, tS16 volume, tU32 channelMask ) = 0;
   //! activates the test tone with a certain frequency and volume for certain channel with DB
   virtual tDiaResult setAudioTestToneDB (tU32 frequency, tS16 volume, tU32 channelMask ) = 0;
   //! activates the test tone with a certain frequency and volume for certain channel with Increment Steps
   virtual tDiaResult setAudioTestToneIncrement (tU32 frequency, tS16 volume, tU32 channelMask ) = 0;
   //! activates Audio Test Tone directly to fully control the audio test tone / no handling via volume level functions
   virtual tDiaResult setAudioTestTone (tU32 frequency, tS16 volume, tU32 channelMask, dia_eAudioVolumeType volumetype ) = 0;
   //! activates the test tone mute DBV
   virtual tDiaResult setAudioTestToneMute (dia_eAudioVolumeType volumetype ) = 0;
   //! obsolete function to set the audio balance (moved to new interface).
   virtual tDiaResult dia_setAudioBalance (tS8 /*balance*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! obsolete function to set the audio fader (moved to new interface).
   virtual tDiaResult dia_setAudioFader (tS8 /*fader*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! get the microphone info
   virtual tDiaResult micPowerSuppyInfo_Get (tU8 mMicNo ) = 0;
   //! register to Bose Amplifier ANC version Info
   virtual tDiaResult regToANCSWVersion ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! register to Bose Amplifier ASC version Info
   virtual tDiaResult regToASCSWVersion ( ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
   //! virtual base class destructor
   virtual ~dia_IAudio( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_AUDIO__ */
