/*****************************************************************************************
*
* \file    IApplicationStateControlListener.h
*
* \brief   listener of IApplicationStateControlListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author gib2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IApplicationStateControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_APPLICATION_STATE_CONTROL_LISTENER__
#define __INCLUDED_DIA_INTERFACE_APPLICATION_STATE_CONTROL_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_APPLICATION_STATE_CONTROL__
#include "dia_IApplicationStateControl.h"
#endif

#define IID_APPLICATION_STATE_CONTROL_LISTENER ((dia::IID) 0x4f46918a)
namespace dia {
/**
 *
 *  \class IApplicationStateControlListener
 *
 */

class IApplicationStateControlListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_APPLICATION_STATE_CONTROL_LISTENER; }
public:
   //! application state change for the given application states is pending
   virtual void onApplicationStateChangePending (ApplicationStateID sourceStateID, ApplicationStateID destinationStateID ) = 0;
   //! application state change for the given application states is done
   virtual void onApplicationStateChanged (ApplicationStateID sourceStateID ) = 0;

protected:
   //! virtual base class destructor
   virtual ~IApplicationStateControlListener( void ) {}
};
/**
 *
 *  \class IApplicationStateControlListenerImpl
 *
 */

class IApplicationStateControlListenerImpl
   : public IApplicationStateControlListener
{
public:
   //! application state change for the given application states is pending
   virtual void onApplicationStateChangePending (ApplicationStateID /*sourceStateID*/, ApplicationStateID /*destinationStateID*/ ) {}
   //! application state change for the given application states is done
   virtual void onApplicationStateChanged (ApplicationStateID /*sourceStateID*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~IApplicationStateControlListenerImpl( void ) {}
};
/**
 *
 *  \class IApplicationStateControlNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class IApplicationStateControlNotifier
   : public IApplicationStateControlListener,
     public dia_Notifier<IApplicationStateControlListener>
{
public:
   //! application state change for the given application states is pending
   virtual void onApplicationStateChangePending (ApplicationStateID sourceStateID, ApplicationStateID destinationStateID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onApplicationStateChangePending(sourceStateID, destinationStateID);
      }
   }
   //! application state change for the given application states is done
   virtual void onApplicationStateChanged (ApplicationStateID sourceStateID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onApplicationStateChanged(sourceStateID);
      }
   }
};

//lint +e665
} /* namespace dia */


#endif /* __INCLUDED_DIA_INTERFACE_APPLICATION_STATE_CONTROL_LISTENER__ */
