/*****************************************************************************************
*
* \file    dia_IADRListener.h
*
* \brief   listener of dia_IADRListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IADR.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_ADR_LISTENER__
#define __INCLUDED_DIA_INTERFACE_ADR_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_ADR__
#include "dia_IADR.h"
#endif

#define IID_ADR_LISTENER ((dia::IID) 0x61eacd98)
/**
 *
 *  \class dia_IADRListener
 *
 */

class dia_IADRListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_ADR_LISTENER; }
public:
   //! forward the given message to the ADR
   virtual void vOnADRContainerMessageResponse (std::vector<tU8>& adrResponse ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IADRListener( void ) {}
};
/**
 *
 *  \class dia_IADRListenerImpl
 *
 */

class dia_IADRListenerImpl
   : public dia_IADRListener
{
public:
   //! forward the given message to the ADR
   virtual void vOnADRContainerMessageResponse (std::vector<tU8>& /*adrResponse*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IADRListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IADRNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IADRNotifier
   : public dia_IADRListener,
     public dia_Notifier<dia_IADRListener>
{
public:
   //! forward the given message to the ADR
   virtual void vOnADRContainerMessageResponse (std::vector<tU8>& adrResponse)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnADRContainerMessageResponse(adrResponse);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_ADR_LISTENER__ */
