/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MOST_TELFITYPES_HEADER
#define MOST_TELFITYPES_HEADER


class most_telfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MOST_Tel_FI message types

fi_tclMessageBase* most_telfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class most_telfi_tclMsgBaseMessage : public most_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   most_telfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

// base class for all most_telfi standard error messages

class most_telfi_tclMsgDefaultError: public most_telfi_tclMsgBaseMessage
{
public:
   // member variables
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   most_fi_tcl_TrailingStream oErrorInfo;
   
   most_telfi_tclMsgDefaultError() : e8ErrorCode(), oErrorInfo() {};
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDefaultError(const most_telfi_tclMsgDefaultError& coRef);
   most_telfi_tclMsgDefaultError& operator=(const most_telfi_tclMsgDefaultError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
};

//=============================================================================

class most_telfi_tclMsgAllocateMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAllocateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAllocateMethodStart& operator=(const most_telfi_tclMsgAllocateMethodStart& coRef);
   most_telfi_tclMsgAllocateMethodStart(const most_telfi_tclMsgAllocateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_telfi_tclMsgAllocateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgAllocateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAllocateError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgAllocateError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAllocateError& operator=(const most_telfi_tclMsgAllocateError& coRef);
   most_telfi_tclMsgAllocateError(const most_telfi_tclMsgAllocateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgAllocateError();

   tBool operator==(const most_telfi_tclMsgAllocateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAllocateMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAllocateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAllocateMethodResult& operator=(const most_telfi_tclMsgAllocateMethodResult& coRef);
   most_telfi_tclMsgAllocateMethodResult(const most_telfi_tclMsgAllocateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   tU16 u16BlockWidth;
   tU16 u16ConnectionLabel;
   virtual ~most_telfi_tclMsgAllocateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgAllocateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeAllocateMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDeAllocateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDeAllocateMethodStart& operator=(const most_telfi_tclMsgDeAllocateMethodStart& coRef);
   most_telfi_tclMsgDeAllocateMethodStart(const most_telfi_tclMsgDeAllocateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_telfi_tclMsgDeAllocateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgDeAllocateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeAllocateError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgDeAllocateError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDeAllocateError& operator=(const most_telfi_tclMsgDeAllocateError& coRef);
   most_telfi_tclMsgDeAllocateError(const most_telfi_tclMsgDeAllocateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgDeAllocateError();

   tBool operator==(const most_telfi_tclMsgDeAllocateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeAllocateMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDeAllocateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDeAllocateMethodResult& operator=(const most_telfi_tclMsgDeAllocateMethodResult& coRef);
   most_telfi_tclMsgDeAllocateMethodResult(const most_telfi_tclMsgDeAllocateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_telfi_tclMsgDeAllocateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgDeAllocateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceActivityMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSourceActivityMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSourceActivityMethodStart& operator=(const most_telfi_tclMsgSourceActivityMethodStart& coRef);
   most_telfi_tclMsgSourceActivityMethodStart(const most_telfi_tclMsgSourceActivityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   most_fi_tcl_e8_SrcActivity e8Activity;
   virtual ~most_telfi_tclMsgSourceActivityMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSourceActivityMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceActivityError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSourceActivityError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSourceActivityError& operator=(const most_telfi_tclMsgSourceActivityError& coRef);
   most_telfi_tclMsgSourceActivityError(const most_telfi_tclMsgSourceActivityError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSourceActivityError();

   tBool operator==(const most_telfi_tclMsgSourceActivityError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceActivityMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSourceActivityMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSourceActivityMethodResult& operator=(const most_telfi_tclMsgSourceActivityMethodResult& coRef);
   most_telfi_tclMsgSourceActivityMethodResult(const most_telfi_tclMsgSourceActivityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   most_fi_tcl_e8_SrcActivity e8Activity;
   virtual ~most_telfi_tclMsgSourceActivityMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSourceActivityMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAcceptCallMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAcceptCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAcceptCallMethodStart& operator=(const most_telfi_tclMsgAcceptCallMethodStart& coRef);
   most_telfi_tclMsgAcceptCallMethodStart(const most_telfi_tclMsgAcceptCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgAcceptCallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgAcceptCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAcceptCallError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgAcceptCallError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAcceptCallError& operator=(const most_telfi_tclMsgAcceptCallError& coRef);
   most_telfi_tclMsgAcceptCallError(const most_telfi_tclMsgAcceptCallError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgAcceptCallError();

   tBool operator==(const most_telfi_tclMsgAcceptCallError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAcceptCallMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAcceptCallMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAcceptCallMethodResult& operator=(const most_telfi_tclMsgAcceptCallMethodResult& coRef);
   most_telfi_tclMsgAcceptCallMethodResult(const most_telfi_tclMsgAcceptCallMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgAcceptCallMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgAcceptCallMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCancelOutgoingCallMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCancelOutgoingCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCancelOutgoingCallMethodStart& operator=(const most_telfi_tclMsgCancelOutgoingCallMethodStart& coRef);
   most_telfi_tclMsgCancelOutgoingCallMethodStart(const most_telfi_tclMsgCancelOutgoingCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgCancelOutgoingCallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgCancelOutgoingCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCancelOutgoingCallError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgCancelOutgoingCallError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCancelOutgoingCallError& operator=(const most_telfi_tclMsgCancelOutgoingCallError& coRef);
   most_telfi_tclMsgCancelOutgoingCallError(const most_telfi_tclMsgCancelOutgoingCallError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgCancelOutgoingCallError();

   tBool operator==(const most_telfi_tclMsgCancelOutgoingCallError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCancelOutgoingCallMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCancelOutgoingCallMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCancelOutgoingCallMethodResult& operator=(const most_telfi_tclMsgCancelOutgoingCallMethodResult& coRef);
   most_telfi_tclMsgCancelOutgoingCallMethodResult(const most_telfi_tclMsgCancelOutgoingCallMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgCancelOutgoingCallMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgCancelOutgoingCallMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgConferenceInMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgConferenceInMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgConferenceInMethodStart& operator=(const most_telfi_tclMsgConferenceInMethodStart& coRef);
   most_telfi_tclMsgConferenceInMethodStart(const most_telfi_tclMsgConferenceInMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelStreamOfCallInstances oStreamOfCallInstances;
   virtual ~most_telfi_tclMsgConferenceInMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgConferenceInMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgConferenceInError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgConferenceInError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgConferenceInError& operator=(const most_telfi_tclMsgConferenceInError& coRef);
   most_telfi_tclMsgConferenceInError(const most_telfi_tclMsgConferenceInError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgConferenceInError();

   tBool operator==(const most_telfi_tclMsgConferenceInError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgConferenceInMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgConferenceInMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgConferenceInMethodResult& operator=(const most_telfi_tclMsgConferenceInMethodResult& coRef);
   most_telfi_tclMsgConferenceInMethodResult(const most_telfi_tclMsgConferenceInMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelStreamOfCallInstances oStreamOfCallInstances;
   virtual ~most_telfi_tclMsgConferenceInMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgConferenceInMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHangUpCallMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHangUpCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHangUpCallMethodStart& operator=(const most_telfi_tclMsgHangUpCallMethodStart& coRef);
   most_telfi_tclMsgHangUpCallMethodStart(const most_telfi_tclMsgHangUpCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgHangUpCallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgHangUpCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHangUpCallError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgHangUpCallError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHangUpCallError& operator=(const most_telfi_tclMsgHangUpCallError& coRef);
   most_telfi_tclMsgHangUpCallError(const most_telfi_tclMsgHangUpCallError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgHangUpCallError();

   tBool operator==(const most_telfi_tclMsgHangUpCallError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHangUpCallMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHangUpCallMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHangUpCallMethodResult& operator=(const most_telfi_tclMsgHangUpCallMethodResult& coRef);
   most_telfi_tclMsgHangUpCallMethodResult(const most_telfi_tclMsgHangUpCallMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgHangUpCallMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgHangUpCallMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHoldCallMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHoldCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHoldCallMethodStart& operator=(const most_telfi_tclMsgHoldCallMethodStart& coRef);
   most_telfi_tclMsgHoldCallMethodStart(const most_telfi_tclMsgHoldCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgHoldCallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgHoldCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHoldCallError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgHoldCallError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHoldCallError& operator=(const most_telfi_tclMsgHoldCallError& coRef);
   most_telfi_tclMsgHoldCallError(const most_telfi_tclMsgHoldCallError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgHoldCallError();

   tBool operator==(const most_telfi_tclMsgHoldCallError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHoldCallMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHoldCallMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHoldCallMethodResult& operator=(const most_telfi_tclMsgHoldCallMethodResult& coRef);
   most_telfi_tclMsgHoldCallMethodResult(const most_telfi_tclMsgHoldCallMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgHoldCallMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgHoldCallMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgIgnoreCallMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgIgnoreCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgIgnoreCallMethodStart& operator=(const most_telfi_tclMsgIgnoreCallMethodStart& coRef);
   most_telfi_tclMsgIgnoreCallMethodStart(const most_telfi_tclMsgIgnoreCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgIgnoreCallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgIgnoreCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgIgnoreCallError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgIgnoreCallError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgIgnoreCallError& operator=(const most_telfi_tclMsgIgnoreCallError& coRef);
   most_telfi_tclMsgIgnoreCallError(const most_telfi_tclMsgIgnoreCallError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgIgnoreCallError();

   tBool operator==(const most_telfi_tclMsgIgnoreCallError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgIgnoreCallMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgIgnoreCallMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgIgnoreCallMethodResult& operator=(const most_telfi_tclMsgIgnoreCallMethodResult& coRef);
   most_telfi_tclMsgIgnoreCallMethodResult(const most_telfi_tclMsgIgnoreCallMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgIgnoreCallMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgIgnoreCallMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRejectCallMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRejectCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRejectCallMethodStart& operator=(const most_telfi_tclMsgRejectCallMethodStart& coRef);
   most_telfi_tclMsgRejectCallMethodStart(const most_telfi_tclMsgRejectCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgRejectCallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgRejectCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRejectCallError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgRejectCallError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRejectCallError& operator=(const most_telfi_tclMsgRejectCallError& coRef);
   most_telfi_tclMsgRejectCallError(const most_telfi_tclMsgRejectCallError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgRejectCallError();

   tBool operator==(const most_telfi_tclMsgRejectCallError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRejectCallMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRejectCallMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRejectCallMethodResult& operator=(const most_telfi_tclMsgRejectCallMethodResult& coRef);
   most_telfi_tclMsgRejectCallMethodResult(const most_telfi_tclMsgRejectCallMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgRejectCallMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgRejectCallMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgResumeCallMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgResumeCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgResumeCallMethodStart& operator=(const most_telfi_tclMsgResumeCallMethodStart& coRef);
   most_telfi_tclMsgResumeCallMethodStart(const most_telfi_tclMsgResumeCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgResumeCallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgResumeCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgResumeCallError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgResumeCallError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgResumeCallError& operator=(const most_telfi_tclMsgResumeCallError& coRef);
   most_telfi_tclMsgResumeCallError(const most_telfi_tclMsgResumeCallError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgResumeCallError();

   tBool operator==(const most_telfi_tclMsgResumeCallError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgResumeCallMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgResumeCallMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgResumeCallMethodResult& operator=(const most_telfi_tclMsgResumeCallMethodResult& coRef);
   most_telfi_tclMsgResumeCallMethodResult(const most_telfi_tclMsgResumeCallMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgResumeCallMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgResumeCallMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSendDTMFMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSendDTMFMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSendDTMFMethodStart& operator=(const most_telfi_tclMsgSendDTMFMethodStart& coRef);
   most_telfi_tclMsgSendDTMFMethodStart(const most_telfi_tclMsgSendDTMFMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_String sDTMFChar;
   virtual ~most_telfi_tclMsgSendDTMFMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSendDTMFMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSendDTMFError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSendDTMFError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSendDTMFError& operator=(const most_telfi_tclMsgSendDTMFError& coRef);
   most_telfi_tclMsgSendDTMFError(const most_telfi_tclMsgSendDTMFError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSendDTMFError();

   tBool operator==(const most_telfi_tclMsgSendDTMFError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSendDTMFMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSendDTMFMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSendDTMFMethodResult& operator=(const most_telfi_tclMsgSendDTMFMethodResult& coRef);
   most_telfi_tclMsgSendDTMFMethodResult(const most_telfi_tclMsgSendDTMFMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   tBool bCommandStatus;
   virtual ~most_telfi_tclMsgSendDTMFMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSendDTMFMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSpeedDialMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSpeedDialMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSpeedDialMethodStart& operator=(const most_telfi_tclMsgSpeedDialMethodStart& coRef);
   most_telfi_tclMsgSpeedDialMethodStart(const most_telfi_tclMsgSpeedDialMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 s8MemoryDialParam;
   virtual ~most_telfi_tclMsgSpeedDialMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSpeedDialMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSpeedDialError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSpeedDialError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSpeedDialError& operator=(const most_telfi_tclMsgSpeedDialError& coRef);
   most_telfi_tclMsgSpeedDialError(const most_telfi_tclMsgSpeedDialError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSpeedDialError();

   tBool operator==(const most_telfi_tclMsgSpeedDialError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSpeedDialMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSpeedDialMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSpeedDialMethodResult& operator=(const most_telfi_tclMsgSpeedDialMethodResult& coRef);
   most_telfi_tclMsgSpeedDialMethodResult(const most_telfi_tclMsgSpeedDialMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgSpeedDialMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSpeedDialMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSplitCallMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSplitCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSplitCallMethodStart& operator=(const most_telfi_tclMsgSplitCallMethodStart& coRef);
   most_telfi_tclMsgSplitCallMethodStart(const most_telfi_tclMsgSplitCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgSplitCallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSplitCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSplitCallError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSplitCallError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSplitCallError& operator=(const most_telfi_tclMsgSplitCallError& coRef);
   most_telfi_tclMsgSplitCallError(const most_telfi_tclMsgSplitCallError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSplitCallError();

   tBool operator==(const most_telfi_tclMsgSplitCallError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSplitCallMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSplitCallMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSplitCallMethodResult& operator=(const most_telfi_tclMsgSplitCallMethodResult& coRef);
   most_telfi_tclMsgSplitCallMethodResult(const most_telfi_tclMsgSplitCallMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgSplitCallMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSplitCallMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSwapCallMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSwapCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSwapCallMethodStart& operator=(const most_telfi_tclMsgSwapCallMethodStart& coRef);
   most_telfi_tclMsgSwapCallMethodStart(const most_telfi_tclMsgSwapCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelStreamOfCallInstances oStreamOfCallInstances;
   virtual ~most_telfi_tclMsgSwapCallMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSwapCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSwapCallError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSwapCallError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSwapCallError& operator=(const most_telfi_tclMsgSwapCallError& coRef);
   most_telfi_tclMsgSwapCallError(const most_telfi_tclMsgSwapCallError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSwapCallError();

   tBool operator==(const most_telfi_tclMsgSwapCallError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSwapCallMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSwapCallMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSwapCallMethodResult& operator=(const most_telfi_tclMsgSwapCallMethodResult& coRef);
   most_telfi_tclMsgSwapCallMethodResult(const most_telfi_tclMsgSwapCallMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   virtual ~most_telfi_tclMsgSwapCallMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSwapCallMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgTransferCallToHandsetMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgTransferCallToHandsetMethodStart();

   virtual ~most_telfi_tclMsgTransferCallToHandsetMethodStart();

   inline tBool operator==(const most_telfi_tclMsgTransferCallToHandsetMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgTransferCallToHandsetError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgTransferCallToHandsetError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgTransferCallToHandsetError& operator=(const most_telfi_tclMsgTransferCallToHandsetError& coRef);
   most_telfi_tclMsgTransferCallToHandsetError(const most_telfi_tclMsgTransferCallToHandsetError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgTransferCallToHandsetError();

   tBool operator==(const most_telfi_tclMsgTransferCallToHandsetError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgTransferCallToHandsetMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgTransferCallToHandsetMethodResult();

   virtual ~most_telfi_tclMsgTransferCallToHandsetMethodResult();

   inline tBool operator==(const most_telfi_tclMsgTransferCallToHandsetMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgTransferCallToVehicleMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgTransferCallToVehicleMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgTransferCallToVehicleMethodStart& operator=(const most_telfi_tclMsgTransferCallToVehicleMethodStart& coRef);
   most_telfi_tclMsgTransferCallToVehicleMethodStart(const most_telfi_tclMsgTransferCallToVehicleMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgTransferCallToVehicleMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgTransferCallToVehicleMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgTransferCallToVehicleError : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgTransferCallToVehicleError();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgTransferCallToVehicleError& operator=(const most_telfi_tclMsgTransferCallToVehicleError& coRef);
   most_telfi_tclMsgTransferCallToVehicleError(const most_telfi_tclMsgTransferCallToVehicleError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TrailingStream oErrorInfo;
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   virtual ~most_telfi_tclMsgTransferCallToVehicleError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgTransferCallToVehicleError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgTransferCallToVehicleMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgTransferCallToVehicleMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgTransferCallToVehicleMethodResult& operator=(const most_telfi_tclMsgTransferCallToVehicleMethodResult& coRef);
   most_telfi_tclMsgTransferCallToVehicleMethodResult(const most_telfi_tclMsgTransferCallToVehicleMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bUsingVehicleAudio;
   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgTransferCallToVehicleMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgTransferCallToVehicleMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgVoiceMailMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgVoiceMailMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgVoiceMailMethodStart& operator=(const most_telfi_tclMsgVoiceMailMethodStart& coRef);
   most_telfi_tclMsgVoiceMailMethodStart(const most_telfi_tclMsgVoiceMailMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sDeviceName;
   virtual ~most_telfi_tclMsgVoiceMailMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgVoiceMailMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgVoiceMailError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgVoiceMailError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgVoiceMailError& operator=(const most_telfi_tclMsgVoiceMailError& coRef);
   most_telfi_tclMsgVoiceMailError(const most_telfi_tclMsgVoiceMailError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgVoiceMailError();

   tBool operator==(const most_telfi_tclMsgVoiceMailError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgVoiceMailMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgVoiceMailMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgVoiceMailMethodResult& operator=(const most_telfi_tclMsgVoiceMailMethodResult& coRef);
   most_telfi_tclMsgVoiceMailMethodResult(const most_telfi_tclMsgVoiceMailMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sVoiceMailNumber;
   virtual ~most_telfi_tclMsgVoiceMailMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgVoiceMailMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDialMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDialMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDialMethodStart& operator=(const most_telfi_tclMsgDialMethodStart& coRef);
   most_telfi_tclMsgDialMethodStart(const most_telfi_tclMsgDialMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sTelephoneNumber;
   most_fi_tcl_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting;
   virtual ~most_telfi_tclMsgDialMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgDialMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDialError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgDialError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDialError& operator=(const most_telfi_tclMsgDialError& coRef);
   most_telfi_tclMsgDialError(const most_telfi_tclMsgDialError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgDialError();

   tBool operator==(const most_telfi_tclMsgDialError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDialMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDialMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDialMethodResult& operator=(const most_telfi_tclMsgDialMethodResult& coRef);
   most_telfi_tclMsgDialMethodResult(const most_telfi_tclMsgDialMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgDialMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgDialMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgQueryTelephoneNumberMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgQueryTelephoneNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgQueryTelephoneNumberMethodStart& operator=(const most_telfi_tclMsgQueryTelephoneNumberMethodStart& coRef);
   most_telfi_tclMsgQueryTelephoneNumberMethodStart(const most_telfi_tclMsgQueryTelephoneNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   virtual ~most_telfi_tclMsgQueryTelephoneNumberMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgQueryTelephoneNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgQueryTelephoneNumberError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgQueryTelephoneNumberError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgQueryTelephoneNumberError& operator=(const most_telfi_tclMsgQueryTelephoneNumberError& coRef);
   most_telfi_tclMsgQueryTelephoneNumberError(const most_telfi_tclMsgQueryTelephoneNumberError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgQueryTelephoneNumberError();

   tBool operator==(const most_telfi_tclMsgQueryTelephoneNumberError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgQueryTelephoneNumberMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgQueryTelephoneNumberMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgQueryTelephoneNumberMethodResult& operator=(const most_telfi_tclMsgQueryTelephoneNumberMethodResult& coRef);
   most_telfi_tclMsgQueryTelephoneNumberMethodResult(const most_telfi_tclMsgQueryTelephoneNumberMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_String sTelephoneNumber;
   virtual ~most_telfi_tclMsgQueryTelephoneNumberMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgQueryTelephoneNumberMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAcquireTelephoneNumberMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAcquireTelephoneNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAcquireTelephoneNumberMethodStart& operator=(const most_telfi_tclMsgAcquireTelephoneNumberMethodStart& coRef);
   most_telfi_tclMsgAcquireTelephoneNumberMethodStart(const most_telfi_tclMsgAcquireTelephoneNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgAcquireTelephoneNumberMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgAcquireTelephoneNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAcquireTelephoneNumberError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgAcquireTelephoneNumberError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAcquireTelephoneNumberError& operator=(const most_telfi_tclMsgAcquireTelephoneNumberError& coRef);
   most_telfi_tclMsgAcquireTelephoneNumberError(const most_telfi_tclMsgAcquireTelephoneNumberError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgAcquireTelephoneNumberError();

   tBool operator==(const most_telfi_tclMsgAcquireTelephoneNumberError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAcquireTelephoneNumberMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAcquireTelephoneNumberMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAcquireTelephoneNumberMethodResult& operator=(const most_telfi_tclMsgAcquireTelephoneNumberMethodResult& coRef);
   most_telfi_tclMsgAcquireTelephoneNumberMethodResult(const most_telfi_tclMsgAcquireTelephoneNumberMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sTelephoneNumber;
   virtual ~most_telfi_tclMsgAcquireTelephoneNumberMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgAcquireTelephoneNumberMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRedialMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRedialMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRedialMethodStart& operator=(const most_telfi_tclMsgRedialMethodStart& coRef);
   most_telfi_tclMsgRedialMethodStart(const most_telfi_tclMsgRedialMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting;
   virtual ~most_telfi_tclMsgRedialMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgRedialMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRedialError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgRedialError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRedialError& operator=(const most_telfi_tclMsgRedialError& coRef);
   most_telfi_tclMsgRedialError(const most_telfi_tclMsgRedialError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgRedialError();

   tBool operator==(const most_telfi_tclMsgRedialError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRedialMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRedialMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRedialMethodResult& operator=(const most_telfi_tclMsgRedialMethodResult& coRef);
   most_telfi_tclMsgRedialMethodResult(const most_telfi_tclMsgRedialMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgRedialMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgRedialMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSetRingtoneMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSetRingtoneMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSetRingtoneMethodStart& operator=(const most_telfi_tclMsgSetRingtoneMethodStart& coRef);
   most_telfi_tclMsgSetRingtoneMethodStart(const most_telfi_tclMsgSetRingtoneMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   tU8 u8RingtoneID;
   virtual ~most_telfi_tclMsgSetRingtoneMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSetRingtoneMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSetRingtoneMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSetRingtoneMethodResult();

   virtual ~most_telfi_tclMsgSetRingtoneMethodResult();

   inline tBool operator==(const most_telfi_tclMsgSetRingtoneMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSetRingtoneError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSetRingtoneError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSetRingtoneError& operator=(const most_telfi_tclMsgSetRingtoneError& coRef);
   most_telfi_tclMsgSetRingtoneError(const most_telfi_tclMsgSetRingtoneError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSetRingtoneError();

   tBool operator==(const most_telfi_tclMsgSetRingtoneError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgPlayRingtoneMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgPlayRingtoneMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgPlayRingtoneMethodStart& operator=(const most_telfi_tclMsgPlayRingtoneMethodStart& coRef);
   most_telfi_tclMsgPlayRingtoneMethodStart(const most_telfi_tclMsgPlayRingtoneMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8RingtoneID;
   tU8 u8PlayCount;
   virtual ~most_telfi_tclMsgPlayRingtoneMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgPlayRingtoneMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgPlayRingtoneMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgPlayRingtoneMethodResult();

   virtual ~most_telfi_tclMsgPlayRingtoneMethodResult();

   inline tBool operator==(const most_telfi_tclMsgPlayRingtoneMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgPlayRingtoneError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgPlayRingtoneError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgPlayRingtoneError& operator=(const most_telfi_tclMsgPlayRingtoneError& coRef);
   most_telfi_tclMsgPlayRingtoneError(const most_telfi_tclMsgPlayRingtoneError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgPlayRingtoneError();

   tBool operator==(const most_telfi_tclMsgPlayRingtoneError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgStopRingtoneMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgStopRingtoneMethodStart();

   virtual ~most_telfi_tclMsgStopRingtoneMethodStart();

   inline tBool operator==(const most_telfi_tclMsgStopRingtoneMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgStopRingtoneMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgStopRingtoneMethodResult();

   virtual ~most_telfi_tclMsgStopRingtoneMethodResult();

   inline tBool operator==(const most_telfi_tclMsgStopRingtoneMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgStopRingtoneError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgStopRingtoneError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgStopRingtoneError& operator=(const most_telfi_tclMsgStopRingtoneError& coRef);
   most_telfi_tclMsgStopRingtoneError(const most_telfi_tclMsgStopRingtoneError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgStopRingtoneError();

   tBool operator==(const most_telfi_tclMsgStopRingtoneError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSuppressRingtoneOnOffMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSuppressRingtoneOnOffMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSuppressRingtoneOnOffMethodStart& operator=(const most_telfi_tclMsgSuppressRingtoneOnOffMethodStart& coRef);
   most_telfi_tclMsgSuppressRingtoneOnOffMethodStart(const most_telfi_tclMsgSuppressRingtoneOnOffMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   tBool bSuppressRingtoneState;
   virtual ~most_telfi_tclMsgSuppressRingtoneOnOffMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSuppressRingtoneOnOffMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSuppressRingtoneOnOffMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSuppressRingtoneOnOffMethodResult();

   virtual ~most_telfi_tclMsgSuppressRingtoneOnOffMethodResult();

   inline tBool operator==(const most_telfi_tclMsgSuppressRingtoneOnOffMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSuppressRingtoneOnOffError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSuppressRingtoneOnOffError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSuppressRingtoneOnOffError& operator=(const most_telfi_tclMsgSuppressRingtoneOnOffError& coRef);
   most_telfi_tclMsgSuppressRingtoneOnOffError(const most_telfi_tclMsgSuppressRingtoneOnOffError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSuppressRingtoneOnOffError();

   tBool operator==(const most_telfi_tclMsgSuppressRingtoneOnOffError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAutoWaitingModeOnOffMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAutoWaitingModeOnOffMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAutoWaitingModeOnOffMethodStart& operator=(const most_telfi_tclMsgAutoWaitingModeOnOffMethodStart& coRef);
   most_telfi_tclMsgAutoWaitingModeOnOffMethodStart(const most_telfi_tclMsgAutoWaitingModeOnOffMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   tBool bAutoWaitingModeState;
   virtual ~most_telfi_tclMsgAutoWaitingModeOnOffMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgAutoWaitingModeOnOffMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAutoWaitingModeOnOffMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAutoWaitingModeOnOffMethodResult();

   virtual ~most_telfi_tclMsgAutoWaitingModeOnOffMethodResult();

   inline tBool operator==(const most_telfi_tclMsgAutoWaitingModeOnOffMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAutoWaitingModeOnOffError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgAutoWaitingModeOnOffError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAutoWaitingModeOnOffError& operator=(const most_telfi_tclMsgAutoWaitingModeOnOffError& coRef);
   most_telfi_tclMsgAutoWaitingModeOnOffError(const most_telfi_tclMsgAutoWaitingModeOnOffError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgAutoWaitingModeOnOffError();

   tBool operator==(const most_telfi_tclMsgAutoWaitingModeOnOffError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgStartStopWaitingModeMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgStartStopWaitingModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgStartStopWaitingModeMethodStart& operator=(const most_telfi_tclMsgStartStopWaitingModeMethodStart& coRef);
   most_telfi_tclMsgStartStopWaitingModeMethodStart(const most_telfi_tclMsgStartStopWaitingModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_TelWaitingModeAction e8WaitingModeAction;
   virtual ~most_telfi_tclMsgStartStopWaitingModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgStartStopWaitingModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgStartStopWaitingModeError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgStartStopWaitingModeError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgStartStopWaitingModeError& operator=(const most_telfi_tclMsgStartStopWaitingModeError& coRef);
   most_telfi_tclMsgStartStopWaitingModeError(const most_telfi_tclMsgStartStopWaitingModeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgStartStopWaitingModeError();

   tBool operator==(const most_telfi_tclMsgStartStopWaitingModeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgStartStopWaitingModeMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgStartStopWaitingModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgStartStopWaitingModeMethodResult& operator=(const most_telfi_tclMsgStartStopWaitingModeMethodResult& coRef);
   most_telfi_tclMsgStartStopWaitingModeMethodResult(const most_telfi_tclMsgStartStopWaitingModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_TelWaitingModeStatus e8WaitingModeStatus;
   virtual ~most_telfi_tclMsgStartStopWaitingModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgStartStopWaitingModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDialExtendedMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDialExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDialExtendedMethodStart& operator=(const most_telfi_tclMsgDialExtendedMethodStart& coRef);
   most_telfi_tclMsgDialExtendedMethodStart(const most_telfi_tclMsgDialExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sTelephoneNumber;
   most_fi_tcl_String sName;
   most_fi_tcl_e8_TelEchoCancellationNoiseReductionSetting e8EchoCancellationNoiseReductionSetting;
   virtual ~most_telfi_tclMsgDialExtendedMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgDialExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDialExtendedError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgDialExtendedError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDialExtendedError& operator=(const most_telfi_tclMsgDialExtendedError& coRef);
   most_telfi_tclMsgDialExtendedError(const most_telfi_tclMsgDialExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgDialExtendedError();

   tBool operator==(const most_telfi_tclMsgDialExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDialExtendedMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDialExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDialExtendedMethodResult& operator=(const most_telfi_tclMsgDialExtendedMethodResult& coRef);
   most_telfi_tclMsgDialExtendedMethodResult(const most_telfi_tclMsgDialExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16CallInstance;
   most_fi_tcl_e8_TelCallStatus e8CallStatus;
   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgDialExtendedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgDialExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSetActivePhoneMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSetActivePhoneMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSetActivePhoneMethodStart& operator=(const most_telfi_tclMsgSetActivePhoneMethodStart& coRef);
   most_telfi_tclMsgSetActivePhoneMethodStart(const most_telfi_tclMsgSetActivePhoneMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgSetActivePhoneMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSetActivePhoneMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSetActivePhoneError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSetActivePhoneError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSetActivePhoneError& operator=(const most_telfi_tclMsgSetActivePhoneError& coRef);
   most_telfi_tclMsgSetActivePhoneError(const most_telfi_tclMsgSetActivePhoneError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSetActivePhoneError();

   tBool operator==(const most_telfi_tclMsgSetActivePhoneError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSetActivePhoneMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSetActivePhoneMethodResult();

   virtual ~most_telfi_tclMsgSetActivePhoneMethodResult();

   inline tBool operator==(const most_telfi_tclMsgSetActivePhoneMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActivateExternalVRMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActivateExternalVRMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgActivateExternalVRMethodStart& operator=(const most_telfi_tclMsgActivateExternalVRMethodStart& coRef);
   most_telfi_tclMsgActivateExternalVRMethodStart(const most_telfi_tclMsgActivateExternalVRMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   virtual ~most_telfi_tclMsgActivateExternalVRMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgActivateExternalVRMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActivateExternalVRError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgActivateExternalVRError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgActivateExternalVRError& operator=(const most_telfi_tclMsgActivateExternalVRError& coRef);
   most_telfi_tclMsgActivateExternalVRError(const most_telfi_tclMsgActivateExternalVRError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgActivateExternalVRError();

   tBool operator==(const most_telfi_tclMsgActivateExternalVRError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActivateExternalVRMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActivateExternalVRMethodResult();

   virtual ~most_telfi_tclMsgActivateExternalVRMethodResult();

   inline tBool operator==(const most_telfi_tclMsgActivateExternalVRMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeActivateExternalVRMethodStart : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDeActivateExternalVRMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDeActivateExternalVRMethodStart& operator=(const most_telfi_tclMsgDeActivateExternalVRMethodStart& coRef);
   most_telfi_tclMsgDeActivateExternalVRMethodStart(const most_telfi_tclMsgDeActivateExternalVRMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   virtual ~most_telfi_tclMsgDeActivateExternalVRMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgDeActivateExternalVRMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeActivateExternalVRError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgDeActivateExternalVRError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDeActivateExternalVRError& operator=(const most_telfi_tclMsgDeActivateExternalVRError& coRef);
   most_telfi_tclMsgDeActivateExternalVRError(const most_telfi_tclMsgDeActivateExternalVRError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgDeActivateExternalVRError();

   tBool operator==(const most_telfi_tclMsgDeActivateExternalVRError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeActivateExternalVRMethodResult : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDeActivateExternalVRMethodResult();

   virtual ~most_telfi_tclMsgDeActivateExternalVRMethodResult();

   inline tBool operator==(const most_telfi_tclMsgDeActivateExternalVRMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceInfoGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSourceInfoGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSourceInfoGet& operator=(const most_telfi_tclMsgSourceInfoGet& coRef);
   most_telfi_tclMsgSourceInfoGet(const most_telfi_tclMsgSourceInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_telfi_tclMsgSourceInfoGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSourceInfoGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceInfoError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSourceInfoError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSourceInfoError& operator=(const most_telfi_tclMsgSourceInfoError& coRef);
   most_telfi_tclMsgSourceInfoError(const most_telfi_tclMsgSourceInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSourceInfoError();

   tBool operator==(const most_telfi_tclMsgSourceInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceInfoStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSourceInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSourceInfoStatus& operator=(const most_telfi_tclMsgSourceInfoStatus& coRef);
   most_telfi_tclMsgSourceInfoStatus(const most_telfi_tclMsgSourceInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   tU16 u16BlockWidth;
   tU16 u16ConnectionLabel;
   most_fi_tcl_e8_SrcTransmissionClass e8TransmissionClass;
   most_fi_tcl_e8_SrcContentProtection e8ContentProtection;
   most_fi_tcl_e8_SrcContentType e8ContentType;
   most_fi_tcl_SrcContentDescription oContentDescription;
   most_fi_tcl_TrailingStream oTransmissionParameter;
   virtual ~most_telfi_tclMsgSourceInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSourceInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceAvailableUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSourceAvailableUpReg();

   virtual ~most_telfi_tclMsgSourceAvailableUpReg();

   inline tBool operator==(const most_telfi_tclMsgSourceAvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceAvailableRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSourceAvailableRelUpReg();

   virtual ~most_telfi_tclMsgSourceAvailableRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgSourceAvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceAvailableGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSourceAvailableGet();

   virtual ~most_telfi_tclMsgSourceAvailableGet();

   inline tBool operator==(const most_telfi_tclMsgSourceAvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceAvailableError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgSourceAvailableError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSourceAvailableError& operator=(const most_telfi_tclMsgSourceAvailableError& coRef);
   most_telfi_tclMsgSourceAvailableError(const most_telfi_tclMsgSourceAvailableError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgSourceAvailableError();

   tBool operator==(const most_telfi_tclMsgSourceAvailableError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSourceAvailableStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSourceAvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSourceAvailableStatus& operator=(const most_telfi_tclMsgSourceAvailableStatus& coRef);
   most_telfi_tclMsgSourceAvailableStatus(const most_telfi_tclMsgSourceAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSourceAvailable;
   virtual ~most_telfi_tclMsgSourceAvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSourceAvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActiveCallinHandsetUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActiveCallinHandsetUpReg();

   virtual ~most_telfi_tclMsgActiveCallinHandsetUpReg();

   inline tBool operator==(const most_telfi_tclMsgActiveCallinHandsetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActiveCallinHandsetRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActiveCallinHandsetRelUpReg();

   virtual ~most_telfi_tclMsgActiveCallinHandsetRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgActiveCallinHandsetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActiveCallinHandsetGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActiveCallinHandsetGet();

   virtual ~most_telfi_tclMsgActiveCallinHandsetGet();

   inline tBool operator==(const most_telfi_tclMsgActiveCallinHandsetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActiveCallinHandsetError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgActiveCallinHandsetError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgActiveCallinHandsetError& operator=(const most_telfi_tclMsgActiveCallinHandsetError& coRef);
   most_telfi_tclMsgActiveCallinHandsetError(const most_telfi_tclMsgActiveCallinHandsetError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgActiveCallinHandsetError();

   tBool operator==(const most_telfi_tclMsgActiveCallinHandsetError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActiveCallinHandsetStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActiveCallinHandsetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgActiveCallinHandsetStatus& operator=(const most_telfi_tclMsgActiveCallinHandsetStatus& coRef);
   most_telfi_tclMsgActiveCallinHandsetStatus(const most_telfi_tclMsgActiveCallinHandsetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelActiveCallinHandsetStream oActiveCallinHandsetStream;
   virtual ~most_telfi_tclMsgActiveCallinHandsetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgActiveCallinHandsetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallStatusNoticeUpReg();

   virtual ~most_telfi_tclMsgCallStatusNoticeUpReg();

   inline tBool operator==(const most_telfi_tclMsgCallStatusNoticeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallStatusNoticeRelUpReg();

   virtual ~most_telfi_tclMsgCallStatusNoticeRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgCallStatusNoticeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallStatusNoticeGet();

   virtual ~most_telfi_tclMsgCallStatusNoticeGet();

   inline tBool operator==(const most_telfi_tclMsgCallStatusNoticeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgCallStatusNoticeError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCallStatusNoticeError& operator=(const most_telfi_tclMsgCallStatusNoticeError& coRef);
   most_telfi_tclMsgCallStatusNoticeError(const most_telfi_tclMsgCallStatusNoticeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgCallStatusNoticeError();

   tBool operator==(const most_telfi_tclMsgCallStatusNoticeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallStatusNoticeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCallStatusNoticeStatus& operator=(const most_telfi_tclMsgCallStatusNoticeStatus& coRef);
   most_telfi_tclMsgCallStatusNoticeStatus(const most_telfi_tclMsgCallStatusNoticeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelCallStatusNoticeStream oCallStatusNoticeStream;
   virtual ~most_telfi_tclMsgCallStatusNoticeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgCallStatusNoticeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellDeviceNameUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellDeviceNameUpReg();

   virtual ~most_telfi_tclMsgCellDeviceNameUpReg();

   inline tBool operator==(const most_telfi_tclMsgCellDeviceNameUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellDeviceNameRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellDeviceNameRelUpReg();

   virtual ~most_telfi_tclMsgCellDeviceNameRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgCellDeviceNameRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellDeviceNameGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellDeviceNameGet();

   virtual ~most_telfi_tclMsgCellDeviceNameGet();

   inline tBool operator==(const most_telfi_tclMsgCellDeviceNameGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellDeviceNameError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgCellDeviceNameError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCellDeviceNameError& operator=(const most_telfi_tclMsgCellDeviceNameError& coRef);
   most_telfi_tclMsgCellDeviceNameError(const most_telfi_tclMsgCellDeviceNameError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgCellDeviceNameError();

   tBool operator==(const most_telfi_tclMsgCellDeviceNameError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellDeviceNameStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellDeviceNameStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCellDeviceNameStatus& operator=(const most_telfi_tclMsgCellDeviceNameStatus& coRef);
   most_telfi_tclMsgCellDeviceNameStatus(const most_telfi_tclMsgCellDeviceNameStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sDeviceName;
   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgCellDeviceNameStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgCellDeviceNameStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellNetworkStatusUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellNetworkStatusUpReg();

   virtual ~most_telfi_tclMsgCellNetworkStatusUpReg();

   inline tBool operator==(const most_telfi_tclMsgCellNetworkStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellNetworkStatusRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellNetworkStatusRelUpReg();

   virtual ~most_telfi_tclMsgCellNetworkStatusRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgCellNetworkStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellNetworkStatusGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellNetworkStatusGet();

   virtual ~most_telfi_tclMsgCellNetworkStatusGet();

   inline tBool operator==(const most_telfi_tclMsgCellNetworkStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellNetworkStatusError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgCellNetworkStatusError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCellNetworkStatusError& operator=(const most_telfi_tclMsgCellNetworkStatusError& coRef);
   most_telfi_tclMsgCellNetworkStatusError(const most_telfi_tclMsgCellNetworkStatusError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgCellNetworkStatusError();

   tBool operator==(const most_telfi_tclMsgCellNetworkStatusError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellNetworkStatusStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellNetworkStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCellNetworkStatusStatus& operator=(const most_telfi_tclMsgCellNetworkStatusStatus& coRef);
   most_telfi_tclMsgCellNetworkStatusStatus(const most_telfi_tclMsgCellNetworkStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_TelCellService e8CellService;
   tBool bRoamingStatus;
   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgCellNetworkStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgCellNetworkStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellSignalStrengthUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellSignalStrengthUpReg();

   virtual ~most_telfi_tclMsgCellSignalStrengthUpReg();

   inline tBool operator==(const most_telfi_tclMsgCellSignalStrengthUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellSignalStrengthRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellSignalStrengthRelUpReg();

   virtual ~most_telfi_tclMsgCellSignalStrengthRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgCellSignalStrengthRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellSignalStrengthGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellSignalStrengthGet();

   virtual ~most_telfi_tclMsgCellSignalStrengthGet();

   inline tBool operator==(const most_telfi_tclMsgCellSignalStrengthGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellSignalStrengthError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgCellSignalStrengthError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCellSignalStrengthError& operator=(const most_telfi_tclMsgCellSignalStrengthError& coRef);
   most_telfi_tclMsgCellSignalStrengthError(const most_telfi_tclMsgCellSignalStrengthError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgCellSignalStrengthError();

   tBool operator==(const most_telfi_tclMsgCellSignalStrengthError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellSignalStrengthStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellSignalStrengthStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCellSignalStrengthStatus& operator=(const most_telfi_tclMsgCellSignalStrengthStatus& coRef);
   most_telfi_tclMsgCellSignalStrengthStatus(const most_telfi_tclMsgCellSignalStrengthStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SignalSrength;
   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgCellSignalStrengthStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgCellSignalStrengthStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellStateofChargeUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellStateofChargeUpReg();

   virtual ~most_telfi_tclMsgCellStateofChargeUpReg();

   inline tBool operator==(const most_telfi_tclMsgCellStateofChargeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellStateofChargeRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellStateofChargeRelUpReg();

   virtual ~most_telfi_tclMsgCellStateofChargeRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgCellStateofChargeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellStateofChargeGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellStateofChargeGet();

   virtual ~most_telfi_tclMsgCellStateofChargeGet();

   inline tBool operator==(const most_telfi_tclMsgCellStateofChargeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellStateofChargeError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgCellStateofChargeError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCellStateofChargeError& operator=(const most_telfi_tclMsgCellStateofChargeError& coRef);
   most_telfi_tclMsgCellStateofChargeError(const most_telfi_tclMsgCellStateofChargeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgCellStateofChargeError();

   tBool operator==(const most_telfi_tclMsgCellStateofChargeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCellStateofChargeStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCellStateofChargeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCellStateofChargeStatus& operator=(const most_telfi_tclMsgCellStateofChargeStatus& coRef);
   most_telfi_tclMsgCellStateofChargeStatus(const most_telfi_tclMsgCellStateofChargeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8StateofCharge;
   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgCellStateofChargeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgCellStateofChargeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgInComingCallEventUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgInComingCallEventUpReg();

   virtual ~most_telfi_tclMsgInComingCallEventUpReg();

   inline tBool operator==(const most_telfi_tclMsgInComingCallEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgInComingCallEventRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgInComingCallEventRelUpReg();

   virtual ~most_telfi_tclMsgInComingCallEventRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgInComingCallEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgInComingCallEventGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgInComingCallEventGet();

   virtual ~most_telfi_tclMsgInComingCallEventGet();

   inline tBool operator==(const most_telfi_tclMsgInComingCallEventGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgInComingCallEventError : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgInComingCallEventError();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgInComingCallEventError& operator=(const most_telfi_tclMsgInComingCallEventError& coRef);
   most_telfi_tclMsgInComingCallEventError(const most_telfi_tclMsgInComingCallEventError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TrailingStream oErrorInfo;
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   virtual ~most_telfi_tclMsgInComingCallEventError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgInComingCallEventError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgInComingCallEventStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgInComingCallEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgInComingCallEventStatus& operator=(const most_telfi_tclMsgInComingCallEventStatus& coRef);
   most_telfi_tclMsgInComingCallEventStatus(const most_telfi_tclMsgInComingCallEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_TelIncomingCallEventEnum e8IncomingCallEventEnum;
   tU16 u16CallInstance;
   most_fi_tcl_String sTelephoneNumber;
   most_fi_tcl_String sFirstName;
   most_fi_tcl_String sLastName;
   tBool bCallWait;
   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgInComingCallEventStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgInComingCallEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgNetworkOperatorUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgNetworkOperatorUpReg();

   virtual ~most_telfi_tclMsgNetworkOperatorUpReg();

   inline tBool operator==(const most_telfi_tclMsgNetworkOperatorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgNetworkOperatorRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgNetworkOperatorRelUpReg();

   virtual ~most_telfi_tclMsgNetworkOperatorRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgNetworkOperatorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgNetworkOperatorGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgNetworkOperatorGet();

   virtual ~most_telfi_tclMsgNetworkOperatorGet();

   inline tBool operator==(const most_telfi_tclMsgNetworkOperatorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgNetworkOperatorError : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgNetworkOperatorError();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgNetworkOperatorError& operator=(const most_telfi_tclMsgNetworkOperatorError& coRef);
   most_telfi_tclMsgNetworkOperatorError(const most_telfi_tclMsgNetworkOperatorError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TrailingStream oErrorInfo;
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   virtual ~most_telfi_tclMsgNetworkOperatorError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgNetworkOperatorError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgNetworkOperatorStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgNetworkOperatorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgNetworkOperatorStatus& operator=(const most_telfi_tclMsgNetworkOperatorStatus& coRef);
   most_telfi_tclMsgNetworkOperatorStatus(const most_telfi_tclMsgNetworkOperatorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sNetworkOperator;
   virtual ~most_telfi_tclMsgNetworkOperatorStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgNetworkOperatorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSLCStatusUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSLCStatusUpReg();

   virtual ~most_telfi_tclMsgSLCStatusUpReg();

   inline tBool operator==(const most_telfi_tclMsgSLCStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSLCStatusRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSLCStatusRelUpReg();

   virtual ~most_telfi_tclMsgSLCStatusRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgSLCStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSLCStatusGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSLCStatusGet();

   virtual ~most_telfi_tclMsgSLCStatusGet();

   inline tBool operator==(const most_telfi_tclMsgSLCStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSLCStatusError : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSLCStatusError();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSLCStatusError& operator=(const most_telfi_tclMsgSLCStatusError& coRef);
   most_telfi_tclMsgSLCStatusError(const most_telfi_tclMsgSLCStatusError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TrailingStream oErrorInfo;
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   virtual ~most_telfi_tclMsgSLCStatusError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSLCStatusError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSLCStatusStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSLCStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSLCStatusStatus& operator=(const most_telfi_tclMsgSLCStatusStatus& coRef);
   most_telfi_tclMsgSLCStatusStatus(const most_telfi_tclMsgSLCStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bCommandStatus;
   virtual ~most_telfi_tclMsgSLCStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSLCStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgVehicleAudioUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgVehicleAudioUpReg();

   virtual ~most_telfi_tclMsgVehicleAudioUpReg();

   inline tBool operator==(const most_telfi_tclMsgVehicleAudioUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgVehicleAudioRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgVehicleAudioRelUpReg();

   virtual ~most_telfi_tclMsgVehicleAudioRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgVehicleAudioRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgVehicleAudioGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgVehicleAudioGet();

   virtual ~most_telfi_tclMsgVehicleAudioGet();

   inline tBool operator==(const most_telfi_tclMsgVehicleAudioGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgVehicleAudioError : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgVehicleAudioError();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgVehicleAudioError& operator=(const most_telfi_tclMsgVehicleAudioError& coRef);
   most_telfi_tclMsgVehicleAudioError(const most_telfi_tclMsgVehicleAudioError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TrailingStream oErrorInfo;
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   virtual ~most_telfi_tclMsgVehicleAudioError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgVehicleAudioError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgVehicleAudioStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgVehicleAudioStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgVehicleAudioStatus& operator=(const most_telfi_tclMsgVehicleAudioStatus& coRef);
   most_telfi_tclMsgVehicleAudioStatus(const most_telfi_tclMsgVehicleAudioStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bUsingVehicleAudio;
   virtual ~most_telfi_tclMsgVehicleAudioStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgVehicleAudioStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgMicrophoneMuteStateUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgMicrophoneMuteStateUpReg();

   virtual ~most_telfi_tclMsgMicrophoneMuteStateUpReg();

   inline tBool operator==(const most_telfi_tclMsgMicrophoneMuteStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgMicrophoneMuteStateRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgMicrophoneMuteStateRelUpReg();

   virtual ~most_telfi_tclMsgMicrophoneMuteStateRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgMicrophoneMuteStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgMicrophoneMuteStateGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgMicrophoneMuteStateGet();

   virtual ~most_telfi_tclMsgMicrophoneMuteStateGet();

   inline tBool operator==(const most_telfi_tclMsgMicrophoneMuteStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgMicrophoneMuteStatePureSet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgMicrophoneMuteStatePureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgMicrophoneMuteStatePureSet& operator=(const most_telfi_tclMsgMicrophoneMuteStatePureSet& coRef);
   most_telfi_tclMsgMicrophoneMuteStatePureSet(const most_telfi_tclMsgMicrophoneMuteStatePureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnable;
   virtual ~most_telfi_tclMsgMicrophoneMuteStatePureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgMicrophoneMuteStatePureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgMicrophoneMuteStateError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgMicrophoneMuteStateError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgMicrophoneMuteStateError& operator=(const most_telfi_tclMsgMicrophoneMuteStateError& coRef);
   most_telfi_tclMsgMicrophoneMuteStateError(const most_telfi_tclMsgMicrophoneMuteStateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgMicrophoneMuteStateError();

   tBool operator==(const most_telfi_tclMsgMicrophoneMuteStateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgMicrophoneMuteStateStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgMicrophoneMuteStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgMicrophoneMuteStateStatus& operator=(const most_telfi_tclMsgMicrophoneMuteStateStatus& coRef);
   most_telfi_tclMsgMicrophoneMuteStateStatus(const most_telfi_tclMsgMicrophoneMuteStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnable;
   virtual ~most_telfi_tclMsgMicrophoneMuteStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgMicrophoneMuteStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtoneMuteStateUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRingtoneMuteStateUpReg();

   virtual ~most_telfi_tclMsgRingtoneMuteStateUpReg();

   inline tBool operator==(const most_telfi_tclMsgRingtoneMuteStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtoneMuteStateRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRingtoneMuteStateRelUpReg();

   virtual ~most_telfi_tclMsgRingtoneMuteStateRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgRingtoneMuteStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtoneMuteStateGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRingtoneMuteStateGet();

   virtual ~most_telfi_tclMsgRingtoneMuteStateGet();

   inline tBool operator==(const most_telfi_tclMsgRingtoneMuteStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtoneMuteStatePureSet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRingtoneMuteStatePureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRingtoneMuteStatePureSet& operator=(const most_telfi_tclMsgRingtoneMuteStatePureSet& coRef);
   most_telfi_tclMsgRingtoneMuteStatePureSet(const most_telfi_tclMsgRingtoneMuteStatePureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnable;
   virtual ~most_telfi_tclMsgRingtoneMuteStatePureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgRingtoneMuteStatePureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtoneMuteStateError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgRingtoneMuteStateError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRingtoneMuteStateError& operator=(const most_telfi_tclMsgRingtoneMuteStateError& coRef);
   most_telfi_tclMsgRingtoneMuteStateError(const most_telfi_tclMsgRingtoneMuteStateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgRingtoneMuteStateError();

   tBool operator==(const most_telfi_tclMsgRingtoneMuteStateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtoneMuteStateStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRingtoneMuteStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRingtoneMuteStateStatus& operator=(const most_telfi_tclMsgRingtoneMuteStateStatus& coRef);
   most_telfi_tclMsgRingtoneMuteStateStatus(const most_telfi_tclMsgRingtoneMuteStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnable;
   virtual ~most_telfi_tclMsgRingtoneMuteStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgRingtoneMuteStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHFServiceUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHFServiceUpReg();

   virtual ~most_telfi_tclMsgHFServiceUpReg();

   inline tBool operator==(const most_telfi_tclMsgHFServiceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHFServiceRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHFServiceRelUpReg();

   virtual ~most_telfi_tclMsgHFServiceRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgHFServiceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHFServiceGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHFServiceGet();

   virtual ~most_telfi_tclMsgHFServiceGet();

   inline tBool operator==(const most_telfi_tclMsgHFServiceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHFServiceError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgHFServiceError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHFServiceError& operator=(const most_telfi_tclMsgHFServiceError& coRef);
   most_telfi_tclMsgHFServiceError(const most_telfi_tclMsgHFServiceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgHFServiceError();

   tBool operator==(const most_telfi_tclMsgHFServiceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHFServiceStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHFServiceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHFServiceStatus& operator=(const most_telfi_tclMsgHFServiceStatus& coRef);
   most_telfi_tclMsgHFServiceStatus(const most_telfi_tclMsgHFServiceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bCallWaitAvail;
   tBool bThreeWayCallAvail;
   virtual ~most_telfi_tclMsgHFServiceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgHFServiceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg();

   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg();

   inline tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg();

   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionGet();

   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionGet();

   inline tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet& operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet& coRef);
   most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet(const most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bBTDeviceVoiceRecActive;
   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgBTDeviceVoiceRecognitionError& operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionError& coRef);
   most_telfi_tclMsgBTDeviceVoiceRecognitionError(const most_telfi_tclMsgBTDeviceVoiceRecognitionError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionError();

   tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgBTDeviceVoiceRecognitionStatus& operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionStatus& coRef);
   most_telfi_tclMsgBTDeviceVoiceRecognitionStatus(const most_telfi_tclMsgBTDeviceVoiceRecognitionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bBTDeviceVoiceRecActive;
   tBool bBTDeviceVoiceRecSupported;
   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg();

   virtual ~most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg();

   inline tBool operator==(const most_telfi_tclMsgHandsFreeEnhancedCallControlUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg();

   virtual ~most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgHandsFreeEnhancedCallControlRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHandsFreeEnhancedCallControlGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHandsFreeEnhancedCallControlGet();

   virtual ~most_telfi_tclMsgHandsFreeEnhancedCallControlGet();

   inline tBool operator==(const most_telfi_tclMsgHandsFreeEnhancedCallControlGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHandsFreeEnhancedCallControlError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgHandsFreeEnhancedCallControlError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHandsFreeEnhancedCallControlError& operator=(const most_telfi_tclMsgHandsFreeEnhancedCallControlError& coRef);
   most_telfi_tclMsgHandsFreeEnhancedCallControlError(const most_telfi_tclMsgHandsFreeEnhancedCallControlError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgHandsFreeEnhancedCallControlError();

   tBool operator==(const most_telfi_tclMsgHandsFreeEnhancedCallControlError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgHandsFreeEnhancedCallControlStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgHandsFreeEnhancedCallControlStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgHandsFreeEnhancedCallControlStatus& operator=(const most_telfi_tclMsgHandsFreeEnhancedCallControlStatus& coRef);
   most_telfi_tclMsgHandsFreeEnhancedCallControlStatus(const most_telfi_tclMsgHandsFreeEnhancedCallControlStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelHFEnhancedCallControlStream oHFEnhancedCallControlStream;
   virtual ~most_telfi_tclMsgHandsFreeEnhancedCallControlStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgHandsFreeEnhancedCallControlStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSystemWideRingtonesListUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSystemWideRingtonesListUpReg();

   virtual ~most_telfi_tclMsgSystemWideRingtonesListUpReg();

   inline tBool operator==(const most_telfi_tclMsgSystemWideRingtonesListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSystemWideRingtonesListRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSystemWideRingtonesListRelUpReg();

   virtual ~most_telfi_tclMsgSystemWideRingtonesListRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgSystemWideRingtonesListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSystemWideRingtonesListGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSystemWideRingtonesListGet();

   virtual ~most_telfi_tclMsgSystemWideRingtonesListGet();

   inline tBool operator==(const most_telfi_tclMsgSystemWideRingtonesListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSystemWideRingtonesListStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSystemWideRingtonesListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSystemWideRingtonesListStatus& operator=(const most_telfi_tclMsgSystemWideRingtonesListStatus& coRef);
   most_telfi_tclMsgSystemWideRingtonesListStatus(const most_telfi_tclMsgSystemWideRingtonesListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ActiveSystemRingtoneID;
   most_fi_tcl_TelSystemWideRingtonesListResult oSystemWideRingtonesListResult;
   virtual ~most_telfi_tclMsgSystemWideRingtonesListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSystemWideRingtonesListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeviceRingtoneListUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDeviceRingtoneListUpReg();

   virtual ~most_telfi_tclMsgDeviceRingtoneListUpReg();

   inline tBool operator==(const most_telfi_tclMsgDeviceRingtoneListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeviceRingtoneListRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDeviceRingtoneListRelUpReg();

   virtual ~most_telfi_tclMsgDeviceRingtoneListRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgDeviceRingtoneListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeviceRingtoneListGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDeviceRingtoneListGet();

   virtual ~most_telfi_tclMsgDeviceRingtoneListGet();

   inline tBool operator==(const most_telfi_tclMsgDeviceRingtoneListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgDeviceRingtoneListStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgDeviceRingtoneListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgDeviceRingtoneListStatus& operator=(const most_telfi_tclMsgDeviceRingtoneListStatus& coRef);
   most_telfi_tclMsgDeviceRingtoneListStatus(const most_telfi_tclMsgDeviceRingtoneListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelDeviceRingtoneListResult oDeviceRingtoneListResult;
   virtual ~most_telfi_tclMsgDeviceRingtoneListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgDeviceRingtoneListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSuppressRingtoneOnOffListUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSuppressRingtoneOnOffListUpReg();

   virtual ~most_telfi_tclMsgSuppressRingtoneOnOffListUpReg();

   inline tBool operator==(const most_telfi_tclMsgSuppressRingtoneOnOffListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg();

   virtual ~most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgSuppressRingtoneOnOffListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSuppressRingtoneOnOffListGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSuppressRingtoneOnOffListGet();

   virtual ~most_telfi_tclMsgSuppressRingtoneOnOffListGet();

   inline tBool operator==(const most_telfi_tclMsgSuppressRingtoneOnOffListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSuppressRingtoneOnOffListStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSuppressRingtoneOnOffListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSuppressRingtoneOnOffListStatus& operator=(const most_telfi_tclMsgSuppressRingtoneOnOffListStatus& coRef);
   most_telfi_tclMsgSuppressRingtoneOnOffListStatus(const most_telfi_tclMsgSuppressRingtoneOnOffListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelSuppressRingtoneOnOffListResult oSuppressRingtoneOnOffListResult;
   virtual ~most_telfi_tclMsgSuppressRingtoneOnOffListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSuppressRingtoneOnOffListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAutoWaitingModeOnOffListUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAutoWaitingModeOnOffListUpReg();

   virtual ~most_telfi_tclMsgAutoWaitingModeOnOffListUpReg();

   inline tBool operator==(const most_telfi_tclMsgAutoWaitingModeOnOffListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg();

   virtual ~most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgAutoWaitingModeOnOffListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAutoWaitingModeOnOffListGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAutoWaitingModeOnOffListGet();

   virtual ~most_telfi_tclMsgAutoWaitingModeOnOffListGet();

   inline tBool operator==(const most_telfi_tclMsgAutoWaitingModeOnOffListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAutoWaitingModeOnOffListStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAutoWaitingModeOnOffListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAutoWaitingModeOnOffListStatus& operator=(const most_telfi_tclMsgAutoWaitingModeOnOffListStatus& coRef);
   most_telfi_tclMsgAutoWaitingModeOnOffListStatus(const most_telfi_tclMsgAutoWaitingModeOnOffListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelAutoWaitingModeOnOffListResult oAutoWaitingModeOnOffListResult;
   virtual ~most_telfi_tclMsgAutoWaitingModeOnOffListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgAutoWaitingModeOnOffListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtonePlaybackStatusUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRingtonePlaybackStatusUpReg();

   virtual ~most_telfi_tclMsgRingtonePlaybackStatusUpReg();

   inline tBool operator==(const most_telfi_tclMsgRingtonePlaybackStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtonePlaybackStatusRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRingtonePlaybackStatusRelUpReg();

   virtual ~most_telfi_tclMsgRingtonePlaybackStatusRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgRingtonePlaybackStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtonePlaybackStatusGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRingtonePlaybackStatusGet();

   virtual ~most_telfi_tclMsgRingtonePlaybackStatusGet();

   inline tBool operator==(const most_telfi_tclMsgRingtonePlaybackStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgRingtonePlaybackStatusStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgRingtonePlaybackStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgRingtonePlaybackStatusStatus& operator=(const most_telfi_tclMsgRingtonePlaybackStatusStatus& coRef);
   most_telfi_tclMsgRingtonePlaybackStatusStatus(const most_telfi_tclMsgRingtonePlaybackStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_TelPlaybackState e8PlaybackState;
   virtual ~most_telfi_tclMsgRingtonePlaybackStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgRingtonePlaybackStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeFilePathUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgWaitingModeFilePathUpReg();

   virtual ~most_telfi_tclMsgWaitingModeFilePathUpReg();

   inline tBool operator==(const most_telfi_tclMsgWaitingModeFilePathUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeFilePathRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgWaitingModeFilePathRelUpReg();

   virtual ~most_telfi_tclMsgWaitingModeFilePathRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgWaitingModeFilePathRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeFilePathGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgWaitingModeFilePathGet();

   virtual ~most_telfi_tclMsgWaitingModeFilePathGet();

   inline tBool operator==(const most_telfi_tclMsgWaitingModeFilePathGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeFilePathPureSet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgWaitingModeFilePathPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgWaitingModeFilePathPureSet& operator=(const most_telfi_tclMsgWaitingModeFilePathPureSet& coRef);
   most_telfi_tclMsgWaitingModeFilePathPureSet(const most_telfi_tclMsgWaitingModeFilePathPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sFilePathNB;
   most_fi_tcl_String sFilePathWB;
   virtual ~most_telfi_tclMsgWaitingModeFilePathPureSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgWaitingModeFilePathPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeFilePathError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgWaitingModeFilePathError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgWaitingModeFilePathError& operator=(const most_telfi_tclMsgWaitingModeFilePathError& coRef);
   most_telfi_tclMsgWaitingModeFilePathError(const most_telfi_tclMsgWaitingModeFilePathError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgWaitingModeFilePathError();

   tBool operator==(const most_telfi_tclMsgWaitingModeFilePathError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeFilePathStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgWaitingModeFilePathStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgWaitingModeFilePathStatus& operator=(const most_telfi_tclMsgWaitingModeFilePathStatus& coRef);
   most_telfi_tclMsgWaitingModeFilePathStatus(const most_telfi_tclMsgWaitingModeFilePathStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sFilePathNB;
   most_fi_tcl_String sFilePathWB;
   virtual ~most_telfi_tclMsgWaitingModeFilePathStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgWaitingModeFilePathStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg();

   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg();

   inline tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg();

   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet();

   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet();

   inline tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet& operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet& coRef);
   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tBool bBTDeviceVoiceRecActive;
   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError& operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError& coRef);
   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError();

   tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus& operator=(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus& coRef);
   most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tBool bBTDeviceVoiceRecActive;
   tBool bBTDeviceVoiceRecSupported;
   most_fi_tcl_e8_TelSiriAvailabilityState e8SiriAvailabilityState;
   virtual ~most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeExtendedUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallStatusNoticeExtendedUpReg();

   virtual ~most_telfi_tclMsgCallStatusNoticeExtendedUpReg();

   inline tBool operator==(const most_telfi_tclMsgCallStatusNoticeExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg();

   virtual ~most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgCallStatusNoticeExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeExtendedGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallStatusNoticeExtendedGet();

   virtual ~most_telfi_tclMsgCallStatusNoticeExtendedGet();

   inline tBool operator==(const most_telfi_tclMsgCallStatusNoticeExtendedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeExtendedError : public most_telfi_tclMsgDefaultError
{
public:

   most_telfi_tclMsgCallStatusNoticeExtendedError() : most_telfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCallStatusNoticeExtendedError& operator=(const most_telfi_tclMsgCallStatusNoticeExtendedError& coRef);
   most_telfi_tclMsgCallStatusNoticeExtendedError(const most_telfi_tclMsgCallStatusNoticeExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_telfi_tclMsgCallStatusNoticeExtendedError();

   tBool operator==(const most_telfi_tclMsgCallStatusNoticeExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallStatusNoticeExtendedStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallStatusNoticeExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCallStatusNoticeExtendedStatus& operator=(const most_telfi_tclMsgCallStatusNoticeExtendedStatus& coRef);
   most_telfi_tclMsgCallStatusNoticeExtendedStatus(const most_telfi_tclMsgCallStatusNoticeExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8TotalCallInstances;
   most_fi_tcl_TelCallStatusNoticeExtendedStream oCallStatusNoticeExtendedStream;
   virtual ~most_telfi_tclMsgCallStatusNoticeExtendedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgCallStatusNoticeExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActivePhoneDeviceUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActivePhoneDeviceUpReg();

   virtual ~most_telfi_tclMsgActivePhoneDeviceUpReg();

   inline tBool operator==(const most_telfi_tclMsgActivePhoneDeviceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActivePhoneDeviceRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActivePhoneDeviceRelUpReg();

   virtual ~most_telfi_tclMsgActivePhoneDeviceRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgActivePhoneDeviceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActivePhoneDeviceGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActivePhoneDeviceGet();

   virtual ~most_telfi_tclMsgActivePhoneDeviceGet();

   inline tBool operator==(const most_telfi_tclMsgActivePhoneDeviceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgActivePhoneDeviceStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgActivePhoneDeviceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgActivePhoneDeviceStatus& operator=(const most_telfi_tclMsgActivePhoneDeviceStatus& coRef);
   most_telfi_tclMsgActivePhoneDeviceStatus(const most_telfi_tclMsgActivePhoneDeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_telfi_tclMsgActivePhoneDeviceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgActivePhoneDeviceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgOutgoingCallFailedEventUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgOutgoingCallFailedEventUpReg();

   virtual ~most_telfi_tclMsgOutgoingCallFailedEventUpReg();

   inline tBool operator==(const most_telfi_tclMsgOutgoingCallFailedEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgOutgoingCallFailedEventRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgOutgoingCallFailedEventRelUpReg();

   virtual ~most_telfi_tclMsgOutgoingCallFailedEventRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgOutgoingCallFailedEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgOutgoingCallFailedEventStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgOutgoingCallFailedEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgOutgoingCallFailedEventStatus& operator=(const most_telfi_tclMsgOutgoingCallFailedEventStatus& coRef);
   most_telfi_tclMsgOutgoingCallFailedEventStatus(const most_telfi_tclMsgOutgoingCallFailedEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelOutgoingCall_Failed oOutgoingFailed;
   virtual ~most_telfi_tclMsgOutgoingCallFailedEventStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgOutgoingCallFailedEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgIncomingCallRejectedEventUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgIncomingCallRejectedEventUpReg();

   virtual ~most_telfi_tclMsgIncomingCallRejectedEventUpReg();

   inline tBool operator==(const most_telfi_tclMsgIncomingCallRejectedEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgIncomingCallRejectedEventRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgIncomingCallRejectedEventRelUpReg();

   virtual ~most_telfi_tclMsgIncomingCallRejectedEventRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgIncomingCallRejectedEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgIncomingCallRejectedEventStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgIncomingCallRejectedEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgIncomingCallRejectedEventStatus& operator=(const most_telfi_tclMsgIncomingCallRejectedEventStatus& coRef);
   most_telfi_tclMsgIncomingCallRejectedEventStatus(const most_telfi_tclMsgIncomingCallRejectedEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_TelIncomingCall_Rejected oIncomingRejected;
   virtual ~most_telfi_tclMsgIncomingCallRejectedEventStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgIncomingCallRejectedEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeStateUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgWaitingModeStateUpReg();

   virtual ~most_telfi_tclMsgWaitingModeStateUpReg();

   inline tBool operator==(const most_telfi_tclMsgWaitingModeStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeStateRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgWaitingModeStateRelUpReg();

   virtual ~most_telfi_tclMsgWaitingModeStateRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgWaitingModeStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeStateGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgWaitingModeStateGet();

   virtual ~most_telfi_tclMsgWaitingModeStateGet();

   inline tBool operator==(const most_telfi_tclMsgWaitingModeStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgWaitingModeStateStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgWaitingModeStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgWaitingModeStateStatus& operator=(const most_telfi_tclMsgWaitingModeStateStatus& coRef);
   most_telfi_tclMsgWaitingModeStateStatus(const most_telfi_tclMsgWaitingModeStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_WaitingModeState e8WaitingModeState;
   virtual ~most_telfi_tclMsgWaitingModeStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgWaitingModeStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgExternalVRStateUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgExternalVRStateUpReg();

   virtual ~most_telfi_tclMsgExternalVRStateUpReg();

   inline tBool operator==(const most_telfi_tclMsgExternalVRStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgExternalVRStateRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgExternalVRStateRelUpReg();

   virtual ~most_telfi_tclMsgExternalVRStateRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgExternalVRStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgExternalVRStateGet : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgExternalVRStateGet();

   virtual ~most_telfi_tclMsgExternalVRStateGet();

   inline tBool operator==(const most_telfi_tclMsgExternalVRStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgExternalVRStateStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgExternalVRStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgExternalVRStateStatus& operator=(const most_telfi_tclMsgExternalVRStateStatus& coRef);
   most_telfi_tclMsgExternalVRStateStatus(const most_telfi_tclMsgExternalVRStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   most_fi_tcl_e8_ExternalVRState e8ExternalVRState;
   most_fi_tcl_e8_VRErrorCode e8VRErrorCode;
   virtual ~most_telfi_tclMsgExternalVRStateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgExternalVRStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallOperationFailedEventUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallOperationFailedEventUpReg();

   virtual ~most_telfi_tclMsgCallOperationFailedEventUpReg();

   inline tBool operator==(const most_telfi_tclMsgCallOperationFailedEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallOperationFailedEventRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallOperationFailedEventRelUpReg();

   virtual ~most_telfi_tclMsgCallOperationFailedEventRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgCallOperationFailedEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgCallOperationFailedEventStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgCallOperationFailedEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgCallOperationFailedEventStatus& operator=(const most_telfi_tclMsgCallOperationFailedEventStatus& coRef);
   most_telfi_tclMsgCallOperationFailedEventStatus(const most_telfi_tclMsgCallOperationFailedEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   most_fi_tcl_String sOperation;
   most_fi_tcl_String sCallOperationFailedReason;
   most_fi_tcl_ListOfCallInstanceStream oListOfCallInstanceStream;
   virtual ~most_telfi_tclMsgCallOperationFailedEventStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgCallOperationFailedEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSendDTMFFailedEventUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSendDTMFFailedEventUpReg();

   virtual ~most_telfi_tclMsgSendDTMFFailedEventUpReg();

   inline tBool operator==(const most_telfi_tclMsgSendDTMFFailedEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSendDTMFFailedEventRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSendDTMFFailedEventRelUpReg();

   virtual ~most_telfi_tclMsgSendDTMFFailedEventRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgSendDTMFFailedEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgSendDTMFFailedEventStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgSendDTMFFailedEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgSendDTMFFailedEventStatus& operator=(const most_telfi_tclMsgSendDTMFFailedEventStatus& coRef);
   most_telfi_tclMsgSendDTMFFailedEventStatus(const most_telfi_tclMsgSendDTMFFailedEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   most_fi_tcl_String sSendDTMFFailedReason;
   virtual ~most_telfi_tclMsgSendDTMFFailedEventStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgSendDTMFFailedEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAudioTransferFailedEventUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAudioTransferFailedEventUpReg();

   virtual ~most_telfi_tclMsgAudioTransferFailedEventUpReg();

   inline tBool operator==(const most_telfi_tclMsgAudioTransferFailedEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAudioTransferFailedEventRelUpReg : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAudioTransferFailedEventRelUpReg();

   virtual ~most_telfi_tclMsgAudioTransferFailedEventRelUpReg();

   inline tBool operator==(const most_telfi_tclMsgAudioTransferFailedEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_telfi_tclMsgAudioTransferFailedEventStatus : public most_telfi_tclMsgBaseMessage
{
public:

   most_telfi_tclMsgAudioTransferFailedEventStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_telfi_tclMsgAudioTransferFailedEventStatus& operator=(const most_telfi_tclMsgAudioTransferFailedEventStatus& coRef);
   most_telfi_tclMsgAudioTransferFailedEventStatus(const most_telfi_tclMsgAudioTransferFailedEventStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   most_fi_tcl_e8_AudioTransferDirection e8AudioDirection;
   virtual ~most_telfi_tclMsgAudioTransferFailedEventStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_telfi_tclMsgAudioTransferFailedEventStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
