/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MOST_PHONBKFITYPES_HEADER
#define MOST_PHONBKFITYPES_HEADER


class most_phonbkfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MOST_PhonBk_FI message types

fi_tclMessageBase* most_phonbkfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class most_phonbkfi_tclMsgBaseMessage : public most_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   most_phonbkfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

// base class for all most_phonbkfi standard error messages

class most_phonbkfi_tclMsgDefaultError: public most_phonbkfi_tclMsgBaseMessage
{
public:
   // member variables
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   most_fi_tcl_TrailingStream oErrorInfo;
   
   most_phonbkfi_tclMsgDefaultError() : e8ErrorCode(), oErrorInfo() {};
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDefaultError(const most_phonbkfi_tclMsgDefaultError& coRef);
   most_phonbkfi_tclMsgDefaultError& operator=(const most_phonbkfi_tclMsgDefaultError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
};

//=============================================================================

class most_phonbkfi_tclMsgStoreFavoriteMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgStoreFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgStoreFavoriteMethodStart& operator=(const most_phonbkfi_tclMsgStoreFavoriteMethodStart& coRef);
   most_phonbkfi_tclMsgStoreFavoriteMethodStart(const most_phonbkfi_tclMsgStoreFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ObjectID;
   virtual ~most_phonbkfi_tclMsgStoreFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgStoreFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgStoreFavoriteError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgStoreFavoriteError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgStoreFavoriteError& operator=(const most_phonbkfi_tclMsgStoreFavoriteError& coRef);
   most_phonbkfi_tclMsgStoreFavoriteError(const most_phonbkfi_tclMsgStoreFavoriteError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgStoreFavoriteError();

   tBool operator==(const most_phonbkfi_tclMsgStoreFavoriteError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgStoreFavoriteMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgStoreFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgStoreFavoriteMethodResult& operator=(const most_phonbkfi_tclMsgStoreFavoriteMethodResult& coRef);
   most_phonbkfi_tclMsgStoreFavoriteMethodResult(const most_phonbkfi_tclMsgStoreFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   virtual ~most_phonbkfi_tclMsgStoreFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgStoreFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgActivateFavoriteMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgActivateFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgActivateFavoriteMethodStart& operator=(const most_phonbkfi_tclMsgActivateFavoriteMethodStart& coRef);
   most_phonbkfi_tclMsgActivateFavoriteMethodStart(const most_phonbkfi_tclMsgActivateFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   most_fi_tcl_e8_FavPrvAudioChannel e8AudioChannel;
   most_fi_tcl_e8_FavPrvVideoChannel e8VideoChannel;
   virtual ~most_phonbkfi_tclMsgActivateFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgActivateFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgActivateFavoriteError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgActivateFavoriteError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgActivateFavoriteError& operator=(const most_phonbkfi_tclMsgActivateFavoriteError& coRef);
   most_phonbkfi_tclMsgActivateFavoriteError(const most_phonbkfi_tclMsgActivateFavoriteError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgActivateFavoriteError();

   tBool operator==(const most_phonbkfi_tclMsgActivateFavoriteError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgActivateFavoriteMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgActivateFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgActivateFavoriteMethodResult& operator=(const most_phonbkfi_tclMsgActivateFavoriteMethodResult& coRef);
   most_phonbkfi_tclMsgActivateFavoriteMethodResult(const most_phonbkfi_tclMsgActivateFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   tU32 u32ActivationHandle;
   virtual ~most_phonbkfi_tclMsgActivateFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgActivateFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDeleteFavoriteMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDeleteFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDeleteFavoriteMethodStart& operator=(const most_phonbkfi_tclMsgDeleteFavoriteMethodStart& coRef);
   most_phonbkfi_tclMsgDeleteFavoriteMethodStart(const most_phonbkfi_tclMsgDeleteFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   virtual ~most_phonbkfi_tclMsgDeleteFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDeleteFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDeleteFavoriteError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgDeleteFavoriteError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDeleteFavoriteError& operator=(const most_phonbkfi_tclMsgDeleteFavoriteError& coRef);
   most_phonbkfi_tclMsgDeleteFavoriteError(const most_phonbkfi_tclMsgDeleteFavoriteError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgDeleteFavoriteError();

   tBool operator==(const most_phonbkfi_tclMsgDeleteFavoriteError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDeleteFavoriteMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDeleteFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDeleteFavoriteMethodResult& operator=(const most_phonbkfi_tclMsgDeleteFavoriteMethodResult& coRef);
   most_phonbkfi_tclMsgDeleteFavoriteMethodResult(const most_phonbkfi_tclMsgDeleteFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   virtual ~most_phonbkfi_tclMsgDeleteFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDeleteFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetFavoriteInfoMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetFavoriteInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetFavoriteInfoMethodStart& operator=(const most_phonbkfi_tclMsgGetFavoriteInfoMethodStart& coRef);
   most_phonbkfi_tclMsgGetFavoriteInfoMethodStart(const most_phonbkfi_tclMsgGetFavoriteInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16FavoriteID;
   virtual ~most_phonbkfi_tclMsgGetFavoriteInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetFavoriteInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetFavoriteInfoError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgGetFavoriteInfoError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetFavoriteInfoError& operator=(const most_phonbkfi_tclMsgGetFavoriteInfoError& coRef);
   most_phonbkfi_tclMsgGetFavoriteInfoError(const most_phonbkfi_tclMsgGetFavoriteInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgGetFavoriteInfoError();

   tBool operator==(const most_phonbkfi_tclMsgGetFavoriteInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetFavoriteInfoMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetFavoriteInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetFavoriteInfoMethodResult& operator=(const most_phonbkfi_tclMsgGetFavoriteInfoMethodResult& coRef);
   most_phonbkfi_tclMsgGetFavoriteInfoMethodResult(const most_phonbkfi_tclMsgGetFavoriteInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32NumItems;
   most_fi_tcl_FavPrvFavoriteInfo oFavoriteInfo;
   virtual ~most_phonbkfi_tclMsgGetFavoriteInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetFavoriteInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgResetFavoritesMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgResetFavoritesMethodStart();

   virtual ~most_phonbkfi_tclMsgResetFavoritesMethodStart();

   inline tBool operator==(const most_phonbkfi_tclMsgResetFavoritesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgResetFavoritesError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgResetFavoritesError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgResetFavoritesError& operator=(const most_phonbkfi_tclMsgResetFavoritesError& coRef);
   most_phonbkfi_tclMsgResetFavoritesError(const most_phonbkfi_tclMsgResetFavoritesError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgResetFavoritesError();

   tBool operator==(const most_phonbkfi_tclMsgResetFavoritesError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgResetFavoritesMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgResetFavoritesMethodResult();

   virtual ~most_phonbkfi_tclMsgResetFavoritesMethodResult();

   inline tBool operator==(const most_phonbkfi_tclMsgResetFavoritesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCreatePhoneBookListMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgCreatePhoneBookListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCreatePhoneBookListMethodStart& operator=(const most_phonbkfi_tclMsgCreatePhoneBookListMethodStart& coRef);
   most_phonbkfi_tclMsgCreatePhoneBookListMethodStart(const most_phonbkfi_tclMsgCreatePhoneBookListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_e8_PhonBkPhoneBookSortType e8PhoneBookSortType;
   virtual ~most_phonbkfi_tclMsgCreatePhoneBookListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgCreatePhoneBookListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCreatePhoneBookListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgCreatePhoneBookListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCreatePhoneBookListError& operator=(const most_phonbkfi_tclMsgCreatePhoneBookListError& coRef);
   most_phonbkfi_tclMsgCreatePhoneBookListError(const most_phonbkfi_tclMsgCreatePhoneBookListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgCreatePhoneBookListError();

   tBool operator==(const most_phonbkfi_tclMsgCreatePhoneBookListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCreatePhoneBookListMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgCreatePhoneBookListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCreatePhoneBookListMethodResult& operator=(const most_phonbkfi_tclMsgCreatePhoneBookListMethodResult& coRef);
   most_phonbkfi_tclMsgCreatePhoneBookListMethodResult(const most_phonbkfi_tclMsgCreatePhoneBookListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU16 u16ListLength;
   virtual ~most_phonbkfi_tclMsgCreatePhoneBookListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgCreatePhoneBookListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart& operator=(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart& coRef);
   most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   virtual ~most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError& operator=(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError& coRef);
   most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError();

   tBool operator==(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult& operator=(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult& coRef);
   most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   most_fi_tcl_PhonBkSearchKeyboardList oSearchKeyboardList;
   virtual ~most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSearchKeyboardPhoneBookListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgReleasePhoneBookListMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgReleasePhoneBookListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgReleasePhoneBookListMethodStart& operator=(const most_phonbkfi_tclMsgReleasePhoneBookListMethodStart& coRef);
   most_phonbkfi_tclMsgReleasePhoneBookListMethodStart(const most_phonbkfi_tclMsgReleasePhoneBookListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   virtual ~most_phonbkfi_tclMsgReleasePhoneBookListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgReleasePhoneBookListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgReleasePhoneBookListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgReleasePhoneBookListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgReleasePhoneBookListError& operator=(const most_phonbkfi_tclMsgReleasePhoneBookListError& coRef);
   most_phonbkfi_tclMsgReleasePhoneBookListError(const most_phonbkfi_tclMsgReleasePhoneBookListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgReleasePhoneBookListError();

   tBool operator==(const most_phonbkfi_tclMsgReleasePhoneBookListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgReleasePhoneBookListMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgReleasePhoneBookListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgReleasePhoneBookListMethodResult& operator=(const most_phonbkfi_tclMsgReleasePhoneBookListMethodResult& coRef);
   most_phonbkfi_tclMsgReleasePhoneBookListMethodResult(const most_phonbkfi_tclMsgReleasePhoneBookListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   virtual ~most_phonbkfi_tclMsgReleasePhoneBookListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgReleasePhoneBookListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactDetailsMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetContactDetailsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactDetailsMethodStart& operator=(const most_phonbkfi_tclMsgGetContactDetailsMethodStart& coRef);
   most_phonbkfi_tclMsgGetContactDetailsMethodStart(const most_phonbkfi_tclMsgGetContactDetailsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   most_fi_tcl_e8_PhonBkContactDetailFilter e8ContactDetailFilter;
   virtual ~most_phonbkfi_tclMsgGetContactDetailsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetContactDetailsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactDetailsError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgGetContactDetailsError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactDetailsError& operator=(const most_phonbkfi_tclMsgGetContactDetailsError& coRef);
   most_phonbkfi_tclMsgGetContactDetailsError(const most_phonbkfi_tclMsgGetContactDetailsError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgGetContactDetailsError();

   tBool operator==(const most_phonbkfi_tclMsgGetContactDetailsError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactDetailsMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetContactDetailsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactDetailsMethodResult& operator=(const most_phonbkfi_tclMsgGetContactDetailsMethodResult& coRef);
   most_phonbkfi_tclMsgGetContactDetailsMethodResult(const most_phonbkfi_tclMsgGetContactDetailsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkContactDetails oContactDetails;
   virtual ~most_phonbkfi_tclMsgGetContactDetailsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetContactDetailsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactPhotoMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetContactPhotoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactPhotoMethodStart& operator=(const most_phonbkfi_tclMsgGetContactPhotoMethodStart& coRef);
   most_phonbkfi_tclMsgGetContactPhotoMethodStart(const most_phonbkfi_tclMsgGetContactPhotoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   virtual ~most_phonbkfi_tclMsgGetContactPhotoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetContactPhotoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactPhotoError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgGetContactPhotoError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactPhotoError& operator=(const most_phonbkfi_tclMsgGetContactPhotoError& coRef);
   most_phonbkfi_tclMsgGetContactPhotoError(const most_phonbkfi_tclMsgGetContactPhotoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgGetContactPhotoError();

   tBool operator==(const most_phonbkfi_tclMsgGetContactPhotoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactPhotoMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetContactPhotoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactPhotoMethodResult& operator=(const most_phonbkfi_tclMsgGetContactPhotoMethodResult& coRef);
   most_phonbkfi_tclMsgGetContactPhotoMethodResult(const most_phonbkfi_tclMsgGetContactPhotoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   most_fi_tcl_PhonBkContactPhoto oContactPhoto;
   virtual ~most_phonbkfi_tclMsgGetContactPhotoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetContactPhotoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAddContactMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAddContactMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAddContactMethodStart& operator=(const most_phonbkfi_tclMsgAddContactMethodStart& coRef);
   most_phonbkfi_tclMsgAddContactMethodStart(const most_phonbkfi_tclMsgAddContactMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_PhonBkContactDetails oContactDetails;
   virtual ~most_phonbkfi_tclMsgAddContactMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgAddContactMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAddContactError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgAddContactError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAddContactError& operator=(const most_phonbkfi_tclMsgAddContactError& coRef);
   most_phonbkfi_tclMsgAddContactError(const most_phonbkfi_tclMsgAddContactError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgAddContactError();

   tBool operator==(const most_phonbkfi_tclMsgAddContactError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAddContactMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAddContactMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAddContactMethodResult& operator=(const most_phonbkfi_tclMsgAddContactMethodResult& coRef);
   most_phonbkfi_tclMsgAddContactMethodResult(const most_phonbkfi_tclMsgAddContactMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   most_fi_tcl_e8_PhonBkContactAddStatus e8ContactAddStatus;
   virtual ~most_phonbkfi_tclMsgAddContactMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgAddContactMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDeleteContactMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDeleteContactMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDeleteContactMethodStart& operator=(const most_phonbkfi_tclMsgDeleteContactMethodStart& coRef);
   most_phonbkfi_tclMsgDeleteContactMethodStart(const most_phonbkfi_tclMsgDeleteContactMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU32 u32ContactHandle;
   virtual ~most_phonbkfi_tclMsgDeleteContactMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDeleteContactMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDeleteContactError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgDeleteContactError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDeleteContactError& operator=(const most_phonbkfi_tclMsgDeleteContactError& coRef);
   most_phonbkfi_tclMsgDeleteContactError(const most_phonbkfi_tclMsgDeleteContactError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgDeleteContactError();

   tBool operator==(const most_phonbkfi_tclMsgDeleteContactError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDeleteContactMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDeleteContactMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDeleteContactMethodResult& operator=(const most_phonbkfi_tclMsgDeleteContactMethodResult& coRef);
   most_phonbkfi_tclMsgDeleteContactMethodResult(const most_phonbkfi_tclMsgDeleteContactMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   most_fi_tcl_e8_PhonBkContactDeleteStatus e8ContactDeleteStatus;
   virtual ~most_phonbkfi_tclMsgDeleteContactMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDeleteContactMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgEditContactMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgEditContactMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgEditContactMethodStart& operator=(const most_phonbkfi_tclMsgEditContactMethodStart& coRef);
   most_phonbkfi_tclMsgEditContactMethodStart(const most_phonbkfi_tclMsgEditContactMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU32 u32ContactHandle;
   most_fi_tcl_PhonBkContactDetails oContactDetails;
   virtual ~most_phonbkfi_tclMsgEditContactMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgEditContactMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgEditContactError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgEditContactError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgEditContactError& operator=(const most_phonbkfi_tclMsgEditContactError& coRef);
   most_phonbkfi_tclMsgEditContactError(const most_phonbkfi_tclMsgEditContactError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgEditContactError();

   tBool operator==(const most_phonbkfi_tclMsgEditContactError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgEditContactMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgEditContactMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgEditContactMethodResult& operator=(const most_phonbkfi_tclMsgEditContactMethodResult& coRef);
   most_phonbkfi_tclMsgEditContactMethodResult(const most_phonbkfi_tclMsgEditContactMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   most_fi_tcl_e8_PhonBkContactEditStatus e8ContactEditStatus;
   virtual ~most_phonbkfi_tclMsgEditContactMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgEditContactMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCreateCallHistoryListMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgCreateCallHistoryListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCreateCallHistoryListMethodStart& operator=(const most_phonbkfi_tclMsgCreateCallHistoryListMethodStart& coRef);
   most_phonbkfi_tclMsgCreateCallHistoryListMethodStart(const most_phonbkfi_tclMsgCreateCallHistoryListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_e8_PhonBkCallHistoryType e8CallHistoryType;
   most_fi_tcl_e8_PhonBkCallHistorySortType e8CallHistorySortType;
   virtual ~most_phonbkfi_tclMsgCreateCallHistoryListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgCreateCallHistoryListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCreateCallHistoryListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgCreateCallHistoryListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCreateCallHistoryListError& operator=(const most_phonbkfi_tclMsgCreateCallHistoryListError& coRef);
   most_phonbkfi_tclMsgCreateCallHistoryListError(const most_phonbkfi_tclMsgCreateCallHistoryListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgCreateCallHistoryListError();

   tBool operator==(const most_phonbkfi_tclMsgCreateCallHistoryListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCreateCallHistoryListMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgCreateCallHistoryListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCreateCallHistoryListMethodResult& operator=(const most_phonbkfi_tclMsgCreateCallHistoryListMethodResult& coRef);
   most_phonbkfi_tclMsgCreateCallHistoryListMethodResult(const most_phonbkfi_tclMsgCreateCallHistoryListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU16 u16ListHandle;
   tU16 u16ListLength;
   virtual ~most_phonbkfi_tclMsgCreateCallHistoryListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgCreateCallHistoryListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart& operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart& coRef);
   most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   virtual ~most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestSliceCallHistoryListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgRequestSliceCallHistoryListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestSliceCallHistoryListError& operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListError& coRef);
   most_phonbkfi_tclMsgRequestSliceCallHistoryListError(const most_phonbkfi_tclMsgRequestSliceCallHistoryListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgRequestSliceCallHistoryListError();

   tBool operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult& operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult& coRef);
   most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkCallHistoryListSliceResult oCallHistoryListSliceResult;
   virtual ~most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart& operator=(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart& coRef);
   most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearMissedCallIndicatorError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgClearMissedCallIndicatorError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearMissedCallIndicatorError& operator=(const most_phonbkfi_tclMsgClearMissedCallIndicatorError& coRef);
   most_phonbkfi_tclMsgClearMissedCallIndicatorError(const most_phonbkfi_tclMsgClearMissedCallIndicatorError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgClearMissedCallIndicatorError();

   tBool operator==(const most_phonbkfi_tclMsgClearMissedCallIndicatorError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult& operator=(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult& coRef);
   most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgClearMissedCallIndicatorMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSearchPhoneBookMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSearchPhoneBookMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSearchPhoneBookMethodStart& operator=(const most_phonbkfi_tclMsgSearchPhoneBookMethodStart& coRef);
   most_phonbkfi_tclMsgSearchPhoneBookMethodStart(const most_phonbkfi_tclMsgSearchPhoneBookMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_String sPhoneNumber;
   most_fi_tcl_String sEmailAddress;
   virtual ~most_phonbkfi_tclMsgSearchPhoneBookMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSearchPhoneBookMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSearchPhoneBookError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgSearchPhoneBookError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSearchPhoneBookError& operator=(const most_phonbkfi_tclMsgSearchPhoneBookError& coRef);
   most_phonbkfi_tclMsgSearchPhoneBookError(const most_phonbkfi_tclMsgSearchPhoneBookError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgSearchPhoneBookError();

   tBool operator==(const most_phonbkfi_tclMsgSearchPhoneBookError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSearchPhoneBookMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSearchPhoneBookMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSearchPhoneBookMethodResult& operator=(const most_phonbkfi_tclMsgSearchPhoneBookMethodResult& coRef);
   most_phonbkfi_tclMsgSearchPhoneBookMethodResult(const most_phonbkfi_tclMsgSearchPhoneBookMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   tU8 u8DeviceHandle;
   most_fi_tcl_String sFirstName;
   most_fi_tcl_String sLastName;
   most_fi_tcl_e8_PhonBkContactDetailType e8ContactDetailType;
   virtual ~most_phonbkfi_tclMsgSearchPhoneBookMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSearchPhoneBookMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart& operator=(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart& coRef);
   most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   virtual ~most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgReleaseCallHistoryListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgReleaseCallHistoryListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgReleaseCallHistoryListError& operator=(const most_phonbkfi_tclMsgReleaseCallHistoryListError& coRef);
   most_phonbkfi_tclMsgReleaseCallHistoryListError(const most_phonbkfi_tclMsgReleaseCallHistoryListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgReleaseCallHistoryListError();

   tBool operator==(const most_phonbkfi_tclMsgReleaseCallHistoryListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult& operator=(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult& coRef);
   most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   virtual ~most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgReleaseCallHistoryListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart& operator=(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart& coRef);
   most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   virtual ~most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactPhotoInfoError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgGetContactPhotoInfoError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactPhotoInfoError& operator=(const most_phonbkfi_tclMsgGetContactPhotoInfoError& coRef);
   most_phonbkfi_tclMsgGetContactPhotoInfoError(const most_phonbkfi_tclMsgGetContactPhotoInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgGetContactPhotoInfoError();

   tBool operator==(const most_phonbkfi_tclMsgGetContactPhotoInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult& operator=(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult& coRef);
   most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   most_fi_tcl_String sMIMEImageSubtype;
   tU32 u32PhotoImageSize;
   virtual ~most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetContactPhotoInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart& operator=(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart& coRef);
   most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetDeviceCallHistorySupportError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgGetDeviceCallHistorySupportError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetDeviceCallHistorySupportError& operator=(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportError& coRef);
   most_phonbkfi_tclMsgGetDeviceCallHistorySupportError(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgGetDeviceCallHistorySupportError();

   tBool operator==(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult& operator=(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult& coRef);
   most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_PhonBkCallHistoryTypeSupport oCallHistoryTypeSupport;
   tBool bCallHistoryDateTimeSupport;
   virtual ~most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetDeviceCallHistorySupportMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart& operator=(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart& coRef);
   most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sPhoneNumberDigits;
   virtual ~most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError& operator=(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError& coRef);
   most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError();

   tBool operator==(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult& operator=(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult& coRef);
   most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAutocompleteMatch;
   most_fi_tcl_String sAutocompleteMatchPhoneNumber;
   tU8 u8NumberOfMatches;
   most_fi_tcl_PhonBkAutocompleteMultipleMatchList oAutocompleteMultipleMatchList;
   virtual ~most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgAutocompletePhoneNumberEntryMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearPhoneBookDataMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgClearPhoneBookDataMethodStart();

   virtual ~most_phonbkfi_tclMsgClearPhoneBookDataMethodStart();

   inline tBool operator==(const most_phonbkfi_tclMsgClearPhoneBookDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearPhoneBookDataError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgClearPhoneBookDataError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearPhoneBookDataError& operator=(const most_phonbkfi_tclMsgClearPhoneBookDataError& coRef);
   most_phonbkfi_tclMsgClearPhoneBookDataError(const most_phonbkfi_tclMsgClearPhoneBookDataError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgClearPhoneBookDataError();

   tBool operator==(const most_phonbkfi_tclMsgClearPhoneBookDataError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearPhoneBookDataMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgClearPhoneBookDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearPhoneBookDataMethodResult& operator=(const most_phonbkfi_tclMsgClearPhoneBookDataMethodResult& coRef);
   most_phonbkfi_tclMsgClearPhoneBookDataMethodResult(const most_phonbkfi_tclMsgClearPhoneBookDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDummyResult;
   virtual ~most_phonbkfi_tclMsgClearPhoneBookDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgClearPhoneBookDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart& operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart& coRef);
   most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   virtual ~most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestPhoneBookListSliceError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgRequestPhoneBookListSliceError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestPhoneBookListSliceError& operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceError& coRef);
   most_phonbkfi_tclMsgRequestPhoneBookListSliceError(const most_phonbkfi_tclMsgRequestPhoneBookListSliceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgRequestPhoneBookListSliceError();

   tBool operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult& operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult& coRef);
   most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkPhoneBookListSliceResult oPhoneBookListSliceResult;
   virtual ~most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart();

   virtual ~most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart();

   inline tBool operator==(const most_phonbkfi_tclMsgClearVehiclePhoneBookMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearVehiclePhoneBookError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgClearVehiclePhoneBookError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearVehiclePhoneBookError& operator=(const most_phonbkfi_tclMsgClearVehiclePhoneBookError& coRef);
   most_phonbkfi_tclMsgClearVehiclePhoneBookError(const most_phonbkfi_tclMsgClearVehiclePhoneBookError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgClearVehiclePhoneBookError();

   tBool operator==(const most_phonbkfi_tclMsgClearVehiclePhoneBookError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult& operator=(const most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult& coRef);
   most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult(const most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDummyResult;
   virtual ~most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgClearVehiclePhoneBookMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart& operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart& coRef);
   most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   virtual ~most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError& operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError& coRef);
   most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError();

   tBool operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult& operator=(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult& coRef);
   most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkCallHistoryListSliceResultExtened oCallHistoryListSliceResultExtended;
   virtual ~most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgRequestSliceCallHistoryListExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart& operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart& coRef);
   most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU32 u32WindowStart;
   tU16 u16WindowSize;
   virtual ~most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError& operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError& coRef);
   most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError();

   tBool operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult& operator=(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult& coRef);
   most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   most_fi_tcl_PhonBkPhoneBookListSliceResultExtended oPhoneBookListSliceResultExtended;
   virtual ~most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgRequestPhoneBookListSliceExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSearchContactsMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSearchContactsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSearchContactsMethodStart& operator=(const most_phonbkfi_tclMsgSearchContactsMethodStart& coRef);
   most_phonbkfi_tclMsgSearchContactsMethodStart(const most_phonbkfi_tclMsgSearchContactsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkDeviceHandleList oDeviceHandleList;
   tU16 u16FieldSelector;
   most_fi_tcl_String sSearchString;
   most_fi_tcl_e8_PhonBkSearchSortType e8SearchSortType;
   tU16 u16MaxReportedMatches;
   virtual ~most_phonbkfi_tclMsgSearchContactsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSearchContactsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSearchContactsError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgSearchContactsError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSearchContactsError& operator=(const most_phonbkfi_tclMsgSearchContactsError& coRef);
   most_phonbkfi_tclMsgSearchContactsError(const most_phonbkfi_tclMsgSearchContactsError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgSearchContactsError();

   tBool operator==(const most_phonbkfi_tclMsgSearchContactsError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSearchContactsMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSearchContactsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSearchContactsMethodResult& operator=(const most_phonbkfi_tclMsgSearchContactsMethodResult& coRef);
   most_phonbkfi_tclMsgSearchContactsMethodResult(const most_phonbkfi_tclMsgSearchContactsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16NumberOfMatches;
   tBool bMatchLimitExceeded;
   most_fi_tcl_PhonBkContactMatchList oContactMatchList;
   virtual ~most_phonbkfi_tclMsgSearchContactsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSearchContactsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgStartPbDownloadMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgStartPbDownloadMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgStartPbDownloadMethodStart& operator=(const most_phonbkfi_tclMsgStartPbDownloadMethodStart& coRef);
   most_phonbkfi_tclMsgStartPbDownloadMethodStart(const most_phonbkfi_tclMsgStartPbDownloadMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgStartPbDownloadMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgStartPbDownloadMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgStartPbDownloadError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgStartPbDownloadError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgStartPbDownloadError& operator=(const most_phonbkfi_tclMsgStartPbDownloadError& coRef);
   most_phonbkfi_tclMsgStartPbDownloadError(const most_phonbkfi_tclMsgStartPbDownloadError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgStartPbDownloadError();

   tBool operator==(const most_phonbkfi_tclMsgStartPbDownloadError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgStartPbDownloadMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgStartPbDownloadMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgStartPbDownloadMethodResult& operator=(const most_phonbkfi_tclMsgStartPbDownloadMethodResult& coRef);
   most_phonbkfi_tclMsgStartPbDownloadMethodResult(const most_phonbkfi_tclMsgStartPbDownloadMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgStartPbDownloadMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgStartPbDownloadMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart& operator=(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart& coRef);
   most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU8 u8DownloadOnOffState;
   virtual ~most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSwitchDownloadOnOffStateError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgSwitchDownloadOnOffStateError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSwitchDownloadOnOffStateError& operator=(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateError& coRef);
   most_phonbkfi_tclMsgSwitchDownloadOnOffStateError(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgSwitchDownloadOnOffStateError();

   tBool operator==(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult& operator=(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult& coRef);
   most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU8 u8DownloadOnOffState;
   virtual ~most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSwitchDownloadOnOffStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCreateContactListMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgCreateContactListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCreateContactListMethodStart& operator=(const most_phonbkfi_tclMsgCreateContactListMethodStart& coRef);
   most_phonbkfi_tclMsgCreateContactListMethodStart(const most_phonbkfi_tclMsgCreateContactListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_e8_PhonBkContactListType e8PhoneBkContactListType;
   most_fi_tcl_e8_PhonBkContactSortType e8PhoneBkContactSortType;
   virtual ~most_phonbkfi_tclMsgCreateContactListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgCreateContactListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCreateContactListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgCreateContactListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCreateContactListError& operator=(const most_phonbkfi_tclMsgCreateContactListError& coRef);
   most_phonbkfi_tclMsgCreateContactListError(const most_phonbkfi_tclMsgCreateContactListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgCreateContactListError();

   tBool operator==(const most_phonbkfi_tclMsgCreateContactListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCreateContactListMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgCreateContactListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCreateContactListMethodResult& operator=(const most_phonbkfi_tclMsgCreateContactListMethodResult& coRef);
   most_phonbkfi_tclMsgCreateContactListMethodResult(const most_phonbkfi_tclMsgCreateContactListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU16 u16ListLength;
   virtual ~most_phonbkfi_tclMsgCreateContactListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgCreateContactListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSetContactPhotoMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSetContactPhotoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSetContactPhotoMethodStart& operator=(const most_phonbkfi_tclMsgSetContactPhotoMethodStart& coRef);
   most_phonbkfi_tclMsgSetContactPhotoMethodStart(const most_phonbkfi_tclMsgSetContactPhotoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   most_fi_tcl_PhonBkContactPhoto oVehicleContactPhoto;
   virtual ~most_phonbkfi_tclMsgSetContactPhotoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSetContactPhotoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSetContactPhotoError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgSetContactPhotoError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSetContactPhotoError& operator=(const most_phonbkfi_tclMsgSetContactPhotoError& coRef);
   most_phonbkfi_tclMsgSetContactPhotoError(const most_phonbkfi_tclMsgSetContactPhotoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgSetContactPhotoError();

   tBool operator==(const most_phonbkfi_tclMsgSetContactPhotoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSetContactPhotoMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSetContactPhotoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSetContactPhotoMethodResult& operator=(const most_phonbkfi_tclMsgSetContactPhotoMethodResult& coRef);
   most_phonbkfi_tclMsgSetContactPhotoMethodResult(const most_phonbkfi_tclMsgSetContactPhotoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   virtual ~most_phonbkfi_tclMsgSetContactPhotoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSetContactPhotoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCancelPbDownloadMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgCancelPbDownloadMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCancelPbDownloadMethodStart& operator=(const most_phonbkfi_tclMsgCancelPbDownloadMethodStart& coRef);
   most_phonbkfi_tclMsgCancelPbDownloadMethodStart(const most_phonbkfi_tclMsgCancelPbDownloadMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgCancelPbDownloadMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgCancelPbDownloadMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCancelPbDownloadError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgCancelPbDownloadError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCancelPbDownloadError& operator=(const most_phonbkfi_tclMsgCancelPbDownloadError& coRef);
   most_phonbkfi_tclMsgCancelPbDownloadError(const most_phonbkfi_tclMsgCancelPbDownloadError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgCancelPbDownloadError();

   tBool operator==(const most_phonbkfi_tclMsgCancelPbDownloadError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgCancelPbDownloadMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgCancelPbDownloadMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgCancelPbDownloadMethodResult& operator=(const most_phonbkfi_tclMsgCancelPbDownloadMethodResult& coRef);
   most_phonbkfi_tclMsgCancelPbDownloadMethodResult(const most_phonbkfi_tclMsgCancelPbDownloadMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgCancelPbDownloadMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgCancelPbDownloadMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSetContactPositionMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSetContactPositionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSetContactPositionMethodStart& operator=(const most_phonbkfi_tclMsgSetContactPositionMethodStart& coRef);
   most_phonbkfi_tclMsgSetContactPositionMethodStart(const most_phonbkfi_tclMsgSetContactPositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   tU32 u32ContactPosition;
   virtual ~most_phonbkfi_tclMsgSetContactPositionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSetContactPositionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSetContactPositionError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgSetContactPositionError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSetContactPositionError& operator=(const most_phonbkfi_tclMsgSetContactPositionError& coRef);
   most_phonbkfi_tclMsgSetContactPositionError(const most_phonbkfi_tclMsgSetContactPositionError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgSetContactPositionError();

   tBool operator==(const most_phonbkfi_tclMsgSetContactPositionError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSetContactPositionMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSetContactPositionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSetContactPositionMethodResult& operator=(const most_phonbkfi_tclMsgSetContactPositionMethodResult& coRef);
   most_phonbkfi_tclMsgSetContactPositionMethodResult(const most_phonbkfi_tclMsgSetContactPositionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   virtual ~most_phonbkfi_tclMsgSetContactPositionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSetContactPositionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAddContactExtendedMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAddContactExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAddContactExtendedMethodStart& operator=(const most_phonbkfi_tclMsgAddContactExtendedMethodStart& coRef);
   most_phonbkfi_tclMsgAddContactExtendedMethodStart(const most_phonbkfi_tclMsgAddContactExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_PhonBkContactDetailsExtended oContactDetailsExtended;
   virtual ~most_phonbkfi_tclMsgAddContactExtendedMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgAddContactExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAddContactExtendedError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgAddContactExtendedError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAddContactExtendedError& operator=(const most_phonbkfi_tclMsgAddContactExtendedError& coRef);
   most_phonbkfi_tclMsgAddContactExtendedError(const most_phonbkfi_tclMsgAddContactExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgAddContactExtendedError();

   tBool operator==(const most_phonbkfi_tclMsgAddContactExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAddContactExtendedMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAddContactExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAddContactExtendedMethodResult& operator=(const most_phonbkfi_tclMsgAddContactExtendedMethodResult& coRef);
   most_phonbkfi_tclMsgAddContactExtendedMethodResult(const most_phonbkfi_tclMsgAddContactExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   most_fi_tcl_e8_PhonBkContactAddStatus e8ContactAddStatusExtended;
   virtual ~most_phonbkfi_tclMsgAddContactExtendedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgAddContactExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgEditContactExtendedMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgEditContactExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgEditContactExtendedMethodStart& operator=(const most_phonbkfi_tclMsgEditContactExtendedMethodStart& coRef);
   most_phonbkfi_tclMsgEditContactExtendedMethodStart(const most_phonbkfi_tclMsgEditContactExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU32 u32ContactHandle;
   most_fi_tcl_PhonBkContactDetailsExtended oContactDetailsExtended;
   virtual ~most_phonbkfi_tclMsgEditContactExtendedMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgEditContactExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgEditContactExtendedError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgEditContactExtendedError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgEditContactExtendedError& operator=(const most_phonbkfi_tclMsgEditContactExtendedError& coRef);
   most_phonbkfi_tclMsgEditContactExtendedError(const most_phonbkfi_tclMsgEditContactExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgEditContactExtendedError();

   tBool operator==(const most_phonbkfi_tclMsgEditContactExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgEditContactExtendedMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgEditContactExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgEditContactExtendedMethodResult& operator=(const most_phonbkfi_tclMsgEditContactExtendedMethodResult& coRef);
   most_phonbkfi_tclMsgEditContactExtendedMethodResult(const most_phonbkfi_tclMsgEditContactExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   most_fi_tcl_e8_PhonBkContactEditStatus e8ContactEditStatusExtended;
   virtual ~most_phonbkfi_tclMsgEditContactExtendedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgEditContactExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart& operator=(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart& coRef);
   most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32ContactHandle;
   virtual ~most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactDetailsExtendedError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgGetContactDetailsExtendedError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactDetailsExtendedError& operator=(const most_phonbkfi_tclMsgGetContactDetailsExtendedError& coRef);
   most_phonbkfi_tclMsgGetContactDetailsExtendedError(const most_phonbkfi_tclMsgGetContactDetailsExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgGetContactDetailsExtendedError();

   tBool operator==(const most_phonbkfi_tclMsgGetContactDetailsExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult& operator=(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult& coRef);
   most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkContactDetailsExtended oContactDetailsExtended;
   virtual ~most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetContactDetailsExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart& operator=(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart& coRef);
   most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError& operator=(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError& coRef);
   most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError();

   tBool operator==(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult& operator=(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult& coRef);
   most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgClearVehiclePhonebookExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart& operator=(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart& coRef);
   most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tBool bAutomaticDL;
   virtual ~most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSetAutomaticContactDownloadError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgSetAutomaticContactDownloadError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSetAutomaticContactDownloadError& operator=(const most_phonbkfi_tclMsgSetAutomaticContactDownloadError& coRef);
   most_phonbkfi_tclMsgSetAutomaticContactDownloadError(const most_phonbkfi_tclMsgSetAutomaticContactDownloadError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgSetAutomaticContactDownloadError();

   tBool operator==(const most_phonbkfi_tclMsgSetAutomaticContactDownloadError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult& operator=(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult& coRef);
   most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tBool bAutomaticDL;
   virtual ~most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgSetAutomaticContactDownloadMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart& operator=(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart& coRef);
   most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU32 u32ContactHandle;
   virtual ~most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetPositionForContactHandleError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgGetPositionForContactHandleError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetPositionForContactHandleError& operator=(const most_phonbkfi_tclMsgGetPositionForContactHandleError& coRef);
   most_phonbkfi_tclMsgGetPositionForContactHandleError(const most_phonbkfi_tclMsgGetPositionForContactHandleError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgGetPositionForContactHandleError();

   tBool operator==(const most_phonbkfi_tclMsgGetPositionForContactHandleError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult& operator=(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult& coRef);
   most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Position;
   tU16 u16ListHandle;
   tU32 u32ContactHandle;
   virtual ~most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgGetPositionForContactHandleMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgFavoritesChangedUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgFavoritesChangedUpReg();

   virtual ~most_phonbkfi_tclMsgFavoritesChangedUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgFavoritesChangedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgFavoritesChangedRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgFavoritesChangedRelUpReg();

   virtual ~most_phonbkfi_tclMsgFavoritesChangedRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgFavoritesChangedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgFavoritesChangedStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgFavoritesChangedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgFavoritesChangedStatus& operator=(const most_phonbkfi_tclMsgFavoritesChangedStatus& coRef);
   most_phonbkfi_tclMsgFavoritesChangedStatus(const most_phonbkfi_tclMsgFavoritesChangedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_FavPrvListChangeType e8ListChangeType;
   tU32 u32ListSize;
   tU32 u32NumItems;
   most_fi_tcl_FavPrvChangedFavorites oChangedFavorites;
   virtual ~most_phonbkfi_tclMsgFavoritesChangedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgFavoritesChangedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgListChangeUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgListChangeUpReg();

   virtual ~most_phonbkfi_tclMsgListChangeUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgListChangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgListChangeRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgListChangeRelUpReg();

   virtual ~most_phonbkfi_tclMsgListChangeRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgListChangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgListChangeStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgListChangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgListChangeStatus& operator=(const most_phonbkfi_tclMsgListChangeStatus& coRef);
   most_phonbkfi_tclMsgListChangeStatus(const most_phonbkfi_tclMsgListChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   most_fi_tcl_e8_PhonBkListType e8ListType;
   most_fi_tcl_e8_PhonBkListChangeType e8ListChangeType;
   tU16 u16ListLength;
   tU32 u32NumItems;
   most_fi_tcl_PhonBkChangeItems oChangeItems;
   virtual ~most_phonbkfi_tclMsgListChangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgListChangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMissedCallIndicatorUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMissedCallIndicatorUpReg();

   virtual ~most_phonbkfi_tclMsgMissedCallIndicatorUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgMissedCallIndicatorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg();

   virtual ~most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgMissedCallIndicatorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMissedCallIndicatorStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMissedCallIndicatorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgMissedCallIndicatorStatus& operator=(const most_phonbkfi_tclMsgMissedCallIndicatorStatus& coRef);
   most_phonbkfi_tclMsgMissedCallIndicatorStatus(const most_phonbkfi_tclMsgMissedCallIndicatorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32NumMissedCalls;
   virtual ~most_phonbkfi_tclMsgMissedCallIndicatorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgMissedCallIndicatorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg();

   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg();

   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet();

   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet();

   inline tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError& operator=(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError& coRef);
   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError();

   tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus& operator=(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus& coRef);
   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bPhoneBookSupport;
   tBool bCCHListSupport;
   tBool bICHListSupport;
   tBool bOCHListSupport;
   tBool bMCHListSupport;
   tBool bContactListSortView;
   tU8 u8DeviceHandle;
   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg();

   virtual ~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg();

   virtual ~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet();

   virtual ~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet();

   inline tBool operator==(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet& operator=(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet& coRef);
   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder e8PreferredPhoneBookSortOrder;
   virtual ~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError& operator=(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError& coRef);
   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError();

   tBool operator==(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus& operator=(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus& coRef);
   most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder e8PreferredPhoneBookSortOrder;
   virtual ~most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgPreferredPhoneBookSortOrderStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadStateUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadStateUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadStateUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadStateRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadStateRelUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadStateRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadStateError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgDownloadStateError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadStateError& operator=(const most_phonbkfi_tclMsgDownloadStateError& coRef);
   most_phonbkfi_tclMsgDownloadStateError(const most_phonbkfi_tclMsgDownloadStateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgDownloadStateError();

   tBool operator==(const most_phonbkfi_tclMsgDownloadStateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadStateStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadStateStatus& operator=(const most_phonbkfi_tclMsgDownloadStateStatus& coRef);
   most_phonbkfi_tclMsgDownloadStateStatus(const most_phonbkfi_tclMsgDownloadStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkDownloadStateStream oDownloadStateStream;
   virtual ~most_phonbkfi_tclMsgDownloadStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDownloadStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadStateExtendedUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadStateExtendedUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadStateExtendedUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadStateExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadStateExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadStateExtendedError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgDownloadStateExtendedError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadStateExtendedError& operator=(const most_phonbkfi_tclMsgDownloadStateExtendedError& coRef);
   most_phonbkfi_tclMsgDownloadStateExtendedError(const most_phonbkfi_tclMsgDownloadStateExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgDownloadStateExtendedError();

   tBool operator==(const most_phonbkfi_tclMsgDownloadStateExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadStateExtendedStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadStateExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadStateExtendedStatus& operator=(const most_phonbkfi_tclMsgDownloadStateExtendedStatus& coRef);
   most_phonbkfi_tclMsgDownloadStateExtendedStatus(const most_phonbkfi_tclMsgDownloadStateExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkDownloadStateExtendedStream oDownloadStateExtendedStream;
   virtual ~most_phonbkfi_tclMsgDownloadStateExtendedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDownloadStateExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadProgressUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadProgressUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadProgressUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadProgressRelUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadProgressRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadProgressRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadProgressGet();

   virtual ~most_phonbkfi_tclMsgDownloadProgressGet();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadProgressGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgDownloadProgressError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadProgressError& operator=(const most_phonbkfi_tclMsgDownloadProgressError& coRef);
   most_phonbkfi_tclMsgDownloadProgressError(const most_phonbkfi_tclMsgDownloadProgressError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgDownloadProgressError();

   tBool operator==(const most_phonbkfi_tclMsgDownloadProgressError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadProgressStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadProgressStatus& operator=(const most_phonbkfi_tclMsgDownloadProgressStatus& coRef);
   most_phonbkfi_tclMsgDownloadProgressStatus(const most_phonbkfi_tclMsgDownloadProgressStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU32 u32NumberOfContacts;
   virtual ~most_phonbkfi_tclMsgDownloadProgressStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDownloadProgressStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressListUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadProgressListUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadProgressListUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadProgressListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressListRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadProgressListRelUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadProgressListRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadProgressListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressListGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadProgressListGet();

   virtual ~most_phonbkfi_tclMsgDownloadProgressListGet();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadProgressListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgDownloadProgressListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadProgressListError& operator=(const most_phonbkfi_tclMsgDownloadProgressListError& coRef);
   most_phonbkfi_tclMsgDownloadProgressListError(const most_phonbkfi_tclMsgDownloadProgressListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgDownloadProgressListError();

   tBool operator==(const most_phonbkfi_tclMsgDownloadProgressListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadProgressListStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadProgressListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadProgressListStatus& operator=(const most_phonbkfi_tclMsgDownloadProgressListStatus& coRef);
   most_phonbkfi_tclMsgDownloadProgressListStatus(const most_phonbkfi_tclMsgDownloadProgressListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkDownloadProgressList oDownloadProgressList;
   virtual ~most_phonbkfi_tclMsgDownloadProgressListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDownloadProgressListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadOnOffListUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadOnOffListUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadOnOffListUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadOnOffListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadOnOffListRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadOnOffListRelUpReg();

   virtual ~most_phonbkfi_tclMsgDownloadOnOffListRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadOnOffListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadOnOffListGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadOnOffListGet();

   virtual ~most_phonbkfi_tclMsgDownloadOnOffListGet();

   inline tBool operator==(const most_phonbkfi_tclMsgDownloadOnOffListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadOnOffListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgDownloadOnOffListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadOnOffListError& operator=(const most_phonbkfi_tclMsgDownloadOnOffListError& coRef);
   most_phonbkfi_tclMsgDownloadOnOffListError(const most_phonbkfi_tclMsgDownloadOnOffListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgDownloadOnOffListError();

   tBool operator==(const most_phonbkfi_tclMsgDownloadOnOffListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDownloadOnOffListStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDownloadOnOffListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDownloadOnOffListStatus& operator=(const most_phonbkfi_tclMsgDownloadOnOffListStatus& coRef);
   most_phonbkfi_tclMsgDownloadOnOffListStatus(const most_phonbkfi_tclMsgDownloadOnOffListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkDownloadOnOffStateList oDownloadOnOffStateList;
   virtual ~most_phonbkfi_tclMsgDownloadOnOffListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDownloadOnOffListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg();

   virtual ~most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgAutomaticContactDownloadListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg();

   virtual ~most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgAutomaticContactDownloadListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAutomaticContactDownloadListGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAutomaticContactDownloadListGet();

   virtual ~most_phonbkfi_tclMsgAutomaticContactDownloadListGet();

   inline tBool operator==(const most_phonbkfi_tclMsgAutomaticContactDownloadListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAutomaticContactDownloadListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgAutomaticContactDownloadListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAutomaticContactDownloadListError& operator=(const most_phonbkfi_tclMsgAutomaticContactDownloadListError& coRef);
   most_phonbkfi_tclMsgAutomaticContactDownloadListError(const most_phonbkfi_tclMsgAutomaticContactDownloadListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgAutomaticContactDownloadListError();

   tBool operator==(const most_phonbkfi_tclMsgAutomaticContactDownloadListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgAutomaticContactDownloadListStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgAutomaticContactDownloadListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgAutomaticContactDownloadListStatus& operator=(const most_phonbkfi_tclMsgAutomaticContactDownloadListStatus& coRef);
   most_phonbkfi_tclMsgAutomaticContactDownloadListStatus(const most_phonbkfi_tclMsgAutomaticContactDownloadListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_AutomaticContactDownloadList oAutomaticContactDownloadList;
   virtual ~most_phonbkfi_tclMsgAutomaticContactDownloadListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgAutomaticContactDownloadListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg();

   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg();

   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet();

   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet();

   inline tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError& operator=(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError& coRef);
   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError();

   tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus& operator=(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus& coRef);
   most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_DevicePhoneBookFeatureSupportList oDevicePhoneBookFeatureSupportList;
   virtual ~most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgDevicePhoneBookFeatureSupportExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgProbablyLockedDevicesUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgProbablyLockedDevicesUpReg();

   virtual ~most_phonbkfi_tclMsgProbablyLockedDevicesUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgProbablyLockedDevicesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg();

   virtual ~most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgProbablyLockedDevicesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgProbablyLockedDevicesGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgProbablyLockedDevicesGet();

   virtual ~most_phonbkfi_tclMsgProbablyLockedDevicesGet();

   inline tBool operator==(const most_phonbkfi_tclMsgProbablyLockedDevicesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgProbablyLockedDevicesError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgProbablyLockedDevicesError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgProbablyLockedDevicesError& operator=(const most_phonbkfi_tclMsgProbablyLockedDevicesError& coRef);
   most_phonbkfi_tclMsgProbablyLockedDevicesError(const most_phonbkfi_tclMsgProbablyLockedDevicesError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgProbablyLockedDevicesError();

   tBool operator==(const most_phonbkfi_tclMsgProbablyLockedDevicesError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgProbablyLockedDevicesStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgProbablyLockedDevicesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgProbablyLockedDevicesStatus& operator=(const most_phonbkfi_tclMsgProbablyLockedDevicesStatus& coRef);
   most_phonbkfi_tclMsgProbablyLockedDevicesStatus(const most_phonbkfi_tclMsgProbablyLockedDevicesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkDeviceHandleList oProbablyLockedDevices;
   virtual ~most_phonbkfi_tclMsgProbablyLockedDevicesStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgProbablyLockedDevicesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMissedCallIndicatorListUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMissedCallIndicatorListUpReg();

   virtual ~most_phonbkfi_tclMsgMissedCallIndicatorListUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgMissedCallIndicatorListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg();

   virtual ~most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgMissedCallIndicatorListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMissedCallIndicatorListGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMissedCallIndicatorListGet();

   virtual ~most_phonbkfi_tclMsgMissedCallIndicatorListGet();

   inline tBool operator==(const most_phonbkfi_tclMsgMissedCallIndicatorListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMissedCallIndicatorListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgMissedCallIndicatorListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgMissedCallIndicatorListError& operator=(const most_phonbkfi_tclMsgMissedCallIndicatorListError& coRef);
   most_phonbkfi_tclMsgMissedCallIndicatorListError(const most_phonbkfi_tclMsgMissedCallIndicatorListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgMissedCallIndicatorListError();

   tBool operator==(const most_phonbkfi_tclMsgMissedCallIndicatorListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMissedCallIndicatorListStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMissedCallIndicatorListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgMissedCallIndicatorListStatus& operator=(const most_phonbkfi_tclMsgMissedCallIndicatorListStatus& coRef);
   most_phonbkfi_tclMsgMissedCallIndicatorListStatus(const most_phonbkfi_tclMsgMissedCallIndicatorListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkMissedCallIndicatorList oMissedCallIndicatorList;
   virtual ~most_phonbkfi_tclMsgMissedCallIndicatorListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgMissedCallIndicatorListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredSortOrderListUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredSortOrderListUpReg();

   virtual ~most_phonbkfi_tclMsgPreferredSortOrderListUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgPreferredSortOrderListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg();

   virtual ~most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgPreferredSortOrderListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredSortOrderListGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredSortOrderListGet();

   virtual ~most_phonbkfi_tclMsgPreferredSortOrderListGet();

   inline tBool operator==(const most_phonbkfi_tclMsgPreferredSortOrderListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredSortOrderListPureSet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredSortOrderListPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgPreferredSortOrderListPureSet& operator=(const most_phonbkfi_tclMsgPreferredSortOrderListPureSet& coRef);
   most_phonbkfi_tclMsgPreferredSortOrderListPureSet(const most_phonbkfi_tclMsgPreferredSortOrderListPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkPreferredSortOrderList oPreferredSortOrderList;
   virtual ~most_phonbkfi_tclMsgPreferredSortOrderListPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgPreferredSortOrderListPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredSortOrderListError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgPreferredSortOrderListError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgPreferredSortOrderListError& operator=(const most_phonbkfi_tclMsgPreferredSortOrderListError& coRef);
   most_phonbkfi_tclMsgPreferredSortOrderListError(const most_phonbkfi_tclMsgPreferredSortOrderListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgPreferredSortOrderListError();

   tBool operator==(const most_phonbkfi_tclMsgPreferredSortOrderListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPreferredSortOrderListStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPreferredSortOrderListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgPreferredSortOrderListStatus& operator=(const most_phonbkfi_tclMsgPreferredSortOrderListStatus& coRef);
   most_phonbkfi_tclMsgPreferredSortOrderListStatus(const most_phonbkfi_tclMsgPreferredSortOrderListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_PhonBkPreferredSortOrderList oPreferredSortOrderList;
   virtual ~most_phonbkfi_tclMsgPreferredSortOrderListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgPreferredSortOrderListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPhonebookLanguageUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPhonebookLanguageUpReg();

   virtual ~most_phonbkfi_tclMsgPhonebookLanguageUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgPhonebookLanguageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPhonebookLanguageRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPhonebookLanguageRelUpReg();

   virtual ~most_phonbkfi_tclMsgPhonebookLanguageRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgPhonebookLanguageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPhonebookLanguageGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPhonebookLanguageGet();

   virtual ~most_phonbkfi_tclMsgPhonebookLanguageGet();

   inline tBool operator==(const most_phonbkfi_tclMsgPhonebookLanguageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPhonebookLanguageSet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPhonebookLanguageSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgPhonebookLanguageSet& operator=(const most_phonbkfi_tclMsgPhonebookLanguageSet& coRef);
   most_phonbkfi_tclMsgPhonebookLanguageSet(const most_phonbkfi_tclMsgPhonebookLanguageSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_PbkLanguage e8Language;
   virtual ~most_phonbkfi_tclMsgPhonebookLanguageSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgPhonebookLanguageSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPhonebookLanguageError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgPhonebookLanguageError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgPhonebookLanguageError& operator=(const most_phonbkfi_tclMsgPhonebookLanguageError& coRef);
   most_phonbkfi_tclMsgPhonebookLanguageError(const most_phonbkfi_tclMsgPhonebookLanguageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgPhonebookLanguageError();

   tBool operator==(const most_phonbkfi_tclMsgPhonebookLanguageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgPhonebookLanguageStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgPhonebookLanguageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgPhonebookLanguageStatus& operator=(const most_phonbkfi_tclMsgPhonebookLanguageStatus& coRef);
   most_phonbkfi_tclMsgPhonebookLanguageStatus(const most_phonbkfi_tclMsgPhonebookLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_PbkLanguage e8Language;
   virtual ~most_phonbkfi_tclMsgPhonebookLanguageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgPhonebookLanguageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMaxContactCountUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMaxContactCountUpReg();

   virtual ~most_phonbkfi_tclMsgMaxContactCountUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgMaxContactCountUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMaxContactCountRelUpReg : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMaxContactCountRelUpReg();

   virtual ~most_phonbkfi_tclMsgMaxContactCountRelUpReg();

   inline tBool operator==(const most_phonbkfi_tclMsgMaxContactCountRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMaxContactCountGet : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMaxContactCountGet();

   virtual ~most_phonbkfi_tclMsgMaxContactCountGet();

   inline tBool operator==(const most_phonbkfi_tclMsgMaxContactCountGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMaxContactCountError : public most_phonbkfi_tclMsgDefaultError
{
public:

   most_phonbkfi_tclMsgMaxContactCountError() : most_phonbkfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgMaxContactCountError& operator=(const most_phonbkfi_tclMsgMaxContactCountError& coRef);
   most_phonbkfi_tclMsgMaxContactCountError(const most_phonbkfi_tclMsgMaxContactCountError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_phonbkfi_tclMsgMaxContactCountError();

   tBool operator==(const most_phonbkfi_tclMsgMaxContactCountError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_phonbkfi_tclMsgMaxContactCountStatus : public most_phonbkfi_tclMsgBaseMessage
{
public:

   most_phonbkfi_tclMsgMaxContactCountStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_phonbkfi_tclMsgMaxContactCountStatus& operator=(const most_phonbkfi_tclMsgMaxContactCountStatus& coRef);
   most_phonbkfi_tclMsgMaxContactCountStatus(const most_phonbkfi_tclMsgMaxContactCountStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32MaxContactsCount;
   virtual ~most_phonbkfi_tclMsgMaxContactCountStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_phonbkfi_tclMsgMaxContactCountStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
