#ifndef __MOST_PHONBKFIDEBUGVISITOR_H__
#define __MOST_PHONBKFIDEBUGVISITOR_H__


///////////////////////////////////////////////////////////////////////////////
//
// special version including MOST compatible types
//
// declaration omitted intentionally for 
// bool, U8, U16, U24, U32, S8, S16, S24, S32, list and multilanguage string
//
///////////////////////////////////////////////////////////////////////////////


class MY_DECL most_phonbkfi_tclPrintVisitor : public most_phonbkfi_tclVisitorBase {
public:
   most_phonbkfi_tclPrintVisitor(most_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(most_fi_tclU8& oU8);
   virtual tVoid vVisitS8(most_fi_tclS8& oS8);
   virtual tVoid vVisitU16(most_fi_tclU16& oU16);
   virtual tVoid vVisitS16(most_fi_tclS16& oS16);
   virtual tVoid vVisitU32(most_fi_tclU32& oU32);
   virtual tVoid vVisitS32(most_fi_tclS32& oS32);
   virtual tVoid vVisitBool(most_fi_tclBool& oBool);

   // Besuche spezielle MOST-Typen
   virtual tVoid vVisit_String(most_fi_tcl_String& oString);
   virtual tVoid vVisit_TrailingStream(most_fi_tcl_TrailingStream& oContainer);
   virtual tVoid vVisit_ShortStream(most_fi_tcl_ShortStream& oContainer);
   virtual tVoid vVisit_ClassifiedStream(most_fi_tcl_ClassifiedStream& oContainer);

   // Besuche die generierten Typen
   virtual tVoid vVisit_e8_ErrorCode(most_fi_tcl_e8_ErrorCode& o_e8_ErrorCode);
   virtual tVoid vVisit_e8_PhonBkPhoneBookSortType(most_fi_tcl_e8_PhonBkPhoneBookSortType& o_e8_PhonBkPhoneBookSortType);
   virtual tBool bDoExpand_PhonBkSearchKeyboardListItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PhonBkContactDetailFilter(most_fi_tcl_e8_PhonBkContactDetailFilter& o_e8_PhonBkContactDetailFilter);
   virtual tBool bDoExpand_PhonBkHomeAddressLatLong(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkWorkAddressLatLong(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkOtherAddressLatLong(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkContactDetails(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PhonBkListChangeType(most_fi_tcl_e8_PhonBkListChangeType& o_e8_PhonBkListChangeType);
   virtual tVoid vVisit_e8_PhonBkListType(most_fi_tcl_e8_PhonBkListType& o_e8_PhonBkListType);
   virtual tVoid vVisit_e8_PhonBkContactAddStatus(most_fi_tcl_e8_PhonBkContactAddStatus& o_e8_PhonBkContactAddStatus);
   virtual tVoid vVisit_e8_PhonBkContactDeleteStatus(most_fi_tcl_e8_PhonBkContactDeleteStatus& o_e8_PhonBkContactDeleteStatus);
   virtual tVoid vVisit_e8_PhonBkContactEditStatus(most_fi_tcl_e8_PhonBkContactEditStatus& o_e8_PhonBkContactEditStatus);
   virtual tVoid vVisit_e8_PhonBkCallHistorySortType(most_fi_tcl_e8_PhonBkCallHistorySortType& o_e8_PhonBkCallHistorySortType);
   virtual tVoid vVisit_e8_PhonBkCallHistoryType(most_fi_tcl_e8_PhonBkCallHistoryType& o_e8_PhonBkCallHistoryType);
   virtual tVoid vVisit_e8_PhonBkCallPhoneType(most_fi_tcl_e8_PhonBkCallPhoneType& o_e8_PhonBkCallPhoneType);
   virtual tBool bDoExpand_PhonBkCallDate(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkCallTime(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkCallDateTime(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkCallHistoryListSliceResultItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PhonBkContactDetailType(most_fi_tcl_e8_PhonBkContactDetailType& o_e8_PhonBkContactDetailType);
   virtual tBool bDoExpand_PhonBkCallHistoryTypeSupport(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkAutocompleteMultipleMatchListItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkPhoneBookListSliceResultItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PhonBkPreferredPhoneBookSortOrder(most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder& o_e8_PhonBkPreferredPhoneBookSortOrder);
   virtual tVoid vVisit_e8_PhonBkRecentCallListDownloadState(most_fi_tcl_e8_PhonBkRecentCallListDownloadState& o_e8_PhonBkRecentCallListDownloadState);
   virtual tVoid vVisit_e8_PhonBkPhoneBookDownloadState(most_fi_tcl_e8_PhonBkPhoneBookDownloadState& o_e8_PhonBkPhoneBookDownloadState);
   virtual tBool bDoExpand_PhonBkDownloadStateStreamItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_FavPrvAudioChannel(most_fi_tcl_e8_FavPrvAudioChannel& o_e8_FavPrvAudioChannel);
   virtual tVoid vVisit_e8_FavPrvVideoChannel(most_fi_tcl_e8_FavPrvVideoChannel& o_e8_FavPrvVideoChannel);
   virtual tVoid vVisit_e8_FavPrvFavoriteType(most_fi_tcl_e8_FavPrvFavoriteType& o_e8_FavPrvFavoriteType);
   virtual tBool bDoExpand_FavPrvFavoriteInfoItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_FavPrvListChangeType(most_fi_tcl_e8_FavPrvListChangeType& o_e8_FavPrvListChangeType);
   virtual tVoid vVisit_e8_PhonBkNumberType(most_fi_tcl_e8_PhonBkNumberType& o_e8_PhonBkNumberType);
   virtual tBool bDoExpand_PhonBkCallHistoryListSliceResultExtenedItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkPhoneNumberItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PhonBkContactType(most_fi_tcl_e8_PhonBkContactType& o_e8_PhonBkContactType);
   virtual tBool bDoExpand_PhonBkPhoneBookListSliceResultExtendedItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PhonBkRecentCallListDownloadStateExtended(most_fi_tcl_e8_PhonBkRecentCallListDownloadStateExtended& o_e8_PhonBkRecentCallListDownloadStateExtended);
   virtual tVoid vVisit_e8_PhonBkPhoneBookDownloadStateExtended(most_fi_tcl_e8_PhonBkPhoneBookDownloadStateExtended& o_e8_PhonBkPhoneBookDownloadStateExtended);
   virtual tBool bDoExpand_PhonBkDownloadStateExtendedStreamItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PhonBkSearchSortType(most_fi_tcl_e8_PhonBkSearchSortType& o_e8_PhonBkSearchSortType);
   virtual tBool bDoExpand_PhonBkContactMatchListItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PhonBkSwitchDownloadOnOffState(most_fi_tcl_e8_PhonBkSwitchDownloadOnOffState& o_e8_PhonBkSwitchDownloadOnOffState);
   virtual tBool bDoExpand_PhonBkDownloadOnOffStateListItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PhonBkContactSortType(most_fi_tcl_e8_PhonBkContactSortType& o_e8_PhonBkContactSortType);
   virtual tVoid vVisit_e8_PhonBkContactListType(most_fi_tcl_e8_PhonBkContactListType& o_e8_PhonBkContactListType);
   virtual tBool bDoExpand_PhonBkContactDetailsExtended(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AutomaticContactDownloadListItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DevicePhoneBookFeatureSupportListItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkDownloadProgressListItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkMissedCallIndicatorListItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhonBkPreferredSortOrderListItem(most_phonbkfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PbkLanguage(most_fi_tcl_e8_PbkLanguage& o_e8_PbkLanguage);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   most_fi_tclOutput* poOutput;
};


///////////////////////////////////////////////////////////////////////////////
//
// special version including MOST compatible types
//
// declaration omitted intentionally for 
// bool, U8, U16, U24, U32, S8, S16, S24, S32, list and multilanguage string
//
///////////////////////////////////////////////////////////////////////////////


class MY_DECL most_phonbkfi_tclRandomInitVisitor : public most_phonbkfi_tclVisitorBase {
public:

   most_phonbkfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(most_fi_tclU8& oU8);
   virtual tVoid vVisitS8(most_fi_tclS8& oS8);
   virtual tVoid vVisitU16(most_fi_tclU16& oU16);
   virtual tVoid vVisitS16(most_fi_tclS16& oS16);
   virtual tVoid vVisitU32(most_fi_tclU32& oU32);
   virtual tVoid vVisitS32(most_fi_tclS32& oS32);
   virtual tVoid vVisitBool(most_fi_tclBool& oBool);

   // Besuche spezielle MOST-Typen
   virtual tVoid vVisit_String(most_fi_tcl_String& oString);
   virtual tVoid vVisit_TrailingStream(most_fi_tcl_TrailingStream& oContainer);
   virtual tVoid vVisit_ShortStream(most_fi_tcl_ShortStream& oContainer);
   virtual tVoid vVisit_ClassifiedStream(most_fi_tcl_ClassifiedStream& oContainer);

   // Besuche die generierten Typen
   virtual tVoid vVisit_e8_ErrorCode(most_fi_tcl_e8_ErrorCode& o_e8_ErrorCode);
   virtual tVoid vVisit_e8_PhonBkPhoneBookSortType(most_fi_tcl_e8_PhonBkPhoneBookSortType& o_e8_PhonBkPhoneBookSortType);
   virtual tVoid vVisit_e8_PhonBkContactDetailFilter(most_fi_tcl_e8_PhonBkContactDetailFilter& o_e8_PhonBkContactDetailFilter);
   virtual tVoid vVisit_e8_PhonBkListChangeType(most_fi_tcl_e8_PhonBkListChangeType& o_e8_PhonBkListChangeType);
   virtual tVoid vVisit_e8_PhonBkListType(most_fi_tcl_e8_PhonBkListType& o_e8_PhonBkListType);
   virtual tVoid vVisit_e8_PhonBkContactAddStatus(most_fi_tcl_e8_PhonBkContactAddStatus& o_e8_PhonBkContactAddStatus);
   virtual tVoid vVisit_e8_PhonBkContactDeleteStatus(most_fi_tcl_e8_PhonBkContactDeleteStatus& o_e8_PhonBkContactDeleteStatus);
   virtual tVoid vVisit_e8_PhonBkContactEditStatus(most_fi_tcl_e8_PhonBkContactEditStatus& o_e8_PhonBkContactEditStatus);
   virtual tVoid vVisit_e8_PhonBkCallHistorySortType(most_fi_tcl_e8_PhonBkCallHistorySortType& o_e8_PhonBkCallHistorySortType);
   virtual tVoid vVisit_e8_PhonBkCallHistoryType(most_fi_tcl_e8_PhonBkCallHistoryType& o_e8_PhonBkCallHistoryType);
   virtual tVoid vVisit_e8_PhonBkCallPhoneType(most_fi_tcl_e8_PhonBkCallPhoneType& o_e8_PhonBkCallPhoneType);
   virtual tVoid vVisit_e8_PhonBkContactDetailType(most_fi_tcl_e8_PhonBkContactDetailType& o_e8_PhonBkContactDetailType);
   virtual tVoid vVisit_e8_PhonBkPreferredPhoneBookSortOrder(most_fi_tcl_e8_PhonBkPreferredPhoneBookSortOrder& o_e8_PhonBkPreferredPhoneBookSortOrder);
   virtual tVoid vVisit_e8_PhonBkRecentCallListDownloadState(most_fi_tcl_e8_PhonBkRecentCallListDownloadState& o_e8_PhonBkRecentCallListDownloadState);
   virtual tVoid vVisit_e8_PhonBkPhoneBookDownloadState(most_fi_tcl_e8_PhonBkPhoneBookDownloadState& o_e8_PhonBkPhoneBookDownloadState);
   virtual tVoid vVisit_e8_FavPrvAudioChannel(most_fi_tcl_e8_FavPrvAudioChannel& o_e8_FavPrvAudioChannel);
   virtual tVoid vVisit_e8_FavPrvVideoChannel(most_fi_tcl_e8_FavPrvVideoChannel& o_e8_FavPrvVideoChannel);
   virtual tVoid vVisit_e8_FavPrvFavoriteType(most_fi_tcl_e8_FavPrvFavoriteType& o_e8_FavPrvFavoriteType);
   virtual tVoid vVisit_e8_FavPrvListChangeType(most_fi_tcl_e8_FavPrvListChangeType& o_e8_FavPrvListChangeType);
   virtual tVoid vVisit_e8_PhonBkNumberType(most_fi_tcl_e8_PhonBkNumberType& o_e8_PhonBkNumberType);
   virtual tVoid vVisit_e8_PhonBkContactType(most_fi_tcl_e8_PhonBkContactType& o_e8_PhonBkContactType);
   virtual tVoid vVisit_e8_PhonBkRecentCallListDownloadStateExtended(most_fi_tcl_e8_PhonBkRecentCallListDownloadStateExtended& o_e8_PhonBkRecentCallListDownloadStateExtended);
   virtual tVoid vVisit_e8_PhonBkPhoneBookDownloadStateExtended(most_fi_tcl_e8_PhonBkPhoneBookDownloadStateExtended& o_e8_PhonBkPhoneBookDownloadStateExtended);
   virtual tVoid vVisit_e8_PhonBkSearchSortType(most_fi_tcl_e8_PhonBkSearchSortType& o_e8_PhonBkSearchSortType);
   virtual tVoid vVisit_e8_PhonBkSwitchDownloadOnOffState(most_fi_tcl_e8_PhonBkSwitchDownloadOnOffState& o_e8_PhonBkSwitchDownloadOnOffState);
   virtual tVoid vVisit_e8_PhonBkContactSortType(most_fi_tcl_e8_PhonBkContactSortType& o_e8_PhonBkContactSortType);
   virtual tVoid vVisit_e8_PhonBkContactListType(most_fi_tcl_e8_PhonBkContactListType& o_e8_PhonBkContactListType);
   virtual tVoid vVisit_e8_PbkLanguage(most_fi_tcl_e8_PbkLanguage& o_e8_PbkLanguage);
	tU32 u32ListSize;
};

#endif
