/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MOST_MSGFITYPES_HEADER
#define MOST_MSGFITYPES_HEADER


class most_msgfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MOST_Msg_FI message types

fi_tclMessageBase* most_msgfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class most_msgfi_tclMsgBaseMessage : public most_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   most_msgfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

// base class for all most_msgfi standard error messages

class most_msgfi_tclMsgDefaultError: public most_msgfi_tclMsgBaseMessage
{
public:
   // member variables
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   most_fi_tcl_TrailingStream oErrorInfo;
   
   most_msgfi_tclMsgDefaultError() : e8ErrorCode(), oErrorInfo() {};
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDefaultError(const most_msgfi_tclMsgDefaultError& coRef);
   most_msgfi_tclMsgDefaultError& operator=(const most_msgfi_tclMsgDefaultError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
};

//=============================================================================

class most_msgfi_tclMsgAllocateMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAllocateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAllocateMethodStart& operator=(const most_msgfi_tclMsgAllocateMethodStart& coRef);
   most_msgfi_tclMsgAllocateMethodStart(const most_msgfi_tclMsgAllocateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_msgfi_tclMsgAllocateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAllocateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAllocateError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgAllocateError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAllocateError& operator=(const most_msgfi_tclMsgAllocateError& coRef);
   most_msgfi_tclMsgAllocateError(const most_msgfi_tclMsgAllocateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgAllocateError();

   tBool operator==(const most_msgfi_tclMsgAllocateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAllocateMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAllocateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAllocateMethodResult& operator=(const most_msgfi_tclMsgAllocateMethodResult& coRef);
   most_msgfi_tclMsgAllocateMethodResult(const most_msgfi_tclMsgAllocateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   tU16 u16BlockWidth;
   tU16 u16ConnectionLabel;
   virtual ~most_msgfi_tclMsgAllocateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAllocateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgDeAllocateMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgDeAllocateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDeAllocateMethodStart& operator=(const most_msgfi_tclMsgDeAllocateMethodStart& coRef);
   most_msgfi_tclMsgDeAllocateMethodStart(const most_msgfi_tclMsgDeAllocateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_msgfi_tclMsgDeAllocateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgDeAllocateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgDeAllocateError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgDeAllocateError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDeAllocateError& operator=(const most_msgfi_tclMsgDeAllocateError& coRef);
   most_msgfi_tclMsgDeAllocateError(const most_msgfi_tclMsgDeAllocateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgDeAllocateError();

   tBool operator==(const most_msgfi_tclMsgDeAllocateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgDeAllocateMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgDeAllocateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDeAllocateMethodResult& operator=(const most_msgfi_tclMsgDeAllocateMethodResult& coRef);
   most_msgfi_tclMsgDeAllocateMethodResult(const most_msgfi_tclMsgDeAllocateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_msgfi_tclMsgDeAllocateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgDeAllocateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceActivityMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSourceActivityMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSourceActivityMethodStart& operator=(const most_msgfi_tclMsgSourceActivityMethodStart& coRef);
   most_msgfi_tclMsgSourceActivityMethodStart(const most_msgfi_tclMsgSourceActivityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   most_fi_tcl_e8_SrcActivity e8Activity;
   virtual ~most_msgfi_tclMsgSourceActivityMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSourceActivityMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceActivityError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgSourceActivityError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSourceActivityError& operator=(const most_msgfi_tclMsgSourceActivityError& coRef);
   most_msgfi_tclMsgSourceActivityError(const most_msgfi_tclMsgSourceActivityError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgSourceActivityError();

   tBool operator==(const most_msgfi_tclMsgSourceActivityError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceActivityMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSourceActivityMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSourceActivityMethodResult& operator=(const most_msgfi_tclMsgSourceActivityMethodResult& coRef);
   most_msgfi_tclMsgSourceActivityMethodResult(const most_msgfi_tclMsgSourceActivityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   most_fi_tcl_e8_SrcActivity e8Activity;
   virtual ~most_msgfi_tclMsgSourceActivityMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSourceActivityMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgCreateMessageListMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgCreateMessageListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgCreateMessageListMethodStart& operator=(const most_msgfi_tclMsgCreateMessageListMethodStart& coRef);
   most_msgfi_tclMsgCreateMessageListMethodStart(const most_msgfi_tclMsgCreateMessageListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_e8_MsgFolderType e8FolderType;
   tU32 u32FolderHandle;
   most_fi_tcl_e8_MsgMessageListType e8MessageListType;
   most_fi_tcl_e8_MsgMessageListSortType e8MessageListSortType;
   most_fi_tcl_e8_MsgMessageListFilterType e8MessageListFilterType;
   virtual ~most_msgfi_tclMsgCreateMessageListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgCreateMessageListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgCreateMessageListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgCreateMessageListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgCreateMessageListError& operator=(const most_msgfi_tclMsgCreateMessageListError& coRef);
   most_msgfi_tclMsgCreateMessageListError(const most_msgfi_tclMsgCreateMessageListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgCreateMessageListError();

   tBool operator==(const most_msgfi_tclMsgCreateMessageListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgCreateMessageListMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgCreateMessageListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgCreateMessageListMethodResult& operator=(const most_msgfi_tclMsgCreateMessageListMethodResult& coRef);
   most_msgfi_tclMsgCreateMessageListMethodResult(const most_msgfi_tclMsgCreateMessageListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU16 u16ListLength;
   virtual ~most_msgfi_tclMsgCreateMessageListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgCreateMessageListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestSliceMessageListMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRequestSliceMessageListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestSliceMessageListMethodStart& operator=(const most_msgfi_tclMsgRequestSliceMessageListMethodStart& coRef);
   most_msgfi_tclMsgRequestSliceMessageListMethodStart(const most_msgfi_tclMsgRequestSliceMessageListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU32 u32WindowStart;
   tU32 u32WindowSize;
   virtual ~most_msgfi_tclMsgRequestSliceMessageListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRequestSliceMessageListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestSliceMessageListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgRequestSliceMessageListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestSliceMessageListError& operator=(const most_msgfi_tclMsgRequestSliceMessageListError& coRef);
   most_msgfi_tclMsgRequestSliceMessageListError(const most_msgfi_tclMsgRequestSliceMessageListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgRequestSliceMessageListError();

   tBool operator==(const most_msgfi_tclMsgRequestSliceMessageListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestSliceMessageListMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRequestSliceMessageListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestSliceMessageListMethodResult& operator=(const most_msgfi_tclMsgRequestSliceMessageListMethodResult& coRef);
   most_msgfi_tclMsgRequestSliceMessageListMethodResult(const most_msgfi_tclMsgRequestSliceMessageListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgMessageListSliceResult oMessageListSliceResult;
   virtual ~most_msgfi_tclMsgRequestSliceMessageListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRequestSliceMessageListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgReleaseMessageListMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgReleaseMessageListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgReleaseMessageListMethodStart& operator=(const most_msgfi_tclMsgReleaseMessageListMethodStart& coRef);
   most_msgfi_tclMsgReleaseMessageListMethodStart(const most_msgfi_tclMsgReleaseMessageListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   virtual ~most_msgfi_tclMsgReleaseMessageListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgReleaseMessageListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgReleaseMessageListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgReleaseMessageListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgReleaseMessageListError& operator=(const most_msgfi_tclMsgReleaseMessageListError& coRef);
   most_msgfi_tclMsgReleaseMessageListError(const most_msgfi_tclMsgReleaseMessageListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgReleaseMessageListError();

   tBool operator==(const most_msgfi_tclMsgReleaseMessageListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgReleaseMessageListMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgReleaseMessageListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgReleaseMessageListMethodResult& operator=(const most_msgfi_tclMsgReleaseMessageListMethodResult& coRef);
   most_msgfi_tclMsgReleaseMessageListMethodResult(const most_msgfi_tclMsgReleaseMessageListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   virtual ~most_msgfi_tclMsgReleaseMessageListMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgReleaseMessageListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestFolderListMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRequestFolderListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestFolderListMethodStart& operator=(const most_msgfi_tclMsgRequestFolderListMethodStart& coRef);
   most_msgfi_tclMsgRequestFolderListMethodStart(const most_msgfi_tclMsgRequestFolderListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32FolderHandle;
   tBool bRootFlag;
   virtual ~most_msgfi_tclMsgRequestFolderListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRequestFolderListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestFolderListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgRequestFolderListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestFolderListError& operator=(const most_msgfi_tclMsgRequestFolderListError& coRef);
   most_msgfi_tclMsgRequestFolderListError(const most_msgfi_tclMsgRequestFolderListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgRequestFolderListError();

   tBool operator==(const most_msgfi_tclMsgRequestFolderListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestFolderListMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRequestFolderListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestFolderListMethodResult& operator=(const most_msgfi_tclMsgRequestFolderListMethodResult& coRef);
   most_msgfi_tclMsgRequestFolderListMethodResult(const most_msgfi_tclMsgRequestFolderListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgFolderListResult oFolderListResult;
   virtual ~most_msgfi_tclMsgRequestFolderListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRequestFolderListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgDeleteMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgDeleteMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDeleteMessageMethodStart& operator=(const most_msgfi_tclMsgDeleteMessageMethodStart& coRef);
   most_msgfi_tclMsgDeleteMessageMethodStart(const most_msgfi_tclMsgDeleteMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgDeleteMessageHandles oDeleteMessageHandles;
   virtual ~most_msgfi_tclMsgDeleteMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgDeleteMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgDeleteMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgDeleteMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDeleteMessageError& operator=(const most_msgfi_tclMsgDeleteMessageError& coRef);
   most_msgfi_tclMsgDeleteMessageError(const most_msgfi_tclMsgDeleteMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgDeleteMessageError();

   tBool operator==(const most_msgfi_tclMsgDeleteMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgDeleteMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgDeleteMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDeleteMessageMethodResult& operator=(const most_msgfi_tclMsgDeleteMessageMethodResult& coRef);
   most_msgfi_tclMsgDeleteMessageMethodResult(const most_msgfi_tclMsgDeleteMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgDeletionStatus e8DeletionStatus;
   most_fi_tcl_MsgDeleteMessageHandles oDeleteMessageHandles;
   virtual ~most_msgfi_tclMsgDeleteMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgDeleteMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecoverMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRecoverMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRecoverMessageMethodStart& operator=(const most_msgfi_tclMsgRecoverMessageMethodStart& coRef);
   most_msgfi_tclMsgRecoverMessageMethodStart(const most_msgfi_tclMsgRecoverMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgMessageHandle oMessageHandle;
   virtual ~most_msgfi_tclMsgRecoverMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRecoverMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecoverMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgRecoverMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRecoverMessageError& operator=(const most_msgfi_tclMsgRecoverMessageError& coRef);
   most_msgfi_tclMsgRecoverMessageError(const most_msgfi_tclMsgRecoverMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgRecoverMessageError();

   tBool operator==(const most_msgfi_tclMsgRecoverMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecoverMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRecoverMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRecoverMessageMethodResult& operator=(const most_msgfi_tclMsgRecoverMessageMethodResult& coRef);
   most_msgfi_tclMsgRecoverMessageMethodResult(const most_msgfi_tclMsgRecoverMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgRecoveryStatus e8RecoveryStatus;
   most_fi_tcl_MsgMessageHandle oMessageHandle;
   virtual ~most_msgfi_tclMsgRecoverMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRecoverMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestAccountListMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRequestAccountListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestAccountListMethodStart& operator=(const most_msgfi_tclMsgRequestAccountListMethodStart& coRef);
   most_msgfi_tclMsgRequestAccountListMethodStart(const most_msgfi_tclMsgRequestAccountListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_msgfi_tclMsgRequestAccountListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRequestAccountListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestAccountListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgRequestAccountListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestAccountListError& operator=(const most_msgfi_tclMsgRequestAccountListError& coRef);
   most_msgfi_tclMsgRequestAccountListError(const most_msgfi_tclMsgRequestAccountListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgRequestAccountListError();

   tBool operator==(const most_msgfi_tclMsgRequestAccountListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestAccountListMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRequestAccountListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestAccountListMethodResult& operator=(const most_msgfi_tclMsgRequestAccountListMethodResult& coRef);
   most_msgfi_tclMsgRequestAccountListMethodResult(const most_msgfi_tclMsgRequestAccountListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgAccountListResult oAccountListResult;
   virtual ~most_msgfi_tclMsgRequestAccountListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRequestAccountListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgChangeAccountMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgChangeAccountMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgChangeAccountMethodStart& operator=(const most_msgfi_tclMsgChangeAccountMethodStart& coRef);
   most_msgfi_tclMsgChangeAccountMethodStart(const most_msgfi_tclMsgChangeAccountMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16AccountHandle;
   virtual ~most_msgfi_tclMsgChangeAccountMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgChangeAccountMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgChangeAccountError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgChangeAccountError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgChangeAccountError& operator=(const most_msgfi_tclMsgChangeAccountError& coRef);
   most_msgfi_tclMsgChangeAccountError(const most_msgfi_tclMsgChangeAccountError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgChangeAccountError();

   tBool operator==(const most_msgfi_tclMsgChangeAccountError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgChangeAccountMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgChangeAccountMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgChangeAccountMethodResult& operator=(const most_msgfi_tclMsgChangeAccountMethodResult& coRef);
   most_msgfi_tclMsgChangeAccountMethodResult(const most_msgfi_tclMsgChangeAccountMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAccountConnectionResult;
   virtual ~most_msgfi_tclMsgChangeAccountMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgChangeAccountMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgUpdateInboxMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgUpdateInboxMethodStart();

   virtual ~most_msgfi_tclMsgUpdateInboxMethodStart();

   inline tBool operator==(const most_msgfi_tclMsgUpdateInboxMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgUpdateInboxError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgUpdateInboxError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgUpdateInboxError& operator=(const most_msgfi_tclMsgUpdateInboxError& coRef);
   most_msgfi_tclMsgUpdateInboxError(const most_msgfi_tclMsgUpdateInboxError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgUpdateInboxError();

   tBool operator==(const most_msgfi_tclMsgUpdateInboxError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgUpdateInboxMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgUpdateInboxMethodResult();

   virtual ~most_msgfi_tclMsgUpdateInboxMethodResult();

   inline tBool operator==(const most_msgfi_tclMsgUpdateInboxMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetMessageMethodStart& operator=(const most_msgfi_tclMsgGetMessageMethodStart& coRef);
   most_msgfi_tclMsgGetMessageMethodStart(const most_msgfi_tclMsgGetMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgMessageHandle oMessageHandle;
   virtual ~most_msgfi_tclMsgGetMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgGetMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetMessageError& operator=(const most_msgfi_tclMsgGetMessageError& coRef);
   most_msgfi_tclMsgGetMessageError(const most_msgfi_tclMsgGetMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgGetMessageError();

   tBool operator==(const most_msgfi_tclMsgGetMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetMessageMethodResult& operator=(const most_msgfi_tclMsgGetMessageMethodResult& coRef);
   most_msgfi_tclMsgGetMessageMethodResult(const most_msgfi_tclMsgGetMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgMessageDetailsResult oMessageDetailsResult;
   virtual ~most_msgfi_tclMsgGetMessageMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetAttachmentListMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetAttachmentListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetAttachmentListMethodStart& operator=(const most_msgfi_tclMsgGetAttachmentListMethodStart& coRef);
   most_msgfi_tclMsgGetAttachmentListMethodStart(const most_msgfi_tclMsgGetAttachmentListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgMessageHandle oMessageHandle;
   virtual ~most_msgfi_tclMsgGetAttachmentListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetAttachmentListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetAttachmentListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgGetAttachmentListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetAttachmentListError& operator=(const most_msgfi_tclMsgGetAttachmentListError& coRef);
   most_msgfi_tclMsgGetAttachmentListError(const most_msgfi_tclMsgGetAttachmentListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgGetAttachmentListError();

   tBool operator==(const most_msgfi_tclMsgGetAttachmentListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetAttachmentListMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetAttachmentListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetAttachmentListMethodResult& operator=(const most_msgfi_tclMsgGetAttachmentListMethodResult& coRef);
   most_msgfi_tclMsgGetAttachmentListMethodResult(const most_msgfi_tclMsgGetAttachmentListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgAttachmentList oAttachmentList;
   virtual ~most_msgfi_tclMsgGetAttachmentListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetAttachmentListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart& operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart& coRef);
   most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16AttachmentHandle;
   most_fi_tcl_e8_MsgPlaybackAction e8PlaybackAction;
   virtual ~most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioAttachmentPlaybackError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgAudioAttachmentPlaybackError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAudioAttachmentPlaybackError& operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackError& coRef);
   most_msgfi_tclMsgAudioAttachmentPlaybackError(const most_msgfi_tclMsgAudioAttachmentPlaybackError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgAudioAttachmentPlaybackError();

   tBool operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult& operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult& coRef);
   most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgPlaybackAction e8PlaybackAction;
   virtual ~most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetImageAttachmentMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetImageAttachmentMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetImageAttachmentMethodStart& operator=(const most_msgfi_tclMsgGetImageAttachmentMethodStart& coRef);
   most_msgfi_tclMsgGetImageAttachmentMethodStart(const most_msgfi_tclMsgGetImageAttachmentMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16AttachmentHandle;
   virtual ~most_msgfi_tclMsgGetImageAttachmentMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetImageAttachmentMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetImageAttachmentError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgGetImageAttachmentError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetImageAttachmentError& operator=(const most_msgfi_tclMsgGetImageAttachmentError& coRef);
   most_msgfi_tclMsgGetImageAttachmentError(const most_msgfi_tclMsgGetImageAttachmentError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgGetImageAttachmentError();

   tBool operator==(const most_msgfi_tclMsgGetImageAttachmentError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetImageAttachmentMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetImageAttachmentMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetImageAttachmentMethodResult& operator=(const most_msgfi_tclMsgGetImageAttachmentMethodResult& coRef);
   most_msgfi_tclMsgGetImageAttachmentMethodResult(const most_msgfi_tclMsgGetImageAttachmentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DataByte;
   virtual ~most_msgfi_tclMsgGetImageAttachmentMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetImageAttachmentMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetBodyPartListMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetBodyPartListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetBodyPartListMethodStart& operator=(const most_msgfi_tclMsgGetBodyPartListMethodStart& coRef);
   most_msgfi_tclMsgGetBodyPartListMethodStart(const most_msgfi_tclMsgGetBodyPartListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgMessageHandle oMessageHandle;
   virtual ~most_msgfi_tclMsgGetBodyPartListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetBodyPartListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetBodyPartListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgGetBodyPartListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetBodyPartListError& operator=(const most_msgfi_tclMsgGetBodyPartListError& coRef);
   most_msgfi_tclMsgGetBodyPartListError(const most_msgfi_tclMsgGetBodyPartListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgGetBodyPartListError();

   tBool operator==(const most_msgfi_tclMsgGetBodyPartListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetBodyPartListMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetBodyPartListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetBodyPartListMethodResult& operator=(const most_msgfi_tclMsgGetBodyPartListMethodResult& coRef);
   most_msgfi_tclMsgGetBodyPartListMethodResult(const most_msgfi_tclMsgGetBodyPartListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgBodyPartList oBodyPartList;
   virtual ~most_msgfi_tclMsgGetBodyPartListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetBodyPartListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgReadMessageAloudMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgReadMessageAloudMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgReadMessageAloudMethodStart& operator=(const most_msgfi_tclMsgReadMessageAloudMethodStart& coRef);
   most_msgfi_tclMsgReadMessageAloudMethodStart(const most_msgfi_tclMsgReadMessageAloudMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgMessageHandle oMessageHandle;
   most_fi_tcl_e8_MsgPlaybackAction e8PlaybackAction;
   tU8 u8LogicalAVChannel;
   most_fi_tcl_e8_MsgTTSLanguage e8TTSLanguage;
   virtual ~most_msgfi_tclMsgReadMessageAloudMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgReadMessageAloudMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgReadMessageAloudError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgReadMessageAloudError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgReadMessageAloudError& operator=(const most_msgfi_tclMsgReadMessageAloudError& coRef);
   most_msgfi_tclMsgReadMessageAloudError(const most_msgfi_tclMsgReadMessageAloudError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgReadMessageAloudError();

   tBool operator==(const most_msgfi_tclMsgReadMessageAloudError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgReadMessageAloudMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgReadMessageAloudMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgReadMessageAloudMethodResult& operator=(const most_msgfi_tclMsgReadMessageAloudMethodResult& coRef);
   most_msgfi_tclMsgReadMessageAloudMethodResult(const most_msgfi_tclMsgReadMessageAloudMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgPlaybackAction e8PlaybackAction;
   virtual ~most_msgfi_tclMsgReadMessageAloudMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgReadMessageAloudMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecordAudioMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRecordAudioMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRecordAudioMessageMethodStart& operator=(const most_msgfi_tclMsgRecordAudioMessageMethodStart& coRef);
   most_msgfi_tclMsgRecordAudioMessageMethodStart(const most_msgfi_tclMsgRecordAudioMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgRecordMessageAction e8RecordMessageAction;
   tU8 u8LogicalAVChannel;
   virtual ~most_msgfi_tclMsgRecordAudioMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRecordAudioMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecordAudioMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgRecordAudioMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRecordAudioMessageError& operator=(const most_msgfi_tclMsgRecordAudioMessageError& coRef);
   most_msgfi_tclMsgRecordAudioMessageError(const most_msgfi_tclMsgRecordAudioMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgRecordAudioMessageError();

   tBool operator==(const most_msgfi_tclMsgRecordAudioMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecordAudioMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRecordAudioMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRecordAudioMessageMethodResult& operator=(const most_msgfi_tclMsgRecordAudioMessageMethodResult& coRef);
   most_msgfi_tclMsgRecordAudioMessageMethodResult(const most_msgfi_tclMsgRecordAudioMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16RecordedAudioMessageHandle;
   virtual ~most_msgfi_tclMsgRecordAudioMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRecordAudioMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPlaybackAudioMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPlaybackAudioMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgPlaybackAudioMessageMethodStart& operator=(const most_msgfi_tclMsgPlaybackAudioMessageMethodStart& coRef);
   most_msgfi_tclMsgPlaybackAudioMessageMethodStart(const most_msgfi_tclMsgPlaybackAudioMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16RecordedAudioMessageHandle;
   most_fi_tcl_e8_MsgPlaybackAction e8PlaybackAction;
   virtual ~most_msgfi_tclMsgPlaybackAudioMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgPlaybackAudioMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPlaybackAudioMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgPlaybackAudioMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgPlaybackAudioMessageError& operator=(const most_msgfi_tclMsgPlaybackAudioMessageError& coRef);
   most_msgfi_tclMsgPlaybackAudioMessageError(const most_msgfi_tclMsgPlaybackAudioMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgPlaybackAudioMessageError();

   tBool operator==(const most_msgfi_tclMsgPlaybackAudioMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPlaybackAudioMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPlaybackAudioMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgPlaybackAudioMessageMethodResult& operator=(const most_msgfi_tclMsgPlaybackAudioMessageMethodResult& coRef);
   most_msgfi_tclMsgPlaybackAudioMessageMethodResult(const most_msgfi_tclMsgPlaybackAudioMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgPlaybackState e8PlaybackState;
   virtual ~most_msgfi_tclMsgPlaybackAudioMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgPlaybackAudioMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAddPredefinedMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAddPredefinedMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAddPredefinedMessageMethodStart& operator=(const most_msgfi_tclMsgAddPredefinedMessageMethodStart& coRef);
   most_msgfi_tclMsgAddPredefinedMessageMethodStart(const most_msgfi_tclMsgAddPredefinedMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sPredefinedMessageText;
   virtual ~most_msgfi_tclMsgAddPredefinedMessageMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAddPredefinedMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAddPredefinedMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgAddPredefinedMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAddPredefinedMessageError& operator=(const most_msgfi_tclMsgAddPredefinedMessageError& coRef);
   most_msgfi_tclMsgAddPredefinedMessageError(const most_msgfi_tclMsgAddPredefinedMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgAddPredefinedMessageError();

   tBool operator==(const most_msgfi_tclMsgAddPredefinedMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAddPredefinedMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAddPredefinedMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAddPredefinedMessageMethodResult& operator=(const most_msgfi_tclMsgAddPredefinedMessageMethodResult& coRef);
   most_msgfi_tclMsgAddPredefinedMessageMethodResult(const most_msgfi_tclMsgAddPredefinedMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16PredefinedMessageHandle;
   virtual ~most_msgfi_tclMsgAddPredefinedMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAddPredefinedMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgDeletePredefinedMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgDeletePredefinedMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDeletePredefinedMessageMethodStart& operator=(const most_msgfi_tclMsgDeletePredefinedMessageMethodStart& coRef);
   most_msgfi_tclMsgDeletePredefinedMessageMethodStart(const most_msgfi_tclMsgDeletePredefinedMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16PredefinedMessageHandle;
   virtual ~most_msgfi_tclMsgDeletePredefinedMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgDeletePredefinedMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgDeletePredefinedMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgDeletePredefinedMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDeletePredefinedMessageError& operator=(const most_msgfi_tclMsgDeletePredefinedMessageError& coRef);
   most_msgfi_tclMsgDeletePredefinedMessageError(const most_msgfi_tclMsgDeletePredefinedMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgDeletePredefinedMessageError();

   tBool operator==(const most_msgfi_tclMsgDeletePredefinedMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgDeletePredefinedMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgDeletePredefinedMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgDeletePredefinedMessageMethodResult& operator=(const most_msgfi_tclMsgDeletePredefinedMessageMethodResult& coRef);
   most_msgfi_tclMsgDeletePredefinedMessageMethodResult(const most_msgfi_tclMsgDeletePredefinedMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16PredefinedMessageHandle;
   virtual ~most_msgfi_tclMsgDeletePredefinedMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgDeletePredefinedMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetConversationMessagesMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetConversationMessagesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetConversationMessagesMethodStart& operator=(const most_msgfi_tclMsgGetConversationMessagesMethodStart& coRef);
   most_msgfi_tclMsgGetConversationMessagesMethodStart(const most_msgfi_tclMsgGetConversationMessagesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgMessageHandle oMessageHandle;
   virtual ~most_msgfi_tclMsgGetConversationMessagesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetConversationMessagesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetConversationMessagesError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgGetConversationMessagesError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetConversationMessagesError& operator=(const most_msgfi_tclMsgGetConversationMessagesError& coRef);
   most_msgfi_tclMsgGetConversationMessagesError(const most_msgfi_tclMsgGetConversationMessagesError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgGetConversationMessagesError();

   tBool operator==(const most_msgfi_tclMsgGetConversationMessagesError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetConversationMessagesMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetConversationMessagesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetConversationMessagesMethodResult& operator=(const most_msgfi_tclMsgGetConversationMessagesMethodResult& coRef);
   most_msgfi_tclMsgGetConversationMessagesMethodResult(const most_msgfi_tclMsgGetConversationMessagesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgConversationMessages oConversationMessages;
   virtual ~most_msgfi_tclMsgGetConversationMessagesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetConversationMessagesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSendMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSendMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSendMessageMethodStart& operator=(const most_msgfi_tclMsgSendMessageMethodStart& coRef);
   most_msgfi_tclMsgSendMessageMethodStart(const most_msgfi_tclMsgSendMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8CreateMessageHandle;
   most_fi_tcl_e8_MsgFolderType e8FolderType;
   virtual ~most_msgfi_tclMsgSendMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSendMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSendMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgSendMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSendMessageError& operator=(const most_msgfi_tclMsgSendMessageError& coRef);
   most_msgfi_tclMsgSendMessageError(const most_msgfi_tclMsgSendMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgSendMessageError();

   tBool operator==(const most_msgfi_tclMsgSendMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSendMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSendMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSendMessageMethodResult& operator=(const most_msgfi_tclMsgSendMessageMethodResult& coRef);
   most_msgfi_tclMsgSendMessageMethodResult(const most_msgfi_tclMsgSendMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgSentMessageStatus e8SentMessageStatus;
   most_fi_tcl_MsgMessageHandle oMessageHandle;
   virtual ~most_msgfi_tclMsgSendMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSendMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgProvideMessageHeaderMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgProvideMessageHeaderMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgProvideMessageHeaderMethodStart& operator=(const most_msgfi_tclMsgProvideMessageHeaderMethodStart& coRef);
   most_msgfi_tclMsgProvideMessageHeaderMethodStart(const most_msgfi_tclMsgProvideMessageHeaderMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8CreateMessageHandle;
   most_fi_tcl_String sSubject;
   most_fi_tcl_MsgAddressField oAddressField;
   virtual ~most_msgfi_tclMsgProvideMessageHeaderMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgProvideMessageHeaderMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgProvideMessageHeaderError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgProvideMessageHeaderError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgProvideMessageHeaderError& operator=(const most_msgfi_tclMsgProvideMessageHeaderError& coRef);
   most_msgfi_tclMsgProvideMessageHeaderError(const most_msgfi_tclMsgProvideMessageHeaderError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgProvideMessageHeaderError();

   tBool operator==(const most_msgfi_tclMsgProvideMessageHeaderError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgProvideMessageHeaderMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgProvideMessageHeaderMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgProvideMessageHeaderMethodResult& operator=(const most_msgfi_tclMsgProvideMessageHeaderMethodResult& coRef);
   most_msgfi_tclMsgProvideMessageHeaderMethodResult(const most_msgfi_tclMsgProvideMessageHeaderMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8CreateMessageHandle;
   virtual ~most_msgfi_tclMsgProvideMessageHeaderMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgProvideMessageHeaderMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgProvideMessageBodyMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgProvideMessageBodyMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgProvideMessageBodyMethodStart& operator=(const most_msgfi_tclMsgProvideMessageBodyMethodStart& coRef);
   most_msgfi_tclMsgProvideMessageBodyMethodStart(const most_msgfi_tclMsgProvideMessageBodyMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8CreateMessageHandle;
   tU16 u16RecordedAudioMessageHandle;
   most_fi_tcl_MsgAttachmentHandleStream oAttachmentHandleStream;
   tU16 u16NumMessageBodyTextElements;
   most_fi_tcl_MsgMessageBodyText oMessageBodyText;
   virtual ~most_msgfi_tclMsgProvideMessageBodyMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgProvideMessageBodyMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgProvideMessageBodyError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgProvideMessageBodyError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgProvideMessageBodyError& operator=(const most_msgfi_tclMsgProvideMessageBodyError& coRef);
   most_msgfi_tclMsgProvideMessageBodyError(const most_msgfi_tclMsgProvideMessageBodyError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgProvideMessageBodyError();

   tBool operator==(const most_msgfi_tclMsgProvideMessageBodyError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgProvideMessageBodyMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgProvideMessageBodyMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgProvideMessageBodyMethodResult& operator=(const most_msgfi_tclMsgProvideMessageBodyMethodResult& coRef);
   most_msgfi_tclMsgProvideMessageBodyMethodResult(const most_msgfi_tclMsgProvideMessageBodyMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8CreateMessageHandle;
   virtual ~most_msgfi_tclMsgProvideMessageBodyMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgProvideMessageBodyMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetMsgBodyActionElementMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetMsgBodyActionElementMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetMsgBodyActionElementMethodStart& operator=(const most_msgfi_tclMsgGetMsgBodyActionElementMethodStart& coRef);
   most_msgfi_tclMsgGetMsgBodyActionElementMethodStart(const most_msgfi_tclMsgGetMsgBodyActionElementMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8MsgBodyActionElementTag;
   virtual ~most_msgfi_tclMsgGetMsgBodyActionElementMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetMsgBodyActionElementMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetMsgBodyActionElementError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgGetMsgBodyActionElementError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetMsgBodyActionElementError& operator=(const most_msgfi_tclMsgGetMsgBodyActionElementError& coRef);
   most_msgfi_tclMsgGetMsgBodyActionElementError(const most_msgfi_tclMsgGetMsgBodyActionElementError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgGetMsgBodyActionElementError();

   tBool operator==(const most_msgfi_tclMsgGetMsgBodyActionElementError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetMsgBodyActionElementMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetMsgBodyActionElementMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetMsgBodyActionElementMethodResult& operator=(const most_msgfi_tclMsgGetMsgBodyActionElementMethodResult& coRef);
   most_msgfi_tclMsgGetMsgBodyActionElementMethodResult(const most_msgfi_tclMsgGetMsgBodyActionElementMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgActionElementType e8ActionElementType;
   most_fi_tcl_String sPhoneNumber;
   most_fi_tcl_String sEmailAddress;
   most_fi_tcl_String sAddress;
   virtual ~most_msgfi_tclMsgGetMsgBodyActionElementMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetMsgBodyActionElementMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetImageAttachmentInfoMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetImageAttachmentInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetImageAttachmentInfoMethodStart& operator=(const most_msgfi_tclMsgGetImageAttachmentInfoMethodStart& coRef);
   most_msgfi_tclMsgGetImageAttachmentInfoMethodStart(const most_msgfi_tclMsgGetImageAttachmentInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16AttachmentHandle;
   virtual ~most_msgfi_tclMsgGetImageAttachmentInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetImageAttachmentInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetImageAttachmentInfoError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgGetImageAttachmentInfoError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetImageAttachmentInfoError& operator=(const most_msgfi_tclMsgGetImageAttachmentInfoError& coRef);
   most_msgfi_tclMsgGetImageAttachmentInfoError(const most_msgfi_tclMsgGetImageAttachmentInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgGetImageAttachmentInfoError();

   tBool operator==(const most_msgfi_tclMsgGetImageAttachmentInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetImageAttachmentInfoMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetImageAttachmentInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetImageAttachmentInfoMethodResult& operator=(const most_msgfi_tclMsgGetImageAttachmentInfoMethodResult& coRef);
   most_msgfi_tclMsgGetImageAttachmentInfoMethodResult(const most_msgfi_tclMsgGetImageAttachmentInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sMIMEImageSubtype;
   tU32 u32ImageSize;
   virtual ~most_msgfi_tclMsgGetImageAttachmentInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetImageAttachmentInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgCreateMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgCreateMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgCreateMessageMethodStart& operator=(const most_msgfi_tclMsgCreateMessageMethodStart& coRef);
   most_msgfi_tclMsgCreateMessageMethodStart(const most_msgfi_tclMsgCreateMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8CreateMessageHandle;
   most_fi_tcl_MsgMessageHandle oMessageHandle;
   most_fi_tcl_e8_MsgMessageType e8MessageType;
   most_fi_tcl_e8_MsgCreateMessageType e8CreateMessageType;
   virtual ~most_msgfi_tclMsgCreateMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgCreateMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgCreateMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgCreateMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgCreateMessageError& operator=(const most_msgfi_tclMsgCreateMessageError& coRef);
   most_msgfi_tclMsgCreateMessageError(const most_msgfi_tclMsgCreateMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgCreateMessageError();

   tBool operator==(const most_msgfi_tclMsgCreateMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgCreateMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgCreateMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgCreateMessageMethodResult& operator=(const most_msgfi_tclMsgCreateMessageMethodResult& coRef);
   most_msgfi_tclMsgCreateMessageMethodResult(const most_msgfi_tclMsgCreateMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8CreateMessageHandle;
   virtual ~most_msgfi_tclMsgCreateMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgCreateMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgClearUserMessagingInfoMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgClearUserMessagingInfoMethodStart();

   virtual ~most_msgfi_tclMsgClearUserMessagingInfoMethodStart();

   inline tBool operator==(const most_msgfi_tclMsgClearUserMessagingInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgClearUserMessagingInfoError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgClearUserMessagingInfoError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgClearUserMessagingInfoError& operator=(const most_msgfi_tclMsgClearUserMessagingInfoError& coRef);
   most_msgfi_tclMsgClearUserMessagingInfoError(const most_msgfi_tclMsgClearUserMessagingInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgClearUserMessagingInfoError();

   tBool operator==(const most_msgfi_tclMsgClearUserMessagingInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgClearUserMessagingInfoMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgClearUserMessagingInfoMethodResult();

   virtual ~most_msgfi_tclMsgClearUserMessagingInfoMethodResult();

   inline tBool operator==(const most_msgfi_tclMsgClearUserMessagingInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgConnectMapProfileMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgConnectMapProfileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgConnectMapProfileMethodStart& operator=(const most_msgfi_tclMsgConnectMapProfileMethodStart& coRef);
   most_msgfi_tclMsgConnectMapProfileMethodStart(const most_msgfi_tclMsgConnectMapProfileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceHandle;
   tU8 RetryCount;
   virtual ~most_msgfi_tclMsgConnectMapProfileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgConnectMapProfileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgConnectMapProfileError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgConnectMapProfileError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgConnectMapProfileError& operator=(const most_msgfi_tclMsgConnectMapProfileError& coRef);
   most_msgfi_tclMsgConnectMapProfileError(const most_msgfi_tclMsgConnectMapProfileError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgConnectMapProfileError();

   tBool operator==(const most_msgfi_tclMsgConnectMapProfileError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgConnectMapProfileMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgConnectMapProfileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgConnectMapProfileMethodResult& operator=(const most_msgfi_tclMsgConnectMapProfileMethodResult& coRef);
   most_msgfi_tclMsgConnectMapProfileMethodResult(const most_msgfi_tclMsgConnectMapProfileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DeviceHandle;
   virtual ~most_msgfi_tclMsgConnectMapProfileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgConnectMapProfileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgEditPredefinedMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgEditPredefinedMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgEditPredefinedMessageMethodStart& operator=(const most_msgfi_tclMsgEditPredefinedMessageMethodStart& coRef);
   most_msgfi_tclMsgEditPredefinedMessageMethodStart(const most_msgfi_tclMsgEditPredefinedMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16PredefinedMessageHandle;
   most_fi_tcl_String sPredefinedMessageText;
   most_fi_tcl_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory;
   virtual ~most_msgfi_tclMsgEditPredefinedMessageMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgEditPredefinedMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgEditPredefinedMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgEditPredefinedMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgEditPredefinedMessageError& operator=(const most_msgfi_tclMsgEditPredefinedMessageError& coRef);
   most_msgfi_tclMsgEditPredefinedMessageError(const most_msgfi_tclMsgEditPredefinedMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgEditPredefinedMessageError();

   tBool operator==(const most_msgfi_tclMsgEditPredefinedMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgEditPredefinedMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgEditPredefinedMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgEditPredefinedMessageMethodResult& operator=(const most_msgfi_tclMsgEditPredefinedMessageMethodResult& coRef);
   most_msgfi_tclMsgEditPredefinedMessageMethodResult(const most_msgfi_tclMsgEditPredefinedMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16PredefinedMessageHandle;
   virtual ~most_msgfi_tclMsgEditPredefinedMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgEditPredefinedMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart& operator=(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart& coRef);
   most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory;
   most_fi_tcl_String sPredefinedMessageText;
   virtual ~most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAddPredefinedMessageExtendedError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgAddPredefinedMessageExtendedError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAddPredefinedMessageExtendedError& operator=(const most_msgfi_tclMsgAddPredefinedMessageExtendedError& coRef);
   most_msgfi_tclMsgAddPredefinedMessageExtendedError(const most_msgfi_tclMsgAddPredefinedMessageExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgAddPredefinedMessageExtendedError();

   tBool operator==(const most_msgfi_tclMsgAddPredefinedMessageExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult& operator=(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult& coRef);
   most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16PredefinedMessageHandle;
   virtual ~most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgReadMessageAloudExtendedMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgReadMessageAloudExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgReadMessageAloudExtendedMethodStart& operator=(const most_msgfi_tclMsgReadMessageAloudExtendedMethodStart& coRef);
   most_msgfi_tclMsgReadMessageAloudExtendedMethodStart(const most_msgfi_tclMsgReadMessageAloudExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgPlaybackAction e8PlaybackAction;
   most_fi_tcl_String sReadAloudContent;
   virtual ~most_msgfi_tclMsgReadMessageAloudExtendedMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgReadMessageAloudExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgReadMessageAloudExtendedError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgReadMessageAloudExtendedError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgReadMessageAloudExtendedError& operator=(const most_msgfi_tclMsgReadMessageAloudExtendedError& coRef);
   most_msgfi_tclMsgReadMessageAloudExtendedError(const most_msgfi_tclMsgReadMessageAloudExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgReadMessageAloudExtendedError();

   tBool operator==(const most_msgfi_tclMsgReadMessageAloudExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgReadMessageAloudExtendedMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgReadMessageAloudExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgReadMessageAloudExtendedMethodResult& operator=(const most_msgfi_tclMsgReadMessageAloudExtendedMethodResult& coRef);
   most_msgfi_tclMsgReadMessageAloudExtendedMethodResult(const most_msgfi_tclMsgReadMessageAloudExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgPlaybackAction e8PlaybackAction;
   virtual ~most_msgfi_tclMsgReadMessageAloudExtendedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgReadMessageAloudExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestSliceConversationListMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRequestSliceConversationListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestSliceConversationListMethodStart& operator=(const most_msgfi_tclMsgRequestSliceConversationListMethodStart& coRef);
   most_msgfi_tclMsgRequestSliceConversationListMethodStart(const most_msgfi_tclMsgRequestSliceConversationListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   tU32 u32WindowStart;
   tU32 u32WindowSize;
   virtual ~most_msgfi_tclMsgRequestSliceConversationListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRequestSliceConversationListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestSliceConversationListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgRequestSliceConversationListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestSliceConversationListError& operator=(const most_msgfi_tclMsgRequestSliceConversationListError& coRef);
   most_msgfi_tclMsgRequestSliceConversationListError(const most_msgfi_tclMsgRequestSliceConversationListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgRequestSliceConversationListError();

   tBool operator==(const most_msgfi_tclMsgRequestSliceConversationListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRequestSliceConversationListMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRequestSliceConversationListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRequestSliceConversationListMethodResult& operator=(const most_msgfi_tclMsgRequestSliceConversationListMethodResult& coRef);
   most_msgfi_tclMsgRequestSliceConversationListMethodResult(const most_msgfi_tclMsgRequestSliceConversationListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgConversationListSliceResult oConversationListSliceResult;
   virtual ~most_msgfi_tclMsgRequestSliceConversationListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRequestSliceConversationListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetSliceConversationDetailsMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetSliceConversationDetailsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetSliceConversationDetailsMethodStart& operator=(const most_msgfi_tclMsgGetSliceConversationDetailsMethodStart& coRef);
   most_msgfi_tclMsgGetSliceConversationDetailsMethodStart(const most_msgfi_tclMsgGetSliceConversationDetailsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgConversationHandle oConversationHandle;
   tU32 u32WindowStart;
   tU32 u32WindowSize;
   virtual ~most_msgfi_tclMsgGetSliceConversationDetailsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetSliceConversationDetailsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetSliceConversationDetailsError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgGetSliceConversationDetailsError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetSliceConversationDetailsError& operator=(const most_msgfi_tclMsgGetSliceConversationDetailsError& coRef);
   most_msgfi_tclMsgGetSliceConversationDetailsError(const most_msgfi_tclMsgGetSliceConversationDetailsError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgGetSliceConversationDetailsError();

   tBool operator==(const most_msgfi_tclMsgGetSliceConversationDetailsError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgGetSliceConversationDetailsMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgGetSliceConversationDetailsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgGetSliceConversationDetailsMethodResult& operator=(const most_msgfi_tclMsgGetSliceConversationDetailsMethodResult& coRef);
   most_msgfi_tclMsgGetSliceConversationDetailsMethodResult(const most_msgfi_tclMsgGetSliceConversationDetailsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MsgConversationDetailList oConversationDetailList;
   virtual ~most_msgfi_tclMsgGetSliceConversationDetailsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgGetSliceConversationDetailsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSwitchMapOnOffMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSwitchMapOnOffMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSwitchMapOnOffMethodStart& operator=(const most_msgfi_tclMsgSwitchMapOnOffMethodStart& coRef);
   most_msgfi_tclMsgSwitchMapOnOffMethodStart(const most_msgfi_tclMsgSwitchMapOnOffMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tBool bOnOffState;
   virtual ~most_msgfi_tclMsgSwitchMapOnOffMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSwitchMapOnOffMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSwitchMapOnOffError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgSwitchMapOnOffError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSwitchMapOnOffError& operator=(const most_msgfi_tclMsgSwitchMapOnOffError& coRef);
   most_msgfi_tclMsgSwitchMapOnOffError(const most_msgfi_tclMsgSwitchMapOnOffError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgSwitchMapOnOffError();

   tBool operator==(const most_msgfi_tclMsgSwitchMapOnOffError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSwitchMapOnOffMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSwitchMapOnOffMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSwitchMapOnOffMethodResult& operator=(const most_msgfi_tclMsgSwitchMapOnOffMethodResult& coRef);
   most_msgfi_tclMsgSwitchMapOnOffMethodResult(const most_msgfi_tclMsgSwitchMapOnOffMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tBool bOnOffState;
   virtual ~most_msgfi_tclMsgSwitchMapOnOffMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSwitchMapOnOffMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAddCustomMessageMethodStart : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAddCustomMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAddCustomMessageMethodStart& operator=(const most_msgfi_tclMsgAddCustomMessageMethodStart& coRef);
   most_msgfi_tclMsgAddCustomMessageMethodStart(const most_msgfi_tclMsgAddCustomMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory;
   most_fi_tcl_String sPredefinedMessageText;
   virtual ~most_msgfi_tclMsgAddCustomMessageMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAddCustomMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAddCustomMessageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgAddCustomMessageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAddCustomMessageError& operator=(const most_msgfi_tclMsgAddCustomMessageError& coRef);
   most_msgfi_tclMsgAddCustomMessageError(const most_msgfi_tclMsgAddCustomMessageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgAddCustomMessageError();

   tBool operator==(const most_msgfi_tclMsgAddCustomMessageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAddCustomMessageMethodResult : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAddCustomMessageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAddCustomMessageMethodResult& operator=(const most_msgfi_tclMsgAddCustomMessageMethodResult& coRef);
   most_msgfi_tclMsgAddCustomMessageMethodResult(const most_msgfi_tclMsgAddCustomMessageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU16 u16PredefinedMessageHandle;
   virtual ~most_msgfi_tclMsgAddCustomMessageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAddCustomMessageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceInfoGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSourceInfoGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSourceInfoGet& operator=(const most_msgfi_tclMsgSourceInfoGet& coRef);
   most_msgfi_tclMsgSourceInfoGet(const most_msgfi_tclMsgSourceInfoGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   virtual ~most_msgfi_tclMsgSourceInfoGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSourceInfoGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceInfoError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgSourceInfoError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSourceInfoError& operator=(const most_msgfi_tclMsgSourceInfoError& coRef);
   most_msgfi_tclMsgSourceInfoError(const most_msgfi_tclMsgSourceInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgSourceInfoError();

   tBool operator==(const most_msgfi_tclMsgSourceInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceInfoStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSourceInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSourceInfoStatus& operator=(const most_msgfi_tclMsgSourceInfoStatus& coRef);
   most_msgfi_tclMsgSourceInfoStatus(const most_msgfi_tclMsgSourceInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SourceNr;
   tU16 u16BlockWidth;
   tU16 u16ConnectionLabel;
   most_fi_tcl_e8_SrcTransmissionClass e8TransmissionClass;
   most_fi_tcl_e8_SrcContentProtection e8ContentProtection;
   most_fi_tcl_e8_SrcContentType e8ContentType;
   most_fi_tcl_SrcContentDescription oContentDescription;
   most_fi_tcl_TrailingStream oTransmissionParameter;
   virtual ~most_msgfi_tclMsgSourceInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSourceInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceAvailableUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSourceAvailableUpReg();

   virtual ~most_msgfi_tclMsgSourceAvailableUpReg();

   inline tBool operator==(const most_msgfi_tclMsgSourceAvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceAvailableRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSourceAvailableRelUpReg();

   virtual ~most_msgfi_tclMsgSourceAvailableRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgSourceAvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceAvailableGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSourceAvailableGet();

   virtual ~most_msgfi_tclMsgSourceAvailableGet();

   inline tBool operator==(const most_msgfi_tclMsgSourceAvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceAvailableError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgSourceAvailableError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSourceAvailableError& operator=(const most_msgfi_tclMsgSourceAvailableError& coRef);
   most_msgfi_tclMsgSourceAvailableError(const most_msgfi_tclMsgSourceAvailableError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgSourceAvailableError();

   tBool operator==(const most_msgfi_tclMsgSourceAvailableError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSourceAvailableStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSourceAvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSourceAvailableStatus& operator=(const most_msgfi_tclMsgSourceAvailableStatus& coRef);
   most_msgfi_tclMsgSourceAvailableStatus(const most_msgfi_tclMsgSourceAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSourceAvailable;
   virtual ~most_msgfi_tclMsgSourceAvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSourceAvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessageListChangeUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessageListChangeUpReg();

   virtual ~most_msgfi_tclMsgMessageListChangeUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessageListChangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessageListChangeRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessageListChangeRelUpReg();

   virtual ~most_msgfi_tclMsgMessageListChangeRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessageListChangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessageListChangeStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessageListChangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessageListChangeStatus& operator=(const most_msgfi_tclMsgMessageListChangeStatus& coRef);
   most_msgfi_tclMsgMessageListChangeStatus(const most_msgfi_tclMsgMessageListChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ListHandle;
   most_fi_tcl_e8_MsgListChangeType e8ListChangeType;
   tU16 u16ListLength;
   tU32 u32NumItems;
   most_fi_tcl_MsgChangeItems oChangeItems;
   virtual ~most_msgfi_tclMsgMessageListChangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMessageListChangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgFolderListChangeUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgFolderListChangeUpReg();

   virtual ~most_msgfi_tclMsgFolderListChangeUpReg();

   inline tBool operator==(const most_msgfi_tclMsgFolderListChangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgFolderListChangeRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgFolderListChangeRelUpReg();

   virtual ~most_msgfi_tclMsgFolderListChangeRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgFolderListChangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgFolderListChangeStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgFolderListChangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgFolderListChangeStatus& operator=(const most_msgfi_tclMsgFolderListChangeStatus& coRef);
   most_msgfi_tclMsgFolderListChangeStatus(const most_msgfi_tclMsgFolderListChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32FolderHandle;
   tBool bFolderStructureChangedFlag;
   virtual ~most_msgfi_tclMsgFolderListChangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgFolderListChangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingDeviceConnectionUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingDeviceConnectionUpReg();

   virtual ~most_msgfi_tclMsgMessagingDeviceConnectionUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingDeviceConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg();

   virtual ~most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingDeviceConnectionStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingDeviceConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingDeviceConnectionStatus& operator=(const most_msgfi_tclMsgMessagingDeviceConnectionStatus& coRef);
   most_msgfi_tclMsgMessagingDeviceConnectionStatus(const most_msgfi_tclMsgMessagingDeviceConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tBool bEmailSupport;
   tBool bSMSSupport;
   tBool bMMSSupport;
   tBool bUpdateInboxSupport;
   tBool bMessagingMemoryStatus;
   most_fi_tcl_MsgActiveAccount oActiveAccount;
   virtual ~most_msgfi_tclMsgMessagingDeviceConnectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMessagingDeviceConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgUpdateInboxSettingsUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgUpdateInboxSettingsUpReg();

   virtual ~most_msgfi_tclMsgUpdateInboxSettingsUpReg();

   inline tBool operator==(const most_msgfi_tclMsgUpdateInboxSettingsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgUpdateInboxSettingsRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgUpdateInboxSettingsRelUpReg();

   virtual ~most_msgfi_tclMsgUpdateInboxSettingsRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgUpdateInboxSettingsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgUpdateInboxSettingsGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgUpdateInboxSettingsGet();

   virtual ~most_msgfi_tclMsgUpdateInboxSettingsGet();

   inline tBool operator==(const most_msgfi_tclMsgUpdateInboxSettingsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgUpdateInboxSettingsPureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgUpdateInboxSettingsPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgUpdateInboxSettingsPureSet& operator=(const most_msgfi_tclMsgUpdateInboxSettingsPureSet& coRef);
   most_msgfi_tclMsgUpdateInboxSettingsPureSet(const most_msgfi_tclMsgUpdateInboxSettingsPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAutoUpdateInboxOnOff;
   tU32 u32UpdateInboxPeriod;
   virtual ~most_msgfi_tclMsgUpdateInboxSettingsPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgUpdateInboxSettingsPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgUpdateInboxSettingsError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgUpdateInboxSettingsError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgUpdateInboxSettingsError& operator=(const most_msgfi_tclMsgUpdateInboxSettingsError& coRef);
   most_msgfi_tclMsgUpdateInboxSettingsError(const most_msgfi_tclMsgUpdateInboxSettingsError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgUpdateInboxSettingsError();

   tBool operator==(const most_msgfi_tclMsgUpdateInboxSettingsError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgUpdateInboxSettingsStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgUpdateInboxSettingsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgUpdateInboxSettingsStatus& operator=(const most_msgfi_tclMsgUpdateInboxSettingsStatus& coRef);
   most_msgfi_tclMsgUpdateInboxSettingsStatus(const most_msgfi_tclMsgUpdateInboxSettingsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAutoUpdateInboxOnOff;
   tU32 u32UpdateInboxPeriod;
   virtual ~most_msgfi_tclMsgUpdateInboxSettingsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgUpdateInboxSettingsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg();

   virtual ~most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg();

   inline tBool operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg();

   virtual ~most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioAttachmentPlaybackStateGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioAttachmentPlaybackStateGet();

   virtual ~most_msgfi_tclMsgAudioAttachmentPlaybackStateGet();

   inline tBool operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioAttachmentPlaybackStateError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgAudioAttachmentPlaybackStateError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAudioAttachmentPlaybackStateError& operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackStateError& coRef);
   most_msgfi_tclMsgAudioAttachmentPlaybackStateError(const most_msgfi_tclMsgAudioAttachmentPlaybackStateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgAudioAttachmentPlaybackStateError();

   tBool operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackStateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus& operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus& coRef);
   most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus(const most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16AttachmentHandle;
   most_fi_tcl_e8_MsgPlaybackState e8PlaybackState;
   virtual ~most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSignatureSettingGet();

   virtual ~most_msgfi_tclMsgSignatureSettingGet();

   inline tBool operator==(const most_msgfi_tclMsgSignatureSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingPureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSignatureSettingPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSignatureSettingPureSet& operator=(const most_msgfi_tclMsgSignatureSettingPureSet& coRef);
   most_msgfi_tclMsgSignatureSettingPureSet(const most_msgfi_tclMsgSignatureSettingPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sSignatureText;
   virtual ~most_msgfi_tclMsgSignatureSettingPureSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSignatureSettingPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgSignatureSettingError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSignatureSettingError& operator=(const most_msgfi_tclMsgSignatureSettingError& coRef);
   most_msgfi_tclMsgSignatureSettingError(const most_msgfi_tclMsgSignatureSettingError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgSignatureSettingError();

   tBool operator==(const most_msgfi_tclMsgSignatureSettingError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSignatureSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSignatureSettingStatus& operator=(const most_msgfi_tclMsgSignatureSettingStatus& coRef);
   most_msgfi_tclMsgSignatureSettingStatus(const most_msgfi_tclMsgSignatureSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sSignatureText;
   virtual ~most_msgfi_tclMsgSignatureSettingStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSignatureSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioMessageRecordingStateUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioMessageRecordingStateUpReg();

   virtual ~most_msgfi_tclMsgAudioMessageRecordingStateUpReg();

   inline tBool operator==(const most_msgfi_tclMsgAudioMessageRecordingStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg();

   virtual ~most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioMessageRecordingStateGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioMessageRecordingStateGet();

   virtual ~most_msgfi_tclMsgAudioMessageRecordingStateGet();

   inline tBool operator==(const most_msgfi_tclMsgAudioMessageRecordingStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioMessageRecordingStateError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgAudioMessageRecordingStateError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAudioMessageRecordingStateError& operator=(const most_msgfi_tclMsgAudioMessageRecordingStateError& coRef);
   most_msgfi_tclMsgAudioMessageRecordingStateError(const most_msgfi_tclMsgAudioMessageRecordingStateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgAudioMessageRecordingStateError();

   tBool operator==(const most_msgfi_tclMsgAudioMessageRecordingStateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAudioMessageRecordingStateStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAudioMessageRecordingStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAudioMessageRecordingStateStatus& operator=(const most_msgfi_tclMsgAudioMessageRecordingStateStatus& coRef);
   most_msgfi_tclMsgAudioMessageRecordingStateStatus(const most_msgfi_tclMsgAudioMessageRecordingStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgRecordMessageState e8RecordMessageState;
   virtual ~most_msgfi_tclMsgAudioMessageRecordingStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAudioMessageRecordingStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecordedAudioMessageInfoUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRecordedAudioMessageInfoUpReg();

   virtual ~most_msgfi_tclMsgRecordedAudioMessageInfoUpReg();

   inline tBool operator==(const most_msgfi_tclMsgRecordedAudioMessageInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg();

   virtual ~most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecordedAudioMessageInfoGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRecordedAudioMessageInfoGet();

   virtual ~most_msgfi_tclMsgRecordedAudioMessageInfoGet();

   inline tBool operator==(const most_msgfi_tclMsgRecordedAudioMessageInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecordedAudioMessageInfoError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgRecordedAudioMessageInfoError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRecordedAudioMessageInfoError& operator=(const most_msgfi_tclMsgRecordedAudioMessageInfoError& coRef);
   most_msgfi_tclMsgRecordedAudioMessageInfoError(const most_msgfi_tclMsgRecordedAudioMessageInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgRecordedAudioMessageInfoError();

   tBool operator==(const most_msgfi_tclMsgRecordedAudioMessageInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgRecordedAudioMessageInfoStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgRecordedAudioMessageInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgRecordedAudioMessageInfoStatus& operator=(const most_msgfi_tclMsgRecordedAudioMessageInfoStatus& coRef);
   most_msgfi_tclMsgRecordedAudioMessageInfoStatus(const most_msgfi_tclMsgRecordedAudioMessageInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16RecordedAudioMessageHandle;
   virtual ~most_msgfi_tclMsgRecordedAudioMessageInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgRecordedAudioMessageInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPredefinedMessageListUpReg();

   virtual ~most_msgfi_tclMsgPredefinedMessageListUpReg();

   inline tBool operator==(const most_msgfi_tclMsgPredefinedMessageListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPredefinedMessageListRelUpReg();

   virtual ~most_msgfi_tclMsgPredefinedMessageListRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgPredefinedMessageListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPredefinedMessageListGet();

   virtual ~most_msgfi_tclMsgPredefinedMessageListGet();

   inline tBool operator==(const most_msgfi_tclMsgPredefinedMessageListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgPredefinedMessageListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgPredefinedMessageListError& operator=(const most_msgfi_tclMsgPredefinedMessageListError& coRef);
   most_msgfi_tclMsgPredefinedMessageListError(const most_msgfi_tclMsgPredefinedMessageListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgPredefinedMessageListError();

   tBool operator==(const most_msgfi_tclMsgPredefinedMessageListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPredefinedMessageListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgPredefinedMessageListStatus& operator=(const most_msgfi_tclMsgPredefinedMessageListStatus& coRef);
   most_msgfi_tclMsgPredefinedMessageListStatus(const most_msgfi_tclMsgPredefinedMessageListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumPredefinedMessages;
   most_fi_tcl_MsgPredefinedMessageListResult oPredefinedMessageListResult;
   virtual ~most_msgfi_tclMsgPredefinedMessageListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgPredefinedMessageListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg();

   virtual ~most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg();

   virtual ~most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingAudioPlaybackStateGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingAudioPlaybackStateGet();

   virtual ~most_msgfi_tclMsgMessagingAudioPlaybackStateGet();

   inline tBool operator==(const most_msgfi_tclMsgMessagingAudioPlaybackStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingAudioPlaybackStateStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingAudioPlaybackStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingAudioPlaybackStateStatus& operator=(const most_msgfi_tclMsgMessagingAudioPlaybackStateStatus& coRef);
   most_msgfi_tclMsgMessagingAudioPlaybackStateStatus(const most_msgfi_tclMsgMessagingAudioPlaybackStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgPlaybackState e8PlaybackState;
   virtual ~most_msgfi_tclMsgMessagingAudioPlaybackStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMessagingAudioPlaybackStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextAlertEnableUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextAlertEnableUpReg();

   virtual ~most_msgfi_tclMsgTextAlertEnableUpReg();

   inline tBool operator==(const most_msgfi_tclMsgTextAlertEnableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextAlertEnableRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextAlertEnableRelUpReg();

   virtual ~most_msgfi_tclMsgTextAlertEnableRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgTextAlertEnableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextAlertEnableGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextAlertEnableGet();

   virtual ~most_msgfi_tclMsgTextAlertEnableGet();

   inline tBool operator==(const most_msgfi_tclMsgTextAlertEnableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextAlertEnablePureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextAlertEnablePureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgTextAlertEnablePureSet& operator=(const most_msgfi_tclMsgTextAlertEnablePureSet& coRef);
   most_msgfi_tclMsgTextAlertEnablePureSet(const most_msgfi_tclMsgTextAlertEnablePureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bTextAlertOnOff;
   virtual ~most_msgfi_tclMsgTextAlertEnablePureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgTextAlertEnablePureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextAlertEnableError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgTextAlertEnableError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgTextAlertEnableError& operator=(const most_msgfi_tclMsgTextAlertEnableError& coRef);
   most_msgfi_tclMsgTextAlertEnableError(const most_msgfi_tclMsgTextAlertEnableError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgTextAlertEnableError();

   tBool operator==(const most_msgfi_tclMsgTextAlertEnableError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextAlertEnableStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextAlertEnableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgTextAlertEnableStatus& operator=(const most_msgfi_tclMsgTextAlertEnableStatus& coRef);
   most_msgfi_tclMsgTextAlertEnableStatus(const most_msgfi_tclMsgTextAlertEnableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bTextAlertOnOff;
   virtual ~most_msgfi_tclMsgTextAlertEnableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgTextAlertEnableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgEmailAlertEnableUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgEmailAlertEnableUpReg();

   virtual ~most_msgfi_tclMsgEmailAlertEnableUpReg();

   inline tBool operator==(const most_msgfi_tclMsgEmailAlertEnableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgEmailAlertEnableRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgEmailAlertEnableRelUpReg();

   virtual ~most_msgfi_tclMsgEmailAlertEnableRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgEmailAlertEnableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgEmailAlertEnableGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgEmailAlertEnableGet();

   virtual ~most_msgfi_tclMsgEmailAlertEnableGet();

   inline tBool operator==(const most_msgfi_tclMsgEmailAlertEnableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgEmailAlertEnablePureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgEmailAlertEnablePureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgEmailAlertEnablePureSet& operator=(const most_msgfi_tclMsgEmailAlertEnablePureSet& coRef);
   most_msgfi_tclMsgEmailAlertEnablePureSet(const most_msgfi_tclMsgEmailAlertEnablePureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEmailAlertOnOff;
   virtual ~most_msgfi_tclMsgEmailAlertEnablePureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgEmailAlertEnablePureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgEmailAlertEnableError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgEmailAlertEnableError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgEmailAlertEnableError& operator=(const most_msgfi_tclMsgEmailAlertEnableError& coRef);
   most_msgfi_tclMsgEmailAlertEnableError(const most_msgfi_tclMsgEmailAlertEnableError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgEmailAlertEnableError();

   tBool operator==(const most_msgfi_tclMsgEmailAlertEnableError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgEmailAlertEnableStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgEmailAlertEnableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgEmailAlertEnableStatus& operator=(const most_msgfi_tclMsgEmailAlertEnableStatus& coRef);
   most_msgfi_tclMsgEmailAlertEnableStatus(const most_msgfi_tclMsgEmailAlertEnableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEmailAlertOnOff;
   virtual ~most_msgfi_tclMsgEmailAlertEnableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgEmailAlertEnableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentTextUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentTextUpReg();

   virtual ~most_msgfi_tclMsgSaveSentTextUpReg();

   inline tBool operator==(const most_msgfi_tclMsgSaveSentTextUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentTextRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentTextRelUpReg();

   virtual ~most_msgfi_tclMsgSaveSentTextRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgSaveSentTextRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentTextGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentTextGet();

   virtual ~most_msgfi_tclMsgSaveSentTextGet();

   inline tBool operator==(const most_msgfi_tclMsgSaveSentTextGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentTextPureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentTextPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSaveSentTextPureSet& operator=(const most_msgfi_tclMsgSaveSentTextPureSet& coRef);
   most_msgfi_tclMsgSaveSentTextPureSet(const most_msgfi_tclMsgSaveSentTextPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSaveSentTextOnOff;
   virtual ~most_msgfi_tclMsgSaveSentTextPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSaveSentTextPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentTextError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgSaveSentTextError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSaveSentTextError& operator=(const most_msgfi_tclMsgSaveSentTextError& coRef);
   most_msgfi_tclMsgSaveSentTextError(const most_msgfi_tclMsgSaveSentTextError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgSaveSentTextError();

   tBool operator==(const most_msgfi_tclMsgSaveSentTextError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentTextStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentTextStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSaveSentTextStatus& operator=(const most_msgfi_tclMsgSaveSentTextStatus& coRef);
   most_msgfi_tclMsgSaveSentTextStatus(const most_msgfi_tclMsgSaveSentTextStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSaveSentTextOnOff;
   virtual ~most_msgfi_tclMsgSaveSentTextStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSaveSentTextStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentEmailUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentEmailUpReg();

   virtual ~most_msgfi_tclMsgSaveSentEmailUpReg();

   inline tBool operator==(const most_msgfi_tclMsgSaveSentEmailUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentEmailRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentEmailRelUpReg();

   virtual ~most_msgfi_tclMsgSaveSentEmailRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgSaveSentEmailRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentEmailGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentEmailGet();

   virtual ~most_msgfi_tclMsgSaveSentEmailGet();

   inline tBool operator==(const most_msgfi_tclMsgSaveSentEmailGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentEmailPureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentEmailPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSaveSentEmailPureSet& operator=(const most_msgfi_tclMsgSaveSentEmailPureSet& coRef);
   most_msgfi_tclMsgSaveSentEmailPureSet(const most_msgfi_tclMsgSaveSentEmailPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSaveSentEmailOnOff;
   virtual ~most_msgfi_tclMsgSaveSentEmailPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSaveSentEmailPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentEmailError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgSaveSentEmailError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSaveSentEmailError& operator=(const most_msgfi_tclMsgSaveSentEmailError& coRef);
   most_msgfi_tclMsgSaveSentEmailError(const most_msgfi_tclMsgSaveSentEmailError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgSaveSentEmailError();

   tBool operator==(const most_msgfi_tclMsgSaveSentEmailError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSaveSentEmailStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSaveSentEmailStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSaveSentEmailStatus& operator=(const most_msgfi_tclMsgSaveSentEmailStatus& coRef);
   most_msgfi_tclMsgSaveSentEmailStatus(const most_msgfi_tclMsgSaveSentEmailStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSaveSentEmailOnOff;
   virtual ~most_msgfi_tclMsgSaveSentEmailStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSaveSentEmailStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMapDeviceCapabilitiesUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMapDeviceCapabilitiesUpReg();

   virtual ~most_msgfi_tclMsgMapDeviceCapabilitiesUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg();

   virtual ~most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMapDeviceCapabilitiesGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMapDeviceCapabilitiesGet();

   virtual ~most_msgfi_tclMsgMapDeviceCapabilitiesGet();

   inline tBool operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMapDeviceCapabilitiesStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMapDeviceCapabilitiesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMapDeviceCapabilitiesStatus& operator=(const most_msgfi_tclMsgMapDeviceCapabilitiesStatus& coRef);
   most_msgfi_tclMsgMapDeviceCapabilitiesStatus(const most_msgfi_tclMsgMapDeviceCapabilitiesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU16 u16SupportedMessageTypes;
   tU16 u16SupportedMapFeatures;
   most_fi_tcl_e8_MapConnectionStatus e8MapConnectionState;
   most_fi_tcl_MsgActiveAccount oActiveAccount;
   virtual ~most_msgfi_tclMsgMapDeviceCapabilitiesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingOnOffUpReg();

   virtual ~most_msgfi_tclMsgMessagingOnOffUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingOnOffUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingOnOffRelUpReg();

   virtual ~most_msgfi_tclMsgMessagingOnOffRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingOnOffRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingOnOffGet();

   virtual ~most_msgfi_tclMsgMessagingOnOffGet();

   inline tBool operator==(const most_msgfi_tclMsgMessagingOnOffGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingOnOffSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingOnOffSet& operator=(const most_msgfi_tclMsgMessagingOnOffSet& coRef);
   most_msgfi_tclMsgMessagingOnOffSet(const most_msgfi_tclMsgMessagingOnOffSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool MapOnOff;
   virtual ~most_msgfi_tclMsgMessagingOnOffSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMessagingOnOffSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgMessagingOnOffError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingOnOffError& operator=(const most_msgfi_tclMsgMessagingOnOffError& coRef);
   most_msgfi_tclMsgMessagingOnOffError(const most_msgfi_tclMsgMessagingOnOffError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgMessagingOnOffError();

   tBool operator==(const most_msgfi_tclMsgMessagingOnOffError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingOnOffStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingOnOffStatus& operator=(const most_msgfi_tclMsgMessagingOnOffStatus& coRef);
   most_msgfi_tclMsgMessagingOnOffStatus(const most_msgfi_tclMsgMessagingOnOffStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool MapOnOff;
   virtual ~most_msgfi_tclMsgMessagingOnOffStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMessagingOnOffStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessageNotificationUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessageNotificationUpReg();

   virtual ~most_msgfi_tclMsgMessageNotificationUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessageNotificationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessageNotificationRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessageNotificationRelUpReg();

   virtual ~most_msgfi_tclMsgMessageNotificationRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessageNotificationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessageNotificationGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessageNotificationGet();

   virtual ~most_msgfi_tclMsgMessageNotificationGet();

   inline tBool operator==(const most_msgfi_tclMsgMessageNotificationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessageNotificationStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessageNotificationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessageNotificationStatus& operator=(const most_msgfi_tclMsgMessageNotificationStatus& coRef);
   most_msgfi_tclMsgMessageNotificationStatus(const most_msgfi_tclMsgMessageNotificationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgNotificationType e8NotificationType;
   most_fi_tcl_e8_MsgMessageType e8MessageType;
   most_fi_tcl_MsgMessageHandle oMessageHandle;
   virtual ~most_msgfi_tclMsgMessageNotificationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMessageNotificationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListExtendedUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPredefinedMessageListExtendedUpReg();

   virtual ~most_msgfi_tclMsgPredefinedMessageListExtendedUpReg();

   inline tBool operator==(const most_msgfi_tclMsgPredefinedMessageListExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg();

   virtual ~most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListExtendedGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPredefinedMessageListExtendedGet();

   virtual ~most_msgfi_tclMsgPredefinedMessageListExtendedGet();

   inline tBool operator==(const most_msgfi_tclMsgPredefinedMessageListExtendedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListExtendedError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgPredefinedMessageListExtendedError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgPredefinedMessageListExtendedError& operator=(const most_msgfi_tclMsgPredefinedMessageListExtendedError& coRef);
   most_msgfi_tclMsgPredefinedMessageListExtendedError(const most_msgfi_tclMsgPredefinedMessageListExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgPredefinedMessageListExtendedError();

   tBool operator==(const most_msgfi_tclMsgPredefinedMessageListExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgPredefinedMessageListExtendedStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgPredefinedMessageListExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgPredefinedMessageListExtendedStatus& operator=(const most_msgfi_tclMsgPredefinedMessageListExtendedStatus& coRef);
   most_msgfi_tclMsgPredefinedMessageListExtendedStatus(const most_msgfi_tclMsgPredefinedMessageListExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumPredefinedMessages;
   most_fi_tcl_MsgPredefinedMessageListExtendedResult oPredefinedMessageListExtendedResult;
   virtual ~most_msgfi_tclMsgPredefinedMessageListExtendedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgPredefinedMessageListExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingLanguageUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingLanguageUpReg();

   virtual ~most_msgfi_tclMsgMessagingLanguageUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingLanguageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingLanguageRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingLanguageRelUpReg();

   virtual ~most_msgfi_tclMsgMessagingLanguageRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingLanguageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingLanguageGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingLanguageGet();

   virtual ~most_msgfi_tclMsgMessagingLanguageGet();

   inline tBool operator==(const most_msgfi_tclMsgMessagingLanguageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingLanguageSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingLanguageSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingLanguageSet& operator=(const most_msgfi_tclMsgMessagingLanguageSet& coRef);
   most_msgfi_tclMsgMessagingLanguageSet(const most_msgfi_tclMsgMessagingLanguageSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgLanguageSet e8LanguageSet;
   virtual ~most_msgfi_tclMsgMessagingLanguageSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMessagingLanguageSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingLanguageError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgMessagingLanguageError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingLanguageError& operator=(const most_msgfi_tclMsgMessagingLanguageError& coRef);
   most_msgfi_tclMsgMessagingLanguageError(const most_msgfi_tclMsgMessagingLanguageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgMessagingLanguageError();

   tBool operator==(const most_msgfi_tclMsgMessagingLanguageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingLanguageStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingLanguageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingLanguageStatus& operator=(const most_msgfi_tclMsgMessagingLanguageStatus& coRef);
   most_msgfi_tclMsgMessagingLanguageStatus(const most_msgfi_tclMsgMessagingLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_MsgLanguageSet e8LanguageSet;
   virtual ~most_msgfi_tclMsgMessagingLanguageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMessagingLanguageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingExtendedUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSignatureSettingExtendedUpReg();

   virtual ~most_msgfi_tclMsgSignatureSettingExtendedUpReg();

   inline tBool operator==(const most_msgfi_tclMsgSignatureSettingExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingExtendedRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSignatureSettingExtendedRelUpReg();

   virtual ~most_msgfi_tclMsgSignatureSettingExtendedRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgSignatureSettingExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingExtendedGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSignatureSettingExtendedGet();

   virtual ~most_msgfi_tclMsgSignatureSettingExtendedGet();

   inline tBool operator==(const most_msgfi_tclMsgSignatureSettingExtendedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingExtendedPureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSignatureSettingExtendedPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSignatureSettingExtendedPureSet& operator=(const most_msgfi_tclMsgSignatureSettingExtendedPureSet& coRef);
   most_msgfi_tclMsgSignatureSettingExtendedPureSet(const most_msgfi_tclMsgSignatureSettingExtendedPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_SignatureTextStream oSignatureTextStream;
   virtual ~most_msgfi_tclMsgSignatureSettingExtendedPureSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSignatureSettingExtendedPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingExtendedError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgSignatureSettingExtendedError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSignatureSettingExtendedError& operator=(const most_msgfi_tclMsgSignatureSettingExtendedError& coRef);
   most_msgfi_tclMsgSignatureSettingExtendedError(const most_msgfi_tclMsgSignatureSettingExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgSignatureSettingExtendedError();

   tBool operator==(const most_msgfi_tclMsgSignatureSettingExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgSignatureSettingExtendedStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgSignatureSettingExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgSignatureSettingExtendedStatus& operator=(const most_msgfi_tclMsgSignatureSettingExtendedStatus& coRef);
   most_msgfi_tclMsgSignatureSettingExtendedStatus(const most_msgfi_tclMsgSignatureSettingExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_SignatureTextStream oSignatureTextStream;
   virtual ~most_msgfi_tclMsgSignatureSettingExtendedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgSignatureSettingExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffListUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingOnOffListUpReg();

   virtual ~most_msgfi_tclMsgMessagingOnOffListUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingOnOffListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffListRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingOnOffListRelUpReg();

   virtual ~most_msgfi_tclMsgMessagingOnOffListRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMessagingOnOffListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffListGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingOnOffListGet();

   virtual ~most_msgfi_tclMsgMessagingOnOffListGet();

   inline tBool operator==(const most_msgfi_tclMsgMessagingOnOffListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgMessagingOnOffListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingOnOffListError& operator=(const most_msgfi_tclMsgMessagingOnOffListError& coRef);
   most_msgfi_tclMsgMessagingOnOffListError(const most_msgfi_tclMsgMessagingOnOffListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgMessagingOnOffListError();

   tBool operator==(const most_msgfi_tclMsgMessagingOnOffListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMessagingOnOffListStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMessagingOnOffListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMessagingOnOffListStatus& operator=(const most_msgfi_tclMsgMessagingOnOffListStatus& coRef);
   most_msgfi_tclMsgMessagingOnOffListStatus(const most_msgfi_tclMsgMessagingOnOffListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_OnOffList oMessagingOnOffList;
   virtual ~most_msgfi_tclMsgMessagingOnOffListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMessagingOnOffListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextRingtoneOnOffListUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextRingtoneOnOffListUpReg();

   virtual ~most_msgfi_tclMsgTextRingtoneOnOffListUpReg();

   inline tBool operator==(const most_msgfi_tclMsgTextRingtoneOnOffListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg();

   virtual ~most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextRingtoneOnOffListGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextRingtoneOnOffListGet();

   virtual ~most_msgfi_tclMsgTextRingtoneOnOffListGet();

   inline tBool operator==(const most_msgfi_tclMsgTextRingtoneOnOffListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextRingtoneOnOffListPureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextRingtoneOnOffListPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgTextRingtoneOnOffListPureSet& operator=(const most_msgfi_tclMsgTextRingtoneOnOffListPureSet& coRef);
   most_msgfi_tclMsgTextRingtoneOnOffListPureSet(const most_msgfi_tclMsgTextRingtoneOnOffListPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_OnOffList oTextRingtoneOnOffList;
   virtual ~most_msgfi_tclMsgTextRingtoneOnOffListPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgTextRingtoneOnOffListPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextRingtoneOnOffListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgTextRingtoneOnOffListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgTextRingtoneOnOffListError& operator=(const most_msgfi_tclMsgTextRingtoneOnOffListError& coRef);
   most_msgfi_tclMsgTextRingtoneOnOffListError(const most_msgfi_tclMsgTextRingtoneOnOffListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgTextRingtoneOnOffListError();

   tBool operator==(const most_msgfi_tclMsgTextRingtoneOnOffListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgTextRingtoneOnOffListStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgTextRingtoneOnOffListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgTextRingtoneOnOffListStatus& operator=(const most_msgfi_tclMsgTextRingtoneOnOffListStatus& coRef);
   most_msgfi_tclMsgTextRingtoneOnOffListStatus(const most_msgfi_tclMsgTextRingtoneOnOffListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_OnOffList oTextRingtoneOnOffList;
   virtual ~most_msgfi_tclMsgTextRingtoneOnOffListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgTextRingtoneOnOffListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyOnOffListUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyOnOffListUpReg();

   virtual ~most_msgfi_tclMsgAutoReplyOnOffListUpReg();

   inline tBool operator==(const most_msgfi_tclMsgAutoReplyOnOffListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyOnOffListRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyOnOffListRelUpReg();

   virtual ~most_msgfi_tclMsgAutoReplyOnOffListRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgAutoReplyOnOffListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyOnOffListGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyOnOffListGet();

   virtual ~most_msgfi_tclMsgAutoReplyOnOffListGet();

   inline tBool operator==(const most_msgfi_tclMsgAutoReplyOnOffListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyOnOffListPureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyOnOffListPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAutoReplyOnOffListPureSet& operator=(const most_msgfi_tclMsgAutoReplyOnOffListPureSet& coRef);
   most_msgfi_tclMsgAutoReplyOnOffListPureSet(const most_msgfi_tclMsgAutoReplyOnOffListPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_OnOffList oAutoReplyOnOffList;
   virtual ~most_msgfi_tclMsgAutoReplyOnOffListPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAutoReplyOnOffListPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyOnOffListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgAutoReplyOnOffListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAutoReplyOnOffListError& operator=(const most_msgfi_tclMsgAutoReplyOnOffListError& coRef);
   most_msgfi_tclMsgAutoReplyOnOffListError(const most_msgfi_tclMsgAutoReplyOnOffListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgAutoReplyOnOffListError();

   tBool operator==(const most_msgfi_tclMsgAutoReplyOnOffListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyOnOffListStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyOnOffListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAutoReplyOnOffListStatus& operator=(const most_msgfi_tclMsgAutoReplyOnOffListStatus& coRef);
   most_msgfi_tclMsgAutoReplyOnOffListStatus(const most_msgfi_tclMsgAutoReplyOnOffListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_OnOffList oAutoReplyOnOffList;
   virtual ~most_msgfi_tclMsgAutoReplyOnOffListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAutoReplyOnOffListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyTextListUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyTextListUpReg();

   virtual ~most_msgfi_tclMsgAutoReplyTextListUpReg();

   inline tBool operator==(const most_msgfi_tclMsgAutoReplyTextListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyTextListRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyTextListRelUpReg();

   virtual ~most_msgfi_tclMsgAutoReplyTextListRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgAutoReplyTextListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyTextListGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyTextListGet();

   virtual ~most_msgfi_tclMsgAutoReplyTextListGet();

   inline tBool operator==(const most_msgfi_tclMsgAutoReplyTextListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyTextListPureSet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyTextListPureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAutoReplyTextListPureSet& operator=(const most_msgfi_tclMsgAutoReplyTextListPureSet& coRef);
   most_msgfi_tclMsgAutoReplyTextListPureSet(const most_msgfi_tclMsgAutoReplyTextListPureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_AutoReplyTextList oAutoReplyTextList;
   virtual ~most_msgfi_tclMsgAutoReplyTextListPureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAutoReplyTextListPureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyTextListError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgAutoReplyTextListError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAutoReplyTextListError& operator=(const most_msgfi_tclMsgAutoReplyTextListError& coRef);
   most_msgfi_tclMsgAutoReplyTextListError(const most_msgfi_tclMsgAutoReplyTextListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgAutoReplyTextListError();

   tBool operator==(const most_msgfi_tclMsgAutoReplyTextListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgAutoReplyTextListStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgAutoReplyTextListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgAutoReplyTextListStatus& operator=(const most_msgfi_tclMsgAutoReplyTextListStatus& coRef);
   most_msgfi_tclMsgAutoReplyTextListStatus(const most_msgfi_tclMsgAutoReplyTextListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_AutoReplyTextList oAutoReplyTextList;
   virtual ~most_msgfi_tclMsgAutoReplyTextListStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgAutoReplyTextListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg();

   virtual ~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg();

   virtual ~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg();

   inline tBool operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet();

   virtual ~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet();

   inline tBool operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError : public most_msgfi_tclMsgDefaultError
{
public:

   most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError() : most_msgfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError& operator=(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError& coRef);
   most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError();

   tBool operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus : public most_msgfi_tclMsgBaseMessage
{
public:

   most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus& operator=(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus& coRef);
   most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_MapDeviceCapabilitiesList oMapDeviceCapabilitiesList;
   virtual ~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
