/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_MSGFI_SERVICEINFO
#include "conn_most_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MOST_Msg_FI message types

fi_tclMessageBase* most_msgfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case most_msgfi_tclToken::EN_MSG_AllocateMethodStart:
         return OSAL_NEW most_msgfi_tclMsgAllocateMethodStart;

      case most_msgfi_tclToken::EN_MSG_AllocateMethodResult:
         return OSAL_NEW most_msgfi_tclMsgAllocateMethodResult;

      case most_msgfi_tclToken::EN_MSG_DeAllocateMethodStart:
         return OSAL_NEW most_msgfi_tclMsgDeAllocateMethodStart;

      case most_msgfi_tclToken::EN_MSG_DeAllocateMethodResult:
         return OSAL_NEW most_msgfi_tclMsgDeAllocateMethodResult;

      case most_msgfi_tclToken::EN_MSG_SourceActivityMethodStart:
         return OSAL_NEW most_msgfi_tclMsgSourceActivityMethodStart;

      case most_msgfi_tclToken::EN_MSG_SourceActivityMethodResult:
         return OSAL_NEW most_msgfi_tclMsgSourceActivityMethodResult;

      case most_msgfi_tclToken::EN_MSG_CreateMessageListMethodStart:
         return OSAL_NEW most_msgfi_tclMsgCreateMessageListMethodStart;

      case most_msgfi_tclToken::EN_MSG_CreateMessageListMethodResult:
         return OSAL_NEW most_msgfi_tclMsgCreateMessageListMethodResult;

      case most_msgfi_tclToken::EN_MSG_RequestSliceMessageListMethodStart:
         return OSAL_NEW most_msgfi_tclMsgRequestSliceMessageListMethodStart;

      case most_msgfi_tclToken::EN_MSG_RequestSliceMessageListMethodResult:
         return OSAL_NEW most_msgfi_tclMsgRequestSliceMessageListMethodResult;

      case most_msgfi_tclToken::EN_MSG_ReleaseMessageListMethodStart:
         return OSAL_NEW most_msgfi_tclMsgReleaseMessageListMethodStart;

      case most_msgfi_tclToken::EN_MSG_ReleaseMessageListMethodResult:
         return OSAL_NEW most_msgfi_tclMsgReleaseMessageListMethodResult;

      case most_msgfi_tclToken::EN_MSG_RequestFolderListMethodStart:
         return OSAL_NEW most_msgfi_tclMsgRequestFolderListMethodStart;

      case most_msgfi_tclToken::EN_MSG_RequestFolderListMethodResult:
         return OSAL_NEW most_msgfi_tclMsgRequestFolderListMethodResult;

      case most_msgfi_tclToken::EN_MSG_DeleteMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgDeleteMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_DeleteMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgDeleteMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_RecoverMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgRecoverMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_RecoverMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgRecoverMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_RequestAccountListMethodStart:
         return OSAL_NEW most_msgfi_tclMsgRequestAccountListMethodStart;

      case most_msgfi_tclToken::EN_MSG_RequestAccountListMethodResult:
         return OSAL_NEW most_msgfi_tclMsgRequestAccountListMethodResult;

      case most_msgfi_tclToken::EN_MSG_ChangeAccountMethodStart:
         return OSAL_NEW most_msgfi_tclMsgChangeAccountMethodStart;

      case most_msgfi_tclToken::EN_MSG_ChangeAccountMethodResult:
         return OSAL_NEW most_msgfi_tclMsgChangeAccountMethodResult;

      case most_msgfi_tclToken::EN_MSG_UpdateInboxMethodStart:
         return OSAL_NEW most_msgfi_tclMsgUpdateInboxMethodStart;

      case most_msgfi_tclToken::EN_MSG_UpdateInboxMethodResult:
         return OSAL_NEW most_msgfi_tclMsgUpdateInboxMethodResult;

      case most_msgfi_tclToken::EN_MSG_GetMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgGetMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_GetMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgGetMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_GetAttachmentListMethodStart:
         return OSAL_NEW most_msgfi_tclMsgGetAttachmentListMethodStart;

      case most_msgfi_tclToken::EN_MSG_GetAttachmentListMethodResult:
         return OSAL_NEW most_msgfi_tclMsgGetAttachmentListMethodResult;

      case most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackMethodStart:
         return OSAL_NEW most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart;

      case most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackMethodResult:
         return OSAL_NEW most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult;

      case most_msgfi_tclToken::EN_MSG_GetImageAttachmentMethodStart:
         return OSAL_NEW most_msgfi_tclMsgGetImageAttachmentMethodStart;

      case most_msgfi_tclToken::EN_MSG_GetImageAttachmentMethodResult:
         return OSAL_NEW most_msgfi_tclMsgGetImageAttachmentMethodResult;

      case most_msgfi_tclToken::EN_MSG_GetBodyPartListMethodStart:
         return OSAL_NEW most_msgfi_tclMsgGetBodyPartListMethodStart;

      case most_msgfi_tclToken::EN_MSG_GetBodyPartListMethodResult:
         return OSAL_NEW most_msgfi_tclMsgGetBodyPartListMethodResult;

      case most_msgfi_tclToken::EN_MSG_ReadMessageAloudMethodStart:
         return OSAL_NEW most_msgfi_tclMsgReadMessageAloudMethodStart;

      case most_msgfi_tclToken::EN_MSG_ReadMessageAloudMethodResult:
         return OSAL_NEW most_msgfi_tclMsgReadMessageAloudMethodResult;

      case most_msgfi_tclToken::EN_MSG_RecordAudioMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgRecordAudioMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_RecordAudioMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgRecordAudioMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_PlaybackAudioMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgPlaybackAudioMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_PlaybackAudioMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgPlaybackAudioMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_AddPredefinedMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgAddPredefinedMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_AddPredefinedMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgAddPredefinedMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_DeletePredefinedMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgDeletePredefinedMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_DeletePredefinedMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgDeletePredefinedMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_GetConversationMessagesMethodStart:
         return OSAL_NEW most_msgfi_tclMsgGetConversationMessagesMethodStart;

      case most_msgfi_tclToken::EN_MSG_GetConversationMessagesMethodResult:
         return OSAL_NEW most_msgfi_tclMsgGetConversationMessagesMethodResult;

      case most_msgfi_tclToken::EN_MSG_SendMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgSendMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_SendMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgSendMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_ProvideMessageHeaderMethodStart:
         return OSAL_NEW most_msgfi_tclMsgProvideMessageHeaderMethodStart;

      case most_msgfi_tclToken::EN_MSG_ProvideMessageHeaderMethodResult:
         return OSAL_NEW most_msgfi_tclMsgProvideMessageHeaderMethodResult;

      case most_msgfi_tclToken::EN_MSG_ProvideMessageBodyMethodStart:
         return OSAL_NEW most_msgfi_tclMsgProvideMessageBodyMethodStart;

      case most_msgfi_tclToken::EN_MSG_ProvideMessageBodyMethodResult:
         return OSAL_NEW most_msgfi_tclMsgProvideMessageBodyMethodResult;

      case most_msgfi_tclToken::EN_MSG_GetMsgBodyActionElementMethodStart:
         return OSAL_NEW most_msgfi_tclMsgGetMsgBodyActionElementMethodStart;

      case most_msgfi_tclToken::EN_MSG_GetMsgBodyActionElementMethodResult:
         return OSAL_NEW most_msgfi_tclMsgGetMsgBodyActionElementMethodResult;

      case most_msgfi_tclToken::EN_MSG_GetImageAttachmentInfoMethodStart:
         return OSAL_NEW most_msgfi_tclMsgGetImageAttachmentInfoMethodStart;

      case most_msgfi_tclToken::EN_MSG_GetImageAttachmentInfoMethodResult:
         return OSAL_NEW most_msgfi_tclMsgGetImageAttachmentInfoMethodResult;

      case most_msgfi_tclToken::EN_MSG_CreateMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgCreateMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_CreateMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgCreateMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_ClearUserMessagingInfoMethodStart:
         return OSAL_NEW most_msgfi_tclMsgClearUserMessagingInfoMethodStart;

      case most_msgfi_tclToken::EN_MSG_ClearUserMessagingInfoMethodResult:
         return OSAL_NEW most_msgfi_tclMsgClearUserMessagingInfoMethodResult;

      case most_msgfi_tclToken::EN_MSG_ConnectMapProfileMethodStart:
         return OSAL_NEW most_msgfi_tclMsgConnectMapProfileMethodStart;

      case most_msgfi_tclToken::EN_MSG_ConnectMapProfileMethodResult:
         return OSAL_NEW most_msgfi_tclMsgConnectMapProfileMethodResult;

      case most_msgfi_tclToken::EN_MSG_EditPredefinedMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgEditPredefinedMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_EditPredefinedMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgEditPredefinedMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_AddPredefinedMessageExtendedMethodStart:
         return OSAL_NEW most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart;

      case most_msgfi_tclToken::EN_MSG_AddPredefinedMessageExtendedMethodResult:
         return OSAL_NEW most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult;

      case most_msgfi_tclToken::EN_MSG_ReadMessageAloudExtendedMethodStart:
         return OSAL_NEW most_msgfi_tclMsgReadMessageAloudExtendedMethodStart;

      case most_msgfi_tclToken::EN_MSG_ReadMessageAloudExtendedMethodResult:
         return OSAL_NEW most_msgfi_tclMsgReadMessageAloudExtendedMethodResult;

      case most_msgfi_tclToken::EN_MSG_RequestSliceConversationListMethodStart:
         return OSAL_NEW most_msgfi_tclMsgRequestSliceConversationListMethodStart;

      case most_msgfi_tclToken::EN_MSG_RequestSliceConversationListMethodResult:
         return OSAL_NEW most_msgfi_tclMsgRequestSliceConversationListMethodResult;

      case most_msgfi_tclToken::EN_MSG_GetSliceConversationDetailsMethodStart:
         return OSAL_NEW most_msgfi_tclMsgGetSliceConversationDetailsMethodStart;

      case most_msgfi_tclToken::EN_MSG_GetSliceConversationDetailsMethodResult:
         return OSAL_NEW most_msgfi_tclMsgGetSliceConversationDetailsMethodResult;

      case most_msgfi_tclToken::EN_MSG_SwitchMapOnOffMethodStart:
         return OSAL_NEW most_msgfi_tclMsgSwitchMapOnOffMethodStart;

      case most_msgfi_tclToken::EN_MSG_SwitchMapOnOffMethodResult:
         return OSAL_NEW most_msgfi_tclMsgSwitchMapOnOffMethodResult;

      case most_msgfi_tclToken::EN_MSG_AddCustomMessageMethodStart:
         return OSAL_NEW most_msgfi_tclMsgAddCustomMessageMethodStart;

      case most_msgfi_tclToken::EN_MSG_AddCustomMessageMethodResult:
         return OSAL_NEW most_msgfi_tclMsgAddCustomMessageMethodResult;

      case most_msgfi_tclToken::EN_MSG_SourceInfoGet:
         return OSAL_NEW most_msgfi_tclMsgSourceInfoGet;

      case most_msgfi_tclToken::EN_MSG_SourceInfoStatus:
         return OSAL_NEW most_msgfi_tclMsgSourceInfoStatus;

      case most_msgfi_tclToken::EN_MSG_SourceAvailableUpReg:
         return OSAL_NEW most_msgfi_tclMsgSourceAvailableUpReg;

      case most_msgfi_tclToken::EN_MSG_SourceAvailableRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgSourceAvailableRelUpReg;

      case most_msgfi_tclToken::EN_MSG_SourceAvailableGet:
         return OSAL_NEW most_msgfi_tclMsgSourceAvailableGet;

      case most_msgfi_tclToken::EN_MSG_SourceAvailableStatus:
         return OSAL_NEW most_msgfi_tclMsgSourceAvailableStatus;

      case most_msgfi_tclToken::EN_MSG_MessageListChangeUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessageListChangeUpReg;

      case most_msgfi_tclToken::EN_MSG_MessageListChangeRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessageListChangeRelUpReg;

      case most_msgfi_tclToken::EN_MSG_MessageListChangeStatus:
         return OSAL_NEW most_msgfi_tclMsgMessageListChangeStatus;

      case most_msgfi_tclToken::EN_MSG_FolderListChangeUpReg:
         return OSAL_NEW most_msgfi_tclMsgFolderListChangeUpReg;

      case most_msgfi_tclToken::EN_MSG_FolderListChangeRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgFolderListChangeRelUpReg;

      case most_msgfi_tclToken::EN_MSG_FolderListChangeStatus:
         return OSAL_NEW most_msgfi_tclMsgFolderListChangeStatus;

      case most_msgfi_tclToken::EN_MSG_MessagingDeviceConnectionUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingDeviceConnectionUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingDeviceConnectionRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingDeviceConnectionStatus:
         return OSAL_NEW most_msgfi_tclMsgMessagingDeviceConnectionStatus;

      case most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsUpReg:
         return OSAL_NEW most_msgfi_tclMsgUpdateInboxSettingsUpReg;

      case most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgUpdateInboxSettingsRelUpReg;

      case most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsGet:
         return OSAL_NEW most_msgfi_tclMsgUpdateInboxSettingsGet;

      case most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsPureSet:
         return OSAL_NEW most_msgfi_tclMsgUpdateInboxSettingsPureSet;

      case most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsStatus:
         return OSAL_NEW most_msgfi_tclMsgUpdateInboxSettingsStatus;

      case most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackStateUpReg:
         return OSAL_NEW most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg;

      case most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackStateRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg;

      case most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackStateGet:
         return OSAL_NEW most_msgfi_tclMsgAudioAttachmentPlaybackStateGet;

      case most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackStateStatus:
         return OSAL_NEW most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus;

      case most_msgfi_tclToken::EN_MSG_SignatureSettingGet:
         return OSAL_NEW most_msgfi_tclMsgSignatureSettingGet;

      case most_msgfi_tclToken::EN_MSG_SignatureSettingPureSet:
         return OSAL_NEW most_msgfi_tclMsgSignatureSettingPureSet;

      case most_msgfi_tclToken::EN_MSG_SignatureSettingStatus:
         return OSAL_NEW most_msgfi_tclMsgSignatureSettingStatus;

      case most_msgfi_tclToken::EN_MSG_AudioMessageRecordingStateUpReg:
         return OSAL_NEW most_msgfi_tclMsgAudioMessageRecordingStateUpReg;

      case most_msgfi_tclToken::EN_MSG_AudioMessageRecordingStateRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg;

      case most_msgfi_tclToken::EN_MSG_AudioMessageRecordingStateGet:
         return OSAL_NEW most_msgfi_tclMsgAudioMessageRecordingStateGet;

      case most_msgfi_tclToken::EN_MSG_AudioMessageRecordingStateStatus:
         return OSAL_NEW most_msgfi_tclMsgAudioMessageRecordingStateStatus;

      case most_msgfi_tclToken::EN_MSG_RecordedAudioMessageInfoUpReg:
         return OSAL_NEW most_msgfi_tclMsgRecordedAudioMessageInfoUpReg;

      case most_msgfi_tclToken::EN_MSG_RecordedAudioMessageInfoRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg;

      case most_msgfi_tclToken::EN_MSG_RecordedAudioMessageInfoGet:
         return OSAL_NEW most_msgfi_tclMsgRecordedAudioMessageInfoGet;

      case most_msgfi_tclToken::EN_MSG_RecordedAudioMessageInfoStatus:
         return OSAL_NEW most_msgfi_tclMsgRecordedAudioMessageInfoStatus;

      case most_msgfi_tclToken::EN_MSG_PredefinedMessageListUpReg:
         return OSAL_NEW most_msgfi_tclMsgPredefinedMessageListUpReg;

      case most_msgfi_tclToken::EN_MSG_PredefinedMessageListRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgPredefinedMessageListRelUpReg;

      case most_msgfi_tclToken::EN_MSG_PredefinedMessageListGet:
         return OSAL_NEW most_msgfi_tclMsgPredefinedMessageListGet;

      case most_msgfi_tclToken::EN_MSG_PredefinedMessageListStatus:
         return OSAL_NEW most_msgfi_tclMsgPredefinedMessageListStatus;

      case most_msgfi_tclToken::EN_MSG_MessagingAudioPlaybackStateUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingAudioPlaybackStateRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingAudioPlaybackStateGet:
         return OSAL_NEW most_msgfi_tclMsgMessagingAudioPlaybackStateGet;

      case most_msgfi_tclToken::EN_MSG_MessagingAudioPlaybackStateStatus:
         return OSAL_NEW most_msgfi_tclMsgMessagingAudioPlaybackStateStatus;

      case most_msgfi_tclToken::EN_MSG_TextAlertEnableUpReg:
         return OSAL_NEW most_msgfi_tclMsgTextAlertEnableUpReg;

      case most_msgfi_tclToken::EN_MSG_TextAlertEnableRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgTextAlertEnableRelUpReg;

      case most_msgfi_tclToken::EN_MSG_TextAlertEnableGet:
         return OSAL_NEW most_msgfi_tclMsgTextAlertEnableGet;

      case most_msgfi_tclToken::EN_MSG_TextAlertEnablePureSet:
         return OSAL_NEW most_msgfi_tclMsgTextAlertEnablePureSet;

      case most_msgfi_tclToken::EN_MSG_TextAlertEnableStatus:
         return OSAL_NEW most_msgfi_tclMsgTextAlertEnableStatus;

      case most_msgfi_tclToken::EN_MSG_EmailAlertEnableUpReg:
         return OSAL_NEW most_msgfi_tclMsgEmailAlertEnableUpReg;

      case most_msgfi_tclToken::EN_MSG_EmailAlertEnableRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgEmailAlertEnableRelUpReg;

      case most_msgfi_tclToken::EN_MSG_EmailAlertEnableGet:
         return OSAL_NEW most_msgfi_tclMsgEmailAlertEnableGet;

      case most_msgfi_tclToken::EN_MSG_EmailAlertEnablePureSet:
         return OSAL_NEW most_msgfi_tclMsgEmailAlertEnablePureSet;

      case most_msgfi_tclToken::EN_MSG_EmailAlertEnableStatus:
         return OSAL_NEW most_msgfi_tclMsgEmailAlertEnableStatus;

      case most_msgfi_tclToken::EN_MSG_SaveSentTextUpReg:
         return OSAL_NEW most_msgfi_tclMsgSaveSentTextUpReg;

      case most_msgfi_tclToken::EN_MSG_SaveSentTextRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgSaveSentTextRelUpReg;

      case most_msgfi_tclToken::EN_MSG_SaveSentTextGet:
         return OSAL_NEW most_msgfi_tclMsgSaveSentTextGet;

      case most_msgfi_tclToken::EN_MSG_SaveSentTextPureSet:
         return OSAL_NEW most_msgfi_tclMsgSaveSentTextPureSet;

      case most_msgfi_tclToken::EN_MSG_SaveSentTextStatus:
         return OSAL_NEW most_msgfi_tclMsgSaveSentTextStatus;

      case most_msgfi_tclToken::EN_MSG_SaveSentEmailUpReg:
         return OSAL_NEW most_msgfi_tclMsgSaveSentEmailUpReg;

      case most_msgfi_tclToken::EN_MSG_SaveSentEmailRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgSaveSentEmailRelUpReg;

      case most_msgfi_tclToken::EN_MSG_SaveSentEmailGet:
         return OSAL_NEW most_msgfi_tclMsgSaveSentEmailGet;

      case most_msgfi_tclToken::EN_MSG_SaveSentEmailPureSet:
         return OSAL_NEW most_msgfi_tclMsgSaveSentEmailPureSet;

      case most_msgfi_tclToken::EN_MSG_SaveSentEmailStatus:
         return OSAL_NEW most_msgfi_tclMsgSaveSentEmailStatus;

      case most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesUpReg:
         return OSAL_NEW most_msgfi_tclMsgMapDeviceCapabilitiesUpReg;

      case most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg;

      case most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesGet:
         return OSAL_NEW most_msgfi_tclMsgMapDeviceCapabilitiesGet;

      case most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesStatus:
         return OSAL_NEW most_msgfi_tclMsgMapDeviceCapabilitiesStatus;

      case most_msgfi_tclToken::EN_MSG_MessagingOnOffUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingOnOffUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingOnOffRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingOnOffRelUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingOnOffGet:
         return OSAL_NEW most_msgfi_tclMsgMessagingOnOffGet;

      case most_msgfi_tclToken::EN_MSG_MessagingOnOffSet:
         return OSAL_NEW most_msgfi_tclMsgMessagingOnOffSet;

      case most_msgfi_tclToken::EN_MSG_MessagingOnOffStatus:
         return OSAL_NEW most_msgfi_tclMsgMessagingOnOffStatus;

      case most_msgfi_tclToken::EN_MSG_MessageNotificationUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessageNotificationUpReg;

      case most_msgfi_tclToken::EN_MSG_MessageNotificationRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessageNotificationRelUpReg;

      case most_msgfi_tclToken::EN_MSG_MessageNotificationGet:
         return OSAL_NEW most_msgfi_tclMsgMessageNotificationGet;

      case most_msgfi_tclToken::EN_MSG_MessageNotificationStatus:
         return OSAL_NEW most_msgfi_tclMsgMessageNotificationStatus;

      case most_msgfi_tclToken::EN_MSG_PredefinedMessageListExtendedUpReg:
         return OSAL_NEW most_msgfi_tclMsgPredefinedMessageListExtendedUpReg;

      case most_msgfi_tclToken::EN_MSG_PredefinedMessageListExtendedRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg;

      case most_msgfi_tclToken::EN_MSG_PredefinedMessageListExtendedGet:
         return OSAL_NEW most_msgfi_tclMsgPredefinedMessageListExtendedGet;

      case most_msgfi_tclToken::EN_MSG_PredefinedMessageListExtendedStatus:
         return OSAL_NEW most_msgfi_tclMsgPredefinedMessageListExtendedStatus;

      case most_msgfi_tclToken::EN_MSG_MessagingLanguageUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingLanguageUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingLanguageRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingLanguageRelUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingLanguageGet:
         return OSAL_NEW most_msgfi_tclMsgMessagingLanguageGet;

      case most_msgfi_tclToken::EN_MSG_MessagingLanguageSet:
         return OSAL_NEW most_msgfi_tclMsgMessagingLanguageSet;

      case most_msgfi_tclToken::EN_MSG_MessagingLanguageStatus:
         return OSAL_NEW most_msgfi_tclMsgMessagingLanguageStatus;

      case most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedUpReg:
         return OSAL_NEW most_msgfi_tclMsgSignatureSettingExtendedUpReg;

      case most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgSignatureSettingExtendedRelUpReg;

      case most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedGet:
         return OSAL_NEW most_msgfi_tclMsgSignatureSettingExtendedGet;

      case most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedPureSet:
         return OSAL_NEW most_msgfi_tclMsgSignatureSettingExtendedPureSet;

      case most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedStatus:
         return OSAL_NEW most_msgfi_tclMsgSignatureSettingExtendedStatus;

      case most_msgfi_tclToken::EN_MSG_MessagingOnOffListUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingOnOffListUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingOnOffListRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgMessagingOnOffListRelUpReg;

      case most_msgfi_tclToken::EN_MSG_MessagingOnOffListGet:
         return OSAL_NEW most_msgfi_tclMsgMessagingOnOffListGet;

      case most_msgfi_tclToken::EN_MSG_MessagingOnOffListStatus:
         return OSAL_NEW most_msgfi_tclMsgMessagingOnOffListStatus;

      case most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListUpReg:
         return OSAL_NEW most_msgfi_tclMsgTextRingtoneOnOffListUpReg;

      case most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg;

      case most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListGet:
         return OSAL_NEW most_msgfi_tclMsgTextRingtoneOnOffListGet;

      case most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListPureSet:
         return OSAL_NEW most_msgfi_tclMsgTextRingtoneOnOffListPureSet;

      case most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListStatus:
         return OSAL_NEW most_msgfi_tclMsgTextRingtoneOnOffListStatus;

      case most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListUpReg:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyOnOffListUpReg;

      case most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyOnOffListRelUpReg;

      case most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListGet:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyOnOffListGet;

      case most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListPureSet:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyOnOffListPureSet;

      case most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListStatus:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyOnOffListStatus;

      case most_msgfi_tclToken::EN_MSG_AutoReplyTextListUpReg:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyTextListUpReg;

      case most_msgfi_tclToken::EN_MSG_AutoReplyTextListRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyTextListRelUpReg;

      case most_msgfi_tclToken::EN_MSG_AutoReplyTextListGet:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyTextListGet;

      case most_msgfi_tclToken::EN_MSG_AutoReplyTextListPureSet:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyTextListPureSet;

      case most_msgfi_tclToken::EN_MSG_AutoReplyTextListStatus:
         return OSAL_NEW most_msgfi_tclMsgAutoReplyTextListStatus;

      case most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesExtendedUpReg:
         return OSAL_NEW most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg;

      case most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesExtendedRelUpReg:
         return OSAL_NEW most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg;

      case most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesExtendedGet:
         return OSAL_NEW most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet;

      case most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesExtendedStatus:
         return OSAL_NEW most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all most_msgfifi messages

// common functions

tU16 most_msgfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MOST_MSGFI_C_U16_SERVICE_ID;
}

tU16 most_msgfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 most_msgfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& most_msgfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& most_msgfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 most_msgfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& most_msgfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& most_msgfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

// base class for all most_msgfi standard error messages

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDefaultError::most_msgfi_tclMsgDefaultError(const most_msgfi_tclMsgDefaultError& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   *this = coRef;
}
most_msgfi_tclMsgDefaultError& most_msgfi_tclMsgDefaultError::operator=(const most_msgfi_tclMsgDefaultError& coRef)
{
   if (this != &coRef)
   {
      e8ErrorCode = coRef.e8ErrorCode;
      oErrorInfo = coRef.oErrorInfo;
   }

   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgDefaultError::vDestroy()
{
   oErrorInfo.vDestroy();
}

tU32 most_msgfi_tclMsgDefaultError::u32GetSize(tU16 u16MajorVersion) const
{
   return 3 + oErrorInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& most_msgfi_tclMsgDefaultError::oRead(fi_tclInContext& oIn)
{
   tU16 u16CCA_Error = CCA_C_U16_ERROR_UNSPECIFIED;
   (tVoid) (oIn >> u16CCA_Error);
   (tVoid) (oIn >> e8ErrorCode);
   (tVoid) (oIn >> oErrorInfo);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgDefaultError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU16)CCA_C_U16_ERROR_UNSPECIFIED);
   (tVoid) (oOut << e8ErrorCode);
   (tVoid) (oOut << oErrorInfo);
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAllocateMethodStart::most_msgfi_tclMsgAllocateMethodStart(const most_msgfi_tclMsgAllocateMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_msgfi_tclMsgAllocateMethodStart& most_msgfi_tclMsgAllocateMethodStart::operator=(const most_msgfi_tclMsgAllocateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAllocateMethodStart::most_msgfi_tclMsgAllocateMethodStart()
:u8SourceNr(0)
 {}

tS32 most_msgfi_tclMsgAllocateMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AllocateMethodStart;
}


most_msgfi_tclMsgAllocateMethodStart::~most_msgfi_tclMsgAllocateMethodStart()
{}

tU32 most_msgfi_tclMsgAllocateMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgAllocateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAllocateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_msgfi_tclMsgAllocateMethodStart::operator==(const most_msgfi_tclMsgAllocateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAllocateError::most_msgfi_tclMsgAllocateError(const most_msgfi_tclMsgAllocateError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgAllocateError& most_msgfi_tclMsgAllocateError::operator=(const most_msgfi_tclMsgAllocateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgAllocateError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AllocateError;
}


most_msgfi_tclMsgAllocateError::~most_msgfi_tclMsgAllocateError()
{}

tBool most_msgfi_tclMsgAllocateError::operator==(const most_msgfi_tclMsgAllocateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAllocateMethodResult::most_msgfi_tclMsgAllocateMethodResult(const most_msgfi_tclMsgAllocateMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
}
most_msgfi_tclMsgAllocateMethodResult& most_msgfi_tclMsgAllocateMethodResult::operator=(const most_msgfi_tclMsgAllocateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAllocateMethodResult::most_msgfi_tclMsgAllocateMethodResult()
:u8SourceNr(0)
,u16BlockWidth(0)
,u16ConnectionLabel(0)
 {}

tS32 most_msgfi_tclMsgAllocateMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AllocateMethodResult;
}


most_msgfi_tclMsgAllocateMethodResult::~most_msgfi_tclMsgAllocateMethodResult()
{}

tU32 most_msgfi_tclMsgAllocateMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_msgfi_tclMsgAllocateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> u16BlockWidth);
   (tVoid) (oIn >> u16ConnectionLabel);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAllocateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << u16BlockWidth);
   (tVoid) (oOut << u16ConnectionLabel);
   return oOut;
}

tBool most_msgfi_tclMsgAllocateMethodResult::operator==(const most_msgfi_tclMsgAllocateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (u16BlockWidth == roRef.u16BlockWidth);
   bResult = bResult && (u16ConnectionLabel == roRef.u16ConnectionLabel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDeAllocateMethodStart::most_msgfi_tclMsgDeAllocateMethodStart(const most_msgfi_tclMsgDeAllocateMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_msgfi_tclMsgDeAllocateMethodStart& most_msgfi_tclMsgDeAllocateMethodStart::operator=(const most_msgfi_tclMsgDeAllocateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgDeAllocateMethodStart::most_msgfi_tclMsgDeAllocateMethodStart()
:u8SourceNr(0)
 {}

tS32 most_msgfi_tclMsgDeAllocateMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_DeAllocateMethodStart;
}


most_msgfi_tclMsgDeAllocateMethodStart::~most_msgfi_tclMsgDeAllocateMethodStart()
{}

tU32 most_msgfi_tclMsgDeAllocateMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgDeAllocateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgDeAllocateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_msgfi_tclMsgDeAllocateMethodStart::operator==(const most_msgfi_tclMsgDeAllocateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDeAllocateError::most_msgfi_tclMsgDeAllocateError(const most_msgfi_tclMsgDeAllocateError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgDeAllocateError& most_msgfi_tclMsgDeAllocateError::operator=(const most_msgfi_tclMsgDeAllocateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgDeAllocateError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_DeAllocateError;
}


most_msgfi_tclMsgDeAllocateError::~most_msgfi_tclMsgDeAllocateError()
{}

tBool most_msgfi_tclMsgDeAllocateError::operator==(const most_msgfi_tclMsgDeAllocateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDeAllocateMethodResult::most_msgfi_tclMsgDeAllocateMethodResult(const most_msgfi_tclMsgDeAllocateMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_msgfi_tclMsgDeAllocateMethodResult& most_msgfi_tclMsgDeAllocateMethodResult::operator=(const most_msgfi_tclMsgDeAllocateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgDeAllocateMethodResult::most_msgfi_tclMsgDeAllocateMethodResult()
:u8SourceNr(0)
 {}

tS32 most_msgfi_tclMsgDeAllocateMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_DeAllocateMethodResult;
}


most_msgfi_tclMsgDeAllocateMethodResult::~most_msgfi_tclMsgDeAllocateMethodResult()
{}

tU32 most_msgfi_tclMsgDeAllocateMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgDeAllocateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgDeAllocateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_msgfi_tclMsgDeAllocateMethodResult::operator==(const most_msgfi_tclMsgDeAllocateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSourceActivityMethodStart::most_msgfi_tclMsgSourceActivityMethodStart(const most_msgfi_tclMsgSourceActivityMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
}
most_msgfi_tclMsgSourceActivityMethodStart& most_msgfi_tclMsgSourceActivityMethodStart::operator=(const most_msgfi_tclMsgSourceActivityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSourceActivityMethodStart::most_msgfi_tclMsgSourceActivityMethodStart()
:u8SourceNr(0)
,e8Activity()
 {}

tS32 most_msgfi_tclMsgSourceActivityMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceActivityMethodStart;
}


most_msgfi_tclMsgSourceActivityMethodStart::~most_msgfi_tclMsgSourceActivityMethodStart()
{}

tU32 most_msgfi_tclMsgSourceActivityMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgSourceActivityMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> e8Activity);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSourceActivityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << e8Activity);
   return oOut;
}

tBool most_msgfi_tclMsgSourceActivityMethodStart::operator==(const most_msgfi_tclMsgSourceActivityMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSourceActivityError::most_msgfi_tclMsgSourceActivityError(const most_msgfi_tclMsgSourceActivityError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgSourceActivityError& most_msgfi_tclMsgSourceActivityError::operator=(const most_msgfi_tclMsgSourceActivityError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgSourceActivityError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceActivityError;
}


most_msgfi_tclMsgSourceActivityError::~most_msgfi_tclMsgSourceActivityError()
{}

tBool most_msgfi_tclMsgSourceActivityError::operator==(const most_msgfi_tclMsgSourceActivityError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSourceActivityMethodResult::most_msgfi_tclMsgSourceActivityMethodResult(const most_msgfi_tclMsgSourceActivityMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
}
most_msgfi_tclMsgSourceActivityMethodResult& most_msgfi_tclMsgSourceActivityMethodResult::operator=(const most_msgfi_tclMsgSourceActivityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   e8Activity = coRef.e8Activity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSourceActivityMethodResult::most_msgfi_tclMsgSourceActivityMethodResult()
:u8SourceNr(0)
,e8Activity()
 {}

tS32 most_msgfi_tclMsgSourceActivityMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceActivityMethodResult;
}


most_msgfi_tclMsgSourceActivityMethodResult::~most_msgfi_tclMsgSourceActivityMethodResult()
{}

tU32 most_msgfi_tclMsgSourceActivityMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgSourceActivityMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> e8Activity);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSourceActivityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << e8Activity);
   return oOut;
}

tBool most_msgfi_tclMsgSourceActivityMethodResult::operator==(const most_msgfi_tclMsgSourceActivityMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (e8Activity == roRef.e8Activity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgCreateMessageListMethodStart::most_msgfi_tclMsgCreateMessageListMethodStart(const most_msgfi_tclMsgCreateMessageListMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8FolderType = coRef.e8FolderType;
   u32FolderHandle = coRef.u32FolderHandle;
   e8MessageListType = coRef.e8MessageListType;
   e8MessageListSortType = coRef.e8MessageListSortType;
   e8MessageListFilterType = coRef.e8MessageListFilterType;
}
most_msgfi_tclMsgCreateMessageListMethodStart& most_msgfi_tclMsgCreateMessageListMethodStart::operator=(const most_msgfi_tclMsgCreateMessageListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8FolderType = coRef.e8FolderType;
   u32FolderHandle = coRef.u32FolderHandle;
   e8MessageListType = coRef.e8MessageListType;
   e8MessageListSortType = coRef.e8MessageListSortType;
   e8MessageListFilterType = coRef.e8MessageListFilterType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgCreateMessageListMethodStart::most_msgfi_tclMsgCreateMessageListMethodStart()
:u8DeviceHandle(0)
,e8FolderType()
,u32FolderHandle(0)
,e8MessageListType()
,e8MessageListSortType()
,e8MessageListFilterType()
 {}

tS32 most_msgfi_tclMsgCreateMessageListMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_CreateMessageListMethodStart;
}


most_msgfi_tclMsgCreateMessageListMethodStart::~most_msgfi_tclMsgCreateMessageListMethodStart()
{}

tU32 most_msgfi_tclMsgCreateMessageListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 9;
}

fi_tclInContext& most_msgfi_tclMsgCreateMessageListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> e8FolderType);
   (tVoid) (oIn >> u32FolderHandle);
   (tVoid) (oIn >> e8MessageListType);
   (tVoid) (oIn >> e8MessageListSortType);
   (tVoid) (oIn >> e8MessageListFilterType);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgCreateMessageListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << e8FolderType);
   (tVoid) (oOut << u32FolderHandle);
   (tVoid) (oOut << e8MessageListType);
   (tVoid) (oOut << e8MessageListSortType);
   (tVoid) (oOut << e8MessageListFilterType);
   return oOut;
}

tBool most_msgfi_tclMsgCreateMessageListMethodStart::operator==(const most_msgfi_tclMsgCreateMessageListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (e8FolderType == roRef.e8FolderType);
   bResult = bResult && (u32FolderHandle == roRef.u32FolderHandle);
   bResult = bResult && (e8MessageListType == roRef.e8MessageListType);
   bResult = bResult && (e8MessageListSortType == roRef.e8MessageListSortType);
   bResult = bResult && (e8MessageListFilterType == roRef.e8MessageListFilterType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgCreateMessageListError::most_msgfi_tclMsgCreateMessageListError(const most_msgfi_tclMsgCreateMessageListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgCreateMessageListError& most_msgfi_tclMsgCreateMessageListError::operator=(const most_msgfi_tclMsgCreateMessageListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgCreateMessageListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_CreateMessageListError;
}


most_msgfi_tclMsgCreateMessageListError::~most_msgfi_tclMsgCreateMessageListError()
{}

tBool most_msgfi_tclMsgCreateMessageListError::operator==(const most_msgfi_tclMsgCreateMessageListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgCreateMessageListMethodResult::most_msgfi_tclMsgCreateMessageListMethodResult(const most_msgfi_tclMsgCreateMessageListMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u16ListLength = coRef.u16ListLength;
}
most_msgfi_tclMsgCreateMessageListMethodResult& most_msgfi_tclMsgCreateMessageListMethodResult::operator=(const most_msgfi_tclMsgCreateMessageListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u16ListLength = coRef.u16ListLength;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgCreateMessageListMethodResult::most_msgfi_tclMsgCreateMessageListMethodResult()
:u16ListHandle(0)
,u16ListLength(0)
 {}

tS32 most_msgfi_tclMsgCreateMessageListMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_CreateMessageListMethodResult;
}


most_msgfi_tclMsgCreateMessageListMethodResult::~most_msgfi_tclMsgCreateMessageListMethodResult()
{}

tU32 most_msgfi_tclMsgCreateMessageListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 4;
}

fi_tclInContext& most_msgfi_tclMsgCreateMessageListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u16ListLength);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgCreateMessageListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u16ListLength);
   return oOut;
}

tBool most_msgfi_tclMsgCreateMessageListMethodResult::operator==(const most_msgfi_tclMsgCreateMessageListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u16ListLength == roRef.u16ListLength);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestSliceMessageListMethodStart::most_msgfi_tclMsgRequestSliceMessageListMethodStart(const most_msgfi_tclMsgRequestSliceMessageListMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u32WindowSize = coRef.u32WindowSize;
}
most_msgfi_tclMsgRequestSliceMessageListMethodStart& most_msgfi_tclMsgRequestSliceMessageListMethodStart::operator=(const most_msgfi_tclMsgRequestSliceMessageListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u32WindowSize = coRef.u32WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgRequestSliceMessageListMethodStart::most_msgfi_tclMsgRequestSliceMessageListMethodStart()
:u16ListHandle(0)
,u32WindowStart(0)
,u32WindowSize(0)
 {}

tS32 most_msgfi_tclMsgRequestSliceMessageListMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestSliceMessageListMethodStart;
}


most_msgfi_tclMsgRequestSliceMessageListMethodStart::~most_msgfi_tclMsgRequestSliceMessageListMethodStart()
{}

tU32 most_msgfi_tclMsgRequestSliceMessageListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 10;
}

fi_tclInContext& most_msgfi_tclMsgRequestSliceMessageListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u32WindowSize);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRequestSliceMessageListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u32WindowSize);
   return oOut;
}

tBool most_msgfi_tclMsgRequestSliceMessageListMethodStart::operator==(const most_msgfi_tclMsgRequestSliceMessageListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u32WindowSize == roRef.u32WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestSliceMessageListError::most_msgfi_tclMsgRequestSliceMessageListError(const most_msgfi_tclMsgRequestSliceMessageListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgRequestSliceMessageListError& most_msgfi_tclMsgRequestSliceMessageListError::operator=(const most_msgfi_tclMsgRequestSliceMessageListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgRequestSliceMessageListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestSliceMessageListError;
}


most_msgfi_tclMsgRequestSliceMessageListError::~most_msgfi_tclMsgRequestSliceMessageListError()
{}

tBool most_msgfi_tclMsgRequestSliceMessageListError::operator==(const most_msgfi_tclMsgRequestSliceMessageListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestSliceMessageListMethodResult::most_msgfi_tclMsgRequestSliceMessageListMethodResult(const most_msgfi_tclMsgRequestSliceMessageListMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMessageListSliceResult = coRef.oMessageListSliceResult;
}
most_msgfi_tclMsgRequestSliceMessageListMethodResult& most_msgfi_tclMsgRequestSliceMessageListMethodResult::operator=(const most_msgfi_tclMsgRequestSliceMessageListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oMessageListSliceResult = coRef.oMessageListSliceResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgRequestSliceMessageListMethodResult::vDestroy()
{
}

most_msgfi_tclMsgRequestSliceMessageListMethodResult::most_msgfi_tclMsgRequestSliceMessageListMethodResult()
:oMessageListSliceResult()
 {}

tS32 most_msgfi_tclMsgRequestSliceMessageListMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestSliceMessageListMethodResult;
}


most_msgfi_tclMsgRequestSliceMessageListMethodResult::~most_msgfi_tclMsgRequestSliceMessageListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgRequestSliceMessageListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageListSliceResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgRequestSliceMessageListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMessageListSliceResult);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRequestSliceMessageListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMessageListSliceResult);
   return oOut;
}

tBool most_msgfi_tclMsgRequestSliceMessageListMethodResult::operator==(const most_msgfi_tclMsgRequestSliceMessageListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMessageListSliceResult == roRef.oMessageListSliceResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgReleaseMessageListMethodStart::most_msgfi_tclMsgReleaseMessageListMethodStart(const most_msgfi_tclMsgReleaseMessageListMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
}
most_msgfi_tclMsgReleaseMessageListMethodStart& most_msgfi_tclMsgReleaseMessageListMethodStart::operator=(const most_msgfi_tclMsgReleaseMessageListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgReleaseMessageListMethodStart::most_msgfi_tclMsgReleaseMessageListMethodStart()
:u16ListHandle(0)
 {}

tS32 most_msgfi_tclMsgReleaseMessageListMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ReleaseMessageListMethodStart;
}


most_msgfi_tclMsgReleaseMessageListMethodStart::~most_msgfi_tclMsgReleaseMessageListMethodStart()
{}

tU32 most_msgfi_tclMsgReleaseMessageListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgReleaseMessageListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgReleaseMessageListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   return oOut;
}

tBool most_msgfi_tclMsgReleaseMessageListMethodStart::operator==(const most_msgfi_tclMsgReleaseMessageListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgReleaseMessageListError::most_msgfi_tclMsgReleaseMessageListError(const most_msgfi_tclMsgReleaseMessageListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgReleaseMessageListError& most_msgfi_tclMsgReleaseMessageListError::operator=(const most_msgfi_tclMsgReleaseMessageListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgReleaseMessageListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ReleaseMessageListError;
}


most_msgfi_tclMsgReleaseMessageListError::~most_msgfi_tclMsgReleaseMessageListError()
{}

tBool most_msgfi_tclMsgReleaseMessageListError::operator==(const most_msgfi_tclMsgReleaseMessageListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgReleaseMessageListMethodResult::most_msgfi_tclMsgReleaseMessageListMethodResult(const most_msgfi_tclMsgReleaseMessageListMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
}
most_msgfi_tclMsgReleaseMessageListMethodResult& most_msgfi_tclMsgReleaseMessageListMethodResult::operator=(const most_msgfi_tclMsgReleaseMessageListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgReleaseMessageListMethodResult::most_msgfi_tclMsgReleaseMessageListMethodResult()
:u16ListHandle(0)
 {}

tS32 most_msgfi_tclMsgReleaseMessageListMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ReleaseMessageListMethodResult;
}


most_msgfi_tclMsgReleaseMessageListMethodResult::~most_msgfi_tclMsgReleaseMessageListMethodResult()
{}

tU32 most_msgfi_tclMsgReleaseMessageListMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgReleaseMessageListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgReleaseMessageListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   return oOut;
}

tBool most_msgfi_tclMsgReleaseMessageListMethodResult::operator==(const most_msgfi_tclMsgReleaseMessageListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestFolderListMethodStart::most_msgfi_tclMsgRequestFolderListMethodStart(const most_msgfi_tclMsgRequestFolderListMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u32FolderHandle = coRef.u32FolderHandle;
   bRootFlag = coRef.bRootFlag;
}
most_msgfi_tclMsgRequestFolderListMethodStart& most_msgfi_tclMsgRequestFolderListMethodStart::operator=(const most_msgfi_tclMsgRequestFolderListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32FolderHandle = coRef.u32FolderHandle;
   bRootFlag = coRef.bRootFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgRequestFolderListMethodStart::most_msgfi_tclMsgRequestFolderListMethodStart()
:u32FolderHandle(0)
,bRootFlag(0)
 {}

tS32 most_msgfi_tclMsgRequestFolderListMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestFolderListMethodStart;
}


most_msgfi_tclMsgRequestFolderListMethodStart::~most_msgfi_tclMsgRequestFolderListMethodStart()
{}

tU32 most_msgfi_tclMsgRequestFolderListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_msgfi_tclMsgRequestFolderListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32FolderHandle);
   (tVoid) (oIn >> bRootFlag);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRequestFolderListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32FolderHandle);
   (tVoid) (oOut << bRootFlag);
   return oOut;
}

tBool most_msgfi_tclMsgRequestFolderListMethodStart::operator==(const most_msgfi_tclMsgRequestFolderListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32FolderHandle == roRef.u32FolderHandle);
   bResult = bResult && (bRootFlag == roRef.bRootFlag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestFolderListError::most_msgfi_tclMsgRequestFolderListError(const most_msgfi_tclMsgRequestFolderListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgRequestFolderListError& most_msgfi_tclMsgRequestFolderListError::operator=(const most_msgfi_tclMsgRequestFolderListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgRequestFolderListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestFolderListError;
}


most_msgfi_tclMsgRequestFolderListError::~most_msgfi_tclMsgRequestFolderListError()
{}

tBool most_msgfi_tclMsgRequestFolderListError::operator==(const most_msgfi_tclMsgRequestFolderListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestFolderListMethodResult::most_msgfi_tclMsgRequestFolderListMethodResult(const most_msgfi_tclMsgRequestFolderListMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oFolderListResult = coRef.oFolderListResult;
}
most_msgfi_tclMsgRequestFolderListMethodResult& most_msgfi_tclMsgRequestFolderListMethodResult::operator=(const most_msgfi_tclMsgRequestFolderListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oFolderListResult = coRef.oFolderListResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgRequestFolderListMethodResult::vDestroy()
{
}

most_msgfi_tclMsgRequestFolderListMethodResult::most_msgfi_tclMsgRequestFolderListMethodResult()
:oFolderListResult()
 {}

tS32 most_msgfi_tclMsgRequestFolderListMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestFolderListMethodResult;
}


most_msgfi_tclMsgRequestFolderListMethodResult::~most_msgfi_tclMsgRequestFolderListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgRequestFolderListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oFolderListResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgRequestFolderListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oFolderListResult);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRequestFolderListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oFolderListResult);
   return oOut;
}

tBool most_msgfi_tclMsgRequestFolderListMethodResult::operator==(const most_msgfi_tclMsgRequestFolderListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oFolderListResult == roRef.oFolderListResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDeleteMessageMethodStart::most_msgfi_tclMsgDeleteMessageMethodStart(const most_msgfi_tclMsgDeleteMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oDeleteMessageHandles = coRef.oDeleteMessageHandles;
}
most_msgfi_tclMsgDeleteMessageMethodStart& most_msgfi_tclMsgDeleteMessageMethodStart::operator=(const most_msgfi_tclMsgDeleteMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oDeleteMessageHandles = coRef.oDeleteMessageHandles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgDeleteMessageMethodStart::most_msgfi_tclMsgDeleteMessageMethodStart()
:oDeleteMessageHandles()
 {}

tS32 most_msgfi_tclMsgDeleteMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_DeleteMessageMethodStart;
}


most_msgfi_tclMsgDeleteMessageMethodStart::~most_msgfi_tclMsgDeleteMessageMethodStart()
{}

tU32 most_msgfi_tclMsgDeleteMessageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDeleteMessageHandles.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgDeleteMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDeleteMessageHandles);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgDeleteMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDeleteMessageHandles);
   return oOut;
}

tBool most_msgfi_tclMsgDeleteMessageMethodStart::operator==(const most_msgfi_tclMsgDeleteMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDeleteMessageHandles == roRef.oDeleteMessageHandles);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDeleteMessageError::most_msgfi_tclMsgDeleteMessageError(const most_msgfi_tclMsgDeleteMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgDeleteMessageError& most_msgfi_tclMsgDeleteMessageError::operator=(const most_msgfi_tclMsgDeleteMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgDeleteMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_DeleteMessageError;
}


most_msgfi_tclMsgDeleteMessageError::~most_msgfi_tclMsgDeleteMessageError()
{}

tBool most_msgfi_tclMsgDeleteMessageError::operator==(const most_msgfi_tclMsgDeleteMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDeleteMessageMethodResult::most_msgfi_tclMsgDeleteMessageMethodResult(const most_msgfi_tclMsgDeleteMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8DeletionStatus = coRef.e8DeletionStatus;
   oDeleteMessageHandles = coRef.oDeleteMessageHandles;
}
most_msgfi_tclMsgDeleteMessageMethodResult& most_msgfi_tclMsgDeleteMessageMethodResult::operator=(const most_msgfi_tclMsgDeleteMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8DeletionStatus = coRef.e8DeletionStatus;
   oDeleteMessageHandles = coRef.oDeleteMessageHandles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgDeleteMessageMethodResult::most_msgfi_tclMsgDeleteMessageMethodResult()
:e8DeletionStatus()
,oDeleteMessageHandles()
 {}

tS32 most_msgfi_tclMsgDeleteMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_DeleteMessageMethodResult;
}


most_msgfi_tclMsgDeleteMessageMethodResult::~most_msgfi_tclMsgDeleteMessageMethodResult()
{}

tU32 most_msgfi_tclMsgDeleteMessageMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDeleteMessageHandles.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgDeleteMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DeletionStatus);
   (tVoid) (oIn >> oDeleteMessageHandles);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgDeleteMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DeletionStatus);
   (tVoid) (oOut << oDeleteMessageHandles);
   return oOut;
}

tBool most_msgfi_tclMsgDeleteMessageMethodResult::operator==(const most_msgfi_tclMsgDeleteMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DeletionStatus == roRef.e8DeletionStatus);
   bResult = bResult && (oDeleteMessageHandles == roRef.oDeleteMessageHandles);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRecoverMessageMethodStart::most_msgfi_tclMsgRecoverMessageMethodStart(const most_msgfi_tclMsgRecoverMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMessageHandle = coRef.oMessageHandle;
}
most_msgfi_tclMsgRecoverMessageMethodStart& most_msgfi_tclMsgRecoverMessageMethodStart::operator=(const most_msgfi_tclMsgRecoverMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oMessageHandle = coRef.oMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgRecoverMessageMethodStart::most_msgfi_tclMsgRecoverMessageMethodStart()
:oMessageHandle()
 {}

tS32 most_msgfi_tclMsgRecoverMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecoverMessageMethodStart;
}


most_msgfi_tclMsgRecoverMessageMethodStart::~most_msgfi_tclMsgRecoverMessageMethodStart()
{}

tU32 most_msgfi_tclMsgRecoverMessageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgRecoverMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRecoverMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgRecoverMessageMethodStart::operator==(const most_msgfi_tclMsgRecoverMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRecoverMessageError::most_msgfi_tclMsgRecoverMessageError(const most_msgfi_tclMsgRecoverMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgRecoverMessageError& most_msgfi_tclMsgRecoverMessageError::operator=(const most_msgfi_tclMsgRecoverMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgRecoverMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecoverMessageError;
}


most_msgfi_tclMsgRecoverMessageError::~most_msgfi_tclMsgRecoverMessageError()
{}

tBool most_msgfi_tclMsgRecoverMessageError::operator==(const most_msgfi_tclMsgRecoverMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRecoverMessageMethodResult::most_msgfi_tclMsgRecoverMessageMethodResult(const most_msgfi_tclMsgRecoverMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8RecoveryStatus = coRef.e8RecoveryStatus;
   oMessageHandle = coRef.oMessageHandle;
}
most_msgfi_tclMsgRecoverMessageMethodResult& most_msgfi_tclMsgRecoverMessageMethodResult::operator=(const most_msgfi_tclMsgRecoverMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8RecoveryStatus = coRef.e8RecoveryStatus;
   oMessageHandle = coRef.oMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgRecoverMessageMethodResult::most_msgfi_tclMsgRecoverMessageMethodResult()
:e8RecoveryStatus()
,oMessageHandle()
 {}

tS32 most_msgfi_tclMsgRecoverMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecoverMessageMethodResult;
}


most_msgfi_tclMsgRecoverMessageMethodResult::~most_msgfi_tclMsgRecoverMessageMethodResult()
{}

tU32 most_msgfi_tclMsgRecoverMessageMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgRecoverMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RecoveryStatus);
   (tVoid) (oIn >> oMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRecoverMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RecoveryStatus);
   (tVoid) (oOut << oMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgRecoverMessageMethodResult::operator==(const most_msgfi_tclMsgRecoverMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RecoveryStatus == roRef.e8RecoveryStatus);
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestAccountListMethodStart::most_msgfi_tclMsgRequestAccountListMethodStart(const most_msgfi_tclMsgRequestAccountListMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_msgfi_tclMsgRequestAccountListMethodStart& most_msgfi_tclMsgRequestAccountListMethodStart::operator=(const most_msgfi_tclMsgRequestAccountListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgRequestAccountListMethodStart::most_msgfi_tclMsgRequestAccountListMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_msgfi_tclMsgRequestAccountListMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestAccountListMethodStart;
}


most_msgfi_tclMsgRequestAccountListMethodStart::~most_msgfi_tclMsgRequestAccountListMethodStart()
{}

tU32 most_msgfi_tclMsgRequestAccountListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgRequestAccountListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRequestAccountListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_msgfi_tclMsgRequestAccountListMethodStart::operator==(const most_msgfi_tclMsgRequestAccountListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestAccountListError::most_msgfi_tclMsgRequestAccountListError(const most_msgfi_tclMsgRequestAccountListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgRequestAccountListError& most_msgfi_tclMsgRequestAccountListError::operator=(const most_msgfi_tclMsgRequestAccountListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgRequestAccountListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestAccountListError;
}


most_msgfi_tclMsgRequestAccountListError::~most_msgfi_tclMsgRequestAccountListError()
{}

tBool most_msgfi_tclMsgRequestAccountListError::operator==(const most_msgfi_tclMsgRequestAccountListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestAccountListMethodResult::most_msgfi_tclMsgRequestAccountListMethodResult(const most_msgfi_tclMsgRequestAccountListMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oAccountListResult = coRef.oAccountListResult;
}
most_msgfi_tclMsgRequestAccountListMethodResult& most_msgfi_tclMsgRequestAccountListMethodResult::operator=(const most_msgfi_tclMsgRequestAccountListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oAccountListResult = coRef.oAccountListResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgRequestAccountListMethodResult::vDestroy()
{
}

most_msgfi_tclMsgRequestAccountListMethodResult::most_msgfi_tclMsgRequestAccountListMethodResult()
:oAccountListResult()
 {}

tS32 most_msgfi_tclMsgRequestAccountListMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestAccountListMethodResult;
}


most_msgfi_tclMsgRequestAccountListMethodResult::~most_msgfi_tclMsgRequestAccountListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgRequestAccountListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oAccountListResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgRequestAccountListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oAccountListResult);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRequestAccountListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oAccountListResult);
   return oOut;
}

tBool most_msgfi_tclMsgRequestAccountListMethodResult::operator==(const most_msgfi_tclMsgRequestAccountListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oAccountListResult == roRef.oAccountListResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgChangeAccountMethodStart::most_msgfi_tclMsgChangeAccountMethodStart(const most_msgfi_tclMsgChangeAccountMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16AccountHandle = coRef.u16AccountHandle;
}
most_msgfi_tclMsgChangeAccountMethodStart& most_msgfi_tclMsgChangeAccountMethodStart::operator=(const most_msgfi_tclMsgChangeAccountMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16AccountHandle = coRef.u16AccountHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgChangeAccountMethodStart::most_msgfi_tclMsgChangeAccountMethodStart()
:u16AccountHandle(0)
 {}

tS32 most_msgfi_tclMsgChangeAccountMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ChangeAccountMethodStart;
}


most_msgfi_tclMsgChangeAccountMethodStart::~most_msgfi_tclMsgChangeAccountMethodStart()
{}

tU32 most_msgfi_tclMsgChangeAccountMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgChangeAccountMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16AccountHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgChangeAccountMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16AccountHandle);
   return oOut;
}

tBool most_msgfi_tclMsgChangeAccountMethodStart::operator==(const most_msgfi_tclMsgChangeAccountMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16AccountHandle == roRef.u16AccountHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgChangeAccountError::most_msgfi_tclMsgChangeAccountError(const most_msgfi_tclMsgChangeAccountError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgChangeAccountError& most_msgfi_tclMsgChangeAccountError::operator=(const most_msgfi_tclMsgChangeAccountError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgChangeAccountError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ChangeAccountError;
}


most_msgfi_tclMsgChangeAccountError::~most_msgfi_tclMsgChangeAccountError()
{}

tBool most_msgfi_tclMsgChangeAccountError::operator==(const most_msgfi_tclMsgChangeAccountError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgChangeAccountMethodResult::most_msgfi_tclMsgChangeAccountMethodResult(const most_msgfi_tclMsgChangeAccountMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bAccountConnectionResult = coRef.bAccountConnectionResult;
}
most_msgfi_tclMsgChangeAccountMethodResult& most_msgfi_tclMsgChangeAccountMethodResult::operator=(const most_msgfi_tclMsgChangeAccountMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bAccountConnectionResult = coRef.bAccountConnectionResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgChangeAccountMethodResult::most_msgfi_tclMsgChangeAccountMethodResult()
:bAccountConnectionResult(0)
 {}

tS32 most_msgfi_tclMsgChangeAccountMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ChangeAccountMethodResult;
}


most_msgfi_tclMsgChangeAccountMethodResult::~most_msgfi_tclMsgChangeAccountMethodResult()
{}

tU32 most_msgfi_tclMsgChangeAccountMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgChangeAccountMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAccountConnectionResult);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgChangeAccountMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAccountConnectionResult);
   return oOut;
}

tBool most_msgfi_tclMsgChangeAccountMethodResult::operator==(const most_msgfi_tclMsgChangeAccountMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAccountConnectionResult == roRef.bAccountConnectionResult);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgUpdateInboxMethodStart::most_msgfi_tclMsgUpdateInboxMethodStart()
 {}

tS32 most_msgfi_tclMsgUpdateInboxMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_UpdateInboxMethodStart;
}


most_msgfi_tclMsgUpdateInboxMethodStart::~most_msgfi_tclMsgUpdateInboxMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgUpdateInboxError::most_msgfi_tclMsgUpdateInboxError(const most_msgfi_tclMsgUpdateInboxError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgUpdateInboxError& most_msgfi_tclMsgUpdateInboxError::operator=(const most_msgfi_tclMsgUpdateInboxError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgUpdateInboxError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_UpdateInboxError;
}


most_msgfi_tclMsgUpdateInboxError::~most_msgfi_tclMsgUpdateInboxError()
{}

tBool most_msgfi_tclMsgUpdateInboxError::operator==(const most_msgfi_tclMsgUpdateInboxError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgUpdateInboxMethodResult::most_msgfi_tclMsgUpdateInboxMethodResult()
 {}

tS32 most_msgfi_tclMsgUpdateInboxMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_UpdateInboxMethodResult;
}


most_msgfi_tclMsgUpdateInboxMethodResult::~most_msgfi_tclMsgUpdateInboxMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetMessageMethodStart::most_msgfi_tclMsgGetMessageMethodStart(const most_msgfi_tclMsgGetMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMessageHandle = coRef.oMessageHandle;
}
most_msgfi_tclMsgGetMessageMethodStart& most_msgfi_tclMsgGetMessageMethodStart::operator=(const most_msgfi_tclMsgGetMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oMessageHandle = coRef.oMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetMessageMethodStart::most_msgfi_tclMsgGetMessageMethodStart()
:oMessageHandle()
 {}

tS32 most_msgfi_tclMsgGetMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetMessageMethodStart;
}


most_msgfi_tclMsgGetMessageMethodStart::~most_msgfi_tclMsgGetMessageMethodStart()
{}

tU32 most_msgfi_tclMsgGetMessageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgGetMessageMethodStart::operator==(const most_msgfi_tclMsgGetMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetMessageError::most_msgfi_tclMsgGetMessageError(const most_msgfi_tclMsgGetMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgGetMessageError& most_msgfi_tclMsgGetMessageError::operator=(const most_msgfi_tclMsgGetMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgGetMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetMessageError;
}


most_msgfi_tclMsgGetMessageError::~most_msgfi_tclMsgGetMessageError()
{}

tBool most_msgfi_tclMsgGetMessageError::operator==(const most_msgfi_tclMsgGetMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetMessageMethodResult::most_msgfi_tclMsgGetMessageMethodResult(const most_msgfi_tclMsgGetMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMessageDetailsResult = coRef.oMessageDetailsResult;
}
most_msgfi_tclMsgGetMessageMethodResult& most_msgfi_tclMsgGetMessageMethodResult::operator=(const most_msgfi_tclMsgGetMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oMessageDetailsResult = coRef.oMessageDetailsResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgGetMessageMethodResult::vDestroy()
{
   oMessageDetailsResult.vDestroy(); 
}

most_msgfi_tclMsgGetMessageMethodResult::most_msgfi_tclMsgGetMessageMethodResult()
:oMessageDetailsResult()
 {}

tS32 most_msgfi_tclMsgGetMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetMessageMethodResult;
}


most_msgfi_tclMsgGetMessageMethodResult::~most_msgfi_tclMsgGetMessageMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgGetMessageMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageDetailsResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMessageDetailsResult);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMessageDetailsResult);
   return oOut;
}

tBool most_msgfi_tclMsgGetMessageMethodResult::operator==(const most_msgfi_tclMsgGetMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMessageDetailsResult == roRef.oMessageDetailsResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetAttachmentListMethodStart::most_msgfi_tclMsgGetAttachmentListMethodStart(const most_msgfi_tclMsgGetAttachmentListMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMessageHandle = coRef.oMessageHandle;
}
most_msgfi_tclMsgGetAttachmentListMethodStart& most_msgfi_tclMsgGetAttachmentListMethodStart::operator=(const most_msgfi_tclMsgGetAttachmentListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oMessageHandle = coRef.oMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetAttachmentListMethodStart::most_msgfi_tclMsgGetAttachmentListMethodStart()
:oMessageHandle()
 {}

tS32 most_msgfi_tclMsgGetAttachmentListMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetAttachmentListMethodStart;
}


most_msgfi_tclMsgGetAttachmentListMethodStart::~most_msgfi_tclMsgGetAttachmentListMethodStart()
{}

tU32 most_msgfi_tclMsgGetAttachmentListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetAttachmentListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetAttachmentListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgGetAttachmentListMethodStart::operator==(const most_msgfi_tclMsgGetAttachmentListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetAttachmentListError::most_msgfi_tclMsgGetAttachmentListError(const most_msgfi_tclMsgGetAttachmentListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgGetAttachmentListError& most_msgfi_tclMsgGetAttachmentListError::operator=(const most_msgfi_tclMsgGetAttachmentListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgGetAttachmentListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetAttachmentListError;
}


most_msgfi_tclMsgGetAttachmentListError::~most_msgfi_tclMsgGetAttachmentListError()
{}

tBool most_msgfi_tclMsgGetAttachmentListError::operator==(const most_msgfi_tclMsgGetAttachmentListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetAttachmentListMethodResult::most_msgfi_tclMsgGetAttachmentListMethodResult(const most_msgfi_tclMsgGetAttachmentListMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oAttachmentList = coRef.oAttachmentList;
}
most_msgfi_tclMsgGetAttachmentListMethodResult& most_msgfi_tclMsgGetAttachmentListMethodResult::operator=(const most_msgfi_tclMsgGetAttachmentListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oAttachmentList = coRef.oAttachmentList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgGetAttachmentListMethodResult::vDestroy()
{
}

most_msgfi_tclMsgGetAttachmentListMethodResult::most_msgfi_tclMsgGetAttachmentListMethodResult()
:oAttachmentList()
 {}

tS32 most_msgfi_tclMsgGetAttachmentListMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetAttachmentListMethodResult;
}


most_msgfi_tclMsgGetAttachmentListMethodResult::~most_msgfi_tclMsgGetAttachmentListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgGetAttachmentListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oAttachmentList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetAttachmentListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oAttachmentList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetAttachmentListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oAttachmentList);
   return oOut;
}

tBool most_msgfi_tclMsgGetAttachmentListMethodResult::operator==(const most_msgfi_tclMsgGetAttachmentListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oAttachmentList == roRef.oAttachmentList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart::most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16AttachmentHandle = coRef.u16AttachmentHandle;
   e8PlaybackAction = coRef.e8PlaybackAction;
}
most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart& most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart::operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16AttachmentHandle = coRef.u16AttachmentHandle;
   e8PlaybackAction = coRef.e8PlaybackAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart::most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart()
:u16AttachmentHandle(0)
,e8PlaybackAction()
 {}

tS32 most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackMethodStart;
}


most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart::~most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart()
{}

tU32 most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16AttachmentHandle);
   (tVoid) (oIn >> e8PlaybackAction);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16AttachmentHandle);
   (tVoid) (oOut << e8PlaybackAction);
   return oOut;
}

tBool most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart::operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16AttachmentHandle == roRef.u16AttachmentHandle);
   bResult = bResult && (e8PlaybackAction == roRef.e8PlaybackAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAudioAttachmentPlaybackError::most_msgfi_tclMsgAudioAttachmentPlaybackError(const most_msgfi_tclMsgAudioAttachmentPlaybackError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgAudioAttachmentPlaybackError& most_msgfi_tclMsgAudioAttachmentPlaybackError::operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgAudioAttachmentPlaybackError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackError;
}


most_msgfi_tclMsgAudioAttachmentPlaybackError::~most_msgfi_tclMsgAudioAttachmentPlaybackError()
{}

tBool most_msgfi_tclMsgAudioAttachmentPlaybackError::operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult::most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackAction = coRef.e8PlaybackAction;
}
most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult& most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult::operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackAction = coRef.e8PlaybackAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult::most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult()
:e8PlaybackAction()
 {}

tS32 most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackMethodResult;
}


most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult::~most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult()
{}

tU32 most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackAction);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackAction);
   return oOut;
}

tBool most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult::operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackAction == roRef.e8PlaybackAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetImageAttachmentMethodStart::most_msgfi_tclMsgGetImageAttachmentMethodStart(const most_msgfi_tclMsgGetImageAttachmentMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16AttachmentHandle = coRef.u16AttachmentHandle;
}
most_msgfi_tclMsgGetImageAttachmentMethodStart& most_msgfi_tclMsgGetImageAttachmentMethodStart::operator=(const most_msgfi_tclMsgGetImageAttachmentMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16AttachmentHandle = coRef.u16AttachmentHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetImageAttachmentMethodStart::most_msgfi_tclMsgGetImageAttachmentMethodStart()
:u16AttachmentHandle(0)
 {}

tS32 most_msgfi_tclMsgGetImageAttachmentMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetImageAttachmentMethodStart;
}


most_msgfi_tclMsgGetImageAttachmentMethodStart::~most_msgfi_tclMsgGetImageAttachmentMethodStart()
{}

tU32 most_msgfi_tclMsgGetImageAttachmentMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgGetImageAttachmentMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16AttachmentHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetImageAttachmentMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16AttachmentHandle);
   return oOut;
}

tBool most_msgfi_tclMsgGetImageAttachmentMethodStart::operator==(const most_msgfi_tclMsgGetImageAttachmentMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16AttachmentHandle == roRef.u16AttachmentHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetImageAttachmentError::most_msgfi_tclMsgGetImageAttachmentError(const most_msgfi_tclMsgGetImageAttachmentError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgGetImageAttachmentError& most_msgfi_tclMsgGetImageAttachmentError::operator=(const most_msgfi_tclMsgGetImageAttachmentError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgGetImageAttachmentError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetImageAttachmentError;
}


most_msgfi_tclMsgGetImageAttachmentError::~most_msgfi_tclMsgGetImageAttachmentError()
{}

tBool most_msgfi_tclMsgGetImageAttachmentError::operator==(const most_msgfi_tclMsgGetImageAttachmentError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetImageAttachmentMethodResult::most_msgfi_tclMsgGetImageAttachmentMethodResult(const most_msgfi_tclMsgGetImageAttachmentMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8DataByte = coRef.u8DataByte;
}
most_msgfi_tclMsgGetImageAttachmentMethodResult& most_msgfi_tclMsgGetImageAttachmentMethodResult::operator=(const most_msgfi_tclMsgGetImageAttachmentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DataByte = coRef.u8DataByte;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetImageAttachmentMethodResult::most_msgfi_tclMsgGetImageAttachmentMethodResult()
:u8DataByte(0)
 {}

tS32 most_msgfi_tclMsgGetImageAttachmentMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetImageAttachmentMethodResult;
}


most_msgfi_tclMsgGetImageAttachmentMethodResult::~most_msgfi_tclMsgGetImageAttachmentMethodResult()
{}

tU32 most_msgfi_tclMsgGetImageAttachmentMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgGetImageAttachmentMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DataByte);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetImageAttachmentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DataByte);
   return oOut;
}

tBool most_msgfi_tclMsgGetImageAttachmentMethodResult::operator==(const most_msgfi_tclMsgGetImageAttachmentMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DataByte == roRef.u8DataByte);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetBodyPartListMethodStart::most_msgfi_tclMsgGetBodyPartListMethodStart(const most_msgfi_tclMsgGetBodyPartListMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMessageHandle = coRef.oMessageHandle;
}
most_msgfi_tclMsgGetBodyPartListMethodStart& most_msgfi_tclMsgGetBodyPartListMethodStart::operator=(const most_msgfi_tclMsgGetBodyPartListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oMessageHandle = coRef.oMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetBodyPartListMethodStart::most_msgfi_tclMsgGetBodyPartListMethodStart()
:oMessageHandle()
 {}

tS32 most_msgfi_tclMsgGetBodyPartListMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetBodyPartListMethodStart;
}


most_msgfi_tclMsgGetBodyPartListMethodStart::~most_msgfi_tclMsgGetBodyPartListMethodStart()
{}

tU32 most_msgfi_tclMsgGetBodyPartListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetBodyPartListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetBodyPartListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgGetBodyPartListMethodStart::operator==(const most_msgfi_tclMsgGetBodyPartListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetBodyPartListError::most_msgfi_tclMsgGetBodyPartListError(const most_msgfi_tclMsgGetBodyPartListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgGetBodyPartListError& most_msgfi_tclMsgGetBodyPartListError::operator=(const most_msgfi_tclMsgGetBodyPartListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgGetBodyPartListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetBodyPartListError;
}


most_msgfi_tclMsgGetBodyPartListError::~most_msgfi_tclMsgGetBodyPartListError()
{}

tBool most_msgfi_tclMsgGetBodyPartListError::operator==(const most_msgfi_tclMsgGetBodyPartListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetBodyPartListMethodResult::most_msgfi_tclMsgGetBodyPartListMethodResult(const most_msgfi_tclMsgGetBodyPartListMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oBodyPartList = coRef.oBodyPartList;
}
most_msgfi_tclMsgGetBodyPartListMethodResult& most_msgfi_tclMsgGetBodyPartListMethodResult::operator=(const most_msgfi_tclMsgGetBodyPartListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oBodyPartList = coRef.oBodyPartList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgGetBodyPartListMethodResult::vDestroy()
{
}

most_msgfi_tclMsgGetBodyPartListMethodResult::most_msgfi_tclMsgGetBodyPartListMethodResult()
:oBodyPartList()
 {}

tS32 most_msgfi_tclMsgGetBodyPartListMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetBodyPartListMethodResult;
}


most_msgfi_tclMsgGetBodyPartListMethodResult::~most_msgfi_tclMsgGetBodyPartListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgGetBodyPartListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oBodyPartList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetBodyPartListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oBodyPartList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetBodyPartListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oBodyPartList);
   return oOut;
}

tBool most_msgfi_tclMsgGetBodyPartListMethodResult::operator==(const most_msgfi_tclMsgGetBodyPartListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oBodyPartList == roRef.oBodyPartList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgReadMessageAloudMethodStart::most_msgfi_tclMsgReadMessageAloudMethodStart(const most_msgfi_tclMsgReadMessageAloudMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMessageHandle = coRef.oMessageHandle;
   e8PlaybackAction = coRef.e8PlaybackAction;
   u8LogicalAVChannel = coRef.u8LogicalAVChannel;
   e8TTSLanguage = coRef.e8TTSLanguage;
}
most_msgfi_tclMsgReadMessageAloudMethodStart& most_msgfi_tclMsgReadMessageAloudMethodStart::operator=(const most_msgfi_tclMsgReadMessageAloudMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oMessageHandle = coRef.oMessageHandle;
   e8PlaybackAction = coRef.e8PlaybackAction;
   u8LogicalAVChannel = coRef.u8LogicalAVChannel;
   e8TTSLanguage = coRef.e8TTSLanguage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgReadMessageAloudMethodStart::most_msgfi_tclMsgReadMessageAloudMethodStart()
:oMessageHandle()
,e8PlaybackAction()
,u8LogicalAVChannel(0)
,e8TTSLanguage()
 {}

tS32 most_msgfi_tclMsgReadMessageAloudMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ReadMessageAloudMethodStart;
}


most_msgfi_tclMsgReadMessageAloudMethodStart::~most_msgfi_tclMsgReadMessageAloudMethodStart()
{}

tU32 most_msgfi_tclMsgReadMessageAloudMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 3 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgReadMessageAloudMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMessageHandle);
   (tVoid) (oIn >> e8PlaybackAction);
   (tVoid) (oIn >> u8LogicalAVChannel);
   (tVoid) (oIn >> e8TTSLanguage);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgReadMessageAloudMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMessageHandle);
   (tVoid) (oOut << e8PlaybackAction);
   (tVoid) (oOut << u8LogicalAVChannel);
   (tVoid) (oOut << e8TTSLanguage);
   return oOut;
}

tBool most_msgfi_tclMsgReadMessageAloudMethodStart::operator==(const most_msgfi_tclMsgReadMessageAloudMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   bResult = bResult && (e8PlaybackAction == roRef.e8PlaybackAction);
   bResult = bResult && (u8LogicalAVChannel == roRef.u8LogicalAVChannel);
   bResult = bResult && (e8TTSLanguage == roRef.e8TTSLanguage);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgReadMessageAloudError::most_msgfi_tclMsgReadMessageAloudError(const most_msgfi_tclMsgReadMessageAloudError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgReadMessageAloudError& most_msgfi_tclMsgReadMessageAloudError::operator=(const most_msgfi_tclMsgReadMessageAloudError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgReadMessageAloudError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ReadMessageAloudError;
}


most_msgfi_tclMsgReadMessageAloudError::~most_msgfi_tclMsgReadMessageAloudError()
{}

tBool most_msgfi_tclMsgReadMessageAloudError::operator==(const most_msgfi_tclMsgReadMessageAloudError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgReadMessageAloudMethodResult::most_msgfi_tclMsgReadMessageAloudMethodResult(const most_msgfi_tclMsgReadMessageAloudMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackAction = coRef.e8PlaybackAction;
}
most_msgfi_tclMsgReadMessageAloudMethodResult& most_msgfi_tclMsgReadMessageAloudMethodResult::operator=(const most_msgfi_tclMsgReadMessageAloudMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackAction = coRef.e8PlaybackAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgReadMessageAloudMethodResult::most_msgfi_tclMsgReadMessageAloudMethodResult()
:e8PlaybackAction()
 {}

tS32 most_msgfi_tclMsgReadMessageAloudMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ReadMessageAloudMethodResult;
}


most_msgfi_tclMsgReadMessageAloudMethodResult::~most_msgfi_tclMsgReadMessageAloudMethodResult()
{}

tU32 most_msgfi_tclMsgReadMessageAloudMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgReadMessageAloudMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackAction);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgReadMessageAloudMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackAction);
   return oOut;
}

tBool most_msgfi_tclMsgReadMessageAloudMethodResult::operator==(const most_msgfi_tclMsgReadMessageAloudMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackAction == roRef.e8PlaybackAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRecordAudioMessageMethodStart::most_msgfi_tclMsgRecordAudioMessageMethodStart(const most_msgfi_tclMsgRecordAudioMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8RecordMessageAction = coRef.e8RecordMessageAction;
   u8LogicalAVChannel = coRef.u8LogicalAVChannel;
}
most_msgfi_tclMsgRecordAudioMessageMethodStart& most_msgfi_tclMsgRecordAudioMessageMethodStart::operator=(const most_msgfi_tclMsgRecordAudioMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8RecordMessageAction = coRef.e8RecordMessageAction;
   u8LogicalAVChannel = coRef.u8LogicalAVChannel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgRecordAudioMessageMethodStart::most_msgfi_tclMsgRecordAudioMessageMethodStart()
:e8RecordMessageAction()
,u8LogicalAVChannel(0)
 {}

tS32 most_msgfi_tclMsgRecordAudioMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecordAudioMessageMethodStart;
}


most_msgfi_tclMsgRecordAudioMessageMethodStart::~most_msgfi_tclMsgRecordAudioMessageMethodStart()
{}

tU32 most_msgfi_tclMsgRecordAudioMessageMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgRecordAudioMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RecordMessageAction);
   (tVoid) (oIn >> u8LogicalAVChannel);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRecordAudioMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RecordMessageAction);
   (tVoid) (oOut << u8LogicalAVChannel);
   return oOut;
}

tBool most_msgfi_tclMsgRecordAudioMessageMethodStart::operator==(const most_msgfi_tclMsgRecordAudioMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RecordMessageAction == roRef.e8RecordMessageAction);
   bResult = bResult && (u8LogicalAVChannel == roRef.u8LogicalAVChannel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRecordAudioMessageError::most_msgfi_tclMsgRecordAudioMessageError(const most_msgfi_tclMsgRecordAudioMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgRecordAudioMessageError& most_msgfi_tclMsgRecordAudioMessageError::operator=(const most_msgfi_tclMsgRecordAudioMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgRecordAudioMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecordAudioMessageError;
}


most_msgfi_tclMsgRecordAudioMessageError::~most_msgfi_tclMsgRecordAudioMessageError()
{}

tBool most_msgfi_tclMsgRecordAudioMessageError::operator==(const most_msgfi_tclMsgRecordAudioMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRecordAudioMessageMethodResult::most_msgfi_tclMsgRecordAudioMessageMethodResult(const most_msgfi_tclMsgRecordAudioMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16RecordedAudioMessageHandle = coRef.u16RecordedAudioMessageHandle;
}
most_msgfi_tclMsgRecordAudioMessageMethodResult& most_msgfi_tclMsgRecordAudioMessageMethodResult::operator=(const most_msgfi_tclMsgRecordAudioMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16RecordedAudioMessageHandle = coRef.u16RecordedAudioMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgRecordAudioMessageMethodResult::most_msgfi_tclMsgRecordAudioMessageMethodResult()
:u16RecordedAudioMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgRecordAudioMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecordAudioMessageMethodResult;
}


most_msgfi_tclMsgRecordAudioMessageMethodResult::~most_msgfi_tclMsgRecordAudioMessageMethodResult()
{}

tU32 most_msgfi_tclMsgRecordAudioMessageMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgRecordAudioMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16RecordedAudioMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRecordAudioMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16RecordedAudioMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgRecordAudioMessageMethodResult::operator==(const most_msgfi_tclMsgRecordAudioMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16RecordedAudioMessageHandle == roRef.u16RecordedAudioMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgPlaybackAudioMessageMethodStart::most_msgfi_tclMsgPlaybackAudioMessageMethodStart(const most_msgfi_tclMsgPlaybackAudioMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16RecordedAudioMessageHandle = coRef.u16RecordedAudioMessageHandle;
   e8PlaybackAction = coRef.e8PlaybackAction;
}
most_msgfi_tclMsgPlaybackAudioMessageMethodStart& most_msgfi_tclMsgPlaybackAudioMessageMethodStart::operator=(const most_msgfi_tclMsgPlaybackAudioMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16RecordedAudioMessageHandle = coRef.u16RecordedAudioMessageHandle;
   e8PlaybackAction = coRef.e8PlaybackAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgPlaybackAudioMessageMethodStart::most_msgfi_tclMsgPlaybackAudioMessageMethodStart()
:u16RecordedAudioMessageHandle(0)
,e8PlaybackAction()
 {}

tS32 most_msgfi_tclMsgPlaybackAudioMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PlaybackAudioMessageMethodStart;
}


most_msgfi_tclMsgPlaybackAudioMessageMethodStart::~most_msgfi_tclMsgPlaybackAudioMessageMethodStart()
{}

tU32 most_msgfi_tclMsgPlaybackAudioMessageMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_msgfi_tclMsgPlaybackAudioMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16RecordedAudioMessageHandle);
   (tVoid) (oIn >> e8PlaybackAction);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgPlaybackAudioMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16RecordedAudioMessageHandle);
   (tVoid) (oOut << e8PlaybackAction);
   return oOut;
}

tBool most_msgfi_tclMsgPlaybackAudioMessageMethodStart::operator==(const most_msgfi_tclMsgPlaybackAudioMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16RecordedAudioMessageHandle == roRef.u16RecordedAudioMessageHandle);
   bResult = bResult && (e8PlaybackAction == roRef.e8PlaybackAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgPlaybackAudioMessageError::most_msgfi_tclMsgPlaybackAudioMessageError(const most_msgfi_tclMsgPlaybackAudioMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgPlaybackAudioMessageError& most_msgfi_tclMsgPlaybackAudioMessageError::operator=(const most_msgfi_tclMsgPlaybackAudioMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgPlaybackAudioMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PlaybackAudioMessageError;
}


most_msgfi_tclMsgPlaybackAudioMessageError::~most_msgfi_tclMsgPlaybackAudioMessageError()
{}

tBool most_msgfi_tclMsgPlaybackAudioMessageError::operator==(const most_msgfi_tclMsgPlaybackAudioMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgPlaybackAudioMessageMethodResult::most_msgfi_tclMsgPlaybackAudioMessageMethodResult(const most_msgfi_tclMsgPlaybackAudioMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackState = coRef.e8PlaybackState;
}
most_msgfi_tclMsgPlaybackAudioMessageMethodResult& most_msgfi_tclMsgPlaybackAudioMessageMethodResult::operator=(const most_msgfi_tclMsgPlaybackAudioMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackState = coRef.e8PlaybackState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgPlaybackAudioMessageMethodResult::most_msgfi_tclMsgPlaybackAudioMessageMethodResult()
:e8PlaybackState()
 {}

tS32 most_msgfi_tclMsgPlaybackAudioMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PlaybackAudioMessageMethodResult;
}


most_msgfi_tclMsgPlaybackAudioMessageMethodResult::~most_msgfi_tclMsgPlaybackAudioMessageMethodResult()
{}

tU32 most_msgfi_tclMsgPlaybackAudioMessageMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgPlaybackAudioMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackState);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgPlaybackAudioMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackState);
   return oOut;
}

tBool most_msgfi_tclMsgPlaybackAudioMessageMethodResult::operator==(const most_msgfi_tclMsgPlaybackAudioMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackState == roRef.e8PlaybackState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAddPredefinedMessageMethodStart::most_msgfi_tclMsgAddPredefinedMessageMethodStart(const most_msgfi_tclMsgAddPredefinedMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   sPredefinedMessageText = coRef.sPredefinedMessageText;
}
most_msgfi_tclMsgAddPredefinedMessageMethodStart& most_msgfi_tclMsgAddPredefinedMessageMethodStart::operator=(const most_msgfi_tclMsgAddPredefinedMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPredefinedMessageText = coRef.sPredefinedMessageText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgAddPredefinedMessageMethodStart::vDestroy()
{
   sPredefinedMessageText.vDestroy(); 
}

most_msgfi_tclMsgAddPredefinedMessageMethodStart::most_msgfi_tclMsgAddPredefinedMessageMethodStart()
:sPredefinedMessageText()
 {}

tS32 most_msgfi_tclMsgAddPredefinedMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AddPredefinedMessageMethodStart;
}


most_msgfi_tclMsgAddPredefinedMessageMethodStart::~most_msgfi_tclMsgAddPredefinedMessageMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgAddPredefinedMessageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPredefinedMessageText.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgAddPredefinedMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPredefinedMessageText);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAddPredefinedMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPredefinedMessageText);
   return oOut;
}

tBool most_msgfi_tclMsgAddPredefinedMessageMethodStart::operator==(const most_msgfi_tclMsgAddPredefinedMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPredefinedMessageText == roRef.sPredefinedMessageText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAddPredefinedMessageError::most_msgfi_tclMsgAddPredefinedMessageError(const most_msgfi_tclMsgAddPredefinedMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgAddPredefinedMessageError& most_msgfi_tclMsgAddPredefinedMessageError::operator=(const most_msgfi_tclMsgAddPredefinedMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgAddPredefinedMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AddPredefinedMessageError;
}


most_msgfi_tclMsgAddPredefinedMessageError::~most_msgfi_tclMsgAddPredefinedMessageError()
{}

tBool most_msgfi_tclMsgAddPredefinedMessageError::operator==(const most_msgfi_tclMsgAddPredefinedMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAddPredefinedMessageMethodResult::most_msgfi_tclMsgAddPredefinedMessageMethodResult(const most_msgfi_tclMsgAddPredefinedMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
}
most_msgfi_tclMsgAddPredefinedMessageMethodResult& most_msgfi_tclMsgAddPredefinedMessageMethodResult::operator=(const most_msgfi_tclMsgAddPredefinedMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAddPredefinedMessageMethodResult::most_msgfi_tclMsgAddPredefinedMessageMethodResult()
:u16PredefinedMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgAddPredefinedMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AddPredefinedMessageMethodResult;
}


most_msgfi_tclMsgAddPredefinedMessageMethodResult::~most_msgfi_tclMsgAddPredefinedMessageMethodResult()
{}

tU32 most_msgfi_tclMsgAddPredefinedMessageMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgAddPredefinedMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16PredefinedMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAddPredefinedMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16PredefinedMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgAddPredefinedMessageMethodResult::operator==(const most_msgfi_tclMsgAddPredefinedMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16PredefinedMessageHandle == roRef.u16PredefinedMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDeletePredefinedMessageMethodStart::most_msgfi_tclMsgDeletePredefinedMessageMethodStart(const most_msgfi_tclMsgDeletePredefinedMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
}
most_msgfi_tclMsgDeletePredefinedMessageMethodStart& most_msgfi_tclMsgDeletePredefinedMessageMethodStart::operator=(const most_msgfi_tclMsgDeletePredefinedMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgDeletePredefinedMessageMethodStart::most_msgfi_tclMsgDeletePredefinedMessageMethodStart()
:u16PredefinedMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgDeletePredefinedMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_DeletePredefinedMessageMethodStart;
}


most_msgfi_tclMsgDeletePredefinedMessageMethodStart::~most_msgfi_tclMsgDeletePredefinedMessageMethodStart()
{}

tU32 most_msgfi_tclMsgDeletePredefinedMessageMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgDeletePredefinedMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16PredefinedMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgDeletePredefinedMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16PredefinedMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgDeletePredefinedMessageMethodStart::operator==(const most_msgfi_tclMsgDeletePredefinedMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16PredefinedMessageHandle == roRef.u16PredefinedMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDeletePredefinedMessageError::most_msgfi_tclMsgDeletePredefinedMessageError(const most_msgfi_tclMsgDeletePredefinedMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgDeletePredefinedMessageError& most_msgfi_tclMsgDeletePredefinedMessageError::operator=(const most_msgfi_tclMsgDeletePredefinedMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgDeletePredefinedMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_DeletePredefinedMessageError;
}


most_msgfi_tclMsgDeletePredefinedMessageError::~most_msgfi_tclMsgDeletePredefinedMessageError()
{}

tBool most_msgfi_tclMsgDeletePredefinedMessageError::operator==(const most_msgfi_tclMsgDeletePredefinedMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgDeletePredefinedMessageMethodResult::most_msgfi_tclMsgDeletePredefinedMessageMethodResult(const most_msgfi_tclMsgDeletePredefinedMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
}
most_msgfi_tclMsgDeletePredefinedMessageMethodResult& most_msgfi_tclMsgDeletePredefinedMessageMethodResult::operator=(const most_msgfi_tclMsgDeletePredefinedMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgDeletePredefinedMessageMethodResult::most_msgfi_tclMsgDeletePredefinedMessageMethodResult()
:u16PredefinedMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgDeletePredefinedMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_DeletePredefinedMessageMethodResult;
}


most_msgfi_tclMsgDeletePredefinedMessageMethodResult::~most_msgfi_tclMsgDeletePredefinedMessageMethodResult()
{}

tU32 most_msgfi_tclMsgDeletePredefinedMessageMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgDeletePredefinedMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16PredefinedMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgDeletePredefinedMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16PredefinedMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgDeletePredefinedMessageMethodResult::operator==(const most_msgfi_tclMsgDeletePredefinedMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16PredefinedMessageHandle == roRef.u16PredefinedMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetConversationMessagesMethodStart::most_msgfi_tclMsgGetConversationMessagesMethodStart(const most_msgfi_tclMsgGetConversationMessagesMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMessageHandle = coRef.oMessageHandle;
}
most_msgfi_tclMsgGetConversationMessagesMethodStart& most_msgfi_tclMsgGetConversationMessagesMethodStart::operator=(const most_msgfi_tclMsgGetConversationMessagesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oMessageHandle = coRef.oMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetConversationMessagesMethodStart::most_msgfi_tclMsgGetConversationMessagesMethodStart()
:oMessageHandle()
 {}

tS32 most_msgfi_tclMsgGetConversationMessagesMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetConversationMessagesMethodStart;
}


most_msgfi_tclMsgGetConversationMessagesMethodStart::~most_msgfi_tclMsgGetConversationMessagesMethodStart()
{}

tU32 most_msgfi_tclMsgGetConversationMessagesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetConversationMessagesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetConversationMessagesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgGetConversationMessagesMethodStart::operator==(const most_msgfi_tclMsgGetConversationMessagesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetConversationMessagesError::most_msgfi_tclMsgGetConversationMessagesError(const most_msgfi_tclMsgGetConversationMessagesError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgGetConversationMessagesError& most_msgfi_tclMsgGetConversationMessagesError::operator=(const most_msgfi_tclMsgGetConversationMessagesError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgGetConversationMessagesError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetConversationMessagesError;
}


most_msgfi_tclMsgGetConversationMessagesError::~most_msgfi_tclMsgGetConversationMessagesError()
{}

tBool most_msgfi_tclMsgGetConversationMessagesError::operator==(const most_msgfi_tclMsgGetConversationMessagesError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetConversationMessagesMethodResult::most_msgfi_tclMsgGetConversationMessagesMethodResult(const most_msgfi_tclMsgGetConversationMessagesMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oConversationMessages = coRef.oConversationMessages;
}
most_msgfi_tclMsgGetConversationMessagesMethodResult& most_msgfi_tclMsgGetConversationMessagesMethodResult::operator=(const most_msgfi_tclMsgGetConversationMessagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oConversationMessages = coRef.oConversationMessages;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetConversationMessagesMethodResult::most_msgfi_tclMsgGetConversationMessagesMethodResult()
:oConversationMessages()
 {}

tS32 most_msgfi_tclMsgGetConversationMessagesMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetConversationMessagesMethodResult;
}


most_msgfi_tclMsgGetConversationMessagesMethodResult::~most_msgfi_tclMsgGetConversationMessagesMethodResult()
{}

tU32 most_msgfi_tclMsgGetConversationMessagesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oConversationMessages.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetConversationMessagesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oConversationMessages);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetConversationMessagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oConversationMessages);
   return oOut;
}

tBool most_msgfi_tclMsgGetConversationMessagesMethodResult::operator==(const most_msgfi_tclMsgGetConversationMessagesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oConversationMessages == roRef.oConversationMessages);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSendMessageMethodStart::most_msgfi_tclMsgSendMessageMethodStart(const most_msgfi_tclMsgSendMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   e8FolderType = coRef.e8FolderType;
}
most_msgfi_tclMsgSendMessageMethodStart& most_msgfi_tclMsgSendMessageMethodStart::operator=(const most_msgfi_tclMsgSendMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   e8FolderType = coRef.e8FolderType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSendMessageMethodStart::most_msgfi_tclMsgSendMessageMethodStart()
:u8CreateMessageHandle(0)
,e8FolderType()
 {}

tS32 most_msgfi_tclMsgSendMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SendMessageMethodStart;
}


most_msgfi_tclMsgSendMessageMethodStart::~most_msgfi_tclMsgSendMessageMethodStart()
{}

tU32 most_msgfi_tclMsgSendMessageMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgSendMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8CreateMessageHandle);
   (tVoid) (oIn >> e8FolderType);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSendMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8CreateMessageHandle);
   (tVoid) (oOut << e8FolderType);
   return oOut;
}

tBool most_msgfi_tclMsgSendMessageMethodStart::operator==(const most_msgfi_tclMsgSendMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8CreateMessageHandle == roRef.u8CreateMessageHandle);
   bResult = bResult && (e8FolderType == roRef.e8FolderType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSendMessageError::most_msgfi_tclMsgSendMessageError(const most_msgfi_tclMsgSendMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgSendMessageError& most_msgfi_tclMsgSendMessageError::operator=(const most_msgfi_tclMsgSendMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgSendMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SendMessageError;
}


most_msgfi_tclMsgSendMessageError::~most_msgfi_tclMsgSendMessageError()
{}

tBool most_msgfi_tclMsgSendMessageError::operator==(const most_msgfi_tclMsgSendMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSendMessageMethodResult::most_msgfi_tclMsgSendMessageMethodResult(const most_msgfi_tclMsgSendMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8SentMessageStatus = coRef.e8SentMessageStatus;
   oMessageHandle = coRef.oMessageHandle;
}
most_msgfi_tclMsgSendMessageMethodResult& most_msgfi_tclMsgSendMessageMethodResult::operator=(const most_msgfi_tclMsgSendMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8SentMessageStatus = coRef.e8SentMessageStatus;
   oMessageHandle = coRef.oMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSendMessageMethodResult::most_msgfi_tclMsgSendMessageMethodResult()
:e8SentMessageStatus()
,oMessageHandle()
 {}

tS32 most_msgfi_tclMsgSendMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SendMessageMethodResult;
}


most_msgfi_tclMsgSendMessageMethodResult::~most_msgfi_tclMsgSendMessageMethodResult()
{}

tU32 most_msgfi_tclMsgSendMessageMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgSendMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SentMessageStatus);
   (tVoid) (oIn >> oMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSendMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SentMessageStatus);
   (tVoid) (oOut << oMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgSendMessageMethodResult::operator==(const most_msgfi_tclMsgSendMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SentMessageStatus == roRef.e8SentMessageStatus);
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgProvideMessageHeaderMethodStart::most_msgfi_tclMsgProvideMessageHeaderMethodStart(const most_msgfi_tclMsgProvideMessageHeaderMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   sSubject = coRef.sSubject;
   oAddressField = coRef.oAddressField;
}
most_msgfi_tclMsgProvideMessageHeaderMethodStart& most_msgfi_tclMsgProvideMessageHeaderMethodStart::operator=(const most_msgfi_tclMsgProvideMessageHeaderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   sSubject = coRef.sSubject;
   oAddressField = coRef.oAddressField;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgProvideMessageHeaderMethodStart::vDestroy()
{
   sSubject.vDestroy(); 
}

most_msgfi_tclMsgProvideMessageHeaderMethodStart::most_msgfi_tclMsgProvideMessageHeaderMethodStart()
:u8CreateMessageHandle(0)
,sSubject()
,oAddressField()
 {}

tS32 most_msgfi_tclMsgProvideMessageHeaderMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ProvideMessageHeaderMethodStart;
}


most_msgfi_tclMsgProvideMessageHeaderMethodStart::~most_msgfi_tclMsgProvideMessageHeaderMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgProvideMessageHeaderMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sSubject.u32GetSize(u16MajorVersion);
   u32DynamicSize += oAddressField.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgProvideMessageHeaderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8CreateMessageHandle);
   (tVoid) (oIn >> sSubject);
   (tVoid) (oIn >> oAddressField);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgProvideMessageHeaderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8CreateMessageHandle);
   (tVoid) (oOut << sSubject);
   (tVoid) (oOut << oAddressField);
   return oOut;
}

tBool most_msgfi_tclMsgProvideMessageHeaderMethodStart::operator==(const most_msgfi_tclMsgProvideMessageHeaderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8CreateMessageHandle == roRef.u8CreateMessageHandle);
   bResult = bResult && (sSubject == roRef.sSubject);
   bResult = bResult && (oAddressField == roRef.oAddressField);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgProvideMessageHeaderError::most_msgfi_tclMsgProvideMessageHeaderError(const most_msgfi_tclMsgProvideMessageHeaderError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgProvideMessageHeaderError& most_msgfi_tclMsgProvideMessageHeaderError::operator=(const most_msgfi_tclMsgProvideMessageHeaderError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgProvideMessageHeaderError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ProvideMessageHeaderError;
}


most_msgfi_tclMsgProvideMessageHeaderError::~most_msgfi_tclMsgProvideMessageHeaderError()
{}

tBool most_msgfi_tclMsgProvideMessageHeaderError::operator==(const most_msgfi_tclMsgProvideMessageHeaderError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgProvideMessageHeaderMethodResult::most_msgfi_tclMsgProvideMessageHeaderMethodResult(const most_msgfi_tclMsgProvideMessageHeaderMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
}
most_msgfi_tclMsgProvideMessageHeaderMethodResult& most_msgfi_tclMsgProvideMessageHeaderMethodResult::operator=(const most_msgfi_tclMsgProvideMessageHeaderMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgProvideMessageHeaderMethodResult::most_msgfi_tclMsgProvideMessageHeaderMethodResult()
:u8CreateMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgProvideMessageHeaderMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ProvideMessageHeaderMethodResult;
}


most_msgfi_tclMsgProvideMessageHeaderMethodResult::~most_msgfi_tclMsgProvideMessageHeaderMethodResult()
{}

tU32 most_msgfi_tclMsgProvideMessageHeaderMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgProvideMessageHeaderMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8CreateMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgProvideMessageHeaderMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8CreateMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgProvideMessageHeaderMethodResult::operator==(const most_msgfi_tclMsgProvideMessageHeaderMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8CreateMessageHandle == roRef.u8CreateMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgProvideMessageBodyMethodStart::most_msgfi_tclMsgProvideMessageBodyMethodStart(const most_msgfi_tclMsgProvideMessageBodyMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   u16RecordedAudioMessageHandle = coRef.u16RecordedAudioMessageHandle;
   oAttachmentHandleStream = coRef.oAttachmentHandleStream;
   u16NumMessageBodyTextElements = coRef.u16NumMessageBodyTextElements;
   oMessageBodyText = coRef.oMessageBodyText;
}
most_msgfi_tclMsgProvideMessageBodyMethodStart& most_msgfi_tclMsgProvideMessageBodyMethodStart::operator=(const most_msgfi_tclMsgProvideMessageBodyMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   u16RecordedAudioMessageHandle = coRef.u16RecordedAudioMessageHandle;
   oAttachmentHandleStream = coRef.oAttachmentHandleStream;
   u16NumMessageBodyTextElements = coRef.u16NumMessageBodyTextElements;
   oMessageBodyText = coRef.oMessageBodyText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgProvideMessageBodyMethodStart::vDestroy()
{
}

most_msgfi_tclMsgProvideMessageBodyMethodStart::most_msgfi_tclMsgProvideMessageBodyMethodStart()
:u8CreateMessageHandle(0)
,u16RecordedAudioMessageHandle(0)
,oAttachmentHandleStream()
,u16NumMessageBodyTextElements(0)
,oMessageBodyText()
 {}

tS32 most_msgfi_tclMsgProvideMessageBodyMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ProvideMessageBodyMethodStart;
}


most_msgfi_tclMsgProvideMessageBodyMethodStart::~most_msgfi_tclMsgProvideMessageBodyMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgProvideMessageBodyMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oAttachmentHandleStream.u32GetSize(u16MajorVersion);
   u32DynamicSize += oMessageBodyText.u32GetSize(u16MajorVersion);
   return 5 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgProvideMessageBodyMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8CreateMessageHandle);
   (tVoid) (oIn >> u16RecordedAudioMessageHandle);
   (tVoid) (oIn >> oAttachmentHandleStream);
   (tVoid) (oIn >> u16NumMessageBodyTextElements);
   (tVoid) (oIn >> oMessageBodyText);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgProvideMessageBodyMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8CreateMessageHandle);
   (tVoid) (oOut << u16RecordedAudioMessageHandle);
   (tVoid) (oOut << oAttachmentHandleStream);
   (tVoid) (oOut << u16NumMessageBodyTextElements);
   (tVoid) (oOut << oMessageBodyText);
   return oOut;
}

tBool most_msgfi_tclMsgProvideMessageBodyMethodStart::operator==(const most_msgfi_tclMsgProvideMessageBodyMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8CreateMessageHandle == roRef.u8CreateMessageHandle);
   bResult = bResult && (u16RecordedAudioMessageHandle == roRef.u16RecordedAudioMessageHandle);
   bResult = bResult && (oAttachmentHandleStream == roRef.oAttachmentHandleStream);
   bResult = bResult && (u16NumMessageBodyTextElements == roRef.u16NumMessageBodyTextElements);
   bResult = bResult && (oMessageBodyText == roRef.oMessageBodyText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgProvideMessageBodyError::most_msgfi_tclMsgProvideMessageBodyError(const most_msgfi_tclMsgProvideMessageBodyError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgProvideMessageBodyError& most_msgfi_tclMsgProvideMessageBodyError::operator=(const most_msgfi_tclMsgProvideMessageBodyError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgProvideMessageBodyError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ProvideMessageBodyError;
}


most_msgfi_tclMsgProvideMessageBodyError::~most_msgfi_tclMsgProvideMessageBodyError()
{}

tBool most_msgfi_tclMsgProvideMessageBodyError::operator==(const most_msgfi_tclMsgProvideMessageBodyError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgProvideMessageBodyMethodResult::most_msgfi_tclMsgProvideMessageBodyMethodResult(const most_msgfi_tclMsgProvideMessageBodyMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
}
most_msgfi_tclMsgProvideMessageBodyMethodResult& most_msgfi_tclMsgProvideMessageBodyMethodResult::operator=(const most_msgfi_tclMsgProvideMessageBodyMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgProvideMessageBodyMethodResult::most_msgfi_tclMsgProvideMessageBodyMethodResult()
:u8CreateMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgProvideMessageBodyMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ProvideMessageBodyMethodResult;
}


most_msgfi_tclMsgProvideMessageBodyMethodResult::~most_msgfi_tclMsgProvideMessageBodyMethodResult()
{}

tU32 most_msgfi_tclMsgProvideMessageBodyMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgProvideMessageBodyMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8CreateMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgProvideMessageBodyMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8CreateMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgProvideMessageBodyMethodResult::operator==(const most_msgfi_tclMsgProvideMessageBodyMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8CreateMessageHandle == roRef.u8CreateMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetMsgBodyActionElementMethodStart::most_msgfi_tclMsgGetMsgBodyActionElementMethodStart(const most_msgfi_tclMsgGetMsgBodyActionElementMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8MsgBodyActionElementTag = coRef.u8MsgBodyActionElementTag;
}
most_msgfi_tclMsgGetMsgBodyActionElementMethodStart& most_msgfi_tclMsgGetMsgBodyActionElementMethodStart::operator=(const most_msgfi_tclMsgGetMsgBodyActionElementMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8MsgBodyActionElementTag = coRef.u8MsgBodyActionElementTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetMsgBodyActionElementMethodStart::most_msgfi_tclMsgGetMsgBodyActionElementMethodStart()
:u8MsgBodyActionElementTag(0)
 {}

tS32 most_msgfi_tclMsgGetMsgBodyActionElementMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetMsgBodyActionElementMethodStart;
}


most_msgfi_tclMsgGetMsgBodyActionElementMethodStart::~most_msgfi_tclMsgGetMsgBodyActionElementMethodStart()
{}

tU32 most_msgfi_tclMsgGetMsgBodyActionElementMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgGetMsgBodyActionElementMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8MsgBodyActionElementTag);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetMsgBodyActionElementMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8MsgBodyActionElementTag);
   return oOut;
}

tBool most_msgfi_tclMsgGetMsgBodyActionElementMethodStart::operator==(const most_msgfi_tclMsgGetMsgBodyActionElementMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8MsgBodyActionElementTag == roRef.u8MsgBodyActionElementTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetMsgBodyActionElementError::most_msgfi_tclMsgGetMsgBodyActionElementError(const most_msgfi_tclMsgGetMsgBodyActionElementError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgGetMsgBodyActionElementError& most_msgfi_tclMsgGetMsgBodyActionElementError::operator=(const most_msgfi_tclMsgGetMsgBodyActionElementError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgGetMsgBodyActionElementError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetMsgBodyActionElementError;
}


most_msgfi_tclMsgGetMsgBodyActionElementError::~most_msgfi_tclMsgGetMsgBodyActionElementError()
{}

tBool most_msgfi_tclMsgGetMsgBodyActionElementError::operator==(const most_msgfi_tclMsgGetMsgBodyActionElementError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::most_msgfi_tclMsgGetMsgBodyActionElementMethodResult(const most_msgfi_tclMsgGetMsgBodyActionElementMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8ActionElementType = coRef.e8ActionElementType;
   sPhoneNumber = coRef.sPhoneNumber;
   sEmailAddress = coRef.sEmailAddress;
   sAddress = coRef.sAddress;
}
most_msgfi_tclMsgGetMsgBodyActionElementMethodResult& most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::operator=(const most_msgfi_tclMsgGetMsgBodyActionElementMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ActionElementType = coRef.e8ActionElementType;
   sPhoneNumber = coRef.sPhoneNumber;
   sEmailAddress = coRef.sEmailAddress;
   sAddress = coRef.sAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::vDestroy()
{
   sPhoneNumber.vDestroy(); 
   sEmailAddress.vDestroy(); 
   sAddress.vDestroy(); 
}

most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::most_msgfi_tclMsgGetMsgBodyActionElementMethodResult()
:e8ActionElementType()
,sPhoneNumber()
,sEmailAddress()
,sAddress()
 {}

tS32 most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetMsgBodyActionElementMethodResult;
}


most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::~most_msgfi_tclMsgGetMsgBodyActionElementMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPhoneNumber.u32GetSize(u16MajorVersion);
   u32DynamicSize += sEmailAddress.u32GetSize(u16MajorVersion);
   u32DynamicSize += sAddress.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ActionElementType);
   (tVoid) (oIn >> sPhoneNumber);
   (tVoid) (oIn >> sEmailAddress);
   (tVoid) (oIn >> sAddress);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ActionElementType);
   (tVoid) (oOut << sPhoneNumber);
   (tVoid) (oOut << sEmailAddress);
   (tVoid) (oOut << sAddress);
   return oOut;
}

tBool most_msgfi_tclMsgGetMsgBodyActionElementMethodResult::operator==(const most_msgfi_tclMsgGetMsgBodyActionElementMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ActionElementType == roRef.e8ActionElementType);
   bResult = bResult && (sPhoneNumber == roRef.sPhoneNumber);
   bResult = bResult && (sEmailAddress == roRef.sEmailAddress);
   bResult = bResult && (sAddress == roRef.sAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetImageAttachmentInfoMethodStart::most_msgfi_tclMsgGetImageAttachmentInfoMethodStart(const most_msgfi_tclMsgGetImageAttachmentInfoMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16AttachmentHandle = coRef.u16AttachmentHandle;
}
most_msgfi_tclMsgGetImageAttachmentInfoMethodStart& most_msgfi_tclMsgGetImageAttachmentInfoMethodStart::operator=(const most_msgfi_tclMsgGetImageAttachmentInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16AttachmentHandle = coRef.u16AttachmentHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetImageAttachmentInfoMethodStart::most_msgfi_tclMsgGetImageAttachmentInfoMethodStart()
:u16AttachmentHandle(0)
 {}

tS32 most_msgfi_tclMsgGetImageAttachmentInfoMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetImageAttachmentInfoMethodStart;
}


most_msgfi_tclMsgGetImageAttachmentInfoMethodStart::~most_msgfi_tclMsgGetImageAttachmentInfoMethodStart()
{}

tU32 most_msgfi_tclMsgGetImageAttachmentInfoMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgGetImageAttachmentInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16AttachmentHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetImageAttachmentInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16AttachmentHandle);
   return oOut;
}

tBool most_msgfi_tclMsgGetImageAttachmentInfoMethodStart::operator==(const most_msgfi_tclMsgGetImageAttachmentInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16AttachmentHandle == roRef.u16AttachmentHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetImageAttachmentInfoError::most_msgfi_tclMsgGetImageAttachmentInfoError(const most_msgfi_tclMsgGetImageAttachmentInfoError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgGetImageAttachmentInfoError& most_msgfi_tclMsgGetImageAttachmentInfoError::operator=(const most_msgfi_tclMsgGetImageAttachmentInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgGetImageAttachmentInfoError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetImageAttachmentInfoError;
}


most_msgfi_tclMsgGetImageAttachmentInfoError::~most_msgfi_tclMsgGetImageAttachmentInfoError()
{}

tBool most_msgfi_tclMsgGetImageAttachmentInfoError::operator==(const most_msgfi_tclMsgGetImageAttachmentInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::most_msgfi_tclMsgGetImageAttachmentInfoMethodResult(const most_msgfi_tclMsgGetImageAttachmentInfoMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32ImageSize = coRef.u32ImageSize;
}
most_msgfi_tclMsgGetImageAttachmentInfoMethodResult& most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::operator=(const most_msgfi_tclMsgGetImageAttachmentInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sMIMEImageSubtype = coRef.sMIMEImageSubtype;
   u32ImageSize = coRef.u32ImageSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::vDestroy()
{
   sMIMEImageSubtype.vDestroy(); 
}

most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::most_msgfi_tclMsgGetImageAttachmentInfoMethodResult()
:sMIMEImageSubtype()
,u32ImageSize(0)
 {}

tS32 most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetImageAttachmentInfoMethodResult;
}


most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::~most_msgfi_tclMsgGetImageAttachmentInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sMIMEImageSubtype.u32GetSize(u16MajorVersion);
   return 4 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sMIMEImageSubtype);
   (tVoid) (oIn >> u32ImageSize);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sMIMEImageSubtype);
   (tVoid) (oOut << u32ImageSize);
   return oOut;
}

tBool most_msgfi_tclMsgGetImageAttachmentInfoMethodResult::operator==(const most_msgfi_tclMsgGetImageAttachmentInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sMIMEImageSubtype == roRef.sMIMEImageSubtype);
   bResult = bResult && (u32ImageSize == roRef.u32ImageSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgCreateMessageMethodStart::most_msgfi_tclMsgCreateMessageMethodStart(const most_msgfi_tclMsgCreateMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   oMessageHandle = coRef.oMessageHandle;
   e8MessageType = coRef.e8MessageType;
   e8CreateMessageType = coRef.e8CreateMessageType;
}
most_msgfi_tclMsgCreateMessageMethodStart& most_msgfi_tclMsgCreateMessageMethodStart::operator=(const most_msgfi_tclMsgCreateMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   oMessageHandle = coRef.oMessageHandle;
   e8MessageType = coRef.e8MessageType;
   e8CreateMessageType = coRef.e8CreateMessageType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgCreateMessageMethodStart::most_msgfi_tclMsgCreateMessageMethodStart()
:u8CreateMessageHandle(0)
,oMessageHandle()
,e8MessageType()
,e8CreateMessageType()
 {}

tS32 most_msgfi_tclMsgCreateMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_CreateMessageMethodStart;
}


most_msgfi_tclMsgCreateMessageMethodStart::~most_msgfi_tclMsgCreateMessageMethodStart()
{}

tU32 most_msgfi_tclMsgCreateMessageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 3 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgCreateMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8CreateMessageHandle);
   (tVoid) (oIn >> oMessageHandle);
   (tVoid) (oIn >> e8MessageType);
   (tVoid) (oIn >> e8CreateMessageType);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgCreateMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8CreateMessageHandle);
   (tVoid) (oOut << oMessageHandle);
   (tVoid) (oOut << e8MessageType);
   (tVoid) (oOut << e8CreateMessageType);
   return oOut;
}

tBool most_msgfi_tclMsgCreateMessageMethodStart::operator==(const most_msgfi_tclMsgCreateMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8CreateMessageHandle == roRef.u8CreateMessageHandle);
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   bResult = bResult && (e8MessageType == roRef.e8MessageType);
   bResult = bResult && (e8CreateMessageType == roRef.e8CreateMessageType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgCreateMessageError::most_msgfi_tclMsgCreateMessageError(const most_msgfi_tclMsgCreateMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgCreateMessageError& most_msgfi_tclMsgCreateMessageError::operator=(const most_msgfi_tclMsgCreateMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgCreateMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_CreateMessageError;
}


most_msgfi_tclMsgCreateMessageError::~most_msgfi_tclMsgCreateMessageError()
{}

tBool most_msgfi_tclMsgCreateMessageError::operator==(const most_msgfi_tclMsgCreateMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgCreateMessageMethodResult::most_msgfi_tclMsgCreateMessageMethodResult(const most_msgfi_tclMsgCreateMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
}
most_msgfi_tclMsgCreateMessageMethodResult& most_msgfi_tclMsgCreateMessageMethodResult::operator=(const most_msgfi_tclMsgCreateMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8CreateMessageHandle = coRef.u8CreateMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgCreateMessageMethodResult::most_msgfi_tclMsgCreateMessageMethodResult()
:u8CreateMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgCreateMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_CreateMessageMethodResult;
}


most_msgfi_tclMsgCreateMessageMethodResult::~most_msgfi_tclMsgCreateMessageMethodResult()
{}

tU32 most_msgfi_tclMsgCreateMessageMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgCreateMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8CreateMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgCreateMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8CreateMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgCreateMessageMethodResult::operator==(const most_msgfi_tclMsgCreateMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8CreateMessageHandle == roRef.u8CreateMessageHandle);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgClearUserMessagingInfoMethodStart::most_msgfi_tclMsgClearUserMessagingInfoMethodStart()
 {}

tS32 most_msgfi_tclMsgClearUserMessagingInfoMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ClearUserMessagingInfoMethodStart;
}


most_msgfi_tclMsgClearUserMessagingInfoMethodStart::~most_msgfi_tclMsgClearUserMessagingInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgClearUserMessagingInfoError::most_msgfi_tclMsgClearUserMessagingInfoError(const most_msgfi_tclMsgClearUserMessagingInfoError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgClearUserMessagingInfoError& most_msgfi_tclMsgClearUserMessagingInfoError::operator=(const most_msgfi_tclMsgClearUserMessagingInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgClearUserMessagingInfoError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ClearUserMessagingInfoError;
}


most_msgfi_tclMsgClearUserMessagingInfoError::~most_msgfi_tclMsgClearUserMessagingInfoError()
{}

tBool most_msgfi_tclMsgClearUserMessagingInfoError::operator==(const most_msgfi_tclMsgClearUserMessagingInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgClearUserMessagingInfoMethodResult::most_msgfi_tclMsgClearUserMessagingInfoMethodResult()
 {}

tS32 most_msgfi_tclMsgClearUserMessagingInfoMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ClearUserMessagingInfoMethodResult;
}


most_msgfi_tclMsgClearUserMessagingInfoMethodResult::~most_msgfi_tclMsgClearUserMessagingInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgConnectMapProfileMethodStart::most_msgfi_tclMsgConnectMapProfileMethodStart(const most_msgfi_tclMsgConnectMapProfileMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
   RetryCount = coRef.RetryCount;
}
most_msgfi_tclMsgConnectMapProfileMethodStart& most_msgfi_tclMsgConnectMapProfileMethodStart::operator=(const most_msgfi_tclMsgConnectMapProfileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   RetryCount = coRef.RetryCount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgConnectMapProfileMethodStart::most_msgfi_tclMsgConnectMapProfileMethodStart()
:DeviceHandle(0)
,RetryCount(0)
 {}

tS32 most_msgfi_tclMsgConnectMapProfileMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ConnectMapProfileMethodStart;
}


most_msgfi_tclMsgConnectMapProfileMethodStart::~most_msgfi_tclMsgConnectMapProfileMethodStart()
{}

tU32 most_msgfi_tclMsgConnectMapProfileMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgConnectMapProfileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   (tVoid) (oIn >> RetryCount);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgConnectMapProfileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   (tVoid) (oOut << RetryCount);
   return oOut;
}

tBool most_msgfi_tclMsgConnectMapProfileMethodStart::operator==(const most_msgfi_tclMsgConnectMapProfileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   bResult = bResult && (RetryCount == roRef.RetryCount);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgConnectMapProfileError::most_msgfi_tclMsgConnectMapProfileError(const most_msgfi_tclMsgConnectMapProfileError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgConnectMapProfileError& most_msgfi_tclMsgConnectMapProfileError::operator=(const most_msgfi_tclMsgConnectMapProfileError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgConnectMapProfileError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ConnectMapProfileError;
}


most_msgfi_tclMsgConnectMapProfileError::~most_msgfi_tclMsgConnectMapProfileError()
{}

tBool most_msgfi_tclMsgConnectMapProfileError::operator==(const most_msgfi_tclMsgConnectMapProfileError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgConnectMapProfileMethodResult::most_msgfi_tclMsgConnectMapProfileMethodResult(const most_msgfi_tclMsgConnectMapProfileMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   DeviceHandle = coRef.DeviceHandle;
}
most_msgfi_tclMsgConnectMapProfileMethodResult& most_msgfi_tclMsgConnectMapProfileMethodResult::operator=(const most_msgfi_tclMsgConnectMapProfileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceHandle = coRef.DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgConnectMapProfileMethodResult::most_msgfi_tclMsgConnectMapProfileMethodResult()
:DeviceHandle(0)
 {}

tS32 most_msgfi_tclMsgConnectMapProfileMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ConnectMapProfileMethodResult;
}


most_msgfi_tclMsgConnectMapProfileMethodResult::~most_msgfi_tclMsgConnectMapProfileMethodResult()
{}

tU32 most_msgfi_tclMsgConnectMapProfileMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgConnectMapProfileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgConnectMapProfileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceHandle);
   return oOut;
}

tBool most_msgfi_tclMsgConnectMapProfileMethodResult::operator==(const most_msgfi_tclMsgConnectMapProfileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceHandle == roRef.DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgEditPredefinedMessageMethodStart::most_msgfi_tclMsgEditPredefinedMessageMethodStart(const most_msgfi_tclMsgEditPredefinedMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
   sPredefinedMessageText = coRef.sPredefinedMessageText;
   e8PredefinedMessageSubCategory = coRef.e8PredefinedMessageSubCategory;
}
most_msgfi_tclMsgEditPredefinedMessageMethodStart& most_msgfi_tclMsgEditPredefinedMessageMethodStart::operator=(const most_msgfi_tclMsgEditPredefinedMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
   sPredefinedMessageText = coRef.sPredefinedMessageText;
   e8PredefinedMessageSubCategory = coRef.e8PredefinedMessageSubCategory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgEditPredefinedMessageMethodStart::vDestroy()
{
   sPredefinedMessageText.vDestroy(); 
}

most_msgfi_tclMsgEditPredefinedMessageMethodStart::most_msgfi_tclMsgEditPredefinedMessageMethodStart()
:u16PredefinedMessageHandle(0)
,sPredefinedMessageText()
,e8PredefinedMessageSubCategory()
 {}

tS32 most_msgfi_tclMsgEditPredefinedMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_EditPredefinedMessageMethodStart;
}


most_msgfi_tclMsgEditPredefinedMessageMethodStart::~most_msgfi_tclMsgEditPredefinedMessageMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgEditPredefinedMessageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPredefinedMessageText.u32GetSize(u16MajorVersion);
   return 3 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgEditPredefinedMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16PredefinedMessageHandle);
   (tVoid) (oIn >> sPredefinedMessageText);
   (tVoid) (oIn >> e8PredefinedMessageSubCategory);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgEditPredefinedMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16PredefinedMessageHandle);
   (tVoid) (oOut << sPredefinedMessageText);
   (tVoid) (oOut << e8PredefinedMessageSubCategory);
   return oOut;
}

tBool most_msgfi_tclMsgEditPredefinedMessageMethodStart::operator==(const most_msgfi_tclMsgEditPredefinedMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16PredefinedMessageHandle == roRef.u16PredefinedMessageHandle);
   bResult = bResult && (sPredefinedMessageText == roRef.sPredefinedMessageText);
   bResult = bResult && (e8PredefinedMessageSubCategory == roRef.e8PredefinedMessageSubCategory);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgEditPredefinedMessageError::most_msgfi_tclMsgEditPredefinedMessageError(const most_msgfi_tclMsgEditPredefinedMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgEditPredefinedMessageError& most_msgfi_tclMsgEditPredefinedMessageError::operator=(const most_msgfi_tclMsgEditPredefinedMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgEditPredefinedMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_EditPredefinedMessageError;
}


most_msgfi_tclMsgEditPredefinedMessageError::~most_msgfi_tclMsgEditPredefinedMessageError()
{}

tBool most_msgfi_tclMsgEditPredefinedMessageError::operator==(const most_msgfi_tclMsgEditPredefinedMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgEditPredefinedMessageMethodResult::most_msgfi_tclMsgEditPredefinedMessageMethodResult(const most_msgfi_tclMsgEditPredefinedMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
}
most_msgfi_tclMsgEditPredefinedMessageMethodResult& most_msgfi_tclMsgEditPredefinedMessageMethodResult::operator=(const most_msgfi_tclMsgEditPredefinedMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgEditPredefinedMessageMethodResult::most_msgfi_tclMsgEditPredefinedMessageMethodResult()
:u16PredefinedMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgEditPredefinedMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_EditPredefinedMessageMethodResult;
}


most_msgfi_tclMsgEditPredefinedMessageMethodResult::~most_msgfi_tclMsgEditPredefinedMessageMethodResult()
{}

tU32 most_msgfi_tclMsgEditPredefinedMessageMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgEditPredefinedMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16PredefinedMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgEditPredefinedMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16PredefinedMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgEditPredefinedMessageMethodResult::operator==(const most_msgfi_tclMsgEditPredefinedMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16PredefinedMessageHandle == roRef.u16PredefinedMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8PredefinedMessageSubCategory = coRef.e8PredefinedMessageSubCategory;
   sPredefinedMessageText = coRef.sPredefinedMessageText;
}
most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart& most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::operator=(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8PredefinedMessageSubCategory = coRef.e8PredefinedMessageSubCategory;
   sPredefinedMessageText = coRef.sPredefinedMessageText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::vDestroy()
{
   sPredefinedMessageText.vDestroy(); 
}

most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart()
:e8PredefinedMessageSubCategory()
,sPredefinedMessageText()
 {}

tS32 most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AddPredefinedMessageExtendedMethodStart;
}


most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::~most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPredefinedMessageText.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PredefinedMessageSubCategory);
   (tVoid) (oIn >> sPredefinedMessageText);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PredefinedMessageSubCategory);
   (tVoid) (oOut << sPredefinedMessageText);
   return oOut;
}

tBool most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart::operator==(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PredefinedMessageSubCategory == roRef.e8PredefinedMessageSubCategory);
   bResult = bResult && (sPredefinedMessageText == roRef.sPredefinedMessageText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAddPredefinedMessageExtendedError::most_msgfi_tclMsgAddPredefinedMessageExtendedError(const most_msgfi_tclMsgAddPredefinedMessageExtendedError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgAddPredefinedMessageExtendedError& most_msgfi_tclMsgAddPredefinedMessageExtendedError::operator=(const most_msgfi_tclMsgAddPredefinedMessageExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgAddPredefinedMessageExtendedError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AddPredefinedMessageExtendedError;
}


most_msgfi_tclMsgAddPredefinedMessageExtendedError::~most_msgfi_tclMsgAddPredefinedMessageExtendedError()
{}

tBool most_msgfi_tclMsgAddPredefinedMessageExtendedError::operator==(const most_msgfi_tclMsgAddPredefinedMessageExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult::most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
}
most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult& most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult::operator=(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult::most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult()
:u16PredefinedMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AddPredefinedMessageExtendedMethodResult;
}


most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult::~most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult()
{}

tU32 most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16PredefinedMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16PredefinedMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult::operator==(const most_msgfi_tclMsgAddPredefinedMessageExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16PredefinedMessageHandle == roRef.u16PredefinedMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::most_msgfi_tclMsgReadMessageAloudExtendedMethodStart(const most_msgfi_tclMsgReadMessageAloudExtendedMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackAction = coRef.e8PlaybackAction;
   sReadAloudContent = coRef.sReadAloudContent;
}
most_msgfi_tclMsgReadMessageAloudExtendedMethodStart& most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::operator=(const most_msgfi_tclMsgReadMessageAloudExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackAction = coRef.e8PlaybackAction;
   sReadAloudContent = coRef.sReadAloudContent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::vDestroy()
{
   sReadAloudContent.vDestroy(); 
}

most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::most_msgfi_tclMsgReadMessageAloudExtendedMethodStart()
:e8PlaybackAction()
,sReadAloudContent()
 {}

tS32 most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ReadMessageAloudExtendedMethodStart;
}


most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::~most_msgfi_tclMsgReadMessageAloudExtendedMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sReadAloudContent.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackAction);
   (tVoid) (oIn >> sReadAloudContent);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackAction);
   (tVoid) (oOut << sReadAloudContent);
   return oOut;
}

tBool most_msgfi_tclMsgReadMessageAloudExtendedMethodStart::operator==(const most_msgfi_tclMsgReadMessageAloudExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackAction == roRef.e8PlaybackAction);
   bResult = bResult && (sReadAloudContent == roRef.sReadAloudContent);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgReadMessageAloudExtendedError::most_msgfi_tclMsgReadMessageAloudExtendedError(const most_msgfi_tclMsgReadMessageAloudExtendedError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgReadMessageAloudExtendedError& most_msgfi_tclMsgReadMessageAloudExtendedError::operator=(const most_msgfi_tclMsgReadMessageAloudExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgReadMessageAloudExtendedError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ReadMessageAloudExtendedError;
}


most_msgfi_tclMsgReadMessageAloudExtendedError::~most_msgfi_tclMsgReadMessageAloudExtendedError()
{}

tBool most_msgfi_tclMsgReadMessageAloudExtendedError::operator==(const most_msgfi_tclMsgReadMessageAloudExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgReadMessageAloudExtendedMethodResult::most_msgfi_tclMsgReadMessageAloudExtendedMethodResult(const most_msgfi_tclMsgReadMessageAloudExtendedMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackAction = coRef.e8PlaybackAction;
}
most_msgfi_tclMsgReadMessageAloudExtendedMethodResult& most_msgfi_tclMsgReadMessageAloudExtendedMethodResult::operator=(const most_msgfi_tclMsgReadMessageAloudExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackAction = coRef.e8PlaybackAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgReadMessageAloudExtendedMethodResult::most_msgfi_tclMsgReadMessageAloudExtendedMethodResult()
:e8PlaybackAction()
 {}

tS32 most_msgfi_tclMsgReadMessageAloudExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_ReadMessageAloudExtendedMethodResult;
}


most_msgfi_tclMsgReadMessageAloudExtendedMethodResult::~most_msgfi_tclMsgReadMessageAloudExtendedMethodResult()
{}

tU32 most_msgfi_tclMsgReadMessageAloudExtendedMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgReadMessageAloudExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackAction);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgReadMessageAloudExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackAction);
   return oOut;
}

tBool most_msgfi_tclMsgReadMessageAloudExtendedMethodResult::operator==(const most_msgfi_tclMsgReadMessageAloudExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackAction == roRef.e8PlaybackAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestSliceConversationListMethodStart::most_msgfi_tclMsgRequestSliceConversationListMethodStart(const most_msgfi_tclMsgRequestSliceConversationListMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u32WindowSize = coRef.u32WindowSize;
}
most_msgfi_tclMsgRequestSliceConversationListMethodStart& most_msgfi_tclMsgRequestSliceConversationListMethodStart::operator=(const most_msgfi_tclMsgRequestSliceConversationListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   u32WindowStart = coRef.u32WindowStart;
   u32WindowSize = coRef.u32WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgRequestSliceConversationListMethodStart::most_msgfi_tclMsgRequestSliceConversationListMethodStart()
:u16ListHandle(0)
,u32WindowStart(0)
,u32WindowSize(0)
 {}

tS32 most_msgfi_tclMsgRequestSliceConversationListMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestSliceConversationListMethodStart;
}


most_msgfi_tclMsgRequestSliceConversationListMethodStart::~most_msgfi_tclMsgRequestSliceConversationListMethodStart()
{}

tU32 most_msgfi_tclMsgRequestSliceConversationListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 10;
}

fi_tclInContext& most_msgfi_tclMsgRequestSliceConversationListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u32WindowSize);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRequestSliceConversationListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u32WindowSize);
   return oOut;
}

tBool most_msgfi_tclMsgRequestSliceConversationListMethodStart::operator==(const most_msgfi_tclMsgRequestSliceConversationListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u32WindowSize == roRef.u32WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestSliceConversationListError::most_msgfi_tclMsgRequestSliceConversationListError(const most_msgfi_tclMsgRequestSliceConversationListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgRequestSliceConversationListError& most_msgfi_tclMsgRequestSliceConversationListError::operator=(const most_msgfi_tclMsgRequestSliceConversationListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgRequestSliceConversationListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestSliceConversationListError;
}


most_msgfi_tclMsgRequestSliceConversationListError::~most_msgfi_tclMsgRequestSliceConversationListError()
{}

tBool most_msgfi_tclMsgRequestSliceConversationListError::operator==(const most_msgfi_tclMsgRequestSliceConversationListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRequestSliceConversationListMethodResult::most_msgfi_tclMsgRequestSliceConversationListMethodResult(const most_msgfi_tclMsgRequestSliceConversationListMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oConversationListSliceResult = coRef.oConversationListSliceResult;
}
most_msgfi_tclMsgRequestSliceConversationListMethodResult& most_msgfi_tclMsgRequestSliceConversationListMethodResult::operator=(const most_msgfi_tclMsgRequestSliceConversationListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oConversationListSliceResult = coRef.oConversationListSliceResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgRequestSliceConversationListMethodResult::vDestroy()
{
}

most_msgfi_tclMsgRequestSliceConversationListMethodResult::most_msgfi_tclMsgRequestSliceConversationListMethodResult()
:oConversationListSliceResult()
 {}

tS32 most_msgfi_tclMsgRequestSliceConversationListMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RequestSliceConversationListMethodResult;
}


most_msgfi_tclMsgRequestSliceConversationListMethodResult::~most_msgfi_tclMsgRequestSliceConversationListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgRequestSliceConversationListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oConversationListSliceResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgRequestSliceConversationListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oConversationListSliceResult);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRequestSliceConversationListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oConversationListSliceResult);
   return oOut;
}

tBool most_msgfi_tclMsgRequestSliceConversationListMethodResult::operator==(const most_msgfi_tclMsgRequestSliceConversationListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oConversationListSliceResult == roRef.oConversationListSliceResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetSliceConversationDetailsMethodStart::most_msgfi_tclMsgGetSliceConversationDetailsMethodStart(const most_msgfi_tclMsgGetSliceConversationDetailsMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oConversationHandle = coRef.oConversationHandle;
   u32WindowStart = coRef.u32WindowStart;
   u32WindowSize = coRef.u32WindowSize;
}
most_msgfi_tclMsgGetSliceConversationDetailsMethodStart& most_msgfi_tclMsgGetSliceConversationDetailsMethodStart::operator=(const most_msgfi_tclMsgGetSliceConversationDetailsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oConversationHandle = coRef.oConversationHandle;
   u32WindowStart = coRef.u32WindowStart;
   u32WindowSize = coRef.u32WindowSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgGetSliceConversationDetailsMethodStart::most_msgfi_tclMsgGetSliceConversationDetailsMethodStart()
:oConversationHandle()
,u32WindowStart(0)
,u32WindowSize(0)
 {}

tS32 most_msgfi_tclMsgGetSliceConversationDetailsMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetSliceConversationDetailsMethodStart;
}


most_msgfi_tclMsgGetSliceConversationDetailsMethodStart::~most_msgfi_tclMsgGetSliceConversationDetailsMethodStart()
{}

tU32 most_msgfi_tclMsgGetSliceConversationDetailsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oConversationHandle.u32GetSize(u16MajorVersion);
   return 8 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetSliceConversationDetailsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oConversationHandle);
   (tVoid) (oIn >> u32WindowStart);
   (tVoid) (oIn >> u32WindowSize);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetSliceConversationDetailsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oConversationHandle);
   (tVoid) (oOut << u32WindowStart);
   (tVoid) (oOut << u32WindowSize);
   return oOut;
}

tBool most_msgfi_tclMsgGetSliceConversationDetailsMethodStart::operator==(const most_msgfi_tclMsgGetSliceConversationDetailsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oConversationHandle == roRef.oConversationHandle);
   bResult = bResult && (u32WindowStart == roRef.u32WindowStart);
   bResult = bResult && (u32WindowSize == roRef.u32WindowSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetSliceConversationDetailsError::most_msgfi_tclMsgGetSliceConversationDetailsError(const most_msgfi_tclMsgGetSliceConversationDetailsError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgGetSliceConversationDetailsError& most_msgfi_tclMsgGetSliceConversationDetailsError::operator=(const most_msgfi_tclMsgGetSliceConversationDetailsError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgGetSliceConversationDetailsError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetSliceConversationDetailsError;
}


most_msgfi_tclMsgGetSliceConversationDetailsError::~most_msgfi_tclMsgGetSliceConversationDetailsError()
{}

tBool most_msgfi_tclMsgGetSliceConversationDetailsError::operator==(const most_msgfi_tclMsgGetSliceConversationDetailsError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::most_msgfi_tclMsgGetSliceConversationDetailsMethodResult(const most_msgfi_tclMsgGetSliceConversationDetailsMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oConversationDetailList = coRef.oConversationDetailList;
}
most_msgfi_tclMsgGetSliceConversationDetailsMethodResult& most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::operator=(const most_msgfi_tclMsgGetSliceConversationDetailsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oConversationDetailList = coRef.oConversationDetailList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::vDestroy()
{
}

most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::most_msgfi_tclMsgGetSliceConversationDetailsMethodResult()
:oConversationDetailList()
 {}

tS32 most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_GetSliceConversationDetailsMethodResult;
}


most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::~most_msgfi_tclMsgGetSliceConversationDetailsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oConversationDetailList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oConversationDetailList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oConversationDetailList);
   return oOut;
}

tBool most_msgfi_tclMsgGetSliceConversationDetailsMethodResult::operator==(const most_msgfi_tclMsgGetSliceConversationDetailsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oConversationDetailList == roRef.oConversationDetailList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSwitchMapOnOffMethodStart::most_msgfi_tclMsgSwitchMapOnOffMethodStart(const most_msgfi_tclMsgSwitchMapOnOffMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   bOnOffState = coRef.bOnOffState;
}
most_msgfi_tclMsgSwitchMapOnOffMethodStart& most_msgfi_tclMsgSwitchMapOnOffMethodStart::operator=(const most_msgfi_tclMsgSwitchMapOnOffMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   bOnOffState = coRef.bOnOffState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSwitchMapOnOffMethodStart::most_msgfi_tclMsgSwitchMapOnOffMethodStart()
:u8DeviceHandle(0)
,bOnOffState(0)
 {}

tS32 most_msgfi_tclMsgSwitchMapOnOffMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SwitchMapOnOffMethodStart;
}


most_msgfi_tclMsgSwitchMapOnOffMethodStart::~most_msgfi_tclMsgSwitchMapOnOffMethodStart()
{}

tU32 most_msgfi_tclMsgSwitchMapOnOffMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgSwitchMapOnOffMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> bOnOffState);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSwitchMapOnOffMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << bOnOffState);
   return oOut;
}

tBool most_msgfi_tclMsgSwitchMapOnOffMethodStart::operator==(const most_msgfi_tclMsgSwitchMapOnOffMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (bOnOffState == roRef.bOnOffState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSwitchMapOnOffError::most_msgfi_tclMsgSwitchMapOnOffError(const most_msgfi_tclMsgSwitchMapOnOffError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgSwitchMapOnOffError& most_msgfi_tclMsgSwitchMapOnOffError::operator=(const most_msgfi_tclMsgSwitchMapOnOffError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgSwitchMapOnOffError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SwitchMapOnOffError;
}


most_msgfi_tclMsgSwitchMapOnOffError::~most_msgfi_tclMsgSwitchMapOnOffError()
{}

tBool most_msgfi_tclMsgSwitchMapOnOffError::operator==(const most_msgfi_tclMsgSwitchMapOnOffError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSwitchMapOnOffMethodResult::most_msgfi_tclMsgSwitchMapOnOffMethodResult(const most_msgfi_tclMsgSwitchMapOnOffMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   bOnOffState = coRef.bOnOffState;
}
most_msgfi_tclMsgSwitchMapOnOffMethodResult& most_msgfi_tclMsgSwitchMapOnOffMethodResult::operator=(const most_msgfi_tclMsgSwitchMapOnOffMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   bOnOffState = coRef.bOnOffState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSwitchMapOnOffMethodResult::most_msgfi_tclMsgSwitchMapOnOffMethodResult()
:u8DeviceHandle(0)
,bOnOffState(0)
 {}

tS32 most_msgfi_tclMsgSwitchMapOnOffMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SwitchMapOnOffMethodResult;
}


most_msgfi_tclMsgSwitchMapOnOffMethodResult::~most_msgfi_tclMsgSwitchMapOnOffMethodResult()
{}

tU32 most_msgfi_tclMsgSwitchMapOnOffMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgSwitchMapOnOffMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> bOnOffState);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSwitchMapOnOffMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << bOnOffState);
   return oOut;
}

tBool most_msgfi_tclMsgSwitchMapOnOffMethodResult::operator==(const most_msgfi_tclMsgSwitchMapOnOffMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (bOnOffState == roRef.bOnOffState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAddCustomMessageMethodStart::most_msgfi_tclMsgAddCustomMessageMethodStart(const most_msgfi_tclMsgAddCustomMessageMethodStart& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8PredefinedMessageSubCategory = coRef.e8PredefinedMessageSubCategory;
   sPredefinedMessageText = coRef.sPredefinedMessageText;
}
most_msgfi_tclMsgAddCustomMessageMethodStart& most_msgfi_tclMsgAddCustomMessageMethodStart::operator=(const most_msgfi_tclMsgAddCustomMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8PredefinedMessageSubCategory = coRef.e8PredefinedMessageSubCategory;
   sPredefinedMessageText = coRef.sPredefinedMessageText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgAddCustomMessageMethodStart::vDestroy()
{
   sPredefinedMessageText.vDestroy(); 
}

most_msgfi_tclMsgAddCustomMessageMethodStart::most_msgfi_tclMsgAddCustomMessageMethodStart()
:u8DeviceHandle(0)
,e8PredefinedMessageSubCategory()
,sPredefinedMessageText()
 {}

tS32 most_msgfi_tclMsgAddCustomMessageMethodStart::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AddCustomMessageMethodStart;
}


most_msgfi_tclMsgAddCustomMessageMethodStart::~most_msgfi_tclMsgAddCustomMessageMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgAddCustomMessageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPredefinedMessageText.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgAddCustomMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> e8PredefinedMessageSubCategory);
   (tVoid) (oIn >> sPredefinedMessageText);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAddCustomMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << e8PredefinedMessageSubCategory);
   (tVoid) (oOut << sPredefinedMessageText);
   return oOut;
}

tBool most_msgfi_tclMsgAddCustomMessageMethodStart::operator==(const most_msgfi_tclMsgAddCustomMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (e8PredefinedMessageSubCategory == roRef.e8PredefinedMessageSubCategory);
   bResult = bResult && (sPredefinedMessageText == roRef.sPredefinedMessageText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAddCustomMessageError::most_msgfi_tclMsgAddCustomMessageError(const most_msgfi_tclMsgAddCustomMessageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgAddCustomMessageError& most_msgfi_tclMsgAddCustomMessageError::operator=(const most_msgfi_tclMsgAddCustomMessageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgAddCustomMessageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AddCustomMessageError;
}


most_msgfi_tclMsgAddCustomMessageError::~most_msgfi_tclMsgAddCustomMessageError()
{}

tBool most_msgfi_tclMsgAddCustomMessageError::operator==(const most_msgfi_tclMsgAddCustomMessageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAddCustomMessageMethodResult::most_msgfi_tclMsgAddCustomMessageMethodResult(const most_msgfi_tclMsgAddCustomMessageMethodResult& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
}
most_msgfi_tclMsgAddCustomMessageMethodResult& most_msgfi_tclMsgAddCustomMessageMethodResult::operator=(const most_msgfi_tclMsgAddCustomMessageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16PredefinedMessageHandle = coRef.u16PredefinedMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAddCustomMessageMethodResult::most_msgfi_tclMsgAddCustomMessageMethodResult()
:u8DeviceHandle(0)
,u16PredefinedMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgAddCustomMessageMethodResult::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AddCustomMessageMethodResult;
}


most_msgfi_tclMsgAddCustomMessageMethodResult::~most_msgfi_tclMsgAddCustomMessageMethodResult()
{}

tU32 most_msgfi_tclMsgAddCustomMessageMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_msgfi_tclMsgAddCustomMessageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u16PredefinedMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAddCustomMessageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u16PredefinedMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgAddCustomMessageMethodResult::operator==(const most_msgfi_tclMsgAddCustomMessageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u16PredefinedMessageHandle == roRef.u16PredefinedMessageHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSourceInfoGet::most_msgfi_tclMsgSourceInfoGet(const most_msgfi_tclMsgSourceInfoGet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
}
most_msgfi_tclMsgSourceInfoGet& most_msgfi_tclMsgSourceInfoGet::operator=(const most_msgfi_tclMsgSourceInfoGet& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSourceInfoGet::most_msgfi_tclMsgSourceInfoGet()
:u8SourceNr(0)
 {}

tS32 most_msgfi_tclMsgSourceInfoGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceInfoGet;
}


most_msgfi_tclMsgSourceInfoGet::~most_msgfi_tclMsgSourceInfoGet()
{}

tU32 most_msgfi_tclMsgSourceInfoGet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgSourceInfoGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSourceInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   return oOut;
}

tBool most_msgfi_tclMsgSourceInfoGet::operator==(const most_msgfi_tclMsgSourceInfoGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSourceInfoError::most_msgfi_tclMsgSourceInfoError(const most_msgfi_tclMsgSourceInfoError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgSourceInfoError& most_msgfi_tclMsgSourceInfoError::operator=(const most_msgfi_tclMsgSourceInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgSourceInfoError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceInfoError;
}


most_msgfi_tclMsgSourceInfoError::~most_msgfi_tclMsgSourceInfoError()
{}

tBool most_msgfi_tclMsgSourceInfoError::operator==(const most_msgfi_tclMsgSourceInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSourceInfoStatus::most_msgfi_tclMsgSourceInfoStatus(const most_msgfi_tclMsgSourceInfoStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   e8TransmissionClass = coRef.e8TransmissionClass;
   e8ContentProtection = coRef.e8ContentProtection;
   e8ContentType = coRef.e8ContentType;
   oContentDescription = coRef.oContentDescription;
   oTransmissionParameter = coRef.oTransmissionParameter;
}
most_msgfi_tclMsgSourceInfoStatus& most_msgfi_tclMsgSourceInfoStatus::operator=(const most_msgfi_tclMsgSourceInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   u8SourceNr = coRef.u8SourceNr;
   u16BlockWidth = coRef.u16BlockWidth;
   u16ConnectionLabel = coRef.u16ConnectionLabel;
   e8TransmissionClass = coRef.e8TransmissionClass;
   e8ContentProtection = coRef.e8ContentProtection;
   e8ContentType = coRef.e8ContentType;
   oContentDescription = coRef.oContentDescription;
   oTransmissionParameter = coRef.oTransmissionParameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSourceInfoStatus::most_msgfi_tclMsgSourceInfoStatus()
:u8SourceNr(0)
,u16BlockWidth(0)
,u16ConnectionLabel(0)
,e8TransmissionClass()
,e8ContentProtection()
,e8ContentType()
,oContentDescription()
,oTransmissionParameter()
 {}

tS32 most_msgfi_tclMsgSourceInfoStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceInfoStatus;
}


most_msgfi_tclMsgSourceInfoStatus::~most_msgfi_tclMsgSourceInfoStatus()
{}

tU32 most_msgfi_tclMsgSourceInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oContentDescription.u32GetSize(u16MajorVersion);
   u32DynamicSize += oTransmissionParameter.u32GetSize(u16MajorVersion);
   return 8 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgSourceInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SourceNr);
   (tVoid) (oIn >> u16BlockWidth);
   (tVoid) (oIn >> u16ConnectionLabel);
   (tVoid) (oIn >> e8TransmissionClass);
   (tVoid) (oIn >> e8ContentProtection);
   (tVoid) (oIn >> e8ContentType);
   (tVoid) (oIn >> oContentDescription);
   (tVoid) (oIn >> oTransmissionParameter);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSourceInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SourceNr);
   (tVoid) (oOut << u16BlockWidth);
   (tVoid) (oOut << u16ConnectionLabel);
   (tVoid) (oOut << e8TransmissionClass);
   (tVoid) (oOut << e8ContentProtection);
   (tVoid) (oOut << e8ContentType);
   (tVoid) (oOut << oContentDescription);
   (tVoid) (oOut << oTransmissionParameter);
   return oOut;
}

tBool most_msgfi_tclMsgSourceInfoStatus::operator==(const most_msgfi_tclMsgSourceInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SourceNr == roRef.u8SourceNr);
   bResult = bResult && (u16BlockWidth == roRef.u16BlockWidth);
   bResult = bResult && (u16ConnectionLabel == roRef.u16ConnectionLabel);
   bResult = bResult && (e8TransmissionClass == roRef.e8TransmissionClass);
   bResult = bResult && (e8ContentProtection == roRef.e8ContentProtection);
   bResult = bResult && (e8ContentType == roRef.e8ContentType);
   bResult = bResult && (oContentDescription == roRef.oContentDescription);
   bResult = bResult && (oTransmissionParameter == roRef.oTransmissionParameter);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgSourceAvailableUpReg::most_msgfi_tclMsgSourceAvailableUpReg()
 {}

tS32 most_msgfi_tclMsgSourceAvailableUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceAvailableUpReg;
}


most_msgfi_tclMsgSourceAvailableUpReg::~most_msgfi_tclMsgSourceAvailableUpReg()
{}

//=============================================================================

most_msgfi_tclMsgSourceAvailableRelUpReg::most_msgfi_tclMsgSourceAvailableRelUpReg()
 {}

tS32 most_msgfi_tclMsgSourceAvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceAvailableRelUpReg;
}


most_msgfi_tclMsgSourceAvailableRelUpReg::~most_msgfi_tclMsgSourceAvailableRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgSourceAvailableGet::most_msgfi_tclMsgSourceAvailableGet()
 {}

tS32 most_msgfi_tclMsgSourceAvailableGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceAvailableGet;
}


most_msgfi_tclMsgSourceAvailableGet::~most_msgfi_tclMsgSourceAvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSourceAvailableError::most_msgfi_tclMsgSourceAvailableError(const most_msgfi_tclMsgSourceAvailableError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgSourceAvailableError& most_msgfi_tclMsgSourceAvailableError::operator=(const most_msgfi_tclMsgSourceAvailableError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgSourceAvailableError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceAvailableError;
}


most_msgfi_tclMsgSourceAvailableError::~most_msgfi_tclMsgSourceAvailableError()
{}

tBool most_msgfi_tclMsgSourceAvailableError::operator==(const most_msgfi_tclMsgSourceAvailableError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSourceAvailableStatus::most_msgfi_tclMsgSourceAvailableStatus(const most_msgfi_tclMsgSourceAvailableStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bSourceAvailable = coRef.bSourceAvailable;
}
most_msgfi_tclMsgSourceAvailableStatus& most_msgfi_tclMsgSourceAvailableStatus::operator=(const most_msgfi_tclMsgSourceAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   bSourceAvailable = coRef.bSourceAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSourceAvailableStatus::most_msgfi_tclMsgSourceAvailableStatus()
:bSourceAvailable(0)
 {}

tS32 most_msgfi_tclMsgSourceAvailableStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SourceAvailableStatus;
}


most_msgfi_tclMsgSourceAvailableStatus::~most_msgfi_tclMsgSourceAvailableStatus()
{}

tU32 most_msgfi_tclMsgSourceAvailableStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgSourceAvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSourceAvailable);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSourceAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSourceAvailable);
   return oOut;
}

tBool most_msgfi_tclMsgSourceAvailableStatus::operator==(const most_msgfi_tclMsgSourceAvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSourceAvailable == roRef.bSourceAvailable);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgMessageListChangeUpReg::most_msgfi_tclMsgMessageListChangeUpReg()
 {}

tS32 most_msgfi_tclMsgMessageListChangeUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessageListChangeUpReg;
}


most_msgfi_tclMsgMessageListChangeUpReg::~most_msgfi_tclMsgMessageListChangeUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessageListChangeRelUpReg::most_msgfi_tclMsgMessageListChangeRelUpReg()
 {}

tS32 most_msgfi_tclMsgMessageListChangeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessageListChangeRelUpReg;
}


most_msgfi_tclMsgMessageListChangeRelUpReg::~most_msgfi_tclMsgMessageListChangeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessageListChangeStatus::most_msgfi_tclMsgMessageListChangeStatus(const most_msgfi_tclMsgMessageListChangeStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16ListHandle = coRef.u16ListHandle;
   e8ListChangeType = coRef.e8ListChangeType;
   u16ListLength = coRef.u16ListLength;
   u32NumItems = coRef.u32NumItems;
   oChangeItems = coRef.oChangeItems;
}
most_msgfi_tclMsgMessageListChangeStatus& most_msgfi_tclMsgMessageListChangeStatus::operator=(const most_msgfi_tclMsgMessageListChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   u16ListHandle = coRef.u16ListHandle;
   e8ListChangeType = coRef.e8ListChangeType;
   u16ListLength = coRef.u16ListLength;
   u32NumItems = coRef.u32NumItems;
   oChangeItems = coRef.oChangeItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgMessageListChangeStatus::most_msgfi_tclMsgMessageListChangeStatus()
:u16ListHandle(0)
,e8ListChangeType()
,u16ListLength(0)
,u32NumItems(0)
,oChangeItems()
 {}

tS32 most_msgfi_tclMsgMessageListChangeStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessageListChangeStatus;
}


most_msgfi_tclMsgMessageListChangeStatus::~most_msgfi_tclMsgMessageListChangeStatus()
{}

tU32 most_msgfi_tclMsgMessageListChangeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oChangeItems.u32GetSize(u16MajorVersion);
   return 9 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgMessageListChangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ListHandle);
   (tVoid) (oIn >> e8ListChangeType);
   (tVoid) (oIn >> u16ListLength);
   (tVoid) (oIn >> u32NumItems);
   (tVoid) (oIn >> oChangeItems);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMessageListChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ListHandle);
   (tVoid) (oOut << e8ListChangeType);
   (tVoid) (oOut << u16ListLength);
   (tVoid) (oOut << u32NumItems);
   (tVoid) (oOut << oChangeItems);
   return oOut;
}

tBool most_msgfi_tclMsgMessageListChangeStatus::operator==(const most_msgfi_tclMsgMessageListChangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16ListHandle == roRef.u16ListHandle);
   bResult = bResult && (e8ListChangeType == roRef.e8ListChangeType);
   bResult = bResult && (u16ListLength == roRef.u16ListLength);
   bResult = bResult && (u32NumItems == roRef.u32NumItems);
   bResult = bResult && (oChangeItems == roRef.oChangeItems);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgFolderListChangeUpReg::most_msgfi_tclMsgFolderListChangeUpReg()
 {}

tS32 most_msgfi_tclMsgFolderListChangeUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_FolderListChangeUpReg;
}


most_msgfi_tclMsgFolderListChangeUpReg::~most_msgfi_tclMsgFolderListChangeUpReg()
{}

//=============================================================================

most_msgfi_tclMsgFolderListChangeRelUpReg::most_msgfi_tclMsgFolderListChangeRelUpReg()
 {}

tS32 most_msgfi_tclMsgFolderListChangeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_FolderListChangeRelUpReg;
}


most_msgfi_tclMsgFolderListChangeRelUpReg::~most_msgfi_tclMsgFolderListChangeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgFolderListChangeStatus::most_msgfi_tclMsgFolderListChangeStatus(const most_msgfi_tclMsgFolderListChangeStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u32FolderHandle = coRef.u32FolderHandle;
   bFolderStructureChangedFlag = coRef.bFolderStructureChangedFlag;
}
most_msgfi_tclMsgFolderListChangeStatus& most_msgfi_tclMsgFolderListChangeStatus::operator=(const most_msgfi_tclMsgFolderListChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   u32FolderHandle = coRef.u32FolderHandle;
   bFolderStructureChangedFlag = coRef.bFolderStructureChangedFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgFolderListChangeStatus::most_msgfi_tclMsgFolderListChangeStatus()
:u32FolderHandle(0)
,bFolderStructureChangedFlag(0)
 {}

tS32 most_msgfi_tclMsgFolderListChangeStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_FolderListChangeStatus;
}


most_msgfi_tclMsgFolderListChangeStatus::~most_msgfi_tclMsgFolderListChangeStatus()
{}

tU32 most_msgfi_tclMsgFolderListChangeStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_msgfi_tclMsgFolderListChangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32FolderHandle);
   (tVoid) (oIn >> bFolderStructureChangedFlag);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgFolderListChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32FolderHandle);
   (tVoid) (oOut << bFolderStructureChangedFlag);
   return oOut;
}

tBool most_msgfi_tclMsgFolderListChangeStatus::operator==(const most_msgfi_tclMsgFolderListChangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32FolderHandle == roRef.u32FolderHandle);
   bResult = bResult && (bFolderStructureChangedFlag == roRef.bFolderStructureChangedFlag);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgMessagingDeviceConnectionUpReg::most_msgfi_tclMsgMessagingDeviceConnectionUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingDeviceConnectionUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingDeviceConnectionUpReg;
}


most_msgfi_tclMsgMessagingDeviceConnectionUpReg::~most_msgfi_tclMsgMessagingDeviceConnectionUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg::most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingDeviceConnectionRelUpReg;
}


most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg::~most_msgfi_tclMsgMessagingDeviceConnectionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingDeviceConnectionStatus::most_msgfi_tclMsgMessagingDeviceConnectionStatus(const most_msgfi_tclMsgMessagingDeviceConnectionStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   bEmailSupport = coRef.bEmailSupport;
   bSMSSupport = coRef.bSMSSupport;
   bMMSSupport = coRef.bMMSSupport;
   bUpdateInboxSupport = coRef.bUpdateInboxSupport;
   bMessagingMemoryStatus = coRef.bMessagingMemoryStatus;
   oActiveAccount = coRef.oActiveAccount;
}
most_msgfi_tclMsgMessagingDeviceConnectionStatus& most_msgfi_tclMsgMessagingDeviceConnectionStatus::operator=(const most_msgfi_tclMsgMessagingDeviceConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   bEmailSupport = coRef.bEmailSupport;
   bSMSSupport = coRef.bSMSSupport;
   bMMSSupport = coRef.bMMSSupport;
   bUpdateInboxSupport = coRef.bUpdateInboxSupport;
   bMessagingMemoryStatus = coRef.bMessagingMemoryStatus;
   oActiveAccount = coRef.oActiveAccount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgMessagingDeviceConnectionStatus::vDestroy()
{
   oActiveAccount.vDestroy(); 
}

most_msgfi_tclMsgMessagingDeviceConnectionStatus::most_msgfi_tclMsgMessagingDeviceConnectionStatus()
:u8DeviceHandle(0)
,bEmailSupport(0)
,bSMSSupport(0)
,bMMSSupport(0)
,bUpdateInboxSupport(0)
,bMessagingMemoryStatus(0)
,oActiveAccount()
 {}

tS32 most_msgfi_tclMsgMessagingDeviceConnectionStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingDeviceConnectionStatus;
}


most_msgfi_tclMsgMessagingDeviceConnectionStatus::~most_msgfi_tclMsgMessagingDeviceConnectionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgMessagingDeviceConnectionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oActiveAccount.u32GetSize(u16MajorVersion);
   return 6 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgMessagingDeviceConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> bEmailSupport);
   (tVoid) (oIn >> bSMSSupport);
   (tVoid) (oIn >> bMMSSupport);
   (tVoid) (oIn >> bUpdateInboxSupport);
   (tVoid) (oIn >> bMessagingMemoryStatus);
   (tVoid) (oIn >> oActiveAccount);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMessagingDeviceConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << bEmailSupport);
   (tVoid) (oOut << bSMSSupport);
   (tVoid) (oOut << bMMSSupport);
   (tVoid) (oOut << bUpdateInboxSupport);
   (tVoid) (oOut << bMessagingMemoryStatus);
   (tVoid) (oOut << oActiveAccount);
   return oOut;
}

tBool most_msgfi_tclMsgMessagingDeviceConnectionStatus::operator==(const most_msgfi_tclMsgMessagingDeviceConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (bEmailSupport == roRef.bEmailSupport);
   bResult = bResult && (bSMSSupport == roRef.bSMSSupport);
   bResult = bResult && (bMMSSupport == roRef.bMMSSupport);
   bResult = bResult && (bUpdateInboxSupport == roRef.bUpdateInboxSupport);
   bResult = bResult && (bMessagingMemoryStatus == roRef.bMessagingMemoryStatus);
   bResult = bResult && (oActiveAccount == roRef.oActiveAccount);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgUpdateInboxSettingsUpReg::most_msgfi_tclMsgUpdateInboxSettingsUpReg()
 {}

tS32 most_msgfi_tclMsgUpdateInboxSettingsUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsUpReg;
}


most_msgfi_tclMsgUpdateInboxSettingsUpReg::~most_msgfi_tclMsgUpdateInboxSettingsUpReg()
{}

//=============================================================================

most_msgfi_tclMsgUpdateInboxSettingsRelUpReg::most_msgfi_tclMsgUpdateInboxSettingsRelUpReg()
 {}

tS32 most_msgfi_tclMsgUpdateInboxSettingsRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsRelUpReg;
}


most_msgfi_tclMsgUpdateInboxSettingsRelUpReg::~most_msgfi_tclMsgUpdateInboxSettingsRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgUpdateInboxSettingsGet::most_msgfi_tclMsgUpdateInboxSettingsGet()
 {}

tS32 most_msgfi_tclMsgUpdateInboxSettingsGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsGet;
}


most_msgfi_tclMsgUpdateInboxSettingsGet::~most_msgfi_tclMsgUpdateInboxSettingsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgUpdateInboxSettingsPureSet::most_msgfi_tclMsgUpdateInboxSettingsPureSet(const most_msgfi_tclMsgUpdateInboxSettingsPureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bAutoUpdateInboxOnOff = coRef.bAutoUpdateInboxOnOff;
   u32UpdateInboxPeriod = coRef.u32UpdateInboxPeriod;
}
most_msgfi_tclMsgUpdateInboxSettingsPureSet& most_msgfi_tclMsgUpdateInboxSettingsPureSet::operator=(const most_msgfi_tclMsgUpdateInboxSettingsPureSet& coRef)
{
   if (this == &coRef) return *this;
   bAutoUpdateInboxOnOff = coRef.bAutoUpdateInboxOnOff;
   u32UpdateInboxPeriod = coRef.u32UpdateInboxPeriod;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgUpdateInboxSettingsPureSet::most_msgfi_tclMsgUpdateInboxSettingsPureSet()
:bAutoUpdateInboxOnOff(0)
,u32UpdateInboxPeriod(0)
 {}

tS32 most_msgfi_tclMsgUpdateInboxSettingsPureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsPureSet;
}


most_msgfi_tclMsgUpdateInboxSettingsPureSet::~most_msgfi_tclMsgUpdateInboxSettingsPureSet()
{}

tU32 most_msgfi_tclMsgUpdateInboxSettingsPureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_msgfi_tclMsgUpdateInboxSettingsPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAutoUpdateInboxOnOff);
   (tVoid) (oIn >> u32UpdateInboxPeriod);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgUpdateInboxSettingsPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAutoUpdateInboxOnOff);
   (tVoid) (oOut << u32UpdateInboxPeriod);
   return oOut;
}

tBool most_msgfi_tclMsgUpdateInboxSettingsPureSet::operator==(const most_msgfi_tclMsgUpdateInboxSettingsPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAutoUpdateInboxOnOff == roRef.bAutoUpdateInboxOnOff);
   bResult = bResult && (u32UpdateInboxPeriod == roRef.u32UpdateInboxPeriod);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgUpdateInboxSettingsError::most_msgfi_tclMsgUpdateInboxSettingsError(const most_msgfi_tclMsgUpdateInboxSettingsError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgUpdateInboxSettingsError& most_msgfi_tclMsgUpdateInboxSettingsError::operator=(const most_msgfi_tclMsgUpdateInboxSettingsError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgUpdateInboxSettingsError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsError;
}


most_msgfi_tclMsgUpdateInboxSettingsError::~most_msgfi_tclMsgUpdateInboxSettingsError()
{}

tBool most_msgfi_tclMsgUpdateInboxSettingsError::operator==(const most_msgfi_tclMsgUpdateInboxSettingsError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgUpdateInboxSettingsStatus::most_msgfi_tclMsgUpdateInboxSettingsStatus(const most_msgfi_tclMsgUpdateInboxSettingsStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bAutoUpdateInboxOnOff = coRef.bAutoUpdateInboxOnOff;
   u32UpdateInboxPeriod = coRef.u32UpdateInboxPeriod;
}
most_msgfi_tclMsgUpdateInboxSettingsStatus& most_msgfi_tclMsgUpdateInboxSettingsStatus::operator=(const most_msgfi_tclMsgUpdateInboxSettingsStatus& coRef)
{
   if (this == &coRef) return *this;
   bAutoUpdateInboxOnOff = coRef.bAutoUpdateInboxOnOff;
   u32UpdateInboxPeriod = coRef.u32UpdateInboxPeriod;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgUpdateInboxSettingsStatus::most_msgfi_tclMsgUpdateInboxSettingsStatus()
:bAutoUpdateInboxOnOff(0)
,u32UpdateInboxPeriod(0)
 {}

tS32 most_msgfi_tclMsgUpdateInboxSettingsStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_UpdateInboxSettingsStatus;
}


most_msgfi_tclMsgUpdateInboxSettingsStatus::~most_msgfi_tclMsgUpdateInboxSettingsStatus()
{}

tU32 most_msgfi_tclMsgUpdateInboxSettingsStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 5;
}

fi_tclInContext& most_msgfi_tclMsgUpdateInboxSettingsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAutoUpdateInboxOnOff);
   (tVoid) (oIn >> u32UpdateInboxPeriod);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgUpdateInboxSettingsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAutoUpdateInboxOnOff);
   (tVoid) (oOut << u32UpdateInboxPeriod);
   return oOut;
}

tBool most_msgfi_tclMsgUpdateInboxSettingsStatus::operator==(const most_msgfi_tclMsgUpdateInboxSettingsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAutoUpdateInboxOnOff == roRef.bAutoUpdateInboxOnOff);
   bResult = bResult && (u32UpdateInboxPeriod == roRef.u32UpdateInboxPeriod);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg::most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg()
 {}

tS32 most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackStateUpReg;
}


most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg::~most_msgfi_tclMsgAudioAttachmentPlaybackStateUpReg()
{}

//=============================================================================

most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg::most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg()
 {}

tS32 most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackStateRelUpReg;
}


most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg::~most_msgfi_tclMsgAudioAttachmentPlaybackStateRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgAudioAttachmentPlaybackStateGet::most_msgfi_tclMsgAudioAttachmentPlaybackStateGet()
 {}

tS32 most_msgfi_tclMsgAudioAttachmentPlaybackStateGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackStateGet;
}


most_msgfi_tclMsgAudioAttachmentPlaybackStateGet::~most_msgfi_tclMsgAudioAttachmentPlaybackStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAudioAttachmentPlaybackStateError::most_msgfi_tclMsgAudioAttachmentPlaybackStateError(const most_msgfi_tclMsgAudioAttachmentPlaybackStateError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgAudioAttachmentPlaybackStateError& most_msgfi_tclMsgAudioAttachmentPlaybackStateError::operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackStateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgAudioAttachmentPlaybackStateError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackStateError;
}


most_msgfi_tclMsgAudioAttachmentPlaybackStateError::~most_msgfi_tclMsgAudioAttachmentPlaybackStateError()
{}

tBool most_msgfi_tclMsgAudioAttachmentPlaybackStateError::operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackStateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus::most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus(const most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16AttachmentHandle = coRef.u16AttachmentHandle;
   e8PlaybackState = coRef.e8PlaybackState;
}
most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus& most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus::operator=(const most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus& coRef)
{
   if (this == &coRef) return *this;
   u16AttachmentHandle = coRef.u16AttachmentHandle;
   e8PlaybackState = coRef.e8PlaybackState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus::most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus()
:u16AttachmentHandle(0)
,e8PlaybackState()
 {}

tS32 most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioAttachmentPlaybackStateStatus;
}


most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus::~most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus()
{}

tU32 most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16AttachmentHandle);
   (tVoid) (oIn >> e8PlaybackState);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16AttachmentHandle);
   (tVoid) (oOut << e8PlaybackState);
   return oOut;
}

tBool most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus::operator==(const most_msgfi_tclMsgAudioAttachmentPlaybackStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16AttachmentHandle == roRef.u16AttachmentHandle);
   bResult = bResult && (e8PlaybackState == roRef.e8PlaybackState);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgSignatureSettingGet::most_msgfi_tclMsgSignatureSettingGet()
 {}

tS32 most_msgfi_tclMsgSignatureSettingGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingGet;
}


most_msgfi_tclMsgSignatureSettingGet::~most_msgfi_tclMsgSignatureSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSignatureSettingPureSet::most_msgfi_tclMsgSignatureSettingPureSet(const most_msgfi_tclMsgSignatureSettingPureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   sSignatureText = coRef.sSignatureText;
}
most_msgfi_tclMsgSignatureSettingPureSet& most_msgfi_tclMsgSignatureSettingPureSet::operator=(const most_msgfi_tclMsgSignatureSettingPureSet& coRef)
{
   if (this == &coRef) return *this;
   sSignatureText = coRef.sSignatureText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgSignatureSettingPureSet::vDestroy()
{
   sSignatureText.vDestroy(); 
}

most_msgfi_tclMsgSignatureSettingPureSet::most_msgfi_tclMsgSignatureSettingPureSet()
:sSignatureText()
 {}

tS32 most_msgfi_tclMsgSignatureSettingPureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingPureSet;
}


most_msgfi_tclMsgSignatureSettingPureSet::~most_msgfi_tclMsgSignatureSettingPureSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgSignatureSettingPureSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sSignatureText.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgSignatureSettingPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sSignatureText);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSignatureSettingPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sSignatureText);
   return oOut;
}

tBool most_msgfi_tclMsgSignatureSettingPureSet::operator==(const most_msgfi_tclMsgSignatureSettingPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sSignatureText == roRef.sSignatureText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSignatureSettingError::most_msgfi_tclMsgSignatureSettingError(const most_msgfi_tclMsgSignatureSettingError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgSignatureSettingError& most_msgfi_tclMsgSignatureSettingError::operator=(const most_msgfi_tclMsgSignatureSettingError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgSignatureSettingError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingError;
}


most_msgfi_tclMsgSignatureSettingError::~most_msgfi_tclMsgSignatureSettingError()
{}

tBool most_msgfi_tclMsgSignatureSettingError::operator==(const most_msgfi_tclMsgSignatureSettingError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSignatureSettingStatus::most_msgfi_tclMsgSignatureSettingStatus(const most_msgfi_tclMsgSignatureSettingStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   sSignatureText = coRef.sSignatureText;
}
most_msgfi_tclMsgSignatureSettingStatus& most_msgfi_tclMsgSignatureSettingStatus::operator=(const most_msgfi_tclMsgSignatureSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   sSignatureText = coRef.sSignatureText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgSignatureSettingStatus::vDestroy()
{
   sSignatureText.vDestroy(); 
}

most_msgfi_tclMsgSignatureSettingStatus::most_msgfi_tclMsgSignatureSettingStatus()
:sSignatureText()
 {}

tS32 most_msgfi_tclMsgSignatureSettingStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingStatus;
}


most_msgfi_tclMsgSignatureSettingStatus::~most_msgfi_tclMsgSignatureSettingStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgSignatureSettingStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sSignatureText.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgSignatureSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sSignatureText);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSignatureSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sSignatureText);
   return oOut;
}

tBool most_msgfi_tclMsgSignatureSettingStatus::operator==(const most_msgfi_tclMsgSignatureSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sSignatureText == roRef.sSignatureText);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgAudioMessageRecordingStateUpReg::most_msgfi_tclMsgAudioMessageRecordingStateUpReg()
 {}

tS32 most_msgfi_tclMsgAudioMessageRecordingStateUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioMessageRecordingStateUpReg;
}


most_msgfi_tclMsgAudioMessageRecordingStateUpReg::~most_msgfi_tclMsgAudioMessageRecordingStateUpReg()
{}

//=============================================================================

most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg::most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg()
 {}

tS32 most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioMessageRecordingStateRelUpReg;
}


most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg::~most_msgfi_tclMsgAudioMessageRecordingStateRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgAudioMessageRecordingStateGet::most_msgfi_tclMsgAudioMessageRecordingStateGet()
 {}

tS32 most_msgfi_tclMsgAudioMessageRecordingStateGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioMessageRecordingStateGet;
}


most_msgfi_tclMsgAudioMessageRecordingStateGet::~most_msgfi_tclMsgAudioMessageRecordingStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAudioMessageRecordingStateError::most_msgfi_tclMsgAudioMessageRecordingStateError(const most_msgfi_tclMsgAudioMessageRecordingStateError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgAudioMessageRecordingStateError& most_msgfi_tclMsgAudioMessageRecordingStateError::operator=(const most_msgfi_tclMsgAudioMessageRecordingStateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgAudioMessageRecordingStateError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioMessageRecordingStateError;
}


most_msgfi_tclMsgAudioMessageRecordingStateError::~most_msgfi_tclMsgAudioMessageRecordingStateError()
{}

tBool most_msgfi_tclMsgAudioMessageRecordingStateError::operator==(const most_msgfi_tclMsgAudioMessageRecordingStateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAudioMessageRecordingStateStatus::most_msgfi_tclMsgAudioMessageRecordingStateStatus(const most_msgfi_tclMsgAudioMessageRecordingStateStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8RecordMessageState = coRef.e8RecordMessageState;
}
most_msgfi_tclMsgAudioMessageRecordingStateStatus& most_msgfi_tclMsgAudioMessageRecordingStateStatus::operator=(const most_msgfi_tclMsgAudioMessageRecordingStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8RecordMessageState = coRef.e8RecordMessageState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAudioMessageRecordingStateStatus::most_msgfi_tclMsgAudioMessageRecordingStateStatus()
:e8RecordMessageState()
 {}

tS32 most_msgfi_tclMsgAudioMessageRecordingStateStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AudioMessageRecordingStateStatus;
}


most_msgfi_tclMsgAudioMessageRecordingStateStatus::~most_msgfi_tclMsgAudioMessageRecordingStateStatus()
{}

tU32 most_msgfi_tclMsgAudioMessageRecordingStateStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgAudioMessageRecordingStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RecordMessageState);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAudioMessageRecordingStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RecordMessageState);
   return oOut;
}

tBool most_msgfi_tclMsgAudioMessageRecordingStateStatus::operator==(const most_msgfi_tclMsgAudioMessageRecordingStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RecordMessageState == roRef.e8RecordMessageState);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgRecordedAudioMessageInfoUpReg::most_msgfi_tclMsgRecordedAudioMessageInfoUpReg()
 {}

tS32 most_msgfi_tclMsgRecordedAudioMessageInfoUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecordedAudioMessageInfoUpReg;
}


most_msgfi_tclMsgRecordedAudioMessageInfoUpReg::~most_msgfi_tclMsgRecordedAudioMessageInfoUpReg()
{}

//=============================================================================

most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg::most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg()
 {}

tS32 most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecordedAudioMessageInfoRelUpReg;
}


most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg::~most_msgfi_tclMsgRecordedAudioMessageInfoRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgRecordedAudioMessageInfoGet::most_msgfi_tclMsgRecordedAudioMessageInfoGet()
 {}

tS32 most_msgfi_tclMsgRecordedAudioMessageInfoGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecordedAudioMessageInfoGet;
}


most_msgfi_tclMsgRecordedAudioMessageInfoGet::~most_msgfi_tclMsgRecordedAudioMessageInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRecordedAudioMessageInfoError::most_msgfi_tclMsgRecordedAudioMessageInfoError(const most_msgfi_tclMsgRecordedAudioMessageInfoError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgRecordedAudioMessageInfoError& most_msgfi_tclMsgRecordedAudioMessageInfoError::operator=(const most_msgfi_tclMsgRecordedAudioMessageInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgRecordedAudioMessageInfoError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecordedAudioMessageInfoError;
}


most_msgfi_tclMsgRecordedAudioMessageInfoError::~most_msgfi_tclMsgRecordedAudioMessageInfoError()
{}

tBool most_msgfi_tclMsgRecordedAudioMessageInfoError::operator==(const most_msgfi_tclMsgRecordedAudioMessageInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgRecordedAudioMessageInfoStatus::most_msgfi_tclMsgRecordedAudioMessageInfoStatus(const most_msgfi_tclMsgRecordedAudioMessageInfoStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u16RecordedAudioMessageHandle = coRef.u16RecordedAudioMessageHandle;
}
most_msgfi_tclMsgRecordedAudioMessageInfoStatus& most_msgfi_tclMsgRecordedAudioMessageInfoStatus::operator=(const most_msgfi_tclMsgRecordedAudioMessageInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   u16RecordedAudioMessageHandle = coRef.u16RecordedAudioMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgRecordedAudioMessageInfoStatus::most_msgfi_tclMsgRecordedAudioMessageInfoStatus()
:u16RecordedAudioMessageHandle(0)
 {}

tS32 most_msgfi_tclMsgRecordedAudioMessageInfoStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_RecordedAudioMessageInfoStatus;
}


most_msgfi_tclMsgRecordedAudioMessageInfoStatus::~most_msgfi_tclMsgRecordedAudioMessageInfoStatus()
{}

tU32 most_msgfi_tclMsgRecordedAudioMessageInfoStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_msgfi_tclMsgRecordedAudioMessageInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16RecordedAudioMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgRecordedAudioMessageInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16RecordedAudioMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgRecordedAudioMessageInfoStatus::operator==(const most_msgfi_tclMsgRecordedAudioMessageInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16RecordedAudioMessageHandle == roRef.u16RecordedAudioMessageHandle);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgPredefinedMessageListUpReg::most_msgfi_tclMsgPredefinedMessageListUpReg()
 {}

tS32 most_msgfi_tclMsgPredefinedMessageListUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListUpReg;
}


most_msgfi_tclMsgPredefinedMessageListUpReg::~most_msgfi_tclMsgPredefinedMessageListUpReg()
{}

//=============================================================================

most_msgfi_tclMsgPredefinedMessageListRelUpReg::most_msgfi_tclMsgPredefinedMessageListRelUpReg()
 {}

tS32 most_msgfi_tclMsgPredefinedMessageListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListRelUpReg;
}


most_msgfi_tclMsgPredefinedMessageListRelUpReg::~most_msgfi_tclMsgPredefinedMessageListRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgPredefinedMessageListGet::most_msgfi_tclMsgPredefinedMessageListGet()
 {}

tS32 most_msgfi_tclMsgPredefinedMessageListGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListGet;
}


most_msgfi_tclMsgPredefinedMessageListGet::~most_msgfi_tclMsgPredefinedMessageListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgPredefinedMessageListError::most_msgfi_tclMsgPredefinedMessageListError(const most_msgfi_tclMsgPredefinedMessageListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgPredefinedMessageListError& most_msgfi_tclMsgPredefinedMessageListError::operator=(const most_msgfi_tclMsgPredefinedMessageListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgPredefinedMessageListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListError;
}


most_msgfi_tclMsgPredefinedMessageListError::~most_msgfi_tclMsgPredefinedMessageListError()
{}

tBool most_msgfi_tclMsgPredefinedMessageListError::operator==(const most_msgfi_tclMsgPredefinedMessageListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgPredefinedMessageListStatus::most_msgfi_tclMsgPredefinedMessageListStatus(const most_msgfi_tclMsgPredefinedMessageListStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8NumPredefinedMessages = coRef.u8NumPredefinedMessages;
   oPredefinedMessageListResult = coRef.oPredefinedMessageListResult;
}
most_msgfi_tclMsgPredefinedMessageListStatus& most_msgfi_tclMsgPredefinedMessageListStatus::operator=(const most_msgfi_tclMsgPredefinedMessageListStatus& coRef)
{
   if (this == &coRef) return *this;
   u8NumPredefinedMessages = coRef.u8NumPredefinedMessages;
   oPredefinedMessageListResult = coRef.oPredefinedMessageListResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgPredefinedMessageListStatus::vDestroy()
{
}

most_msgfi_tclMsgPredefinedMessageListStatus::most_msgfi_tclMsgPredefinedMessageListStatus()
:u8NumPredefinedMessages(0)
,oPredefinedMessageListResult()
 {}

tS32 most_msgfi_tclMsgPredefinedMessageListStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListStatus;
}


most_msgfi_tclMsgPredefinedMessageListStatus::~most_msgfi_tclMsgPredefinedMessageListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgPredefinedMessageListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oPredefinedMessageListResult.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgPredefinedMessageListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumPredefinedMessages);
   (tVoid) (oIn >> oPredefinedMessageListResult);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgPredefinedMessageListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumPredefinedMessages);
   (tVoid) (oOut << oPredefinedMessageListResult);
   return oOut;
}

tBool most_msgfi_tclMsgPredefinedMessageListStatus::operator==(const most_msgfi_tclMsgPredefinedMessageListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumPredefinedMessages == roRef.u8NumPredefinedMessages);
   bResult = bResult && (oPredefinedMessageListResult == roRef.oPredefinedMessageListResult);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg::most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingAudioPlaybackStateUpReg;
}


most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg::~most_msgfi_tclMsgMessagingAudioPlaybackStateUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg::most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingAudioPlaybackStateRelUpReg;
}


most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg::~most_msgfi_tclMsgMessagingAudioPlaybackStateRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessagingAudioPlaybackStateGet::most_msgfi_tclMsgMessagingAudioPlaybackStateGet()
 {}

tS32 most_msgfi_tclMsgMessagingAudioPlaybackStateGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingAudioPlaybackStateGet;
}


most_msgfi_tclMsgMessagingAudioPlaybackStateGet::~most_msgfi_tclMsgMessagingAudioPlaybackStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingAudioPlaybackStateStatus::most_msgfi_tclMsgMessagingAudioPlaybackStateStatus(const most_msgfi_tclMsgMessagingAudioPlaybackStateStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8PlaybackState = coRef.e8PlaybackState;
}
most_msgfi_tclMsgMessagingAudioPlaybackStateStatus& most_msgfi_tclMsgMessagingAudioPlaybackStateStatus::operator=(const most_msgfi_tclMsgMessagingAudioPlaybackStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8PlaybackState = coRef.e8PlaybackState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgMessagingAudioPlaybackStateStatus::most_msgfi_tclMsgMessagingAudioPlaybackStateStatus()
:e8PlaybackState()
 {}

tS32 most_msgfi_tclMsgMessagingAudioPlaybackStateStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingAudioPlaybackStateStatus;
}


most_msgfi_tclMsgMessagingAudioPlaybackStateStatus::~most_msgfi_tclMsgMessagingAudioPlaybackStateStatus()
{}

tU32 most_msgfi_tclMsgMessagingAudioPlaybackStateStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgMessagingAudioPlaybackStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PlaybackState);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMessagingAudioPlaybackStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PlaybackState);
   return oOut;
}

tBool most_msgfi_tclMsgMessagingAudioPlaybackStateStatus::operator==(const most_msgfi_tclMsgMessagingAudioPlaybackStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PlaybackState == roRef.e8PlaybackState);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgTextAlertEnableUpReg::most_msgfi_tclMsgTextAlertEnableUpReg()
 {}

tS32 most_msgfi_tclMsgTextAlertEnableUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextAlertEnableUpReg;
}


most_msgfi_tclMsgTextAlertEnableUpReg::~most_msgfi_tclMsgTextAlertEnableUpReg()
{}

//=============================================================================

most_msgfi_tclMsgTextAlertEnableRelUpReg::most_msgfi_tclMsgTextAlertEnableRelUpReg()
 {}

tS32 most_msgfi_tclMsgTextAlertEnableRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextAlertEnableRelUpReg;
}


most_msgfi_tclMsgTextAlertEnableRelUpReg::~most_msgfi_tclMsgTextAlertEnableRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgTextAlertEnableGet::most_msgfi_tclMsgTextAlertEnableGet()
 {}

tS32 most_msgfi_tclMsgTextAlertEnableGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextAlertEnableGet;
}


most_msgfi_tclMsgTextAlertEnableGet::~most_msgfi_tclMsgTextAlertEnableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgTextAlertEnablePureSet::most_msgfi_tclMsgTextAlertEnablePureSet(const most_msgfi_tclMsgTextAlertEnablePureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bTextAlertOnOff = coRef.bTextAlertOnOff;
}
most_msgfi_tclMsgTextAlertEnablePureSet& most_msgfi_tclMsgTextAlertEnablePureSet::operator=(const most_msgfi_tclMsgTextAlertEnablePureSet& coRef)
{
   if (this == &coRef) return *this;
   bTextAlertOnOff = coRef.bTextAlertOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgTextAlertEnablePureSet::most_msgfi_tclMsgTextAlertEnablePureSet()
:bTextAlertOnOff(0)
 {}

tS32 most_msgfi_tclMsgTextAlertEnablePureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextAlertEnablePureSet;
}


most_msgfi_tclMsgTextAlertEnablePureSet::~most_msgfi_tclMsgTextAlertEnablePureSet()
{}

tU32 most_msgfi_tclMsgTextAlertEnablePureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgTextAlertEnablePureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bTextAlertOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgTextAlertEnablePureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bTextAlertOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgTextAlertEnablePureSet::operator==(const most_msgfi_tclMsgTextAlertEnablePureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bTextAlertOnOff == roRef.bTextAlertOnOff);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgTextAlertEnableError::most_msgfi_tclMsgTextAlertEnableError(const most_msgfi_tclMsgTextAlertEnableError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgTextAlertEnableError& most_msgfi_tclMsgTextAlertEnableError::operator=(const most_msgfi_tclMsgTextAlertEnableError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgTextAlertEnableError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextAlertEnableError;
}


most_msgfi_tclMsgTextAlertEnableError::~most_msgfi_tclMsgTextAlertEnableError()
{}

tBool most_msgfi_tclMsgTextAlertEnableError::operator==(const most_msgfi_tclMsgTextAlertEnableError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgTextAlertEnableStatus::most_msgfi_tclMsgTextAlertEnableStatus(const most_msgfi_tclMsgTextAlertEnableStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bTextAlertOnOff = coRef.bTextAlertOnOff;
}
most_msgfi_tclMsgTextAlertEnableStatus& most_msgfi_tclMsgTextAlertEnableStatus::operator=(const most_msgfi_tclMsgTextAlertEnableStatus& coRef)
{
   if (this == &coRef) return *this;
   bTextAlertOnOff = coRef.bTextAlertOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgTextAlertEnableStatus::most_msgfi_tclMsgTextAlertEnableStatus()
:bTextAlertOnOff(0)
 {}

tS32 most_msgfi_tclMsgTextAlertEnableStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextAlertEnableStatus;
}


most_msgfi_tclMsgTextAlertEnableStatus::~most_msgfi_tclMsgTextAlertEnableStatus()
{}

tU32 most_msgfi_tclMsgTextAlertEnableStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgTextAlertEnableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bTextAlertOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgTextAlertEnableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bTextAlertOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgTextAlertEnableStatus::operator==(const most_msgfi_tclMsgTextAlertEnableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bTextAlertOnOff == roRef.bTextAlertOnOff);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgEmailAlertEnableUpReg::most_msgfi_tclMsgEmailAlertEnableUpReg()
 {}

tS32 most_msgfi_tclMsgEmailAlertEnableUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_EmailAlertEnableUpReg;
}


most_msgfi_tclMsgEmailAlertEnableUpReg::~most_msgfi_tclMsgEmailAlertEnableUpReg()
{}

//=============================================================================

most_msgfi_tclMsgEmailAlertEnableRelUpReg::most_msgfi_tclMsgEmailAlertEnableRelUpReg()
 {}

tS32 most_msgfi_tclMsgEmailAlertEnableRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_EmailAlertEnableRelUpReg;
}


most_msgfi_tclMsgEmailAlertEnableRelUpReg::~most_msgfi_tclMsgEmailAlertEnableRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgEmailAlertEnableGet::most_msgfi_tclMsgEmailAlertEnableGet()
 {}

tS32 most_msgfi_tclMsgEmailAlertEnableGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_EmailAlertEnableGet;
}


most_msgfi_tclMsgEmailAlertEnableGet::~most_msgfi_tclMsgEmailAlertEnableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgEmailAlertEnablePureSet::most_msgfi_tclMsgEmailAlertEnablePureSet(const most_msgfi_tclMsgEmailAlertEnablePureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bEmailAlertOnOff = coRef.bEmailAlertOnOff;
}
most_msgfi_tclMsgEmailAlertEnablePureSet& most_msgfi_tclMsgEmailAlertEnablePureSet::operator=(const most_msgfi_tclMsgEmailAlertEnablePureSet& coRef)
{
   if (this == &coRef) return *this;
   bEmailAlertOnOff = coRef.bEmailAlertOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgEmailAlertEnablePureSet::most_msgfi_tclMsgEmailAlertEnablePureSet()
:bEmailAlertOnOff(0)
 {}

tS32 most_msgfi_tclMsgEmailAlertEnablePureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_EmailAlertEnablePureSet;
}


most_msgfi_tclMsgEmailAlertEnablePureSet::~most_msgfi_tclMsgEmailAlertEnablePureSet()
{}

tU32 most_msgfi_tclMsgEmailAlertEnablePureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgEmailAlertEnablePureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEmailAlertOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgEmailAlertEnablePureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEmailAlertOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgEmailAlertEnablePureSet::operator==(const most_msgfi_tclMsgEmailAlertEnablePureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEmailAlertOnOff == roRef.bEmailAlertOnOff);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgEmailAlertEnableError::most_msgfi_tclMsgEmailAlertEnableError(const most_msgfi_tclMsgEmailAlertEnableError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgEmailAlertEnableError& most_msgfi_tclMsgEmailAlertEnableError::operator=(const most_msgfi_tclMsgEmailAlertEnableError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgEmailAlertEnableError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_EmailAlertEnableError;
}


most_msgfi_tclMsgEmailAlertEnableError::~most_msgfi_tclMsgEmailAlertEnableError()
{}

tBool most_msgfi_tclMsgEmailAlertEnableError::operator==(const most_msgfi_tclMsgEmailAlertEnableError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgEmailAlertEnableStatus::most_msgfi_tclMsgEmailAlertEnableStatus(const most_msgfi_tclMsgEmailAlertEnableStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bEmailAlertOnOff = coRef.bEmailAlertOnOff;
}
most_msgfi_tclMsgEmailAlertEnableStatus& most_msgfi_tclMsgEmailAlertEnableStatus::operator=(const most_msgfi_tclMsgEmailAlertEnableStatus& coRef)
{
   if (this == &coRef) return *this;
   bEmailAlertOnOff = coRef.bEmailAlertOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgEmailAlertEnableStatus::most_msgfi_tclMsgEmailAlertEnableStatus()
:bEmailAlertOnOff(0)
 {}

tS32 most_msgfi_tclMsgEmailAlertEnableStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_EmailAlertEnableStatus;
}


most_msgfi_tclMsgEmailAlertEnableStatus::~most_msgfi_tclMsgEmailAlertEnableStatus()
{}

tU32 most_msgfi_tclMsgEmailAlertEnableStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgEmailAlertEnableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEmailAlertOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgEmailAlertEnableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEmailAlertOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgEmailAlertEnableStatus::operator==(const most_msgfi_tclMsgEmailAlertEnableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEmailAlertOnOff == roRef.bEmailAlertOnOff);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgSaveSentTextUpReg::most_msgfi_tclMsgSaveSentTextUpReg()
 {}

tS32 most_msgfi_tclMsgSaveSentTextUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentTextUpReg;
}


most_msgfi_tclMsgSaveSentTextUpReg::~most_msgfi_tclMsgSaveSentTextUpReg()
{}

//=============================================================================

most_msgfi_tclMsgSaveSentTextRelUpReg::most_msgfi_tclMsgSaveSentTextRelUpReg()
 {}

tS32 most_msgfi_tclMsgSaveSentTextRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentTextRelUpReg;
}


most_msgfi_tclMsgSaveSentTextRelUpReg::~most_msgfi_tclMsgSaveSentTextRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgSaveSentTextGet::most_msgfi_tclMsgSaveSentTextGet()
 {}

tS32 most_msgfi_tclMsgSaveSentTextGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentTextGet;
}


most_msgfi_tclMsgSaveSentTextGet::~most_msgfi_tclMsgSaveSentTextGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSaveSentTextPureSet::most_msgfi_tclMsgSaveSentTextPureSet(const most_msgfi_tclMsgSaveSentTextPureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bSaveSentTextOnOff = coRef.bSaveSentTextOnOff;
}
most_msgfi_tclMsgSaveSentTextPureSet& most_msgfi_tclMsgSaveSentTextPureSet::operator=(const most_msgfi_tclMsgSaveSentTextPureSet& coRef)
{
   if (this == &coRef) return *this;
   bSaveSentTextOnOff = coRef.bSaveSentTextOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSaveSentTextPureSet::most_msgfi_tclMsgSaveSentTextPureSet()
:bSaveSentTextOnOff(0)
 {}

tS32 most_msgfi_tclMsgSaveSentTextPureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentTextPureSet;
}


most_msgfi_tclMsgSaveSentTextPureSet::~most_msgfi_tclMsgSaveSentTextPureSet()
{}

tU32 most_msgfi_tclMsgSaveSentTextPureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgSaveSentTextPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSaveSentTextOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSaveSentTextPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSaveSentTextOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgSaveSentTextPureSet::operator==(const most_msgfi_tclMsgSaveSentTextPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSaveSentTextOnOff == roRef.bSaveSentTextOnOff);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSaveSentTextError::most_msgfi_tclMsgSaveSentTextError(const most_msgfi_tclMsgSaveSentTextError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgSaveSentTextError& most_msgfi_tclMsgSaveSentTextError::operator=(const most_msgfi_tclMsgSaveSentTextError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgSaveSentTextError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentTextError;
}


most_msgfi_tclMsgSaveSentTextError::~most_msgfi_tclMsgSaveSentTextError()
{}

tBool most_msgfi_tclMsgSaveSentTextError::operator==(const most_msgfi_tclMsgSaveSentTextError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSaveSentTextStatus::most_msgfi_tclMsgSaveSentTextStatus(const most_msgfi_tclMsgSaveSentTextStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bSaveSentTextOnOff = coRef.bSaveSentTextOnOff;
}
most_msgfi_tclMsgSaveSentTextStatus& most_msgfi_tclMsgSaveSentTextStatus::operator=(const most_msgfi_tclMsgSaveSentTextStatus& coRef)
{
   if (this == &coRef) return *this;
   bSaveSentTextOnOff = coRef.bSaveSentTextOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSaveSentTextStatus::most_msgfi_tclMsgSaveSentTextStatus()
:bSaveSentTextOnOff(0)
 {}

tS32 most_msgfi_tclMsgSaveSentTextStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentTextStatus;
}


most_msgfi_tclMsgSaveSentTextStatus::~most_msgfi_tclMsgSaveSentTextStatus()
{}

tU32 most_msgfi_tclMsgSaveSentTextStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgSaveSentTextStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSaveSentTextOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSaveSentTextStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSaveSentTextOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgSaveSentTextStatus::operator==(const most_msgfi_tclMsgSaveSentTextStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSaveSentTextOnOff == roRef.bSaveSentTextOnOff);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgSaveSentEmailUpReg::most_msgfi_tclMsgSaveSentEmailUpReg()
 {}

tS32 most_msgfi_tclMsgSaveSentEmailUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentEmailUpReg;
}


most_msgfi_tclMsgSaveSentEmailUpReg::~most_msgfi_tclMsgSaveSentEmailUpReg()
{}

//=============================================================================

most_msgfi_tclMsgSaveSentEmailRelUpReg::most_msgfi_tclMsgSaveSentEmailRelUpReg()
 {}

tS32 most_msgfi_tclMsgSaveSentEmailRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentEmailRelUpReg;
}


most_msgfi_tclMsgSaveSentEmailRelUpReg::~most_msgfi_tclMsgSaveSentEmailRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgSaveSentEmailGet::most_msgfi_tclMsgSaveSentEmailGet()
 {}

tS32 most_msgfi_tclMsgSaveSentEmailGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentEmailGet;
}


most_msgfi_tclMsgSaveSentEmailGet::~most_msgfi_tclMsgSaveSentEmailGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSaveSentEmailPureSet::most_msgfi_tclMsgSaveSentEmailPureSet(const most_msgfi_tclMsgSaveSentEmailPureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bSaveSentEmailOnOff = coRef.bSaveSentEmailOnOff;
}
most_msgfi_tclMsgSaveSentEmailPureSet& most_msgfi_tclMsgSaveSentEmailPureSet::operator=(const most_msgfi_tclMsgSaveSentEmailPureSet& coRef)
{
   if (this == &coRef) return *this;
   bSaveSentEmailOnOff = coRef.bSaveSentEmailOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSaveSentEmailPureSet::most_msgfi_tclMsgSaveSentEmailPureSet()
:bSaveSentEmailOnOff(0)
 {}

tS32 most_msgfi_tclMsgSaveSentEmailPureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentEmailPureSet;
}


most_msgfi_tclMsgSaveSentEmailPureSet::~most_msgfi_tclMsgSaveSentEmailPureSet()
{}

tU32 most_msgfi_tclMsgSaveSentEmailPureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgSaveSentEmailPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSaveSentEmailOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSaveSentEmailPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSaveSentEmailOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgSaveSentEmailPureSet::operator==(const most_msgfi_tclMsgSaveSentEmailPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSaveSentEmailOnOff == roRef.bSaveSentEmailOnOff);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSaveSentEmailError::most_msgfi_tclMsgSaveSentEmailError(const most_msgfi_tclMsgSaveSentEmailError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgSaveSentEmailError& most_msgfi_tclMsgSaveSentEmailError::operator=(const most_msgfi_tclMsgSaveSentEmailError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgSaveSentEmailError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentEmailError;
}


most_msgfi_tclMsgSaveSentEmailError::~most_msgfi_tclMsgSaveSentEmailError()
{}

tBool most_msgfi_tclMsgSaveSentEmailError::operator==(const most_msgfi_tclMsgSaveSentEmailError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSaveSentEmailStatus::most_msgfi_tclMsgSaveSentEmailStatus(const most_msgfi_tclMsgSaveSentEmailStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   bSaveSentEmailOnOff = coRef.bSaveSentEmailOnOff;
}
most_msgfi_tclMsgSaveSentEmailStatus& most_msgfi_tclMsgSaveSentEmailStatus::operator=(const most_msgfi_tclMsgSaveSentEmailStatus& coRef)
{
   if (this == &coRef) return *this;
   bSaveSentEmailOnOff = coRef.bSaveSentEmailOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgSaveSentEmailStatus::most_msgfi_tclMsgSaveSentEmailStatus()
:bSaveSentEmailOnOff(0)
 {}

tS32 most_msgfi_tclMsgSaveSentEmailStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SaveSentEmailStatus;
}


most_msgfi_tclMsgSaveSentEmailStatus::~most_msgfi_tclMsgSaveSentEmailStatus()
{}

tU32 most_msgfi_tclMsgSaveSentEmailStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgSaveSentEmailStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSaveSentEmailOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSaveSentEmailStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSaveSentEmailOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgSaveSentEmailStatus::operator==(const most_msgfi_tclMsgSaveSentEmailStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSaveSentEmailOnOff == roRef.bSaveSentEmailOnOff);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgMapDeviceCapabilitiesUpReg::most_msgfi_tclMsgMapDeviceCapabilitiesUpReg()
 {}

tS32 most_msgfi_tclMsgMapDeviceCapabilitiesUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesUpReg;
}


most_msgfi_tclMsgMapDeviceCapabilitiesUpReg::~most_msgfi_tclMsgMapDeviceCapabilitiesUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg::most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg()
 {}

tS32 most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesRelUpReg;
}


most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg::~most_msgfi_tclMsgMapDeviceCapabilitiesRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMapDeviceCapabilitiesGet::most_msgfi_tclMsgMapDeviceCapabilitiesGet()
 {}

tS32 most_msgfi_tclMsgMapDeviceCapabilitiesGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesGet;
}


most_msgfi_tclMsgMapDeviceCapabilitiesGet::~most_msgfi_tclMsgMapDeviceCapabilitiesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMapDeviceCapabilitiesStatus::most_msgfi_tclMsgMapDeviceCapabilitiesStatus(const most_msgfi_tclMsgMapDeviceCapabilitiesStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16SupportedMessageTypes = coRef.u16SupportedMessageTypes;
   u16SupportedMapFeatures = coRef.u16SupportedMapFeatures;
   e8MapConnectionState = coRef.e8MapConnectionState;
   oActiveAccount = coRef.oActiveAccount;
}
most_msgfi_tclMsgMapDeviceCapabilitiesStatus& most_msgfi_tclMsgMapDeviceCapabilitiesStatus::operator=(const most_msgfi_tclMsgMapDeviceCapabilitiesStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16SupportedMessageTypes = coRef.u16SupportedMessageTypes;
   u16SupportedMapFeatures = coRef.u16SupportedMapFeatures;
   e8MapConnectionState = coRef.e8MapConnectionState;
   oActiveAccount = coRef.oActiveAccount;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgMapDeviceCapabilitiesStatus::vDestroy()
{
   oActiveAccount.vDestroy(); 
}

most_msgfi_tclMsgMapDeviceCapabilitiesStatus::most_msgfi_tclMsgMapDeviceCapabilitiesStatus()
:u8DeviceHandle(0)
,u16SupportedMessageTypes(0)
,u16SupportedMapFeatures(0)
,e8MapConnectionState()
,oActiveAccount()
 {}

tS32 most_msgfi_tclMsgMapDeviceCapabilitiesStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesStatus;
}


most_msgfi_tclMsgMapDeviceCapabilitiesStatus::~most_msgfi_tclMsgMapDeviceCapabilitiesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgMapDeviceCapabilitiesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oActiveAccount.u32GetSize(u16MajorVersion);
   return 6 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgMapDeviceCapabilitiesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u16SupportedMessageTypes);
   (tVoid) (oIn >> u16SupportedMapFeatures);
   (tVoid) (oIn >> e8MapConnectionState);
   (tVoid) (oIn >> oActiveAccount);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMapDeviceCapabilitiesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u16SupportedMessageTypes);
   (tVoid) (oOut << u16SupportedMapFeatures);
   (tVoid) (oOut << e8MapConnectionState);
   (tVoid) (oOut << oActiveAccount);
   return oOut;
}

tBool most_msgfi_tclMsgMapDeviceCapabilitiesStatus::operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u16SupportedMessageTypes == roRef.u16SupportedMessageTypes);
   bResult = bResult && (u16SupportedMapFeatures == roRef.u16SupportedMapFeatures);
   bResult = bResult && (e8MapConnectionState == roRef.e8MapConnectionState);
   bResult = bResult && (oActiveAccount == roRef.oActiveAccount);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgMessagingOnOffUpReg::most_msgfi_tclMsgMessagingOnOffUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingOnOffUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffUpReg;
}


most_msgfi_tclMsgMessagingOnOffUpReg::~most_msgfi_tclMsgMessagingOnOffUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessagingOnOffRelUpReg::most_msgfi_tclMsgMessagingOnOffRelUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingOnOffRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffRelUpReg;
}


most_msgfi_tclMsgMessagingOnOffRelUpReg::~most_msgfi_tclMsgMessagingOnOffRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessagingOnOffGet::most_msgfi_tclMsgMessagingOnOffGet()
 {}

tS32 most_msgfi_tclMsgMessagingOnOffGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffGet;
}


most_msgfi_tclMsgMessagingOnOffGet::~most_msgfi_tclMsgMessagingOnOffGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingOnOffSet::most_msgfi_tclMsgMessagingOnOffSet(const most_msgfi_tclMsgMessagingOnOffSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   MapOnOff = coRef.MapOnOff;
}
most_msgfi_tclMsgMessagingOnOffSet& most_msgfi_tclMsgMessagingOnOffSet::operator=(const most_msgfi_tclMsgMessagingOnOffSet& coRef)
{
   if (this == &coRef) return *this;
   MapOnOff = coRef.MapOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgMessagingOnOffSet::most_msgfi_tclMsgMessagingOnOffSet()
:MapOnOff(0)
 {}

tS32 most_msgfi_tclMsgMessagingOnOffSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffSet;
}


most_msgfi_tclMsgMessagingOnOffSet::~most_msgfi_tclMsgMessagingOnOffSet()
{}

tU32 most_msgfi_tclMsgMessagingOnOffSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgMessagingOnOffSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MapOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMessagingOnOffSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MapOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgMessagingOnOffSet::operator==(const most_msgfi_tclMsgMessagingOnOffSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MapOnOff == roRef.MapOnOff);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingOnOffError::most_msgfi_tclMsgMessagingOnOffError(const most_msgfi_tclMsgMessagingOnOffError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgMessagingOnOffError& most_msgfi_tclMsgMessagingOnOffError::operator=(const most_msgfi_tclMsgMessagingOnOffError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgMessagingOnOffError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffError;
}


most_msgfi_tclMsgMessagingOnOffError::~most_msgfi_tclMsgMessagingOnOffError()
{}

tBool most_msgfi_tclMsgMessagingOnOffError::operator==(const most_msgfi_tclMsgMessagingOnOffError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingOnOffStatus::most_msgfi_tclMsgMessagingOnOffStatus(const most_msgfi_tclMsgMessagingOnOffStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   MapOnOff = coRef.MapOnOff;
}
most_msgfi_tclMsgMessagingOnOffStatus& most_msgfi_tclMsgMessagingOnOffStatus::operator=(const most_msgfi_tclMsgMessagingOnOffStatus& coRef)
{
   if (this == &coRef) return *this;
   MapOnOff = coRef.MapOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgMessagingOnOffStatus::most_msgfi_tclMsgMessagingOnOffStatus()
:MapOnOff(0)
 {}

tS32 most_msgfi_tclMsgMessagingOnOffStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffStatus;
}


most_msgfi_tclMsgMessagingOnOffStatus::~most_msgfi_tclMsgMessagingOnOffStatus()
{}

tU32 most_msgfi_tclMsgMessagingOnOffStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgMessagingOnOffStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MapOnOff);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMessagingOnOffStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MapOnOff);
   return oOut;
}

tBool most_msgfi_tclMsgMessagingOnOffStatus::operator==(const most_msgfi_tclMsgMessagingOnOffStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MapOnOff == roRef.MapOnOff);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgMessageNotificationUpReg::most_msgfi_tclMsgMessageNotificationUpReg()
 {}

tS32 most_msgfi_tclMsgMessageNotificationUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessageNotificationUpReg;
}


most_msgfi_tclMsgMessageNotificationUpReg::~most_msgfi_tclMsgMessageNotificationUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessageNotificationRelUpReg::most_msgfi_tclMsgMessageNotificationRelUpReg()
 {}

tS32 most_msgfi_tclMsgMessageNotificationRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessageNotificationRelUpReg;
}


most_msgfi_tclMsgMessageNotificationRelUpReg::~most_msgfi_tclMsgMessageNotificationRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessageNotificationGet::most_msgfi_tclMsgMessageNotificationGet()
 {}

tS32 most_msgfi_tclMsgMessageNotificationGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessageNotificationGet;
}


most_msgfi_tclMsgMessageNotificationGet::~most_msgfi_tclMsgMessageNotificationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessageNotificationStatus::most_msgfi_tclMsgMessageNotificationStatus(const most_msgfi_tclMsgMessageNotificationStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8NotificationType = coRef.e8NotificationType;
   e8MessageType = coRef.e8MessageType;
   oMessageHandle = coRef.oMessageHandle;
}
most_msgfi_tclMsgMessageNotificationStatus& most_msgfi_tclMsgMessageNotificationStatus::operator=(const most_msgfi_tclMsgMessageNotificationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8NotificationType = coRef.e8NotificationType;
   e8MessageType = coRef.e8MessageType;
   oMessageHandle = coRef.oMessageHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgMessageNotificationStatus::most_msgfi_tclMsgMessageNotificationStatus()
:e8NotificationType()
,e8MessageType()
,oMessageHandle()
 {}

tS32 most_msgfi_tclMsgMessageNotificationStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessageNotificationStatus;
}


most_msgfi_tclMsgMessageNotificationStatus::~most_msgfi_tclMsgMessageNotificationStatus()
{}

tU32 most_msgfi_tclMsgMessageNotificationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessageHandle.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgMessageNotificationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8NotificationType);
   (tVoid) (oIn >> e8MessageType);
   (tVoid) (oIn >> oMessageHandle);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMessageNotificationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8NotificationType);
   (tVoid) (oOut << e8MessageType);
   (tVoid) (oOut << oMessageHandle);
   return oOut;
}

tBool most_msgfi_tclMsgMessageNotificationStatus::operator==(const most_msgfi_tclMsgMessageNotificationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8NotificationType == roRef.e8NotificationType);
   bResult = bResult && (e8MessageType == roRef.e8MessageType);
   bResult = bResult && (oMessageHandle == roRef.oMessageHandle);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgPredefinedMessageListExtendedUpReg::most_msgfi_tclMsgPredefinedMessageListExtendedUpReg()
 {}

tS32 most_msgfi_tclMsgPredefinedMessageListExtendedUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListExtendedUpReg;
}


most_msgfi_tclMsgPredefinedMessageListExtendedUpReg::~most_msgfi_tclMsgPredefinedMessageListExtendedUpReg()
{}

//=============================================================================

most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg::most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg()
 {}

tS32 most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListExtendedRelUpReg;
}


most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg::~most_msgfi_tclMsgPredefinedMessageListExtendedRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgPredefinedMessageListExtendedGet::most_msgfi_tclMsgPredefinedMessageListExtendedGet()
 {}

tS32 most_msgfi_tclMsgPredefinedMessageListExtendedGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListExtendedGet;
}


most_msgfi_tclMsgPredefinedMessageListExtendedGet::~most_msgfi_tclMsgPredefinedMessageListExtendedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgPredefinedMessageListExtendedError::most_msgfi_tclMsgPredefinedMessageListExtendedError(const most_msgfi_tclMsgPredefinedMessageListExtendedError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgPredefinedMessageListExtendedError& most_msgfi_tclMsgPredefinedMessageListExtendedError::operator=(const most_msgfi_tclMsgPredefinedMessageListExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgPredefinedMessageListExtendedError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListExtendedError;
}


most_msgfi_tclMsgPredefinedMessageListExtendedError::~most_msgfi_tclMsgPredefinedMessageListExtendedError()
{}

tBool most_msgfi_tclMsgPredefinedMessageListExtendedError::operator==(const most_msgfi_tclMsgPredefinedMessageListExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgPredefinedMessageListExtendedStatus::most_msgfi_tclMsgPredefinedMessageListExtendedStatus(const most_msgfi_tclMsgPredefinedMessageListExtendedStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   u8NumPredefinedMessages = coRef.u8NumPredefinedMessages;
   oPredefinedMessageListExtendedResult = coRef.oPredefinedMessageListExtendedResult;
}
most_msgfi_tclMsgPredefinedMessageListExtendedStatus& most_msgfi_tclMsgPredefinedMessageListExtendedStatus::operator=(const most_msgfi_tclMsgPredefinedMessageListExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   u8NumPredefinedMessages = coRef.u8NumPredefinedMessages;
   oPredefinedMessageListExtendedResult = coRef.oPredefinedMessageListExtendedResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgPredefinedMessageListExtendedStatus::vDestroy()
{
}

most_msgfi_tclMsgPredefinedMessageListExtendedStatus::most_msgfi_tclMsgPredefinedMessageListExtendedStatus()
:u8NumPredefinedMessages(0)
,oPredefinedMessageListExtendedResult()
 {}

tS32 most_msgfi_tclMsgPredefinedMessageListExtendedStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_PredefinedMessageListExtendedStatus;
}


most_msgfi_tclMsgPredefinedMessageListExtendedStatus::~most_msgfi_tclMsgPredefinedMessageListExtendedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgPredefinedMessageListExtendedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oPredefinedMessageListExtendedResult.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgPredefinedMessageListExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumPredefinedMessages);
   (tVoid) (oIn >> oPredefinedMessageListExtendedResult);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgPredefinedMessageListExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumPredefinedMessages);
   (tVoid) (oOut << oPredefinedMessageListExtendedResult);
   return oOut;
}

tBool most_msgfi_tclMsgPredefinedMessageListExtendedStatus::operator==(const most_msgfi_tclMsgPredefinedMessageListExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumPredefinedMessages == roRef.u8NumPredefinedMessages);
   bResult = bResult && (oPredefinedMessageListExtendedResult == roRef.oPredefinedMessageListExtendedResult);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgMessagingLanguageUpReg::most_msgfi_tclMsgMessagingLanguageUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingLanguageUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingLanguageUpReg;
}


most_msgfi_tclMsgMessagingLanguageUpReg::~most_msgfi_tclMsgMessagingLanguageUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessagingLanguageRelUpReg::most_msgfi_tclMsgMessagingLanguageRelUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingLanguageRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingLanguageRelUpReg;
}


most_msgfi_tclMsgMessagingLanguageRelUpReg::~most_msgfi_tclMsgMessagingLanguageRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessagingLanguageGet::most_msgfi_tclMsgMessagingLanguageGet()
 {}

tS32 most_msgfi_tclMsgMessagingLanguageGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingLanguageGet;
}


most_msgfi_tclMsgMessagingLanguageGet::~most_msgfi_tclMsgMessagingLanguageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingLanguageSet::most_msgfi_tclMsgMessagingLanguageSet(const most_msgfi_tclMsgMessagingLanguageSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8LanguageSet = coRef.e8LanguageSet;
}
most_msgfi_tclMsgMessagingLanguageSet& most_msgfi_tclMsgMessagingLanguageSet::operator=(const most_msgfi_tclMsgMessagingLanguageSet& coRef)
{
   if (this == &coRef) return *this;
   e8LanguageSet = coRef.e8LanguageSet;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgMessagingLanguageSet::most_msgfi_tclMsgMessagingLanguageSet()
:e8LanguageSet()
 {}

tS32 most_msgfi_tclMsgMessagingLanguageSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingLanguageSet;
}


most_msgfi_tclMsgMessagingLanguageSet::~most_msgfi_tclMsgMessagingLanguageSet()
{}

tU32 most_msgfi_tclMsgMessagingLanguageSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgMessagingLanguageSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LanguageSet);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMessagingLanguageSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LanguageSet);
   return oOut;
}

tBool most_msgfi_tclMsgMessagingLanguageSet::operator==(const most_msgfi_tclMsgMessagingLanguageSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LanguageSet == roRef.e8LanguageSet);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingLanguageError::most_msgfi_tclMsgMessagingLanguageError(const most_msgfi_tclMsgMessagingLanguageError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgMessagingLanguageError& most_msgfi_tclMsgMessagingLanguageError::operator=(const most_msgfi_tclMsgMessagingLanguageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgMessagingLanguageError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingLanguageError;
}


most_msgfi_tclMsgMessagingLanguageError::~most_msgfi_tclMsgMessagingLanguageError()
{}

tBool most_msgfi_tclMsgMessagingLanguageError::operator==(const most_msgfi_tclMsgMessagingLanguageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingLanguageStatus::most_msgfi_tclMsgMessagingLanguageStatus(const most_msgfi_tclMsgMessagingLanguageStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   e8LanguageSet = coRef.e8LanguageSet;
}
most_msgfi_tclMsgMessagingLanguageStatus& most_msgfi_tclMsgMessagingLanguageStatus::operator=(const most_msgfi_tclMsgMessagingLanguageStatus& coRef)
{
   if (this == &coRef) return *this;
   e8LanguageSet = coRef.e8LanguageSet;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgMessagingLanguageStatus::most_msgfi_tclMsgMessagingLanguageStatus()
:e8LanguageSet()
 {}

tS32 most_msgfi_tclMsgMessagingLanguageStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingLanguageStatus;
}


most_msgfi_tclMsgMessagingLanguageStatus::~most_msgfi_tclMsgMessagingLanguageStatus()
{}

tU32 most_msgfi_tclMsgMessagingLanguageStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_msgfi_tclMsgMessagingLanguageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8LanguageSet);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMessagingLanguageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8LanguageSet);
   return oOut;
}

tBool most_msgfi_tclMsgMessagingLanguageStatus::operator==(const most_msgfi_tclMsgMessagingLanguageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8LanguageSet == roRef.e8LanguageSet);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgSignatureSettingExtendedUpReg::most_msgfi_tclMsgSignatureSettingExtendedUpReg()
 {}

tS32 most_msgfi_tclMsgSignatureSettingExtendedUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedUpReg;
}


most_msgfi_tclMsgSignatureSettingExtendedUpReg::~most_msgfi_tclMsgSignatureSettingExtendedUpReg()
{}

//=============================================================================

most_msgfi_tclMsgSignatureSettingExtendedRelUpReg::most_msgfi_tclMsgSignatureSettingExtendedRelUpReg()
 {}

tS32 most_msgfi_tclMsgSignatureSettingExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedRelUpReg;
}


most_msgfi_tclMsgSignatureSettingExtendedRelUpReg::~most_msgfi_tclMsgSignatureSettingExtendedRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgSignatureSettingExtendedGet::most_msgfi_tclMsgSignatureSettingExtendedGet()
 {}

tS32 most_msgfi_tclMsgSignatureSettingExtendedGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedGet;
}


most_msgfi_tclMsgSignatureSettingExtendedGet::~most_msgfi_tclMsgSignatureSettingExtendedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSignatureSettingExtendedPureSet::most_msgfi_tclMsgSignatureSettingExtendedPureSet(const most_msgfi_tclMsgSignatureSettingExtendedPureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oSignatureTextStream = coRef.oSignatureTextStream;
}
most_msgfi_tclMsgSignatureSettingExtendedPureSet& most_msgfi_tclMsgSignatureSettingExtendedPureSet::operator=(const most_msgfi_tclMsgSignatureSettingExtendedPureSet& coRef)
{
   if (this == &coRef) return *this;
   oSignatureTextStream = coRef.oSignatureTextStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgSignatureSettingExtendedPureSet::vDestroy()
{
}

most_msgfi_tclMsgSignatureSettingExtendedPureSet::most_msgfi_tclMsgSignatureSettingExtendedPureSet()
:oSignatureTextStream()
 {}

tS32 most_msgfi_tclMsgSignatureSettingExtendedPureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedPureSet;
}


most_msgfi_tclMsgSignatureSettingExtendedPureSet::~most_msgfi_tclMsgSignatureSettingExtendedPureSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgSignatureSettingExtendedPureSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oSignatureTextStream.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgSignatureSettingExtendedPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oSignatureTextStream);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSignatureSettingExtendedPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oSignatureTextStream);
   return oOut;
}

tBool most_msgfi_tclMsgSignatureSettingExtendedPureSet::operator==(const most_msgfi_tclMsgSignatureSettingExtendedPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oSignatureTextStream == roRef.oSignatureTextStream);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSignatureSettingExtendedError::most_msgfi_tclMsgSignatureSettingExtendedError(const most_msgfi_tclMsgSignatureSettingExtendedError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgSignatureSettingExtendedError& most_msgfi_tclMsgSignatureSettingExtendedError::operator=(const most_msgfi_tclMsgSignatureSettingExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgSignatureSettingExtendedError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedError;
}


most_msgfi_tclMsgSignatureSettingExtendedError::~most_msgfi_tclMsgSignatureSettingExtendedError()
{}

tBool most_msgfi_tclMsgSignatureSettingExtendedError::operator==(const most_msgfi_tclMsgSignatureSettingExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgSignatureSettingExtendedStatus::most_msgfi_tclMsgSignatureSettingExtendedStatus(const most_msgfi_tclMsgSignatureSettingExtendedStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oSignatureTextStream = coRef.oSignatureTextStream;
}
most_msgfi_tclMsgSignatureSettingExtendedStatus& most_msgfi_tclMsgSignatureSettingExtendedStatus::operator=(const most_msgfi_tclMsgSignatureSettingExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   oSignatureTextStream = coRef.oSignatureTextStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgSignatureSettingExtendedStatus::vDestroy()
{
}

most_msgfi_tclMsgSignatureSettingExtendedStatus::most_msgfi_tclMsgSignatureSettingExtendedStatus()
:oSignatureTextStream()
 {}

tS32 most_msgfi_tclMsgSignatureSettingExtendedStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_SignatureSettingExtendedStatus;
}


most_msgfi_tclMsgSignatureSettingExtendedStatus::~most_msgfi_tclMsgSignatureSettingExtendedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgSignatureSettingExtendedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oSignatureTextStream.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgSignatureSettingExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oSignatureTextStream);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgSignatureSettingExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oSignatureTextStream);
   return oOut;
}

tBool most_msgfi_tclMsgSignatureSettingExtendedStatus::operator==(const most_msgfi_tclMsgSignatureSettingExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oSignatureTextStream == roRef.oSignatureTextStream);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgMessagingOnOffListUpReg::most_msgfi_tclMsgMessagingOnOffListUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingOnOffListUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffListUpReg;
}


most_msgfi_tclMsgMessagingOnOffListUpReg::~most_msgfi_tclMsgMessagingOnOffListUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessagingOnOffListRelUpReg::most_msgfi_tclMsgMessagingOnOffListRelUpReg()
 {}

tS32 most_msgfi_tclMsgMessagingOnOffListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffListRelUpReg;
}


most_msgfi_tclMsgMessagingOnOffListRelUpReg::~most_msgfi_tclMsgMessagingOnOffListRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMessagingOnOffListGet::most_msgfi_tclMsgMessagingOnOffListGet()
 {}

tS32 most_msgfi_tclMsgMessagingOnOffListGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffListGet;
}


most_msgfi_tclMsgMessagingOnOffListGet::~most_msgfi_tclMsgMessagingOnOffListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingOnOffListError::most_msgfi_tclMsgMessagingOnOffListError(const most_msgfi_tclMsgMessagingOnOffListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgMessagingOnOffListError& most_msgfi_tclMsgMessagingOnOffListError::operator=(const most_msgfi_tclMsgMessagingOnOffListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgMessagingOnOffListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffListError;
}


most_msgfi_tclMsgMessagingOnOffListError::~most_msgfi_tclMsgMessagingOnOffListError()
{}

tBool most_msgfi_tclMsgMessagingOnOffListError::operator==(const most_msgfi_tclMsgMessagingOnOffListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMessagingOnOffListStatus::most_msgfi_tclMsgMessagingOnOffListStatus(const most_msgfi_tclMsgMessagingOnOffListStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMessagingOnOffList = coRef.oMessagingOnOffList;
}
most_msgfi_tclMsgMessagingOnOffListStatus& most_msgfi_tclMsgMessagingOnOffListStatus::operator=(const most_msgfi_tclMsgMessagingOnOffListStatus& coRef)
{
   if (this == &coRef) return *this;
   oMessagingOnOffList = coRef.oMessagingOnOffList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgMessagingOnOffListStatus::most_msgfi_tclMsgMessagingOnOffListStatus()
:oMessagingOnOffList()
 {}

tS32 most_msgfi_tclMsgMessagingOnOffListStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MessagingOnOffListStatus;
}


most_msgfi_tclMsgMessagingOnOffListStatus::~most_msgfi_tclMsgMessagingOnOffListStatus()
{}

tU32 most_msgfi_tclMsgMessagingOnOffListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMessagingOnOffList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgMessagingOnOffListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMessagingOnOffList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMessagingOnOffListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMessagingOnOffList);
   return oOut;
}

tBool most_msgfi_tclMsgMessagingOnOffListStatus::operator==(const most_msgfi_tclMsgMessagingOnOffListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMessagingOnOffList == roRef.oMessagingOnOffList);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgTextRingtoneOnOffListUpReg::most_msgfi_tclMsgTextRingtoneOnOffListUpReg()
 {}

tS32 most_msgfi_tclMsgTextRingtoneOnOffListUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListUpReg;
}


most_msgfi_tclMsgTextRingtoneOnOffListUpReg::~most_msgfi_tclMsgTextRingtoneOnOffListUpReg()
{}

//=============================================================================

most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg::most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg()
 {}

tS32 most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListRelUpReg;
}


most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg::~most_msgfi_tclMsgTextRingtoneOnOffListRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgTextRingtoneOnOffListGet::most_msgfi_tclMsgTextRingtoneOnOffListGet()
 {}

tS32 most_msgfi_tclMsgTextRingtoneOnOffListGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListGet;
}


most_msgfi_tclMsgTextRingtoneOnOffListGet::~most_msgfi_tclMsgTextRingtoneOnOffListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgTextRingtoneOnOffListPureSet::most_msgfi_tclMsgTextRingtoneOnOffListPureSet(const most_msgfi_tclMsgTextRingtoneOnOffListPureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oTextRingtoneOnOffList = coRef.oTextRingtoneOnOffList;
}
most_msgfi_tclMsgTextRingtoneOnOffListPureSet& most_msgfi_tclMsgTextRingtoneOnOffListPureSet::operator=(const most_msgfi_tclMsgTextRingtoneOnOffListPureSet& coRef)
{
   if (this == &coRef) return *this;
   oTextRingtoneOnOffList = coRef.oTextRingtoneOnOffList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgTextRingtoneOnOffListPureSet::most_msgfi_tclMsgTextRingtoneOnOffListPureSet()
:oTextRingtoneOnOffList()
 {}

tS32 most_msgfi_tclMsgTextRingtoneOnOffListPureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListPureSet;
}


most_msgfi_tclMsgTextRingtoneOnOffListPureSet::~most_msgfi_tclMsgTextRingtoneOnOffListPureSet()
{}

tU32 most_msgfi_tclMsgTextRingtoneOnOffListPureSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oTextRingtoneOnOffList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgTextRingtoneOnOffListPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oTextRingtoneOnOffList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgTextRingtoneOnOffListPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oTextRingtoneOnOffList);
   return oOut;
}

tBool most_msgfi_tclMsgTextRingtoneOnOffListPureSet::operator==(const most_msgfi_tclMsgTextRingtoneOnOffListPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oTextRingtoneOnOffList == roRef.oTextRingtoneOnOffList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgTextRingtoneOnOffListError::most_msgfi_tclMsgTextRingtoneOnOffListError(const most_msgfi_tclMsgTextRingtoneOnOffListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgTextRingtoneOnOffListError& most_msgfi_tclMsgTextRingtoneOnOffListError::operator=(const most_msgfi_tclMsgTextRingtoneOnOffListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgTextRingtoneOnOffListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListError;
}


most_msgfi_tclMsgTextRingtoneOnOffListError::~most_msgfi_tclMsgTextRingtoneOnOffListError()
{}

tBool most_msgfi_tclMsgTextRingtoneOnOffListError::operator==(const most_msgfi_tclMsgTextRingtoneOnOffListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgTextRingtoneOnOffListStatus::most_msgfi_tclMsgTextRingtoneOnOffListStatus(const most_msgfi_tclMsgTextRingtoneOnOffListStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oTextRingtoneOnOffList = coRef.oTextRingtoneOnOffList;
}
most_msgfi_tclMsgTextRingtoneOnOffListStatus& most_msgfi_tclMsgTextRingtoneOnOffListStatus::operator=(const most_msgfi_tclMsgTextRingtoneOnOffListStatus& coRef)
{
   if (this == &coRef) return *this;
   oTextRingtoneOnOffList = coRef.oTextRingtoneOnOffList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgTextRingtoneOnOffListStatus::most_msgfi_tclMsgTextRingtoneOnOffListStatus()
:oTextRingtoneOnOffList()
 {}

tS32 most_msgfi_tclMsgTextRingtoneOnOffListStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_TextRingtoneOnOffListStatus;
}


most_msgfi_tclMsgTextRingtoneOnOffListStatus::~most_msgfi_tclMsgTextRingtoneOnOffListStatus()
{}

tU32 most_msgfi_tclMsgTextRingtoneOnOffListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oTextRingtoneOnOffList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgTextRingtoneOnOffListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oTextRingtoneOnOffList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgTextRingtoneOnOffListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oTextRingtoneOnOffList);
   return oOut;
}

tBool most_msgfi_tclMsgTextRingtoneOnOffListStatus::operator==(const most_msgfi_tclMsgTextRingtoneOnOffListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oTextRingtoneOnOffList == roRef.oTextRingtoneOnOffList);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgAutoReplyOnOffListUpReg::most_msgfi_tclMsgAutoReplyOnOffListUpReg()
 {}

tS32 most_msgfi_tclMsgAutoReplyOnOffListUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListUpReg;
}


most_msgfi_tclMsgAutoReplyOnOffListUpReg::~most_msgfi_tclMsgAutoReplyOnOffListUpReg()
{}

//=============================================================================

most_msgfi_tclMsgAutoReplyOnOffListRelUpReg::most_msgfi_tclMsgAutoReplyOnOffListRelUpReg()
 {}

tS32 most_msgfi_tclMsgAutoReplyOnOffListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListRelUpReg;
}


most_msgfi_tclMsgAutoReplyOnOffListRelUpReg::~most_msgfi_tclMsgAutoReplyOnOffListRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgAutoReplyOnOffListGet::most_msgfi_tclMsgAutoReplyOnOffListGet()
 {}

tS32 most_msgfi_tclMsgAutoReplyOnOffListGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListGet;
}


most_msgfi_tclMsgAutoReplyOnOffListGet::~most_msgfi_tclMsgAutoReplyOnOffListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAutoReplyOnOffListPureSet::most_msgfi_tclMsgAutoReplyOnOffListPureSet(const most_msgfi_tclMsgAutoReplyOnOffListPureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oAutoReplyOnOffList = coRef.oAutoReplyOnOffList;
}
most_msgfi_tclMsgAutoReplyOnOffListPureSet& most_msgfi_tclMsgAutoReplyOnOffListPureSet::operator=(const most_msgfi_tclMsgAutoReplyOnOffListPureSet& coRef)
{
   if (this == &coRef) return *this;
   oAutoReplyOnOffList = coRef.oAutoReplyOnOffList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAutoReplyOnOffListPureSet::most_msgfi_tclMsgAutoReplyOnOffListPureSet()
:oAutoReplyOnOffList()
 {}

tS32 most_msgfi_tclMsgAutoReplyOnOffListPureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListPureSet;
}


most_msgfi_tclMsgAutoReplyOnOffListPureSet::~most_msgfi_tclMsgAutoReplyOnOffListPureSet()
{}

tU32 most_msgfi_tclMsgAutoReplyOnOffListPureSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oAutoReplyOnOffList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgAutoReplyOnOffListPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oAutoReplyOnOffList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAutoReplyOnOffListPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oAutoReplyOnOffList);
   return oOut;
}

tBool most_msgfi_tclMsgAutoReplyOnOffListPureSet::operator==(const most_msgfi_tclMsgAutoReplyOnOffListPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oAutoReplyOnOffList == roRef.oAutoReplyOnOffList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAutoReplyOnOffListError::most_msgfi_tclMsgAutoReplyOnOffListError(const most_msgfi_tclMsgAutoReplyOnOffListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgAutoReplyOnOffListError& most_msgfi_tclMsgAutoReplyOnOffListError::operator=(const most_msgfi_tclMsgAutoReplyOnOffListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgAutoReplyOnOffListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListError;
}


most_msgfi_tclMsgAutoReplyOnOffListError::~most_msgfi_tclMsgAutoReplyOnOffListError()
{}

tBool most_msgfi_tclMsgAutoReplyOnOffListError::operator==(const most_msgfi_tclMsgAutoReplyOnOffListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAutoReplyOnOffListStatus::most_msgfi_tclMsgAutoReplyOnOffListStatus(const most_msgfi_tclMsgAutoReplyOnOffListStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oAutoReplyOnOffList = coRef.oAutoReplyOnOffList;
}
most_msgfi_tclMsgAutoReplyOnOffListStatus& most_msgfi_tclMsgAutoReplyOnOffListStatus::operator=(const most_msgfi_tclMsgAutoReplyOnOffListStatus& coRef)
{
   if (this == &coRef) return *this;
   oAutoReplyOnOffList = coRef.oAutoReplyOnOffList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAutoReplyOnOffListStatus::most_msgfi_tclMsgAutoReplyOnOffListStatus()
:oAutoReplyOnOffList()
 {}

tS32 most_msgfi_tclMsgAutoReplyOnOffListStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyOnOffListStatus;
}


most_msgfi_tclMsgAutoReplyOnOffListStatus::~most_msgfi_tclMsgAutoReplyOnOffListStatus()
{}

tU32 most_msgfi_tclMsgAutoReplyOnOffListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oAutoReplyOnOffList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgAutoReplyOnOffListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oAutoReplyOnOffList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAutoReplyOnOffListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oAutoReplyOnOffList);
   return oOut;
}

tBool most_msgfi_tclMsgAutoReplyOnOffListStatus::operator==(const most_msgfi_tclMsgAutoReplyOnOffListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oAutoReplyOnOffList == roRef.oAutoReplyOnOffList);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgAutoReplyTextListUpReg::most_msgfi_tclMsgAutoReplyTextListUpReg()
 {}

tS32 most_msgfi_tclMsgAutoReplyTextListUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyTextListUpReg;
}


most_msgfi_tclMsgAutoReplyTextListUpReg::~most_msgfi_tclMsgAutoReplyTextListUpReg()
{}

//=============================================================================

most_msgfi_tclMsgAutoReplyTextListRelUpReg::most_msgfi_tclMsgAutoReplyTextListRelUpReg()
 {}

tS32 most_msgfi_tclMsgAutoReplyTextListRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyTextListRelUpReg;
}


most_msgfi_tclMsgAutoReplyTextListRelUpReg::~most_msgfi_tclMsgAutoReplyTextListRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgAutoReplyTextListGet::most_msgfi_tclMsgAutoReplyTextListGet()
 {}

tS32 most_msgfi_tclMsgAutoReplyTextListGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyTextListGet;
}


most_msgfi_tclMsgAutoReplyTextListGet::~most_msgfi_tclMsgAutoReplyTextListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAutoReplyTextListPureSet::most_msgfi_tclMsgAutoReplyTextListPureSet(const most_msgfi_tclMsgAutoReplyTextListPureSet& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oAutoReplyTextList = coRef.oAutoReplyTextList;
}
most_msgfi_tclMsgAutoReplyTextListPureSet& most_msgfi_tclMsgAutoReplyTextListPureSet::operator=(const most_msgfi_tclMsgAutoReplyTextListPureSet& coRef)
{
   if (this == &coRef) return *this;
   oAutoReplyTextList = coRef.oAutoReplyTextList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAutoReplyTextListPureSet::most_msgfi_tclMsgAutoReplyTextListPureSet()
:oAutoReplyTextList()
 {}

tS32 most_msgfi_tclMsgAutoReplyTextListPureSet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyTextListPureSet;
}


most_msgfi_tclMsgAutoReplyTextListPureSet::~most_msgfi_tclMsgAutoReplyTextListPureSet()
{}

tU32 most_msgfi_tclMsgAutoReplyTextListPureSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oAutoReplyTextList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgAutoReplyTextListPureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oAutoReplyTextList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAutoReplyTextListPureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oAutoReplyTextList);
   return oOut;
}

tBool most_msgfi_tclMsgAutoReplyTextListPureSet::operator==(const most_msgfi_tclMsgAutoReplyTextListPureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oAutoReplyTextList == roRef.oAutoReplyTextList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAutoReplyTextListError::most_msgfi_tclMsgAutoReplyTextListError(const most_msgfi_tclMsgAutoReplyTextListError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgAutoReplyTextListError& most_msgfi_tclMsgAutoReplyTextListError::operator=(const most_msgfi_tclMsgAutoReplyTextListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgAutoReplyTextListError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyTextListError;
}


most_msgfi_tclMsgAutoReplyTextListError::~most_msgfi_tclMsgAutoReplyTextListError()
{}

tBool most_msgfi_tclMsgAutoReplyTextListError::operator==(const most_msgfi_tclMsgAutoReplyTextListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgAutoReplyTextListStatus::most_msgfi_tclMsgAutoReplyTextListStatus(const most_msgfi_tclMsgAutoReplyTextListStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oAutoReplyTextList = coRef.oAutoReplyTextList;
}
most_msgfi_tclMsgAutoReplyTextListStatus& most_msgfi_tclMsgAutoReplyTextListStatus::operator=(const most_msgfi_tclMsgAutoReplyTextListStatus& coRef)
{
   if (this == &coRef) return *this;
   oAutoReplyTextList = coRef.oAutoReplyTextList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_msgfi_tclMsgAutoReplyTextListStatus::most_msgfi_tclMsgAutoReplyTextListStatus()
:oAutoReplyTextList()
 {}

tS32 most_msgfi_tclMsgAutoReplyTextListStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_AutoReplyTextListStatus;
}


most_msgfi_tclMsgAutoReplyTextListStatus::~most_msgfi_tclMsgAutoReplyTextListStatus()
{}

tU32 most_msgfi_tclMsgAutoReplyTextListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oAutoReplyTextList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgAutoReplyTextListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oAutoReplyTextList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgAutoReplyTextListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oAutoReplyTextList);
   return oOut;
}

tBool most_msgfi_tclMsgAutoReplyTextListStatus::operator==(const most_msgfi_tclMsgAutoReplyTextListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oAutoReplyTextList == roRef.oAutoReplyTextList);
   return bResult;
}

//=============================================================================

most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg::most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg()
 {}

tS32 most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesExtendedUpReg;
}


most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg::~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg::most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg()
 {}

tS32 most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesExtendedRelUpReg;
}


most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg::~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedRelUpReg()
{}

//=============================================================================

most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet::most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet()
 {}

tS32 most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesExtendedGet;
}


most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet::~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError::most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError& coRef)
   : most_msgfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError& most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError::operator=(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesExtendedError;
}


most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError::~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError()
{}

tBool most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError::operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus& coRef)
   : most_msgfi_tclMsgBaseMessage(coRef)
{
   oMapDeviceCapabilitiesList = coRef.oMapDeviceCapabilitiesList;
}
most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus& most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::operator=(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   oMapDeviceCapabilitiesList = coRef.oMapDeviceCapabilitiesList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::vDestroy()
{
}

most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus()
:oMapDeviceCapabilitiesList()
 {}

tS32 most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::s32GetTypeId() const
{
   return (tS32) most_msgfi_tclToken::EN_MSG_MapDeviceCapabilitiesExtendedStatus;
}


most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::~most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oMapDeviceCapabilitiesList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oMapDeviceCapabilitiesList);
   return oIn;
}

fi_tclOutContext& most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oMapDeviceCapabilitiesList);
   return oOut;
}

tBool most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus::operator==(const most_msgfi_tclMsgMapDeviceCapabilitiesExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oMapDeviceCapabilitiesList == roRef.oMapDeviceCapabilitiesList);
   return bResult;
}

