/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MOST_BTSETFITYPES_HEADER
#define MOST_BTSETFITYPES_HEADER


class most_btsetfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MOST_BTSet_FI message types

fi_tclMessageBase* most_btsetfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class most_btsetfi_tclMsgBaseMessage : public most_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   most_btsetfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

// base class for all most_btsetfi standard error messages

class most_btsetfi_tclMsgDefaultError: public most_btsetfi_tclMsgBaseMessage
{
public:
   // member variables
   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   most_fi_tcl_TrailingStream oErrorInfo;
   
   most_btsetfi_tclMsgDefaultError() : e8ErrorCode(), oErrorInfo() {};
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgDefaultError(const most_btsetfi_tclMsgDefaultError& coRef);
   most_btsetfi_tclMsgDefaultError& operator=(const most_btsetfi_tclMsgDefaultError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
};

//=============================================================================

class most_btsetfi_tclMsgAddNewDeviceMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAddNewDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAddNewDeviceMethodStart& operator=(const most_btsetfi_tclMsgAddNewDeviceMethodStart& coRef);
   most_btsetfi_tclMsgAddNewDeviceMethodStart(const most_btsetfi_tclMsgAddNewDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDummyFlag;
   virtual ~most_btsetfi_tclMsgAddNewDeviceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgAddNewDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAddNewDeviceError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgAddNewDeviceError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAddNewDeviceError& operator=(const most_btsetfi_tclMsgAddNewDeviceError& coRef);
   most_btsetfi_tclMsgAddNewDeviceError(const most_btsetfi_tclMsgAddNewDeviceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgAddNewDeviceError();

   tBool operator==(const most_btsetfi_tclMsgAddNewDeviceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAddNewDeviceMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAddNewDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAddNewDeviceMethodResult& operator=(const most_btsetfi_tclMsgAddNewDeviceMethodResult& coRef);
   most_btsetfi_tclMsgAddNewDeviceMethodResult(const most_btsetfi_tclMsgAddNewDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSetPairingType e8PairingType;
   most_fi_tcl_String sDeviceName;
   most_fi_tcl_String sPinNumber;
   virtual ~most_btsetfi_tclMsgAddNewDeviceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgAddNewDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingResponseMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingResponseMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairingResponseMethodStart& operator=(const most_btsetfi_tclMsgPairingResponseMethodStart& coRef);
   most_btsetfi_tclMsgPairingResponseMethodStart(const most_btsetfi_tclMsgPairingResponseMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSetPairingResponseType e8PairingResponseType;
   virtual ~most_btsetfi_tclMsgPairingResponseMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgPairingResponseMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingResponseError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgPairingResponseError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairingResponseError& operator=(const most_btsetfi_tclMsgPairingResponseError& coRef);
   most_btsetfi_tclMsgPairingResponseError(const most_btsetfi_tclMsgPairingResponseError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgPairingResponseError();

   tBool operator==(const most_btsetfi_tclMsgPairingResponseError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingResponseMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingResponseMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairingResponseMethodResult& operator=(const most_btsetfi_tclMsgPairingResponseMethodResult& coRef);
   most_btsetfi_tclMsgPairingResponseMethodResult(const most_btsetfi_tclMsgPairingResponseMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSetPairingStatusType e8PairingStatusType;
   virtual ~most_btsetfi_tclMsgPairingResponseMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgPairingResponseMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangePinMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangePinMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangePinMethodStart& operator=(const most_btsetfi_tclMsgChangePinMethodStart& coRef);
   most_btsetfi_tclMsgChangePinMethodStart(const most_btsetfi_tclMsgChangePinMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sPinNumber;
   virtual ~most_btsetfi_tclMsgChangePinMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgChangePinMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangePinError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgChangePinError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangePinError& operator=(const most_btsetfi_tclMsgChangePinError& coRef);
   most_btsetfi_tclMsgChangePinError(const most_btsetfi_tclMsgChangePinError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgChangePinError();

   tBool operator==(const most_btsetfi_tclMsgChangePinError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangePinMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangePinMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangePinMethodResult& operator=(const most_btsetfi_tclMsgChangePinMethodResult& coRef);
   most_btsetfi_tclMsgChangePinMethodResult(const most_btsetfi_tclMsgChangePinMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSetPairingType e8PairingType;
   most_fi_tcl_String sDeviceName;
   most_fi_tcl_String sPinNumber;
   virtual ~most_btsetfi_tclMsgChangePinMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgChangePinMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeDeviceStateMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangeDeviceStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangeDeviceStateMethodStart& operator=(const most_btsetfi_tclMsgChangeDeviceStateMethodStart& coRef);
   most_btsetfi_tclMsgChangeDeviceStateMethodStart(const most_btsetfi_tclMsgChangeDeviceStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSetChangeDeviceStateAction e8ChangeDeviceStateAction;
   tU8 u8DeviceHandle;
   virtual ~most_btsetfi_tclMsgChangeDeviceStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgChangeDeviceStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeDeviceStateError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgChangeDeviceStateError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangeDeviceStateError& operator=(const most_btsetfi_tclMsgChangeDeviceStateError& coRef);
   most_btsetfi_tclMsgChangeDeviceStateError(const most_btsetfi_tclMsgChangeDeviceStateError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgChangeDeviceStateError();

   tBool operator==(const most_btsetfi_tclMsgChangeDeviceStateError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeDeviceStateMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangeDeviceStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangeDeviceStateMethodResult& operator=(const most_btsetfi_tclMsgChangeDeviceStateMethodResult& coRef);
   most_btsetfi_tclMsgChangeDeviceStateMethodResult(const most_btsetfi_tclMsgChangeDeviceStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bReplaceDeviceRequired;
   most_fi_tcl_e8_BTSetConnectionResult e8ConnectionResult;
   virtual ~most_btsetfi_tclMsgChangeDeviceStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgChangeDeviceStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgReplaceDeviceMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgReplaceDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgReplaceDeviceMethodStart& operator=(const most_btsetfi_tclMsgReplaceDeviceMethodStart& coRef);
   most_btsetfi_tclMsgReplaceDeviceMethodStart(const most_btsetfi_tclMsgReplaceDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8ConnectDeviceHandle;
   tU8 u8DisconnectDeviceHandle;
   virtual ~most_btsetfi_tclMsgReplaceDeviceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgReplaceDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgReplaceDeviceError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgReplaceDeviceError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgReplaceDeviceError& operator=(const most_btsetfi_tclMsgReplaceDeviceError& coRef);
   most_btsetfi_tclMsgReplaceDeviceError(const most_btsetfi_tclMsgReplaceDeviceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgReplaceDeviceError();

   tBool operator==(const most_btsetfi_tclMsgReplaceDeviceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgReplaceDeviceMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgReplaceDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgReplaceDeviceMethodResult& operator=(const most_btsetfi_tclMsgReplaceDeviceMethodResult& coRef);
   most_btsetfi_tclMsgReplaceDeviceMethodResult(const most_btsetfi_tclMsgReplaceDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSetConnectionResult e8ConnectionResult;
   virtual ~most_btsetfi_tclMsgReplaceDeviceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgReplaceDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart& operator=(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart& coRef);
   most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDummyFlag;
   virtual ~most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgRequestDeviceRingtoneListError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgRequestDeviceRingtoneListError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgRequestDeviceRingtoneListError& operator=(const most_btsetfi_tclMsgRequestDeviceRingtoneListError& coRef);
   most_btsetfi_tclMsgRequestDeviceRingtoneListError(const most_btsetfi_tclMsgRequestDeviceRingtoneListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgRequestDeviceRingtoneListError();

   tBool operator==(const most_btsetfi_tclMsgRequestDeviceRingtoneListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult& operator=(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult& coRef);
   most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTSetDeviceRingtoneListResult oDeviceRingtoneListResult;
   virtual ~most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart& operator=(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart& coRef);
   most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgRequestAvailableRingtonesListError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgRequestAvailableRingtonesListError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgRequestAvailableRingtonesListError& operator=(const most_btsetfi_tclMsgRequestAvailableRingtonesListError& coRef);
   most_btsetfi_tclMsgRequestAvailableRingtonesListError(const most_btsetfi_tclMsgRequestAvailableRingtonesListError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgRequestAvailableRingtonesListError();

   tBool operator==(const most_btsetfi_tclMsgRequestAvailableRingtonesListError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult& operator=(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult& coRef);
   most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTSetRingtoneList oRingtoneList;
   virtual ~most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPlayRingtoneMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPlayRingtoneMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPlayRingtoneMethodStart& operator=(const most_btsetfi_tclMsgPlayRingtoneMethodStart& coRef);
   most_btsetfi_tclMsgPlayRingtoneMethodStart(const most_btsetfi_tclMsgPlayRingtoneMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16RingtoneID;
   tU8 u8LogicalAVChannel;
   virtual ~most_btsetfi_tclMsgPlayRingtoneMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgPlayRingtoneMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPlayRingtoneError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgPlayRingtoneError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPlayRingtoneError& operator=(const most_btsetfi_tclMsgPlayRingtoneError& coRef);
   most_btsetfi_tclMsgPlayRingtoneError(const most_btsetfi_tclMsgPlayRingtoneError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgPlayRingtoneError();

   tBool operator==(const most_btsetfi_tclMsgPlayRingtoneError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPlayRingtoneMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPlayRingtoneMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPlayRingtoneMethodResult& operator=(const most_btsetfi_tclMsgPlayRingtoneMethodResult& coRef);
   most_btsetfi_tclMsgPlayRingtoneMethodResult(const most_btsetfi_tclMsgPlayRingtoneMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_ErrorCode e8ErrorCode;
   most_fi_tcl_TrailingStream oErrorInfo;
   virtual ~most_btsetfi_tclMsgPlayRingtoneMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgPlayRingtoneMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgClearDeviceInfoMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgClearDeviceInfoMethodStart();

   virtual ~most_btsetfi_tclMsgClearDeviceInfoMethodStart();

   inline tBool operator==(const most_btsetfi_tclMsgClearDeviceInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgClearDeviceInfoError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgClearDeviceInfoError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgClearDeviceInfoError& operator=(const most_btsetfi_tclMsgClearDeviceInfoError& coRef);
   most_btsetfi_tclMsgClearDeviceInfoError(const most_btsetfi_tclMsgClearDeviceInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgClearDeviceInfoError();

   tBool operator==(const most_btsetfi_tclMsgClearDeviceInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgClearDeviceInfoMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgClearDeviceInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgClearDeviceInfoMethodResult& operator=(const most_btsetfi_tclMsgClearDeviceInfoMethodResult& coRef);
   most_btsetfi_tclMsgClearDeviceInfoMethodResult(const most_btsetfi_tclMsgClearDeviceInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgClearDeviceInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgClearDeviceInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart& operator=(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart& coRef);
   most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgGetDeviceInfoExtendedError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgGetDeviceInfoExtendedError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgGetDeviceInfoExtendedError& operator=(const most_btsetfi_tclMsgGetDeviceInfoExtendedError& coRef);
   most_btsetfi_tclMsgGetDeviceInfoExtendedError(const most_btsetfi_tclMsgGetDeviceInfoExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgGetDeviceInfoExtendedError();

   tBool operator==(const most_btsetfi_tclMsgGetDeviceInfoExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult& operator=(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult& coRef);
   most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_e8_BTSetMajorDeviceClass e8MajorDeviceClass;
   most_fi_tcl_String sBluetoothDeviceAddress;
   most_fi_tcl_BTSetBluetoothFeatureSupport oBluetoothFeatureSupport;
   most_fi_tcl_String sLinkKey;
   most_fi_tcl_BTSetSupportedProfiles oSupportedProfiles;
   most_fi_tcl_BTSetDeviceIdentification oDeviceIdentification;
   virtual ~most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStopRingtoneMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgStopRingtoneMethodStart();

   virtual ~most_btsetfi_tclMsgStopRingtoneMethodStart();

   inline tBool operator==(const most_btsetfi_tclMsgStopRingtoneMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStopRingtoneError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgStopRingtoneError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStopRingtoneError& operator=(const most_btsetfi_tclMsgStopRingtoneError& coRef);
   most_btsetfi_tclMsgStopRingtoneError(const most_btsetfi_tclMsgStopRingtoneError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgStopRingtoneError();

   tBool operator==(const most_btsetfi_tclMsgStopRingtoneError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStopRingtoneMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgStopRingtoneMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStopRingtoneMethodResult& operator=(const most_btsetfi_tclMsgStopRingtoneMethodResult& coRef);
   most_btsetfi_tclMsgStopRingtoneMethodResult(const most_btsetfi_tclMsgStopRingtoneMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bStopPlayRingtoneResult;
   virtual ~most_btsetfi_tclMsgStopRingtoneMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgStopRingtoneMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgScanBluetoothDevicesMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgScanBluetoothDevicesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgScanBluetoothDevicesMethodStart& operator=(const most_btsetfi_tclMsgScanBluetoothDevicesMethodStart& coRef);
   most_btsetfi_tclMsgScanBluetoothDevicesMethodStart(const most_btsetfi_tclMsgScanBluetoothDevicesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bScan;
   virtual ~most_btsetfi_tclMsgScanBluetoothDevicesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgScanBluetoothDevicesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgScanBluetoothDevicesError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgScanBluetoothDevicesError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgScanBluetoothDevicesError& operator=(const most_btsetfi_tclMsgScanBluetoothDevicesError& coRef);
   most_btsetfi_tclMsgScanBluetoothDevicesError(const most_btsetfi_tclMsgScanBluetoothDevicesError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgScanBluetoothDevicesError();

   tBool operator==(const most_btsetfi_tclMsgScanBluetoothDevicesError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgScanBluetoothDevicesMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgScanBluetoothDevicesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgScanBluetoothDevicesMethodResult& operator=(const most_btsetfi_tclMsgScanBluetoothDevicesMethodResult& coRef);
   most_btsetfi_tclMsgScanBluetoothDevicesMethodResult(const most_btsetfi_tclMsgScanBluetoothDevicesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSetScanningState e8ScanningState;
   virtual ~most_btsetfi_tclMsgScanBluetoothDevicesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgScanBluetoothDevicesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConnectBluetoothProfileMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgConnectBluetoothProfileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgConnectBluetoothProfileMethodStart& operator=(const most_btsetfi_tclMsgConnectBluetoothProfileMethodStart& coRef);
   most_btsetfi_tclMsgConnectBluetoothProfileMethodStart(const most_btsetfi_tclMsgConnectBluetoothProfileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_BTServiceType oServiceType;
   virtual ~most_btsetfi_tclMsgConnectBluetoothProfileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgConnectBluetoothProfileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConnectBluetoothProfileError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgConnectBluetoothProfileError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgConnectBluetoothProfileError& operator=(const most_btsetfi_tclMsgConnectBluetoothProfileError& coRef);
   most_btsetfi_tclMsgConnectBluetoothProfileError(const most_btsetfi_tclMsgConnectBluetoothProfileError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgConnectBluetoothProfileError();

   tBool operator==(const most_btsetfi_tclMsgConnectBluetoothProfileError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConnectBluetoothProfileMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgConnectBluetoothProfileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgConnectBluetoothProfileMethodResult& operator=(const most_btsetfi_tclMsgConnectBluetoothProfileMethodResult& coRef);
   most_btsetfi_tclMsgConnectBluetoothProfileMethodResult(const most_btsetfi_tclMsgConnectBluetoothProfileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_BTServiceType oProfileConnectionStatus;
   virtual ~most_btsetfi_tclMsgConnectBluetoothProfileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgConnectBluetoothProfileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart& operator=(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart& coRef);
   most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_BTServiceType oServiceType;
   virtual ~most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDisconnectBluetoothProfileError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgDisconnectBluetoothProfileError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgDisconnectBluetoothProfileError& operator=(const most_btsetfi_tclMsgDisconnectBluetoothProfileError& coRef);
   most_btsetfi_tclMsgDisconnectBluetoothProfileError(const most_btsetfi_tclMsgDisconnectBluetoothProfileError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgDisconnectBluetoothProfileError();

   tBool operator==(const most_btsetfi_tclMsgDisconnectBluetoothProfileError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult& operator=(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult& coRef);
   most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_BTServiceType oProfileDisconnectionStatus;
   virtual ~most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSendPairingRequestMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSendPairingRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSendPairingRequestMethodStart& operator=(const most_btsetfi_tclMsgSendPairingRequestMethodStart& coRef);
   most_btsetfi_tclMsgSendPairingRequestMethodStart(const most_btsetfi_tclMsgSendPairingRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bPairingRequest;
   most_fi_tcl_String sRemoteDeviceAddress;
   virtual ~most_btsetfi_tclMsgSendPairingRequestMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSendPairingRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSendPairingRequestError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSendPairingRequestError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSendPairingRequestError& operator=(const most_btsetfi_tclMsgSendPairingRequestError& coRef);
   most_btsetfi_tclMsgSendPairingRequestError(const most_btsetfi_tclMsgSendPairingRequestError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSendPairingRequestError();

   tBool operator==(const most_btsetfi_tclMsgSendPairingRequestError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSendPairingRequestMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSendPairingRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSendPairingRequestMethodResult& operator=(const most_btsetfi_tclMsgSendPairingRequestMethodResult& coRef);
   most_btsetfi_tclMsgSendPairingRequestMethodResult(const most_btsetfi_tclMsgSendPairingRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSetPairingResult e8PairingResult;
   virtual ~most_btsetfi_tclMsgSendPairingRequestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSendPairingRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSwitchBTLocalModeMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSwitchBTLocalModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSwitchBTLocalModeMethodStart& operator=(const most_btsetfi_tclMsgSwitchBTLocalModeMethodStart& coRef);
   most_btsetfi_tclMsgSwitchBTLocalModeMethodStart(const most_btsetfi_tclMsgSwitchBTLocalModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTLocalModeType Pairable;
   most_fi_tcl_BTLocalModeType Connectable;
   most_fi_tcl_String sBTAddress;
   virtual ~most_btsetfi_tclMsgSwitchBTLocalModeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSwitchBTLocalModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSwitchBTLocalModeError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSwitchBTLocalModeError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSwitchBTLocalModeError& operator=(const most_btsetfi_tclMsgSwitchBTLocalModeError& coRef);
   most_btsetfi_tclMsgSwitchBTLocalModeError(const most_btsetfi_tclMsgSwitchBTLocalModeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSwitchBTLocalModeError();

   tBool operator==(const most_btsetfi_tclMsgSwitchBTLocalModeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSwitchBTLocalModeMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSwitchBTLocalModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSwitchBTLocalModeMethodResult& operator=(const most_btsetfi_tclMsgSwitchBTLocalModeMethodResult& coRef);
   most_btsetfi_tclMsgSwitchBTLocalModeMethodResult(const most_btsetfi_tclMsgSwitchBTLocalModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgSwitchBTLocalModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSwitchBTLocalModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart& operator=(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart& coRef);
   most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bStartAutoConnect;
   virtual ~most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStartAutoConnectSequenceError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgStartAutoConnectSequenceError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStartAutoConnectSequenceError& operator=(const most_btsetfi_tclMsgStartAutoConnectSequenceError& coRef);
   most_btsetfi_tclMsgStartAutoConnectSequenceError(const most_btsetfi_tclMsgStartAutoConnectSequenceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgStartAutoConnectSequenceError();

   tBool operator==(const most_btsetfi_tclMsgStartAutoConnectSequenceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult& operator=(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult& coRef);
   most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConnectSPPServiceMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgConnectSPPServiceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgConnectSPPServiceMethodStart& operator=(const most_btsetfi_tclMsgConnectSPPServiceMethodStart& coRef);
   most_btsetfi_tclMsgConnectSPPServiceMethodStart(const most_btsetfi_tclMsgConnectSPPServiceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_String szUUID;
   virtual ~most_btsetfi_tclMsgConnectSPPServiceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgConnectSPPServiceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConnectSPPServiceError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgConnectSPPServiceError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgConnectSPPServiceError& operator=(const most_btsetfi_tclMsgConnectSPPServiceError& coRef);
   most_btsetfi_tclMsgConnectSPPServiceError(const most_btsetfi_tclMsgConnectSPPServiceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgConnectSPPServiceError();

   tBool operator==(const most_btsetfi_tclMsgConnectSPPServiceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConnectSPPServiceMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgConnectSPPServiceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgConnectSPPServiceMethodResult& operator=(const most_btsetfi_tclMsgConnectSPPServiceMethodResult& coRef);
   most_btsetfi_tclMsgConnectSPPServiceMethodResult(const most_btsetfi_tclMsgConnectSPPServiceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bConnectSPPService;
   virtual ~most_btsetfi_tclMsgConnectSPPServiceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgConnectSPPServiceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart& operator=(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart& coRef);
   most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   most_fi_tcl_String sBdDeviceName;
   most_fi_tcl_e8_BTTechnology e8Technology;
   most_fi_tcl_e8_BTCommunicationChannel e8CommunicationChannel;
   most_fi_tcl_e8_BTLimitationAction e8Action;
   virtual ~most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetBluetoothLimitationModeError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSetBluetoothLimitationModeError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetBluetoothLimitationModeError& operator=(const most_btsetfi_tclMsgSetBluetoothLimitationModeError& coRef);
   most_btsetfi_tclMsgSetBluetoothLimitationModeError(const most_btsetfi_tclMsgSetBluetoothLimitationModeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSetBluetoothLimitationModeError();

   tBool operator==(const most_btsetfi_tclMsgSetBluetoothLimitationModeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult& operator=(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult& coRef);
   most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart& operator=(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart& coRef);
   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bBTOnOff;
   tBool bSuppressAutoConnection;
   virtual ~most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError& operator=(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError& coRef);
   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError();

   tBool operator==(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult& operator=(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult& coRef);
   most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bBTOnOffResult;
   virtual ~most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart& operator=(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart& coRef);
   most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8WiFiPowerAttenuation;
   virtual ~most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeWifiTransmitPowerError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgChangeWifiTransmitPowerError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangeWifiTransmitPowerError& operator=(const most_btsetfi_tclMsgChangeWifiTransmitPowerError& coRef);
   most_btsetfi_tclMsgChangeWifiTransmitPowerError(const most_btsetfi_tclMsgChangeWifiTransmitPowerError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgChangeWifiTransmitPowerError();

   tBool operator==(const most_btsetfi_tclMsgChangeWifiTransmitPowerError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult& operator=(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult& coRef);
   most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDisconnectSPPServiceMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgDisconnectSPPServiceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgDisconnectSPPServiceMethodStart& operator=(const most_btsetfi_tclMsgDisconnectSPPServiceMethodStart& coRef);
   most_btsetfi_tclMsgDisconnectSPPServiceMethodStart(const most_btsetfi_tclMsgDisconnectSPPServiceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_String szUUID;
   virtual ~most_btsetfi_tclMsgDisconnectSPPServiceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgDisconnectSPPServiceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDisconnectSPPServiceError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgDisconnectSPPServiceError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgDisconnectSPPServiceError& operator=(const most_btsetfi_tclMsgDisconnectSPPServiceError& coRef);
   most_btsetfi_tclMsgDisconnectSPPServiceError(const most_btsetfi_tclMsgDisconnectSPPServiceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgDisconnectSPPServiceError();

   tBool operator==(const most_btsetfi_tclMsgDisconnectSPPServiceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDisconnectSPPServiceMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgDisconnectSPPServiceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgDisconnectSPPServiceMethodResult& operator=(const most_btsetfi_tclMsgDisconnectSPPServiceMethodResult& coRef);
   most_btsetfi_tclMsgDisconnectSPPServiceMethodResult(const most_btsetfi_tclMsgDisconnectSPPServiceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDisconnectSPPService;
   virtual ~most_btsetfi_tclMsgDisconnectSPPServiceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgDisconnectSPPServiceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStartSearchSPPServicesMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgStartSearchSPPServicesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStartSearchSPPServicesMethodStart& operator=(const most_btsetfi_tclMsgStartSearchSPPServicesMethodStart& coRef);
   most_btsetfi_tclMsgStartSearchSPPServicesMethodStart(const most_btsetfi_tclMsgStartSearchSPPServicesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tBool bPeriodicSearch;
   virtual ~most_btsetfi_tclMsgStartSearchSPPServicesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgStartSearchSPPServicesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStartSearchSPPServicesError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgStartSearchSPPServicesError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStartSearchSPPServicesError& operator=(const most_btsetfi_tclMsgStartSearchSPPServicesError& coRef);
   most_btsetfi_tclMsgStartSearchSPPServicesError(const most_btsetfi_tclMsgStartSearchSPPServicesError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgStartSearchSPPServicesError();

   tBool operator==(const most_btsetfi_tclMsgStartSearchSPPServicesError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStartSearchSPPServicesMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgStartSearchSPPServicesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStartSearchSPPServicesMethodResult& operator=(const most_btsetfi_tclMsgStartSearchSPPServicesMethodResult& coRef);
   most_btsetfi_tclMsgStartSearchSPPServicesMethodResult(const most_btsetfi_tclMsgStartSearchSPPServicesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   tU8 u8SearchHandle;
   virtual ~most_btsetfi_tclMsgStartSearchSPPServicesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgStartSearchSPPServicesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStopSearchSPPServicesMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgStopSearchSPPServicesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStopSearchSPPServicesMethodStart& operator=(const most_btsetfi_tclMsgStopSearchSPPServicesMethodStart& coRef);
   most_btsetfi_tclMsgStopSearchSPPServicesMethodStart(const most_btsetfi_tclMsgStopSearchSPPServicesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU8 u8SearchHandle;
   virtual ~most_btsetfi_tclMsgStopSearchSPPServicesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgStopSearchSPPServicesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStopSearchSPPServicesError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgStopSearchSPPServicesError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStopSearchSPPServicesError& operator=(const most_btsetfi_tclMsgStopSearchSPPServicesError& coRef);
   most_btsetfi_tclMsgStopSearchSPPServicesError(const most_btsetfi_tclMsgStopSearchSPPServicesError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgStopSearchSPPServicesError();

   tBool operator==(const most_btsetfi_tclMsgStopSearchSPPServicesError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgStopSearchSPPServicesMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgStopSearchSPPServicesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgStopSearchSPPServicesMethodResult& operator=(const most_btsetfi_tclMsgStopSearchSPPServicesMethodResult& coRef);
   most_btsetfi_tclMsgStopSearchSPPServicesMethodResult(const most_btsetfi_tclMsgStopSearchSPPServicesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgStopSearchSPPServicesMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgStopSearchSPPServicesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAddOobPairedDeviceMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAddOobPairedDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAddOobPairedDeviceMethodStart& operator=(const most_btsetfi_tclMsgAddOobPairedDeviceMethodStart& coRef);
   most_btsetfi_tclMsgAddOobPairedDeviceMethodStart(const most_btsetfi_tclMsgAddOobPairedDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sBdAddress;
   most_fi_tcl_String sBdName;
   most_fi_tcl_String sLinkKey;
   most_fi_tcl_e8_BTOobType e8OobType;
   virtual ~most_btsetfi_tclMsgAddOobPairedDeviceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgAddOobPairedDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAddOobPairedDeviceError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgAddOobPairedDeviceError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAddOobPairedDeviceError& operator=(const most_btsetfi_tclMsgAddOobPairedDeviceError& coRef);
   most_btsetfi_tclMsgAddOobPairedDeviceError(const most_btsetfi_tclMsgAddOobPairedDeviceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgAddOobPairedDeviceError();

   tBool operator==(const most_btsetfi_tclMsgAddOobPairedDeviceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAddOobPairedDeviceMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAddOobPairedDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAddOobPairedDeviceMethodResult& operator=(const most_btsetfi_tclMsgAddOobPairedDeviceMethodResult& coRef);
   most_btsetfi_tclMsgAddOobPairedDeviceMethodResult(const most_btsetfi_tclMsgAddOobPairedDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgAddOobPairedDeviceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgAddOobPairedDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetFavoriteMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetFavoriteMethodStart& operator=(const most_btsetfi_tclMsgSetFavoriteMethodStart& coRef);
   most_btsetfi_tclMsgSetFavoriteMethodStart(const most_btsetfi_tclMsgSetFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_e8_BTFavoriteType e8FavoriteType;
   tU8 u8FavoriteIndex;
   virtual ~most_btsetfi_tclMsgSetFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetFavoriteError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSetFavoriteError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetFavoriteError& operator=(const most_btsetfi_tclMsgSetFavoriteError& coRef);
   most_btsetfi_tclMsgSetFavoriteError(const most_btsetfi_tclMsgSetFavoriteError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSetFavoriteError();

   tBool operator==(const most_btsetfi_tclMsgSetFavoriteError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetFavoriteMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetFavoriteMethodResult& operator=(const most_btsetfi_tclMsgSetFavoriteMethodResult& coRef);
   most_btsetfi_tclMsgSetFavoriteMethodResult(const most_btsetfi_tclMsgSetFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgSetFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgClearFavoriteMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgClearFavoriteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgClearFavoriteMethodStart& operator=(const most_btsetfi_tclMsgClearFavoriteMethodStart& coRef);
   most_btsetfi_tclMsgClearFavoriteMethodStart(const most_btsetfi_tclMsgClearFavoriteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_e8_BTFavoriteType e8FavoriteType;
   virtual ~most_btsetfi_tclMsgClearFavoriteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgClearFavoriteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgClearFavoriteError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgClearFavoriteError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgClearFavoriteError& operator=(const most_btsetfi_tclMsgClearFavoriteError& coRef);
   most_btsetfi_tclMsgClearFavoriteError(const most_btsetfi_tclMsgClearFavoriteError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgClearFavoriteError();

   tBool operator==(const most_btsetfi_tclMsgClearFavoriteError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgClearFavoriteMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgClearFavoriteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgClearFavoriteMethodResult& operator=(const most_btsetfi_tclMsgClearFavoriteMethodResult& coRef);
   most_btsetfi_tclMsgClearFavoriteMethodResult(const most_btsetfi_tclMsgClearFavoriteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgClearFavoriteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgClearFavoriteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart& operator=(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart& coRef);
   most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMultiHFPSupport;
   virtual ~most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSwitchMultiHFPSupportError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSwitchMultiHFPSupportError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSwitchMultiHFPSupportError& operator=(const most_btsetfi_tclMsgSwitchMultiHFPSupportError& coRef);
   most_btsetfi_tclMsgSwitchMultiHFPSupportError(const most_btsetfi_tclMsgSwitchMultiHFPSupportError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSwitchMultiHFPSupportError();

   tBool operator==(const most_btsetfi_tclMsgSwitchMultiHFPSupportError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult& operator=(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult& coRef);
   most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetPrimaryMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetPrimaryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetPrimaryMethodStart& operator=(const most_btsetfi_tclMsgSetPrimaryMethodStart& coRef);
   most_btsetfi_tclMsgSetPrimaryMethodStart(const most_btsetfi_tclMsgSetPrimaryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_btsetfi_tclMsgSetPrimaryMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetPrimaryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetPrimaryError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSetPrimaryError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetPrimaryError& operator=(const most_btsetfi_tclMsgSetPrimaryError& coRef);
   most_btsetfi_tclMsgSetPrimaryError(const most_btsetfi_tclMsgSetPrimaryError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSetPrimaryError();

   tBool operator==(const most_btsetfi_tclMsgSetPrimaryError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetPrimaryMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetPrimaryMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetPrimaryMethodResult& operator=(const most_btsetfi_tclMsgSetPrimaryMethodResult& coRef);
   most_btsetfi_tclMsgSetPrimaryMethodResult(const most_btsetfi_tclMsgSetPrimaryMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgSetPrimaryMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetPrimaryMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetBTProfilesUsageMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetBTProfilesUsageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetBTProfilesUsageMethodStart& operator=(const most_btsetfi_tclMsgSetBTProfilesUsageMethodStart& coRef);
   most_btsetfi_tclMsgSetBTProfilesUsageMethodStart(const most_btsetfi_tclMsgSetBTProfilesUsageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTProfilesUsageList oBTProfilesUsageInfoList;
   virtual ~most_btsetfi_tclMsgSetBTProfilesUsageMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetBTProfilesUsageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetBTProfilesUsageError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSetBTProfilesUsageError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetBTProfilesUsageError& operator=(const most_btsetfi_tclMsgSetBTProfilesUsageError& coRef);
   most_btsetfi_tclMsgSetBTProfilesUsageError(const most_btsetfi_tclMsgSetBTProfilesUsageError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSetBTProfilesUsageError();

   tBool operator==(const most_btsetfi_tclMsgSetBTProfilesUsageError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetBTProfilesUsageMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetBTProfilesUsageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetBTProfilesUsageMethodResult& operator=(const most_btsetfi_tclMsgSetBTProfilesUsageMethodResult& coRef);
   most_btsetfi_tclMsgSetBTProfilesUsageMethodResult(const most_btsetfi_tclMsgSetBTProfilesUsageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgSetBTProfilesUsageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetBTProfilesUsageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgResolveConflictsMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgResolveConflictsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgResolveConflictsMethodStart& operator=(const most_btsetfi_tclMsgResolveConflictsMethodStart& coRef);
   most_btsetfi_tclMsgResolveConflictsMethodStart(const most_btsetfi_tclMsgResolveConflictsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTConflictTrigger e8ConflictTrigger;
   most_fi_tcl_e8_BTResolutionType e8ResolutionType;
   virtual ~most_btsetfi_tclMsgResolveConflictsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgResolveConflictsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgResolveConflictsError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgResolveConflictsError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgResolveConflictsError& operator=(const most_btsetfi_tclMsgResolveConflictsError& coRef);
   most_btsetfi_tclMsgResolveConflictsError(const most_btsetfi_tclMsgResolveConflictsError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgResolveConflictsError();

   tBool operator==(const most_btsetfi_tclMsgResolveConflictsError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgResolveConflictsMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgResolveConflictsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgResolveConflictsMethodResult& operator=(const most_btsetfi_tclMsgResolveConflictsMethodResult& coRef);
   most_btsetfi_tclMsgResolveConflictsMethodResult(const most_btsetfi_tclMsgResolveConflictsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgResolveConflictsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgResolveConflictsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart& operator=(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart& coRef);
   most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_e8_BTSetUsagePreference e8DeviceUsagePreference;
   virtual ~most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetDeviceUsagePreferenceError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSetDeviceUsagePreferenceError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetDeviceUsagePreferenceError& operator=(const most_btsetfi_tclMsgSetDeviceUsagePreferenceError& coRef);
   most_btsetfi_tclMsgSetDeviceUsagePreferenceError(const most_btsetfi_tclMsgSetDeviceUsagePreferenceError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSetDeviceUsagePreferenceError();

   tBool operator==(const most_btsetfi_tclMsgSetDeviceUsagePreferenceError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult& operator=(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult& coRef);
   most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart& operator=(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart& coRef);
   most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTProfile e8Profile;
   most_fi_tcl_e8_BTUserAvailable e8UserAvailable;
   virtual ~most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetProfileUserAvailabilityError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSetProfileUserAvailabilityError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetProfileUserAvailabilityError& operator=(const most_btsetfi_tclMsgSetProfileUserAvailabilityError& coRef);
   most_btsetfi_tclMsgSetProfileUserAvailabilityError(const most_btsetfi_tclMsgSetProfileUserAvailabilityError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSetProfileUserAvailabilityError();

   tBool operator==(const most_btsetfi_tclMsgSetProfileUserAvailabilityError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult& operator=(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult& coRef);
   most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart& operator=(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart& coRef);
   most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTLimitationModeListItem oLimitationModeToBeReplaced;
   most_fi_tcl_BTLimitationMode oNewLimitationMode;
   virtual ~most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgReplaceBluetoothLimitationModeError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgReplaceBluetoothLimitationModeError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgReplaceBluetoothLimitationModeError& operator=(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeError& coRef);
   most_btsetfi_tclMsgReplaceBluetoothLimitationModeError(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgReplaceBluetoothLimitationModeError();

   tBool operator==(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult& operator=(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult& coRef);
   most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothOnOffUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothOnOffUpReg();

   virtual ~most_btsetfi_tclMsgBluetoothOnOffUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgBluetoothOnOffUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothOnOffRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothOnOffRelUpReg();

   virtual ~most_btsetfi_tclMsgBluetoothOnOffRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgBluetoothOnOffRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothOnOffGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothOnOffGet();

   virtual ~most_btsetfi_tclMsgBluetoothOnOffGet();

   inline tBool operator==(const most_btsetfi_tclMsgBluetoothOnOffGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothOnOffSet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothOnOffSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgBluetoothOnOffSet& operator=(const most_btsetfi_tclMsgBluetoothOnOffSet& coRef);
   most_btsetfi_tclMsgBluetoothOnOffSet(const most_btsetfi_tclMsgBluetoothOnOffSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bBTOnOff;
   virtual ~most_btsetfi_tclMsgBluetoothOnOffSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgBluetoothOnOffSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothOnOffError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgBluetoothOnOffError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgBluetoothOnOffError& operator=(const most_btsetfi_tclMsgBluetoothOnOffError& coRef);
   most_btsetfi_tclMsgBluetoothOnOffError(const most_btsetfi_tclMsgBluetoothOnOffError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgBluetoothOnOffError();

   tBool operator==(const most_btsetfi_tclMsgBluetoothOnOffError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothOnOffStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothOnOffStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgBluetoothOnOffStatus& operator=(const most_btsetfi_tclMsgBluetoothOnOffStatus& coRef);
   most_btsetfi_tclMsgBluetoothOnOffStatus(const most_btsetfi_tclMsgBluetoothOnOffStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bBTOnOff;
   virtual ~most_btsetfi_tclMsgBluetoothOnOffStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgBluetoothOnOffStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingStatusUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingStatusUpReg();

   virtual ~most_btsetfi_tclMsgPairingStatusUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgPairingStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingStatusRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingStatusRelUpReg();

   virtual ~most_btsetfi_tclMsgPairingStatusRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgPairingStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingStatusGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingStatusGet();

   virtual ~most_btsetfi_tclMsgPairingStatusGet();

   inline tBool operator==(const most_btsetfi_tclMsgPairingStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingStatusError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgPairingStatusError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairingStatusError& operator=(const most_btsetfi_tclMsgPairingStatusError& coRef);
   most_btsetfi_tclMsgPairingStatusError(const most_btsetfi_tclMsgPairingStatusError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgPairingStatusError();

   tBool operator==(const most_btsetfi_tclMsgPairingStatusError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingStatusStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairingStatusStatus& operator=(const most_btsetfi_tclMsgPairingStatusStatus& coRef);
   most_btsetfi_tclMsgPairingStatusStatus(const most_btsetfi_tclMsgPairingStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSetPairingStatusType e8PairingStatusType;
   tU8 u8DeviceHandle;
   most_fi_tcl_String sDeviceName;
   virtual ~most_btsetfi_tclMsgPairingStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgPairingStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeRingtoneUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangeRingtoneUpReg();

   virtual ~most_btsetfi_tclMsgChangeRingtoneUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgChangeRingtoneUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeRingtoneRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangeRingtoneRelUpReg();

   virtual ~most_btsetfi_tclMsgChangeRingtoneRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgChangeRingtoneRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeRingtonePureSet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangeRingtonePureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangeRingtonePureSet& operator=(const most_btsetfi_tclMsgChangeRingtonePureSet& coRef);
   most_btsetfi_tclMsgChangeRingtonePureSet(const most_btsetfi_tclMsgChangeRingtonePureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU16 u16RingtoneID;
   virtual ~most_btsetfi_tclMsgChangeRingtonePureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgChangeRingtonePureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeRingtoneError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgChangeRingtoneError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangeRingtoneError& operator=(const most_btsetfi_tclMsgChangeRingtoneError& coRef);
   most_btsetfi_tclMsgChangeRingtoneError(const most_btsetfi_tclMsgChangeRingtoneError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgChangeRingtoneError();

   tBool operator==(const most_btsetfi_tclMsgChangeRingtoneError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgChangeRingtoneStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgChangeRingtoneStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgChangeRingtoneStatus& operator=(const most_btsetfi_tclMsgChangeRingtoneStatus& coRef);
   most_btsetfi_tclMsgChangeRingtoneStatus(const most_btsetfi_tclMsgChangeRingtoneStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   tU16 u16RingtoneID;
   most_fi_tcl_String sRingtoneName;
   virtual ~most_btsetfi_tclMsgChangeRingtoneStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgChangeRingtoneStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg();

   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg();

   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNameGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNameGet();

   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNameGet();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNameGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNameError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNameError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleBTFriendlyNameError& operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNameError& coRef);
   most_btsetfi_tclMsgVehicleBTFriendlyNameError(const most_btsetfi_tclMsgVehicleBTFriendlyNameError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNameError();

   tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNameError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNameStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNameStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleBTFriendlyNameStatus& operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNameStatus& coRef);
   most_btsetfi_tclMsgVehicleBTFriendlyNameStatus(const most_btsetfi_tclMsgVehicleBTFriendlyNameStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sVehicleBTFriendlyName;
   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNameStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNameStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothAudioSourceUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothAudioSourceUpReg();

   virtual ~most_btsetfi_tclMsgBluetoothAudioSourceUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgBluetoothAudioSourceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg();

   virtual ~most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothAudioSourceGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothAudioSourceGet();

   virtual ~most_btsetfi_tclMsgBluetoothAudioSourceGet();

   inline tBool operator==(const most_btsetfi_tclMsgBluetoothAudioSourceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothAudioSourcePureSet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothAudioSourcePureSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgBluetoothAudioSourcePureSet& operator=(const most_btsetfi_tclMsgBluetoothAudioSourcePureSet& coRef);
   most_btsetfi_tclMsgBluetoothAudioSourcePureSet(const most_btsetfi_tclMsgBluetoothAudioSourcePureSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   virtual ~most_btsetfi_tclMsgBluetoothAudioSourcePureSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgBluetoothAudioSourcePureSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothAudioSourceStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothAudioSourceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgBluetoothAudioSourceStatus& operator=(const most_btsetfi_tclMsgBluetoothAudioSourceStatus& coRef);
   most_btsetfi_tclMsgBluetoothAudioSourceStatus(const most_btsetfi_tclMsgBluetoothAudioSourceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_BTSetDeviceControlSupport oDeviceControlSupport;
   virtual ~most_btsetfi_tclMsgBluetoothAudioSourceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgBluetoothAudioSourceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingPinUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingPinUpReg();

   virtual ~most_btsetfi_tclMsgPairingPinUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgPairingPinUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingPinRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingPinRelUpReg();

   virtual ~most_btsetfi_tclMsgPairingPinRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgPairingPinRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingPinGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingPinGet();

   virtual ~most_btsetfi_tclMsgPairingPinGet();

   inline tBool operator==(const most_btsetfi_tclMsgPairingPinGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingPinStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingPinStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairingPinStatus& operator=(const most_btsetfi_tclMsgPairingPinStatus& coRef);
   most_btsetfi_tclMsgPairingPinStatus(const most_btsetfi_tclMsgPairingPinStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sPinNumber;
   virtual ~most_btsetfi_tclMsgPairingPinStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgPairingPinStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMaxDevicesPairedUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgMaxDevicesPairedUpReg();

   virtual ~most_btsetfi_tclMsgMaxDevicesPairedUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgMaxDevicesPairedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMaxDevicesPairedRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgMaxDevicesPairedRelUpReg();

   virtual ~most_btsetfi_tclMsgMaxDevicesPairedRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgMaxDevicesPairedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMaxDevicesPairedGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgMaxDevicesPairedGet();

   virtual ~most_btsetfi_tclMsgMaxDevicesPairedGet();

   inline tBool operator==(const most_btsetfi_tclMsgMaxDevicesPairedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMaxDevicesPairedError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgMaxDevicesPairedError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgMaxDevicesPairedError& operator=(const most_btsetfi_tclMsgMaxDevicesPairedError& coRef);
   most_btsetfi_tclMsgMaxDevicesPairedError(const most_btsetfi_tclMsgMaxDevicesPairedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgMaxDevicesPairedError();

   tBool operator==(const most_btsetfi_tclMsgMaxDevicesPairedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMaxDevicesPairedStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgMaxDevicesPairedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgMaxDevicesPairedStatus& operator=(const most_btsetfi_tclMsgMaxDevicesPairedStatus& coRef);
   most_btsetfi_tclMsgMaxDevicesPairedStatus(const most_btsetfi_tclMsgMaxDevicesPairedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceHandle;
   most_fi_tcl_String sDeviceName;
   virtual ~most_btsetfi_tclMsgMaxDevicesPairedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgMaxDevicesPairedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectOnOffUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAutoConnectOnOffUpReg();

   virtual ~most_btsetfi_tclMsgAutoConnectOnOffUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgAutoConnectOnOffUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectOnOffRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAutoConnectOnOffRelUpReg();

   virtual ~most_btsetfi_tclMsgAutoConnectOnOffRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgAutoConnectOnOffRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectOnOffSet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAutoConnectOnOffSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAutoConnectOnOffSet& operator=(const most_btsetfi_tclMsgAutoConnectOnOffSet& coRef);
   most_btsetfi_tclMsgAutoConnectOnOffSet(const most_btsetfi_tclMsgAutoConnectOnOffSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAutoConnectOnOff;
   virtual ~most_btsetfi_tclMsgAutoConnectOnOffSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgAutoConnectOnOffSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectOnOffError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgAutoConnectOnOffError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAutoConnectOnOffError& operator=(const most_btsetfi_tclMsgAutoConnectOnOffError& coRef);
   most_btsetfi_tclMsgAutoConnectOnOffError(const most_btsetfi_tclMsgAutoConnectOnOffError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgAutoConnectOnOffError();

   tBool operator==(const most_btsetfi_tclMsgAutoConnectOnOffError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectOnOffGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAutoConnectOnOffGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAutoConnectOnOffGet& operator=(const most_btsetfi_tclMsgAutoConnectOnOffGet& coRef);
   most_btsetfi_tclMsgAutoConnectOnOffGet(const most_btsetfi_tclMsgAutoConnectOnOffGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAutoConnectOnOff;
   virtual ~most_btsetfi_tclMsgAutoConnectOnOffGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgAutoConnectOnOffGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectOnOffStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAutoConnectOnOffStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAutoConnectOnOffStatus& operator=(const most_btsetfi_tclMsgAutoConnectOnOffStatus& coRef);
   most_btsetfi_tclMsgAutoConnectOnOffStatus(const most_btsetfi_tclMsgAutoConnectOnOffStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAutoConnectOnOff;
   virtual ~most_btsetfi_tclMsgAutoConnectOnOffStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgAutoConnectOnOffStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTAddressUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTAddressUpReg();

   virtual ~most_btsetfi_tclMsgVehicleBTAddressUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleBTAddressUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTAddressRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTAddressRelUpReg();

   virtual ~most_btsetfi_tclMsgVehicleBTAddressRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleBTAddressRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTAddressGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTAddressGet();

   virtual ~most_btsetfi_tclMsgVehicleBTAddressGet();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleBTAddressGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTAddressError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgVehicleBTAddressError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleBTAddressError& operator=(const most_btsetfi_tclMsgVehicleBTAddressError& coRef);
   most_btsetfi_tclMsgVehicleBTAddressError(const most_btsetfi_tclMsgVehicleBTAddressError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgVehicleBTAddressError();

   tBool operator==(const most_btsetfi_tclMsgVehicleBTAddressError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTAddressStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTAddressStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleBTAddressStatus& operator=(const most_btsetfi_tclMsgVehicleBTAddressStatus& coRef);
   most_btsetfi_tclMsgVehicleBTAddressStatus(const most_btsetfi_tclMsgVehicleBTAddressStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sVehicleBTAddress;
   virtual ~most_btsetfi_tclMsgVehicleBTAddressStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgVehicleBTAddressStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg();

   virtual ~most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg();

   virtual ~most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleSupportedBTProfilesGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleSupportedBTProfilesGet();

   virtual ~most_btsetfi_tclMsgVehicleSupportedBTProfilesGet();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleSupportedBTProfilesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleSupportedBTProfilesError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgVehicleSupportedBTProfilesError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleSupportedBTProfilesError& operator=(const most_btsetfi_tclMsgVehicleSupportedBTProfilesError& coRef);
   most_btsetfi_tclMsgVehicleSupportedBTProfilesError(const most_btsetfi_tclMsgVehicleSupportedBTProfilesError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgVehicleSupportedBTProfilesError();

   tBool operator==(const most_btsetfi_tclMsgVehicleSupportedBTProfilesError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus& operator=(const most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus& coRef);
   most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus(const most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTSetSupportedProfiles oSupportedProfiles;
   virtual ~most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg();

   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg();

   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet();

   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet& operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet& coRef);
   most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sVehicleBTFriendlyName;
   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNamesetError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNamesetError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleBTFriendlyNamesetError& operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetError& coRef);
   most_btsetfi_tclMsgVehicleBTFriendlyNamesetError(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNamesetError();

   tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus& operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus& coRef);
   most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sVehicleBTFriendlyName;
   virtual ~most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingRequestUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingRequestUpReg();

   virtual ~most_btsetfi_tclMsgPairingRequestUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgPairingRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingRequestRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingRequestRelUpReg();

   virtual ~most_btsetfi_tclMsgPairingRequestRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgPairingRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingRequestGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingRequestGet();

   virtual ~most_btsetfi_tclMsgPairingRequestGet();

   inline tBool operator==(const most_btsetfi_tclMsgPairingRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingRequestError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgPairingRequestError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairingRequestError& operator=(const most_btsetfi_tclMsgPairingRequestError& coRef);
   most_btsetfi_tclMsgPairingRequestError(const most_btsetfi_tclMsgPairingRequestError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgPairingRequestError();

   tBool operator==(const most_btsetfi_tclMsgPairingRequestError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairingRequestStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairingRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairingRequestStatus& operator=(const most_btsetfi_tclMsgPairingRequestStatus& coRef);
   most_btsetfi_tclMsgPairingRequestStatus(const most_btsetfi_tclMsgPairingRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sDeviceName;
   most_fi_tcl_String sRemoteDeviceAddress;
   most_fi_tcl_String sPinNumber;
   most_fi_tcl_e8_BTSetPairingType e8PairingType;
   most_fi_tcl_e8_BTSetOrigin e8Origin;
   virtual ~most_btsetfi_tclMsgPairingRequestStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgPairingRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDeviceListExtendedUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgDeviceListExtendedUpReg();

   virtual ~most_btsetfi_tclMsgDeviceListExtendedUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgDeviceListExtendedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDeviceListExtendedRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgDeviceListExtendedRelUpReg();

   virtual ~most_btsetfi_tclMsgDeviceListExtendedRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgDeviceListExtendedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDeviceListExtendedGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgDeviceListExtendedGet();

   virtual ~most_btsetfi_tclMsgDeviceListExtendedGet();

   inline tBool operator==(const most_btsetfi_tclMsgDeviceListExtendedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDeviceListExtendedError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgDeviceListExtendedError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgDeviceListExtendedError& operator=(const most_btsetfi_tclMsgDeviceListExtendedError& coRef);
   most_btsetfi_tclMsgDeviceListExtendedError(const most_btsetfi_tclMsgDeviceListExtendedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgDeviceListExtendedError();

   tBool operator==(const most_btsetfi_tclMsgDeviceListExtendedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgDeviceListExtendedStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgDeviceListExtendedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgDeviceListExtendedStatus& operator=(const most_btsetfi_tclMsgDeviceListExtendedStatus& coRef);
   most_btsetfi_tclMsgDeviceListExtendedStatus(const most_btsetfi_tclMsgDeviceListExtendedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTSetDeviceListChangeExtended oDeviceListChange;
   tU8 u8NumPairedDevices;
   most_fi_tcl_BTSetDeviceListExtendedResult oDeviceListExtendedResult;
   virtual ~most_btsetfi_tclMsgDeviceListExtendedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgDeviceListExtendedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVisibleDevicesUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVisibleDevicesUpReg();

   virtual ~most_btsetfi_tclMsgVisibleDevicesUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVisibleDevicesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVisibleDevicesRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVisibleDevicesRelUpReg();

   virtual ~most_btsetfi_tclMsgVisibleDevicesRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVisibleDevicesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVisibleDevicesGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVisibleDevicesGet();

   virtual ~most_btsetfi_tclMsgVisibleDevicesGet();

   inline tBool operator==(const most_btsetfi_tclMsgVisibleDevicesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVisibleDevicesError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgVisibleDevicesError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVisibleDevicesError& operator=(const most_btsetfi_tclMsgVisibleDevicesError& coRef);
   most_btsetfi_tclMsgVisibleDevicesError(const most_btsetfi_tclMsgVisibleDevicesError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgVisibleDevicesError();

   tBool operator==(const most_btsetfi_tclMsgVisibleDevicesError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVisibleDevicesStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVisibleDevicesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVisibleDevicesStatus& operator=(const most_btsetfi_tclMsgVisibleDevicesStatus& coRef);
   most_btsetfi_tclMsgVisibleDevicesStatus(const most_btsetfi_tclMsgVisibleDevicesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumVisibleDevices;
   most_fi_tcl_BTSetVisibleDevicesList oVisibleDevicesList;
   virtual ~most_btsetfi_tclMsgVisibleDevicesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgVisibleDevicesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairableModeUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairableModeUpReg();

   virtual ~most_btsetfi_tclMsgPairableModeUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgPairableModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairableModeRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairableModeRelUpReg();

   virtual ~most_btsetfi_tclMsgPairableModeRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgPairableModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairableModeGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairableModeGet();

   virtual ~most_btsetfi_tclMsgPairableModeGet();

   inline tBool operator==(const most_btsetfi_tclMsgPairableModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairableModeError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgPairableModeError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairableModeError& operator=(const most_btsetfi_tclMsgPairableModeError& coRef);
   most_btsetfi_tclMsgPairableModeError(const most_btsetfi_tclMsgPairableModeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgPairableModeError();

   tBool operator==(const most_btsetfi_tclMsgPairableModeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgPairableModeStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgPairableModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgPairableModeStatus& operator=(const most_btsetfi_tclMsgPairableModeStatus& coRef);
   most_btsetfi_tclMsgPairableModeStatus(const most_btsetfi_tclMsgPairableModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Pairable;
   tBool Connectable;
   tBool PairingInProgress;
   most_fi_tcl_String sBTAddress;
   virtual ~most_btsetfi_tclMsgPairableModeStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgPairableModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSignalStrengthUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSignalStrengthUpReg();

   virtual ~most_btsetfi_tclMsgSignalStrengthUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgSignalStrengthUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSignalStrengthRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSignalStrengthRelUpReg();

   virtual ~most_btsetfi_tclMsgSignalStrengthRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgSignalStrengthRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSignalStrengthGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSignalStrengthGet();

   virtual ~most_btsetfi_tclMsgSignalStrengthGet();

   inline tBool operator==(const most_btsetfi_tclMsgSignalStrengthGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSignalStrengthError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSignalStrengthError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSignalStrengthError& operator=(const most_btsetfi_tclMsgSignalStrengthError& coRef);
   most_btsetfi_tclMsgSignalStrengthError(const most_btsetfi_tclMsgSignalStrengthError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSignalStrengthError();

   tBool operator==(const most_btsetfi_tclMsgSignalStrengthError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSignalStrengthStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSignalStrengthStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSignalStrengthStatus& operator=(const most_btsetfi_tclMsgSignalStrengthStatus& coRef);
   most_btsetfi_tclMsgSignalStrengthStatus(const most_btsetfi_tclMsgSignalStrengthStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTSetSignalStrengthList oSignalStrengthList;
   virtual ~most_btsetfi_tclMsgSignalStrengthStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSignalStrengthStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSPPServiceConnectionUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSPPServiceConnectionUpReg();

   virtual ~most_btsetfi_tclMsgSPPServiceConnectionUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgSPPServiceConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSPPServiceConnectionRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSPPServiceConnectionRelUpReg();

   virtual ~most_btsetfi_tclMsgSPPServiceConnectionRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgSPPServiceConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSPPServiceConnectionGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSPPServiceConnectionGet();

   virtual ~most_btsetfi_tclMsgSPPServiceConnectionGet();

   inline tBool operator==(const most_btsetfi_tclMsgSPPServiceConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSPPServiceConnectionError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgSPPServiceConnectionError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSPPServiceConnectionError& operator=(const most_btsetfi_tclMsgSPPServiceConnectionError& coRef);
   most_btsetfi_tclMsgSPPServiceConnectionError(const most_btsetfi_tclMsgSPPServiceConnectionError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgSPPServiceConnectionError();

   tBool operator==(const most_btsetfi_tclMsgSPPServiceConnectionError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgSPPServiceConnectionStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgSPPServiceConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgSPPServiceConnectionStatus& operator=(const most_btsetfi_tclMsgSPPServiceConnectionStatus& coRef);
   most_btsetfi_tclMsgSPPServiceConnectionStatus(const most_btsetfi_tclMsgSPPServiceConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTSPPServiceConnectionStatusList oSPPServiceConnectionStatusList;
   virtual ~most_btsetfi_tclMsgSPPServiceConnectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgSPPServiceConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothLimitationModeUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothLimitationModeUpReg();

   virtual ~most_btsetfi_tclMsgBluetoothLimitationModeUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgBluetoothLimitationModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg();

   virtual ~most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothLimitationModeGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothLimitationModeGet();

   virtual ~most_btsetfi_tclMsgBluetoothLimitationModeGet();

   inline tBool operator==(const most_btsetfi_tclMsgBluetoothLimitationModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothLimitationModeError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgBluetoothLimitationModeError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgBluetoothLimitationModeError& operator=(const most_btsetfi_tclMsgBluetoothLimitationModeError& coRef);
   most_btsetfi_tclMsgBluetoothLimitationModeError(const most_btsetfi_tclMsgBluetoothLimitationModeError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgBluetoothLimitationModeError();

   tBool operator==(const most_btsetfi_tclMsgBluetoothLimitationModeError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBluetoothLimitationModeStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBluetoothLimitationModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgBluetoothLimitationModeStatus& operator=(const most_btsetfi_tclMsgBluetoothLimitationModeStatus& coRef);
   most_btsetfi_tclMsgBluetoothLimitationModeStatus(const most_btsetfi_tclMsgBluetoothLimitationModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTLimitationModeList oList;
   virtual ~most_btsetfi_tclMsgBluetoothLimitationModeStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgBluetoothLimitationModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMultiHFPSupportUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgMultiHFPSupportUpReg();

   virtual ~most_btsetfi_tclMsgMultiHFPSupportUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgMultiHFPSupportUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMultiHFPSupportRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgMultiHFPSupportRelUpReg();

   virtual ~most_btsetfi_tclMsgMultiHFPSupportRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgMultiHFPSupportRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMultiHFPSupportGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgMultiHFPSupportGet();

   virtual ~most_btsetfi_tclMsgMultiHFPSupportGet();

   inline tBool operator==(const most_btsetfi_tclMsgMultiHFPSupportGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMultiHFPSupportError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgMultiHFPSupportError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgMultiHFPSupportError& operator=(const most_btsetfi_tclMsgMultiHFPSupportError& coRef);
   most_btsetfi_tclMsgMultiHFPSupportError(const most_btsetfi_tclMsgMultiHFPSupportError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgMultiHFPSupportError();

   tBool operator==(const most_btsetfi_tclMsgMultiHFPSupportError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgMultiHFPSupportStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgMultiHFPSupportStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgMultiHFPSupportStatus& operator=(const most_btsetfi_tclMsgMultiHFPSupportStatus& coRef);
   most_btsetfi_tclMsgMultiHFPSupportStatus(const most_btsetfi_tclMsgMultiHFPSupportStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTSwitchStatus e8MultiHFPSupport;
   virtual ~most_btsetfi_tclMsgMultiHFPSupportStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgMultiHFPSupportStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBTProfilesUsageInfoUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBTProfilesUsageInfoUpReg();

   virtual ~most_btsetfi_tclMsgBTProfilesUsageInfoUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgBTProfilesUsageInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg();

   virtual ~most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBTProfilesUsageInfoGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBTProfilesUsageInfoGet();

   virtual ~most_btsetfi_tclMsgBTProfilesUsageInfoGet();

   inline tBool operator==(const most_btsetfi_tclMsgBTProfilesUsageInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBTProfilesUsageInfoError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgBTProfilesUsageInfoError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgBTProfilesUsageInfoError& operator=(const most_btsetfi_tclMsgBTProfilesUsageInfoError& coRef);
   most_btsetfi_tclMsgBTProfilesUsageInfoError(const most_btsetfi_tclMsgBTProfilesUsageInfoError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgBTProfilesUsageInfoError();

   tBool operator==(const most_btsetfi_tclMsgBTProfilesUsageInfoError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgBTProfilesUsageInfoStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgBTProfilesUsageInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgBTProfilesUsageInfoStatus& operator=(const most_btsetfi_tclMsgBTProfilesUsageInfoStatus& coRef);
   most_btsetfi_tclMsgBTProfilesUsageInfoStatus(const most_btsetfi_tclMsgBTProfilesUsageInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_BTProfilesUsageList oBTProfilesUsageInfoList;
   virtual ~most_btsetfi_tclMsgBTProfilesUsageInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgBTProfilesUsageInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConflictsDetectedUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgConflictsDetectedUpReg();

   virtual ~most_btsetfi_tclMsgConflictsDetectedUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgConflictsDetectedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConflictsDetectedRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgConflictsDetectedRelUpReg();

   virtual ~most_btsetfi_tclMsgConflictsDetectedRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgConflictsDetectedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConflictsDetectedGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgConflictsDetectedGet();

   virtual ~most_btsetfi_tclMsgConflictsDetectedGet();

   inline tBool operator==(const most_btsetfi_tclMsgConflictsDetectedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConflictsDetectedError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgConflictsDetectedError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgConflictsDetectedError& operator=(const most_btsetfi_tclMsgConflictsDetectedError& coRef);
   most_btsetfi_tclMsgConflictsDetectedError(const most_btsetfi_tclMsgConflictsDetectedError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgConflictsDetectedError();

   tBool operator==(const most_btsetfi_tclMsgConflictsDetectedError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgConflictsDetectedStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgConflictsDetectedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgConflictsDetectedStatus& operator=(const most_btsetfi_tclMsgConflictsDetectedStatus& coRef);
   most_btsetfi_tclMsgConflictsDetectedStatus(const most_btsetfi_tclMsgConflictsDetectedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTConflictTrigger e8ConflictTrigger;
   most_fi_tcl_BTConflictInfoList oBTConflictInfoList;
   virtual ~most_btsetfi_tclMsgConflictsDetectedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgConflictsDetectedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectionStatusUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAutoConnectionStatusUpReg();

   virtual ~most_btsetfi_tclMsgAutoConnectionStatusUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgAutoConnectionStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectionStatusRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAutoConnectionStatusRelUpReg();

   virtual ~most_btsetfi_tclMsgAutoConnectionStatusRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgAutoConnectionStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectionStatusGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAutoConnectionStatusGet();

   virtual ~most_btsetfi_tclMsgAutoConnectionStatusGet();

   inline tBool operator==(const most_btsetfi_tclMsgAutoConnectionStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectionStatusError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgAutoConnectionStatusError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAutoConnectionStatusError& operator=(const most_btsetfi_tclMsgAutoConnectionStatusError& coRef);
   most_btsetfi_tclMsgAutoConnectionStatusError(const most_btsetfi_tclMsgAutoConnectionStatusError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgAutoConnectionStatusError();

   tBool operator==(const most_btsetfi_tclMsgAutoConnectionStatusError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgAutoConnectionStatusStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgAutoConnectionStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgAutoConnectionStatusStatus& operator=(const most_btsetfi_tclMsgAutoConnectionStatusStatus& coRef);
   most_btsetfi_tclMsgAutoConnectionStatusStatus(const most_btsetfi_tclMsgAutoConnectionStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTAutoconnectionStatus e8AutoConnectionStatus;
   tU8 u8DeviceHandle;
   virtual ~most_btsetfi_tclMsgAutoConnectionStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgAutoConnectionStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgServiceAvailableUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgServiceAvailableUpReg();

   virtual ~most_btsetfi_tclMsgServiceAvailableUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgServiceAvailableUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgServiceAvailableRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgServiceAvailableRelUpReg();

   virtual ~most_btsetfi_tclMsgServiceAvailableRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgServiceAvailableRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgServiceAvailableGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgServiceAvailableGet();

   virtual ~most_btsetfi_tclMsgServiceAvailableGet();

   inline tBool operator==(const most_btsetfi_tclMsgServiceAvailableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgServiceAvailableError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgServiceAvailableError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgServiceAvailableError& operator=(const most_btsetfi_tclMsgServiceAvailableError& coRef);
   most_btsetfi_tclMsgServiceAvailableError(const most_btsetfi_tclMsgServiceAvailableError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgServiceAvailableError();

   tBool operator==(const most_btsetfi_tclMsgServiceAvailableError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgServiceAvailableStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgServiceAvailableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgServiceAvailableStatus& operator=(const most_btsetfi_tclMsgServiceAvailableStatus& coRef);
   most_btsetfi_tclMsgServiceAvailableStatus(const most_btsetfi_tclMsgServiceAvailableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_e8_BTServiceAvailable e8ServiceAvailable;
   virtual ~most_btsetfi_tclMsgServiceAvailableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgServiceAvailableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleConfigurationUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleConfigurationUpReg();

   virtual ~most_btsetfi_tclMsgVehicleConfigurationUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleConfigurationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleConfigurationRelUpReg : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleConfigurationRelUpReg();

   virtual ~most_btsetfi_tclMsgVehicleConfigurationRelUpReg();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleConfigurationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleConfigurationGet : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleConfigurationGet();

   virtual ~most_btsetfi_tclMsgVehicleConfigurationGet();

   inline tBool operator==(const most_btsetfi_tclMsgVehicleConfigurationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleConfigurationError : public most_btsetfi_tclMsgDefaultError
{
public:

   most_btsetfi_tclMsgVehicleConfigurationError() : most_btsetfi_tclMsgDefaultError() {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleConfigurationError& operator=(const most_btsetfi_tclMsgVehicleConfigurationError& coRef);
   most_btsetfi_tclMsgVehicleConfigurationError(const most_btsetfi_tclMsgVehicleConfigurationError& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   virtual ~most_btsetfi_tclMsgVehicleConfigurationError();

   tBool operator==(const most_btsetfi_tclMsgVehicleConfigurationError& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class most_btsetfi_tclMsgVehicleConfigurationStatus : public most_btsetfi_tclMsgBaseMessage
{
public:

   most_btsetfi_tclMsgVehicleConfigurationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   most_btsetfi_tclMsgVehicleConfigurationStatus& operator=(const most_btsetfi_tclMsgVehicleConfigurationStatus& coRef);
   most_btsetfi_tclMsgVehicleConfigurationStatus(const most_btsetfi_tclMsgVehicleConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   most_fi_tcl_String sVehicleBTFriendlyName;
   most_fi_tcl_String sVehicleBTAddress;
   most_fi_tcl_BTSetSupportedProfiles oVehicleSupportedProfiles;
   most_fi_tcl_BTSetDeviceIdentification oVehicleIdentification;
   virtual ~most_btsetfi_tclMsgVehicleConfigurationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const most_btsetfi_tclMsgVehicleConfigurationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
