/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO
#include "conn_most_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MOST_BTSet_FI message types

fi_tclMessageBase* most_btsetfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case most_btsetfi_tclToken::EN_MSG_AddNewDeviceMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgAddNewDeviceMethodStart;

      case most_btsetfi_tclToken::EN_MSG_AddNewDeviceMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgAddNewDeviceMethodResult;

      case most_btsetfi_tclToken::EN_MSG_PairingResponseMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgPairingResponseMethodStart;

      case most_btsetfi_tclToken::EN_MSG_PairingResponseMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgPairingResponseMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ChangePinMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgChangePinMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ChangePinMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgChangePinMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ChangeDeviceStateMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgChangeDeviceStateMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ChangeDeviceStateMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgChangeDeviceStateMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ReplaceDeviceMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgReplaceDeviceMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ReplaceDeviceMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgReplaceDeviceMethodResult;

      case most_btsetfi_tclToken::EN_MSG_RequestDeviceRingtoneListMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart;

      case most_btsetfi_tclToken::EN_MSG_RequestDeviceRingtoneListMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult;

      case most_btsetfi_tclToken::EN_MSG_RequestAvailableRingtonesListMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart;

      case most_btsetfi_tclToken::EN_MSG_RequestAvailableRingtonesListMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult;

      case most_btsetfi_tclToken::EN_MSG_PlayRingtoneMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgPlayRingtoneMethodStart;

      case most_btsetfi_tclToken::EN_MSG_PlayRingtoneMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgPlayRingtoneMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ClearDeviceInfoMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgClearDeviceInfoMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ClearDeviceInfoMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgClearDeviceInfoMethodResult;

      case most_btsetfi_tclToken::EN_MSG_GetDeviceInfoExtendedMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart;

      case most_btsetfi_tclToken::EN_MSG_GetDeviceInfoExtendedMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult;

      case most_btsetfi_tclToken::EN_MSG_StopRingtoneMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgStopRingtoneMethodStart;

      case most_btsetfi_tclToken::EN_MSG_StopRingtoneMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgStopRingtoneMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ScanBluetoothDevicesMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgScanBluetoothDevicesMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ScanBluetoothDevicesMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgScanBluetoothDevicesMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ConnectBluetoothProfileMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgConnectBluetoothProfileMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ConnectBluetoothProfileMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgConnectBluetoothProfileMethodResult;

      case most_btsetfi_tclToken::EN_MSG_DisconnectBluetoothProfileMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart;

      case most_btsetfi_tclToken::EN_MSG_DisconnectBluetoothProfileMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SendPairingRequestMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSendPairingRequestMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SendPairingRequestMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSendPairingRequestMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SwitchBTLocalModeMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSwitchBTLocalModeMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SwitchBTLocalModeMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSwitchBTLocalModeMethodResult;

      case most_btsetfi_tclToken::EN_MSG_StartAutoConnectSequenceMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart;

      case most_btsetfi_tclToken::EN_MSG_StartAutoConnectSequenceMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ConnectSPPServiceMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgConnectSPPServiceMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ConnectSPPServiceMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgConnectSPPServiceMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SetBluetoothLimitationModeMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SetBluetoothLimitationModeMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SwitchBluetoothOnOffExtendedMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SwitchBluetoothOnOffExtendedMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ChangeWifiTransmitPowerMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ChangeWifiTransmitPowerMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult;

      case most_btsetfi_tclToken::EN_MSG_DisconnectSPPServiceMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgDisconnectSPPServiceMethodStart;

      case most_btsetfi_tclToken::EN_MSG_DisconnectSPPServiceMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgDisconnectSPPServiceMethodResult;

      case most_btsetfi_tclToken::EN_MSG_StartSearchSPPServicesMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgStartSearchSPPServicesMethodStart;

      case most_btsetfi_tclToken::EN_MSG_StartSearchSPPServicesMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgStartSearchSPPServicesMethodResult;

      case most_btsetfi_tclToken::EN_MSG_StopSearchSPPServicesMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgStopSearchSPPServicesMethodStart;

      case most_btsetfi_tclToken::EN_MSG_StopSearchSPPServicesMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgStopSearchSPPServicesMethodResult;

      case most_btsetfi_tclToken::EN_MSG_AddOobPairedDeviceMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgAddOobPairedDeviceMethodStart;

      case most_btsetfi_tclToken::EN_MSG_AddOobPairedDeviceMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgAddOobPairedDeviceMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SetFavoriteMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSetFavoriteMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SetFavoriteMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSetFavoriteMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ClearFavoriteMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgClearFavoriteMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ClearFavoriteMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgClearFavoriteMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SwitchMultiHFPSupportMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SwitchMultiHFPSupportMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SetPrimaryMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSetPrimaryMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SetPrimaryMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSetPrimaryMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SetBTProfilesUsageMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSetBTProfilesUsageMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SetBTProfilesUsageMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSetBTProfilesUsageMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ResolveConflictsMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgResolveConflictsMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ResolveConflictsMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgResolveConflictsMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SetDeviceUsagePreferenceMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SetDeviceUsagePreferenceMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult;

      case most_btsetfi_tclToken::EN_MSG_SetProfileUserAvailabilityMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart;

      case most_btsetfi_tclToken::EN_MSG_SetProfileUserAvailabilityMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult;

      case most_btsetfi_tclToken::EN_MSG_ReplaceBluetoothLimitationModeMethodStart:
         return OSAL_NEW most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart;

      case most_btsetfi_tclToken::EN_MSG_ReplaceBluetoothLimitationModeMethodResult:
         return OSAL_NEW most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult;

      case most_btsetfi_tclToken::EN_MSG_BluetoothOnOffUpReg:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothOnOffUpReg;

      case most_btsetfi_tclToken::EN_MSG_BluetoothOnOffRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothOnOffRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_BluetoothOnOffGet:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothOnOffGet;

      case most_btsetfi_tclToken::EN_MSG_BluetoothOnOffSet:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothOnOffSet;

      case most_btsetfi_tclToken::EN_MSG_BluetoothOnOffStatus:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothOnOffStatus;

      case most_btsetfi_tclToken::EN_MSG_PairingStatusUpReg:
         return OSAL_NEW most_btsetfi_tclMsgPairingStatusUpReg;

      case most_btsetfi_tclToken::EN_MSG_PairingStatusRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgPairingStatusRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_PairingStatusGet:
         return OSAL_NEW most_btsetfi_tclMsgPairingStatusGet;

      case most_btsetfi_tclToken::EN_MSG_PairingStatusStatus:
         return OSAL_NEW most_btsetfi_tclMsgPairingStatusStatus;

      case most_btsetfi_tclToken::EN_MSG_ChangeRingtoneUpReg:
         return OSAL_NEW most_btsetfi_tclMsgChangeRingtoneUpReg;

      case most_btsetfi_tclToken::EN_MSG_ChangeRingtoneRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgChangeRingtoneRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_ChangeRingtonePureSet:
         return OSAL_NEW most_btsetfi_tclMsgChangeRingtonePureSet;

      case most_btsetfi_tclToken::EN_MSG_ChangeRingtoneStatus:
         return OSAL_NEW most_btsetfi_tclMsgChangeRingtoneStatus;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNameUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNameRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNameGet:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTFriendlyNameGet;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNameStatus:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTFriendlyNameStatus;

      case most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourceUpReg:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothAudioSourceUpReg;

      case most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourceRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourceGet:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothAudioSourceGet;

      case most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourcePureSet:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothAudioSourcePureSet;

      case most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourceStatus:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothAudioSourceStatus;

      case most_btsetfi_tclToken::EN_MSG_PairingPinUpReg:
         return OSAL_NEW most_btsetfi_tclMsgPairingPinUpReg;

      case most_btsetfi_tclToken::EN_MSG_PairingPinRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgPairingPinRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_PairingPinGet:
         return OSAL_NEW most_btsetfi_tclMsgPairingPinGet;

      case most_btsetfi_tclToken::EN_MSG_PairingPinStatus:
         return OSAL_NEW most_btsetfi_tclMsgPairingPinStatus;

      case most_btsetfi_tclToken::EN_MSG_MaxDevicesPairedUpReg:
         return OSAL_NEW most_btsetfi_tclMsgMaxDevicesPairedUpReg;

      case most_btsetfi_tclToken::EN_MSG_MaxDevicesPairedRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgMaxDevicesPairedRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_MaxDevicesPairedGet:
         return OSAL_NEW most_btsetfi_tclMsgMaxDevicesPairedGet;

      case most_btsetfi_tclToken::EN_MSG_MaxDevicesPairedStatus:
         return OSAL_NEW most_btsetfi_tclMsgMaxDevicesPairedStatus;

      case most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffUpReg:
         return OSAL_NEW most_btsetfi_tclMsgAutoConnectOnOffUpReg;

      case most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgAutoConnectOnOffRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffSet:
         return OSAL_NEW most_btsetfi_tclMsgAutoConnectOnOffSet;

      case most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffGet:
         return OSAL_NEW most_btsetfi_tclMsgAutoConnectOnOffGet;

      case most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffStatus:
         return OSAL_NEW most_btsetfi_tclMsgAutoConnectOnOffStatus;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTAddressUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTAddressUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTAddressRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTAddressRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTAddressGet:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTAddressGet;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTAddressStatus:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTAddressStatus;

      case most_btsetfi_tclToken::EN_MSG_VehicleSupportedBTProfilesUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleSupportedBTProfilesRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleSupportedBTProfilesGet:
         return OSAL_NEW most_btsetfi_tclMsgVehicleSupportedBTProfilesGet;

      case most_btsetfi_tclToken::EN_MSG_VehicleSupportedBTProfilesStatus:
         return OSAL_NEW most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetGet:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetSet:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet;

      case most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetStatus:
         return OSAL_NEW most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus;

      case most_btsetfi_tclToken::EN_MSG_PairingRequestUpReg:
         return OSAL_NEW most_btsetfi_tclMsgPairingRequestUpReg;

      case most_btsetfi_tclToken::EN_MSG_PairingRequestRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgPairingRequestRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_PairingRequestGet:
         return OSAL_NEW most_btsetfi_tclMsgPairingRequestGet;

      case most_btsetfi_tclToken::EN_MSG_PairingRequestStatus:
         return OSAL_NEW most_btsetfi_tclMsgPairingRequestStatus;

      case most_btsetfi_tclToken::EN_MSG_DeviceListExtendedUpReg:
         return OSAL_NEW most_btsetfi_tclMsgDeviceListExtendedUpReg;

      case most_btsetfi_tclToken::EN_MSG_DeviceListExtendedRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgDeviceListExtendedRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_DeviceListExtendedGet:
         return OSAL_NEW most_btsetfi_tclMsgDeviceListExtendedGet;

      case most_btsetfi_tclToken::EN_MSG_DeviceListExtendedStatus:
         return OSAL_NEW most_btsetfi_tclMsgDeviceListExtendedStatus;

      case most_btsetfi_tclToken::EN_MSG_VisibleDevicesUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVisibleDevicesUpReg;

      case most_btsetfi_tclToken::EN_MSG_VisibleDevicesRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVisibleDevicesRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_VisibleDevicesGet:
         return OSAL_NEW most_btsetfi_tclMsgVisibleDevicesGet;

      case most_btsetfi_tclToken::EN_MSG_VisibleDevicesStatus:
         return OSAL_NEW most_btsetfi_tclMsgVisibleDevicesStatus;

      case most_btsetfi_tclToken::EN_MSG_PairableModeUpReg:
         return OSAL_NEW most_btsetfi_tclMsgPairableModeUpReg;

      case most_btsetfi_tclToken::EN_MSG_PairableModeRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgPairableModeRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_PairableModeGet:
         return OSAL_NEW most_btsetfi_tclMsgPairableModeGet;

      case most_btsetfi_tclToken::EN_MSG_PairableModeStatus:
         return OSAL_NEW most_btsetfi_tclMsgPairableModeStatus;

      case most_btsetfi_tclToken::EN_MSG_SignalStrengthUpReg:
         return OSAL_NEW most_btsetfi_tclMsgSignalStrengthUpReg;

      case most_btsetfi_tclToken::EN_MSG_SignalStrengthRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgSignalStrengthRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_SignalStrengthGet:
         return OSAL_NEW most_btsetfi_tclMsgSignalStrengthGet;

      case most_btsetfi_tclToken::EN_MSG_SignalStrengthStatus:
         return OSAL_NEW most_btsetfi_tclMsgSignalStrengthStatus;

      case most_btsetfi_tclToken::EN_MSG_SPPServiceConnectionUpReg:
         return OSAL_NEW most_btsetfi_tclMsgSPPServiceConnectionUpReg;

      case most_btsetfi_tclToken::EN_MSG_SPPServiceConnectionRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgSPPServiceConnectionRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_SPPServiceConnectionGet:
         return OSAL_NEW most_btsetfi_tclMsgSPPServiceConnectionGet;

      case most_btsetfi_tclToken::EN_MSG_SPPServiceConnectionStatus:
         return OSAL_NEW most_btsetfi_tclMsgSPPServiceConnectionStatus;

      case most_btsetfi_tclToken::EN_MSG_BluetoothLimitationModeUpReg:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothLimitationModeUpReg;

      case most_btsetfi_tclToken::EN_MSG_BluetoothLimitationModeRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_BluetoothLimitationModeGet:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothLimitationModeGet;

      case most_btsetfi_tclToken::EN_MSG_BluetoothLimitationModeStatus:
         return OSAL_NEW most_btsetfi_tclMsgBluetoothLimitationModeStatus;

      case most_btsetfi_tclToken::EN_MSG_MultiHFPSupportUpReg:
         return OSAL_NEW most_btsetfi_tclMsgMultiHFPSupportUpReg;

      case most_btsetfi_tclToken::EN_MSG_MultiHFPSupportRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgMultiHFPSupportRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_MultiHFPSupportGet:
         return OSAL_NEW most_btsetfi_tclMsgMultiHFPSupportGet;

      case most_btsetfi_tclToken::EN_MSG_MultiHFPSupportStatus:
         return OSAL_NEW most_btsetfi_tclMsgMultiHFPSupportStatus;

      case most_btsetfi_tclToken::EN_MSG_BTProfilesUsageInfoUpReg:
         return OSAL_NEW most_btsetfi_tclMsgBTProfilesUsageInfoUpReg;

      case most_btsetfi_tclToken::EN_MSG_BTProfilesUsageInfoRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_BTProfilesUsageInfoGet:
         return OSAL_NEW most_btsetfi_tclMsgBTProfilesUsageInfoGet;

      case most_btsetfi_tclToken::EN_MSG_BTProfilesUsageInfoStatus:
         return OSAL_NEW most_btsetfi_tclMsgBTProfilesUsageInfoStatus;

      case most_btsetfi_tclToken::EN_MSG_ConflictsDetectedUpReg:
         return OSAL_NEW most_btsetfi_tclMsgConflictsDetectedUpReg;

      case most_btsetfi_tclToken::EN_MSG_ConflictsDetectedRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgConflictsDetectedRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_ConflictsDetectedGet:
         return OSAL_NEW most_btsetfi_tclMsgConflictsDetectedGet;

      case most_btsetfi_tclToken::EN_MSG_ConflictsDetectedStatus:
         return OSAL_NEW most_btsetfi_tclMsgConflictsDetectedStatus;

      case most_btsetfi_tclToken::EN_MSG_AutoConnectionStatusUpReg:
         return OSAL_NEW most_btsetfi_tclMsgAutoConnectionStatusUpReg;

      case most_btsetfi_tclToken::EN_MSG_AutoConnectionStatusRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgAutoConnectionStatusRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_AutoConnectionStatusGet:
         return OSAL_NEW most_btsetfi_tclMsgAutoConnectionStatusGet;

      case most_btsetfi_tclToken::EN_MSG_AutoConnectionStatusStatus:
         return OSAL_NEW most_btsetfi_tclMsgAutoConnectionStatusStatus;

      case most_btsetfi_tclToken::EN_MSG_ServiceAvailableUpReg:
         return OSAL_NEW most_btsetfi_tclMsgServiceAvailableUpReg;

      case most_btsetfi_tclToken::EN_MSG_ServiceAvailableRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgServiceAvailableRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_ServiceAvailableGet:
         return OSAL_NEW most_btsetfi_tclMsgServiceAvailableGet;

      case most_btsetfi_tclToken::EN_MSG_ServiceAvailableStatus:
         return OSAL_NEW most_btsetfi_tclMsgServiceAvailableStatus;

      case most_btsetfi_tclToken::EN_MSG_VehicleConfigurationUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleConfigurationUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleConfigurationRelUpReg:
         return OSAL_NEW most_btsetfi_tclMsgVehicleConfigurationRelUpReg;

      case most_btsetfi_tclToken::EN_MSG_VehicleConfigurationGet:
         return OSAL_NEW most_btsetfi_tclMsgVehicleConfigurationGet;

      case most_btsetfi_tclToken::EN_MSG_VehicleConfigurationStatus:
         return OSAL_NEW most_btsetfi_tclMsgVehicleConfigurationStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all most_btsetfifi messages

// common functions

tU16 most_btsetfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MOST_BTSETFI_C_U16_SERVICE_ID;
}

tU16 most_btsetfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 most_btsetfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& most_btsetfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& most_btsetfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 most_btsetfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& most_btsetfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& most_btsetfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

// base class for all most_btsetfi standard error messages

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgDefaultError::most_btsetfi_tclMsgDefaultError(const most_btsetfi_tclMsgDefaultError& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   *this = coRef;
}
most_btsetfi_tclMsgDefaultError& most_btsetfi_tclMsgDefaultError::operator=(const most_btsetfi_tclMsgDefaultError& coRef)
{
   if (this != &coRef)
   {
      e8ErrorCode = coRef.e8ErrorCode;
      oErrorInfo = coRef.oErrorInfo;
   }

   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgDefaultError::vDestroy()
{
   oErrorInfo.vDestroy();
}

tU32 most_btsetfi_tclMsgDefaultError::u32GetSize(tU16 u16MajorVersion) const
{
   return 3 + oErrorInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& most_btsetfi_tclMsgDefaultError::oRead(fi_tclInContext& oIn)
{
   tU16 u16CCA_Error = CCA_C_U16_ERROR_UNSPECIFIED;
   (tVoid) (oIn >> u16CCA_Error);
   (tVoid) (oIn >> e8ErrorCode);
   (tVoid) (oIn >> oErrorInfo);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgDefaultError::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU16)CCA_C_U16_ERROR_UNSPECIFIED);
   (tVoid) (oOut << e8ErrorCode);
   (tVoid) (oOut << oErrorInfo);
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAddNewDeviceMethodStart::most_btsetfi_tclMsgAddNewDeviceMethodStart(const most_btsetfi_tclMsgAddNewDeviceMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bDummyFlag = coRef.bDummyFlag;
}
most_btsetfi_tclMsgAddNewDeviceMethodStart& most_btsetfi_tclMsgAddNewDeviceMethodStart::operator=(const most_btsetfi_tclMsgAddNewDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bDummyFlag = coRef.bDummyFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgAddNewDeviceMethodStart::most_btsetfi_tclMsgAddNewDeviceMethodStart()
:bDummyFlag(0)
 {}

tS32 most_btsetfi_tclMsgAddNewDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AddNewDeviceMethodStart;
}


most_btsetfi_tclMsgAddNewDeviceMethodStart::~most_btsetfi_tclMsgAddNewDeviceMethodStart()
{}

tU32 most_btsetfi_tclMsgAddNewDeviceMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgAddNewDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDummyFlag);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgAddNewDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDummyFlag);
   return oOut;
}

tBool most_btsetfi_tclMsgAddNewDeviceMethodStart::operator==(const most_btsetfi_tclMsgAddNewDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDummyFlag == roRef.bDummyFlag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAddNewDeviceError::most_btsetfi_tclMsgAddNewDeviceError(const most_btsetfi_tclMsgAddNewDeviceError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgAddNewDeviceError& most_btsetfi_tclMsgAddNewDeviceError::operator=(const most_btsetfi_tclMsgAddNewDeviceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgAddNewDeviceError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AddNewDeviceError;
}


most_btsetfi_tclMsgAddNewDeviceError::~most_btsetfi_tclMsgAddNewDeviceError()
{}

tBool most_btsetfi_tclMsgAddNewDeviceError::operator==(const most_btsetfi_tclMsgAddNewDeviceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAddNewDeviceMethodResult::most_btsetfi_tclMsgAddNewDeviceMethodResult(const most_btsetfi_tclMsgAddNewDeviceMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8PairingType = coRef.e8PairingType;
   sDeviceName = coRef.sDeviceName;
   sPinNumber = coRef.sPinNumber;
}
most_btsetfi_tclMsgAddNewDeviceMethodResult& most_btsetfi_tclMsgAddNewDeviceMethodResult::operator=(const most_btsetfi_tclMsgAddNewDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8PairingType = coRef.e8PairingType;
   sDeviceName = coRef.sDeviceName;
   sPinNumber = coRef.sPinNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgAddNewDeviceMethodResult::vDestroy()
{
   sDeviceName.vDestroy(); 
   sPinNumber.vDestroy(); 
}

most_btsetfi_tclMsgAddNewDeviceMethodResult::most_btsetfi_tclMsgAddNewDeviceMethodResult()
:e8PairingType()
,sDeviceName()
,sPinNumber()
 {}

tS32 most_btsetfi_tclMsgAddNewDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AddNewDeviceMethodResult;
}


most_btsetfi_tclMsgAddNewDeviceMethodResult::~most_btsetfi_tclMsgAddNewDeviceMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgAddNewDeviceMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sDeviceName.u32GetSize(u16MajorVersion);
   u32DynamicSize += sPinNumber.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgAddNewDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PairingType);
   (tVoid) (oIn >> sDeviceName);
   (tVoid) (oIn >> sPinNumber);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgAddNewDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PairingType);
   (tVoid) (oOut << sDeviceName);
   (tVoid) (oOut << sPinNumber);
   return oOut;
}

tBool most_btsetfi_tclMsgAddNewDeviceMethodResult::operator==(const most_btsetfi_tclMsgAddNewDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PairingType == roRef.e8PairingType);
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   bResult = bResult && (sPinNumber == roRef.sPinNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairingResponseMethodStart::most_btsetfi_tclMsgPairingResponseMethodStart(const most_btsetfi_tclMsgPairingResponseMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8PairingResponseType = coRef.e8PairingResponseType;
}
most_btsetfi_tclMsgPairingResponseMethodStart& most_btsetfi_tclMsgPairingResponseMethodStart::operator=(const most_btsetfi_tclMsgPairingResponseMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8PairingResponseType = coRef.e8PairingResponseType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgPairingResponseMethodStart::most_btsetfi_tclMsgPairingResponseMethodStart()
:e8PairingResponseType()
 {}

tS32 most_btsetfi_tclMsgPairingResponseMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingResponseMethodStart;
}


most_btsetfi_tclMsgPairingResponseMethodStart::~most_btsetfi_tclMsgPairingResponseMethodStart()
{}

tU32 most_btsetfi_tclMsgPairingResponseMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgPairingResponseMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PairingResponseType);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgPairingResponseMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PairingResponseType);
   return oOut;
}

tBool most_btsetfi_tclMsgPairingResponseMethodStart::operator==(const most_btsetfi_tclMsgPairingResponseMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PairingResponseType == roRef.e8PairingResponseType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairingResponseError::most_btsetfi_tclMsgPairingResponseError(const most_btsetfi_tclMsgPairingResponseError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgPairingResponseError& most_btsetfi_tclMsgPairingResponseError::operator=(const most_btsetfi_tclMsgPairingResponseError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgPairingResponseError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingResponseError;
}


most_btsetfi_tclMsgPairingResponseError::~most_btsetfi_tclMsgPairingResponseError()
{}

tBool most_btsetfi_tclMsgPairingResponseError::operator==(const most_btsetfi_tclMsgPairingResponseError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairingResponseMethodResult::most_btsetfi_tclMsgPairingResponseMethodResult(const most_btsetfi_tclMsgPairingResponseMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8PairingStatusType = coRef.e8PairingStatusType;
}
most_btsetfi_tclMsgPairingResponseMethodResult& most_btsetfi_tclMsgPairingResponseMethodResult::operator=(const most_btsetfi_tclMsgPairingResponseMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8PairingStatusType = coRef.e8PairingStatusType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgPairingResponseMethodResult::most_btsetfi_tclMsgPairingResponseMethodResult()
:e8PairingStatusType()
 {}

tS32 most_btsetfi_tclMsgPairingResponseMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingResponseMethodResult;
}


most_btsetfi_tclMsgPairingResponseMethodResult::~most_btsetfi_tclMsgPairingResponseMethodResult()
{}

tU32 most_btsetfi_tclMsgPairingResponseMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgPairingResponseMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PairingStatusType);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgPairingResponseMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PairingStatusType);
   return oOut;
}

tBool most_btsetfi_tclMsgPairingResponseMethodResult::operator==(const most_btsetfi_tclMsgPairingResponseMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PairingStatusType == roRef.e8PairingStatusType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangePinMethodStart::most_btsetfi_tclMsgChangePinMethodStart(const most_btsetfi_tclMsgChangePinMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sPinNumber = coRef.sPinNumber;
}
most_btsetfi_tclMsgChangePinMethodStart& most_btsetfi_tclMsgChangePinMethodStart::operator=(const most_btsetfi_tclMsgChangePinMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPinNumber = coRef.sPinNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgChangePinMethodStart::vDestroy()
{
   sPinNumber.vDestroy(); 
}

most_btsetfi_tclMsgChangePinMethodStart::most_btsetfi_tclMsgChangePinMethodStart()
:sPinNumber()
 {}

tS32 most_btsetfi_tclMsgChangePinMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangePinMethodStart;
}


most_btsetfi_tclMsgChangePinMethodStart::~most_btsetfi_tclMsgChangePinMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgChangePinMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPinNumber.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgChangePinMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPinNumber);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgChangePinMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPinNumber);
   return oOut;
}

tBool most_btsetfi_tclMsgChangePinMethodStart::operator==(const most_btsetfi_tclMsgChangePinMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPinNumber == roRef.sPinNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangePinError::most_btsetfi_tclMsgChangePinError(const most_btsetfi_tclMsgChangePinError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgChangePinError& most_btsetfi_tclMsgChangePinError::operator=(const most_btsetfi_tclMsgChangePinError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgChangePinError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangePinError;
}


most_btsetfi_tclMsgChangePinError::~most_btsetfi_tclMsgChangePinError()
{}

tBool most_btsetfi_tclMsgChangePinError::operator==(const most_btsetfi_tclMsgChangePinError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangePinMethodResult::most_btsetfi_tclMsgChangePinMethodResult(const most_btsetfi_tclMsgChangePinMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8PairingType = coRef.e8PairingType;
   sDeviceName = coRef.sDeviceName;
   sPinNumber = coRef.sPinNumber;
}
most_btsetfi_tclMsgChangePinMethodResult& most_btsetfi_tclMsgChangePinMethodResult::operator=(const most_btsetfi_tclMsgChangePinMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8PairingType = coRef.e8PairingType;
   sDeviceName = coRef.sDeviceName;
   sPinNumber = coRef.sPinNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgChangePinMethodResult::vDestroy()
{
   sDeviceName.vDestroy(); 
   sPinNumber.vDestroy(); 
}

most_btsetfi_tclMsgChangePinMethodResult::most_btsetfi_tclMsgChangePinMethodResult()
:e8PairingType()
,sDeviceName()
,sPinNumber()
 {}

tS32 most_btsetfi_tclMsgChangePinMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangePinMethodResult;
}


most_btsetfi_tclMsgChangePinMethodResult::~most_btsetfi_tclMsgChangePinMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgChangePinMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sDeviceName.u32GetSize(u16MajorVersion);
   u32DynamicSize += sPinNumber.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgChangePinMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PairingType);
   (tVoid) (oIn >> sDeviceName);
   (tVoid) (oIn >> sPinNumber);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgChangePinMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PairingType);
   (tVoid) (oOut << sDeviceName);
   (tVoid) (oOut << sPinNumber);
   return oOut;
}

tBool most_btsetfi_tclMsgChangePinMethodResult::operator==(const most_btsetfi_tclMsgChangePinMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PairingType == roRef.e8PairingType);
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   bResult = bResult && (sPinNumber == roRef.sPinNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangeDeviceStateMethodStart::most_btsetfi_tclMsgChangeDeviceStateMethodStart(const most_btsetfi_tclMsgChangeDeviceStateMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8ChangeDeviceStateAction = coRef.e8ChangeDeviceStateAction;
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_btsetfi_tclMsgChangeDeviceStateMethodStart& most_btsetfi_tclMsgChangeDeviceStateMethodStart::operator=(const most_btsetfi_tclMsgChangeDeviceStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ChangeDeviceStateAction = coRef.e8ChangeDeviceStateAction;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgChangeDeviceStateMethodStart::most_btsetfi_tclMsgChangeDeviceStateMethodStart()
:e8ChangeDeviceStateAction()
,u8DeviceHandle(0)
 {}

tS32 most_btsetfi_tclMsgChangeDeviceStateMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeDeviceStateMethodStart;
}


most_btsetfi_tclMsgChangeDeviceStateMethodStart::~most_btsetfi_tclMsgChangeDeviceStateMethodStart()
{}

tU32 most_btsetfi_tclMsgChangeDeviceStateMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgChangeDeviceStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ChangeDeviceStateAction);
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgChangeDeviceStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ChangeDeviceStateAction);
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_btsetfi_tclMsgChangeDeviceStateMethodStart::operator==(const most_btsetfi_tclMsgChangeDeviceStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ChangeDeviceStateAction == roRef.e8ChangeDeviceStateAction);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangeDeviceStateError::most_btsetfi_tclMsgChangeDeviceStateError(const most_btsetfi_tclMsgChangeDeviceStateError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgChangeDeviceStateError& most_btsetfi_tclMsgChangeDeviceStateError::operator=(const most_btsetfi_tclMsgChangeDeviceStateError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgChangeDeviceStateError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeDeviceStateError;
}


most_btsetfi_tclMsgChangeDeviceStateError::~most_btsetfi_tclMsgChangeDeviceStateError()
{}

tBool most_btsetfi_tclMsgChangeDeviceStateError::operator==(const most_btsetfi_tclMsgChangeDeviceStateError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangeDeviceStateMethodResult::most_btsetfi_tclMsgChangeDeviceStateMethodResult(const most_btsetfi_tclMsgChangeDeviceStateMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bReplaceDeviceRequired = coRef.bReplaceDeviceRequired;
   e8ConnectionResult = coRef.e8ConnectionResult;
}
most_btsetfi_tclMsgChangeDeviceStateMethodResult& most_btsetfi_tclMsgChangeDeviceStateMethodResult::operator=(const most_btsetfi_tclMsgChangeDeviceStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bReplaceDeviceRequired = coRef.bReplaceDeviceRequired;
   e8ConnectionResult = coRef.e8ConnectionResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgChangeDeviceStateMethodResult::most_btsetfi_tclMsgChangeDeviceStateMethodResult()
:bReplaceDeviceRequired(0)
,e8ConnectionResult()
 {}

tS32 most_btsetfi_tclMsgChangeDeviceStateMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeDeviceStateMethodResult;
}


most_btsetfi_tclMsgChangeDeviceStateMethodResult::~most_btsetfi_tclMsgChangeDeviceStateMethodResult()
{}

tU32 most_btsetfi_tclMsgChangeDeviceStateMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgChangeDeviceStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bReplaceDeviceRequired);
   (tVoid) (oIn >> e8ConnectionResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgChangeDeviceStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bReplaceDeviceRequired);
   (tVoid) (oOut << e8ConnectionResult);
   return oOut;
}

tBool most_btsetfi_tclMsgChangeDeviceStateMethodResult::operator==(const most_btsetfi_tclMsgChangeDeviceStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bReplaceDeviceRequired == roRef.bReplaceDeviceRequired);
   bResult = bResult && (e8ConnectionResult == roRef.e8ConnectionResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgReplaceDeviceMethodStart::most_btsetfi_tclMsgReplaceDeviceMethodStart(const most_btsetfi_tclMsgReplaceDeviceMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8ConnectDeviceHandle = coRef.u8ConnectDeviceHandle;
   u8DisconnectDeviceHandle = coRef.u8DisconnectDeviceHandle;
}
most_btsetfi_tclMsgReplaceDeviceMethodStart& most_btsetfi_tclMsgReplaceDeviceMethodStart::operator=(const most_btsetfi_tclMsgReplaceDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8ConnectDeviceHandle = coRef.u8ConnectDeviceHandle;
   u8DisconnectDeviceHandle = coRef.u8DisconnectDeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgReplaceDeviceMethodStart::most_btsetfi_tclMsgReplaceDeviceMethodStart()
:u8ConnectDeviceHandle(0)
,u8DisconnectDeviceHandle(0)
 {}

tS32 most_btsetfi_tclMsgReplaceDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ReplaceDeviceMethodStart;
}


most_btsetfi_tclMsgReplaceDeviceMethodStart::~most_btsetfi_tclMsgReplaceDeviceMethodStart()
{}

tU32 most_btsetfi_tclMsgReplaceDeviceMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgReplaceDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8ConnectDeviceHandle);
   (tVoid) (oIn >> u8DisconnectDeviceHandle);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgReplaceDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8ConnectDeviceHandle);
   (tVoid) (oOut << u8DisconnectDeviceHandle);
   return oOut;
}

tBool most_btsetfi_tclMsgReplaceDeviceMethodStart::operator==(const most_btsetfi_tclMsgReplaceDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8ConnectDeviceHandle == roRef.u8ConnectDeviceHandle);
   bResult = bResult && (u8DisconnectDeviceHandle == roRef.u8DisconnectDeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgReplaceDeviceError::most_btsetfi_tclMsgReplaceDeviceError(const most_btsetfi_tclMsgReplaceDeviceError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgReplaceDeviceError& most_btsetfi_tclMsgReplaceDeviceError::operator=(const most_btsetfi_tclMsgReplaceDeviceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgReplaceDeviceError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ReplaceDeviceError;
}


most_btsetfi_tclMsgReplaceDeviceError::~most_btsetfi_tclMsgReplaceDeviceError()
{}

tBool most_btsetfi_tclMsgReplaceDeviceError::operator==(const most_btsetfi_tclMsgReplaceDeviceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgReplaceDeviceMethodResult::most_btsetfi_tclMsgReplaceDeviceMethodResult(const most_btsetfi_tclMsgReplaceDeviceMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8ConnectionResult = coRef.e8ConnectionResult;
}
most_btsetfi_tclMsgReplaceDeviceMethodResult& most_btsetfi_tclMsgReplaceDeviceMethodResult::operator=(const most_btsetfi_tclMsgReplaceDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ConnectionResult = coRef.e8ConnectionResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgReplaceDeviceMethodResult::most_btsetfi_tclMsgReplaceDeviceMethodResult()
:e8ConnectionResult()
 {}

tS32 most_btsetfi_tclMsgReplaceDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ReplaceDeviceMethodResult;
}


most_btsetfi_tclMsgReplaceDeviceMethodResult::~most_btsetfi_tclMsgReplaceDeviceMethodResult()
{}

tU32 most_btsetfi_tclMsgReplaceDeviceMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgReplaceDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConnectionResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgReplaceDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConnectionResult);
   return oOut;
}

tBool most_btsetfi_tclMsgReplaceDeviceMethodResult::operator==(const most_btsetfi_tclMsgReplaceDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConnectionResult == roRef.e8ConnectionResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart::most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bDummyFlag = coRef.bDummyFlag;
}
most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart& most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart::operator=(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bDummyFlag = coRef.bDummyFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart::most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart()
:bDummyFlag(0)
 {}

tS32 most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_RequestDeviceRingtoneListMethodStart;
}


most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart::~most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart()
{}

tU32 most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDummyFlag);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDummyFlag);
   return oOut;
}

tBool most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart::operator==(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDummyFlag == roRef.bDummyFlag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgRequestDeviceRingtoneListError::most_btsetfi_tclMsgRequestDeviceRingtoneListError(const most_btsetfi_tclMsgRequestDeviceRingtoneListError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgRequestDeviceRingtoneListError& most_btsetfi_tclMsgRequestDeviceRingtoneListError::operator=(const most_btsetfi_tclMsgRequestDeviceRingtoneListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgRequestDeviceRingtoneListError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_RequestDeviceRingtoneListError;
}


most_btsetfi_tclMsgRequestDeviceRingtoneListError::~most_btsetfi_tclMsgRequestDeviceRingtoneListError()
{}

tBool most_btsetfi_tclMsgRequestDeviceRingtoneListError::operator==(const most_btsetfi_tclMsgRequestDeviceRingtoneListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oDeviceRingtoneListResult = coRef.oDeviceRingtoneListResult;
}
most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult& most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::operator=(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oDeviceRingtoneListResult = coRef.oDeviceRingtoneListResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::vDestroy()
{
}

most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult()
:oDeviceRingtoneListResult()
 {}

tS32 most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_RequestDeviceRingtoneListMethodResult;
}


most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::~most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDeviceRingtoneListResult.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDeviceRingtoneListResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDeviceRingtoneListResult);
   return oOut;
}

tBool most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult::operator==(const most_btsetfi_tclMsgRequestDeviceRingtoneListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDeviceRingtoneListResult == roRef.oDeviceRingtoneListResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart::most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart& most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart::operator=(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart::most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_RequestAvailableRingtonesListMethodStart;
}


most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart::~most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart()
{}

tU32 most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart::operator==(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgRequestAvailableRingtonesListError::most_btsetfi_tclMsgRequestAvailableRingtonesListError(const most_btsetfi_tclMsgRequestAvailableRingtonesListError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgRequestAvailableRingtonesListError& most_btsetfi_tclMsgRequestAvailableRingtonesListError::operator=(const most_btsetfi_tclMsgRequestAvailableRingtonesListError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgRequestAvailableRingtonesListError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_RequestAvailableRingtonesListError;
}


most_btsetfi_tclMsgRequestAvailableRingtonesListError::~most_btsetfi_tclMsgRequestAvailableRingtonesListError()
{}

tBool most_btsetfi_tclMsgRequestAvailableRingtonesListError::operator==(const most_btsetfi_tclMsgRequestAvailableRingtonesListError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oRingtoneList = coRef.oRingtoneList;
}
most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult& most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::operator=(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   oRingtoneList = coRef.oRingtoneList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::vDestroy()
{
}

most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult()
:oRingtoneList()
 {}

tS32 most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_RequestAvailableRingtonesListMethodResult;
}


most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::~most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oRingtoneList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oRingtoneList);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oRingtoneList);
   return oOut;
}

tBool most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult::operator==(const most_btsetfi_tclMsgRequestAvailableRingtonesListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oRingtoneList == roRef.oRingtoneList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPlayRingtoneMethodStart::most_btsetfi_tclMsgPlayRingtoneMethodStart(const most_btsetfi_tclMsgPlayRingtoneMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u16RingtoneID = coRef.u16RingtoneID;
   u8LogicalAVChannel = coRef.u8LogicalAVChannel;
}
most_btsetfi_tclMsgPlayRingtoneMethodStart& most_btsetfi_tclMsgPlayRingtoneMethodStart::operator=(const most_btsetfi_tclMsgPlayRingtoneMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u16RingtoneID = coRef.u16RingtoneID;
   u8LogicalAVChannel = coRef.u8LogicalAVChannel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgPlayRingtoneMethodStart::most_btsetfi_tclMsgPlayRingtoneMethodStart()
:u16RingtoneID(0)
,u8LogicalAVChannel(0)
 {}

tS32 most_btsetfi_tclMsgPlayRingtoneMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PlayRingtoneMethodStart;
}


most_btsetfi_tclMsgPlayRingtoneMethodStart::~most_btsetfi_tclMsgPlayRingtoneMethodStart()
{}

tU32 most_btsetfi_tclMsgPlayRingtoneMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_btsetfi_tclMsgPlayRingtoneMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16RingtoneID);
   (tVoid) (oIn >> u8LogicalAVChannel);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgPlayRingtoneMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16RingtoneID);
   (tVoid) (oOut << u8LogicalAVChannel);
   return oOut;
}

tBool most_btsetfi_tclMsgPlayRingtoneMethodStart::operator==(const most_btsetfi_tclMsgPlayRingtoneMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16RingtoneID == roRef.u16RingtoneID);
   bResult = bResult && (u8LogicalAVChannel == roRef.u8LogicalAVChannel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPlayRingtoneError::most_btsetfi_tclMsgPlayRingtoneError(const most_btsetfi_tclMsgPlayRingtoneError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgPlayRingtoneError& most_btsetfi_tclMsgPlayRingtoneError::operator=(const most_btsetfi_tclMsgPlayRingtoneError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgPlayRingtoneError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PlayRingtoneError;
}


most_btsetfi_tclMsgPlayRingtoneError::~most_btsetfi_tclMsgPlayRingtoneError()
{}

tBool most_btsetfi_tclMsgPlayRingtoneError::operator==(const most_btsetfi_tclMsgPlayRingtoneError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPlayRingtoneMethodResult::most_btsetfi_tclMsgPlayRingtoneMethodResult(const most_btsetfi_tclMsgPlayRingtoneMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgPlayRingtoneMethodResult& most_btsetfi_tclMsgPlayRingtoneMethodResult::operator=(const most_btsetfi_tclMsgPlayRingtoneMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgPlayRingtoneMethodResult::most_btsetfi_tclMsgPlayRingtoneMethodResult()
:e8ErrorCode()
,oErrorInfo()
 {}

tS32 most_btsetfi_tclMsgPlayRingtoneMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PlayRingtoneMethodResult;
}


most_btsetfi_tclMsgPlayRingtoneMethodResult::~most_btsetfi_tclMsgPlayRingtoneMethodResult()
{}

tU32 most_btsetfi_tclMsgPlayRingtoneMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oErrorInfo.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgPlayRingtoneMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ErrorCode);
   (tVoid) (oIn >> oErrorInfo);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgPlayRingtoneMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ErrorCode);
   (tVoid) (oOut << oErrorInfo);
   return oOut;
}

tBool most_btsetfi_tclMsgPlayRingtoneMethodResult::operator==(const most_btsetfi_tclMsgPlayRingtoneMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgClearDeviceInfoMethodStart::most_btsetfi_tclMsgClearDeviceInfoMethodStart()
 {}

tS32 most_btsetfi_tclMsgClearDeviceInfoMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ClearDeviceInfoMethodStart;
}


most_btsetfi_tclMsgClearDeviceInfoMethodStart::~most_btsetfi_tclMsgClearDeviceInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgClearDeviceInfoError::most_btsetfi_tclMsgClearDeviceInfoError(const most_btsetfi_tclMsgClearDeviceInfoError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgClearDeviceInfoError& most_btsetfi_tclMsgClearDeviceInfoError::operator=(const most_btsetfi_tclMsgClearDeviceInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgClearDeviceInfoError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ClearDeviceInfoError;
}


most_btsetfi_tclMsgClearDeviceInfoError::~most_btsetfi_tclMsgClearDeviceInfoError()
{}

tBool most_btsetfi_tclMsgClearDeviceInfoError::operator==(const most_btsetfi_tclMsgClearDeviceInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgClearDeviceInfoMethodResult::most_btsetfi_tclMsgClearDeviceInfoMethodResult(const most_btsetfi_tclMsgClearDeviceInfoMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgClearDeviceInfoMethodResult& most_btsetfi_tclMsgClearDeviceInfoMethodResult::operator=(const most_btsetfi_tclMsgClearDeviceInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgClearDeviceInfoMethodResult::most_btsetfi_tclMsgClearDeviceInfoMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgClearDeviceInfoMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ClearDeviceInfoMethodResult;
}


most_btsetfi_tclMsgClearDeviceInfoMethodResult::~most_btsetfi_tclMsgClearDeviceInfoMethodResult()
{}

tU32 most_btsetfi_tclMsgClearDeviceInfoMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgClearDeviceInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgClearDeviceInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgClearDeviceInfoMethodResult::operator==(const most_btsetfi_tclMsgClearDeviceInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart::most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart& most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart::operator=(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart::most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_GetDeviceInfoExtendedMethodStart;
}


most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart::~most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart()
{}

tU32 most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart::operator==(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgGetDeviceInfoExtendedError::most_btsetfi_tclMsgGetDeviceInfoExtendedError(const most_btsetfi_tclMsgGetDeviceInfoExtendedError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgGetDeviceInfoExtendedError& most_btsetfi_tclMsgGetDeviceInfoExtendedError::operator=(const most_btsetfi_tclMsgGetDeviceInfoExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgGetDeviceInfoExtendedError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_GetDeviceInfoExtendedError;
}


most_btsetfi_tclMsgGetDeviceInfoExtendedError::~most_btsetfi_tclMsgGetDeviceInfoExtendedError()
{}

tBool most_btsetfi_tclMsgGetDeviceInfoExtendedError::operator==(const most_btsetfi_tclMsgGetDeviceInfoExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8MajorDeviceClass = coRef.e8MajorDeviceClass;
   sBluetoothDeviceAddress = coRef.sBluetoothDeviceAddress;
   oBluetoothFeatureSupport = coRef.oBluetoothFeatureSupport;
   sLinkKey = coRef.sLinkKey;
   oSupportedProfiles = coRef.oSupportedProfiles;
   oDeviceIdentification = coRef.oDeviceIdentification;
}
most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult& most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::operator=(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8MajorDeviceClass = coRef.e8MajorDeviceClass;
   sBluetoothDeviceAddress = coRef.sBluetoothDeviceAddress;
   oBluetoothFeatureSupport = coRef.oBluetoothFeatureSupport;
   sLinkKey = coRef.sLinkKey;
   oSupportedProfiles = coRef.oSupportedProfiles;
   oDeviceIdentification = coRef.oDeviceIdentification;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::vDestroy()
{
   sBluetoothDeviceAddress.vDestroy(); 
   oBluetoothFeatureSupport.vDestroy(); 
   sLinkKey.vDestroy(); 
   oSupportedProfiles.vDestroy(); 
   oDeviceIdentification.vDestroy(); 
}

most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult()
:u8DeviceHandle(0)
,e8MajorDeviceClass()
,sBluetoothDeviceAddress()
,oBluetoothFeatureSupport()
,sLinkKey()
,oSupportedProfiles()
,oDeviceIdentification()
 {}

tS32 most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_GetDeviceInfoExtendedMethodResult;
}


most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::~most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBluetoothDeviceAddress.u32GetSize(u16MajorVersion);
   u32DynamicSize += oBluetoothFeatureSupport.u32GetSize(u16MajorVersion);
   u32DynamicSize += sLinkKey.u32GetSize(u16MajorVersion);
   u32DynamicSize += oSupportedProfiles.u32GetSize(u16MajorVersion);
   u32DynamicSize += oDeviceIdentification.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> e8MajorDeviceClass);
   (tVoid) (oIn >> sBluetoothDeviceAddress);
   (tVoid) (oIn >> oBluetoothFeatureSupport);
   (tVoid) (oIn >> sLinkKey);
   (tVoid) (oIn >> oSupportedProfiles);
   (tVoid) (oIn >> oDeviceIdentification);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << e8MajorDeviceClass);
   (tVoid) (oOut << sBluetoothDeviceAddress);
   (tVoid) (oOut << oBluetoothFeatureSupport);
   (tVoid) (oOut << sLinkKey);
   (tVoid) (oOut << oSupportedProfiles);
   (tVoid) (oOut << oDeviceIdentification);
   return oOut;
}

tBool most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult::operator==(const most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (e8MajorDeviceClass == roRef.e8MajorDeviceClass);
   bResult = bResult && (sBluetoothDeviceAddress == roRef.sBluetoothDeviceAddress);
   bResult = bResult && (oBluetoothFeatureSupport == roRef.oBluetoothFeatureSupport);
   bResult = bResult && (sLinkKey == roRef.sLinkKey);
   bResult = bResult && (oSupportedProfiles == roRef.oSupportedProfiles);
   bResult = bResult && (oDeviceIdentification == roRef.oDeviceIdentification);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgStopRingtoneMethodStart::most_btsetfi_tclMsgStopRingtoneMethodStart()
 {}

tS32 most_btsetfi_tclMsgStopRingtoneMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StopRingtoneMethodStart;
}


most_btsetfi_tclMsgStopRingtoneMethodStart::~most_btsetfi_tclMsgStopRingtoneMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStopRingtoneError::most_btsetfi_tclMsgStopRingtoneError(const most_btsetfi_tclMsgStopRingtoneError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgStopRingtoneError& most_btsetfi_tclMsgStopRingtoneError::operator=(const most_btsetfi_tclMsgStopRingtoneError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgStopRingtoneError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StopRingtoneError;
}


most_btsetfi_tclMsgStopRingtoneError::~most_btsetfi_tclMsgStopRingtoneError()
{}

tBool most_btsetfi_tclMsgStopRingtoneError::operator==(const most_btsetfi_tclMsgStopRingtoneError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStopRingtoneMethodResult::most_btsetfi_tclMsgStopRingtoneMethodResult(const most_btsetfi_tclMsgStopRingtoneMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bStopPlayRingtoneResult = coRef.bStopPlayRingtoneResult;
}
most_btsetfi_tclMsgStopRingtoneMethodResult& most_btsetfi_tclMsgStopRingtoneMethodResult::operator=(const most_btsetfi_tclMsgStopRingtoneMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bStopPlayRingtoneResult = coRef.bStopPlayRingtoneResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgStopRingtoneMethodResult::most_btsetfi_tclMsgStopRingtoneMethodResult()
:bStopPlayRingtoneResult(0)
 {}

tS32 most_btsetfi_tclMsgStopRingtoneMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StopRingtoneMethodResult;
}


most_btsetfi_tclMsgStopRingtoneMethodResult::~most_btsetfi_tclMsgStopRingtoneMethodResult()
{}

tU32 most_btsetfi_tclMsgStopRingtoneMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgStopRingtoneMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bStopPlayRingtoneResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgStopRingtoneMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bStopPlayRingtoneResult);
   return oOut;
}

tBool most_btsetfi_tclMsgStopRingtoneMethodResult::operator==(const most_btsetfi_tclMsgStopRingtoneMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bStopPlayRingtoneResult == roRef.bStopPlayRingtoneResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgScanBluetoothDevicesMethodStart::most_btsetfi_tclMsgScanBluetoothDevicesMethodStart(const most_btsetfi_tclMsgScanBluetoothDevicesMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bScan = coRef.bScan;
}
most_btsetfi_tclMsgScanBluetoothDevicesMethodStart& most_btsetfi_tclMsgScanBluetoothDevicesMethodStart::operator=(const most_btsetfi_tclMsgScanBluetoothDevicesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bScan = coRef.bScan;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgScanBluetoothDevicesMethodStart::most_btsetfi_tclMsgScanBluetoothDevicesMethodStart()
:bScan(0)
 {}

tS32 most_btsetfi_tclMsgScanBluetoothDevicesMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ScanBluetoothDevicesMethodStart;
}


most_btsetfi_tclMsgScanBluetoothDevicesMethodStart::~most_btsetfi_tclMsgScanBluetoothDevicesMethodStart()
{}

tU32 most_btsetfi_tclMsgScanBluetoothDevicesMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgScanBluetoothDevicesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bScan);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgScanBluetoothDevicesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bScan);
   return oOut;
}

tBool most_btsetfi_tclMsgScanBluetoothDevicesMethodStart::operator==(const most_btsetfi_tclMsgScanBluetoothDevicesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bScan == roRef.bScan);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgScanBluetoothDevicesError::most_btsetfi_tclMsgScanBluetoothDevicesError(const most_btsetfi_tclMsgScanBluetoothDevicesError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgScanBluetoothDevicesError& most_btsetfi_tclMsgScanBluetoothDevicesError::operator=(const most_btsetfi_tclMsgScanBluetoothDevicesError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgScanBluetoothDevicesError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ScanBluetoothDevicesError;
}


most_btsetfi_tclMsgScanBluetoothDevicesError::~most_btsetfi_tclMsgScanBluetoothDevicesError()
{}

tBool most_btsetfi_tclMsgScanBluetoothDevicesError::operator==(const most_btsetfi_tclMsgScanBluetoothDevicesError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgScanBluetoothDevicesMethodResult::most_btsetfi_tclMsgScanBluetoothDevicesMethodResult(const most_btsetfi_tclMsgScanBluetoothDevicesMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8ScanningState = coRef.e8ScanningState;
}
most_btsetfi_tclMsgScanBluetoothDevicesMethodResult& most_btsetfi_tclMsgScanBluetoothDevicesMethodResult::operator=(const most_btsetfi_tclMsgScanBluetoothDevicesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8ScanningState = coRef.e8ScanningState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgScanBluetoothDevicesMethodResult::most_btsetfi_tclMsgScanBluetoothDevicesMethodResult()
:e8ScanningState()
 {}

tS32 most_btsetfi_tclMsgScanBluetoothDevicesMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ScanBluetoothDevicesMethodResult;
}


most_btsetfi_tclMsgScanBluetoothDevicesMethodResult::~most_btsetfi_tclMsgScanBluetoothDevicesMethodResult()
{}

tU32 most_btsetfi_tclMsgScanBluetoothDevicesMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgScanBluetoothDevicesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ScanningState);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgScanBluetoothDevicesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ScanningState);
   return oOut;
}

tBool most_btsetfi_tclMsgScanBluetoothDevicesMethodResult::operator==(const most_btsetfi_tclMsgScanBluetoothDevicesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ScanningState == roRef.e8ScanningState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgConnectBluetoothProfileMethodStart::most_btsetfi_tclMsgConnectBluetoothProfileMethodStart(const most_btsetfi_tclMsgConnectBluetoothProfileMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   oServiceType = coRef.oServiceType;
}
most_btsetfi_tclMsgConnectBluetoothProfileMethodStart& most_btsetfi_tclMsgConnectBluetoothProfileMethodStart::operator=(const most_btsetfi_tclMsgConnectBluetoothProfileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   oServiceType = coRef.oServiceType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgConnectBluetoothProfileMethodStart::most_btsetfi_tclMsgConnectBluetoothProfileMethodStart()
:u8DeviceHandle(0)
,oServiceType()
 {}

tS32 most_btsetfi_tclMsgConnectBluetoothProfileMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConnectBluetoothProfileMethodStart;
}


most_btsetfi_tclMsgConnectBluetoothProfileMethodStart::~most_btsetfi_tclMsgConnectBluetoothProfileMethodStart()
{}

tU32 most_btsetfi_tclMsgConnectBluetoothProfileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oServiceType.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgConnectBluetoothProfileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> oServiceType);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgConnectBluetoothProfileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << oServiceType);
   return oOut;
}

tBool most_btsetfi_tclMsgConnectBluetoothProfileMethodStart::operator==(const most_btsetfi_tclMsgConnectBluetoothProfileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (oServiceType == roRef.oServiceType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgConnectBluetoothProfileError::most_btsetfi_tclMsgConnectBluetoothProfileError(const most_btsetfi_tclMsgConnectBluetoothProfileError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgConnectBluetoothProfileError& most_btsetfi_tclMsgConnectBluetoothProfileError::operator=(const most_btsetfi_tclMsgConnectBluetoothProfileError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgConnectBluetoothProfileError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConnectBluetoothProfileError;
}


most_btsetfi_tclMsgConnectBluetoothProfileError::~most_btsetfi_tclMsgConnectBluetoothProfileError()
{}

tBool most_btsetfi_tclMsgConnectBluetoothProfileError::operator==(const most_btsetfi_tclMsgConnectBluetoothProfileError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgConnectBluetoothProfileMethodResult::most_btsetfi_tclMsgConnectBluetoothProfileMethodResult(const most_btsetfi_tclMsgConnectBluetoothProfileMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   oProfileConnectionStatus = coRef.oProfileConnectionStatus;
}
most_btsetfi_tclMsgConnectBluetoothProfileMethodResult& most_btsetfi_tclMsgConnectBluetoothProfileMethodResult::operator=(const most_btsetfi_tclMsgConnectBluetoothProfileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   oProfileConnectionStatus = coRef.oProfileConnectionStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgConnectBluetoothProfileMethodResult::most_btsetfi_tclMsgConnectBluetoothProfileMethodResult()
:u8DeviceHandle(0)
,oProfileConnectionStatus()
 {}

tS32 most_btsetfi_tclMsgConnectBluetoothProfileMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConnectBluetoothProfileMethodResult;
}


most_btsetfi_tclMsgConnectBluetoothProfileMethodResult::~most_btsetfi_tclMsgConnectBluetoothProfileMethodResult()
{}

tU32 most_btsetfi_tclMsgConnectBluetoothProfileMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oProfileConnectionStatus.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgConnectBluetoothProfileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> oProfileConnectionStatus);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgConnectBluetoothProfileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << oProfileConnectionStatus);
   return oOut;
}

tBool most_btsetfi_tclMsgConnectBluetoothProfileMethodResult::operator==(const most_btsetfi_tclMsgConnectBluetoothProfileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (oProfileConnectionStatus == roRef.oProfileConnectionStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart::most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   oServiceType = coRef.oServiceType;
}
most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart& most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart::operator=(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   oServiceType = coRef.oServiceType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart::most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart()
:u8DeviceHandle(0)
,oServiceType()
 {}

tS32 most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DisconnectBluetoothProfileMethodStart;
}


most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart::~most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart()
{}

tU32 most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oServiceType.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> oServiceType);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << oServiceType);
   return oOut;
}

tBool most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart::operator==(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (oServiceType == roRef.oServiceType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgDisconnectBluetoothProfileError::most_btsetfi_tclMsgDisconnectBluetoothProfileError(const most_btsetfi_tclMsgDisconnectBluetoothProfileError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgDisconnectBluetoothProfileError& most_btsetfi_tclMsgDisconnectBluetoothProfileError::operator=(const most_btsetfi_tclMsgDisconnectBluetoothProfileError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgDisconnectBluetoothProfileError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DisconnectBluetoothProfileError;
}


most_btsetfi_tclMsgDisconnectBluetoothProfileError::~most_btsetfi_tclMsgDisconnectBluetoothProfileError()
{}

tBool most_btsetfi_tclMsgDisconnectBluetoothProfileError::operator==(const most_btsetfi_tclMsgDisconnectBluetoothProfileError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult::most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   oProfileDisconnectionStatus = coRef.oProfileDisconnectionStatus;
}
most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult& most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult::operator=(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   oProfileDisconnectionStatus = coRef.oProfileDisconnectionStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult::most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult()
:u8DeviceHandle(0)
,oProfileDisconnectionStatus()
 {}

tS32 most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DisconnectBluetoothProfileMethodResult;
}


most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult::~most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult()
{}

tU32 most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oProfileDisconnectionStatus.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> oProfileDisconnectionStatus);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << oProfileDisconnectionStatus);
   return oOut;
}

tBool most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult::operator==(const most_btsetfi_tclMsgDisconnectBluetoothProfileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (oProfileDisconnectionStatus == roRef.oProfileDisconnectionStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSendPairingRequestMethodStart::most_btsetfi_tclMsgSendPairingRequestMethodStart(const most_btsetfi_tclMsgSendPairingRequestMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bPairingRequest = coRef.bPairingRequest;
   sRemoteDeviceAddress = coRef.sRemoteDeviceAddress;
}
most_btsetfi_tclMsgSendPairingRequestMethodStart& most_btsetfi_tclMsgSendPairingRequestMethodStart::operator=(const most_btsetfi_tclMsgSendPairingRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bPairingRequest = coRef.bPairingRequest;
   sRemoteDeviceAddress = coRef.sRemoteDeviceAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgSendPairingRequestMethodStart::vDestroy()
{
   sRemoteDeviceAddress.vDestroy(); 
}

most_btsetfi_tclMsgSendPairingRequestMethodStart::most_btsetfi_tclMsgSendPairingRequestMethodStart()
:bPairingRequest(0)
,sRemoteDeviceAddress()
 {}

tS32 most_btsetfi_tclMsgSendPairingRequestMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SendPairingRequestMethodStart;
}


most_btsetfi_tclMsgSendPairingRequestMethodStart::~most_btsetfi_tclMsgSendPairingRequestMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgSendPairingRequestMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sRemoteDeviceAddress.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgSendPairingRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bPairingRequest);
   (tVoid) (oIn >> sRemoteDeviceAddress);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSendPairingRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bPairingRequest);
   (tVoid) (oOut << sRemoteDeviceAddress);
   return oOut;
}

tBool most_btsetfi_tclMsgSendPairingRequestMethodStart::operator==(const most_btsetfi_tclMsgSendPairingRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bPairingRequest == roRef.bPairingRequest);
   bResult = bResult && (sRemoteDeviceAddress == roRef.sRemoteDeviceAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSendPairingRequestError::most_btsetfi_tclMsgSendPairingRequestError(const most_btsetfi_tclMsgSendPairingRequestError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSendPairingRequestError& most_btsetfi_tclMsgSendPairingRequestError::operator=(const most_btsetfi_tclMsgSendPairingRequestError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSendPairingRequestError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SendPairingRequestError;
}


most_btsetfi_tclMsgSendPairingRequestError::~most_btsetfi_tclMsgSendPairingRequestError()
{}

tBool most_btsetfi_tclMsgSendPairingRequestError::operator==(const most_btsetfi_tclMsgSendPairingRequestError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSendPairingRequestMethodResult::most_btsetfi_tclMsgSendPairingRequestMethodResult(const most_btsetfi_tclMsgSendPairingRequestMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8PairingResult = coRef.e8PairingResult;
}
most_btsetfi_tclMsgSendPairingRequestMethodResult& most_btsetfi_tclMsgSendPairingRequestMethodResult::operator=(const most_btsetfi_tclMsgSendPairingRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8PairingResult = coRef.e8PairingResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSendPairingRequestMethodResult::most_btsetfi_tclMsgSendPairingRequestMethodResult()
:e8PairingResult()
 {}

tS32 most_btsetfi_tclMsgSendPairingRequestMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SendPairingRequestMethodResult;
}


most_btsetfi_tclMsgSendPairingRequestMethodResult::~most_btsetfi_tclMsgSendPairingRequestMethodResult()
{}

tU32 most_btsetfi_tclMsgSendPairingRequestMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSendPairingRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PairingResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSendPairingRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PairingResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSendPairingRequestMethodResult::operator==(const most_btsetfi_tclMsgSendPairingRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PairingResult == roRef.e8PairingResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::most_btsetfi_tclMsgSwitchBTLocalModeMethodStart(const most_btsetfi_tclMsgSwitchBTLocalModeMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   Pairable = coRef.Pairable;
   Connectable = coRef.Connectable;
   sBTAddress = coRef.sBTAddress;
}
most_btsetfi_tclMsgSwitchBTLocalModeMethodStart& most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::operator=(const most_btsetfi_tclMsgSwitchBTLocalModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Pairable = coRef.Pairable;
   Connectable = coRef.Connectable;
   sBTAddress = coRef.sBTAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::vDestroy()
{
   sBTAddress.vDestroy(); 
}

most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::most_btsetfi_tclMsgSwitchBTLocalModeMethodStart()
:Pairable()
,Connectable()
,sBTAddress()
 {}

tS32 most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SwitchBTLocalModeMethodStart;
}


most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::~most_btsetfi_tclMsgSwitchBTLocalModeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBTAddress.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Pairable);
   (tVoid) (oIn >> Connectable);
   (tVoid) (oIn >> sBTAddress);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Pairable);
   (tVoid) (oOut << Connectable);
   (tVoid) (oOut << sBTAddress);
   return oOut;
}

tBool most_btsetfi_tclMsgSwitchBTLocalModeMethodStart::operator==(const most_btsetfi_tclMsgSwitchBTLocalModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Pairable == roRef.Pairable);
   bResult = bResult && (Connectable == roRef.Connectable);
   bResult = bResult && (sBTAddress == roRef.sBTAddress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSwitchBTLocalModeError::most_btsetfi_tclMsgSwitchBTLocalModeError(const most_btsetfi_tclMsgSwitchBTLocalModeError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSwitchBTLocalModeError& most_btsetfi_tclMsgSwitchBTLocalModeError::operator=(const most_btsetfi_tclMsgSwitchBTLocalModeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSwitchBTLocalModeError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SwitchBTLocalModeError;
}


most_btsetfi_tclMsgSwitchBTLocalModeError::~most_btsetfi_tclMsgSwitchBTLocalModeError()
{}

tBool most_btsetfi_tclMsgSwitchBTLocalModeError::operator==(const most_btsetfi_tclMsgSwitchBTLocalModeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSwitchBTLocalModeMethodResult::most_btsetfi_tclMsgSwitchBTLocalModeMethodResult(const most_btsetfi_tclMsgSwitchBTLocalModeMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgSwitchBTLocalModeMethodResult& most_btsetfi_tclMsgSwitchBTLocalModeMethodResult::operator=(const most_btsetfi_tclMsgSwitchBTLocalModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSwitchBTLocalModeMethodResult::most_btsetfi_tclMsgSwitchBTLocalModeMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgSwitchBTLocalModeMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SwitchBTLocalModeMethodResult;
}


most_btsetfi_tclMsgSwitchBTLocalModeMethodResult::~most_btsetfi_tclMsgSwitchBTLocalModeMethodResult()
{}

tU32 most_btsetfi_tclMsgSwitchBTLocalModeMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSwitchBTLocalModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSwitchBTLocalModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSwitchBTLocalModeMethodResult::operator==(const most_btsetfi_tclMsgSwitchBTLocalModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart::most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bStartAutoConnect = coRef.bStartAutoConnect;
}
most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart& most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart::operator=(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bStartAutoConnect = coRef.bStartAutoConnect;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart::most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart()
:bStartAutoConnect(0)
 {}

tS32 most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StartAutoConnectSequenceMethodStart;
}


most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart::~most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart()
{}

tU32 most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bStartAutoConnect);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bStartAutoConnect);
   return oOut;
}

tBool most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart::operator==(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bStartAutoConnect == roRef.bStartAutoConnect);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStartAutoConnectSequenceError::most_btsetfi_tclMsgStartAutoConnectSequenceError(const most_btsetfi_tclMsgStartAutoConnectSequenceError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgStartAutoConnectSequenceError& most_btsetfi_tclMsgStartAutoConnectSequenceError::operator=(const most_btsetfi_tclMsgStartAutoConnectSequenceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgStartAutoConnectSequenceError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StartAutoConnectSequenceError;
}


most_btsetfi_tclMsgStartAutoConnectSequenceError::~most_btsetfi_tclMsgStartAutoConnectSequenceError()
{}

tBool most_btsetfi_tclMsgStartAutoConnectSequenceError::operator==(const most_btsetfi_tclMsgStartAutoConnectSequenceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult::most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult& most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult::operator=(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult::most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StartAutoConnectSequenceMethodResult;
}


most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult::~most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult()
{}

tU32 most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult::operator==(const most_btsetfi_tclMsgStartAutoConnectSequenceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgConnectSPPServiceMethodStart::most_btsetfi_tclMsgConnectSPPServiceMethodStart(const most_btsetfi_tclMsgConnectSPPServiceMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   szUUID = coRef.szUUID;
}
most_btsetfi_tclMsgConnectSPPServiceMethodStart& most_btsetfi_tclMsgConnectSPPServiceMethodStart::operator=(const most_btsetfi_tclMsgConnectSPPServiceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   szUUID = coRef.szUUID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgConnectSPPServiceMethodStart::vDestroy()
{
   szUUID.vDestroy(); 
}

most_btsetfi_tclMsgConnectSPPServiceMethodStart::most_btsetfi_tclMsgConnectSPPServiceMethodStart()
:u8DeviceHandle(0)
,szUUID()
 {}

tS32 most_btsetfi_tclMsgConnectSPPServiceMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConnectSPPServiceMethodStart;
}


most_btsetfi_tclMsgConnectSPPServiceMethodStart::~most_btsetfi_tclMsgConnectSPPServiceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgConnectSPPServiceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += szUUID.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgConnectSPPServiceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> szUUID);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgConnectSPPServiceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << szUUID);
   return oOut;
}

tBool most_btsetfi_tclMsgConnectSPPServiceMethodStart::operator==(const most_btsetfi_tclMsgConnectSPPServiceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (szUUID == roRef.szUUID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgConnectSPPServiceError::most_btsetfi_tclMsgConnectSPPServiceError(const most_btsetfi_tclMsgConnectSPPServiceError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgConnectSPPServiceError& most_btsetfi_tclMsgConnectSPPServiceError::operator=(const most_btsetfi_tclMsgConnectSPPServiceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgConnectSPPServiceError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConnectSPPServiceError;
}


most_btsetfi_tclMsgConnectSPPServiceError::~most_btsetfi_tclMsgConnectSPPServiceError()
{}

tBool most_btsetfi_tclMsgConnectSPPServiceError::operator==(const most_btsetfi_tclMsgConnectSPPServiceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgConnectSPPServiceMethodResult::most_btsetfi_tclMsgConnectSPPServiceMethodResult(const most_btsetfi_tclMsgConnectSPPServiceMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bConnectSPPService = coRef.bConnectSPPService;
}
most_btsetfi_tclMsgConnectSPPServiceMethodResult& most_btsetfi_tclMsgConnectSPPServiceMethodResult::operator=(const most_btsetfi_tclMsgConnectSPPServiceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bConnectSPPService = coRef.bConnectSPPService;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgConnectSPPServiceMethodResult::most_btsetfi_tclMsgConnectSPPServiceMethodResult()
:bConnectSPPService(0)
 {}

tS32 most_btsetfi_tclMsgConnectSPPServiceMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConnectSPPServiceMethodResult;
}


most_btsetfi_tclMsgConnectSPPServiceMethodResult::~most_btsetfi_tclMsgConnectSPPServiceMethodResult()
{}

tU32 most_btsetfi_tclMsgConnectSPPServiceMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgConnectSPPServiceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bConnectSPPService);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgConnectSPPServiceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bConnectSPPService);
   return oOut;
}

tBool most_btsetfi_tclMsgConnectSPPServiceMethodResult::operator==(const most_btsetfi_tclMsgConnectSPPServiceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bConnectSPPService == roRef.bConnectSPPService);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
   sBdDeviceName = coRef.sBdDeviceName;
   e8Technology = coRef.e8Technology;
   e8CommunicationChannel = coRef.e8CommunicationChannel;
   e8Action = coRef.e8Action;
}
most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart& most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::operator=(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   sBdDeviceName = coRef.sBdDeviceName;
   e8Technology = coRef.e8Technology;
   e8CommunicationChannel = coRef.e8CommunicationChannel;
   e8Action = coRef.e8Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::vDestroy()
{
   sBdAddress.vDestroy(); 
   sBdDeviceName.vDestroy(); 
}

most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart()
:sBdAddress()
,sBdDeviceName()
,e8Technology()
,e8CommunicationChannel()
,e8Action()
 {}

tS32 most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetBluetoothLimitationModeMethodStart;
}


most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::~most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   u32DynamicSize += sBdDeviceName.u32GetSize(u16MajorVersion);
   return 3 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   (tVoid) (oIn >> sBdDeviceName);
   (tVoid) (oIn >> e8Technology);
   (tVoid) (oIn >> e8CommunicationChannel);
   (tVoid) (oIn >> e8Action);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   (tVoid) (oOut << sBdDeviceName);
   (tVoid) (oOut << e8Technology);
   (tVoid) (oOut << e8CommunicationChannel);
   (tVoid) (oOut << e8Action);
   return oOut;
}

tBool most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart::operator==(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   bResult = bResult && (sBdDeviceName == roRef.sBdDeviceName);
   bResult = bResult && (e8Technology == roRef.e8Technology);
   bResult = bResult && (e8CommunicationChannel == roRef.e8CommunicationChannel);
   bResult = bResult && (e8Action == roRef.e8Action);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetBluetoothLimitationModeError::most_btsetfi_tclMsgSetBluetoothLimitationModeError(const most_btsetfi_tclMsgSetBluetoothLimitationModeError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSetBluetoothLimitationModeError& most_btsetfi_tclMsgSetBluetoothLimitationModeError::operator=(const most_btsetfi_tclMsgSetBluetoothLimitationModeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSetBluetoothLimitationModeError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetBluetoothLimitationModeError;
}


most_btsetfi_tclMsgSetBluetoothLimitationModeError::~most_btsetfi_tclMsgSetBluetoothLimitationModeError()
{}

tBool most_btsetfi_tclMsgSetBluetoothLimitationModeError::operator==(const most_btsetfi_tclMsgSetBluetoothLimitationModeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult::most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult& most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult::operator=(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult::most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetBluetoothLimitationModeMethodResult;
}


most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult::~most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult()
{}

tU32 most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult::operator==(const most_btsetfi_tclMsgSetBluetoothLimitationModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart::most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bBTOnOff = coRef.bBTOnOff;
   bSuppressAutoConnection = coRef.bSuppressAutoConnection;
}
most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart& most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart::operator=(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bBTOnOff = coRef.bBTOnOff;
   bSuppressAutoConnection = coRef.bSuppressAutoConnection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart::most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart()
:bBTOnOff(0)
,bSuppressAutoConnection(0)
 {}

tS32 most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SwitchBluetoothOnOffExtendedMethodStart;
}


most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart::~most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart()
{}

tU32 most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bBTOnOff);
   (tVoid) (oIn >> bSuppressAutoConnection);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bBTOnOff);
   (tVoid) (oOut << bSuppressAutoConnection);
   return oOut;
}

tBool most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart::operator==(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bBTOnOff == roRef.bBTOnOff);
   bResult = bResult && (bSuppressAutoConnection == roRef.bSuppressAutoConnection);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError::most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError& most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError::operator=(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SwitchBluetoothOnOffExtendedError;
}


most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError::~most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError()
{}

tBool most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError::operator==(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult::most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bBTOnOffResult = coRef.bBTOnOffResult;
}
most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult& most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult::operator=(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bBTOnOffResult = coRef.bBTOnOffResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult::most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult()
:bBTOnOffResult(0)
 {}

tS32 most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SwitchBluetoothOnOffExtendedMethodResult;
}


most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult::~most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult()
{}

tU32 most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bBTOnOffResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bBTOnOffResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult::operator==(const most_btsetfi_tclMsgSwitchBluetoothOnOffExtendedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bBTOnOffResult == roRef.bBTOnOffResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart::most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8WiFiPowerAttenuation = coRef.u8WiFiPowerAttenuation;
}
most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart& most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart::operator=(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8WiFiPowerAttenuation = coRef.u8WiFiPowerAttenuation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart::most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart()
:u8WiFiPowerAttenuation(0)
 {}

tS32 most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeWifiTransmitPowerMethodStart;
}


most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart::~most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart()
{}

tU32 most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8WiFiPowerAttenuation);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8WiFiPowerAttenuation);
   return oOut;
}

tBool most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart::operator==(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8WiFiPowerAttenuation == roRef.u8WiFiPowerAttenuation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangeWifiTransmitPowerError::most_btsetfi_tclMsgChangeWifiTransmitPowerError(const most_btsetfi_tclMsgChangeWifiTransmitPowerError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgChangeWifiTransmitPowerError& most_btsetfi_tclMsgChangeWifiTransmitPowerError::operator=(const most_btsetfi_tclMsgChangeWifiTransmitPowerError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgChangeWifiTransmitPowerError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeWifiTransmitPowerError;
}


most_btsetfi_tclMsgChangeWifiTransmitPowerError::~most_btsetfi_tclMsgChangeWifiTransmitPowerError()
{}

tBool most_btsetfi_tclMsgChangeWifiTransmitPowerError::operator==(const most_btsetfi_tclMsgChangeWifiTransmitPowerError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult::most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult& most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult::operator=(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult::most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeWifiTransmitPowerMethodResult;
}


most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult::~most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult()
{}

tU32 most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult::operator==(const most_btsetfi_tclMsgChangeWifiTransmitPowerMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::most_btsetfi_tclMsgDisconnectSPPServiceMethodStart(const most_btsetfi_tclMsgDisconnectSPPServiceMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   szUUID = coRef.szUUID;
}
most_btsetfi_tclMsgDisconnectSPPServiceMethodStart& most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::operator=(const most_btsetfi_tclMsgDisconnectSPPServiceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   szUUID = coRef.szUUID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::vDestroy()
{
   szUUID.vDestroy(); 
}

most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::most_btsetfi_tclMsgDisconnectSPPServiceMethodStart()
:u8DeviceHandle(0)
,szUUID()
 {}

tS32 most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DisconnectSPPServiceMethodStart;
}


most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::~most_btsetfi_tclMsgDisconnectSPPServiceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += szUUID.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> szUUID);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << szUUID);
   return oOut;
}

tBool most_btsetfi_tclMsgDisconnectSPPServiceMethodStart::operator==(const most_btsetfi_tclMsgDisconnectSPPServiceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (szUUID == roRef.szUUID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgDisconnectSPPServiceError::most_btsetfi_tclMsgDisconnectSPPServiceError(const most_btsetfi_tclMsgDisconnectSPPServiceError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgDisconnectSPPServiceError& most_btsetfi_tclMsgDisconnectSPPServiceError::operator=(const most_btsetfi_tclMsgDisconnectSPPServiceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgDisconnectSPPServiceError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DisconnectSPPServiceError;
}


most_btsetfi_tclMsgDisconnectSPPServiceError::~most_btsetfi_tclMsgDisconnectSPPServiceError()
{}

tBool most_btsetfi_tclMsgDisconnectSPPServiceError::operator==(const most_btsetfi_tclMsgDisconnectSPPServiceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgDisconnectSPPServiceMethodResult::most_btsetfi_tclMsgDisconnectSPPServiceMethodResult(const most_btsetfi_tclMsgDisconnectSPPServiceMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bDisconnectSPPService = coRef.bDisconnectSPPService;
}
most_btsetfi_tclMsgDisconnectSPPServiceMethodResult& most_btsetfi_tclMsgDisconnectSPPServiceMethodResult::operator=(const most_btsetfi_tclMsgDisconnectSPPServiceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bDisconnectSPPService = coRef.bDisconnectSPPService;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgDisconnectSPPServiceMethodResult::most_btsetfi_tclMsgDisconnectSPPServiceMethodResult()
:bDisconnectSPPService(0)
 {}

tS32 most_btsetfi_tclMsgDisconnectSPPServiceMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DisconnectSPPServiceMethodResult;
}


most_btsetfi_tclMsgDisconnectSPPServiceMethodResult::~most_btsetfi_tclMsgDisconnectSPPServiceMethodResult()
{}

tU32 most_btsetfi_tclMsgDisconnectSPPServiceMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgDisconnectSPPServiceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDisconnectSPPService);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgDisconnectSPPServiceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDisconnectSPPService);
   return oOut;
}

tBool most_btsetfi_tclMsgDisconnectSPPServiceMethodResult::operator==(const most_btsetfi_tclMsgDisconnectSPPServiceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDisconnectSPPService == roRef.bDisconnectSPPService);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStartSearchSPPServicesMethodStart::most_btsetfi_tclMsgStartSearchSPPServicesMethodStart(const most_btsetfi_tclMsgStartSearchSPPServicesMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   bPeriodicSearch = coRef.bPeriodicSearch;
}
most_btsetfi_tclMsgStartSearchSPPServicesMethodStart& most_btsetfi_tclMsgStartSearchSPPServicesMethodStart::operator=(const most_btsetfi_tclMsgStartSearchSPPServicesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   bPeriodicSearch = coRef.bPeriodicSearch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgStartSearchSPPServicesMethodStart::most_btsetfi_tclMsgStartSearchSPPServicesMethodStart()
:u8DeviceHandle(0)
,bPeriodicSearch(0)
 {}

tS32 most_btsetfi_tclMsgStartSearchSPPServicesMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StartSearchSPPServicesMethodStart;
}


most_btsetfi_tclMsgStartSearchSPPServicesMethodStart::~most_btsetfi_tclMsgStartSearchSPPServicesMethodStart()
{}

tU32 most_btsetfi_tclMsgStartSearchSPPServicesMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgStartSearchSPPServicesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> bPeriodicSearch);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgStartSearchSPPServicesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << bPeriodicSearch);
   return oOut;
}

tBool most_btsetfi_tclMsgStartSearchSPPServicesMethodStart::operator==(const most_btsetfi_tclMsgStartSearchSPPServicesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (bPeriodicSearch == roRef.bPeriodicSearch);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStartSearchSPPServicesError::most_btsetfi_tclMsgStartSearchSPPServicesError(const most_btsetfi_tclMsgStartSearchSPPServicesError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgStartSearchSPPServicesError& most_btsetfi_tclMsgStartSearchSPPServicesError::operator=(const most_btsetfi_tclMsgStartSearchSPPServicesError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgStartSearchSPPServicesError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StartSearchSPPServicesError;
}


most_btsetfi_tclMsgStartSearchSPPServicesError::~most_btsetfi_tclMsgStartSearchSPPServicesError()
{}

tBool most_btsetfi_tclMsgStartSearchSPPServicesError::operator==(const most_btsetfi_tclMsgStartSearchSPPServicesError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStartSearchSPPServicesMethodResult::most_btsetfi_tclMsgStartSearchSPPServicesMethodResult(const most_btsetfi_tclMsgStartSearchSPPServicesMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
   u8SearchHandle = coRef.u8SearchHandle;
}
most_btsetfi_tclMsgStartSearchSPPServicesMethodResult& most_btsetfi_tclMsgStartSearchSPPServicesMethodResult::operator=(const most_btsetfi_tclMsgStartSearchSPPServicesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   u8SearchHandle = coRef.u8SearchHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgStartSearchSPPServicesMethodResult::most_btsetfi_tclMsgStartSearchSPPServicesMethodResult()
:bResult(0)
,u8SearchHandle(0)
 {}

tS32 most_btsetfi_tclMsgStartSearchSPPServicesMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StartSearchSPPServicesMethodResult;
}


most_btsetfi_tclMsgStartSearchSPPServicesMethodResult::~most_btsetfi_tclMsgStartSearchSPPServicesMethodResult()
{}

tU32 most_btsetfi_tclMsgStartSearchSPPServicesMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgStartSearchSPPServicesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   (tVoid) (oIn >> u8SearchHandle);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgStartSearchSPPServicesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   (tVoid) (oOut << u8SearchHandle);
   return oOut;
}

tBool most_btsetfi_tclMsgStartSearchSPPServicesMethodResult::operator==(const most_btsetfi_tclMsgStartSearchSPPServicesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   bResult = bResult && (u8SearchHandle == roRef.u8SearchHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStopSearchSPPServicesMethodStart::most_btsetfi_tclMsgStopSearchSPPServicesMethodStart(const most_btsetfi_tclMsgStopSearchSPPServicesMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u8SearchHandle = coRef.u8SearchHandle;
}
most_btsetfi_tclMsgStopSearchSPPServicesMethodStart& most_btsetfi_tclMsgStopSearchSPPServicesMethodStart::operator=(const most_btsetfi_tclMsgStopSearchSPPServicesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u8SearchHandle = coRef.u8SearchHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgStopSearchSPPServicesMethodStart::most_btsetfi_tclMsgStopSearchSPPServicesMethodStart()
:u8DeviceHandle(0)
,u8SearchHandle(0)
 {}

tS32 most_btsetfi_tclMsgStopSearchSPPServicesMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StopSearchSPPServicesMethodStart;
}


most_btsetfi_tclMsgStopSearchSPPServicesMethodStart::~most_btsetfi_tclMsgStopSearchSPPServicesMethodStart()
{}

tU32 most_btsetfi_tclMsgStopSearchSPPServicesMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgStopSearchSPPServicesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u8SearchHandle);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgStopSearchSPPServicesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u8SearchHandle);
   return oOut;
}

tBool most_btsetfi_tclMsgStopSearchSPPServicesMethodStart::operator==(const most_btsetfi_tclMsgStopSearchSPPServicesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u8SearchHandle == roRef.u8SearchHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStopSearchSPPServicesError::most_btsetfi_tclMsgStopSearchSPPServicesError(const most_btsetfi_tclMsgStopSearchSPPServicesError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgStopSearchSPPServicesError& most_btsetfi_tclMsgStopSearchSPPServicesError::operator=(const most_btsetfi_tclMsgStopSearchSPPServicesError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgStopSearchSPPServicesError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StopSearchSPPServicesError;
}


most_btsetfi_tclMsgStopSearchSPPServicesError::~most_btsetfi_tclMsgStopSearchSPPServicesError()
{}

tBool most_btsetfi_tclMsgStopSearchSPPServicesError::operator==(const most_btsetfi_tclMsgStopSearchSPPServicesError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgStopSearchSPPServicesMethodResult::most_btsetfi_tclMsgStopSearchSPPServicesMethodResult(const most_btsetfi_tclMsgStopSearchSPPServicesMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgStopSearchSPPServicesMethodResult& most_btsetfi_tclMsgStopSearchSPPServicesMethodResult::operator=(const most_btsetfi_tclMsgStopSearchSPPServicesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgStopSearchSPPServicesMethodResult::most_btsetfi_tclMsgStopSearchSPPServicesMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgStopSearchSPPServicesMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_StopSearchSPPServicesMethodResult;
}


most_btsetfi_tclMsgStopSearchSPPServicesMethodResult::~most_btsetfi_tclMsgStopSearchSPPServicesMethodResult()
{}

tU32 most_btsetfi_tclMsgStopSearchSPPServicesMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgStopSearchSPPServicesMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgStopSearchSPPServicesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgStopSearchSPPServicesMethodResult::operator==(const most_btsetfi_tclMsgStopSearchSPPServicesMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::most_btsetfi_tclMsgAddOobPairedDeviceMethodStart(const most_btsetfi_tclMsgAddOobPairedDeviceMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sBdAddress = coRef.sBdAddress;
   sBdName = coRef.sBdName;
   sLinkKey = coRef.sLinkKey;
   e8OobType = coRef.e8OobType;
}
most_btsetfi_tclMsgAddOobPairedDeviceMethodStart& most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::operator=(const most_btsetfi_tclMsgAddOobPairedDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sBdAddress = coRef.sBdAddress;
   sBdName = coRef.sBdName;
   sLinkKey = coRef.sLinkKey;
   e8OobType = coRef.e8OobType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::vDestroy()
{
   sBdAddress.vDestroy(); 
   sBdName.vDestroy(); 
   sLinkKey.vDestroy(); 
}

most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::most_btsetfi_tclMsgAddOobPairedDeviceMethodStart()
:sBdAddress()
,sBdName()
,sLinkKey()
,e8OobType()
 {}

tS32 most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AddOobPairedDeviceMethodStart;
}


most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::~most_btsetfi_tclMsgAddOobPairedDeviceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBdAddress.u32GetSize(u16MajorVersion);
   u32DynamicSize += sBdName.u32GetSize(u16MajorVersion);
   u32DynamicSize += sLinkKey.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sBdAddress);
   (tVoid) (oIn >> sBdName);
   (tVoid) (oIn >> sLinkKey);
   (tVoid) (oIn >> e8OobType);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sBdAddress);
   (tVoid) (oOut << sBdName);
   (tVoid) (oOut << sLinkKey);
   (tVoid) (oOut << e8OobType);
   return oOut;
}

tBool most_btsetfi_tclMsgAddOobPairedDeviceMethodStart::operator==(const most_btsetfi_tclMsgAddOobPairedDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sBdAddress == roRef.sBdAddress);
   bResult = bResult && (sBdName == roRef.sBdName);
   bResult = bResult && (sLinkKey == roRef.sLinkKey);
   bResult = bResult && (e8OobType == roRef.e8OobType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAddOobPairedDeviceError::most_btsetfi_tclMsgAddOobPairedDeviceError(const most_btsetfi_tclMsgAddOobPairedDeviceError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgAddOobPairedDeviceError& most_btsetfi_tclMsgAddOobPairedDeviceError::operator=(const most_btsetfi_tclMsgAddOobPairedDeviceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgAddOobPairedDeviceError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AddOobPairedDeviceError;
}


most_btsetfi_tclMsgAddOobPairedDeviceError::~most_btsetfi_tclMsgAddOobPairedDeviceError()
{}

tBool most_btsetfi_tclMsgAddOobPairedDeviceError::operator==(const most_btsetfi_tclMsgAddOobPairedDeviceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAddOobPairedDeviceMethodResult::most_btsetfi_tclMsgAddOobPairedDeviceMethodResult(const most_btsetfi_tclMsgAddOobPairedDeviceMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgAddOobPairedDeviceMethodResult& most_btsetfi_tclMsgAddOobPairedDeviceMethodResult::operator=(const most_btsetfi_tclMsgAddOobPairedDeviceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgAddOobPairedDeviceMethodResult::most_btsetfi_tclMsgAddOobPairedDeviceMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgAddOobPairedDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AddOobPairedDeviceMethodResult;
}


most_btsetfi_tclMsgAddOobPairedDeviceMethodResult::~most_btsetfi_tclMsgAddOobPairedDeviceMethodResult()
{}

tU32 most_btsetfi_tclMsgAddOobPairedDeviceMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgAddOobPairedDeviceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgAddOobPairedDeviceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgAddOobPairedDeviceMethodResult::operator==(const most_btsetfi_tclMsgAddOobPairedDeviceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetFavoriteMethodStart::most_btsetfi_tclMsgSetFavoriteMethodStart(const most_btsetfi_tclMsgSetFavoriteMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8FavoriteType = coRef.e8FavoriteType;
   u8FavoriteIndex = coRef.u8FavoriteIndex;
}
most_btsetfi_tclMsgSetFavoriteMethodStart& most_btsetfi_tclMsgSetFavoriteMethodStart::operator=(const most_btsetfi_tclMsgSetFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8FavoriteType = coRef.e8FavoriteType;
   u8FavoriteIndex = coRef.u8FavoriteIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetFavoriteMethodStart::most_btsetfi_tclMsgSetFavoriteMethodStart()
:u8DeviceHandle(0)
,e8FavoriteType()
,u8FavoriteIndex(0)
 {}

tS32 most_btsetfi_tclMsgSetFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetFavoriteMethodStart;
}


most_btsetfi_tclMsgSetFavoriteMethodStart::~most_btsetfi_tclMsgSetFavoriteMethodStart()
{}

tU32 most_btsetfi_tclMsgSetFavoriteMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_btsetfi_tclMsgSetFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> e8FavoriteType);
   (tVoid) (oIn >> u8FavoriteIndex);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << e8FavoriteType);
   (tVoid) (oOut << u8FavoriteIndex);
   return oOut;
}

tBool most_btsetfi_tclMsgSetFavoriteMethodStart::operator==(const most_btsetfi_tclMsgSetFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (e8FavoriteType == roRef.e8FavoriteType);
   bResult = bResult && (u8FavoriteIndex == roRef.u8FavoriteIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetFavoriteError::most_btsetfi_tclMsgSetFavoriteError(const most_btsetfi_tclMsgSetFavoriteError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSetFavoriteError& most_btsetfi_tclMsgSetFavoriteError::operator=(const most_btsetfi_tclMsgSetFavoriteError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSetFavoriteError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetFavoriteError;
}


most_btsetfi_tclMsgSetFavoriteError::~most_btsetfi_tclMsgSetFavoriteError()
{}

tBool most_btsetfi_tclMsgSetFavoriteError::operator==(const most_btsetfi_tclMsgSetFavoriteError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetFavoriteMethodResult::most_btsetfi_tclMsgSetFavoriteMethodResult(const most_btsetfi_tclMsgSetFavoriteMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgSetFavoriteMethodResult& most_btsetfi_tclMsgSetFavoriteMethodResult::operator=(const most_btsetfi_tclMsgSetFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetFavoriteMethodResult::most_btsetfi_tclMsgSetFavoriteMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgSetFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetFavoriteMethodResult;
}


most_btsetfi_tclMsgSetFavoriteMethodResult::~most_btsetfi_tclMsgSetFavoriteMethodResult()
{}

tU32 most_btsetfi_tclMsgSetFavoriteMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSetFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSetFavoriteMethodResult::operator==(const most_btsetfi_tclMsgSetFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgClearFavoriteMethodStart::most_btsetfi_tclMsgClearFavoriteMethodStart(const most_btsetfi_tclMsgClearFavoriteMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8FavoriteType = coRef.e8FavoriteType;
}
most_btsetfi_tclMsgClearFavoriteMethodStart& most_btsetfi_tclMsgClearFavoriteMethodStart::operator=(const most_btsetfi_tclMsgClearFavoriteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8FavoriteType = coRef.e8FavoriteType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgClearFavoriteMethodStart::most_btsetfi_tclMsgClearFavoriteMethodStart()
:u8DeviceHandle(0)
,e8FavoriteType()
 {}

tS32 most_btsetfi_tclMsgClearFavoriteMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ClearFavoriteMethodStart;
}


most_btsetfi_tclMsgClearFavoriteMethodStart::~most_btsetfi_tclMsgClearFavoriteMethodStart()
{}

tU32 most_btsetfi_tclMsgClearFavoriteMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgClearFavoriteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> e8FavoriteType);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgClearFavoriteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << e8FavoriteType);
   return oOut;
}

tBool most_btsetfi_tclMsgClearFavoriteMethodStart::operator==(const most_btsetfi_tclMsgClearFavoriteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (e8FavoriteType == roRef.e8FavoriteType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgClearFavoriteError::most_btsetfi_tclMsgClearFavoriteError(const most_btsetfi_tclMsgClearFavoriteError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgClearFavoriteError& most_btsetfi_tclMsgClearFavoriteError::operator=(const most_btsetfi_tclMsgClearFavoriteError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgClearFavoriteError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ClearFavoriteError;
}


most_btsetfi_tclMsgClearFavoriteError::~most_btsetfi_tclMsgClearFavoriteError()
{}

tBool most_btsetfi_tclMsgClearFavoriteError::operator==(const most_btsetfi_tclMsgClearFavoriteError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgClearFavoriteMethodResult::most_btsetfi_tclMsgClearFavoriteMethodResult(const most_btsetfi_tclMsgClearFavoriteMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgClearFavoriteMethodResult& most_btsetfi_tclMsgClearFavoriteMethodResult::operator=(const most_btsetfi_tclMsgClearFavoriteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgClearFavoriteMethodResult::most_btsetfi_tclMsgClearFavoriteMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgClearFavoriteMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ClearFavoriteMethodResult;
}


most_btsetfi_tclMsgClearFavoriteMethodResult::~most_btsetfi_tclMsgClearFavoriteMethodResult()
{}

tU32 most_btsetfi_tclMsgClearFavoriteMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgClearFavoriteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgClearFavoriteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgClearFavoriteMethodResult::operator==(const most_btsetfi_tclMsgClearFavoriteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart::most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bMultiHFPSupport = coRef.bMultiHFPSupport;
}
most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart& most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart::operator=(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bMultiHFPSupport = coRef.bMultiHFPSupport;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart::most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart()
:bMultiHFPSupport(0)
 {}

tS32 most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SwitchMultiHFPSupportMethodStart;
}


most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart::~most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart()
{}

tU32 most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMultiHFPSupport);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMultiHFPSupport);
   return oOut;
}

tBool most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart::operator==(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMultiHFPSupport == roRef.bMultiHFPSupport);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSwitchMultiHFPSupportError::most_btsetfi_tclMsgSwitchMultiHFPSupportError(const most_btsetfi_tclMsgSwitchMultiHFPSupportError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSwitchMultiHFPSupportError& most_btsetfi_tclMsgSwitchMultiHFPSupportError::operator=(const most_btsetfi_tclMsgSwitchMultiHFPSupportError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSwitchMultiHFPSupportError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SwitchMultiHFPSupportError;
}


most_btsetfi_tclMsgSwitchMultiHFPSupportError::~most_btsetfi_tclMsgSwitchMultiHFPSupportError()
{}

tBool most_btsetfi_tclMsgSwitchMultiHFPSupportError::operator==(const most_btsetfi_tclMsgSwitchMultiHFPSupportError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult::most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult& most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult::operator=(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult::most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SwitchMultiHFPSupportMethodResult;
}


most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult::~most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult()
{}

tU32 most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult::operator==(const most_btsetfi_tclMsgSwitchMultiHFPSupportMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetPrimaryMethodStart::most_btsetfi_tclMsgSetPrimaryMethodStart(const most_btsetfi_tclMsgSetPrimaryMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_btsetfi_tclMsgSetPrimaryMethodStart& most_btsetfi_tclMsgSetPrimaryMethodStart::operator=(const most_btsetfi_tclMsgSetPrimaryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetPrimaryMethodStart::most_btsetfi_tclMsgSetPrimaryMethodStart()
:u8DeviceHandle(0)
 {}

tS32 most_btsetfi_tclMsgSetPrimaryMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetPrimaryMethodStart;
}


most_btsetfi_tclMsgSetPrimaryMethodStart::~most_btsetfi_tclMsgSetPrimaryMethodStart()
{}

tU32 most_btsetfi_tclMsgSetPrimaryMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSetPrimaryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetPrimaryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_btsetfi_tclMsgSetPrimaryMethodStart::operator==(const most_btsetfi_tclMsgSetPrimaryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetPrimaryError::most_btsetfi_tclMsgSetPrimaryError(const most_btsetfi_tclMsgSetPrimaryError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSetPrimaryError& most_btsetfi_tclMsgSetPrimaryError::operator=(const most_btsetfi_tclMsgSetPrimaryError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSetPrimaryError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetPrimaryError;
}


most_btsetfi_tclMsgSetPrimaryError::~most_btsetfi_tclMsgSetPrimaryError()
{}

tBool most_btsetfi_tclMsgSetPrimaryError::operator==(const most_btsetfi_tclMsgSetPrimaryError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetPrimaryMethodResult::most_btsetfi_tclMsgSetPrimaryMethodResult(const most_btsetfi_tclMsgSetPrimaryMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgSetPrimaryMethodResult& most_btsetfi_tclMsgSetPrimaryMethodResult::operator=(const most_btsetfi_tclMsgSetPrimaryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetPrimaryMethodResult::most_btsetfi_tclMsgSetPrimaryMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgSetPrimaryMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetPrimaryMethodResult;
}


most_btsetfi_tclMsgSetPrimaryMethodResult::~most_btsetfi_tclMsgSetPrimaryMethodResult()
{}

tU32 most_btsetfi_tclMsgSetPrimaryMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSetPrimaryMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetPrimaryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSetPrimaryMethodResult::operator==(const most_btsetfi_tclMsgSetPrimaryMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::most_btsetfi_tclMsgSetBTProfilesUsageMethodStart(const most_btsetfi_tclMsgSetBTProfilesUsageMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oBTProfilesUsageInfoList = coRef.oBTProfilesUsageInfoList;
}
most_btsetfi_tclMsgSetBTProfilesUsageMethodStart& most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::operator=(const most_btsetfi_tclMsgSetBTProfilesUsageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oBTProfilesUsageInfoList = coRef.oBTProfilesUsageInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::vDestroy()
{
}

most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::most_btsetfi_tclMsgSetBTProfilesUsageMethodStart()
:oBTProfilesUsageInfoList()
 {}

tS32 most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetBTProfilesUsageMethodStart;
}


most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::~most_btsetfi_tclMsgSetBTProfilesUsageMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oBTProfilesUsageInfoList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oBTProfilesUsageInfoList);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oBTProfilesUsageInfoList);
   return oOut;
}

tBool most_btsetfi_tclMsgSetBTProfilesUsageMethodStart::operator==(const most_btsetfi_tclMsgSetBTProfilesUsageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oBTProfilesUsageInfoList == roRef.oBTProfilesUsageInfoList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetBTProfilesUsageError::most_btsetfi_tclMsgSetBTProfilesUsageError(const most_btsetfi_tclMsgSetBTProfilesUsageError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSetBTProfilesUsageError& most_btsetfi_tclMsgSetBTProfilesUsageError::operator=(const most_btsetfi_tclMsgSetBTProfilesUsageError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSetBTProfilesUsageError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetBTProfilesUsageError;
}


most_btsetfi_tclMsgSetBTProfilesUsageError::~most_btsetfi_tclMsgSetBTProfilesUsageError()
{}

tBool most_btsetfi_tclMsgSetBTProfilesUsageError::operator==(const most_btsetfi_tclMsgSetBTProfilesUsageError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetBTProfilesUsageMethodResult::most_btsetfi_tclMsgSetBTProfilesUsageMethodResult(const most_btsetfi_tclMsgSetBTProfilesUsageMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgSetBTProfilesUsageMethodResult& most_btsetfi_tclMsgSetBTProfilesUsageMethodResult::operator=(const most_btsetfi_tclMsgSetBTProfilesUsageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetBTProfilesUsageMethodResult::most_btsetfi_tclMsgSetBTProfilesUsageMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgSetBTProfilesUsageMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetBTProfilesUsageMethodResult;
}


most_btsetfi_tclMsgSetBTProfilesUsageMethodResult::~most_btsetfi_tclMsgSetBTProfilesUsageMethodResult()
{}

tU32 most_btsetfi_tclMsgSetBTProfilesUsageMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSetBTProfilesUsageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetBTProfilesUsageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSetBTProfilesUsageMethodResult::operator==(const most_btsetfi_tclMsgSetBTProfilesUsageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgResolveConflictsMethodStart::most_btsetfi_tclMsgResolveConflictsMethodStart(const most_btsetfi_tclMsgResolveConflictsMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8ConflictTrigger = coRef.e8ConflictTrigger;
   e8ResolutionType = coRef.e8ResolutionType;
}
most_btsetfi_tclMsgResolveConflictsMethodStart& most_btsetfi_tclMsgResolveConflictsMethodStart::operator=(const most_btsetfi_tclMsgResolveConflictsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ConflictTrigger = coRef.e8ConflictTrigger;
   e8ResolutionType = coRef.e8ResolutionType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgResolveConflictsMethodStart::most_btsetfi_tclMsgResolveConflictsMethodStart()
:e8ConflictTrigger()
,e8ResolutionType()
 {}

tS32 most_btsetfi_tclMsgResolveConflictsMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ResolveConflictsMethodStart;
}


most_btsetfi_tclMsgResolveConflictsMethodStart::~most_btsetfi_tclMsgResolveConflictsMethodStart()
{}

tU32 most_btsetfi_tclMsgResolveConflictsMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgResolveConflictsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConflictTrigger);
   (tVoid) (oIn >> e8ResolutionType);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgResolveConflictsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConflictTrigger);
   (tVoid) (oOut << e8ResolutionType);
   return oOut;
}

tBool most_btsetfi_tclMsgResolveConflictsMethodStart::operator==(const most_btsetfi_tclMsgResolveConflictsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConflictTrigger == roRef.e8ConflictTrigger);
   bResult = bResult && (e8ResolutionType == roRef.e8ResolutionType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgResolveConflictsError::most_btsetfi_tclMsgResolveConflictsError(const most_btsetfi_tclMsgResolveConflictsError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgResolveConflictsError& most_btsetfi_tclMsgResolveConflictsError::operator=(const most_btsetfi_tclMsgResolveConflictsError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgResolveConflictsError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ResolveConflictsError;
}


most_btsetfi_tclMsgResolveConflictsError::~most_btsetfi_tclMsgResolveConflictsError()
{}

tBool most_btsetfi_tclMsgResolveConflictsError::operator==(const most_btsetfi_tclMsgResolveConflictsError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgResolveConflictsMethodResult::most_btsetfi_tclMsgResolveConflictsMethodResult(const most_btsetfi_tclMsgResolveConflictsMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgResolveConflictsMethodResult& most_btsetfi_tclMsgResolveConflictsMethodResult::operator=(const most_btsetfi_tclMsgResolveConflictsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgResolveConflictsMethodResult::most_btsetfi_tclMsgResolveConflictsMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgResolveConflictsMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ResolveConflictsMethodResult;
}


most_btsetfi_tclMsgResolveConflictsMethodResult::~most_btsetfi_tclMsgResolveConflictsMethodResult()
{}

tU32 most_btsetfi_tclMsgResolveConflictsMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgResolveConflictsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgResolveConflictsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgResolveConflictsMethodResult::operator==(const most_btsetfi_tclMsgResolveConflictsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart::most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8DeviceUsagePreference = coRef.e8DeviceUsagePreference;
}
most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart& most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart::operator=(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   e8DeviceUsagePreference = coRef.e8DeviceUsagePreference;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart::most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart()
:u8DeviceHandle(0)
,e8DeviceUsagePreference()
 {}

tS32 most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetDeviceUsagePreferenceMethodStart;
}


most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart::~most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart()
{}

tU32 most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> e8DeviceUsagePreference);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << e8DeviceUsagePreference);
   return oOut;
}

tBool most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart::operator==(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (e8DeviceUsagePreference == roRef.e8DeviceUsagePreference);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetDeviceUsagePreferenceError::most_btsetfi_tclMsgSetDeviceUsagePreferenceError(const most_btsetfi_tclMsgSetDeviceUsagePreferenceError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSetDeviceUsagePreferenceError& most_btsetfi_tclMsgSetDeviceUsagePreferenceError::operator=(const most_btsetfi_tclMsgSetDeviceUsagePreferenceError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSetDeviceUsagePreferenceError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetDeviceUsagePreferenceError;
}


most_btsetfi_tclMsgSetDeviceUsagePreferenceError::~most_btsetfi_tclMsgSetDeviceUsagePreferenceError()
{}

tBool most_btsetfi_tclMsgSetDeviceUsagePreferenceError::operator==(const most_btsetfi_tclMsgSetDeviceUsagePreferenceError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult::most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult& most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult::operator=(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult::most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetDeviceUsagePreferenceMethodResult;
}


most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult::~most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult()
{}

tU32 most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult::operator==(const most_btsetfi_tclMsgSetDeviceUsagePreferenceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart::most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8Profile = coRef.e8Profile;
   e8UserAvailable = coRef.e8UserAvailable;
}
most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart& most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart::operator=(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Profile = coRef.e8Profile;
   e8UserAvailable = coRef.e8UserAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart::most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart()
:e8Profile()
,e8UserAvailable()
 {}

tS32 most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetProfileUserAvailabilityMethodStart;
}


most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart::~most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart()
{}

tU32 most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Profile);
   (tVoid) (oIn >> e8UserAvailable);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Profile);
   (tVoid) (oOut << e8UserAvailable);
   return oOut;
}

tBool most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart::operator==(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Profile == roRef.e8Profile);
   bResult = bResult && (e8UserAvailable == roRef.e8UserAvailable);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetProfileUserAvailabilityError::most_btsetfi_tclMsgSetProfileUserAvailabilityError(const most_btsetfi_tclMsgSetProfileUserAvailabilityError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSetProfileUserAvailabilityError& most_btsetfi_tclMsgSetProfileUserAvailabilityError::operator=(const most_btsetfi_tclMsgSetProfileUserAvailabilityError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSetProfileUserAvailabilityError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetProfileUserAvailabilityError;
}


most_btsetfi_tclMsgSetProfileUserAvailabilityError::~most_btsetfi_tclMsgSetProfileUserAvailabilityError()
{}

tBool most_btsetfi_tclMsgSetProfileUserAvailabilityError::operator==(const most_btsetfi_tclMsgSetProfileUserAvailabilityError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult::most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult& most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult::operator=(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult::most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SetProfileUserAvailabilityMethodResult;
}


most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult::~most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult()
{}

tU32 most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult::operator==(const most_btsetfi_tclMsgSetProfileUserAvailabilityMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oLimitationModeToBeReplaced = coRef.oLimitationModeToBeReplaced;
   oNewLimitationMode = coRef.oNewLimitationMode;
}
most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart& most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::operator=(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   oLimitationModeToBeReplaced = coRef.oLimitationModeToBeReplaced;
   oNewLimitationMode = coRef.oNewLimitationMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::vDestroy()
{
   oLimitationModeToBeReplaced.vDestroy(); 
   oNewLimitationMode.vDestroy(); 
}

most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart()
:oLimitationModeToBeReplaced()
,oNewLimitationMode()
 {}

tS32 most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ReplaceBluetoothLimitationModeMethodStart;
}


most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::~most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oLimitationModeToBeReplaced.u32GetSize(u16MajorVersion);
   u32DynamicSize += oNewLimitationMode.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oLimitationModeToBeReplaced);
   (tVoid) (oIn >> oNewLimitationMode);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oLimitationModeToBeReplaced);
   (tVoid) (oOut << oNewLimitationMode);
   return oOut;
}

tBool most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart::operator==(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oLimitationModeToBeReplaced == roRef.oLimitationModeToBeReplaced);
   bResult = bResult && (oNewLimitationMode == roRef.oNewLimitationMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgReplaceBluetoothLimitationModeError::most_btsetfi_tclMsgReplaceBluetoothLimitationModeError(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgReplaceBluetoothLimitationModeError& most_btsetfi_tclMsgReplaceBluetoothLimitationModeError::operator=(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgReplaceBluetoothLimitationModeError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ReplaceBluetoothLimitationModeError;
}


most_btsetfi_tclMsgReplaceBluetoothLimitationModeError::~most_btsetfi_tclMsgReplaceBluetoothLimitationModeError()
{}

tBool most_btsetfi_tclMsgReplaceBluetoothLimitationModeError::operator==(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult::most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult& most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult::operator=(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult::most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult()
:bResult(0)
 {}

tS32 most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ReplaceBluetoothLimitationModeMethodResult;
}


most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult::~most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult()
{}

tU32 most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult::operator==(const most_btsetfi_tclMsgReplaceBluetoothLimitationModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgBluetoothOnOffUpReg::most_btsetfi_tclMsgBluetoothOnOffUpReg()
 {}

tS32 most_btsetfi_tclMsgBluetoothOnOffUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothOnOffUpReg;
}


most_btsetfi_tclMsgBluetoothOnOffUpReg::~most_btsetfi_tclMsgBluetoothOnOffUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgBluetoothOnOffRelUpReg::most_btsetfi_tclMsgBluetoothOnOffRelUpReg()
 {}

tS32 most_btsetfi_tclMsgBluetoothOnOffRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothOnOffRelUpReg;
}


most_btsetfi_tclMsgBluetoothOnOffRelUpReg::~most_btsetfi_tclMsgBluetoothOnOffRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgBluetoothOnOffGet::most_btsetfi_tclMsgBluetoothOnOffGet()
 {}

tS32 most_btsetfi_tclMsgBluetoothOnOffGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothOnOffGet;
}


most_btsetfi_tclMsgBluetoothOnOffGet::~most_btsetfi_tclMsgBluetoothOnOffGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgBluetoothOnOffSet::most_btsetfi_tclMsgBluetoothOnOffSet(const most_btsetfi_tclMsgBluetoothOnOffSet& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bBTOnOff = coRef.bBTOnOff;
}
most_btsetfi_tclMsgBluetoothOnOffSet& most_btsetfi_tclMsgBluetoothOnOffSet::operator=(const most_btsetfi_tclMsgBluetoothOnOffSet& coRef)
{
   if (this == &coRef) return *this;
   bBTOnOff = coRef.bBTOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgBluetoothOnOffSet::most_btsetfi_tclMsgBluetoothOnOffSet()
:bBTOnOff(0)
 {}

tS32 most_btsetfi_tclMsgBluetoothOnOffSet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothOnOffSet;
}


most_btsetfi_tclMsgBluetoothOnOffSet::~most_btsetfi_tclMsgBluetoothOnOffSet()
{}

tU32 most_btsetfi_tclMsgBluetoothOnOffSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgBluetoothOnOffSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bBTOnOff);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgBluetoothOnOffSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bBTOnOff);
   return oOut;
}

tBool most_btsetfi_tclMsgBluetoothOnOffSet::operator==(const most_btsetfi_tclMsgBluetoothOnOffSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bBTOnOff == roRef.bBTOnOff);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgBluetoothOnOffError::most_btsetfi_tclMsgBluetoothOnOffError(const most_btsetfi_tclMsgBluetoothOnOffError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgBluetoothOnOffError& most_btsetfi_tclMsgBluetoothOnOffError::operator=(const most_btsetfi_tclMsgBluetoothOnOffError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgBluetoothOnOffError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothOnOffError;
}


most_btsetfi_tclMsgBluetoothOnOffError::~most_btsetfi_tclMsgBluetoothOnOffError()
{}

tBool most_btsetfi_tclMsgBluetoothOnOffError::operator==(const most_btsetfi_tclMsgBluetoothOnOffError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgBluetoothOnOffStatus::most_btsetfi_tclMsgBluetoothOnOffStatus(const most_btsetfi_tclMsgBluetoothOnOffStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bBTOnOff = coRef.bBTOnOff;
}
most_btsetfi_tclMsgBluetoothOnOffStatus& most_btsetfi_tclMsgBluetoothOnOffStatus::operator=(const most_btsetfi_tclMsgBluetoothOnOffStatus& coRef)
{
   if (this == &coRef) return *this;
   bBTOnOff = coRef.bBTOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgBluetoothOnOffStatus::most_btsetfi_tclMsgBluetoothOnOffStatus()
:bBTOnOff(0)
 {}

tS32 most_btsetfi_tclMsgBluetoothOnOffStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothOnOffStatus;
}


most_btsetfi_tclMsgBluetoothOnOffStatus::~most_btsetfi_tclMsgBluetoothOnOffStatus()
{}

tU32 most_btsetfi_tclMsgBluetoothOnOffStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgBluetoothOnOffStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bBTOnOff);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgBluetoothOnOffStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bBTOnOff);
   return oOut;
}

tBool most_btsetfi_tclMsgBluetoothOnOffStatus::operator==(const most_btsetfi_tclMsgBluetoothOnOffStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bBTOnOff == roRef.bBTOnOff);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgPairingStatusUpReg::most_btsetfi_tclMsgPairingStatusUpReg()
 {}

tS32 most_btsetfi_tclMsgPairingStatusUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingStatusUpReg;
}


most_btsetfi_tclMsgPairingStatusUpReg::~most_btsetfi_tclMsgPairingStatusUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgPairingStatusRelUpReg::most_btsetfi_tclMsgPairingStatusRelUpReg()
 {}

tS32 most_btsetfi_tclMsgPairingStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingStatusRelUpReg;
}


most_btsetfi_tclMsgPairingStatusRelUpReg::~most_btsetfi_tclMsgPairingStatusRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgPairingStatusGet::most_btsetfi_tclMsgPairingStatusGet()
 {}

tS32 most_btsetfi_tclMsgPairingStatusGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingStatusGet;
}


most_btsetfi_tclMsgPairingStatusGet::~most_btsetfi_tclMsgPairingStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairingStatusError::most_btsetfi_tclMsgPairingStatusError(const most_btsetfi_tclMsgPairingStatusError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgPairingStatusError& most_btsetfi_tclMsgPairingStatusError::operator=(const most_btsetfi_tclMsgPairingStatusError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgPairingStatusError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingStatusError;
}


most_btsetfi_tclMsgPairingStatusError::~most_btsetfi_tclMsgPairingStatusError()
{}

tBool most_btsetfi_tclMsgPairingStatusError::operator==(const most_btsetfi_tclMsgPairingStatusError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairingStatusStatus::most_btsetfi_tclMsgPairingStatusStatus(const most_btsetfi_tclMsgPairingStatusStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8PairingStatusType = coRef.e8PairingStatusType;
   u8DeviceHandle = coRef.u8DeviceHandle;
   sDeviceName = coRef.sDeviceName;
}
most_btsetfi_tclMsgPairingStatusStatus& most_btsetfi_tclMsgPairingStatusStatus::operator=(const most_btsetfi_tclMsgPairingStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8PairingStatusType = coRef.e8PairingStatusType;
   u8DeviceHandle = coRef.u8DeviceHandle;
   sDeviceName = coRef.sDeviceName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgPairingStatusStatus::vDestroy()
{
   sDeviceName.vDestroy(); 
}

most_btsetfi_tclMsgPairingStatusStatus::most_btsetfi_tclMsgPairingStatusStatus()
:e8PairingStatusType()
,u8DeviceHandle(0)
,sDeviceName()
 {}

tS32 most_btsetfi_tclMsgPairingStatusStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingStatusStatus;
}


most_btsetfi_tclMsgPairingStatusStatus::~most_btsetfi_tclMsgPairingStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgPairingStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sDeviceName.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgPairingStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8PairingStatusType);
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> sDeviceName);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgPairingStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8PairingStatusType);
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << sDeviceName);
   return oOut;
}

tBool most_btsetfi_tclMsgPairingStatusStatus::operator==(const most_btsetfi_tclMsgPairingStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8PairingStatusType == roRef.e8PairingStatusType);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgChangeRingtoneUpReg::most_btsetfi_tclMsgChangeRingtoneUpReg()
 {}

tS32 most_btsetfi_tclMsgChangeRingtoneUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeRingtoneUpReg;
}


most_btsetfi_tclMsgChangeRingtoneUpReg::~most_btsetfi_tclMsgChangeRingtoneUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgChangeRingtoneRelUpReg::most_btsetfi_tclMsgChangeRingtoneRelUpReg()
 {}

tS32 most_btsetfi_tclMsgChangeRingtoneRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeRingtoneRelUpReg;
}


most_btsetfi_tclMsgChangeRingtoneRelUpReg::~most_btsetfi_tclMsgChangeRingtoneRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangeRingtonePureSet::most_btsetfi_tclMsgChangeRingtonePureSet(const most_btsetfi_tclMsgChangeRingtonePureSet& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16RingtoneID = coRef.u16RingtoneID;
}
most_btsetfi_tclMsgChangeRingtonePureSet& most_btsetfi_tclMsgChangeRingtonePureSet::operator=(const most_btsetfi_tclMsgChangeRingtonePureSet& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16RingtoneID = coRef.u16RingtoneID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgChangeRingtonePureSet::most_btsetfi_tclMsgChangeRingtonePureSet()
:u8DeviceHandle(0)
,u16RingtoneID(0)
 {}

tS32 most_btsetfi_tclMsgChangeRingtonePureSet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeRingtonePureSet;
}


most_btsetfi_tclMsgChangeRingtonePureSet::~most_btsetfi_tclMsgChangeRingtonePureSet()
{}

tU32 most_btsetfi_tclMsgChangeRingtonePureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 3;
}

fi_tclInContext& most_btsetfi_tclMsgChangeRingtonePureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u16RingtoneID);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgChangeRingtonePureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u16RingtoneID);
   return oOut;
}

tBool most_btsetfi_tclMsgChangeRingtonePureSet::operator==(const most_btsetfi_tclMsgChangeRingtonePureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u16RingtoneID == roRef.u16RingtoneID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangeRingtoneError::most_btsetfi_tclMsgChangeRingtoneError(const most_btsetfi_tclMsgChangeRingtoneError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgChangeRingtoneError& most_btsetfi_tclMsgChangeRingtoneError::operator=(const most_btsetfi_tclMsgChangeRingtoneError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgChangeRingtoneError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeRingtoneError;
}


most_btsetfi_tclMsgChangeRingtoneError::~most_btsetfi_tclMsgChangeRingtoneError()
{}

tBool most_btsetfi_tclMsgChangeRingtoneError::operator==(const most_btsetfi_tclMsgChangeRingtoneError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgChangeRingtoneStatus::most_btsetfi_tclMsgChangeRingtoneStatus(const most_btsetfi_tclMsgChangeRingtoneStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16RingtoneID = coRef.u16RingtoneID;
   sRingtoneName = coRef.sRingtoneName;
}
most_btsetfi_tclMsgChangeRingtoneStatus& most_btsetfi_tclMsgChangeRingtoneStatus::operator=(const most_btsetfi_tclMsgChangeRingtoneStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   u16RingtoneID = coRef.u16RingtoneID;
   sRingtoneName = coRef.sRingtoneName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgChangeRingtoneStatus::vDestroy()
{
   sRingtoneName.vDestroy(); 
}

most_btsetfi_tclMsgChangeRingtoneStatus::most_btsetfi_tclMsgChangeRingtoneStatus()
:u8DeviceHandle(0)
,u16RingtoneID(0)
,sRingtoneName()
 {}

tS32 most_btsetfi_tclMsgChangeRingtoneStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ChangeRingtoneStatus;
}


most_btsetfi_tclMsgChangeRingtoneStatus::~most_btsetfi_tclMsgChangeRingtoneStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgChangeRingtoneStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sRingtoneName.u32GetSize(u16MajorVersion);
   return 3 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgChangeRingtoneStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> u16RingtoneID);
   (tVoid) (oIn >> sRingtoneName);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgChangeRingtoneStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << u16RingtoneID);
   (tVoid) (oOut << sRingtoneName);
   return oOut;
}

tBool most_btsetfi_tclMsgChangeRingtoneStatus::operator==(const most_btsetfi_tclMsgChangeRingtoneStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (u16RingtoneID == roRef.u16RingtoneID);
   bResult = bResult && (sRingtoneName == roRef.sRingtoneName);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg::most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNameUpReg;
}


most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg::~most_btsetfi_tclMsgVehicleBTFriendlyNameUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg::most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNameRelUpReg;
}


most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg::~most_btsetfi_tclMsgVehicleBTFriendlyNameRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleBTFriendlyNameGet::most_btsetfi_tclMsgVehicleBTFriendlyNameGet()
 {}

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNameGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNameGet;
}


most_btsetfi_tclMsgVehicleBTFriendlyNameGet::~most_btsetfi_tclMsgVehicleBTFriendlyNameGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleBTFriendlyNameError::most_btsetfi_tclMsgVehicleBTFriendlyNameError(const most_btsetfi_tclMsgVehicleBTFriendlyNameError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgVehicleBTFriendlyNameError& most_btsetfi_tclMsgVehicleBTFriendlyNameError::operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNameError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNameError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNameError;
}


most_btsetfi_tclMsgVehicleBTFriendlyNameError::~most_btsetfi_tclMsgVehicleBTFriendlyNameError()
{}

tBool most_btsetfi_tclMsgVehicleBTFriendlyNameError::operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNameError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::most_btsetfi_tclMsgVehicleBTFriendlyNameStatus(const most_btsetfi_tclMsgVehicleBTFriendlyNameStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sVehicleBTFriendlyName = coRef.sVehicleBTFriendlyName;
}
most_btsetfi_tclMsgVehicleBTFriendlyNameStatus& most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNameStatus& coRef)
{
   if (this == &coRef) return *this;
   sVehicleBTFriendlyName = coRef.sVehicleBTFriendlyName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::vDestroy()
{
   sVehicleBTFriendlyName.vDestroy(); 
}

most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::most_btsetfi_tclMsgVehicleBTFriendlyNameStatus()
:sVehicleBTFriendlyName()
 {}

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNameStatus;
}


most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::~most_btsetfi_tclMsgVehicleBTFriendlyNameStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sVehicleBTFriendlyName.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sVehicleBTFriendlyName);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sVehicleBTFriendlyName);
   return oOut;
}

tBool most_btsetfi_tclMsgVehicleBTFriendlyNameStatus::operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNameStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sVehicleBTFriendlyName == roRef.sVehicleBTFriendlyName);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgBluetoothAudioSourceUpReg::most_btsetfi_tclMsgBluetoothAudioSourceUpReg()
 {}

tS32 most_btsetfi_tclMsgBluetoothAudioSourceUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourceUpReg;
}


most_btsetfi_tclMsgBluetoothAudioSourceUpReg::~most_btsetfi_tclMsgBluetoothAudioSourceUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg::most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg()
 {}

tS32 most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourceRelUpReg;
}


most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg::~most_btsetfi_tclMsgBluetoothAudioSourceRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgBluetoothAudioSourceGet::most_btsetfi_tclMsgBluetoothAudioSourceGet()
 {}

tS32 most_btsetfi_tclMsgBluetoothAudioSourceGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourceGet;
}


most_btsetfi_tclMsgBluetoothAudioSourceGet::~most_btsetfi_tclMsgBluetoothAudioSourceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgBluetoothAudioSourcePureSet::most_btsetfi_tclMsgBluetoothAudioSourcePureSet(const most_btsetfi_tclMsgBluetoothAudioSourcePureSet& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_btsetfi_tclMsgBluetoothAudioSourcePureSet& most_btsetfi_tclMsgBluetoothAudioSourcePureSet::operator=(const most_btsetfi_tclMsgBluetoothAudioSourcePureSet& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgBluetoothAudioSourcePureSet::most_btsetfi_tclMsgBluetoothAudioSourcePureSet()
:u8DeviceHandle(0)
 {}

tS32 most_btsetfi_tclMsgBluetoothAudioSourcePureSet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourcePureSet;
}


most_btsetfi_tclMsgBluetoothAudioSourcePureSet::~most_btsetfi_tclMsgBluetoothAudioSourcePureSet()
{}

tU32 most_btsetfi_tclMsgBluetoothAudioSourcePureSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgBluetoothAudioSourcePureSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgBluetoothAudioSourcePureSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_btsetfi_tclMsgBluetoothAudioSourcePureSet::operator==(const most_btsetfi_tclMsgBluetoothAudioSourcePureSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgBluetoothAudioSourceStatus::most_btsetfi_tclMsgBluetoothAudioSourceStatus(const most_btsetfi_tclMsgBluetoothAudioSourceStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   oDeviceControlSupport = coRef.oDeviceControlSupport;
}
most_btsetfi_tclMsgBluetoothAudioSourceStatus& most_btsetfi_tclMsgBluetoothAudioSourceStatus::operator=(const most_btsetfi_tclMsgBluetoothAudioSourceStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   oDeviceControlSupport = coRef.oDeviceControlSupport;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgBluetoothAudioSourceStatus::most_btsetfi_tclMsgBluetoothAudioSourceStatus()
:u8DeviceHandle(0)
,oDeviceControlSupport()
 {}

tS32 most_btsetfi_tclMsgBluetoothAudioSourceStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothAudioSourceStatus;
}


most_btsetfi_tclMsgBluetoothAudioSourceStatus::~most_btsetfi_tclMsgBluetoothAudioSourceStatus()
{}

tU32 most_btsetfi_tclMsgBluetoothAudioSourceStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 13;
}

fi_tclInContext& most_btsetfi_tclMsgBluetoothAudioSourceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> oDeviceControlSupport);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgBluetoothAudioSourceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << oDeviceControlSupport);
   return oOut;
}

tBool most_btsetfi_tclMsgBluetoothAudioSourceStatus::operator==(const most_btsetfi_tclMsgBluetoothAudioSourceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (oDeviceControlSupport == roRef.oDeviceControlSupport);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgPairingPinUpReg::most_btsetfi_tclMsgPairingPinUpReg()
 {}

tS32 most_btsetfi_tclMsgPairingPinUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingPinUpReg;
}


most_btsetfi_tclMsgPairingPinUpReg::~most_btsetfi_tclMsgPairingPinUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgPairingPinRelUpReg::most_btsetfi_tclMsgPairingPinRelUpReg()
 {}

tS32 most_btsetfi_tclMsgPairingPinRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingPinRelUpReg;
}


most_btsetfi_tclMsgPairingPinRelUpReg::~most_btsetfi_tclMsgPairingPinRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgPairingPinGet::most_btsetfi_tclMsgPairingPinGet()
 {}

tS32 most_btsetfi_tclMsgPairingPinGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingPinGet;
}


most_btsetfi_tclMsgPairingPinGet::~most_btsetfi_tclMsgPairingPinGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairingPinStatus::most_btsetfi_tclMsgPairingPinStatus(const most_btsetfi_tclMsgPairingPinStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sPinNumber = coRef.sPinNumber;
}
most_btsetfi_tclMsgPairingPinStatus& most_btsetfi_tclMsgPairingPinStatus::operator=(const most_btsetfi_tclMsgPairingPinStatus& coRef)
{
   if (this == &coRef) return *this;
   sPinNumber = coRef.sPinNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgPairingPinStatus::vDestroy()
{
   sPinNumber.vDestroy(); 
}

most_btsetfi_tclMsgPairingPinStatus::most_btsetfi_tclMsgPairingPinStatus()
:sPinNumber()
 {}

tS32 most_btsetfi_tclMsgPairingPinStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingPinStatus;
}


most_btsetfi_tclMsgPairingPinStatus::~most_btsetfi_tclMsgPairingPinStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgPairingPinStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sPinNumber.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgPairingPinStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPinNumber);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgPairingPinStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPinNumber);
   return oOut;
}

tBool most_btsetfi_tclMsgPairingPinStatus::operator==(const most_btsetfi_tclMsgPairingPinStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPinNumber == roRef.sPinNumber);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgMaxDevicesPairedUpReg::most_btsetfi_tclMsgMaxDevicesPairedUpReg()
 {}

tS32 most_btsetfi_tclMsgMaxDevicesPairedUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MaxDevicesPairedUpReg;
}


most_btsetfi_tclMsgMaxDevicesPairedUpReg::~most_btsetfi_tclMsgMaxDevicesPairedUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgMaxDevicesPairedRelUpReg::most_btsetfi_tclMsgMaxDevicesPairedRelUpReg()
 {}

tS32 most_btsetfi_tclMsgMaxDevicesPairedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MaxDevicesPairedRelUpReg;
}


most_btsetfi_tclMsgMaxDevicesPairedRelUpReg::~most_btsetfi_tclMsgMaxDevicesPairedRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgMaxDevicesPairedGet::most_btsetfi_tclMsgMaxDevicesPairedGet()
 {}

tS32 most_btsetfi_tclMsgMaxDevicesPairedGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MaxDevicesPairedGet;
}


most_btsetfi_tclMsgMaxDevicesPairedGet::~most_btsetfi_tclMsgMaxDevicesPairedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgMaxDevicesPairedError::most_btsetfi_tclMsgMaxDevicesPairedError(const most_btsetfi_tclMsgMaxDevicesPairedError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgMaxDevicesPairedError& most_btsetfi_tclMsgMaxDevicesPairedError::operator=(const most_btsetfi_tclMsgMaxDevicesPairedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgMaxDevicesPairedError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MaxDevicesPairedError;
}


most_btsetfi_tclMsgMaxDevicesPairedError::~most_btsetfi_tclMsgMaxDevicesPairedError()
{}

tBool most_btsetfi_tclMsgMaxDevicesPairedError::operator==(const most_btsetfi_tclMsgMaxDevicesPairedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgMaxDevicesPairedStatus::most_btsetfi_tclMsgMaxDevicesPairedStatus(const most_btsetfi_tclMsgMaxDevicesPairedStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8DeviceHandle = coRef.u8DeviceHandle;
   sDeviceName = coRef.sDeviceName;
}
most_btsetfi_tclMsgMaxDevicesPairedStatus& most_btsetfi_tclMsgMaxDevicesPairedStatus::operator=(const most_btsetfi_tclMsgMaxDevicesPairedStatus& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceHandle = coRef.u8DeviceHandle;
   sDeviceName = coRef.sDeviceName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgMaxDevicesPairedStatus::vDestroy()
{
   sDeviceName.vDestroy(); 
}

most_btsetfi_tclMsgMaxDevicesPairedStatus::most_btsetfi_tclMsgMaxDevicesPairedStatus()
:u8DeviceHandle(0)
,sDeviceName()
 {}

tS32 most_btsetfi_tclMsgMaxDevicesPairedStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MaxDevicesPairedStatus;
}


most_btsetfi_tclMsgMaxDevicesPairedStatus::~most_btsetfi_tclMsgMaxDevicesPairedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgMaxDevicesPairedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sDeviceName.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgMaxDevicesPairedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceHandle);
   (tVoid) (oIn >> sDeviceName);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgMaxDevicesPairedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceHandle);
   (tVoid) (oOut << sDeviceName);
   return oOut;
}

tBool most_btsetfi_tclMsgMaxDevicesPairedStatus::operator==(const most_btsetfi_tclMsgMaxDevicesPairedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgAutoConnectOnOffUpReg::most_btsetfi_tclMsgAutoConnectOnOffUpReg()
 {}

tS32 most_btsetfi_tclMsgAutoConnectOnOffUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffUpReg;
}


most_btsetfi_tclMsgAutoConnectOnOffUpReg::~most_btsetfi_tclMsgAutoConnectOnOffUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgAutoConnectOnOffRelUpReg::most_btsetfi_tclMsgAutoConnectOnOffRelUpReg()
 {}

tS32 most_btsetfi_tclMsgAutoConnectOnOffRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffRelUpReg;
}


most_btsetfi_tclMsgAutoConnectOnOffRelUpReg::~most_btsetfi_tclMsgAutoConnectOnOffRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAutoConnectOnOffSet::most_btsetfi_tclMsgAutoConnectOnOffSet(const most_btsetfi_tclMsgAutoConnectOnOffSet& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bAutoConnectOnOff = coRef.bAutoConnectOnOff;
}
most_btsetfi_tclMsgAutoConnectOnOffSet& most_btsetfi_tclMsgAutoConnectOnOffSet::operator=(const most_btsetfi_tclMsgAutoConnectOnOffSet& coRef)
{
   if (this == &coRef) return *this;
   bAutoConnectOnOff = coRef.bAutoConnectOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgAutoConnectOnOffSet::most_btsetfi_tclMsgAutoConnectOnOffSet()
:bAutoConnectOnOff(0)
 {}

tS32 most_btsetfi_tclMsgAutoConnectOnOffSet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffSet;
}


most_btsetfi_tclMsgAutoConnectOnOffSet::~most_btsetfi_tclMsgAutoConnectOnOffSet()
{}

tU32 most_btsetfi_tclMsgAutoConnectOnOffSet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgAutoConnectOnOffSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAutoConnectOnOff);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgAutoConnectOnOffSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAutoConnectOnOff);
   return oOut;
}

tBool most_btsetfi_tclMsgAutoConnectOnOffSet::operator==(const most_btsetfi_tclMsgAutoConnectOnOffSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAutoConnectOnOff == roRef.bAutoConnectOnOff);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAutoConnectOnOffError::most_btsetfi_tclMsgAutoConnectOnOffError(const most_btsetfi_tclMsgAutoConnectOnOffError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgAutoConnectOnOffError& most_btsetfi_tclMsgAutoConnectOnOffError::operator=(const most_btsetfi_tclMsgAutoConnectOnOffError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgAutoConnectOnOffError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffError;
}


most_btsetfi_tclMsgAutoConnectOnOffError::~most_btsetfi_tclMsgAutoConnectOnOffError()
{}

tBool most_btsetfi_tclMsgAutoConnectOnOffError::operator==(const most_btsetfi_tclMsgAutoConnectOnOffError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAutoConnectOnOffGet::most_btsetfi_tclMsgAutoConnectOnOffGet(const most_btsetfi_tclMsgAutoConnectOnOffGet& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bAutoConnectOnOff = coRef.bAutoConnectOnOff;
}
most_btsetfi_tclMsgAutoConnectOnOffGet& most_btsetfi_tclMsgAutoConnectOnOffGet::operator=(const most_btsetfi_tclMsgAutoConnectOnOffGet& coRef)
{
   if (this == &coRef) return *this;
   bAutoConnectOnOff = coRef.bAutoConnectOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgAutoConnectOnOffGet::most_btsetfi_tclMsgAutoConnectOnOffGet()
:bAutoConnectOnOff(0)
 {}

tS32 most_btsetfi_tclMsgAutoConnectOnOffGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffGet;
}


most_btsetfi_tclMsgAutoConnectOnOffGet::~most_btsetfi_tclMsgAutoConnectOnOffGet()
{}

tU32 most_btsetfi_tclMsgAutoConnectOnOffGet::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgAutoConnectOnOffGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAutoConnectOnOff);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgAutoConnectOnOffGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAutoConnectOnOff);
   return oOut;
}

tBool most_btsetfi_tclMsgAutoConnectOnOffGet::operator==(const most_btsetfi_tclMsgAutoConnectOnOffGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAutoConnectOnOff == roRef.bAutoConnectOnOff);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAutoConnectOnOffStatus::most_btsetfi_tclMsgAutoConnectOnOffStatus(const most_btsetfi_tclMsgAutoConnectOnOffStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   bAutoConnectOnOff = coRef.bAutoConnectOnOff;
}
most_btsetfi_tclMsgAutoConnectOnOffStatus& most_btsetfi_tclMsgAutoConnectOnOffStatus::operator=(const most_btsetfi_tclMsgAutoConnectOnOffStatus& coRef)
{
   if (this == &coRef) return *this;
   bAutoConnectOnOff = coRef.bAutoConnectOnOff;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgAutoConnectOnOffStatus::most_btsetfi_tclMsgAutoConnectOnOffStatus()
:bAutoConnectOnOff(0)
 {}

tS32 most_btsetfi_tclMsgAutoConnectOnOffStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectOnOffStatus;
}


most_btsetfi_tclMsgAutoConnectOnOffStatus::~most_btsetfi_tclMsgAutoConnectOnOffStatus()
{}

tU32 most_btsetfi_tclMsgAutoConnectOnOffStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgAutoConnectOnOffStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bAutoConnectOnOff);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgAutoConnectOnOffStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bAutoConnectOnOff);
   return oOut;
}

tBool most_btsetfi_tclMsgAutoConnectOnOffStatus::operator==(const most_btsetfi_tclMsgAutoConnectOnOffStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bAutoConnectOnOff == roRef.bAutoConnectOnOff);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgVehicleBTAddressUpReg::most_btsetfi_tclMsgVehicleBTAddressUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleBTAddressUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTAddressUpReg;
}


most_btsetfi_tclMsgVehicleBTAddressUpReg::~most_btsetfi_tclMsgVehicleBTAddressUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleBTAddressRelUpReg::most_btsetfi_tclMsgVehicleBTAddressRelUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleBTAddressRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTAddressRelUpReg;
}


most_btsetfi_tclMsgVehicleBTAddressRelUpReg::~most_btsetfi_tclMsgVehicleBTAddressRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleBTAddressGet::most_btsetfi_tclMsgVehicleBTAddressGet()
 {}

tS32 most_btsetfi_tclMsgVehicleBTAddressGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTAddressGet;
}


most_btsetfi_tclMsgVehicleBTAddressGet::~most_btsetfi_tclMsgVehicleBTAddressGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleBTAddressError::most_btsetfi_tclMsgVehicleBTAddressError(const most_btsetfi_tclMsgVehicleBTAddressError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgVehicleBTAddressError& most_btsetfi_tclMsgVehicleBTAddressError::operator=(const most_btsetfi_tclMsgVehicleBTAddressError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgVehicleBTAddressError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTAddressError;
}


most_btsetfi_tclMsgVehicleBTAddressError::~most_btsetfi_tclMsgVehicleBTAddressError()
{}

tBool most_btsetfi_tclMsgVehicleBTAddressError::operator==(const most_btsetfi_tclMsgVehicleBTAddressError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleBTAddressStatus::most_btsetfi_tclMsgVehicleBTAddressStatus(const most_btsetfi_tclMsgVehicleBTAddressStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sVehicleBTAddress = coRef.sVehicleBTAddress;
}
most_btsetfi_tclMsgVehicleBTAddressStatus& most_btsetfi_tclMsgVehicleBTAddressStatus::operator=(const most_btsetfi_tclMsgVehicleBTAddressStatus& coRef)
{
   if (this == &coRef) return *this;
   sVehicleBTAddress = coRef.sVehicleBTAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgVehicleBTAddressStatus::vDestroy()
{
   sVehicleBTAddress.vDestroy(); 
}

most_btsetfi_tclMsgVehicleBTAddressStatus::most_btsetfi_tclMsgVehicleBTAddressStatus()
:sVehicleBTAddress()
 {}

tS32 most_btsetfi_tclMsgVehicleBTAddressStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTAddressStatus;
}


most_btsetfi_tclMsgVehicleBTAddressStatus::~most_btsetfi_tclMsgVehicleBTAddressStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgVehicleBTAddressStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sVehicleBTAddress.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgVehicleBTAddressStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sVehicleBTAddress);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgVehicleBTAddressStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sVehicleBTAddress);
   return oOut;
}

tBool most_btsetfi_tclMsgVehicleBTAddressStatus::operator==(const most_btsetfi_tclMsgVehicleBTAddressStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sVehicleBTAddress == roRef.sVehicleBTAddress);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg::most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleSupportedBTProfilesUpReg;
}


most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg::~most_btsetfi_tclMsgVehicleSupportedBTProfilesUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg::most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleSupportedBTProfilesRelUpReg;
}


most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg::~most_btsetfi_tclMsgVehicleSupportedBTProfilesRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleSupportedBTProfilesGet::most_btsetfi_tclMsgVehicleSupportedBTProfilesGet()
 {}

tS32 most_btsetfi_tclMsgVehicleSupportedBTProfilesGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleSupportedBTProfilesGet;
}


most_btsetfi_tclMsgVehicleSupportedBTProfilesGet::~most_btsetfi_tclMsgVehicleSupportedBTProfilesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleSupportedBTProfilesError::most_btsetfi_tclMsgVehicleSupportedBTProfilesError(const most_btsetfi_tclMsgVehicleSupportedBTProfilesError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgVehicleSupportedBTProfilesError& most_btsetfi_tclMsgVehicleSupportedBTProfilesError::operator=(const most_btsetfi_tclMsgVehicleSupportedBTProfilesError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgVehicleSupportedBTProfilesError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleSupportedBTProfilesError;
}


most_btsetfi_tclMsgVehicleSupportedBTProfilesError::~most_btsetfi_tclMsgVehicleSupportedBTProfilesError()
{}

tBool most_btsetfi_tclMsgVehicleSupportedBTProfilesError::operator==(const most_btsetfi_tclMsgVehicleSupportedBTProfilesError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus::most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus(const most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oSupportedProfiles = coRef.oSupportedProfiles;
}
most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus& most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus::operator=(const most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus& coRef)
{
   if (this == &coRef) return *this;
   oSupportedProfiles = coRef.oSupportedProfiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus::most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus()
:oSupportedProfiles()
 {}

tS32 most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleSupportedBTProfilesStatus;
}


most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus::~most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus()
{}

tU32 most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oSupportedProfiles.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oSupportedProfiles);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oSupportedProfiles);
   return oOut;
}

tBool most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus::operator==(const most_btsetfi_tclMsgVehicleSupportedBTProfilesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oSupportedProfiles == roRef.oSupportedProfiles);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg::most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetUpReg;
}


most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg::~most_btsetfi_tclMsgVehicleBTFriendlyNamesetUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg::most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetRelUpReg;
}


most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg::~most_btsetfi_tclMsgVehicleBTFriendlyNamesetRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet::most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet()
 {}

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetGet;
}


most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet::~most_btsetfi_tclMsgVehicleBTFriendlyNamesetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sVehicleBTFriendlyName = coRef.sVehicleBTFriendlyName;
}
most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet& most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet& coRef)
{
   if (this == &coRef) return *this;
   sVehicleBTFriendlyName = coRef.sVehicleBTFriendlyName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::vDestroy()
{
   sVehicleBTFriendlyName.vDestroy(); 
}

most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet()
:sVehicleBTFriendlyName()
 {}

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetSet;
}


most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::~most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sVehicleBTFriendlyName.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sVehicleBTFriendlyName);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sVehicleBTFriendlyName);
   return oOut;
}

tBool most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet::operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sVehicleBTFriendlyName == roRef.sVehicleBTFriendlyName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleBTFriendlyNamesetError::most_btsetfi_tclMsgVehicleBTFriendlyNamesetError(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgVehicleBTFriendlyNamesetError& most_btsetfi_tclMsgVehicleBTFriendlyNamesetError::operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNamesetError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetError;
}


most_btsetfi_tclMsgVehicleBTFriendlyNamesetError::~most_btsetfi_tclMsgVehicleBTFriendlyNamesetError()
{}

tBool most_btsetfi_tclMsgVehicleBTFriendlyNamesetError::operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sVehicleBTFriendlyName = coRef.sVehicleBTFriendlyName;
}
most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus& most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::operator=(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus& coRef)
{
   if (this == &coRef) return *this;
   sVehicleBTFriendlyName = coRef.sVehicleBTFriendlyName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::vDestroy()
{
   sVehicleBTFriendlyName.vDestroy(); 
}

most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus()
:sVehicleBTFriendlyName()
 {}

tS32 most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleBTFriendlyNamesetStatus;
}


most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::~most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sVehicleBTFriendlyName.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sVehicleBTFriendlyName);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sVehicleBTFriendlyName);
   return oOut;
}

tBool most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus::operator==(const most_btsetfi_tclMsgVehicleBTFriendlyNamesetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sVehicleBTFriendlyName == roRef.sVehicleBTFriendlyName);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgPairingRequestUpReg::most_btsetfi_tclMsgPairingRequestUpReg()
 {}

tS32 most_btsetfi_tclMsgPairingRequestUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingRequestUpReg;
}


most_btsetfi_tclMsgPairingRequestUpReg::~most_btsetfi_tclMsgPairingRequestUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgPairingRequestRelUpReg::most_btsetfi_tclMsgPairingRequestRelUpReg()
 {}

tS32 most_btsetfi_tclMsgPairingRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingRequestRelUpReg;
}


most_btsetfi_tclMsgPairingRequestRelUpReg::~most_btsetfi_tclMsgPairingRequestRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgPairingRequestGet::most_btsetfi_tclMsgPairingRequestGet()
 {}

tS32 most_btsetfi_tclMsgPairingRequestGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingRequestGet;
}


most_btsetfi_tclMsgPairingRequestGet::~most_btsetfi_tclMsgPairingRequestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairingRequestError::most_btsetfi_tclMsgPairingRequestError(const most_btsetfi_tclMsgPairingRequestError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgPairingRequestError& most_btsetfi_tclMsgPairingRequestError::operator=(const most_btsetfi_tclMsgPairingRequestError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgPairingRequestError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingRequestError;
}


most_btsetfi_tclMsgPairingRequestError::~most_btsetfi_tclMsgPairingRequestError()
{}

tBool most_btsetfi_tclMsgPairingRequestError::operator==(const most_btsetfi_tclMsgPairingRequestError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairingRequestStatus::most_btsetfi_tclMsgPairingRequestStatus(const most_btsetfi_tclMsgPairingRequestStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sDeviceName = coRef.sDeviceName;
   sRemoteDeviceAddress = coRef.sRemoteDeviceAddress;
   sPinNumber = coRef.sPinNumber;
   e8PairingType = coRef.e8PairingType;
   e8Origin = coRef.e8Origin;
}
most_btsetfi_tclMsgPairingRequestStatus& most_btsetfi_tclMsgPairingRequestStatus::operator=(const most_btsetfi_tclMsgPairingRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   sDeviceName = coRef.sDeviceName;
   sRemoteDeviceAddress = coRef.sRemoteDeviceAddress;
   sPinNumber = coRef.sPinNumber;
   e8PairingType = coRef.e8PairingType;
   e8Origin = coRef.e8Origin;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgPairingRequestStatus::vDestroy()
{
   sDeviceName.vDestroy(); 
   sRemoteDeviceAddress.vDestroy(); 
   sPinNumber.vDestroy(); 
}

most_btsetfi_tclMsgPairingRequestStatus::most_btsetfi_tclMsgPairingRequestStatus()
:sDeviceName()
,sRemoteDeviceAddress()
,sPinNumber()
,e8PairingType()
,e8Origin()
 {}

tS32 most_btsetfi_tclMsgPairingRequestStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairingRequestStatus;
}


most_btsetfi_tclMsgPairingRequestStatus::~most_btsetfi_tclMsgPairingRequestStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgPairingRequestStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sDeviceName.u32GetSize(u16MajorVersion);
   u32DynamicSize += sRemoteDeviceAddress.u32GetSize(u16MajorVersion);
   u32DynamicSize += sPinNumber.u32GetSize(u16MajorVersion);
   return 2 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgPairingRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sDeviceName);
   (tVoid) (oIn >> sRemoteDeviceAddress);
   (tVoid) (oIn >> sPinNumber);
   (tVoid) (oIn >> e8PairingType);
   (tVoid) (oIn >> e8Origin);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgPairingRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sDeviceName);
   (tVoid) (oOut << sRemoteDeviceAddress);
   (tVoid) (oOut << sPinNumber);
   (tVoid) (oOut << e8PairingType);
   (tVoid) (oOut << e8Origin);
   return oOut;
}

tBool most_btsetfi_tclMsgPairingRequestStatus::operator==(const most_btsetfi_tclMsgPairingRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   bResult = bResult && (sRemoteDeviceAddress == roRef.sRemoteDeviceAddress);
   bResult = bResult && (sPinNumber == roRef.sPinNumber);
   bResult = bResult && (e8PairingType == roRef.e8PairingType);
   bResult = bResult && (e8Origin == roRef.e8Origin);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgDeviceListExtendedUpReg::most_btsetfi_tclMsgDeviceListExtendedUpReg()
 {}

tS32 most_btsetfi_tclMsgDeviceListExtendedUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DeviceListExtendedUpReg;
}


most_btsetfi_tclMsgDeviceListExtendedUpReg::~most_btsetfi_tclMsgDeviceListExtendedUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgDeviceListExtendedRelUpReg::most_btsetfi_tclMsgDeviceListExtendedRelUpReg()
 {}

tS32 most_btsetfi_tclMsgDeviceListExtendedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DeviceListExtendedRelUpReg;
}


most_btsetfi_tclMsgDeviceListExtendedRelUpReg::~most_btsetfi_tclMsgDeviceListExtendedRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgDeviceListExtendedGet::most_btsetfi_tclMsgDeviceListExtendedGet()
 {}

tS32 most_btsetfi_tclMsgDeviceListExtendedGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DeviceListExtendedGet;
}


most_btsetfi_tclMsgDeviceListExtendedGet::~most_btsetfi_tclMsgDeviceListExtendedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgDeviceListExtendedError::most_btsetfi_tclMsgDeviceListExtendedError(const most_btsetfi_tclMsgDeviceListExtendedError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgDeviceListExtendedError& most_btsetfi_tclMsgDeviceListExtendedError::operator=(const most_btsetfi_tclMsgDeviceListExtendedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgDeviceListExtendedError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DeviceListExtendedError;
}


most_btsetfi_tclMsgDeviceListExtendedError::~most_btsetfi_tclMsgDeviceListExtendedError()
{}

tBool most_btsetfi_tclMsgDeviceListExtendedError::operator==(const most_btsetfi_tclMsgDeviceListExtendedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgDeviceListExtendedStatus::most_btsetfi_tclMsgDeviceListExtendedStatus(const most_btsetfi_tclMsgDeviceListExtendedStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oDeviceListChange = coRef.oDeviceListChange;
   u8NumPairedDevices = coRef.u8NumPairedDevices;
   oDeviceListExtendedResult = coRef.oDeviceListExtendedResult;
}
most_btsetfi_tclMsgDeviceListExtendedStatus& most_btsetfi_tclMsgDeviceListExtendedStatus::operator=(const most_btsetfi_tclMsgDeviceListExtendedStatus& coRef)
{
   if (this == &coRef) return *this;
   oDeviceListChange = coRef.oDeviceListChange;
   u8NumPairedDevices = coRef.u8NumPairedDevices;
   oDeviceListExtendedResult = coRef.oDeviceListExtendedResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgDeviceListExtendedStatus::vDestroy()
{
   oDeviceListChange.vDestroy(); 
}

most_btsetfi_tclMsgDeviceListExtendedStatus::most_btsetfi_tclMsgDeviceListExtendedStatus()
:oDeviceListChange()
,u8NumPairedDevices(0)
,oDeviceListExtendedResult()
 {}

tS32 most_btsetfi_tclMsgDeviceListExtendedStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_DeviceListExtendedStatus;
}


most_btsetfi_tclMsgDeviceListExtendedStatus::~most_btsetfi_tclMsgDeviceListExtendedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgDeviceListExtendedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oDeviceListChange.u32GetSize(u16MajorVersion);
   u32DynamicSize += oDeviceListExtendedResult.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgDeviceListExtendedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oDeviceListChange);
   (tVoid) (oIn >> u8NumPairedDevices);
   (tVoid) (oIn >> oDeviceListExtendedResult);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgDeviceListExtendedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oDeviceListChange);
   (tVoid) (oOut << u8NumPairedDevices);
   (tVoid) (oOut << oDeviceListExtendedResult);
   return oOut;
}

tBool most_btsetfi_tclMsgDeviceListExtendedStatus::operator==(const most_btsetfi_tclMsgDeviceListExtendedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oDeviceListChange == roRef.oDeviceListChange);
   bResult = bResult && (u8NumPairedDevices == roRef.u8NumPairedDevices);
   bResult = bResult && (oDeviceListExtendedResult == roRef.oDeviceListExtendedResult);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgVisibleDevicesUpReg::most_btsetfi_tclMsgVisibleDevicesUpReg()
 {}

tS32 most_btsetfi_tclMsgVisibleDevicesUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VisibleDevicesUpReg;
}


most_btsetfi_tclMsgVisibleDevicesUpReg::~most_btsetfi_tclMsgVisibleDevicesUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVisibleDevicesRelUpReg::most_btsetfi_tclMsgVisibleDevicesRelUpReg()
 {}

tS32 most_btsetfi_tclMsgVisibleDevicesRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VisibleDevicesRelUpReg;
}


most_btsetfi_tclMsgVisibleDevicesRelUpReg::~most_btsetfi_tclMsgVisibleDevicesRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVisibleDevicesGet::most_btsetfi_tclMsgVisibleDevicesGet()
 {}

tS32 most_btsetfi_tclMsgVisibleDevicesGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VisibleDevicesGet;
}


most_btsetfi_tclMsgVisibleDevicesGet::~most_btsetfi_tclMsgVisibleDevicesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVisibleDevicesError::most_btsetfi_tclMsgVisibleDevicesError(const most_btsetfi_tclMsgVisibleDevicesError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgVisibleDevicesError& most_btsetfi_tclMsgVisibleDevicesError::operator=(const most_btsetfi_tclMsgVisibleDevicesError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgVisibleDevicesError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VisibleDevicesError;
}


most_btsetfi_tclMsgVisibleDevicesError::~most_btsetfi_tclMsgVisibleDevicesError()
{}

tBool most_btsetfi_tclMsgVisibleDevicesError::operator==(const most_btsetfi_tclMsgVisibleDevicesError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVisibleDevicesStatus::most_btsetfi_tclMsgVisibleDevicesStatus(const most_btsetfi_tclMsgVisibleDevicesStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   u8NumVisibleDevices = coRef.u8NumVisibleDevices;
   oVisibleDevicesList = coRef.oVisibleDevicesList;
}
most_btsetfi_tclMsgVisibleDevicesStatus& most_btsetfi_tclMsgVisibleDevicesStatus::operator=(const most_btsetfi_tclMsgVisibleDevicesStatus& coRef)
{
   if (this == &coRef) return *this;
   u8NumVisibleDevices = coRef.u8NumVisibleDevices;
   oVisibleDevicesList = coRef.oVisibleDevicesList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgVisibleDevicesStatus::vDestroy()
{
}

most_btsetfi_tclMsgVisibleDevicesStatus::most_btsetfi_tclMsgVisibleDevicesStatus()
:u8NumVisibleDevices(0)
,oVisibleDevicesList()
 {}

tS32 most_btsetfi_tclMsgVisibleDevicesStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VisibleDevicesStatus;
}


most_btsetfi_tclMsgVisibleDevicesStatus::~most_btsetfi_tclMsgVisibleDevicesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgVisibleDevicesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oVisibleDevicesList.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgVisibleDevicesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumVisibleDevices);
   (tVoid) (oIn >> oVisibleDevicesList);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgVisibleDevicesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumVisibleDevices);
   (tVoid) (oOut << oVisibleDevicesList);
   return oOut;
}

tBool most_btsetfi_tclMsgVisibleDevicesStatus::operator==(const most_btsetfi_tclMsgVisibleDevicesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumVisibleDevices == roRef.u8NumVisibleDevices);
   bResult = bResult && (oVisibleDevicesList == roRef.oVisibleDevicesList);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgPairableModeUpReg::most_btsetfi_tclMsgPairableModeUpReg()
 {}

tS32 most_btsetfi_tclMsgPairableModeUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairableModeUpReg;
}


most_btsetfi_tclMsgPairableModeUpReg::~most_btsetfi_tclMsgPairableModeUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgPairableModeRelUpReg::most_btsetfi_tclMsgPairableModeRelUpReg()
 {}

tS32 most_btsetfi_tclMsgPairableModeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairableModeRelUpReg;
}


most_btsetfi_tclMsgPairableModeRelUpReg::~most_btsetfi_tclMsgPairableModeRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgPairableModeGet::most_btsetfi_tclMsgPairableModeGet()
 {}

tS32 most_btsetfi_tclMsgPairableModeGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairableModeGet;
}


most_btsetfi_tclMsgPairableModeGet::~most_btsetfi_tclMsgPairableModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairableModeError::most_btsetfi_tclMsgPairableModeError(const most_btsetfi_tclMsgPairableModeError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgPairableModeError& most_btsetfi_tclMsgPairableModeError::operator=(const most_btsetfi_tclMsgPairableModeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgPairableModeError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairableModeError;
}


most_btsetfi_tclMsgPairableModeError::~most_btsetfi_tclMsgPairableModeError()
{}

tBool most_btsetfi_tclMsgPairableModeError::operator==(const most_btsetfi_tclMsgPairableModeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgPairableModeStatus::most_btsetfi_tclMsgPairableModeStatus(const most_btsetfi_tclMsgPairableModeStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   Pairable = coRef.Pairable;
   Connectable = coRef.Connectable;
   PairingInProgress = coRef.PairingInProgress;
   sBTAddress = coRef.sBTAddress;
}
most_btsetfi_tclMsgPairableModeStatus& most_btsetfi_tclMsgPairableModeStatus::operator=(const most_btsetfi_tclMsgPairableModeStatus& coRef)
{
   if (this == &coRef) return *this;
   Pairable = coRef.Pairable;
   Connectable = coRef.Connectable;
   PairingInProgress = coRef.PairingInProgress;
   sBTAddress = coRef.sBTAddress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgPairableModeStatus::vDestroy()
{
   sBTAddress.vDestroy(); 
}

most_btsetfi_tclMsgPairableModeStatus::most_btsetfi_tclMsgPairableModeStatus()
:Pairable(0)
,Connectable(0)
,PairingInProgress(0)
,sBTAddress()
 {}

tS32 most_btsetfi_tclMsgPairableModeStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_PairableModeStatus;
}


most_btsetfi_tclMsgPairableModeStatus::~most_btsetfi_tclMsgPairableModeStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgPairableModeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sBTAddress.u32GetSize(u16MajorVersion);
   return 3 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgPairableModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Pairable);
   (tVoid) (oIn >> Connectable);
   (tVoid) (oIn >> PairingInProgress);
   (tVoid) (oIn >> sBTAddress);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgPairableModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Pairable);
   (tVoid) (oOut << Connectable);
   (tVoid) (oOut << PairingInProgress);
   (tVoid) (oOut << sBTAddress);
   return oOut;
}

tBool most_btsetfi_tclMsgPairableModeStatus::operator==(const most_btsetfi_tclMsgPairableModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Pairable == roRef.Pairable);
   bResult = bResult && (Connectable == roRef.Connectable);
   bResult = bResult && (PairingInProgress == roRef.PairingInProgress);
   bResult = bResult && (sBTAddress == roRef.sBTAddress);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgSignalStrengthUpReg::most_btsetfi_tclMsgSignalStrengthUpReg()
 {}

tS32 most_btsetfi_tclMsgSignalStrengthUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SignalStrengthUpReg;
}


most_btsetfi_tclMsgSignalStrengthUpReg::~most_btsetfi_tclMsgSignalStrengthUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgSignalStrengthRelUpReg::most_btsetfi_tclMsgSignalStrengthRelUpReg()
 {}

tS32 most_btsetfi_tclMsgSignalStrengthRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SignalStrengthRelUpReg;
}


most_btsetfi_tclMsgSignalStrengthRelUpReg::~most_btsetfi_tclMsgSignalStrengthRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgSignalStrengthGet::most_btsetfi_tclMsgSignalStrengthGet()
 {}

tS32 most_btsetfi_tclMsgSignalStrengthGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SignalStrengthGet;
}


most_btsetfi_tclMsgSignalStrengthGet::~most_btsetfi_tclMsgSignalStrengthGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSignalStrengthError::most_btsetfi_tclMsgSignalStrengthError(const most_btsetfi_tclMsgSignalStrengthError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSignalStrengthError& most_btsetfi_tclMsgSignalStrengthError::operator=(const most_btsetfi_tclMsgSignalStrengthError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSignalStrengthError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SignalStrengthError;
}


most_btsetfi_tclMsgSignalStrengthError::~most_btsetfi_tclMsgSignalStrengthError()
{}

tBool most_btsetfi_tclMsgSignalStrengthError::operator==(const most_btsetfi_tclMsgSignalStrengthError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSignalStrengthStatus::most_btsetfi_tclMsgSignalStrengthStatus(const most_btsetfi_tclMsgSignalStrengthStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oSignalStrengthList = coRef.oSignalStrengthList;
}
most_btsetfi_tclMsgSignalStrengthStatus& most_btsetfi_tclMsgSignalStrengthStatus::operator=(const most_btsetfi_tclMsgSignalStrengthStatus& coRef)
{
   if (this == &coRef) return *this;
   oSignalStrengthList = coRef.oSignalStrengthList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgSignalStrengthStatus::most_btsetfi_tclMsgSignalStrengthStatus()
:oSignalStrengthList()
 {}

tS32 most_btsetfi_tclMsgSignalStrengthStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SignalStrengthStatus;
}


most_btsetfi_tclMsgSignalStrengthStatus::~most_btsetfi_tclMsgSignalStrengthStatus()
{}

tU32 most_btsetfi_tclMsgSignalStrengthStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oSignalStrengthList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgSignalStrengthStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oSignalStrengthList);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSignalStrengthStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oSignalStrengthList);
   return oOut;
}

tBool most_btsetfi_tclMsgSignalStrengthStatus::operator==(const most_btsetfi_tclMsgSignalStrengthStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oSignalStrengthList == roRef.oSignalStrengthList);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgSPPServiceConnectionUpReg::most_btsetfi_tclMsgSPPServiceConnectionUpReg()
 {}

tS32 most_btsetfi_tclMsgSPPServiceConnectionUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SPPServiceConnectionUpReg;
}


most_btsetfi_tclMsgSPPServiceConnectionUpReg::~most_btsetfi_tclMsgSPPServiceConnectionUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgSPPServiceConnectionRelUpReg::most_btsetfi_tclMsgSPPServiceConnectionRelUpReg()
 {}

tS32 most_btsetfi_tclMsgSPPServiceConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SPPServiceConnectionRelUpReg;
}


most_btsetfi_tclMsgSPPServiceConnectionRelUpReg::~most_btsetfi_tclMsgSPPServiceConnectionRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgSPPServiceConnectionGet::most_btsetfi_tclMsgSPPServiceConnectionGet()
 {}

tS32 most_btsetfi_tclMsgSPPServiceConnectionGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SPPServiceConnectionGet;
}


most_btsetfi_tclMsgSPPServiceConnectionGet::~most_btsetfi_tclMsgSPPServiceConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSPPServiceConnectionError::most_btsetfi_tclMsgSPPServiceConnectionError(const most_btsetfi_tclMsgSPPServiceConnectionError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgSPPServiceConnectionError& most_btsetfi_tclMsgSPPServiceConnectionError::operator=(const most_btsetfi_tclMsgSPPServiceConnectionError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgSPPServiceConnectionError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SPPServiceConnectionError;
}


most_btsetfi_tclMsgSPPServiceConnectionError::~most_btsetfi_tclMsgSPPServiceConnectionError()
{}

tBool most_btsetfi_tclMsgSPPServiceConnectionError::operator==(const most_btsetfi_tclMsgSPPServiceConnectionError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgSPPServiceConnectionStatus::most_btsetfi_tclMsgSPPServiceConnectionStatus(const most_btsetfi_tclMsgSPPServiceConnectionStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oSPPServiceConnectionStatusList = coRef.oSPPServiceConnectionStatusList;
}
most_btsetfi_tclMsgSPPServiceConnectionStatus& most_btsetfi_tclMsgSPPServiceConnectionStatus::operator=(const most_btsetfi_tclMsgSPPServiceConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   oSPPServiceConnectionStatusList = coRef.oSPPServiceConnectionStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgSPPServiceConnectionStatus::vDestroy()
{
}

most_btsetfi_tclMsgSPPServiceConnectionStatus::most_btsetfi_tclMsgSPPServiceConnectionStatus()
:oSPPServiceConnectionStatusList()
 {}

tS32 most_btsetfi_tclMsgSPPServiceConnectionStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_SPPServiceConnectionStatus;
}


most_btsetfi_tclMsgSPPServiceConnectionStatus::~most_btsetfi_tclMsgSPPServiceConnectionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgSPPServiceConnectionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oSPPServiceConnectionStatusList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgSPPServiceConnectionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oSPPServiceConnectionStatusList);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgSPPServiceConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oSPPServiceConnectionStatusList);
   return oOut;
}

tBool most_btsetfi_tclMsgSPPServiceConnectionStatus::operator==(const most_btsetfi_tclMsgSPPServiceConnectionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oSPPServiceConnectionStatusList == roRef.oSPPServiceConnectionStatusList);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgBluetoothLimitationModeUpReg::most_btsetfi_tclMsgBluetoothLimitationModeUpReg()
 {}

tS32 most_btsetfi_tclMsgBluetoothLimitationModeUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothLimitationModeUpReg;
}


most_btsetfi_tclMsgBluetoothLimitationModeUpReg::~most_btsetfi_tclMsgBluetoothLimitationModeUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg::most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg()
 {}

tS32 most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothLimitationModeRelUpReg;
}


most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg::~most_btsetfi_tclMsgBluetoothLimitationModeRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgBluetoothLimitationModeGet::most_btsetfi_tclMsgBluetoothLimitationModeGet()
 {}

tS32 most_btsetfi_tclMsgBluetoothLimitationModeGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothLimitationModeGet;
}


most_btsetfi_tclMsgBluetoothLimitationModeGet::~most_btsetfi_tclMsgBluetoothLimitationModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgBluetoothLimitationModeError::most_btsetfi_tclMsgBluetoothLimitationModeError(const most_btsetfi_tclMsgBluetoothLimitationModeError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgBluetoothLimitationModeError& most_btsetfi_tclMsgBluetoothLimitationModeError::operator=(const most_btsetfi_tclMsgBluetoothLimitationModeError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgBluetoothLimitationModeError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothLimitationModeError;
}


most_btsetfi_tclMsgBluetoothLimitationModeError::~most_btsetfi_tclMsgBluetoothLimitationModeError()
{}

tBool most_btsetfi_tclMsgBluetoothLimitationModeError::operator==(const most_btsetfi_tclMsgBluetoothLimitationModeError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgBluetoothLimitationModeStatus::most_btsetfi_tclMsgBluetoothLimitationModeStatus(const most_btsetfi_tclMsgBluetoothLimitationModeStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oList = coRef.oList;
}
most_btsetfi_tclMsgBluetoothLimitationModeStatus& most_btsetfi_tclMsgBluetoothLimitationModeStatus::operator=(const most_btsetfi_tclMsgBluetoothLimitationModeStatus& coRef)
{
   if (this == &coRef) return *this;
   oList = coRef.oList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgBluetoothLimitationModeStatus::vDestroy()
{
}

most_btsetfi_tclMsgBluetoothLimitationModeStatus::most_btsetfi_tclMsgBluetoothLimitationModeStatus()
:oList()
 {}

tS32 most_btsetfi_tclMsgBluetoothLimitationModeStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BluetoothLimitationModeStatus;
}


most_btsetfi_tclMsgBluetoothLimitationModeStatus::~most_btsetfi_tclMsgBluetoothLimitationModeStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgBluetoothLimitationModeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgBluetoothLimitationModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oList);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgBluetoothLimitationModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oList);
   return oOut;
}

tBool most_btsetfi_tclMsgBluetoothLimitationModeStatus::operator==(const most_btsetfi_tclMsgBluetoothLimitationModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oList == roRef.oList);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgMultiHFPSupportUpReg::most_btsetfi_tclMsgMultiHFPSupportUpReg()
 {}

tS32 most_btsetfi_tclMsgMultiHFPSupportUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MultiHFPSupportUpReg;
}


most_btsetfi_tclMsgMultiHFPSupportUpReg::~most_btsetfi_tclMsgMultiHFPSupportUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgMultiHFPSupportRelUpReg::most_btsetfi_tclMsgMultiHFPSupportRelUpReg()
 {}

tS32 most_btsetfi_tclMsgMultiHFPSupportRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MultiHFPSupportRelUpReg;
}


most_btsetfi_tclMsgMultiHFPSupportRelUpReg::~most_btsetfi_tclMsgMultiHFPSupportRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgMultiHFPSupportGet::most_btsetfi_tclMsgMultiHFPSupportGet()
 {}

tS32 most_btsetfi_tclMsgMultiHFPSupportGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MultiHFPSupportGet;
}


most_btsetfi_tclMsgMultiHFPSupportGet::~most_btsetfi_tclMsgMultiHFPSupportGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgMultiHFPSupportError::most_btsetfi_tclMsgMultiHFPSupportError(const most_btsetfi_tclMsgMultiHFPSupportError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgMultiHFPSupportError& most_btsetfi_tclMsgMultiHFPSupportError::operator=(const most_btsetfi_tclMsgMultiHFPSupportError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgMultiHFPSupportError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MultiHFPSupportError;
}


most_btsetfi_tclMsgMultiHFPSupportError::~most_btsetfi_tclMsgMultiHFPSupportError()
{}

tBool most_btsetfi_tclMsgMultiHFPSupportError::operator==(const most_btsetfi_tclMsgMultiHFPSupportError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgMultiHFPSupportStatus::most_btsetfi_tclMsgMultiHFPSupportStatus(const most_btsetfi_tclMsgMultiHFPSupportStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8MultiHFPSupport = coRef.e8MultiHFPSupport;
}
most_btsetfi_tclMsgMultiHFPSupportStatus& most_btsetfi_tclMsgMultiHFPSupportStatus::operator=(const most_btsetfi_tclMsgMultiHFPSupportStatus& coRef)
{
   if (this == &coRef) return *this;
   e8MultiHFPSupport = coRef.e8MultiHFPSupport;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgMultiHFPSupportStatus::most_btsetfi_tclMsgMultiHFPSupportStatus()
:e8MultiHFPSupport()
 {}

tS32 most_btsetfi_tclMsgMultiHFPSupportStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_MultiHFPSupportStatus;
}


most_btsetfi_tclMsgMultiHFPSupportStatus::~most_btsetfi_tclMsgMultiHFPSupportStatus()
{}

tU32 most_btsetfi_tclMsgMultiHFPSupportStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgMultiHFPSupportStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MultiHFPSupport);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgMultiHFPSupportStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MultiHFPSupport);
   return oOut;
}

tBool most_btsetfi_tclMsgMultiHFPSupportStatus::operator==(const most_btsetfi_tclMsgMultiHFPSupportStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MultiHFPSupport == roRef.e8MultiHFPSupport);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgBTProfilesUsageInfoUpReg::most_btsetfi_tclMsgBTProfilesUsageInfoUpReg()
 {}

tS32 most_btsetfi_tclMsgBTProfilesUsageInfoUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BTProfilesUsageInfoUpReg;
}


most_btsetfi_tclMsgBTProfilesUsageInfoUpReg::~most_btsetfi_tclMsgBTProfilesUsageInfoUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg::most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg()
 {}

tS32 most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BTProfilesUsageInfoRelUpReg;
}


most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg::~most_btsetfi_tclMsgBTProfilesUsageInfoRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgBTProfilesUsageInfoGet::most_btsetfi_tclMsgBTProfilesUsageInfoGet()
 {}

tS32 most_btsetfi_tclMsgBTProfilesUsageInfoGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BTProfilesUsageInfoGet;
}


most_btsetfi_tclMsgBTProfilesUsageInfoGet::~most_btsetfi_tclMsgBTProfilesUsageInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgBTProfilesUsageInfoError::most_btsetfi_tclMsgBTProfilesUsageInfoError(const most_btsetfi_tclMsgBTProfilesUsageInfoError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgBTProfilesUsageInfoError& most_btsetfi_tclMsgBTProfilesUsageInfoError::operator=(const most_btsetfi_tclMsgBTProfilesUsageInfoError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgBTProfilesUsageInfoError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BTProfilesUsageInfoError;
}


most_btsetfi_tclMsgBTProfilesUsageInfoError::~most_btsetfi_tclMsgBTProfilesUsageInfoError()
{}

tBool most_btsetfi_tclMsgBTProfilesUsageInfoError::operator==(const most_btsetfi_tclMsgBTProfilesUsageInfoError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgBTProfilesUsageInfoStatus::most_btsetfi_tclMsgBTProfilesUsageInfoStatus(const most_btsetfi_tclMsgBTProfilesUsageInfoStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   oBTProfilesUsageInfoList = coRef.oBTProfilesUsageInfoList;
}
most_btsetfi_tclMsgBTProfilesUsageInfoStatus& most_btsetfi_tclMsgBTProfilesUsageInfoStatus::operator=(const most_btsetfi_tclMsgBTProfilesUsageInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   oBTProfilesUsageInfoList = coRef.oBTProfilesUsageInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgBTProfilesUsageInfoStatus::vDestroy()
{
}

most_btsetfi_tclMsgBTProfilesUsageInfoStatus::most_btsetfi_tclMsgBTProfilesUsageInfoStatus()
:oBTProfilesUsageInfoList()
 {}

tS32 most_btsetfi_tclMsgBTProfilesUsageInfoStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_BTProfilesUsageInfoStatus;
}


most_btsetfi_tclMsgBTProfilesUsageInfoStatus::~most_btsetfi_tclMsgBTProfilesUsageInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgBTProfilesUsageInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oBTProfilesUsageInfoList.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgBTProfilesUsageInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oBTProfilesUsageInfoList);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgBTProfilesUsageInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oBTProfilesUsageInfoList);
   return oOut;
}

tBool most_btsetfi_tclMsgBTProfilesUsageInfoStatus::operator==(const most_btsetfi_tclMsgBTProfilesUsageInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oBTProfilesUsageInfoList == roRef.oBTProfilesUsageInfoList);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgConflictsDetectedUpReg::most_btsetfi_tclMsgConflictsDetectedUpReg()
 {}

tS32 most_btsetfi_tclMsgConflictsDetectedUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConflictsDetectedUpReg;
}


most_btsetfi_tclMsgConflictsDetectedUpReg::~most_btsetfi_tclMsgConflictsDetectedUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgConflictsDetectedRelUpReg::most_btsetfi_tclMsgConflictsDetectedRelUpReg()
 {}

tS32 most_btsetfi_tclMsgConflictsDetectedRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConflictsDetectedRelUpReg;
}


most_btsetfi_tclMsgConflictsDetectedRelUpReg::~most_btsetfi_tclMsgConflictsDetectedRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgConflictsDetectedGet::most_btsetfi_tclMsgConflictsDetectedGet()
 {}

tS32 most_btsetfi_tclMsgConflictsDetectedGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConflictsDetectedGet;
}


most_btsetfi_tclMsgConflictsDetectedGet::~most_btsetfi_tclMsgConflictsDetectedGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgConflictsDetectedError::most_btsetfi_tclMsgConflictsDetectedError(const most_btsetfi_tclMsgConflictsDetectedError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgConflictsDetectedError& most_btsetfi_tclMsgConflictsDetectedError::operator=(const most_btsetfi_tclMsgConflictsDetectedError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgConflictsDetectedError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConflictsDetectedError;
}


most_btsetfi_tclMsgConflictsDetectedError::~most_btsetfi_tclMsgConflictsDetectedError()
{}

tBool most_btsetfi_tclMsgConflictsDetectedError::operator==(const most_btsetfi_tclMsgConflictsDetectedError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgConflictsDetectedStatus::most_btsetfi_tclMsgConflictsDetectedStatus(const most_btsetfi_tclMsgConflictsDetectedStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8ConflictTrigger = coRef.e8ConflictTrigger;
   oBTConflictInfoList = coRef.oBTConflictInfoList;
}
most_btsetfi_tclMsgConflictsDetectedStatus& most_btsetfi_tclMsgConflictsDetectedStatus::operator=(const most_btsetfi_tclMsgConflictsDetectedStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ConflictTrigger = coRef.e8ConflictTrigger;
   oBTConflictInfoList = coRef.oBTConflictInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgConflictsDetectedStatus::vDestroy()
{
}

most_btsetfi_tclMsgConflictsDetectedStatus::most_btsetfi_tclMsgConflictsDetectedStatus()
:e8ConflictTrigger()
,oBTConflictInfoList()
 {}

tS32 most_btsetfi_tclMsgConflictsDetectedStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ConflictsDetectedStatus;
}


most_btsetfi_tclMsgConflictsDetectedStatus::~most_btsetfi_tclMsgConflictsDetectedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgConflictsDetectedStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += oBTConflictInfoList.u32GetSize(u16MajorVersion);
   return 1 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgConflictsDetectedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConflictTrigger);
   (tVoid) (oIn >> oBTConflictInfoList);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgConflictsDetectedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConflictTrigger);
   (tVoid) (oOut << oBTConflictInfoList);
   return oOut;
}

tBool most_btsetfi_tclMsgConflictsDetectedStatus::operator==(const most_btsetfi_tclMsgConflictsDetectedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConflictTrigger == roRef.e8ConflictTrigger);
   bResult = bResult && (oBTConflictInfoList == roRef.oBTConflictInfoList);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgAutoConnectionStatusUpReg::most_btsetfi_tclMsgAutoConnectionStatusUpReg()
 {}

tS32 most_btsetfi_tclMsgAutoConnectionStatusUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectionStatusUpReg;
}


most_btsetfi_tclMsgAutoConnectionStatusUpReg::~most_btsetfi_tclMsgAutoConnectionStatusUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgAutoConnectionStatusRelUpReg::most_btsetfi_tclMsgAutoConnectionStatusRelUpReg()
 {}

tS32 most_btsetfi_tclMsgAutoConnectionStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectionStatusRelUpReg;
}


most_btsetfi_tclMsgAutoConnectionStatusRelUpReg::~most_btsetfi_tclMsgAutoConnectionStatusRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgAutoConnectionStatusGet::most_btsetfi_tclMsgAutoConnectionStatusGet()
 {}

tS32 most_btsetfi_tclMsgAutoConnectionStatusGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectionStatusGet;
}


most_btsetfi_tclMsgAutoConnectionStatusGet::~most_btsetfi_tclMsgAutoConnectionStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAutoConnectionStatusError::most_btsetfi_tclMsgAutoConnectionStatusError(const most_btsetfi_tclMsgAutoConnectionStatusError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgAutoConnectionStatusError& most_btsetfi_tclMsgAutoConnectionStatusError::operator=(const most_btsetfi_tclMsgAutoConnectionStatusError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgAutoConnectionStatusError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectionStatusError;
}


most_btsetfi_tclMsgAutoConnectionStatusError::~most_btsetfi_tclMsgAutoConnectionStatusError()
{}

tBool most_btsetfi_tclMsgAutoConnectionStatusError::operator==(const most_btsetfi_tclMsgAutoConnectionStatusError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgAutoConnectionStatusStatus::most_btsetfi_tclMsgAutoConnectionStatusStatus(const most_btsetfi_tclMsgAutoConnectionStatusStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8AutoConnectionStatus = coRef.e8AutoConnectionStatus;
   u8DeviceHandle = coRef.u8DeviceHandle;
}
most_btsetfi_tclMsgAutoConnectionStatusStatus& most_btsetfi_tclMsgAutoConnectionStatusStatus::operator=(const most_btsetfi_tclMsgAutoConnectionStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8AutoConnectionStatus = coRef.e8AutoConnectionStatus;
   u8DeviceHandle = coRef.u8DeviceHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgAutoConnectionStatusStatus::most_btsetfi_tclMsgAutoConnectionStatusStatus()
:e8AutoConnectionStatus()
,u8DeviceHandle(0)
 {}

tS32 most_btsetfi_tclMsgAutoConnectionStatusStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_AutoConnectionStatusStatus;
}


most_btsetfi_tclMsgAutoConnectionStatusStatus::~most_btsetfi_tclMsgAutoConnectionStatusStatus()
{}

tU32 most_btsetfi_tclMsgAutoConnectionStatusStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 2;
}

fi_tclInContext& most_btsetfi_tclMsgAutoConnectionStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8AutoConnectionStatus);
   (tVoid) (oIn >> u8DeviceHandle);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgAutoConnectionStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8AutoConnectionStatus);
   (tVoid) (oOut << u8DeviceHandle);
   return oOut;
}

tBool most_btsetfi_tclMsgAutoConnectionStatusStatus::operator==(const most_btsetfi_tclMsgAutoConnectionStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8AutoConnectionStatus == roRef.e8AutoConnectionStatus);
   bResult = bResult && (u8DeviceHandle == roRef.u8DeviceHandle);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgServiceAvailableUpReg::most_btsetfi_tclMsgServiceAvailableUpReg()
 {}

tS32 most_btsetfi_tclMsgServiceAvailableUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ServiceAvailableUpReg;
}


most_btsetfi_tclMsgServiceAvailableUpReg::~most_btsetfi_tclMsgServiceAvailableUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgServiceAvailableRelUpReg::most_btsetfi_tclMsgServiceAvailableRelUpReg()
 {}

tS32 most_btsetfi_tclMsgServiceAvailableRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ServiceAvailableRelUpReg;
}


most_btsetfi_tclMsgServiceAvailableRelUpReg::~most_btsetfi_tclMsgServiceAvailableRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgServiceAvailableGet::most_btsetfi_tclMsgServiceAvailableGet()
 {}

tS32 most_btsetfi_tclMsgServiceAvailableGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ServiceAvailableGet;
}


most_btsetfi_tclMsgServiceAvailableGet::~most_btsetfi_tclMsgServiceAvailableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgServiceAvailableError::most_btsetfi_tclMsgServiceAvailableError(const most_btsetfi_tclMsgServiceAvailableError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgServiceAvailableError& most_btsetfi_tclMsgServiceAvailableError::operator=(const most_btsetfi_tclMsgServiceAvailableError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgServiceAvailableError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ServiceAvailableError;
}


most_btsetfi_tclMsgServiceAvailableError::~most_btsetfi_tclMsgServiceAvailableError()
{}

tBool most_btsetfi_tclMsgServiceAvailableError::operator==(const most_btsetfi_tclMsgServiceAvailableError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgServiceAvailableStatus::most_btsetfi_tclMsgServiceAvailableStatus(const most_btsetfi_tclMsgServiceAvailableStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   e8ServiceAvailable = coRef.e8ServiceAvailable;
}
most_btsetfi_tclMsgServiceAvailableStatus& most_btsetfi_tclMsgServiceAvailableStatus::operator=(const most_btsetfi_tclMsgServiceAvailableStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ServiceAvailable = coRef.e8ServiceAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

most_btsetfi_tclMsgServiceAvailableStatus::most_btsetfi_tclMsgServiceAvailableStatus()
:e8ServiceAvailable()
 {}

tS32 most_btsetfi_tclMsgServiceAvailableStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_ServiceAvailableStatus;
}


most_btsetfi_tclMsgServiceAvailableStatus::~most_btsetfi_tclMsgServiceAvailableStatus()
{}

tU32 most_btsetfi_tclMsgServiceAvailableStatus::u32GetSize(tU16 /* u16MajorVersion */) const
{
   return 1;
}

fi_tclInContext& most_btsetfi_tclMsgServiceAvailableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ServiceAvailable);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgServiceAvailableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ServiceAvailable);
   return oOut;
}

tBool most_btsetfi_tclMsgServiceAvailableStatus::operator==(const most_btsetfi_tclMsgServiceAvailableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ServiceAvailable == roRef.e8ServiceAvailable);
   return bResult;
}

//=============================================================================

most_btsetfi_tclMsgVehicleConfigurationUpReg::most_btsetfi_tclMsgVehicleConfigurationUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleConfigurationUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleConfigurationUpReg;
}


most_btsetfi_tclMsgVehicleConfigurationUpReg::~most_btsetfi_tclMsgVehicleConfigurationUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleConfigurationRelUpReg::most_btsetfi_tclMsgVehicleConfigurationRelUpReg()
 {}

tS32 most_btsetfi_tclMsgVehicleConfigurationRelUpReg::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleConfigurationRelUpReg;
}


most_btsetfi_tclMsgVehicleConfigurationRelUpReg::~most_btsetfi_tclMsgVehicleConfigurationRelUpReg()
{}

//=============================================================================

most_btsetfi_tclMsgVehicleConfigurationGet::most_btsetfi_tclMsgVehicleConfigurationGet()
 {}

tS32 most_btsetfi_tclMsgVehicleConfigurationGet::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleConfigurationGet;
}


most_btsetfi_tclMsgVehicleConfigurationGet::~most_btsetfi_tclMsgVehicleConfigurationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleConfigurationError::most_btsetfi_tclMsgVehicleConfigurationError(const most_btsetfi_tclMsgVehicleConfigurationError& coRef)
   : most_btsetfi_tclMsgDefaultError(coRef)
{
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
}
most_btsetfi_tclMsgVehicleConfigurationError& most_btsetfi_tclMsgVehicleConfigurationError::operator=(const most_btsetfi_tclMsgVehicleConfigurationError& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorCode = coRef.e8ErrorCode;
   oErrorInfo = coRef.oErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 most_btsetfi_tclMsgVehicleConfigurationError::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleConfigurationError;
}


most_btsetfi_tclMsgVehicleConfigurationError::~most_btsetfi_tclMsgVehicleConfigurationError()
{}

tBool most_btsetfi_tclMsgVehicleConfigurationError::operator==(const most_btsetfi_tclMsgVehicleConfigurationError& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorCode == roRef.e8ErrorCode);
   bResult = bResult && (oErrorInfo == roRef.oErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
most_btsetfi_tclMsgVehicleConfigurationStatus::most_btsetfi_tclMsgVehicleConfigurationStatus(const most_btsetfi_tclMsgVehicleConfigurationStatus& coRef)
   : most_btsetfi_tclMsgBaseMessage(coRef)
{
   sVehicleBTFriendlyName = coRef.sVehicleBTFriendlyName;
   sVehicleBTAddress = coRef.sVehicleBTAddress;
   oVehicleSupportedProfiles = coRef.oVehicleSupportedProfiles;
   oVehicleIdentification = coRef.oVehicleIdentification;
}
most_btsetfi_tclMsgVehicleConfigurationStatus& most_btsetfi_tclMsgVehicleConfigurationStatus::operator=(const most_btsetfi_tclMsgVehicleConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   sVehicleBTFriendlyName = coRef.sVehicleBTFriendlyName;
   sVehicleBTAddress = coRef.sVehicleBTAddress;
   oVehicleSupportedProfiles = coRef.oVehicleSupportedProfiles;
   oVehicleIdentification = coRef.oVehicleIdentification;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid most_btsetfi_tclMsgVehicleConfigurationStatus::vDestroy()
{
   sVehicleBTFriendlyName.vDestroy(); 
   sVehicleBTAddress.vDestroy(); 
   oVehicleSupportedProfiles.vDestroy(); 
   oVehicleIdentification.vDestroy(); 
}

most_btsetfi_tclMsgVehicleConfigurationStatus::most_btsetfi_tclMsgVehicleConfigurationStatus()
:sVehicleBTFriendlyName()
,sVehicleBTAddress()
,oVehicleSupportedProfiles()
,oVehicleIdentification()
 {}

tS32 most_btsetfi_tclMsgVehicleConfigurationStatus::s32GetTypeId() const
{
   return (tS32) most_btsetfi_tclToken::EN_MSG_VehicleConfigurationStatus;
}


most_btsetfi_tclMsgVehicleConfigurationStatus::~most_btsetfi_tclMsgVehicleConfigurationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 most_btsetfi_tclMsgVehicleConfigurationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   u32DynamicSize += sVehicleBTFriendlyName.u32GetSize(u16MajorVersion);
   u32DynamicSize += sVehicleBTAddress.u32GetSize(u16MajorVersion);
   u32DynamicSize += oVehicleSupportedProfiles.u32GetSize(u16MajorVersion);
   u32DynamicSize += oVehicleIdentification.u32GetSize(u16MajorVersion);
   return 0 + u32DynamicSize;
}

fi_tclInContext& most_btsetfi_tclMsgVehicleConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sVehicleBTFriendlyName);
   (tVoid) (oIn >> sVehicleBTAddress);
   (tVoid) (oIn >> oVehicleSupportedProfiles);
   (tVoid) (oIn >> oVehicleIdentification);
   return oIn;
}

fi_tclOutContext& most_btsetfi_tclMsgVehicleConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sVehicleBTFriendlyName);
   (tVoid) (oOut << sVehicleBTAddress);
   (tVoid) (oOut << oVehicleSupportedProfiles);
   (tVoid) (oOut << oVehicleIdentification);
   return oOut;
}

tBool most_btsetfi_tclMsgVehicleConfigurationStatus::operator==(const most_btsetfi_tclMsgVehicleConfigurationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sVehicleBTFriendlyName == roRef.sVehicleBTFriendlyName);
   bResult = bResult && (sVehicleBTAddress == roRef.sVehicleBTAddress);
   bResult = bResult && (oVehicleSupportedProfiles == roRef.oVehicleSupportedProfiles);
   bResult = bResult && (oVehicleIdentification == roRef.oVehicleIdentification);
   return bResult;
}

