#ifndef _PROTOCOLCONNECTSM_H_
#define _PROTOCOLCONNECTSM_H_

/* generated code: do not edit */

#include "BtsSmfWrapper.h"

#include "BtStackInternalSmTypes.h"

namespace btstackif {

#define PROTOCOLCONNECTSM_NAME "ProtocolConnectSm"

class ProtocolConnectSm: public SmfWrapper {
public:
	ProtocolConnectSm() :
	ACCEPT_CONNECT(0),
	BUSY(0),
	CANCEL(0),
	CANCELED(0),
	CANCEL_RESULT(0),
	CHARACTER_DEVICE_AVAILABLE(0),
	CONNECT(0),
	CONNECTING(0),
	CONNECT_EXTERN(0),
	CONNECT_RESULT(0),
	CONTINUE_CANCEL(0),
	CREATE_FAILED(0),
	CREATE_SUCCESS(0),
	DISCONNECTING(0),
	EXIT(0),
	EXIT_NO_RETRY(0),
	FINAL_STATE(0),
	GUARD_PERIOD_EXPIRED(0),
	INIT(0),
	REJECT_CONNECT(0),
	RETRY_CONNECT(0),
	SEARCH_FAILED(0),
	SEARCH_SUCCESS(0),
	SETTING_FAILED(0),
	SETTING_SUCCESS(0),
	SET_PAGE_TIMEOUT_SUCCESS(0),
	START(0),
	WAITING_FOR_PROTOCOL_FAILED(0),
	WAITING_FOR_PROTOCOL_SUCCESS(0),
	WAITING_FOR_SERVICE_FAILED(0),
	WAITING_FOR_SERVICE_SUCCESS(0),
	dummy_do_not_use(0)
	{
		SetSMName(PROTOCOLCONNECTSM_NAME);
	}

	/* enums for states */
	enum ProtocolConnectSm_states {
		topProtocolConnect,
		Main,
		Final,
		Disconnected,
		Creating,
		Searching,
		Setting,
		Connecting,
		Busy,
		Waiting,
		WaitingForService,
		WaitingForProtocol,
		StartConnect,
		CheckForRetry,
		Canceled,
		GuardPeriod,
		WaitForCharacterDevice,
		SetPageTimeout,
	};

	// generated virtual implementations of user callback functions
	virtual int checkCreating() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int checkSearching() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int checkSetting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int checkSettingPageTimeout() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int checkWaitingForProtocol() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int checkWaitingForService() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int entryBusy() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int entryCheckForCharacterDevice() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int entryCheckForRetry() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int entryDisconnected() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int exitBusy() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int exitConnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleBusyCanceled(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleCancel() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleCancelDuringBusy() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleCancelDuringConnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleCancelDuringSearching() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleCharacterDeviceAvailable() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleConnectCompleted(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleConnectFinalState(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleConnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleConnectingCanceled() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleContinueCancel() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleCreateCanceled() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleCreateFailed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleDisconnectedReached(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleDisconnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleExitNoRetry() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleFinalStateDuringGuardPeriod(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleFinalStateDuringWaitForCharacterDevice(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleGuardPeriodExpired() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleRemoteConnect() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleRemoteConnectDuringCanceled() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleRemoteConnectDuringConnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleRemoteConnectDuringSearching() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleRemoteConnectDuringSetting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleRemoteConnectDuringWaiting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleRemoteConnectDuringWaitingForProtocol() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleRemoteConnecting() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleSearchCanceled() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleSearchFailed(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleSetPageTimeoutCanceled() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleSettingCanceled() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleSettingFailed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleWaitingForProtocolCanceled() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleWaitingForProtocolFailed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleWaitingForServiceCanceled() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleWaitingForServiceFailed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int initSm() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int isCanceled() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int isFinalStateDisconnectedReached(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int isFinalStateReached(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int sendAccept() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int sendConnect() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int sendDirectAccept() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int sendReject() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int storeFinalState(const BTSRequestResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	int ParameterCANCEL_RESULT(char *parameterString, const size_t size, const BTSRequestResult _1)
	{
		return (Marshal(parameterString, size-1, BTSREQUESTRESULT_FORMAT , _1) != 0 ? 0 : -1);
	}

	int ParameterCONNECT_RESULT(char *parameterString, const size_t size, const BTSRequestResult _1)
	{
		return (Marshal(parameterString, size-1, BTSREQUESTRESULT_FORMAT , _1) != 0 ? 0 : -1);
	}

	int ParameterFINAL_STATE(char *parameterString, const size_t size, const BTSRequestResult _1)
	{
		return (Marshal(parameterString, size-1, BTSREQUESTRESULT_FORMAT , _1) != 0 ? 0 : -1);
	}

	int ParameterSEARCH_FAILED(char *parameterString, const size_t size, const BTSRequestResult _1)
	{
		return (Marshal(parameterString, size-1, BTSREQUESTRESULT_FORMAT , _1) != 0 ? 0 : -1);
	}


protected:

	// generates static call functions for all state machine user callbacks
	static int checkCreatingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->checkCreating();
	}

	static int checkSearchingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->checkSearching();
	}

	static int checkSettingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->checkSetting();
	}

	static int checkSettingPageTimeoutCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->checkSettingPageTimeout();
	}

	static int checkWaitingForProtocolCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->checkWaitingForProtocol();
	}

	static int checkWaitingForServiceCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->checkWaitingForService();
	}

	static int entryBusyCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectSm *)(state->_this))->entryBusy();
	}

	static int entryCheckForCharacterDeviceCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectSm *)(state->_this))->entryCheckForCharacterDevice();
	}

	static int entryCheckForRetryCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectSm *)(state->_this))->entryCheckForRetry();
	}

	static int entryDisconnectedCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectSm *)(state->_this))->entryDisconnected();
	}

	static int exitBusyCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectSm *)(state->_this))->exitBusy();
	}

	static int exitConnectingCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((ProtocolConnectSm *)(state->_this))->exitConnecting();
	}

	static int handleBusyCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->handleBusyCanceled(_1);
		return ret;
	}

	static int handleCancelCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleCancel();
	}

	static int handleCancelDuringBusyCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleCancelDuringBusy();
	}

	static int handleCancelDuringConnectingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleCancelDuringConnecting();
	}

	static int handleCancelDuringSearchingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleCancelDuringSearching();
	}

	static int handleCharacterDeviceAvailableCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleCharacterDeviceAvailable();
	}

	static int handleConnectCompletedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->handleConnectCompleted(_1);
		return ret;
	}

	static int handleConnectFinalStateCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->handleConnectFinalState(_1);
		return ret;
	}

	static int handleConnectingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleConnecting();
	}

	static int handleConnectingCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleConnectingCanceled();
	}

	static int handleContinueCancelCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleContinueCancel();
	}

	static int handleCreateCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleCreateCanceled();
	}

	static int handleCreateFailedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleCreateFailed();
	}

	static int handleDisconnectedReachedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->handleDisconnectedReached(_1);
		return ret;
	}

	static int handleDisconnectingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleDisconnecting();
	}

	static int handleExitNoRetryCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleExitNoRetry();
	}

	static int handleFinalStateDuringGuardPeriodCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->handleFinalStateDuringGuardPeriod(_1);
		return ret;
	}

	static int handleFinalStateDuringWaitForCharacterDeviceCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->handleFinalStateDuringWaitForCharacterDevice(_1);
		return ret;
	}

	static int handleGuardPeriodExpiredCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleGuardPeriodExpired();
	}

	static int handleRemoteConnectCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleRemoteConnect();
	}

	static int handleRemoteConnectDuringCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleRemoteConnectDuringCanceled();
	}

	static int handleRemoteConnectDuringConnectingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleRemoteConnectDuringConnecting();
	}

	static int handleRemoteConnectDuringSearchingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleRemoteConnectDuringSearching();
	}

	static int handleRemoteConnectDuringSettingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleRemoteConnectDuringSetting();
	}

	static int handleRemoteConnectDuringWaitingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleRemoteConnectDuringWaiting();
	}

	static int handleRemoteConnectDuringWaitingForProtocolCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleRemoteConnectDuringWaitingForProtocol();
	}

	static int handleRemoteConnectingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleRemoteConnecting();
	}

	static int handleSearchCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleSearchCanceled();
	}

	static int handleSearchFailedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->handleSearchFailed(_1);
		return ret;
	}

	static int handleSetPageTimeoutCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleSetPageTimeoutCanceled();
	}

	static int handleSettingCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleSettingCanceled();
	}

	static int handleSettingFailedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleSettingFailed();
	}

	static int handleWaitingForProtocolCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleWaitingForProtocolCanceled();
	}

	static int handleWaitingForProtocolFailedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleWaitingForProtocolFailed();
	}

	static int handleWaitingForServiceCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleWaitingForServiceCanceled();
	}

	static int handleWaitingForServiceFailedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->handleWaitingForServiceFailed();
	}

	static int initSmCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->initSm();
	}

	static int isCanceledCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->isCanceled();
	}

	static int isFinalStateDisconnectedReachedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->isFinalStateDisconnectedReached(_1);
		return ret;
	}

	static int isFinalStateReachedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->isFinalStateReached(_1);
		return ret;
	}

	static int sendAcceptCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->sendAccept();
	}

	static int sendConnectCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->sendConnect();
	}

	static int sendDirectAcceptCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->sendDirectAccept();
	}

	static int sendRejectCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((ProtocolConnectSm *)(trans->_this))->sendReject();
	}

	static int storeFinalStateCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BTSRequestResult _1 = BTSREQUESTRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BTSREQUESTRESULT_FORMAT  ,&_1 );
		}
		ret = ((ProtocolConnectSm *)(trans->_this))->storeFinalState(_1);
		return ret;
	}


public:

	/* used external events */
	SMF::tEvent *ACCEPT_CONNECT;
	SMF::tEvent *BUSY;
	SMF::tEvent *CANCEL;
	SMF::tEvent *CANCELED;
	SMF::tEvent *CANCEL_RESULT;
	SMF::tEvent *CHARACTER_DEVICE_AVAILABLE;
	SMF::tEvent *CONNECT;
	SMF::tEvent *CONNECTING;
	SMF::tEvent *CONNECT_EXTERN;
	SMF::tEvent *CONNECT_RESULT;
	SMF::tEvent *CONTINUE_CANCEL;
	SMF::tEvent *CREATE_FAILED;
	SMF::tEvent *CREATE_SUCCESS;
	SMF::tEvent *DISCONNECTING;
	SMF::tEvent *EXIT;
	SMF::tEvent *EXIT_NO_RETRY;
	SMF::tEvent *FINAL_STATE;
	SMF::tEvent *GUARD_PERIOD_EXPIRED;
	SMF::tEvent *INIT;
	SMF::tEvent *REJECT_CONNECT;
	SMF::tEvent *RETRY_CONNECT;
	SMF::tEvent *SEARCH_FAILED;
	SMF::tEvent *SEARCH_SUCCESS;
	SMF::tEvent *SETTING_FAILED;
	SMF::tEvent *SETTING_SUCCESS;
	SMF::tEvent *SET_PAGE_TIMEOUT_SUCCESS;
	SMF::tEvent *START;
	SMF::tEvent *WAITING_FOR_PROTOCOL_FAILED;
	SMF::tEvent *WAITING_FOR_PROTOCOL_SUCCESS;
	SMF::tEvent *WAITING_FOR_SERVICE_FAILED;
	SMF::tEvent *WAITING_FOR_SERVICE_SUCCESS;
	int dummy_do_not_use;


virtual void Create()
{
	if (_created) {
		/* SM was already created => return now */
		return;
	}

	_created = true;

	/* state machine definition */


	/* create new compound state */
	tState *topProtocolConnect_15a6f7f242b80000000000000000867 = CreateCompoundState("topProtocolConnect", topProtocolConnect, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *Main_15a6f7f242b80000000000000000868 = CreateCompoundState("Main", Main, NULL, NULL, NULL, NULL);

	/* create final states */
	tState *Final_15a6f7f242b8000000000000000086A = CreateFinalState("Final", Final, NULL, NULL);
	AddState(Main_15a6f7f242b80000000000000000868, Final_15a6f7f242b8000000000000000086A);

	/* create states */
	tState *Disconnected_15a6f7f242b8000000000000000086B = CreateState("Disconnected", Disconnected, entryDisconnectedCall, "entryDisconnected", NULL, NULL);
	tState *Creating_15a6f7f242b80000000000000000876 = CreateState("Creating", Creating, NULL, NULL, NULL, NULL);
	tState *Searching_15a6f7f242b80000000000000000877 = CreateState("Searching", Searching, NULL, NULL, NULL, NULL);
	tState *Setting_15a6f7f242b80000000000000000878 = CreateState("Setting", Setting, NULL, NULL, NULL, NULL);
	tState *Connecting_15a6f7f242b800000000000000008B2 = CreateState("Connecting", Connecting, NULL, NULL, exitConnectingCall, "exitConnecting");
	tState *Busy_15a6f7f242b800000000000000008B3 = CreateState("Busy", Busy, entryBusyCall, "entryBusy", exitBusyCall, "exitBusy");
	tState *Waiting_15a6fbb5e4580000000000000000AC3 = CreateState("Waiting", Waiting, NULL, NULL, NULL, NULL);
	tState *WaitingForService_16036a2b22080000000000000000A12 = CreateState("WaitingForService", WaitingForService, NULL, NULL, NULL, NULL);
	tState *WaitingForProtocol_16036ac336880000000000000000A24 = CreateState("WaitingForProtocol", WaitingForProtocol, NULL, NULL, NULL, NULL);
	tState *StartConnect_16194544c8a80000000000000000A45 = CreateState("StartConnect", StartConnect, NULL, NULL, NULL, NULL);
	tState *CheckForRetry_162ae53492180000000000000000A49 = CreateState("CheckForRetry", CheckForRetry, entryCheckForRetryCall, "entryCheckForRetry", NULL, NULL);
	tState *Canceled_162afe3e30c80000000000000000A54 = CreateState("Canceled", Canceled, NULL, NULL, NULL, NULL);
	tState *GuardPeriod_162afe3e30c80000000000000000A55 = CreateState("GuardPeriod", GuardPeriod, NULL, NULL, NULL, NULL);
	tState *WaitForCharacterDevice_166267198ee80000000000000000A81 = CreateState("WaitForCharacterDevice", WaitForCharacterDevice, entryCheckForCharacterDeviceCall, "entryCheckForCharacterDevice", NULL, NULL);
	tState *SetPageTimeout_1668756450e80000000000000000A8A = CreateState("SetPageTimeout", SetPageTimeout, NULL, NULL, NULL, NULL);

	/* create states */
	tTransition *Init_15a6f7f242b80000000000000000869 = CreateTransition("Init", NULL, NULL, initSmCall, "initSm", StartConnect_16194544c8a80000000000000000A45);

	/* set the init transition */
	SetInitTransition(topProtocolConnect_15a6f7f242b80000000000000000867, Init_15a6f7f242b80000000000000000869);

	/* Add in states */
	AddState(topProtocolConnect_15a6f7f242b80000000000000000867, Main_15a6f7f242b80000000000000000868);
	AddState(Main_15a6f7f242b80000000000000000868, Disconnected_15a6f7f242b8000000000000000086B);
	AddState(Main_15a6f7f242b80000000000000000868, Creating_15a6f7f242b80000000000000000876);
	AddState(Main_15a6f7f242b80000000000000000868, Searching_15a6f7f242b80000000000000000877);
	AddState(Main_15a6f7f242b80000000000000000868, Setting_15a6f7f242b80000000000000000878);
	AddState(Main_15a6f7f242b80000000000000000868, Connecting_15a6f7f242b800000000000000008B2);
	AddState(Main_15a6f7f242b80000000000000000868, Busy_15a6f7f242b800000000000000008B3);
	AddState(Main_15a6f7f242b80000000000000000868, Waiting_15a6fbb5e4580000000000000000AC3);
	AddState(Main_15a6f7f242b80000000000000000868, WaitingForService_16036a2b22080000000000000000A12);
	AddState(Main_15a6f7f242b80000000000000000868, WaitingForProtocol_16036ac336880000000000000000A24);
	AddState(Main_15a6f7f242b80000000000000000868, StartConnect_16194544c8a80000000000000000A45);
	AddState(Main_15a6f7f242b80000000000000000868, CheckForRetry_162ae53492180000000000000000A49);
	AddState(Main_15a6f7f242b80000000000000000868, Canceled_162afe3e30c80000000000000000A54);
	AddState(Main_15a6f7f242b80000000000000000868, GuardPeriod_162afe3e30c80000000000000000A55);
	AddState(Main_15a6f7f242b80000000000000000868, WaitForCharacterDevice_166267198ee80000000000000000A81);
	AddState(Main_15a6f7f242b80000000000000000868, SetPageTimeout_1668756450e80000000000000000A8A);

	/* create events */
	ACCEPT_CONNECT = CreateEvent("ACCEPT_CONNECT");
	BUSY = CreateEvent("BUSY");
	CANCEL = CreateEvent("CANCEL");
	CANCELED = CreateEvent("CANCELED");
	CANCEL_RESULT = CreateEvent("CANCEL_RESULT");
	CHARACTER_DEVICE_AVAILABLE = CreateEvent("CHARACTER_DEVICE_AVAILABLE");
	CONNECT = CreateEvent("CONNECT");
	CONNECTING = CreateEvent("CONNECTING");
	CONNECT_EXTERN = CreateEvent("CONNECT_EXTERN");
	CONNECT_RESULT = CreateEvent("CONNECT_RESULT");
	CONTINUE_CANCEL = CreateEvent("CONTINUE_CANCEL");
	CREATE_FAILED = CreateEvent("CREATE_FAILED");
	CREATE_SUCCESS = CreateEvent("CREATE_SUCCESS");
	DISCONNECTING = CreateEvent("DISCONNECTING");
	EXIT = CreateEvent("EXIT");
	EXIT_NO_RETRY = CreateEvent("EXIT_NO_RETRY");
	FINAL_STATE = CreateEvent("FINAL_STATE");
	GUARD_PERIOD_EXPIRED = CreateEvent("GUARD_PERIOD_EXPIRED");
	INIT = CreateEvent("INIT");
	REJECT_CONNECT = CreateEvent("REJECT_CONNECT");
	RETRY_CONNECT = CreateEvent("RETRY_CONNECT");
	SEARCH_FAILED = CreateEvent("SEARCH_FAILED");
	SEARCH_SUCCESS = CreateEvent("SEARCH_SUCCESS");
	SETTING_FAILED = CreateEvent("SETTING_FAILED");
	SETTING_SUCCESS = CreateEvent("SETTING_SUCCESS");
	SET_PAGE_TIMEOUT_SUCCESS = CreateEvent("SET_PAGE_TIMEOUT_SUCCESS");
	START = CreateEvent("START");
	WAITING_FOR_PROTOCOL_FAILED = CreateEvent("WAITING_FOR_PROTOCOL_FAILED");
	WAITING_FOR_PROTOCOL_SUCCESS = CreateEvent("WAITING_FOR_PROTOCOL_SUCCESS");
	WAITING_FOR_SERVICE_FAILED = CreateEvent("WAITING_FOR_SERVICE_FAILED");
	WAITING_FOR_SERVICE_SUCCESS = CreateEvent("WAITING_FOR_SERVICE_SUCCESS");

	/* create event transitions */

	/* create internal transactions */
/*2*/	tTransition *Busy2Busy_Cancel_P16179de72ce80000000000000000A3C = CreateEventTransition(CANCEL, "BUSY2BUSY_CANCEL", NULL, NULL,  handleCancelDuringBusyCall,  "handleCancelDuringBusy", NULL);
/*2*/	tTransition *Canceled2Canceled_ConnectExtern_P162afe3e30c80000000000000000A56 = CreateEventTransition(CONNECT_EXTERN, "CANCELED2CANCELED_CONNECTEXTERN", NULL, NULL,  handleRemoteConnectDuringCanceledCall,  "handleRemoteConnectDuringCanceled", NULL);
/*2*/	tTransition *Canceled2Canceled_ConnectResult_P162afe3e30c80000000000000000A58 = CreateEventTransition(CONNECT_RESULT, "CANCELED2CANCELED_CONNECTRESULT", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Canceled2Canceled_FinalState_P162afe3e30c80000000000000000A57 = CreateEventTransition(FINAL_STATE, "CANCELED2CANCELED_FINALSTATE", NULL, NULL,  storeFinalStateCall,  "storeFinalState", NULL);
/*2*/	tTransition *Connecting2Connecting_AcceptConnect_P15a6fbb5e4580000000000000000AF5 = CreateEventTransition(ACCEPT_CONNECT, "CONNECTING2CONNECTING_ACCEPTCONNECT", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Connecting2Connecting_Cancel_P15a6f7f242b800000000000000008B7 = CreateEventTransition(CANCEL, "CONNECTING2CONNECTING_CANCEL", NULL, NULL,  handleCancelDuringConnectingCall,  "handleCancelDuringConnecting", NULL);
/*2*/	tTransition *Connecting2Connecting_ConnectExtern_P15a6fbb5e4580000000000000000AE5 = CreateEventTransition(CONNECT_EXTERN, "CONNECTING2CONNECTING_CONNECTEXTERN", NULL, NULL,  handleRemoteConnectDuringConnectingCall,  "handleRemoteConnectDuringConnecting", NULL);
/*2*/	tTransition *Connecting2Connecting_FinalState_P15a6fbb5e4580000000000000000AD6 = CreateEventTransition(FINAL_STATE, "CONNECTING2CONNECTING_FINALSTATE", NULL, NULL,  storeFinalStateCall,  "storeFinalState", NULL);
/*2*/	tTransition *Connecting2Connecting_RejectConnect_P15a6fbb5e4580000000000000000AF6 = CreateEventTransition(REJECT_CONNECT, "CONNECTING2CONNECTING_REJECTCONNECT", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Disconnected2Disconnected_ConnectExtern_P15a6fbb5e4580000000000000000ADB = CreateEventTransition(CONNECT_EXTERN, "DISCONNECTED2DISCONNECTED_CONNECTEXTERN", NULL, NULL,  handleRemoteConnectCall,  "handleRemoteConnect", NULL);
/*2*/	tTransition *Disconnected2Disconnected_Connecting_P15a6fbb5e4580000000000000000AFB = CreateEventTransition(CONNECTING, "DISCONNECTED2DISCONNECTED_CONNECTING", NULL, NULL,  handleRemoteConnectingCall,  "handleRemoteConnecting", NULL);
/*2*/	tTransition *GuardPeriod2GuardPeriod_ConnectExtern_P162afe3e30c80000000000000000A64 = CreateEventTransition(CONNECT_EXTERN, "GUARDPERIOD2GUARDPERIOD_CONNECTEXTERN", NULL, NULL,  handleRemoteConnectDuringCanceledCall,  "handleRemoteConnectDuringCanceled", NULL);
/*2*/	tTransition *GuardPeriod2GuardPeriod_ConnectResult_P162afe3e30c80000000000000000A6B = CreateEventTransition(CONNECT_RESULT, "GUARDPERIOD2GUARDPERIOD_CONNECTRESULT", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *GuardPeriod2GuardPeriod_FinalState_P162afe3e30c80000000000000000A65 = CreateEventTransition(FINAL_STATE, "GUARDPERIOD2GUARDPERIOD_FINALSTATE", NULL, NULL,  handleFinalStateDuringGuardPeriodCall,  "handleFinalStateDuringGuardPeriod", NULL);
/*2*/	tTransition *Main2Main_Accept_P16179de72ce80000000000000000A41 = CreateEventTransition(ACCEPT_CONNECT, "MAIN2MAIN_ACCEPT", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_Cancel_P15a6f7f242b80000000000000000872 = CreateEventTransition(CANCEL, "MAIN2MAIN_CANCEL", NULL, NULL,  handleCancelCall,  "handleCancel", NULL);
/*2*/	tTransition *Main2Main_Canceled_P15a6fbb5e4580000000000000000B0F = CreateEventTransition(CANCELED, "MAIN2MAIN_CANCELED", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_CharacterDeviceAvailable_P166267d486f80000000000000000A88 = CreateEventTransition(CHARACTER_DEVICE_AVAILABLE, "MAIN2MAIN_CHARACTERDEVICEAVAILABLE", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_ConnectResult_P15a6fbb5e4580000000000000000AF9 = CreateEventTransition(CONNECT_RESULT, "MAIN2MAIN_CONNECTRESULT", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_Connecting_P15a6fbb5e4580000000000000000AFF = CreateEventTransition(CONNECTING, "MAIN2MAIN_CONNECTING", NULL, NULL,  handleConnectingCall,  "handleConnecting", NULL);
/*2*/	tTransition *Main2Main_CreateFailed_P15a6fbb5e4580000000000000000AF8 = CreateEventTransition(CREATE_FAILED, "MAIN2MAIN_CREATEFAILED", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_CreateSuccess_P15a6fbb5e4580000000000000000AF7 = CreateEventTransition(CREATE_SUCCESS, "MAIN2MAIN_CREATESUCCESS", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_Disconnecting_P162b3d038a480000000000000000A73 = CreateEventTransition(DISCONNECTING, "MAIN2MAIN_DISCONNECTING", NULL, NULL,  handleDisconnectingCall,  "handleDisconnecting", NULL);
/*2*/	tTransition *Main2Main_FinalState_P15a6fbb5e4580000000000000000AFA = CreateEventTransition(FINAL_STATE, "MAIN2MAIN_FINALSTATE", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_Reject_P16179de72ce80000000000000000A42 = CreateEventTransition(REJECT_CONNECT, "MAIN2MAIN_REJECT", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_SearchFailed_P1618fb8161580000000000000000A42 = CreateEventTransition(SEARCH_FAILED, "MAIN2MAIN_SEARCHFAILED", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_SearchSuccess_P1618fb8161580000000000000000A41 = CreateEventTransition(SEARCH_SUCCESS, "MAIN2MAIN_SEARCHSUCCESS", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Main2Main_Start_P16194544c8a80000000000000000A48 = CreateEventTransition(START, "MAIN2MAIN_START", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *Searching2Searching_Cancel_P15a6f7f242b80000000000000000879 = CreateEventTransition(CANCEL, "SEARCHING2SEARCHING_CANCEL", NULL, NULL,  handleCancelDuringSearchingCall,  "handleCancelDuringSearching", NULL);
/*2*/	tTransition *Searching2Searching_ConnectExtern_P1668756450e80000000000000000A9E = CreateEventTransition(CONNECT_EXTERN, "SEARCHING2SEARCHING_CONNECTEXTERN", NULL, NULL,  handleRemoteConnectDuringSearchingCall,  "handleRemoteConnectDuringSearching", NULL);
/*2*/	tTransition *Setting2Setting_ConnectExtern_P16036e11c3280000000000000000A35 = CreateEventTransition(CONNECT_EXTERN, "SETTING2SETTING_CONNECTEXTERN", NULL, NULL,  handleRemoteConnectDuringSettingCall,  "handleRemoteConnectDuringSetting", NULL);
/*2*/	tTransition *Waiting2Waiting_ConnectExtern_P15a6fbb5e4580000000000000000B03 = CreateEventTransition(CONNECT_EXTERN, "WAITING2WAITING_CONNECTEXTERN", NULL, NULL,  handleRemoteConnectDuringWaitingCall,  "handleRemoteConnectDuringWaiting", NULL);
/*2*/	tTransition *Waiting2Waiting_ConnectResult_P15a6fbb5e4580000000000000000ADA = CreateEventTransition(CONNECT_RESULT, "WAITING2WAITING_CONNECTRESULT", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *WaitingForProtocol2WaitingForProtocol_ConnectExtern_P1668756450e80000000000000000AA1 = CreateEventTransition(CONNECT_EXTERN, "WAITINGFORPROTOCOL2WAITINGFORPROTOCOL_CONNECTEXTERN", NULL, NULL,  handleRemoteConnectDuringWaitingForProtocolCall,  "handleRemoteConnectDuringWaitingForProtocol", NULL);

	/* create event transitions */
/*11*/	tTransition *Canceled2ConditionFinalStateDisconnected_CancelResult_162afe3e30c80000000000000000A5E = CreateEventConditionalTransition(CANCEL_RESULT, "Canceled2ConditionFinalStateDisconnected_CancelResult", Main_15a6f7f242b80000000000000000868, NULL, NULL, isFinalStateDisconnectedReachedCall, "isFinalStateDisconnectedReached", handleDisconnectedReachedCall, "handleDisconnectedReachedTrue", NULL, NULL, "trueConditionFinalStateDisconnected2WaitForCharacterDevice_True", WaitForCharacterDevice_166267198ee80000000000000000A81, "falseConditionFinalStateDisconnected2GuardPeriod_False", GuardPeriod_162afe3e30c80000000000000000A55);
/*11*/	tTransition *Connecting2ConditionFinalState_ConnectResult_15a6fbb5e4580000000000000000AC5 = CreateEventConditionalTransition(CONNECT_RESULT, "Connecting2ConditionFinalState_ConnectResult", Main_15a6f7f242b80000000000000000868, NULL, NULL, isFinalStateReachedCall, "isFinalStateReached", handleConnectFinalStateCall, "handleConnectFinalStateTrue", NULL, NULL, "trueConditionFinalState2Final_True", CheckForRetry_162ae53492180000000000000000A49, "falseConditionFinalState2Waiting_False", Waiting_15a6fbb5e4580000000000000000AC3);
/*11*/	tTransition *Creating2ConditionCreateCanceled_CreateSuccess_15a6f7f242b80000000000000000882 = CreateEventConditionalTransition(CREATE_SUCCESS, "Creating2ConditionCreateCanceled_CreateSuccess", Main_15a6f7f242b80000000000000000868, NULL, NULL, isCanceledCall, "isCanceled", handleCreateCanceledCall, "handleCreateCanceledTrue", checkSettingPageTimeoutCall, "checkSettingPageTimeoutFalse", "trueConditionCreateCanceled2Final_True", CheckForRetry_162ae53492180000000000000000A49, "falseConditionCreateCanceled2SetPageTimeout_False", SetPageTimeout_1668756450e80000000000000000A8A);
/*11*/	tTransition *Disconnected2ConditionFinalStateRemote_ConnectResult_15a6fbb5e4580000000000000000B06 = CreateEventConditionalTransition(CONNECT_RESULT, "Disconnected2ConditionFinalStateRemote_ConnectResult", Main_15a6f7f242b80000000000000000868, NULL, NULL, isFinalStateReachedCall, "isFinalStateReached", handleConnectFinalStateCall, "handleConnectFinalStateTrue", NULL, NULL, "trueConditionFinalStateRemote2Final_True", CheckForRetry_162ae53492180000000000000000A49, "falseConditionFinalStateRemote2Waiting_False", Waiting_15a6fbb5e4580000000000000000AC3);
/*11*/	tTransition *Searching2ConditionSearchCanceled_SearchSuccess_15a6f7f242b8000000000000000089C = CreateEventConditionalTransition(SEARCH_SUCCESS, "Searching2ConditionSearchCanceled_SearchSuccess", Main_15a6f7f242b80000000000000000868, NULL, NULL, isCanceledCall, "isCanceled", handleSearchCanceledCall, "handleSearchCanceledTrue", checkWaitingForProtocolCall, "checkWaitingForProtocolFalse", "trueConditionSearchCanceled2Final_True", CheckForRetry_162ae53492180000000000000000A49, "falseConditionSearchCanceled2WaitingForProtocol_False", WaitingForProtocol_16036ac336880000000000000000A24);
/*11*/	tTransition *SetPageTimeout2ConditionSetPageTimeoutCanceled_SetPageTimeoutSuccess_1668756450e80000000000000000A8C = CreateEventConditionalTransition(SET_PAGE_TIMEOUT_SUCCESS, "SetPageTimeout2ConditionSetPageTimeoutCanceled_SetPageTimeoutSuccess", Main_15a6f7f242b80000000000000000868, NULL, NULL, isCanceledCall, "isCanceled", handleSetPageTimeoutCanceledCall, "handleSetPageTimeoutCanceledTrue", checkSearchingCall, "checkSearchingFalse", "trueConditionSetPageTimeoutCanceled2Final_True", CheckForRetry_162ae53492180000000000000000A49, "falseConditionSetPageTimeoutCanceled2Searching_False", Searching_15a6f7f242b80000000000000000877);
/*11*/	tTransition *WaitingForService2ConditionWaitForServiceCanceled_WaitingForServiceSuccess_16036ac336880000000000000000A1B = CreateEventConditionalTransition(WAITING_FOR_SERVICE_SUCCESS, "WaitingForService2ConditionWaitForServiceCanceled_WaitingForServiceSuccess", Main_15a6f7f242b80000000000000000868, NULL, NULL, isCanceledCall, "isCanceled", handleWaitingForServiceCanceledCall, "handleWaitingForServiceCanceledTrue", checkCreatingCall, "checkCreatingFalse", "trueConditionWaitForServiceCanceled2Final_True", CheckForRetry_162ae53492180000000000000000A49, "falseConditionWaitForServiceCanceled2Creating_False", Creating_15a6f7f242b80000000000000000876);
/*7*/	tTransition *Busy2Connecting_ConnectExtern_15a6fbb5e4580000000000000000AE8 = CreateEventTransition(CONNECT_EXTERN, "Busy2Connecting_ConnectExtern", NULL, NULL, sendDirectAcceptCall, "sendDirectAccept", Connecting_15a6f7f242b800000000000000008B2);
/*7*/	tTransition *Busy2Connecting_Connect_15a6fbb5e4580000000000000000ABF = CreateEventTransition(CONNECT, "Busy2Connecting_Connect", NULL, NULL, sendConnectCall, "sendConnect", Connecting_15a6f7f242b800000000000000008B2);
/*7*/	tTransition *Busy2Final_Cancel_15a6f7f242b800000000000000008C6 = CreateEventTransition(CONNECT_RESULT, "Busy2Final_Cancel", NULL, NULL, handleBusyCanceledCall, "handleBusyCanceled", CheckForRetry_162ae53492180000000000000000A49);
/*7*/	tTransition *CheckForRetry2Connecting_RetryConnect_162ae53492180000000000000000A50 = CreateEventTransition(RETRY_CONNECT, "CheckForRetry2Connecting_RetryConnect", NULL, NULL, NULL, NULL, Busy_15a6f7f242b800000000000000008B3);
/*7*/	tTransition *CheckForRetry2WaitForCharacterDevice_ExitNoRetry_162ae53492180000000000000000A4C = CreateEventTransition(EXIT_NO_RETRY, "CheckForRetry2WaitForCharacterDevice_ExitNoRetry", NULL, NULL, handleExitNoRetryCall, "handleExitNoRetry", WaitForCharacterDevice_166267198ee80000000000000000A81);
/*7*/	tTransition *Connecting2Canceled_Cancel_162b3d038a480000000000000000A70 = CreateEventTransition(CONTINUE_CANCEL, "Connecting2Canceled_Cancel", NULL, NULL, handleContinueCancelCall, "handleContinueCancel", Canceled_162afe3e30c80000000000000000A54);
/*7*/	tTransition *Creating2Connecting_ConnectExtern_15a6fbb5e4580000000000000000ADF = CreateEventTransition(CONNECT_EXTERN, "Creating2Connecting_ConnectExtern", NULL, NULL, sendDirectAcceptCall, "sendDirectAccept", Connecting_15a6f7f242b800000000000000008B2);
/*7*/	tTransition *Creating2Final_CreateFailed_15a6f7f242b8000000000000000088E = CreateEventTransition(CREATE_FAILED, "Creating2Final_CreateFailed", NULL, NULL, handleCreateFailedCall, "handleCreateFailed", CheckForRetry_162ae53492180000000000000000A49);
/*7*/	tTransition *Disconnected2Connecting_AcceptConnect_15a6fbb5e4580000000000000000AED = CreateEventTransition(ACCEPT_CONNECT, "Disconnected2Connecting_AcceptConnect", NULL, NULL, sendAcceptCall, "sendAccept", Connecting_15a6f7f242b800000000000000008B2);
/*7*/	tTransition *Disconnected2Connecting_RejectConnect_15a6fbb5e4580000000000000000AF1 = CreateEventTransition(REJECT_CONNECT, "Disconnected2Connecting_RejectConnect", NULL, NULL, sendRejectCall, "sendReject", Connecting_15a6f7f242b800000000000000008B2);
/*7*/	tTransition *Disconnected2WaitingForService_Connect_16036a2b22080000000000000000A13 = CreateEventTransition(CONNECT, "Disconnected2WaitingForService_Connect", NULL, NULL, checkWaitingForServiceCall, "checkWaitingForService", WaitingForService_16036a2b22080000000000000000A12);
/*7*/	tTransition *GuardPeriod2WaitForCharacterDevice_GuardPeriodExpired_162afe3e30c80000000000000000A6C = CreateEventTransition(GUARD_PERIOD_EXPIRED, "GuardPeriod2WaitForCharacterDevice_GuardPeriodExpired", NULL, NULL, handleGuardPeriodExpiredCall, "handleGuardPeriodExpired", WaitForCharacterDevice_166267198ee80000000000000000A81);
/*7*/	tTransition *Searching2Final_SearchFailed_15a6f7f242b80000000000000000895 = CreateEventTransition(SEARCH_FAILED, "Searching2Final_SearchFailed", NULL, NULL, handleSearchFailedCall, "handleSearchFailed", CheckForRetry_162ae53492180000000000000000A49);
/*7*/	tTransition *SetPageTimeout2Connecting_ConnectExtern_1668756450e80000000000000000A9B = CreateEventTransition(CONNECT_EXTERN, "SetPageTimeout2Connecting_ConnectExtern", NULL, NULL, sendDirectAcceptCall, "sendDirectAccept", Connecting_15a6f7f242b800000000000000008B2);
/*7*/	tTransition *Setting2Final_SettingFailed_15a6f7f242b800000000000000008AB = CreateEventTransition(SETTING_FAILED, "Setting2Final_SettingFailed", NULL, NULL, handleSettingFailedCall, "handleSettingFailed", CheckForRetry_162ae53492180000000000000000A49);
/*7*/	tTransition *StartConnect2Disconnected_Start_16194544c8a80000000000000000A46 = CreateEventTransition(START, "StartConnect2Disconnected_Start", NULL, NULL, NULL, NULL, Disconnected_15a6f7f242b8000000000000000086B);
/*7*/	tTransition *StartConnect2Final_Exit_15a6f7f242b80000000000000000870 = CreateEventTransition(EXIT, "StartConnect2Final_Exit", NULL, NULL, NULL, NULL, Final_15a6f7f242b8000000000000000086A);
/*7*/	tTransition *WaitForCharacterDevice2Final_CharacterDeviceAvailable_166267198ee80000000000000000A84 = CreateEventTransition(CHARACTER_DEVICE_AVAILABLE, "WaitForCharacterDevice2Final_CharacterDeviceAvailable", NULL, NULL, handleCharacterDeviceAvailableCall, "handleCharacterDeviceAvailable", Final_15a6f7f242b8000000000000000086A);
/*7*/	tTransition *WaitForCharacterDevice2Final_FinalState_1668756450e80000000000000000AA6 = CreateEventTransition(FINAL_STATE, "WaitForCharacterDevice2Final_FinalState", NULL, NULL, handleFinalStateDuringWaitForCharacterDeviceCall, "handleFinalStateDuringWaitForCharacterDevice", Final_15a6f7f242b8000000000000000086A);
/*7*/	tTransition *Waiting2Final_FinalState_15a6fbb5e4580000000000000000AD0 = CreateEventTransition(FINAL_STATE, "Waiting2Final_FinalState", NULL, NULL, handleConnectCompletedCall, "handleConnectCompleted", CheckForRetry_162ae53492180000000000000000A49);
/*7*/	tTransition *WaitingForProtocol2Final_WaitingForProtocolFailed_16036ac336880000000000000000A26 = CreateEventTransition(WAITING_FOR_PROTOCOL_FAILED, "WaitingForProtocol2Final_WaitingForProtocolFailed", NULL, NULL, handleWaitingForProtocolFailedCall, "handleWaitingForProtocolFailed", CheckForRetry_162ae53492180000000000000000A49);
/*7*/	tTransition *WaitingForService2Final_WaitingForServiceFailed_16036ac336880000000000000000A17 = CreateEventTransition(WAITING_FOR_SERVICE_FAILED, "WaitingForService2Final_WaitingForServiceFailed", NULL, NULL, handleWaitingForServiceFailedCall, "handleWaitingForServiceFailed", CheckForRetry_162ae53492180000000000000000A49);
/*9*/	tTransition *Connecting2ConditionConnectingCanceled_Busy_15a6f7f242b800000000000000008BB = CreateEventConditionalTransition(BUSY, "Connecting2ConditionConnectingCanceled_Busy", Main_15a6f7f242b80000000000000000868, NULL, NULL, isCanceledCall, "isCanceled", handleConnectingCanceledCall, "handleConnectingCanceledTrue", NULL, NULL, "trueConditionConnectingCanceled2Final_True", CheckForRetry_162ae53492180000000000000000A49, "falseConditionConnectingCanceled2Busy_False", Busy_15a6f7f242b800000000000000008B3);
/*9*/	tTransition *Setting2ConditionSettingCanceled_SettingSuccess_15a6f7f242b800000000000000008A7 = CreateEventConditionalTransition(SETTING_SUCCESS, "Setting2ConditionSettingCanceled_SettingSuccess", Main_15a6f7f242b80000000000000000868, NULL, NULL, isCanceledCall, "isCanceled", handleSettingCanceledCall, "handleSettingCanceledTrue", sendConnectCall, "sendConnectFalse", "trueConditionSettingCanceled2Final_True", CheckForRetry_162ae53492180000000000000000A49, "falseConditionSettingCanceled2Connecting_False", Connecting_15a6f7f242b800000000000000008B2);
/*9*/	tTransition *WaitingForProtocol2ConditionWaitForProtocolCanceled_WaitingForProtocolSuccess_16036ac336880000000000000000A2B = CreateEventConditionalTransition(WAITING_FOR_PROTOCOL_SUCCESS, "WaitingForProtocol2ConditionWaitForProtocolCanceled_WaitingForProtocolSuccess", Main_15a6f7f242b80000000000000000868, NULL, NULL, isCanceledCall, "isCanceled", handleWaitingForProtocolCanceledCall, "handleWaitingForProtocolCanceledTrue", checkSettingCall, "checkSettingFalse", "trueConditionWaitForProtocolCanceled2Final_True", CheckForRetry_162ae53492180000000000000000A49, "falseConditionWaitForProtocolCanceled2Setting_False", Setting_15a6f7f242b80000000000000000878);

	/* add transitions to states */
	AddTransition(StartConnect_16194544c8a80000000000000000A45, StartConnect2Final_Exit_15a6f7f242b80000000000000000870);
	AddTransition(Creating_15a6f7f242b80000000000000000876, Creating2ConditionCreateCanceled_CreateSuccess_15a6f7f242b80000000000000000882);
	AddTransition(Creating_15a6f7f242b80000000000000000876, Creating2Final_CreateFailed_15a6f7f242b8000000000000000088E);
	AddTransition(Searching_15a6f7f242b80000000000000000877, Searching2Final_SearchFailed_15a6f7f242b80000000000000000895);
	AddTransition(Searching_15a6f7f242b80000000000000000877, Searching2ConditionSearchCanceled_SearchSuccess_15a6f7f242b8000000000000000089C);
	AddTransition(Setting_15a6f7f242b80000000000000000878, Setting2ConditionSettingCanceled_SettingSuccess_15a6f7f242b800000000000000008A7);
	AddTransition(Setting_15a6f7f242b80000000000000000878, Setting2Final_SettingFailed_15a6f7f242b800000000000000008AB);
	AddTransition(Connecting_15a6f7f242b800000000000000008B2, Connecting2ConditionConnectingCanceled_Busy_15a6f7f242b800000000000000008BB);
	AddTransition(Busy_15a6f7f242b800000000000000008B3, Busy2Final_Cancel_15a6f7f242b800000000000000008C6);
	AddTransition(Busy_15a6f7f242b800000000000000008B3, Busy2Connecting_Connect_15a6fbb5e4580000000000000000ABF);
	AddTransition(Connecting_15a6f7f242b800000000000000008B2, Connecting2ConditionFinalState_ConnectResult_15a6fbb5e4580000000000000000AC5);
	AddTransition(Waiting_15a6fbb5e4580000000000000000AC3, Waiting2Final_FinalState_15a6fbb5e4580000000000000000AD0);
	AddTransition(Creating_15a6f7f242b80000000000000000876, Creating2Connecting_ConnectExtern_15a6fbb5e4580000000000000000ADF);
	AddTransition(Busy_15a6f7f242b800000000000000008B3, Busy2Connecting_ConnectExtern_15a6fbb5e4580000000000000000AE8);
	AddTransition(Disconnected_15a6f7f242b8000000000000000086B, Disconnected2Connecting_AcceptConnect_15a6fbb5e4580000000000000000AED);
	AddTransition(Disconnected_15a6f7f242b8000000000000000086B, Disconnected2Connecting_RejectConnect_15a6fbb5e4580000000000000000AF1);
	AddTransition(Disconnected_15a6f7f242b8000000000000000086B, Disconnected2ConditionFinalStateRemote_ConnectResult_15a6fbb5e4580000000000000000B06);
	AddTransition(Disconnected_15a6f7f242b8000000000000000086B, Disconnected2WaitingForService_Connect_16036a2b22080000000000000000A13);
	AddTransition(WaitingForService_16036a2b22080000000000000000A12, WaitingForService2Final_WaitingForServiceFailed_16036ac336880000000000000000A17);
	AddTransition(WaitingForService_16036a2b22080000000000000000A12, WaitingForService2ConditionWaitForServiceCanceled_WaitingForServiceSuccess_16036ac336880000000000000000A1B);
	AddTransition(WaitingForProtocol_16036ac336880000000000000000A24, WaitingForProtocol2Final_WaitingForProtocolFailed_16036ac336880000000000000000A26);
	AddTransition(WaitingForProtocol_16036ac336880000000000000000A24, WaitingForProtocol2ConditionWaitForProtocolCanceled_WaitingForProtocolSuccess_16036ac336880000000000000000A2B);
	AddTransition(StartConnect_16194544c8a80000000000000000A45, StartConnect2Disconnected_Start_16194544c8a80000000000000000A46);
	AddTransition(CheckForRetry_162ae53492180000000000000000A49, CheckForRetry2WaitForCharacterDevice_ExitNoRetry_162ae53492180000000000000000A4C);
	AddTransition(CheckForRetry_162ae53492180000000000000000A49, CheckForRetry2Connecting_RetryConnect_162ae53492180000000000000000A50);
	AddTransition(Canceled_162afe3e30c80000000000000000A54, Canceled2ConditionFinalStateDisconnected_CancelResult_162afe3e30c80000000000000000A5E);
	AddTransition(GuardPeriod_162afe3e30c80000000000000000A55, GuardPeriod2WaitForCharacterDevice_GuardPeriodExpired_162afe3e30c80000000000000000A6C);
	AddTransition(Connecting_15a6f7f242b800000000000000008B2, Connecting2Canceled_Cancel_162b3d038a480000000000000000A70);
	AddTransition(WaitForCharacterDevice_166267198ee80000000000000000A81, WaitForCharacterDevice2Final_CharacterDeviceAvailable_166267198ee80000000000000000A84);
	AddTransition(SetPageTimeout_1668756450e80000000000000000A8A, SetPageTimeout2ConditionSetPageTimeoutCanceled_SetPageTimeoutSuccess_1668756450e80000000000000000A8C);
	AddTransition(SetPageTimeout_1668756450e80000000000000000A8A, SetPageTimeout2Connecting_ConnectExtern_1668756450e80000000000000000A9B);
	AddTransition(WaitForCharacterDevice_166267198ee80000000000000000A81, WaitForCharacterDevice2Final_FinalState_1668756450e80000000000000000AA6);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_Cancel_P15a6f7f242b80000000000000000872);
	AddTransition(Searching_15a6f7f242b80000000000000000877, Searching2Searching_Cancel_P15a6f7f242b80000000000000000879);
	AddTransition(Connecting_15a6f7f242b800000000000000008B2, Connecting2Connecting_Cancel_P15a6f7f242b800000000000000008B7);
	AddTransition(Connecting_15a6f7f242b800000000000000008B2, Connecting2Connecting_FinalState_P15a6fbb5e4580000000000000000AD6);
	AddTransition(Waiting_15a6fbb5e4580000000000000000AC3, Waiting2Waiting_ConnectResult_P15a6fbb5e4580000000000000000ADA);
	AddTransition(Disconnected_15a6f7f242b8000000000000000086B, Disconnected2Disconnected_ConnectExtern_P15a6fbb5e4580000000000000000ADB);
	AddTransition(Connecting_15a6f7f242b800000000000000008B2, Connecting2Connecting_ConnectExtern_P15a6fbb5e4580000000000000000AE5);
	AddTransition(Connecting_15a6f7f242b800000000000000008B2, Connecting2Connecting_AcceptConnect_P15a6fbb5e4580000000000000000AF5);
	AddTransition(Connecting_15a6f7f242b800000000000000008B2, Connecting2Connecting_RejectConnect_P15a6fbb5e4580000000000000000AF6);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_CreateSuccess_P15a6fbb5e4580000000000000000AF7);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_CreateFailed_P15a6fbb5e4580000000000000000AF8);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_ConnectResult_P15a6fbb5e4580000000000000000AF9);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_FinalState_P15a6fbb5e4580000000000000000AFA);
	AddTransition(Disconnected_15a6f7f242b8000000000000000086B, Disconnected2Disconnected_Connecting_P15a6fbb5e4580000000000000000AFB);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_Connecting_P15a6fbb5e4580000000000000000AFF);
	AddTransition(Waiting_15a6fbb5e4580000000000000000AC3, Waiting2Waiting_ConnectExtern_P15a6fbb5e4580000000000000000B03);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_Canceled_P15a6fbb5e4580000000000000000B0F);
	AddTransition(Setting_15a6f7f242b80000000000000000878, Setting2Setting_ConnectExtern_P16036e11c3280000000000000000A35);
	AddTransition(Busy_15a6f7f242b800000000000000008B3, Busy2Busy_Cancel_P16179de72ce80000000000000000A3C);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_Accept_P16179de72ce80000000000000000A41);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_Reject_P16179de72ce80000000000000000A42);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_SearchSuccess_P1618fb8161580000000000000000A41);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_SearchFailed_P1618fb8161580000000000000000A42);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_Start_P16194544c8a80000000000000000A48);
	AddTransition(Canceled_162afe3e30c80000000000000000A54, Canceled2Canceled_ConnectExtern_P162afe3e30c80000000000000000A56);
	AddTransition(Canceled_162afe3e30c80000000000000000A54, Canceled2Canceled_FinalState_P162afe3e30c80000000000000000A57);
	AddTransition(Canceled_162afe3e30c80000000000000000A54, Canceled2Canceled_ConnectResult_P162afe3e30c80000000000000000A58);
	AddTransition(GuardPeriod_162afe3e30c80000000000000000A55, GuardPeriod2GuardPeriod_ConnectExtern_P162afe3e30c80000000000000000A64);
	AddTransition(GuardPeriod_162afe3e30c80000000000000000A55, GuardPeriod2GuardPeriod_FinalState_P162afe3e30c80000000000000000A65);
	AddTransition(GuardPeriod_162afe3e30c80000000000000000A55, GuardPeriod2GuardPeriod_ConnectResult_P162afe3e30c80000000000000000A6B);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_Disconnecting_P162b3d038a480000000000000000A73);
	AddTransition(Main_15a6f7f242b80000000000000000868, Main2Main_CharacterDeviceAvailable_P166267d486f80000000000000000A88);
	AddTransition(Searching_15a6f7f242b80000000000000000877, Searching2Searching_ConnectExtern_P1668756450e80000000000000000A9E);
	AddTransition(WaitingForProtocol_16036ac336880000000000000000A24, WaitingForProtocol2WaitingForProtocol_ConnectExtern_P1668756450e80000000000000000AA1);

	/* set start (compound) state for state machine */
	SetConcurrent(topProtocolConnect_15a6f7f242b80000000000000000867);
	return SetRoot(topProtocolConnect_15a6f7f242b80000000000000000867);
}
};
} // namespace btstackif
// end of generated code

#endif
