#ifndef _PAIRINGSM_H_
#define _PAIRINGSM_H_

/* generated code: do not edit */

#include "SMF.h"

#include "BmAllTypes.h"

namespace bmcore {

#define PAIRINGSM_NAME "PairingSm"

class PairingSm: public SMF {
public:
	PairingSm() :
	ACCEPT_PAIRING(0),
	AUTO_CONFIRM(0),
	CANCEL_PAIRING(0),
	CHECK_AUTO_CONFIRMATION(0),
	CONNECT_DEVICE_AS_CLASSIC_BT(0),
	CONNECT_DEVICE_AS_CPW(0),
	DB_DELETE_DEVICEPROTOCOLS_TRIGGER(0),
	DB_DELETE_DEVICES_TRIGGER(0),
	DB_INSERT_DEVICEPROTOCOLS_TRIGGER(0),
	DB_INSERT_DEVICES_TRIGGER(0),
	DB_UPDATE_DEVICES_TRIGGER(0),
	DEFAULT(0),
	DID_INFO_CHANGED(0),
	DISABLE_PAIRABLE(0),
	DISABLE_PAIRABLE_RESULT(0),
	DISCOVERY(0),
	DONE(0),
	ENABLE_PAIRABLE_RESULT(0),
	END_PAIRING_SESSION(0),
	INIT(0),
	KEEP_PAIRING_SESSION(0),
	NOT_PAIRABLE(0),
	PAIRING_ATTEMPT(0),
	PAIRING_CANCELED(0),
	PAIRING_CONFIRMATION_REQUESTED(0),
	PAIRING_FINISHED(0),
	PAIRING_REQUESTED(0),
	PAIRING_SUCCESSFUL(0),
	PAIR_DEVICE(0),
	REJECT_PAIRING(0),
	START_DISCOVERY(0),
	START_DISCOVERY_RESULT(0),
	START_PAIRING(0),
	START_REMOTE_PAIRING_SESSION(0),
	STOP_DISCOVERY(0),
	STOP_DISCOVERY_RESULT(0),
	STOP_SM(0),
	SUPPORTED_PROTOCOLS_CHANGED(0),
	SUPPORTED_SPP_UUID_CHANGED(0),
	TIMEOUT(0),
	USER_CONFIRMATION_NEEDED(0),
	dummy_do_not_use(0)
	{
		SetSMName(PAIRINGSM_NAME);
	}

	/* enums for states */
	enum PairingSm_states {
		topPairing,
		ConfirmationOngoing,
		WaitingForPairingResult,
		CheckingAutoConfirmation,
		Idle,
		Final,
		Stopped,
		CheckingForReservedDcc,
		RemotePairingSessionStarted,
		CheckPairedDeviceAndWaitforDIDInfo,
		PairingRequested,
		WaitingForUserConfirmation,
	};

	// generated virtual implementations of user callback functions
	virtual int cancelPairing() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int checkAndStartTimer() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int checkDccReservation() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int checkPairingIsSuccessful(const BdAddressChrArr _1, const PairingResult _2) { (void)_1; (void)_2; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int confirmPairing() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int connectDeviceAsCPW() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int connectDeviceAsClassicBT() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleDone() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleFinishedPairing(const BdAddressChrArr _1, const PairingResult _2) { (void)_1; (void)_2; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleNotPairable(const SwitchedOffReason _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handlePairingFinished() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleStopSm() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleTimeout() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int initSm() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int keepPairingSession() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int messageNotConsumed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int rejectPairing() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int saveAdditionalPairingInfo(const BdAddressChrArr _1, const DeviceNameChrArr _2, const PairingType _3, const SspPinCodeChrArr _4) { (void)_1; (void)_2; (void)_3; (void)_4; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int savePairingInfoLocal(const BdAddressChrArr _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int savePairingInfoRemote(const BdAddressChrArr _1, const DeviceNameChrArr _2, const PairingType _3, const SspPinCodeChrArr _4) { (void)_1; (void)_2; (void)_3; (void)_4; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int shallAutoConfirmPairingRequest() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int startPairing() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int startRemotePairingSession() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int stopPairingSession(const BdAddressChrArr _1, const PairingResult _2) { (void)_1; (void)_2; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int stopPairingSession(const PairingResult _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int stopTimerAndSendPairingResult() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int updateInfo(const DeviceId _1, const DeviceInfoUpdateType _2) { (void)_1; (void)_2; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	int ParameterDID_INFO_CHANGED(char *parameterString, const size_t size, const DeviceId _1, const DeviceInfoUpdateType _2)
	{
		return (Marshal(parameterString, size-1, DEVICEID_FORMAT DEVICEINFOUPDATETYPE_FORMAT , _1, _2) != 0 ? 0 : -1);
	}

	int ParameterEND_PAIRING_SESSION(char *parameterString, const size_t size, const BdAddressChrArr _1, const PairingResult _2)
	{
		return (Marshal(parameterString, size-1, BDADDRESSCHRARR_FORMAT PAIRINGRESULT_FORMAT , _1, _2) != 0 ? 0 : -1);
	}

	int ParameterNOT_PAIRABLE(char *parameterString, const size_t size, const SwitchedOffReason _1)
	{
		return (Marshal(parameterString, size-1, SWITCHEDOFFREASON_FORMAT , _1) != 0 ? 0 : -1);
	}

	int ParameterPAIRING_CANCELED(char *parameterString, const size_t size, const PairingResult _1)
	{
		return (Marshal(parameterString, size-1, PAIRINGRESULT_FORMAT , _1) != 0 ? 0 : -1);
	}

	int ParameterPAIRING_CONFIRMATION_REQUESTED(char *parameterString, const size_t size, const BdAddressChrArr _1, const DeviceNameChrArr _2, const PairingType _3, const SspPinCodeChrArr _4)
	{
		return (Marshal(parameterString, size-1, BDADDRESSCHRARR_FORMAT DEVICENAMECHRARR_FORMAT PAIRINGTYPE_FORMAT SSPPINCODECHRARR_FORMAT , _1, _2, _3, _4) != 0 ? 0 : -1);
	}

	int ParameterPAIRING_FINISHED(char *parameterString, const size_t size, const BdAddressChrArr _1, const PairingResult _2)
	{
		return (Marshal(parameterString, size-1, BDADDRESSCHRARR_FORMAT PAIRINGRESULT_FORMAT , _1, _2) != 0 ? 0 : -1);
	}

	int ParameterPAIRING_REQUESTED(char *parameterString, const size_t size, const BdAddressChrArr _1)
	{
		return (Marshal(parameterString, size-1, BDADDRESSCHRARR_FORMAT , _1) != 0 ? 0 : -1);
	}

	int ParameterSUPPORTED_PROTOCOLS_CHANGED(char *parameterString, const size_t size, const DeviceId _1, const DeviceInfoUpdateType _2)
	{
		return (Marshal(parameterString, size-1, DEVICEID_FORMAT DEVICEINFOUPDATETYPE_FORMAT , _1, _2) != 0 ? 0 : -1);
	}

	int ParameterSUPPORTED_SPP_UUID_CHANGED(char *parameterString, const size_t size, const DeviceId _1, const DeviceInfoUpdateType _2)
	{
		return (Marshal(parameterString, size-1, DEVICEID_FORMAT DEVICEINFOUPDATETYPE_FORMAT , _1, _2) != 0 ? 0 : -1);
	}


protected:

	// generates static call functions for all state machine user callbacks
	static int cancelPairingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->cancelPairing();
	}

	static int checkAndStartTimerCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((PairingSm *)(state->_this))->checkAndStartTimer();
	}

	static int checkDccReservationCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((PairingSm *)(state->_this))->checkDccReservation();
	}

	static int checkPairingIsSuccessfulCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BdAddressChrArr _1 = {0};
		PairingResult _2 = PAIRINGRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BDADDRESSCHRARR_FORMAT PAIRINGRESULT_FORMAT  ,_1 ,&_2 );
		}
		ret = ((PairingSm *)(trans->_this))->checkPairingIsSuccessful(_1, _2);
		return ret;
	}

	static int confirmPairingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->confirmPairing();
	}

	static int connectDeviceAsCPWCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->connectDeviceAsCPW();
	}

	static int connectDeviceAsClassicBTCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->connectDeviceAsClassicBT();
	}

	static int handleDoneCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->handleDone();
	}

	static int handleFinishedPairingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BdAddressChrArr _1 = BDADDRESSCHRARR_INIT;
		PairingResult _2 = PAIRINGRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BDADDRESSCHRARR_FORMAT PAIRINGRESULT_FORMAT  ,&_1 ,&_2 );
		}
		ret = ((PairingSm *)(trans->_this))->handleFinishedPairing(_1, _2);
		return ret;
	}

	static int handleNotPairableCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		SwitchedOffReason _1 = SWITCHEDOFFREASON_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, SWITCHEDOFFREASON_FORMAT  ,&_1 );
		}
		ret = ((PairingSm *)(trans->_this))->handleNotPairable(_1);
		return ret;
	}

	static int handlePairingFinishedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->handlePairingFinished();
	}

	static int handleStopSmCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->handleStopSm();
	}

	static int handleTimeoutCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->handleTimeout();
	}

	static int initSmCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->initSm();
	}

	static int keepPairingSessionCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->keepPairingSession();
	}

	static int messageNotConsumedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->messageNotConsumed();
	}

	static int rejectPairingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->rejectPairing();
	}

	static int saveAdditionalPairingInfoCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BdAddressChrArr _1 = {0};
		DeviceNameChrArr _2 = {0};
		PairingType _3 = PAIRINGTYPE_INIT;
		SspPinCodeChrArr _4 = {0};
		if (trans->arguments) {
			UnMarshal(trans->arguments, BDADDRESSCHRARR_FORMAT DEVICENAMECHRARR_FORMAT PAIRINGTYPE_FORMAT SSPPINCODECHRARR_FORMAT  ,_1 ,_2 ,&_3 ,_4 );
		}
		ret = ((PairingSm *)(trans->_this))->saveAdditionalPairingInfo(_1, _2, _3, _4);
		return ret;
	}

	static int savePairingInfoLocalCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BdAddressChrArr _1 = {0};
		if (trans->arguments) {
			UnMarshal(trans->arguments, BDADDRESSCHRARR_FORMAT  ,_1 );
		}
		ret = ((PairingSm *)(trans->_this))->savePairingInfoLocal(_1);
		return ret;
	}

	static int savePairingInfoRemoteCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BdAddressChrArr _1 = {0};
		DeviceNameChrArr _2 = {0};
		PairingType _3 = PAIRINGTYPE_INIT;
		SspPinCodeChrArr _4 = {0};
		if (trans->arguments) {
			UnMarshal(trans->arguments, BDADDRESSCHRARR_FORMAT DEVICENAMECHRARR_FORMAT PAIRINGTYPE_FORMAT SSPPINCODECHRARR_FORMAT  ,_1 ,_2 ,&_3 ,_4 );
		}
		ret = ((PairingSm *)(trans->_this))->savePairingInfoRemote(_1, _2, _3, _4);
		return ret;
	}

	static int shallAutoConfirmPairingRequestCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((PairingSm *)(state->_this))->shallAutoConfirmPairingRequest();
	}

	static int startPairingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->startPairing();
	}

	static int startRemotePairingSessionCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((PairingSm *)(trans->_this))->startRemotePairingSession();
	}

	static int stopPairingSessionCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		BdAddressChrArr _1 = {0};
		PairingResult _2 = PAIRINGRESULT_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, BDADDRESSCHRARR_FORMAT PAIRINGRESULT_FORMAT  ,_1 ,&_2 );
		}
		ret = ((PairingSm *)(trans->_this))->stopPairingSession(_1, _2);
		return ret;
	}

	static int stopTimerAndSendPairingResultCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((PairingSm *)(state->_this))->stopTimerAndSendPairingResult();
	}

	static int updateInfoCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		DeviceId _1 = DEVICEID_INIT;
		DeviceInfoUpdateType _2 = DEVICEINFOUPDATETYPE_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, DEVICEID_FORMAT DEVICEINFOUPDATETYPE_FORMAT  ,&_1 ,&_2 );
		}
		ret = ((PairingSm *)(trans->_this))->updateInfo(_1, _2);
		return ret;
	}


public:

	/* used external events */
	SMF::tEvent *ACCEPT_PAIRING;
	SMF::tEvent *AUTO_CONFIRM;
	SMF::tEvent *CANCEL_PAIRING;
	SMF::tEvent *CHECK_AUTO_CONFIRMATION;
	SMF::tEvent *CONNECT_DEVICE_AS_CLASSIC_BT;
	SMF::tEvent *CONNECT_DEVICE_AS_CPW;
	SMF::tEvent *DB_DELETE_DEVICEPROTOCOLS_TRIGGER;
	SMF::tEvent *DB_DELETE_DEVICES_TRIGGER;
	SMF::tEvent *DB_INSERT_DEVICEPROTOCOLS_TRIGGER;
	SMF::tEvent *DB_INSERT_DEVICES_TRIGGER;
	SMF::tEvent *DB_UPDATE_DEVICES_TRIGGER;
	SMF::tEvent *DEFAULT;
	SMF::tEvent *DID_INFO_CHANGED;
	SMF::tEvent *DISABLE_PAIRABLE;
	SMF::tEvent *DISABLE_PAIRABLE_RESULT;
	SMF::tEvent *DISCOVERY;
	SMF::tEvent *DONE;
	SMF::tEvent *ENABLE_PAIRABLE_RESULT;
	SMF::tEvent *END_PAIRING_SESSION;
	SMF::tEvent *INIT;
	SMF::tEvent *KEEP_PAIRING_SESSION;
	SMF::tEvent *NOT_PAIRABLE;
	SMF::tEvent *PAIRING_ATTEMPT;
	SMF::tEvent *PAIRING_CANCELED;
	SMF::tEvent *PAIRING_CONFIRMATION_REQUESTED;
	SMF::tEvent *PAIRING_FINISHED;
	SMF::tEvent *PAIRING_REQUESTED;
	SMF::tEvent *PAIRING_SUCCESSFUL;
	SMF::tEvent *PAIR_DEVICE;
	SMF::tEvent *REJECT_PAIRING;
	SMF::tEvent *START_DISCOVERY;
	SMF::tEvent *START_DISCOVERY_RESULT;
	SMF::tEvent *START_PAIRING;
	SMF::tEvent *START_REMOTE_PAIRING_SESSION;
	SMF::tEvent *STOP_DISCOVERY;
	SMF::tEvent *STOP_DISCOVERY_RESULT;
	SMF::tEvent *STOP_SM;
	SMF::tEvent *SUPPORTED_PROTOCOLS_CHANGED;
	SMF::tEvent *SUPPORTED_SPP_UUID_CHANGED;
	SMF::tEvent *TIMEOUT;
	SMF::tEvent *USER_CONFIRMATION_NEEDED;
	int dummy_do_not_use;


virtual void Create()
{
	if (_created) {
		/* SM was already created => return now */
		return;
	}

	_created = true;

	/* state machine definition */


	/* create new compound state */
	tState *topPairing_14b2fc270f080000000000000000867 = CreateCompoundState("topPairing", topPairing, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *ConfirmationOngoing_14b496f1987800000000000000009BA = CreateCompoundState("ConfirmationOngoing", ConfirmationOngoing, NULL, NULL, NULL, NULL);

	/* create states */
	tState *WaitingForPairingResult_14b2fc270f080000000000000000880 = CreateState("WaitingForPairingResult", WaitingForPairingResult, NULL, NULL, NULL, NULL);
	tState *CheckingAutoConfirmation_14e1ae79eb180000000000000000C4D = CreateState("CheckingAutoConfirmation", CheckingAutoConfirmation, shallAutoConfirmPairingRequestCall, "shallAutoConfirmPairingRequest", NULL, NULL);

	/* create new compound state */
	tState *Idle_14b58fed75680000000000000000A08 = CreateCompoundState("Idle", Idle, NULL, NULL, NULL, NULL);

	/* create final states */
	tState *Final_14b4a6f276a800000000000000009DE = CreateFinalState("Final", Final, NULL, NULL);
	AddState(Idle_14b58fed75680000000000000000A08, Final_14b4a6f276a800000000000000009DE);

	/* create states */
	tState *Stopped_14b4a6f276a800000000000000009DD = CreateState("Stopped", Stopped, NULL, NULL, NULL, NULL);
	tState *CheckingForReservedDcc_14e1ae79eb180000000000000000C1F = CreateState("CheckingForReservedDcc", CheckingForReservedDcc, checkDccReservationCall, "checkDccReservation", NULL, NULL);
	tState *RemotePairingSessionStarted_1523b15496e80000000000000000CAD = CreateState("RemotePairingSessionStarted", RemotePairingSessionStarted, NULL, NULL, NULL, NULL);
	tState *CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B = CreateState("CheckPairedDeviceAndWaitforDIDInfo", CheckPairedDeviceAndWaitforDIDInfo, checkAndStartTimerCall, "checkAndStartTimer", stopTimerAndSendPairingResultCall, "stopTimerAndSendPairingResult");

	/* create new compound state */
	tState *PairingRequested_14b58fed75680000000000000000A1D = CreateCompoundState("PairingRequested", PairingRequested, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *WaitingForUserConfirmation_14b6d759ad080000000000000000BDD = CreateCompoundState("WaitingForUserConfirmation", WaitingForUserConfirmation, NULL, NULL, NULL, NULL);

	/* create states */
	tTransition *Init_14b2fc270f080000000000000000869 = CreateTransition("Init", NULL, NULL, initSmCall, "initSm", Idle_14b58fed75680000000000000000A08);

	/* set the init transition */
	SetInitTransition(topPairing_14b2fc270f080000000000000000867, Init_14b2fc270f080000000000000000869);

	/* Add in states */
	AddState(topPairing_14b2fc270f080000000000000000867, Idle_14b58fed75680000000000000000A08);
	AddState(ConfirmationOngoing_14b496f1987800000000000000009BA, WaitingForUserConfirmation_14b6d759ad080000000000000000BDD);
	AddState(ConfirmationOngoing_14b496f1987800000000000000009BA, WaitingForPairingResult_14b2fc270f080000000000000000880);
	AddState(ConfirmationOngoing_14b496f1987800000000000000009BA, CheckingAutoConfirmation_14e1ae79eb180000000000000000C4D);
	AddState(Idle_14b58fed75680000000000000000A08, PairingRequested_14b58fed75680000000000000000A1D);
	AddState(Idle_14b58fed75680000000000000000A08, Stopped_14b4a6f276a800000000000000009DD);
	AddState(Idle_14b58fed75680000000000000000A08, CheckingForReservedDcc_14e1ae79eb180000000000000000C1F);
	AddState(Idle_14b58fed75680000000000000000A08, RemotePairingSessionStarted_1523b15496e80000000000000000CAD);
	AddState(Idle_14b58fed75680000000000000000A08, CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B);
	AddState(PairingRequested_14b58fed75680000000000000000A1D, ConfirmationOngoing_14b496f1987800000000000000009BA);

	/* create events */
	ACCEPT_PAIRING = CreateEvent("ACCEPT_PAIRING");
	AUTO_CONFIRM = CreateEvent("AUTO_CONFIRM");
	CANCEL_PAIRING = CreateEvent("CANCEL_PAIRING");
	CHECK_AUTO_CONFIRMATION = CreateEvent("CHECK_AUTO_CONFIRMATION");
	CONNECT_DEVICE_AS_CLASSIC_BT = CreateEvent("CONNECT_DEVICE_AS_CLASSIC_BT");
	CONNECT_DEVICE_AS_CPW = CreateEvent("CONNECT_DEVICE_AS_CPW");
	DB_DELETE_DEVICEPROTOCOLS_TRIGGER = CreateEvent("DB_DELETE_DEVICEPROTOCOLS_TRIGGER");
	DB_DELETE_DEVICES_TRIGGER = CreateEvent("DB_DELETE_DEVICES_TRIGGER");
	DB_INSERT_DEVICEPROTOCOLS_TRIGGER = CreateEvent("DB_INSERT_DEVICEPROTOCOLS_TRIGGER");
	DB_INSERT_DEVICES_TRIGGER = CreateEvent("DB_INSERT_DEVICES_TRIGGER");
	DB_UPDATE_DEVICES_TRIGGER = CreateEvent("DB_UPDATE_DEVICES_TRIGGER");
	DEFAULT = CreateEvent("DEFAULT");
	DID_INFO_CHANGED = CreateEvent("DID_INFO_CHANGED");
	DISABLE_PAIRABLE = CreateEvent("DISABLE_PAIRABLE");
	DISABLE_PAIRABLE_RESULT = CreateEvent("DISABLE_PAIRABLE_RESULT");
	DISCOVERY = CreateEvent("DISCOVERY");
	DONE = CreateEvent("DONE");
	ENABLE_PAIRABLE_RESULT = CreateEvent("ENABLE_PAIRABLE_RESULT");
	END_PAIRING_SESSION = CreateEvent("END_PAIRING_SESSION");
	INIT = CreateEvent("INIT");
	KEEP_PAIRING_SESSION = CreateEvent("KEEP_PAIRING_SESSION");
	NOT_PAIRABLE = CreateEvent("NOT_PAIRABLE");
	PAIRING_ATTEMPT = CreateEvent("PAIRING_ATTEMPT");
	PAIRING_CANCELED = CreateEvent("PAIRING_CANCELED");
	PAIRING_CONFIRMATION_REQUESTED = CreateEvent("PAIRING_CONFIRMATION_REQUESTED");
	PAIRING_FINISHED = CreateEvent("PAIRING_FINISHED");
	PAIRING_REQUESTED = CreateEvent("PAIRING_REQUESTED");
	PAIRING_SUCCESSFUL = CreateEvent("PAIRING_SUCCESSFUL");
	PAIR_DEVICE = CreateEvent("PAIR_DEVICE");
	REJECT_PAIRING = CreateEvent("REJECT_PAIRING");
	START_DISCOVERY = CreateEvent("START_DISCOVERY");
	START_DISCOVERY_RESULT = CreateEvent("START_DISCOVERY_RESULT");
	START_PAIRING = CreateEvent("START_PAIRING");
	START_REMOTE_PAIRING_SESSION = CreateEvent("START_REMOTE_PAIRING_SESSION");
	STOP_DISCOVERY = CreateEvent("STOP_DISCOVERY");
	STOP_DISCOVERY_RESULT = CreateEvent("STOP_DISCOVERY_RESULT");
	STOP_SM = CreateEvent("STOP_SM");
	SUPPORTED_PROTOCOLS_CHANGED = CreateEvent("SUPPORTED_PROTOCOLS_CHANGED");
	SUPPORTED_SPP_UUID_CHANGED = CreateEvent("SUPPORTED_SPP_UUID_CHANGED");
	TIMEOUT = CreateEvent("TIMEOUT");
	USER_CONFIRMATION_NEEDED = CreateEvent("USER_CONFIRMATION_NEEDED");

	/* create event transitions */

	/* create internal transactions */
/*2*/	tTransition *CheckPairedDeviceAndWaitforDIDInfo2CheckPairedDeviceAndWaitforDIDInfo_DID_INFO_CHANGED_P15de1b53b0480000000000000000A67 = CreateEventTransition(DID_INFO_CHANGED, "CHECKPAIREDDEVICEANDWAITFORDIDINFO2CHECKPAIREDDEVICEANDWAITFORDIDINFO_DID_INFO_CHANGED", NULL, NULL,  updateInfoCall,  "updateInfo", NULL);
/*2*/	tTransition *CheckPairedDeviceAndWaitforDIDInfo2CheckPairedDeviceAndWaitforDIDInfo_SupportedProtocolsChanged_P15de1b53b0480000000000000000A5E = CreateEventTransition(SUPPORTED_PROTOCOLS_CHANGED, "CHECKPAIREDDEVICEANDWAITFORDIDINFO2CHECKPAIREDDEVICEANDWAITFORDIDINFO_SUPPORTEDPROTOCOLSCHANGED", NULL, NULL,  updateInfoCall,  "updateInfo", NULL);
/*2*/	tTransition *CheckPairedDeviceAndWaitforDIDInfo2CheckPairedDeviceAndWaitforDIDInfo_Timeout_P15ffbd133d780000000000000000A76 = CreateEventTransition(TIMEOUT, "CHECKPAIREDDEVICEANDWAITFORDIDINFO2CHECKPAIREDDEVICEANDWAITFORDIDINFO_TIMEOUT", NULL, NULL,  handleTimeoutCall,  "handleTimeout", NULL);
/*2*/	tTransition *CheckPairedDeviceAndWaitforDIDInfo2CheckPairedDeviceAndWaitforDIDInfo_supportedsppuuidchanged_P15de1b53b0480000000000000000A5C = CreateEventTransition(SUPPORTED_SPP_UUID_CHANGED, "CHECKPAIREDDEVICEANDWAITFORDIDINFO2CHECKPAIREDDEVICEANDWAITFORDIDINFO_SUPPORTEDSPPUUIDCHANGED", NULL, NULL,  updateInfoCall,  "updateInfo", NULL);
/*2*/	tTransition *CheckingForReservedDcc2CheckingForReservedDcc_CancelPairing_P14e2612013e80000000000000000BD3 = CreateEventTransition(CANCEL_PAIRING, "CHECKINGFORRESERVEDDCC2CHECKINGFORRESERVEDDCC_CANCELPAIRING", NULL, NULL,  cancelPairingCall,  "cancelPairing", NULL);
/*2*/	tTransition *CheckingForReservedDcc2CheckingForReservedDcc_NotPairable_P14e2612013e80000000000000000BDA = CreateEventTransition(NOT_PAIRABLE, "CHECKINGFORRESERVEDDCC2CHECKINGFORRESERVEDDCC_NOTPAIRABLE", NULL, NULL,  handleNotPairableCall,  "handleNotPairable", NULL);
/*2*/	tTransition *Idle2Idle_Default_P153f55a3e7680000000000000000A30 = CreateEventTransition(DEFAULT, "IDLE2IDLE_DEFAULT", NULL, NULL,  messageNotConsumedCall,  "messageNotConsumed", NULL);
/*2*/	tTransition *PairingRequested2PairingRequested_CancelPairing_P14e1ae79eb180000000000000000CA5 = CreateEventTransition(CANCEL_PAIRING, "PAIRINGREQUESTED2PAIRINGREQUESTED_CANCELPAIRING", NULL, NULL,  cancelPairingCall,  "cancelPairing", NULL);
/*2*/	tTransition *PairingRequested2PairingRequested_FinalizePairing_P153f0eafe5080000000000000000A25 = CreateEventTransition(PAIRING_FINISHED, "PAIRINGREQUESTED2PAIRINGREQUESTED_FINALIZEPAIRING", NULL, NULL,  handleFinishedPairingCall,  "handleFinishedPairing", NULL);
/*2*/	tTransition *PairingRequested2PairingRequested_PairingConfirmationRequested_P14e1bf21f7180000000000000000BD9 = CreateEventTransition(PAIRING_CONFIRMATION_REQUESTED, "PAIRINGREQUESTED2PAIRINGREQUESTED_PAIRINGCONFIRMATIONREQUESTED", NULL, NULL,  saveAdditionalPairingInfoCall,  "saveAdditionalPairingInfo", NULL);
/*2*/	tTransition *RemotePairingSessionStarted2RemotePairingSessionStarted_NotPairable_P1523b15496e80000000000000000CBD = CreateEventTransition(NOT_PAIRABLE, "REMOTEPAIRINGSESSIONSTARTED2REMOTEPAIRINGSESSIONSTARTED_NOTPAIRABLE", NULL, NULL,  handleNotPairableCall,  "handleNotPairable", NULL);
/*2*/	tTransition *RemotePairingSessionStarted2RemotePairingSessionStarted_RejectPairing_P1523b15496e80000000000000000CD9 = CreateEventTransition(REJECT_PAIRING, "REMOTEPAIRINGSESSIONSTARTED2REMOTEPAIRINGSESSIONSTARTED_REJECTPAIRING", NULL, NULL,  rejectPairingCall,  "rejectPairing", NULL);
/*2*/	tTransition *WaitingForPairingResult2WaitingForPairingResult_RejectPairing_P162f1dea88c80000000000000000A75 = CreateEventTransition(REJECT_PAIRING, "WAITINGFORPAIRINGRESULT2WAITINGFORPAIRINGRESULT_REJECTPAIRING", NULL, NULL,  rejectPairingCall,  "rejectPairing", NULL);
/*2*/	tTransition *WaitingForUserConfirmation2WaitingForUserConfirmation_NotPairable_P14ba273792b80000000000000000C05 = CreateEventTransition(NOT_PAIRABLE, "WAITINGFORUSERCONFIRMATION2WAITINGFORUSERCONFIRMATION_NOTPAIRABLE", NULL, NULL,  handleNotPairableCall,  "handleNotPairable", NULL);

	/* create event transitions */
/*7*/	tTransition *CheckPairedDeviceAndWaitforDIDInfo2Idle_ConnectDeviceAsCPW_15de129793080000000000000000A58 = CreateEventTransition(CONNECT_DEVICE_AS_CPW, "CheckPairedDeviceAndWaitforDIDInfo2Idle_ConnectDeviceAsCPW", NULL, NULL, connectDeviceAsCPWCall, "connectDeviceAsCPW", Idle_14b58fed75680000000000000000A08);
/*7*/	tTransition *CheckPairedDeviceAndWaitforDIDInfo2Idle_ConnectDeviceAsClassicBT_15de129793080000000000000000A4E = CreateEventTransition(CONNECT_DEVICE_AS_CLASSIC_BT, "CheckPairedDeviceAndWaitforDIDInfo2Idle_ConnectDeviceAsClassicBT", NULL, NULL, connectDeviceAsClassicBTCall, "connectDeviceAsClassicBT", Idle_14b58fed75680000000000000000A08);
/*7*/	tTransition *CheckPairedDeviceAndWaitforDIDInfo2Idle_RejectPairing_15de612bb3e80000000000000000A6F = CreateEventTransition(REJECT_PAIRING, "CheckPairedDeviceAndWaitforDIDInfo2Idle_RejectPairing", NULL, NULL, handlePairingFinishedCall, "handlePairingFinished", Idle_14b58fed75680000000000000000A08);
/*7*/	tTransition *CheckingAutoConfirmation2WaitingForPairingResult_AutoConfirm_14e1ae79eb180000000000000000C4E = CreateEventTransition(AUTO_CONFIRM, "CheckingAutoConfirmation2WaitingForPairingResult_AutoConfirm", NULL, NULL, confirmPairingCall, "confirmPairing", WaitingForPairingResult_14b2fc270f080000000000000000880);
/*7*/	tTransition *CheckingAutoConfirmation2WaitingForUserConfirmation_UserConfirmationNeeded_14e1ae79eb180000000000000000C56 = CreateEventTransition(USER_CONFIRMATION_NEEDED, "CheckingAutoConfirmation2WaitingForUserConfirmation_UserConfirmationNeeded", NULL, NULL, NULL, NULL, WaitingForUserConfirmation_14b6d759ad080000000000000000BDD);
/*7*/	tTransition *CheckingForReservedDcc2CheckingAutoConfirmation_CheckAutoConfirmation_14e1ae79eb180000000000000000C5A = CreateEventTransition(CHECK_AUTO_CONFIRMATION, "CheckingForReservedDcc2CheckingAutoConfirmation_CheckAutoConfirmation", NULL, NULL, NULL, NULL, CheckingAutoConfirmation_14e1ae79eb180000000000000000C4D);
/*7*/	tTransition *CheckingForReservedDcc2Idle_PairingCancelled_14e2f75fc3b80000000000000000BBC = CreateEventTransition(PAIRING_CANCELED, "CheckingForReservedDcc2Idle_PairingCancelled", NULL, NULL, stopPairingSessionCall, "stopPairingSession", Idle_14b58fed75680000000000000000A08);
/*7*/	tTransition *CheckingForReservedDcc2Idle_PairingFinished_14e1ae79eb180000000000000000C2F = CreateEventTransition(PAIRING_FINISHED, "CheckingForReservedDcc2Idle_PairingFinished", NULL, NULL, stopPairingSessionCall, "stopPairingSession", Idle_14b58fed75680000000000000000A08);
/*7*/	tTransition *CheckingForReservedDcc2PairingRequested_StartPairing_14e1ae79eb180000000000000000C37 = CreateEventTransition(START_PAIRING, "CheckingForReservedDcc2PairingRequested_StartPairing", NULL, NULL, startPairingCall, "startPairing", PairingRequested_14b58fed75680000000000000000A1D);
/*7*/	tTransition *Idle2CheckingForReservedDcc_PairingConfirmationRequested_14e1ae79eb180000000000000000C41 = CreateEventTransition(PAIRING_CONFIRMATION_REQUESTED, "Idle2CheckingForReservedDcc_PairingConfirmationRequested", NULL, NULL, savePairingInfoRemoteCall, "savePairingInfoRemote", CheckingForReservedDcc_14e1ae79eb180000000000000000C1F);
/*7*/	tTransition *Idle2CheckingForReservedDcc_PairingRequestLocal_14e1ae79eb180000000000000000C22 = CreateEventTransition(PAIRING_REQUESTED, "Idle2CheckingForReservedDcc_PairingRequestLocal", NULL, NULL, savePairingInfoLocalCall, "savePairingInfoLocal", CheckingForReservedDcc_14e1ae79eb180000000000000000C1F);
/*7*/	tTransition *Idle2Final_14c9971be1e80000000000000000C1C = CreateEventTransition(DONE, "Idle2Final", NULL, NULL, handleDoneCall, "handleDone", Final_14b4a6f276a800000000000000009DE);
/*7*/	tTransition *Idle2RemotePairingSessionStarted_StartRemotePairingSession_1523b15496e80000000000000000CAE = CreateEventTransition(START_REMOTE_PAIRING_SESSION, "Idle2RemotePairingSessionStarted_StartRemotePairingSession", NULL, NULL, startRemotePairingSessionCall, "startRemotePairingSession", RemotePairingSessionStarted_1523b15496e80000000000000000CAD);
/*7*/	tTransition *Idle2Stopped_14c9dc7b45680000000000000000C19 = CreateEventTransition(STOP_SM, "Idle2Stopped", NULL, NULL, handleStopSmCall, "handleStopSm", Stopped_14b4a6f276a800000000000000009DD);
/*7*/	tTransition *PairingRequested2CheckingAutoConfirmation_CheckAutoConfirmation_14e1ae79eb180000000000000000C55 = CreateEventTransition(CHECK_AUTO_CONFIRMATION, "PairingRequested2CheckingAutoConfirmation_CheckAutoConfirmation", NULL, NULL, NULL, NULL, CheckingAutoConfirmation_14e1ae79eb180000000000000000C4D);
/*7*/	tTransition *PairingRequested2Idle_PairingAttempt_153f0eafe5080000000000000000A2A = CreateEventTransition(KEEP_PAIRING_SESSION, "PairingRequested2Idle_PairingAttempt", NULL, NULL, keepPairingSessionCall, "keepPairingSession", RemotePairingSessionStarted_1523b15496e80000000000000000CAD);
/*7*/	tTransition *RemotePairingSessionStarted2CheckingForReservedDcc_1523b15496e80000000000000000CB0 = CreateEventTransition(PAIRING_CONFIRMATION_REQUESTED, "RemotePairingSessionStarted2CheckingForReservedDcc", NULL, NULL, savePairingInfoRemoteCall, "savePairingInfoRemote", CheckingForReservedDcc_14e1ae79eb180000000000000000C1F);
/*7*/	tTransition *RemotePairingSessionStarted2CheckingForReservedDcc_PairingRequested_15d12bf10fd80000000000000000A39 = CreateEventTransition(PAIRING_REQUESTED, "RemotePairingSessionStarted2CheckingForReservedDcc_PairingRequested", NULL, NULL, savePairingInfoLocalCall, "savePairingInfoLocal", CheckingForReservedDcc_14e1ae79eb180000000000000000C1F);
/*7*/	tTransition *RemotePairingSessionStarted2Idle_PairingFinished_1523b15496e80000000000000000CC1 = CreateEventTransition(PAIRING_FINISHED, "RemotePairingSessionStarted2Idle_PairingFinished", NULL, NULL, stopPairingSessionCall, "stopPairingSession", Idle_14b58fed75680000000000000000A08);
/*7*/	tTransition *WaitingForUserConfirmation2WaitingForPairingResult_AcceptPairing_14b2fc270f08000000000000000088D = CreateEventTransition(ACCEPT_PAIRING, "WaitingForUserConfirmation2WaitingForPairingResult_AcceptPairing", NULL, NULL, confirmPairingCall, "confirmPairing", WaitingForPairingResult_14b2fc270f080000000000000000880);
/*7*/	tTransition *WaitingForUserConfirmation2WaitingForPairingResult_RejectPairing_14b2fc270f080000000000000000894 = CreateEventTransition(REJECT_PAIRING, "WaitingForUserConfirmation2WaitingForPairingResult_RejectPairing", NULL, NULL, rejectPairingCall, "rejectPairing", WaitingForPairingResult_14b2fc270f080000000000000000880);
/*9*/	tTransition *PairingRequested2Idle_PairingFinished_14ba273792b80000000000000000C26 = CreateEventConditionalTransition(END_PAIRING_SESSION, "PairingRequested2Idle_PairingFinished", Idle_14b58fed75680000000000000000A08, NULL, NULL, checkPairingIsSuccessfulCall, "checkPairingIsSuccessful", NULL, NULL, stopPairingSessionCall, "stopPairingSessionFalse", "trueCond12CheckAndWaitforDIDInfo_True", CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B, "falseCond12Idle_False", Idle_14b58fed75680000000000000000A08);

	/* add transitions to states */
	AddTransition(WaitingForUserConfirmation_14b6d759ad080000000000000000BDD, WaitingForUserConfirmation2WaitingForPairingResult_AcceptPairing_14b2fc270f08000000000000000088D);
	AddTransition(WaitingForUserConfirmation_14b6d759ad080000000000000000BDD, WaitingForUserConfirmation2WaitingForPairingResult_RejectPairing_14b2fc270f080000000000000000894);
	AddTransition(PairingRequested_14b58fed75680000000000000000A1D, PairingRequested2Idle_PairingFinished_14ba273792b80000000000000000C26);
	AddTransition(Idle_14b58fed75680000000000000000A08, Idle2Final_14c9971be1e80000000000000000C1C);
	AddTransition(Idle_14b58fed75680000000000000000A08, Idle2Stopped_14c9dc7b45680000000000000000C19);
	AddTransition(Idle_14b58fed75680000000000000000A08, Idle2CheckingForReservedDcc_PairingRequestLocal_14e1ae79eb180000000000000000C22);
	AddTransition(CheckingForReservedDcc_14e1ae79eb180000000000000000C1F, CheckingForReservedDcc2Idle_PairingFinished_14e1ae79eb180000000000000000C2F);
	AddTransition(CheckingForReservedDcc_14e1ae79eb180000000000000000C1F, CheckingForReservedDcc2PairingRequested_StartPairing_14e1ae79eb180000000000000000C37);
	AddTransition(Idle_14b58fed75680000000000000000A08, Idle2CheckingForReservedDcc_PairingConfirmationRequested_14e1ae79eb180000000000000000C41);
	AddTransition(CheckingAutoConfirmation_14e1ae79eb180000000000000000C4D, CheckingAutoConfirmation2WaitingForPairingResult_AutoConfirm_14e1ae79eb180000000000000000C4E);
	AddTransition(PairingRequested_14b58fed75680000000000000000A1D, PairingRequested2CheckingAutoConfirmation_CheckAutoConfirmation_14e1ae79eb180000000000000000C55);
	AddTransition(CheckingAutoConfirmation_14e1ae79eb180000000000000000C4D, CheckingAutoConfirmation2WaitingForUserConfirmation_UserConfirmationNeeded_14e1ae79eb180000000000000000C56);
	AddTransition(CheckingForReservedDcc_14e1ae79eb180000000000000000C1F, CheckingForReservedDcc2CheckingAutoConfirmation_CheckAutoConfirmation_14e1ae79eb180000000000000000C5A);
	AddTransition(CheckingForReservedDcc_14e1ae79eb180000000000000000C1F, CheckingForReservedDcc2Idle_PairingCancelled_14e2f75fc3b80000000000000000BBC);
	AddTransition(Idle_14b58fed75680000000000000000A08, Idle2RemotePairingSessionStarted_StartRemotePairingSession_1523b15496e80000000000000000CAE);
	AddTransition(RemotePairingSessionStarted_1523b15496e80000000000000000CAD, RemotePairingSessionStarted2CheckingForReservedDcc_1523b15496e80000000000000000CB0);
	AddTransition(RemotePairingSessionStarted_1523b15496e80000000000000000CAD, RemotePairingSessionStarted2Idle_PairingFinished_1523b15496e80000000000000000CC1);
	AddTransition(PairingRequested_14b58fed75680000000000000000A1D, PairingRequested2Idle_PairingAttempt_153f0eafe5080000000000000000A2A);
	AddTransition(RemotePairingSessionStarted_1523b15496e80000000000000000CAD, RemotePairingSessionStarted2CheckingForReservedDcc_PairingRequested_15d12bf10fd80000000000000000A39);
	AddTransition(CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B, CheckPairedDeviceAndWaitforDIDInfo2Idle_ConnectDeviceAsClassicBT_15de129793080000000000000000A4E);
	AddTransition(CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B, CheckPairedDeviceAndWaitforDIDInfo2Idle_ConnectDeviceAsCPW_15de129793080000000000000000A58);
	AddTransition(CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B, CheckPairedDeviceAndWaitforDIDInfo2Idle_RejectPairing_15de612bb3e80000000000000000A6F);
	AddTransition(WaitingForUserConfirmation_14b6d759ad080000000000000000BDD, WaitingForUserConfirmation2WaitingForUserConfirmation_NotPairable_P14ba273792b80000000000000000C05);
	AddTransition(PairingRequested_14b58fed75680000000000000000A1D, PairingRequested2PairingRequested_CancelPairing_P14e1ae79eb180000000000000000CA5);
	AddTransition(PairingRequested_14b58fed75680000000000000000A1D, PairingRequested2PairingRequested_PairingConfirmationRequested_P14e1bf21f7180000000000000000BD9);
	AddTransition(CheckingForReservedDcc_14e1ae79eb180000000000000000C1F, CheckingForReservedDcc2CheckingForReservedDcc_CancelPairing_P14e2612013e80000000000000000BD3);
	AddTransition(CheckingForReservedDcc_14e1ae79eb180000000000000000C1F, CheckingForReservedDcc2CheckingForReservedDcc_NotPairable_P14e2612013e80000000000000000BDA);
	AddTransition(RemotePairingSessionStarted_1523b15496e80000000000000000CAD, RemotePairingSessionStarted2RemotePairingSessionStarted_NotPairable_P1523b15496e80000000000000000CBD);
	AddTransition(RemotePairingSessionStarted_1523b15496e80000000000000000CAD, RemotePairingSessionStarted2RemotePairingSessionStarted_RejectPairing_P1523b15496e80000000000000000CD9);
	AddTransition(PairingRequested_14b58fed75680000000000000000A1D, PairingRequested2PairingRequested_FinalizePairing_P153f0eafe5080000000000000000A25);
	AddTransition(Idle_14b58fed75680000000000000000A08, Idle2Idle_Default_P153f55a3e7680000000000000000A30);
	AddTransition(CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B, CheckPairedDeviceAndWaitforDIDInfo2CheckPairedDeviceAndWaitforDIDInfo_supportedsppuuidchanged_P15de1b53b0480000000000000000A5C);
	AddTransition(CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B, CheckPairedDeviceAndWaitforDIDInfo2CheckPairedDeviceAndWaitforDIDInfo_SupportedProtocolsChanged_P15de1b53b0480000000000000000A5E);
	AddTransition(CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B, CheckPairedDeviceAndWaitforDIDInfo2CheckPairedDeviceAndWaitforDIDInfo_DID_INFO_CHANGED_P15de1b53b0480000000000000000A67);
	AddTransition(CheckPairedDeviceAndWaitforDIDInfo_15de05d368880000000000000000A4B, CheckPairedDeviceAndWaitforDIDInfo2CheckPairedDeviceAndWaitforDIDInfo_Timeout_P15ffbd133d780000000000000000A76);
	AddTransition(WaitingForPairingResult_14b2fc270f080000000000000000880, WaitingForPairingResult2WaitingForPairingResult_RejectPairing_P162f1dea88c80000000000000000A75);

	/* set start (compound) state for state machine */
	SetConcurrent(topPairing_14b2fc270f080000000000000000867);
	return SetRoot(topPairing_14b2fc270f080000000000000000867);
}
};
} // namespace bmcore
// end of generated code

#endif
