#ifndef _BMCONTROLLERONOFFSM_H_
#define _BMCONTROLLERONOFFSM_H_

/* generated code: do not edit */

#include "SMF.h"

#include "BmAllTypes.h"

namespace bmcore {

#define BMCONTROLLERONOFFSM_NAME "BmControllerOnOffSm"

class BmControllerOnOffSm: public SMF {
public:
	BmControllerOnOffSm() :
	ALL_CONN_CTRL_STOPPED(0),
	ALL_CONN_CTRL_TERMINATED(0),
	ALL_DEVICES_DISCONNECTED(0),
	BTSTACKIF_INITIALIZATION_ERROR(0),
	BTSTACKIF_INITIALIZED(0),
	BT_SWITCHED_OFF(0),
	BT_SWITCHED_ON(0),
	CLEAR_AUTO_CONNECTION_BOOKING(0),
	CONN_CTRL_STOPPED(0),
	CONN_CTRL_TERMINATED(0),
	DEFAULT(0),
	DEVICE_DISCOVERY_STOPPED(0),
	DISCONNECT_ALL_DEVICES(0),
	DONE(0),
	INIT(0),
	PROPERTIES_INITIALIZED(0),
	RESTORE_BT_STATUS(0),
	RUN(0),
	START_AUTO_CONNECTION(0),
	STOP(0),
	STOP_AUTO_CONNECTION(0),
	SWITCH_BT_OFF(0),
	dummy_do_not_use(0)
	{
		SetSMName(BMCONTROLLERONOFFSM_NAME);
	}

	/* enums for states */
	enum BmControllerOnOffSm_states {
		topBmControllerOnOff,
		BmControllerOnOff,
		Final,
		StoppingConnectionControllers,
		InitializingBtStackIf,
		InitializingProperties,
		BmControllerStopped,
		TerminatingConnectionControllers,
		BmControllerActive,
		BtSwitchedOff,
		SwitchingBtOff,
		SwitchingBtOffOnStop,
		BmControllerInactive,
		BtSwitchedOn,
		CheckingForConnectedDevices,
		DisconnectingDevicesOnDisconnectAllDevices,
		DisconnectingDevicesOnSwitchBtOff,
		DisconnectingDevicesOnStop,
		CheckDeviceDiscoveryStatus,
		CheckingDeviceDiscoveryStatus,
	};

	// generated virtual implementations of user callback functions
	virtual int StopDeviceDiscovery() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int areAllConnCtrlStopped() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int areAllConnCtrlTerminated() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int clearAutoConnectionBooking() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int disconnectAllDevices() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleBmControllerActive() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleBmControllerStopped() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int handleBmControllerTerminated() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int initializeBtStackIf() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int initializeProperties() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int initiateSwitchingBtOff() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int isFirstStartUp() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int messageNotConsumed() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int restoreBtStatus() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int startAutoConnection(const AutoConnectionStartMode _1) { (void)_1; NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int startAutoConnectionAttempt() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int stopAllConnectionControllers() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int stopAutoConnection() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int switchBtOff() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	virtual int terminateAllConnectionControllers() { NotImplemented(__PRETTY_FUNCTION__); return 0; }
	int ParameterSTART_AUTO_CONNECTION(char *parameterString, const size_t size, const AutoConnectionStartMode _1)
	{
		return (Marshal(parameterString, size-1, AUTOCONNECTIONSTARTMODE_FORMAT , _1) != 0 ? 0 : -1);
	}


protected:

	// generates static call functions for all state machine user callbacks
	static int StopDeviceDiscoveryCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->StopDeviceDiscovery();
	}

	static int areAllConnCtrlStoppedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((BmControllerOnOffSm *)(trans->_this))->areAllConnCtrlStopped();
	}

	static int areAllConnCtrlTerminatedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((BmControllerOnOffSm *)(trans->_this))->areAllConnCtrlTerminated();
	}

	static int clearAutoConnectionBookingCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((BmControllerOnOffSm *)(trans->_this))->clearAutoConnectionBooking();
	}

	static int disconnectAllDevicesCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->disconnectAllDevices();
	}

	static int handleBmControllerActiveCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->handleBmControllerActive();
	}

	static int handleBmControllerStoppedCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->handleBmControllerStopped();
	}

	static int handleBmControllerTerminatedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((BmControllerOnOffSm *)(trans->_this))->handleBmControllerTerminated();
	}

	static int initializeBtStackIfCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->initializeBtStackIf();
	}

	static int initializePropertiesCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->initializeProperties();
	}

	static int initiateSwitchingBtOffCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->initiateSwitchingBtOff();
	}

	static int isFirstStartUpCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((BmControllerOnOffSm *)(trans->_this))->isFirstStartUp();
	}

	static int messageNotConsumedCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((BmControllerOnOffSm *)(trans->_this))->messageNotConsumed();
	}

	static int restoreBtStatusCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((BmControllerOnOffSm *)(trans->_this))->restoreBtStatus();
	}

	static int startAutoConnectionAttemptCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((BmControllerOnOffSm *)(trans->_this))->startAutoConnectionAttempt();
	}

	static int startAutoConnectionCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		int ret;
		AutoConnectionStartMode _1 = AUTOCONNECTIONSTARTMODE_INIT;
		if (trans->arguments) {
			UnMarshal(trans->arguments, AUTOCONNECTIONSTARTMODE_FORMAT  ,&_1 );
		}
		ret = ((BmControllerOnOffSm *)(trans->_this))->startAutoConnection(_1);
		return ret;
	}

	static int stopAllConnectionControllersCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->stopAllConnectionControllers();
	}

	static int stopAutoConnectionCall(void *_trans)	{
		tTransition *trans = (tTransition *)_trans;
		return ((BmControllerOnOffSm *)(trans->_this))->stopAutoConnection();
	}

	static int switchBtOffCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->switchBtOff();
	}

	static int terminateAllConnectionControllersCall(void *_state)
	{
		tState *state = (tState *)_state;
		return ((BmControllerOnOffSm *)(state->_this))->terminateAllConnectionControllers();
	}


public:

	/* used external events */
	SMF::tEvent *ALL_CONN_CTRL_STOPPED;
	SMF::tEvent *ALL_CONN_CTRL_TERMINATED;
	SMF::tEvent *ALL_DEVICES_DISCONNECTED;
	SMF::tEvent *BTSTACKIF_INITIALIZATION_ERROR;
	SMF::tEvent *BTSTACKIF_INITIALIZED;
	SMF::tEvent *BT_SWITCHED_OFF;
	SMF::tEvent *BT_SWITCHED_ON;
	SMF::tEvent *CLEAR_AUTO_CONNECTION_BOOKING;
	SMF::tEvent *CONN_CTRL_STOPPED;
	SMF::tEvent *CONN_CTRL_TERMINATED;
	SMF::tEvent *DEFAULT;
	SMF::tEvent *DEVICE_DISCOVERY_STOPPED;
	SMF::tEvent *DISCONNECT_ALL_DEVICES;
	SMF::tEvent *DONE;
	SMF::tEvent *INIT;
	SMF::tEvent *PROPERTIES_INITIALIZED;
	SMF::tEvent *RESTORE_BT_STATUS;
	SMF::tEvent *RUN;
	SMF::tEvent *START_AUTO_CONNECTION;
	SMF::tEvent *STOP;
	SMF::tEvent *STOP_AUTO_CONNECTION;
	SMF::tEvent *SWITCH_BT_OFF;
	int dummy_do_not_use;


virtual void Create()
{
	if (_created) {
		/* SM was already created => return now */
		return;
	}

	_created = true;

	/* state machine definition */


	/* create new compound state */
	tState *topBmControllerOnOff_14b2fc270f080000000000000000867 = CreateCompoundState("topBmControllerOnOff", topBmControllerOnOff, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *BmControllerOnOff_14b58fed75680000000000000000A08 = CreateCompoundState("BmControllerOnOff", BmControllerOnOff, NULL, NULL, NULL, NULL);

	/* create final states */
	tState *Final_14b4a6f276a800000000000000009DE = CreateFinalState("Final", Final, NULL, NULL);
	AddState(BmControllerOnOff_14b58fed75680000000000000000A08, Final_14b4a6f276a800000000000000009DE);

	/* create states */
	tState *StoppingConnectionControllers_150fc2654fc800000000000000009BE = CreateState("StoppingConnectionControllers", StoppingConnectionControllers, stopAllConnectionControllersCall, "stopAllConnectionControllers", NULL, NULL);
	tState *InitializingBtStackIf_15419e14e2380000000000000000B27 = CreateState("InitializingBtStackIf", InitializingBtStackIf, initializeBtStackIfCall, "initializeBtStackIf", NULL, NULL);
	tState *InitializingProperties_15419e14e2380000000000000000B31 = CreateState("InitializingProperties", InitializingProperties, initializePropertiesCall, "initializeProperties", NULL, NULL);
	tState *BmControllerStopped_15a8edc2eb9800000000000000009D6 = CreateState("BmControllerStopped", BmControllerStopped, handleBmControllerStoppedCall, "handleBmControllerStopped", NULL, NULL);
	tState *TerminatingConnectionControllers_15a8edc2eb9800000000000000009E3 = CreateState("TerminatingConnectionControllers", TerminatingConnectionControllers, terminateAllConnectionControllersCall, "terminateAllConnectionControllers", NULL, NULL);

	/* create new compound state */
	tState *BmControllerActive_15429f18fec80000000000000000B3A = CreateCompoundState("BmControllerActive", BmControllerActive, handleBmControllerActiveCall, "handleBmControllerActive", NULL, NULL);

	/* create states */
	tState *BtSwitchedOff_15419e14e2380000000000000000B3B = CreateState("BtSwitchedOff", BtSwitchedOff, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *SwitchingBtOff_15429f18fec80000000000000000B4A = CreateCompoundState("SwitchingBtOff", SwitchingBtOff, switchBtOffCall, "switchBtOff", NULL, NULL);

	/* create states */
	tState *SwitchingBtOffOnStop_1544dd3869280000000000000000B7A = CreateState("SwitchingBtOffOnStop", SwitchingBtOffOnStop, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *BmControllerInactive_1543e88332980000000000000000B69 = CreateCompoundState("BmControllerInactive", BmControllerInactive, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *BtSwitchedOn_1544daaa6d480000000000000000B58 = CreateCompoundState("BtSwitchedOn", BtSwitchedOn, NULL, NULL, NULL, NULL);

	/* create new compound state */
	tState *CheckingForConnectedDevices_1544dd3869280000000000000000B72 = CreateCompoundState("CheckingForConnectedDevices", CheckingForConnectedDevices, disconnectAllDevicesCall, "disconnectAllDevices", NULL, NULL);

	/* create states */
	tState *DisconnectingDevicesOnDisconnectAllDevices_1544dd3869280000000000000000B73 = CreateState("DisconnectingDevicesOnDisconnectAllDevices", DisconnectingDevicesOnDisconnectAllDevices, NULL, NULL, NULL, NULL);
	tState *DisconnectingDevicesOnSwitchBtOff_1544dd3869280000000000000000B75 = CreateState("DisconnectingDevicesOnSwitchBtOff", DisconnectingDevicesOnSwitchBtOff, NULL, NULL, NULL, NULL);
	tState *DisconnectingDevicesOnStop_1544dd3869280000000000000000B76 = CreateState("DisconnectingDevicesOnStop", DisconnectingDevicesOnStop, initiateSwitchingBtOffCall, "initiateSwitchingBtOff", NULL, NULL);

	/* create new compound state */
	tState *CheckDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F5 = CreateCompoundState("CheckDeviceDiscoveryStatus", CheckDeviceDiscoveryStatus, StopDeviceDiscoveryCall, "StopDeviceDiscovery", NULL, NULL);

	/* create states */
	tState *CheckingDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F7 = CreateState("CheckingDeviceDiscoveryStatus", CheckingDeviceDiscoveryStatus, NULL, NULL, NULL, NULL);

	/* create states */
	tTransition *TopInit_14b2fc270f080000000000000000869 = CreateTransition("TopInit", NULL, NULL, NULL, NULL, BmControllerInactive_1543e88332980000000000000000B69);

	/* set the init transition */
	SetInitTransition(topBmControllerOnOff_14b2fc270f080000000000000000867, TopInit_14b2fc270f080000000000000000869);

	/* Add in states */
	AddState(topBmControllerOnOff_14b2fc270f080000000000000000867, BmControllerOnOff_14b58fed75680000000000000000A08);
	AddState(BmControllerOnOff_14b58fed75680000000000000000A08, BmControllerActive_15429f18fec80000000000000000B3A);
	AddState(BmControllerOnOff_14b58fed75680000000000000000A08, BmControllerInactive_1543e88332980000000000000000B69);
	AddState(BmControllerOnOff_14b58fed75680000000000000000A08, StoppingConnectionControllers_150fc2654fc800000000000000009BE);
	AddState(BmControllerOnOff_14b58fed75680000000000000000A08, InitializingBtStackIf_15419e14e2380000000000000000B27);
	AddState(BmControllerOnOff_14b58fed75680000000000000000A08, InitializingProperties_15419e14e2380000000000000000B31);
	AddState(BmControllerOnOff_14b58fed75680000000000000000A08, BmControllerStopped_15a8edc2eb9800000000000000009D6);
	AddState(BmControllerOnOff_14b58fed75680000000000000000A08, TerminatingConnectionControllers_15a8edc2eb9800000000000000009E3);
	AddState(BmControllerActive_15429f18fec80000000000000000B3A, SwitchingBtOff_15429f18fec80000000000000000B4A);
	AddState(BmControllerActive_15429f18fec80000000000000000B3A, BtSwitchedOn_1544daaa6d480000000000000000B58);
	AddState(BmControllerActive_15429f18fec80000000000000000B3A, BtSwitchedOff_15419e14e2380000000000000000B3B);
	AddState(SwitchingBtOff_15429f18fec80000000000000000B4A, SwitchingBtOffOnStop_1544dd3869280000000000000000B7A);
	AddState(BtSwitchedOn_1544daaa6d480000000000000000B58, CheckingForConnectedDevices_1544dd3869280000000000000000B72);
	AddState(BtSwitchedOn_1544daaa6d480000000000000000B58, CheckDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F5);
	AddState(CheckingForConnectedDevices_1544dd3869280000000000000000B72, DisconnectingDevicesOnDisconnectAllDevices_1544dd3869280000000000000000B73);
	AddState(CheckingForConnectedDevices_1544dd3869280000000000000000B72, DisconnectingDevicesOnSwitchBtOff_1544dd3869280000000000000000B75);
	AddState(CheckingForConnectedDevices_1544dd3869280000000000000000B72, DisconnectingDevicesOnStop_1544dd3869280000000000000000B76);
	AddState(CheckDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F5, CheckingDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F7);

	/* create events */
	ALL_CONN_CTRL_STOPPED = CreateEvent("ALL_CONN_CTRL_STOPPED");
	ALL_CONN_CTRL_TERMINATED = CreateEvent("ALL_CONN_CTRL_TERMINATED");
	ALL_DEVICES_DISCONNECTED = CreateEvent("ALL_DEVICES_DISCONNECTED");
	BTSTACKIF_INITIALIZATION_ERROR = CreateEvent("BTSTACKIF_INITIALIZATION_ERROR");
	BTSTACKIF_INITIALIZED = CreateEvent("BTSTACKIF_INITIALIZED");
	BT_SWITCHED_OFF = CreateEvent("BT_SWITCHED_OFF");
	BT_SWITCHED_ON = CreateEvent("BT_SWITCHED_ON");
	CLEAR_AUTO_CONNECTION_BOOKING = CreateEvent("CLEAR_AUTO_CONNECTION_BOOKING");
	CONN_CTRL_STOPPED = CreateEvent("CONN_CTRL_STOPPED");
	CONN_CTRL_TERMINATED = CreateEvent("CONN_CTRL_TERMINATED");
	DEFAULT = CreateEvent("DEFAULT");
	DEVICE_DISCOVERY_STOPPED = CreateEvent("DEVICE_DISCOVERY_STOPPED");
	DISCONNECT_ALL_DEVICES = CreateEvent("DISCONNECT_ALL_DEVICES");
	DONE = CreateEvent("DONE");
	INIT = CreateEvent("INIT");
	PROPERTIES_INITIALIZED = CreateEvent("PROPERTIES_INITIALIZED");
	RESTORE_BT_STATUS = CreateEvent("RESTORE_BT_STATUS");
	RUN = CreateEvent("RUN");
	START_AUTO_CONNECTION = CreateEvent("START_AUTO_CONNECTION");
	STOP = CreateEvent("STOP");
	STOP_AUTO_CONNECTION = CreateEvent("STOP_AUTO_CONNECTION");
	SWITCH_BT_OFF = CreateEvent("SWITCH_BT_OFF");

	/* create event transitions */

	/* create internal transactions */
	tTransition *DEFAULTBMCONTROLLERONOFF2BMCONTROLLERONOFF_DEFAULT_BmControllerOnOff_P14c9dc7b45680000000000000000C24 = CreateDefaultTransition("DEFAULTBMCONTROLLERONOFF2BMCONTROLLERONOFF_DEFAULT_BmControllerOnOff", NULL, NULL, messageNotConsumedCall, "messageNotConsumed", NULL);
/*2*/	tTransition *BmControllerActive2BmControllerActive_RestoreBtStatus_P15452527f1380000000000000000B60 = CreateEventTransition(RESTORE_BT_STATUS, "BMCONTROLLERACTIVE2BMCONTROLLERACTIVE_RESTOREBTSTATUS", NULL, NULL,  restoreBtStatusCall,  "restoreBtStatus", NULL);
/*2*/	tTransition *BmControllerOnOff2BmControllerOnOff_ClearAutoConnectionBooking_P15460ff86d980000000000000000B70 = CreateEventTransition(CLEAR_AUTO_CONNECTION_BOOKING, "BMCONTROLLERONOFF2BMCONTROLLERONOFF_CLEARAUTOCONNECTIONBOOKING", NULL, NULL,  clearAutoConnectionBookingCall,  "clearAutoConnectionBooking", NULL);
/*2*/	tTransition *BmControllerOnOff2BmControllerOnOff_StartAutoConnection_P15460ff86d980000000000000000B66 = CreateEventTransition(START_AUTO_CONNECTION, "BMCONTROLLERONOFF2BMCONTROLLERONOFF_STARTAUTOCONNECTION", NULL, NULL,  startAutoConnectionCall,  "startAutoConnection", NULL);
/*2*/	tTransition *BmControllerOnOff2BmControllerOnOff_StopAutoConnection_P15460ff86d980000000000000000B6C = CreateEventTransition(STOP_AUTO_CONNECTION, "BMCONTROLLERONOFF2BMCONTROLLERONOFF_STOPAUTOCONNECTION", NULL, NULL,  stopAutoConnectionCall,  "stopAutoConnection", NULL);
/*2*/	tTransition *BtSwitchedOff2BtSwitchedOff_restoreBtStatus_P16aa1e2491a800000000000000009F8 = CreateEventTransition(BTSTACKIF_INITIALIZED, "BTSWITCHEDOFF2BTSWITCHEDOFF_RESTOREBTSTATUS", NULL, NULL,  restoreBtStatusCall,  "restoreBtStatus", NULL);
/*2*/	tTransition *BtSwitchedOff2BtSwitchedOff_switchBtOff_P15e94c82531800000000000000009EB = CreateEventTransition(SWITCH_BT_OFF, "BTSWITCHEDOFF2BTSWITCHEDOFF_SWITCHBTOFF", NULL, NULL,  switchBtOffCall,  "switchBtOff", NULL);
/*2*/	tTransition *DisconnectingDevicesOnDisconnectAllDevices2DisconnectingDevicesOnDisconnectAllDevices_DisconnectAllDevices_P1544dd3869280000000000000000B84 = CreateEventTransition(DISCONNECT_ALL_DEVICES, "DISCONNECTINGDEVICESONDISCONNECTALLDEVICES2DISCONNECTINGDEVICESONDISCONNECTALLDEVICES_DISCONNECTALLDEVICES", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *DisconnectingDevicesOnStop2DisconnectingDevicesOnStop_DisconnectAllDevices_P1544dd3869280000000000000000B88 = CreateEventTransition(DISCONNECT_ALL_DEVICES, "DISCONNECTINGDEVICESONSTOP2DISCONNECTINGDEVICESONSTOP_DISCONNECTALLDEVICES", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *DisconnectingDevicesOnStop2DisconnectingDevicesOnStop_Stop_P1544dd3869280000000000000000B86 = CreateEventTransition(STOP, "DISCONNECTINGDEVICESONSTOP2DISCONNECTINGDEVICESONSTOP_STOP", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *DisconnectingDevicesOnStop2DisconnectingDevicesOnStop_SwitchBtOff_P15452527f1380000000000000000B5F = CreateEventTransition(SWITCH_BT_OFF, "DISCONNECTINGDEVICESONSTOP2DISCONNECTINGDEVICESONSTOP_SWITCHBTOFF", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *DisconnectingDevicesOnSwitchBtOff2DisconnectingDevicesOnSwitchBtOff_DisconnectAllDevices_P1544dd3869280000000000000000B87 = CreateEventTransition(DISCONNECT_ALL_DEVICES, "DISCONNECTINGDEVICESONSWITCHBTOFF2DISCONNECTINGDEVICESONSWITCHBTOFF_DISCONNECTALLDEVICES", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *DisconnectingDevicesOnSwitchBtOff2DisconnectingDevicesOnSwitchBtOff_SwitchBtOff_P1544dd3869280000000000000000B85 = CreateEventTransition(SWITCH_BT_OFF, "DISCONNECTINGDEVICESONSWITCHBTOFF2DISCONNECTINGDEVICESONSWITCHBTOFF_SWITCHBTOFF", NULL, NULL,  NULL,  NULL, NULL);
/*2*/	tTransition *StoppingConnectionControllers2StoppingConnectionControllers_ConnCtrlStopped_P15a8edc2eb9800000000000000009E0 = CreateEventTransition(CONN_CTRL_STOPPED, "STOPPINGCONNECTIONCONTROLLERS2STOPPINGCONNECTIONCONTROLLERS_CONNCTRLSTOPPED", NULL, NULL,  areAllConnCtrlStoppedCall,  "areAllConnCtrlStopped", NULL);
/*2*/	tTransition *TerminatingConnectionControllers2TerminatingConnectionControllers_ConnCtrlTerminated_P15a8edc2eb9800000000000000009E6 = CreateEventTransition(CONN_CTRL_TERMINATED, "TERMINATINGCONNECTIONCONTROLLERS2TERMINATINGCONNECTIONCONTROLLERS_CONNCTRLTERMINATED", NULL, NULL,  areAllConnCtrlTerminatedCall,  "areAllConnCtrlTerminated", NULL);

	/* create event transitions */
/*7*/	tTransition *BmControllerOnOff2TerminatingConnectionControllers_Done_14c9971be1e80000000000000000C1C = CreateEventTransition(DONE, "BmControllerOnOff2TerminatingConnectionControllers_Done", NULL, NULL, NULL, NULL, TerminatingConnectionControllers_15a8edc2eb9800000000000000009E3);
/*7*/	tTransition *BtSwitchedOff2BmControllerStopped_Stop_1543e88332980000000000000000B62 = CreateEventTransition(STOP, "BtSwitchedOff2BmControllerStopped_Stop", NULL, NULL, NULL, NULL, StoppingConnectionControllers_150fc2654fc800000000000000009BE);
/*7*/	tTransition *BtSwitchedOff2BtSwitchedOn_BtSwitchedOn_15429f18fec80000000000000000B44 = CreateEventTransition(BT_SWITCHED_ON, "BtSwitchedOff2BtSwitchedOn_BtSwitchedOn", NULL, NULL, startAutoConnectionAttemptCall, "startAutoConnectionAttempt", BtSwitchedOn_1544daaa6d480000000000000000B58);
/*7*/	tTransition *BtSwitchedOn2BtSwitchedOff_BtSwitchedOff_1544dd3869280000000000000000B7D = CreateEventTransition(BT_SWITCHED_OFF, "BtSwitchedOn2BtSwitchedOff_BtSwitchedOff", NULL, NULL, disconnectAllDevicesCall, "disconnectAllDevices", BtSwitchedOff_15419e14e2380000000000000000B3B);
/*7*/	tTransition *BtSwitchedOn2CheckDeviceDiscoveryStatus_SwitchBtOff_15f2f4f4f2d800000000000000009F8 = CreateEventTransition(SWITCH_BT_OFF, "BtSwitchedOn2CheckDeviceDiscoveryStatus_SwitchBtOff", NULL, NULL, NULL, NULL, CheckDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F5);
/*7*/	tTransition *BtSwitchedOn2DisconnectingDevicesOnDisconnectAllDevices_DisconnectAllDevices_1544dd3869280000000000000000B70 = CreateEventTransition(DISCONNECT_ALL_DEVICES, "BtSwitchedOn2DisconnectingDevicesOnDisconnectAllDevices_DisconnectAllDevices", NULL, NULL, NULL, NULL, DisconnectingDevicesOnDisconnectAllDevices_1544dd3869280000000000000000B73);
/*7*/	tTransition *BtSwitchedOn2DisconnectingDevicesOnStop_Stop_1544dd3869280000000000000000B67 = CreateEventTransition(STOP, "BtSwitchedOn2DisconnectingDevicesOnStop_Stop", NULL, NULL, NULL, NULL, DisconnectingDevicesOnStop_1544dd3869280000000000000000B76);
/*7*/	tTransition *CheckDeviceDiscoveryStatus2CheckingDeviceDiscoveryStatus_Stop_15f2f4f4f2d800000000000000009FD = CreateEventTransition(STOP, "CheckDeviceDiscoveryStatus2CheckingDeviceDiscoveryStatus_Stop", NULL, NULL, NULL, NULL, CheckingDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F7);
/*7*/	tTransition *CheckDeviceDiscoveryStatus2DisconnectingDevicesOnSwitchBtOff_DeviceDiscoveryStopped_15f2f4f4f2d800000000000000009FB = CreateEventTransition(DEVICE_DISCOVERY_STOPPED, "CheckDeviceDiscoveryStatus2DisconnectingDevicesOnSwitchBtOff_DeviceDiscoveryStopped", NULL, NULL, NULL, NULL, DisconnectingDevicesOnSwitchBtOff_1544dd3869280000000000000000B75);
/*7*/	tTransition *CheckingDeviceDiscoveryStatus2DisconnectingDevicesOnStop_DeviceDiscoveryStopped_15f2f4f4f2d800000000000000009FC = CreateEventTransition(DEVICE_DISCOVERY_STOPPED, "CheckingDeviceDiscoveryStatus2DisconnectingDevicesOnStop_DeviceDiscoveryStopped", NULL, NULL, NULL, NULL, DisconnectingDevicesOnStop_1544dd3869280000000000000000B76);
/*7*/	tTransition *DisconnectingDevicesOnDisconnectAllDevices2BtSwitchedOn_AllDevicesDisconnected_1544dd3869280000000000000000B74 = CreateEventTransition(ALL_DEVICES_DISCONNECTED, "DisconnectingDevicesOnDisconnectAllDevices2BtSwitchedOn_AllDevicesDisconnected", NULL, NULL, NULL, NULL, BtSwitchedOn_1544daaa6d480000000000000000B58);
/*7*/	tTransition *DisconnectingDevicesOnDisconnectAllDevices2BtSwitchedOn_StartAutoConnection_15650d285c0800000000000000009CF = CreateEventTransition(START_AUTO_CONNECTION, "DisconnectingDevicesOnDisconnectAllDevices2BtSwitchedOn_StartAutoConnection", NULL, NULL, startAutoConnectionCall, "startAutoConnection", BtSwitchedOn_1544daaa6d480000000000000000B58);
/*7*/	tTransition *DisconnectingDevicesOnDisconnectAllDevices2DisconnectingDevicesOnStop_Stop_1544dd3869280000000000000000B82 = CreateEventTransition(STOP, "DisconnectingDevicesOnDisconnectAllDevices2DisconnectingDevicesOnStop_Stop", NULL, NULL, NULL, NULL, DisconnectingDevicesOnStop_1544dd3869280000000000000000B76);
/*7*/	tTransition *DisconnectingDevicesOnDisconnectAllDevices2DisconnectingDevicesOnSwitchBtOff_SwitchBtOff_1544dd3869280000000000000000B81 = CreateEventTransition(SWITCH_BT_OFF, "DisconnectingDevicesOnDisconnectAllDevices2DisconnectingDevicesOnSwitchBtOff_SwitchBtOff", NULL, NULL, NULL, NULL, DisconnectingDevicesOnSwitchBtOff_1544dd3869280000000000000000B75);
/*7*/	tTransition *DisconnectingDevicesOnStop2BmControllerStopped_BtSwitchedOff_1544dd3869280000000000000000B7E = CreateEventTransition(BT_SWITCHED_OFF, "DisconnectingDevicesOnStop2BmControllerStopped_BtSwitchedOff", NULL, NULL, NULL, NULL, StoppingConnectionControllers_150fc2654fc800000000000000009BE);
/*7*/	tTransition *DisconnectingDevicesOnStop2SwitchingBtOffOnStop_AllDevicesDisconnected_1544dd3869280000000000000000B79 = CreateEventTransition(ALL_DEVICES_DISCONNECTED, "DisconnectingDevicesOnStop2SwitchingBtOffOnStop_AllDevicesDisconnected", NULL, NULL, NULL, NULL, SwitchingBtOffOnStop_1544dd3869280000000000000000B7A);
/*7*/	tTransition *DisconnectingDevicesOnSwitchBtOff2DisconnectingDevicesOnStop_Stop_1544dd3869280000000000000000B83 = CreateEventTransition(STOP, "DisconnectingDevicesOnSwitchBtOff2DisconnectingDevicesOnStop_Stop", NULL, NULL, NULL, NULL, DisconnectingDevicesOnStop_1544dd3869280000000000000000B76);
/*7*/	tTransition *DisconnectingDevicesOnSwitchBtOff2SwitchingBtOff_AllDevicesDisconnected_1544dd3869280000000000000000B77 = CreateEventTransition(ALL_DEVICES_DISCONNECTED, "DisconnectingDevicesOnSwitchBtOff2SwitchingBtOff_AllDevicesDisconnected", NULL, NULL, NULL, NULL, SwitchingBtOff_15429f18fec80000000000000000B4A);
/*7*/	tTransition *InitializingBtStackIf2InitializingProperties_BtStackIfInitializationError_154c3f39e69800000000000000009CD = CreateEventTransition(BTSTACKIF_INITIALIZATION_ERROR, "InitializingBtStackIf2InitializingProperties_BtStackIfInitializationError", NULL, NULL, NULL, NULL, InitializingProperties_15419e14e2380000000000000000B31);
/*7*/	tTransition *InitializingBtStackIf2InitializingProperties_BtStackIfInitialized_15419e14e2380000000000000000B34 = CreateEventTransition(BTSTACKIF_INITIALIZED, "InitializingBtStackIf2InitializingProperties_BtStackIfInitialized", NULL, NULL, NULL, NULL, InitializingProperties_15419e14e2380000000000000000B31);
/*7*/	tTransition *InitializingProperties2BtSwitchedOff_PropertiesInitialized_15419e14e2380000000000000000B39 = CreateEventTransition(PROPERTIES_INITIALIZED, "InitializingProperties2BtSwitchedOff_PropertiesInitialized", NULL, NULL, restoreBtStatusCall, "restoreBtStatus", BtSwitchedOff_15419e14e2380000000000000000B3B);
/*7*/	tTransition *StoppingConnectionControllers2BmControllerStopped_AllConnCtrlStopped_15a8edc2eb9800000000000000009D9 = CreateEventTransition(ALL_CONN_CTRL_STOPPED, "StoppingConnectionControllers2BmControllerStopped_AllConnCtrlStopped", NULL, NULL, NULL, NULL, BmControllerStopped_15a8edc2eb9800000000000000009D6);
/*7*/	tTransition *SwitchingBtOff2BtSwitchedOff_BtSwitchedOff_1544dd3869280000000000000000B7B = CreateEventTransition(BT_SWITCHED_OFF, "SwitchingBtOff2BtSwitchedOff_BtSwitchedOff", NULL, NULL, NULL, NULL, BtSwitchedOff_15419e14e2380000000000000000B3B);
/*7*/	tTransition *SwitchingBtOff2BtSwitchedOn_BtSwitchedOn_1544dd3869280000000000000000B7F = CreateEventTransition(BT_SWITCHED_ON, "SwitchingBtOff2BtSwitchedOn_BtSwitchedOn", NULL, NULL, startAutoConnectionAttemptCall, "startAutoConnectionAttempt", BtSwitchedOn_1544daaa6d480000000000000000B58);
/*7*/	tTransition *SwitchingBtOff2SwitchingBtOffOnStop_Stop_1544dd3869280000000000000000B8A = CreateEventTransition(STOP, "SwitchingBtOff2SwitchingBtOffOnStop_Stop", NULL, NULL, NULL, NULL, SwitchingBtOffOnStop_1544dd3869280000000000000000B7A);
/*7*/	tTransition *SwitchingBtOffOnStop2BmControllerStopped_BtSwitchedOff_1544dd3869280000000000000000B7C = CreateEventTransition(BT_SWITCHED_OFF, "SwitchingBtOffOnStop2BmControllerStopped_BtSwitchedOff", NULL, NULL, NULL, NULL, StoppingConnectionControllers_150fc2654fc800000000000000009BE);
/*7*/	tTransition *SwitchingBtOffOnStop2BmControllerStopped_BtSwitchedOn_1544dd3869280000000000000000B80 = CreateEventTransition(BT_SWITCHED_ON, "SwitchingBtOffOnStop2BmControllerStopped_BtSwitchedOn", NULL, NULL, NULL, NULL, StoppingConnectionControllers_150fc2654fc800000000000000009BE);
/*7*/	tTransition *TerminatingConnectionControllers2Final_AllConnCtrlTerminated_15a8edc2eb9800000000000000009EA = CreateEventTransition(ALL_CONN_CTRL_TERMINATED, "TerminatingConnectionControllers2Final_AllConnCtrlTerminated", NULL, NULL, handleBmControllerTerminatedCall, "handleBmControllerTerminated", Final_14b4a6f276a800000000000000009DE);
/*9*/	tTransition *BmControllerInactive2ChoiceA_Run_1543e88332980000000000000000B66 = CreateEventConditionalTransition(RUN, "BmControllerInactive2ChoiceA_Run", BmControllerOnOff_14b58fed75680000000000000000A08, NULL, NULL, isFirstStartUpCall, "isFirstStartUp", NULL, NULL, NULL, NULL, "trueChoiceA2InitializingBtStackIf_True", InitializingBtStackIf_15419e14e2380000000000000000B27, "falseChoiceA2InitializingProperties_False", InitializingProperties_15419e14e2380000000000000000B31);

	/* add transitions to states */
	AddTransition(BmControllerOnOff_14b58fed75680000000000000000A08, BmControllerOnOff2TerminatingConnectionControllers_Done_14c9971be1e80000000000000000C1C);
	AddTransition(InitializingBtStackIf_15419e14e2380000000000000000B27, InitializingBtStackIf2InitializingProperties_BtStackIfInitialized_15419e14e2380000000000000000B34);
	AddTransition(InitializingProperties_15419e14e2380000000000000000B31, InitializingProperties2BtSwitchedOff_PropertiesInitialized_15419e14e2380000000000000000B39);
	AddTransition(BtSwitchedOff_15419e14e2380000000000000000B3B, BtSwitchedOff2BtSwitchedOn_BtSwitchedOn_15429f18fec80000000000000000B44);
	AddTransition(BtSwitchedOff_15419e14e2380000000000000000B3B, BtSwitchedOff2BmControllerStopped_Stop_1543e88332980000000000000000B62);
	AddTransition(BmControllerInactive_1543e88332980000000000000000B69, BmControllerInactive2ChoiceA_Run_1543e88332980000000000000000B66);
	AddTransition(BtSwitchedOn_1544daaa6d480000000000000000B58, BtSwitchedOn2DisconnectingDevicesOnStop_Stop_1544dd3869280000000000000000B67);
	AddTransition(BtSwitchedOn_1544daaa6d480000000000000000B58, BtSwitchedOn2DisconnectingDevicesOnDisconnectAllDevices_DisconnectAllDevices_1544dd3869280000000000000000B70);
	AddTransition(DisconnectingDevicesOnDisconnectAllDevices_1544dd3869280000000000000000B73, DisconnectingDevicesOnDisconnectAllDevices2BtSwitchedOn_AllDevicesDisconnected_1544dd3869280000000000000000B74);
	AddTransition(DisconnectingDevicesOnSwitchBtOff_1544dd3869280000000000000000B75, DisconnectingDevicesOnSwitchBtOff2SwitchingBtOff_AllDevicesDisconnected_1544dd3869280000000000000000B77);
	AddTransition(DisconnectingDevicesOnStop_1544dd3869280000000000000000B76, DisconnectingDevicesOnStop2SwitchingBtOffOnStop_AllDevicesDisconnected_1544dd3869280000000000000000B79);
	AddTransition(SwitchingBtOff_15429f18fec80000000000000000B4A, SwitchingBtOff2BtSwitchedOff_BtSwitchedOff_1544dd3869280000000000000000B7B);
	AddTransition(SwitchingBtOffOnStop_1544dd3869280000000000000000B7A, SwitchingBtOffOnStop2BmControllerStopped_BtSwitchedOff_1544dd3869280000000000000000B7C);
	AddTransition(BtSwitchedOn_1544daaa6d480000000000000000B58, BtSwitchedOn2BtSwitchedOff_BtSwitchedOff_1544dd3869280000000000000000B7D);
	AddTransition(DisconnectingDevicesOnStop_1544dd3869280000000000000000B76, DisconnectingDevicesOnStop2BmControllerStopped_BtSwitchedOff_1544dd3869280000000000000000B7E);
	AddTransition(SwitchingBtOff_15429f18fec80000000000000000B4A, SwitchingBtOff2BtSwitchedOn_BtSwitchedOn_1544dd3869280000000000000000B7F);
	AddTransition(SwitchingBtOffOnStop_1544dd3869280000000000000000B7A, SwitchingBtOffOnStop2BmControllerStopped_BtSwitchedOn_1544dd3869280000000000000000B80);
	AddTransition(DisconnectingDevicesOnDisconnectAllDevices_1544dd3869280000000000000000B73, DisconnectingDevicesOnDisconnectAllDevices2DisconnectingDevicesOnSwitchBtOff_SwitchBtOff_1544dd3869280000000000000000B81);
	AddTransition(DisconnectingDevicesOnDisconnectAllDevices_1544dd3869280000000000000000B73, DisconnectingDevicesOnDisconnectAllDevices2DisconnectingDevicesOnStop_Stop_1544dd3869280000000000000000B82);
	AddTransition(DisconnectingDevicesOnSwitchBtOff_1544dd3869280000000000000000B75, DisconnectingDevicesOnSwitchBtOff2DisconnectingDevicesOnStop_Stop_1544dd3869280000000000000000B83);
	AddTransition(SwitchingBtOff_15429f18fec80000000000000000B4A, SwitchingBtOff2SwitchingBtOffOnStop_Stop_1544dd3869280000000000000000B8A);
	AddTransition(InitializingBtStackIf_15419e14e2380000000000000000B27, InitializingBtStackIf2InitializingProperties_BtStackIfInitializationError_154c3f39e69800000000000000009CD);
	AddTransition(DisconnectingDevicesOnDisconnectAllDevices_1544dd3869280000000000000000B73, DisconnectingDevicesOnDisconnectAllDevices2BtSwitchedOn_StartAutoConnection_15650d285c0800000000000000009CF);
	AddTransition(StoppingConnectionControllers_150fc2654fc800000000000000009BE, StoppingConnectionControllers2BmControllerStopped_AllConnCtrlStopped_15a8edc2eb9800000000000000009D9);
	AddTransition(TerminatingConnectionControllers_15a8edc2eb9800000000000000009E3, TerminatingConnectionControllers2Final_AllConnCtrlTerminated_15a8edc2eb9800000000000000009EA);
	AddTransition(BtSwitchedOn_1544daaa6d480000000000000000B58, BtSwitchedOn2CheckDeviceDiscoveryStatus_SwitchBtOff_15f2f4f4f2d800000000000000009F8);
	AddTransition(CheckDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F5, CheckDeviceDiscoveryStatus2DisconnectingDevicesOnSwitchBtOff_DeviceDiscoveryStopped_15f2f4f4f2d800000000000000009FB);
	AddTransition(CheckingDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F7, CheckingDeviceDiscoveryStatus2DisconnectingDevicesOnStop_DeviceDiscoveryStopped_15f2f4f4f2d800000000000000009FC);
	AddTransition(CheckDeviceDiscoveryStatus_15f2f4f4f2d800000000000000009F5, CheckDeviceDiscoveryStatus2CheckingDeviceDiscoveryStatus_Stop_15f2f4f4f2d800000000000000009FD);
	AddTransition(BmControllerOnOff_14b58fed75680000000000000000A08, DEFAULTBMCONTROLLERONOFF2BMCONTROLLERONOFF_DEFAULT_BmControllerOnOff_P14c9dc7b45680000000000000000C24);
	AddTransition(DisconnectingDevicesOnDisconnectAllDevices_1544dd3869280000000000000000B73, DisconnectingDevicesOnDisconnectAllDevices2DisconnectingDevicesOnDisconnectAllDevices_DisconnectAllDevices_P1544dd3869280000000000000000B84);
	AddTransition(DisconnectingDevicesOnSwitchBtOff_1544dd3869280000000000000000B75, DisconnectingDevicesOnSwitchBtOff2DisconnectingDevicesOnSwitchBtOff_SwitchBtOff_P1544dd3869280000000000000000B85);
	AddTransition(DisconnectingDevicesOnStop_1544dd3869280000000000000000B76, DisconnectingDevicesOnStop2DisconnectingDevicesOnStop_Stop_P1544dd3869280000000000000000B86);
	AddTransition(DisconnectingDevicesOnSwitchBtOff_1544dd3869280000000000000000B75, DisconnectingDevicesOnSwitchBtOff2DisconnectingDevicesOnSwitchBtOff_DisconnectAllDevices_P1544dd3869280000000000000000B87);
	AddTransition(DisconnectingDevicesOnStop_1544dd3869280000000000000000B76, DisconnectingDevicesOnStop2DisconnectingDevicesOnStop_DisconnectAllDevices_P1544dd3869280000000000000000B88);
	AddTransition(DisconnectingDevicesOnStop_1544dd3869280000000000000000B76, DisconnectingDevicesOnStop2DisconnectingDevicesOnStop_SwitchBtOff_P15452527f1380000000000000000B5F);
	AddTransition(BmControllerActive_15429f18fec80000000000000000B3A, BmControllerActive2BmControllerActive_RestoreBtStatus_P15452527f1380000000000000000B60);
	AddTransition(BmControllerOnOff_14b58fed75680000000000000000A08, BmControllerOnOff2BmControllerOnOff_StartAutoConnection_P15460ff86d980000000000000000B66);
	AddTransition(BmControllerOnOff_14b58fed75680000000000000000A08, BmControllerOnOff2BmControllerOnOff_StopAutoConnection_P15460ff86d980000000000000000B6C);
	AddTransition(BmControllerOnOff_14b58fed75680000000000000000A08, BmControllerOnOff2BmControllerOnOff_ClearAutoConnectionBooking_P15460ff86d980000000000000000B70);
	AddTransition(StoppingConnectionControllers_150fc2654fc800000000000000009BE, StoppingConnectionControllers2StoppingConnectionControllers_ConnCtrlStopped_P15a8edc2eb9800000000000000009E0);
	AddTransition(TerminatingConnectionControllers_15a8edc2eb9800000000000000009E3, TerminatingConnectionControllers2TerminatingConnectionControllers_ConnCtrlTerminated_P15a8edc2eb9800000000000000009E6);
	AddTransition(BtSwitchedOff_15419e14e2380000000000000000B3B, BtSwitchedOff2BtSwitchedOff_switchBtOff_P15e94c82531800000000000000009EB);
	AddTransition(BtSwitchedOff_15419e14e2380000000000000000B3B, BtSwitchedOff2BtSwitchedOff_restoreBtStatus_P16aa1e2491a800000000000000009F8);

	/* set start (compound) state for state machine */
	SetConcurrent(topBmControllerOnOff_14b2fc270f080000000000000000867);
	return SetRoot(topBmControllerOnOff_14b2fc270f080000000000000000867);
}
};
} // namespace bmcore
// end of generated code

#endif
