/*****************************************************************************
| FILE:         ProcBase.cpp
| PROJECT:      NISSAN LCN2.5
| SW-COMPONENT: Process
|-----------------------------------------------------------------------------
| DESCRIPTION:  Process Base Entry
|
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2005 Blaupunkt GmbH
| HISTORY:
| Date      | Modification               | Author
| 18.08.11  |                            | Kollai
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

/************************************************************************
|defines and macros (scope: module-local)
|-----------------------------------------------------------------------*/
#define EVENT_SHUTDOWN_NAME "SHUTDOWN"

/************************************************************************
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

//~ #define SPM_S_IMPORT_INTERFACE_GENERIC
//~ #include "spm_if.h"

//~ 
//~ 

#define TRACE_S_IMPORT_INTERFACE_TYPES
#include "trace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_DATAPOOL
#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"
#endif

#include "ProcDynamicEnv.h"

#include "buildversion_if.h"

#define TR_CLASS_PROC_STARTUP_DYN          0x8201

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROC_STARTUP_DYN
#include "trcGenProj/Header/ProcDynamic.cpp.trc.h"
#endif
/************************************************************************
*defines and macros
************************************************************************/

OSAL_tEventHandle  hEvShutdown = 0;
OSAL_tEventMask    hEvRequest  = 0x00000001;

static tVoid vDisplayStartupMessage(tVoid)
{
    tChar cTmpString[255];
    const tChar* cProcName = PROC_NAME_STRING;

    ETG_TRACE_FATAL(("---------------------------------------------------"));

    sprintf(cTmpString,"%s:          Version: %s",cProcName , (tCString)BuildVersion_szLabel);
    ETG_TRACE_FATAL(("%s", cTmpString));

#if (OSAL_OS==OSAL_LINUX)
    sprintf(cTmpString,"%s:Initial Builddate: %8.8s  %2.2s:%2.2s:%2.2s",cProcName,
        BuildVersion_szTimestamp, BuildVersion_szTimestamp+8,
        BuildVersion_szTimestamp+10, BuildVersion_szTimestamp+12 );
#else
    sprintf(cTmpString,"%s:        Builddate: %8.8s  %2.2s:%2.2s:%2.2s",cProcName,
        BuildVersion_szTimestamp, BuildVersion_szTimestamp+8,
        BuildVersion_szTimestamp+10, BuildVersion_szTimestamp+12 );
#endif
    ETG_TRACE_FATAL(("%s", cTmpString));

    sprintf(cTmpString,"%s:             User: %s on %s",cProcName,
        (tCString)BuildVersion_szBuildUser,
        (tCString)BuildVersion_szBuildMachine);
    ETG_TRACE_FATAL(("%s", cTmpString));

    if ((BuildVersion_szBuildType[0] == 'd') &&
        (BuildVersion_szBuildType[1] == 'e') &&
        (BuildVersion_szBuildType[2] == 'v'))
    {
        ETG_TRACE_FATAL(("%s:             Type: Development build",cProcName));
    }
    else
    {
        ETG_TRACE_FATAL(("%s:             Type: Integration build",cProcName));
    }

#ifdef __DEBUG_BUILD__
    ETG_TRACE_FATAL(("%s:             Mode: Debug  ",cProcName));
#else
    ETG_TRACE_FATAL(("%s:             Mode: Release  ",cProcName));
#endif

    ETG_TRACE_FATAL(("---------------------------------------------------"));
}


tS32 s32RunEnv(void)
{
    tS32 s32RetVal = OSAL_OK;


    // setup CCA & co.
    amt_bInit();
    scd_init();

    // open Trace ------------------------------
    ET_TRACE_OPEN;

   vDisplayStartupMessage();
#ifdef PROC_REG_FILE_NAME
   OSAL_tIODescriptor  regHandle;
   if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
   {
      char Path[100] = "/dev/root/opt/bosch/base/registry/"PROC_REG_FILE_NAME;
      if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t)&Path[0])) == OSAL_OK)
      {
         ETG_TRACE_FATAL(("REGISTRY loaded %s!", PROC_REG_FILE_NAME));
      } else {
         ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY %s!", PROC_REG_FILE_NAME));
      }
   }
   OSAL_s32IOClose(regHandle);
#endif

    // create the shutdown event
    if (OSAL_s32EventCreate(PROC_SHUTDOWN_EVENT_NAME, &hEvShutdown) != OSAL_ERROR) {

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_DATAPOOL
        DP_vCreateDatapool();
#endif

        vStartCCAApplications();

        // Wait for Shutdown-Signal
        ETG_TRACE_FATAL(("Wait for Shutdown-event %s!", PROC_SHUTDOWN_EVENT_NAME));
        OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
        ETG_TRACE_FATAL(("Shutdown-event received -> stop applications!"));

        // Stop all CCA Applications
        vStopCCAApplications();

        // Shutdown everything else
        OSAL_s32EventClose(hEvShutdown);
        OSAL_s32EventDelete(PROC_SHUTDOWN_EVENT_NAME);

    } else {
        ETG_TRACE_FATAL(("Failed to create event %s",PROC_SHUTDOWN_EVENT_NAME));
    }
    // end trace
    ET_TRACE_CLOSE;

    return s32RetVal;
}

/************************************************************************
|end of file ProcBase.cpp
|-----------------------------------------------------------------------*/

