#ifndef _TDDRD_H
#define _TDDRD_H

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/syslog.h>
#include <unistd.h>
#include <sys/epoll.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <pthread.h>


#define DEV_ERRMEM "/dev/errmem"
#define TDDRD_INVALID_HANDLE (-1)
#define TDDRD_MAX_NAME_LEN (128)

typedef struct {
	short int file_id;
	short int err;
	unsigned int line_no;
	char text[32];
}error_packet_t;

struct data {
	//unsigned int	time_low;  /* Time_low = lower 32 bit of time value */
	//unsigned int	time_high; /* Time_high = upper 32 bit of time value */
	unsigned long long time;
	unsigned char	ev;
	unsigned char	ctx;
	unsigned short	id;
	unsigned int	pc;
	unsigned int	lr;
};

typedef struct tddrrb_data {
	union {
		struct data d;
		unsigned char buf[sizeof(struct data)];
	};
}tddrrb_data;

typedef struct {	
	char backend_storage[TDDRD_MAX_NAME_LEN];
	long int size_max;
	unsigned int overwrite_output;
	char*    command;
} tddrconf;

typedef struct tddrd_backend {
	char dev[TDDRD_MAX_NAME_LEN];
	int errmem_fd;
	pthread_t worker_thread_id;
	pthread_attr_t worker_thread_attr;
}tddrd_backend_t;

typedef struct tddrd_frontend {
	char dev[TDDRD_MAX_NAME_LEN];
	int devid;
	int fd;
	struct tddrd_frontend *next;
}tddrd_frontend_t;

typedef struct  {
	int32_t   command;         /* current file handele */
	int32_t  socket_fd ; /* Socket descriptor */
	struct sockaddr_un address ;
	int32_t isOpen;	
	int32_t (*handler)(int32_t arg);
} tddrd_socket_t;

typedef struct  {
	tddrd_frontend_t *frontend;
	tddrd_backend_t *backend;
	long int	max_file_length;
}tddr_dev_info_t;

typedef struct  {
	unsigned int num_tddr_devices;
	int32_t tddrd_running ;	/* Daemon running status*/
	tddrconf tddr_config;	/* configuration info */
	tddr_dev_info_t tddr_dev_info;
}tddrd_t;

int is_tddrd_running();
tddr_dev_info_t* tddrd_get_devinfo();
int tddrd_get_device_num();
void* tddrd_worker_thread(void* data);
void tddrd_log_error( unsigned int line_no,short int fileid,const char *text);
tddrd_frontend_t* tddrd_get_frontend_node(int devid);

#endif
