
#include "OsalConf.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "Linux_osal.h"
#include "ostrace.h"

#define DYN_MEM_ALLOC_SIZE 255


#ifdef __cplusplus
extern "C" {
#endif

//#define TEST_ERRMEM_ENTRIES
#ifdef TEST_ERRMEM_ENTRIES
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "../../../../di_trace/components/etg/etg_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "../../../../di_commonbase/components/etrace/etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_COMP_OSALTEST
#include "trcGenProj/Header/Main.cpp.trc.h"
#endif

void TestErrmem()
{
	
  vWritePrintfErrmem("------------------------------------------------------------------- \n");	
  ET_ERRMEM_INFO_STRING(TR_COMP_OSALTEST,"This_is_an_ErrMem_Test_with ETRACE \n");
  vWritePrintfErrmem("------------------------------------------------------------------- \n");	
  ETG_TRACE_ERRMEM(("This_is_an_ErrMem_Test_with ETG \n"));
  vWritePrintfErrmem("------------------------------------------------------------------- \n");	
  vWritePrintfErrmem("This_is_an_ErrMem_Test_with OSAL \n");
  vWritePrintfErrmem("------------------------------------------------------------------- \n");	
  int fd = open("/dev/errmem", O_WRONLY,OSAL_ACCESS_RIGTHS);
  write(fd,"This_is_an_ErrMem_Test_with kernel IF",strlen("This_is_an_ErrMem_Test_with kernel IF"));
  close(fd);
  vWritePrintfErrmem("------------------------------------------------------------------- \n");	
  ETG_TRACE_ERRMEM(("This_is_an_ErrMem_Test_with ETG 2 \n"));
  vWritePrintfErrmem("------------------------------------------------------------------- \n");	
}
#endif //TEST_ERRMEM_ENTRIES

void ClearErrMemEntries(void)
{
   OSAL_tIODescriptor hDevice = 0;
   tS32 s32Size = 0;
   hDevice = OSAL_IOOpen(OSAL_C_STRING_DEVICE_ERRMEM,OSAL_EN_READWRITE);
   OSAL_s32IOControl(hDevice, OSAL_C_S32_IOCTRL_ERRMEM_CLEAR,(uintptr_t)&s32Size);
   OSAL_s32IOClose(hDevice);
}


void vPrintDataTypes(void)
{
   TraceString("enum    size:%d Bytes",sizeof(OSAL_tenThreadState));
   TraceString("tString size:%d Bytes",sizeof(tString));
   TraceString("tBool   size:%d Bytes",sizeof(tBool));
   TraceString("tU8     size:%d Bytes",sizeof(tU8));
   TraceString("tS8     size:%d Bytes",sizeof(tS8));
   TraceString("tChar   size:%d Bytes",sizeof(tChar));
   TraceString("tU16    size:%d Bytes",sizeof(tU16));
   TraceString("tS16    size:%d Bytes",sizeof(tS16));
   TraceString("tUShort size:%d Bytes",sizeof(tUShort));
   TraceString("tShort  size:%d Bytes",sizeof(tShort));
   TraceString("tUInt   size:%d Bytes",sizeof(tUInt));
   TraceString("tInt    size:%d Bytes",sizeof(tInt));
   TraceString("tULong  size:%d Bytes",sizeof(tULong));
   TraceString("tLong   size:%d Bytes",sizeof(tLong));
   TraceString("tFloat  size:%d Bytes",sizeof(tFloat));
   TraceString("tDouble size:%d Bytes",sizeof(tDouble));
   TraceString("tLDouble size:%d Bytes",sizeof(tLDouble));
   TraceString("tSize   size:%d Bytes",sizeof(tSize));
//   TraceString("tUBitfield size:%d Bytes",sizeof(tUBitfield));
//   TraceString("tBitfield  size:%d Bytes",sizeof(tBitfield));
   TraceString("tF32    size:%d Bytes",sizeof(tF32));
   TraceString("tS32    size:%d Bytes",sizeof(tS32));
   TraceString("tU32    size:%d Bytes",sizeof(tU32));
   TraceString("tF64    size:%d Bytes",sizeof(tF64));
   TraceString("tS64    size:%d Bytes",sizeof(tS64));
   TraceString("Page    Size:%d Bytes",getpagesize());
}
void vPrintResources(void)
{
   TraceString("%d Events configured",pOsalData->u32MaxNrEventElements);
   TraceString("%d Threads configured",pOsalData->u32MaxNrThreadElements);
   TraceString("%d SharedMemories configured",pOsalData->u32MaxNrSharedMemElements);
   TraceString("%d Semaphores configured",pOsalData->u32MaxNrSemaphoreElements);
   TraceString("%d Mutexes configured",pOsalData->u32MaxNrMutexElements);
   TraceString("%d Timer configured",pOsalData->u32MaxNrTimerElements);
   TraceString("%d Message Queues configured",pOsalData->u32MaxNrMqElements); 
   TraceString("%d Processes configured",pOsalData->u32MaxNrProcElements);
   TraceString("%d Internal Locks configured",pOsalData->u32MaxNrLockElements); 
   
   
   TraceString("%d Processes configured",pOsalData->u32MaxNrProcElements);
   
   TraceString("Memory for 1 Process:      %d Bytes",sizeof(trProcessInfo));
   TraceString("Memory for 1 Thread:       %d Bytes",sizeof(trThreadElement));
   TraceString("Memory for 1 Event:        %d Bytes",sizeof(trEventElement));
   TraceString("Memory for 1 Semphore:     %d Bytes",sizeof(trSemaphoreElement));
   TraceString("Memory for 1 Mutex:        %d Bytes",sizeof(trMutexElement));
   TraceString("Memory for 1 Timer:        %d Bytes",sizeof(trTimerElement));
   TraceString("Memory for 1 Shared Memory:%d Bytes",sizeof(trSharedMemoryElement));
   TraceString("Memory for 1 Message Queue:%d Bytes",sizeof(trMqueueElement));
 
   TraceString("Memory for 1 Message Queue Handle:    %d Bytes %d Handles configured",MQHANDLE_BLOCKSIZE,pOsalData->u32MqHandles);
   TraceString("Memory for 1 Event Handle:            %d Bytes %d Handles configured",EVDAT_BLOCKSIZE,pOsalData->u32EventHandles);
   TraceString("Memory for 1 Semaphore Handle:        %d Bytes %d Handles configured",SEMDAT_BLOCKSIZE,pOsalData->u32SemHandles);
   TraceString("Memory for 1 Device Descriptor Handle:%d Bytes %d Handles configured",DEVDECS_BLOCKSIZE,pOsalData->u32DeviceHandles);
   TraceString("Memory for 1 File Descriptor Handle:  %d Bytes %d Handles configured",FILEDECS_BLOCKSIZE,pOsalData->u32FileHandles);
 
   TraceString("Memory for OSAL Shared Memory %d Bytes",sizeof(trGlobalOsalData)
#ifdef PROTECTED_OSAL_AREAS
                - (4*PROTECTED_PAGE_SIZE)
#endif
   );
   TraceString("Memory for OSAL Configurable Resources Shared Memory %d Bytes",pOsalData->u32OsalResMemSize);
   TraceString("Memory for OSAL Configurable Registy Shared Memory %d Bytes",pOsalData->u32RegistryMemSize);
   TraceString("Memory for OSAL Configurable CCA Message Pool Shared Memory %d Bytes",pOsalData->u32MsgPoolSize);
}

void vOsalTraceOutRegistry(const char* szBaseName)
{
    static tU32 u32Count_recursive_call = 0;
    OSAL_trIOCtrlDir        rDir;
    OSAL_trIOCtrlDir        rDirV;
    OSAL_trIOCtrlRegistry rReg;
    OSAL_tIODescriptor fd;
    tS32* ps32Data = (tS32*)OSAL_pvMemoryAllocate(DYN_MEM_ALLOC_SIZE);
    char* ps8Name  = (char*)OSAL_pvMemoryAllocate(DYN_MEM_ALLOC_SIZE);
    
    if(ps32Data && ps8Name)
    {
       /*Tracing out when the function is recursively called for the 10th time*/
       u32Count_recursive_call++;
       if(!(u32Count_recursive_call % 10))
            TraceString("vOsalTraceOutResistry is recursively called for 10th time");
 
       fd = OSAL_IOOpen(szBaseName, OSAL_EN_READONLY);
       if (fd != OSAL_ERROR)
       {
 //          TraceString("%s",szBaseName+sizeof("/dev/registry"));

           /* First, recursively show all the subkeys */
           rDir.fd = fd;
           rDir.s32Cookie = 0;

           while (OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_REGREADDIR, (uintptr_t)&rDir) != OSAL_ERROR)
           {
              (void)OSAL_szStringCopy(ps8Name, szBaseName);
              (void)OSAL_szStringConcat(ps8Name, "/");
              (void)OSAL_szStringConcat(ps8Name, (tString)rDir.dirent.s8Name);
          
              vOsalTraceOutRegistry( (tString)ps8Name);
           }

           /* Now show all the values of this key */
           rDirV.fd = fd;
           rDirV.s32Cookie = 0;

           while (OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_REGENUMVALUE, (uintptr_t)&rDirV) != OSAL_ERROR)
           {
               rReg.pcos8Name = rDirV.dirent.s8Name;
               rReg.ps8Value  = (tU8*)ps32Data;
               rReg.u32Size    = DYN_MEM_ALLOC_SIZE;
               if (OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_REGGETVALUE, (uintptr_t)&rReg) != OSAL_ERROR)
               {
                   if (rReg.s32Type == OSAL_C_S32_VALUE_S32)
                   {
                      tU32 Val = *((tU32*)ps32Data);
                      TraceString("%s->%s:0x%x (%d)",szBaseName+47,rReg.pcos8Name,Val,Val);
                   }
                   else if (rReg.s32Type == OSAL_C_S32_VALUE_STRING)
                   {
                      TraceString("%s->%s:%s",szBaseName+47,rReg.pcos8Name,rReg.ps8Value);
                   }
                   else
                   {
                      TraceString("Unknown OSAL_C_S32_VALUE_ Type");
                   }
               }
           }
 
           if (OSAL_s32IOClose(fd) != OSAL_ERROR)
           {
   //            TraceString("%s",szBaseName+sizeof("/dev/registry"));
           }
       }
       /*Decreasing the count (for tracing out purposes) */
       u32Count_recursive_call--;
    }
    /*Freeing the memory during every return of the function*/
    if(ps8Name)OSAL_vMemoryFree(ps8Name);
    if(ps32Data)OSAL_vMemoryFree(ps32Data);
}

tS32 s32GetLinuxConfValue(tCString ValPath, tCString ValName)
{
  char cBuffer[256];
  intptr_t Ret = -1;
  
  snprintf(cBuffer,256,"%s/%s",ValPath,ValName);
  int fd = open(cBuffer, O_RDONLY);
  if(fd != -1)
  {
    Ret = read(fd,cBuffer,32);
    if(Ret > 0)
    {
       Ret = atoi(cBuffer);
    }
    close(fd);
  }
  return (tS32)Ret;
}

void vCollectLinuxConf(void)
{
   struct rlimit limit;
   TraceString("--------------------------------------------------------------------------------------------");	
#ifdef QNX
   TraceString("MQ Limit Cur:%d ",sysconf( _SC_MQ_OPEN_MAX ));
#else
   TraceString("POSIX message queue");	
   TraceString("/proc/sys/fs/mqueue/msgsize_max:%d",s32GetLinuxConfValue("/proc/sys/fs/mqueue","msgsize_max"));
   TraceString("/proc/sys/fs/mqueue/msg_max    :%d",s32GetLinuxConfValue("/proc/sys/fs/mqueue","msg_max"));
   TraceString("/proc/sys/fs/mqueue/queues_max :%d",s32GetLinuxConfValue("/proc/sys/fs/mqueue","queues_max"));
   if(getrlimit(RLIMIT_MSGQUEUE,&limit) == 0)
   {      
      TraceString("MQ Limit Cur:%d Max:%d",limit.rlim_cur, limit.rlim_max);
   }                                              
   TraceString("--------------------------------------------------------------------------------------------");	
   TraceString("Linux Shared Memory");	
   TraceString("/proc/sys/kernel/shmmax        :%d",s32GetLinuxConfValue("/proc/sys/kernel","shmmax"));
   TraceString("--------------------------------------------------------------------------------------------");	
   TraceString("Linux Processes");	
   TraceString("/proc/sys/kernel/threads_max   :%d",s32GetLinuxConfValue("/proc/sys/kernel","threads_max"));
   TraceString("/proc/sys/kernel/pid_max       :%d",s32GetLinuxConfValue("/proc/sys/kernel","pid_max"));
#endif
   if(getrlimit(RLIMIT_STACK,&limit) == 0)
   {           
      TraceString("Process Stack Size Limit Cur:%d Max:%d",limit.rlim_cur, limit.rlim_max);
   }                                              
#ifndef QNX
   TraceString("--------------------------------------------------------------------------------------------");	
   TraceString("/proc/sys/fs/file-max          :%d",s32GetLinuxConfValue("/proc/sys/fs","file-max"));
#endif
   if(getrlimit(RLIMIT_FSIZE,&limit) == 0)
   {           
      TraceString("File Size Limit Cur:%d Max:%d",limit.rlim_cur, limit.rlim_max);
   }                                              
#ifndef QNX
   TraceString("--------------------------------------------------------------------------------------------");	
   TraceString("Linux Memory Options");	
   TraceString("/proc/sys/vm/swappiness        :%d",s32GetLinuxConfValue("/proc/sys/vm","swappiness"));
   TraceString("/proc/sys/vm/overcommit_memory :%d",s32GetLinuxConfValue("/proc/sys/vm","overcommit_memory"));
   TraceString("/proc/sys/vm/panic_on_oom      :%d",s32GetLinuxConfValue("/proc/sys/vm","panic_on_oom"));
   TraceString("/proc/sys/vm/min_free_kbytes   :%d",s32GetLinuxConfValue("/proc/sys/vm","min_free_kbytes"));
   TraceString("/proc/sys/vm/vfs_cache_pressure:%d",s32GetLinuxConfValue("/proc/sys/vm","vfs_cache_pressure"));
#endif
   if(getrlimit(RLIMIT_AS ,&limit) == 0)
   {           
      TraceString("Process available virtual memory Size Limit Cur:%d Max:%d",limit.rlim_cur, limit.rlim_max);
   }                                              

#ifdef QNX
   if(getrlimit(RLIMIT_NTHR,&limit) == 0)
   {
      TraceString("Limit Threads Cur:%d Max:%d", limit.rlim_cur, limit.rlim_max);
   }
#else
   if(getrlimit(RLIMIT_NICE,&limit) == 0)
   {
      TraceString("Limit Nice Prio Cur:%d Max:%d", limit.rlim_cur, limit.rlim_max);
   }
   if(getrlimit(RLIMIT_RTPRIO,&limit) == 0)
   {
      TraceString("Limit Real Time Prio Cur:%d Max:%d", limit.rlim_cur, limit.rlim_max);
   }
   if(getrlimit(RLIMIT_RTTIME,&limit) == 0)
   {
      TraceString("Limit Real Time Time Cur:%d Max:%d", limit.rlim_cur, limit.rlim_max);
   }
#endif
   if(getrlimit(RLIMIT_NPROC,&limit) == 0)
   {
      TraceString("Limit Processes Cur:%d Max:%d", limit.rlim_cur, limit.rlim_max);
   }
   if(getrlimit(RLIMIT_STACK,&limit) == 0)
   {
      TraceString("Limit Stack size Cur:%d Max:%d", limit.rlim_cur, limit.rlim_max);
   }
   if(getrlimit(RLIMIT_AS,&limit) == 0)
   {
      TraceString("Limit size, in bytes, of a process's mapped address space Cur:%d Max:%d", limit.rlim_cur, limit.rlim_max);
   }
    
   TraceString("--------------------------------------------------------------------------------------------");	
}

void vRemount(void)
{
   OSAL_tIODescriptor fd;
   OSAL_trRemountData rRemountData;
   if((fd = OSAL_IOOpen(OSAL_C_STRING_DEVICE_PRM, OSAL_EN_READONLY))!= OSAL_ERROR )
   {
      rRemountData.u16AppID = OSAL_C_U16_DAPI_APPID;                /* ID of the application                    */
      rRemountData.szPath    = "/var/opt/bosch/navdata";
      rRemountData.szOption = "rw";         
      if(OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_PRM_REMOUNT, (uintptr_t)&rRemountData) != OSAL_ERROR)
      {
      } 
  
      /* Do something on the readwrite partition*/
      OSAL_s32ThreadWait(30000);

      rRemountData.szOption = "ro";         
      if(OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_PRM_REMOUNT, (uintptr_t)&rRemountData) != OSAL_ERROR)
      {
      } 

      OSAL_s32IOClose(fd);
   }
}

void SetOsalSystemTime(char* pTime)
{
   OSAL_trTimeDate rTime;
   char* tmp;
   if(pTime != OSAL_NULL)
   {   
     // 20.02.2017-12:53:32
     tmp = pTime + 2;
     *tmp = '\0';
     rTime.s32Day = atoi(pTime);
     pTime = tmp+1;
     tmp = pTime + 2;
     *tmp = '\0';
     rTime.s32Month = atoi(pTime);
     pTime = tmp+1;
     tmp = pTime + 4;
     *tmp = '\0';
     rTime.s32Year = atoi(pTime) -1900;

     pTime = tmp+1;
     tmp = pTime + 2;
     *tmp = '\0';
     rTime.s32Hour =atoi(pTime);
     pTime = tmp+1;
     tmp = pTime + 2;
     *tmp = '\0';
     rTime.s32Minute = atoi(pTime);
     pTime = tmp+1;
     tmp = pTime + 2;
     *tmp = '\0';
     rTime.s32Second = atoi(pTime);

     rTime.s32Weekday = 0;
     rTime.s32Yearday = 0;
     rTime.s32Daylightsaving = 0;
     if(OSAL_s32ClockSetTime(&rTime) == OSAL_OK)
     {
        TraceString("Set for OSAL %d.%d.%d-%d:%d:%d",rTime.s32Day,rTime.s32Month,rTime.s32Year, rTime.s32Hour,rTime.s32Minute,rTime.s32Second);
     }
     memset(&rTime,0,sizeof(OSAL_trTimeDate));
     if(OSAL_s32ClockGetTime(&rTime) == OSAL_OK)
     {
        TraceString("Get for OSAL %d.%d.%d-%d:%d:%d",rTime.s32Day,rTime.s32Month,rTime.s32Year, rTime.s32Hour,rTime.s32Minute,rTime.s32Second);
     }
   }
}

void ScanProcessDir(char* Path,tBool bErrMemEntry,tS32 s32Idx)
{
   struct dirent*   pDirEntp =0;
   DIR* dirproc =0;
   char szPrcPath[264];
   
   dirproc = opendir(Path);
   if(dirproc)
   {
	   pDirEntp = readdir((DIR*)dirproc);
       while(pDirEntp)
	   {
          if(*pDirEntp->d_name != '.')
		  {
 		     snprintf(szPrcPath,264,"%s/%s",Path,pDirEntp->d_name);
             u32ScanPidTaskTidStat(szPrcPath,bErrMemEntry,s32Idx);	  
		  }
          pDirEntp = readdir(dirproc);
	   }
       rewinddir(dirproc);
       closedir(dirproc);
   }
}

void vPrintTaskStates(tS32 s32Pid)
{
#ifdef QNX
    u32ScanPidTaskTidStat(NULL,FALSE,s32Pid);	  
#else	
    struct dirent*   pDirEntp =0;
    DIR* dirproc =0;
    char szPrcPath[264];

    if(s32Pid == 0)
    {
       dirproc = opendir("/proc");
       if(dirproc)
       {
          pDirEntp = readdir((DIR*)dirproc);
          while(pDirEntp)
          {
             if((*pDirEntp->d_name>= 0x30 /* 0 */)&&(*pDirEntp->d_name < 0x39 /* 9 */ ))
             {
                snprintf(szPrcPath,264,"/proc/%s/task",pDirEntp->d_name);
                ScanProcessDir(szPrcPath,FALSE,-1);	  
             }
             pDirEntp = readdir(dirproc);
          }//while(pDirEntt)
          rewinddir(dirproc);
          closedir(dirproc);
       }
    }
    else
    {
       snprintf(szPrcPath,264,"/proc/%d/task",s32Pid);
       ScanProcessDir(szPrcPath,FALSE,-1);	  
    }
#endif	
}

void vPrintTaskStatesViaName(char* name)
{
#ifdef QNX
    ((void)name);
    TraceString("Functionality not supported for QNX");
#else
   tS32 s32Pid = 0;
   struct dirent*    pDirEntp=NULL;
   DIR* dirproc =0;
   char szPrcPath[256];
   char ProcessPath[1024];
   FILE* fdstr = NULL;
   
   dirproc = opendir("/proc");
   if(dirproc)
   {
      pDirEntp = readdir((DIR*)dirproc);
      while(pDirEntp)
      {
         if((*pDirEntp->d_name>= 0x30 /* 0 */)&&(*pDirEntp->d_name < 0x39 /* 9 */ ))
         {
             OSAL_szStringCopy(szPrcPath,"/proc/");
             OSAL_szStringConcat(szPrcPath,pDirEntp->d_name);
             OSAL_szStringConcat(szPrcPath,"/cmdline");
             fdstr = fopen(szPrcPath, "r");
             if(fdstr != NULL)
             {
                 memset(ProcessPath,0,128);
                 if(fscanf(fdstr,"%s",&ProcessPath[0]) == -1){}
                 fclose(fdstr);
                 if(strstr(ProcessPath,name))
                 {
                    s32Pid = atoi(pDirEntp->d_name);
                    vPrintTaskStates(s32Pid);
                 }
             }
         }
         pDirEntp = readdir(dirproc);
      }//while(pDirEntp)
      closedir(dirproc);
   }
#endif
}

void vPrintOsalProcesses(void)
{
    struct dirent*   pDirEntp =0;
    DIR* dirproc =0;
    char Buffer[1024];
    char szPrcPath[264];
    char szName[64];
    int fd;
    char *tmp = 0,*tmp2;
    char* Status = (char*)"ACTIVE";
    int CountDead = 0;
    int CountActive = 0;
    snprintf(szName,64,"%s/OSAL/Processes",VOLATILE_DIR);
    dirproc = opendir(szName);
    if(dirproc)
    {
       pDirEntp = readdir((DIR*)dirproc);
       while(pDirEntp)
       {
          if((*pDirEntp->d_name>= 0x30 /* 0 */)&&(*pDirEntp->d_name < 0x39 /* 9 */ ))
          {
              snprintf(Buffer,264,"/proc/%s",pDirEntp->d_name);
              if((fd = open(Buffer, O_RDONLY|O_CLOEXEC,OSAL_ACCESS_RIGTHS)) == -1)
              {
                 Status = (char*)"DEAD";
                 CountDead++;
              }
              else
              {
                 Status = (char*)"ACTIVE";
                 CountActive++;
                 close(fd);  
              }
              snprintf(szPrcPath,264,"%s/%s",szName,pDirEntp->d_name);
              if((fd = open(szPrcPath, O_RDONLY|O_CLOEXEC,OSAL_ACCESS_RIGTHS)) != -1)
              {
                 if(read(fd,Buffer,1024) != -1)
                 {
                    tmp = strchr(Buffer,'\n');
                    tmp++;
                    tmp2 = strchr(tmp,'\n');
                     *tmp2 = 0x00;
                 }
                 close(fd);
              }
              //snprintf(szName,64,"/proc/%s",pDirEntp->d_name);
              TraceString("PID:%s Status:%s Name:%s",pDirEntp->d_name,Status,tmp);
          }
          pDirEntp = readdir(dirproc);
       }//while(pDirEntt)
       rewinddir(dirproc);
       closedir(dirproc);
    }
    TraceString("%d active OSAL processes, %d unexpected terminated",CountActive,CountDead);
}


void vPrintProzessStates(int Pid)
{
   char Command[1024];
   TraceString("--------------- File Handle Information -----------------------------------------");
   snprintf(Command,1024,"ls -la /proc/%d/fd",Pid);
   vGetSystemCallInfo(Command,FALSE);
   TraceString("--------------- Process Status Information --------------------------------------");
   snprintf(Command,1024,"cat /proc/%d/status",Pid);
   vGetSystemCallInfo(Command,FALSE);
   TraceString("--------------- Process IO Information ------------------------------------------");
   snprintf(Command,1024,"cat /proc/%d/io",Pid);
   vGetSystemCallInfo(Command,FALSE);
   TraceString("--------------- Process Limit Information ---------------------------------------");
   snprintf(Command,1024,"cat /proc/%d/limits",Pid);
   vGetSystemCallInfo(Command,FALSE);
   TraceString("--------------- Process cgroup Information --------------------------------------");
   snprintf(Command,1024,"cat /proc/%d/cgroup",Pid);
   vGetSystemCallInfo(Command,FALSE);
   TraceString("--------------- Process Map Information -----------------------------------------");
   snprintf(Command,1024,"cat /proc/%d/maps",Pid);
   vGetSystemCallInfo(Command,FALSE);
}

#ifdef QNX 

void PrintSLog(void)
{
    int events[4096];
    int *evp;
    int n;
    int wait = 0;  // Set to 1 to block and print
                   // new events as they arrive.
    int fd = open("/dev/slog2",
              wait ? O_RDONLY : O_RDONLY|O_NONBLOCK);
    if(fd != -1)
	{
      for(;;) 
	  {
        int cnt;

        // Read some events.
        n = read(fd, events, sizeof(events));
        if(n == -1) 
		{
            // Normal case for a non-blocking read with no events.
            if(errno == EAGAIN) 
			{
               TraceString("Normal case for a non-blocking read with no events");
            }
            break;
        }

       // Converts bytes to ints (all events are composed of ints).
        n /= sizeof(int);
        if(n == 0)
            break;

        for(evp = events ; evp < &events[n] ;
            evp += cnt) {
            int    major, minor, severity, txt;
            time_t sec;
            char   timebuf[60];

            major    = _SLOG_GETMAJOR(evp[1]);
            minor    = _SLOG_GETMINOR(evp[1]);
            cnt      = _SLOG_GETCOUNT(evp[0]) +
                       _SLOG_HDRINTS;
            severity = _SLOG_GETSEVERITY(evp[0]);
            txt      = _SLOG_GETTEXT(evp[0]);

            sec = evp[2];
            strftime(timebuf, sizeof(timebuf),
                     "%h %d %T", localtime(&sec));
            TraceString("%s    %d %5d    %2d ", timebuf,
                   severity, major, minor);

            if(txt)
                TraceString("%s",
                       (char *) &evp[_SLOG_HDRINTS]);
        }

      }
	}
	else
	{
       TraceString("Open /dev/slog2 failed errno:%d", errno);
	}	
}
#endif


int main(int argc,char** argv)
{
   OSAL_tIODescriptor s32DevDesc = 0;
   intptr_t s32Ret = OSAL_ERROR;
   int opt,msecs = 0;
   char* tmp;
   OSAL_trRemountData rRemountData;
   char cPath[256] = "/dev/registry/"REGISTRY_BASE_PATH;
   char cFilePath[256] = {0};
   char Buffer[256] = {0};

   /* check for timeout option ./osalprc.out -t 1000 */
 //  while ((opt = getopt (argc, argv, "f:t:r:s:S:d:m:ReohLxpgnqa:vwc:")) != -1)
   while ((opt = getopt (argc, argv, "f:t:r:s:S:d:m:ReohLpgnqc:Mx:wQPC:")) != -1)
   {
      switch (opt)
      {
         case 'f':// take over file path
               strcpy(&cFilePath[0],"/dev/root");             
               if(strlen((char*)optarg) < (256 - strlen("/dev/root")-1))
               {
                  strncat(cFilePath,(char*)optarg,strlen((char*)optarg)); 
                  if((s32Ret = OSAL_IOCreate(cFilePath, OSAL_EN_READWRITE)) == OSAL_ERROR)
                  {
                     if(OSAL_u32ErrorCode() == OSAL_E_ALREADYEXISTS)
                     {
                         s32Ret = OSAL_IOOpen(cFilePath, OSAL_EN_READWRITE);
                     }
                     if(s32Ret == OSAL_ERROR)
                     {
                        TraceString("Cannot access file %s Error 0x%x",cFilePath,OSAL_u32ErrorCode());
                     }
                  }
               }
               else
               {
                  TraceString("File path to long");
               }
             break;
         case 't':// check timeout for process living
              msecs = atoi(optarg);
            break;
         case 'e': // trace errmem content
              s32DevDesc = OSAL_IOOpen( OSAL_C_STRING_DEVICE_PRM, OSAL_EN_READWRITE );
              if (s32DevDesc != OSAL_ERROR)
              {
                 if(s32Ret == 0)s32Ret=-1;
                 (void)OSAL_s32IOControl(s32DevDesc, OSAL_C_S32_IOCTRL_PRM_TRIGGER_ERRMEM_TTFIS,(intptr_t)s32Ret);
                 OSAL_s32IOClose(s32DevDesc);
              }
             break;
         case 'd':// set UTC time to Linux		 
               SetOsalSystemTime((char*)optarg);
             break;
         case 'c': // Overwrite existing osal.reg
               snprintf(Buffer,256,"/dev/root%s",optarg);
               if(Buffer[0] != 0)
               {
                  bOverrideOsalConf(&Buffer[0]);
               }
               else
               {
                  TraceString("No file set for overwriting osal.reg values ");
               }
             break;
         case 'p':// print datatypes
               vPrintDataTypes();
               vPrintResources();
             break;
         case 'R':// print Registry content
              vOsalTraceOutRegistry(cPath);
             break;
         case 'r':// print Registry content partly
               snprintf(cPath,256,"/dev/registry%s",optarg);
               vOsalTraceOutRegistry(cPath);
              break;
         case 'L':// print Linux configuration
              vCollectLinuxConf();
             break;
         case 's':
               TraceString("--------------- Process stat + wchan Information --------------------------------");
               vPrintTaskStates(atoi(optarg));
             break;
         case 'x':
               vPrintProzessStates(atoi(optarg));
             break;
         case 'S':
              vPrintTaskStatesViaName(optarg);
             break;
         case 'm':
              if((s32DevDesc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_PRM,OSAL_EN_READWRITE)) != OSAL_ERROR)
              {
                strncpy(cFilePath,optarg,strlen(optarg));
				tmp = strchr(cFilePath,',');
				*tmp = '\0';
				rRemountData.szOption = ++tmp;
                rRemountData.u16AppID = OSAL_C_U16_DIAGNOSIS_APPID;            // ID of the application               
                rRemountData.szPath   = cFilePath;
                TraceString("Remount %s with %s",rRemountData.szPath,rRemountData.szOption);
                OSAL_s32IOControl(s32DevDesc, OSAL_C_S32_IOCTRL_PRM_REMOUNT,(intptr_t)&rRemountData);
                OSAL_s32IOClose(s32DevDesc);
              }
             break;
         case 'a':
 /*            s32DevDesc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_ADR3CTRL, OSAL_EN_READWRITE);
             s32Ret = atoi(optarg);
             if( s32DevDesc != OSAL_ERROR )
             {
                if(OSAL_s32IOControl(s32DevDesc, OSAL_C_S32_IOCTRL_ADR3CTRL_RESET_ADR3,(intptr_t)&s32Ret) == OSAL_ERROR)
                {
                   TraceString("OSAL_C_S32_IOCTRL_ADR3CTRL_RESET_ADR3 Error 0x%x",OSAL_u32ErrorCode());
                }
                else
                {
                   TraceString("OSAL_C_S32_IOCTRL_ADR3CTRL_RESET_ADR3 Succeeded !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                }
                OSAL_s32IOClose(s32DevDesc);
             }*/
             s32DevDesc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_PRM, OSAL_EN_READWRITE);
             s32Ret = atoi(optarg);
             if( s32DevDesc != OSAL_ERROR )
             {
                if(OSAL_s32IOControl(s32DevDesc, OSAL_C_S32_IOCTRL_PRM_RESET_ADR3,(intptr_t)&s32Ret) == OSAL_ERROR)
                {
                   TraceString("OSAL_C_S32_IOCTRL_PRM_RESET_ADR3 Error 0x%x",OSAL_u32ErrorCode());
                }
                else
                {
                   TraceString("OSAL_C_S32_IOCTRL_PRM_RESET_ADR3 Succeeded !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                }
                OSAL_s32IOClose(s32DevDesc);
             }
             break;
        case 'n':
             {
               /* load  and instantiate PRM*/
               OSAL_tIODescriptor d;
               intptr_t Val = 0;
               d = OSAL_IOOpen( OSAL_C_STRING_DEVICE_PRM, OSAL_EN_READWRITE );
               if (d != OSAL_ERROR)
               {
                   /*dummy access to force prm_init */
                   (void)OSAL_s32IOControl(d, OSAL_C_S32_IOCTRL_GET_EXCLUSIVE_ACCESS,(uintptr_t)&Val);
                   OSAL_s32IOClose(d);
               }
            }
             break;		
        case 'q':
            {
               OSAL_tIODescriptor d;
               d = OSAL_IOOpen( OSAL_C_STRING_DEVICE_PRM, OSAL_EN_READWRITE );
               if (d != OSAL_ERROR)
               {
                   char Command[100] = "echo This is a Test ";
                   (void)OSAL_s32IOControl(d, OSAL_C_S32_IOCTRL_PRM_SYSTEM_CALL,(uintptr_t)&Command);
                   OSAL_s32IOClose(d);
               }
            }
             break;		
        case 'w':
              ClearErrMemEntries();
             break;		
        case 'g':
#ifdef TEST_ERRMEM_ENTRIES
             TestErrmem();
#else
             TraceString("empty test entry -g");
#endif
             break;
         case 'o':    
              vPrintOsalProcesses();
             break;			 
         case 'C':    
              msecs = atoi(optarg);
              StartMessageCountTimer(msecs,0);
              msecs += 1000;
             break;			 
         case 'M':    
             {
                char* pcReadBuf = (char*)malloc(32*1024);
                vWriteMemStatToErrmem(pcReadBuf,32*1024,FALSE);
             }
             break;			 
#ifdef QNX 
         case 'Q':    
              InstalldumperConnection(1);
             break;		
         case 'P':    
              PrintSLog();
             break;
#else
         case 'Q':    
         case 'P':    
              TraceString("Only for QNX use cases");
#endif			 
         case 'h':// print help output
              TraceString("Usage: %s [-t msecs] [-s PID] [-S name] [-f file] [-e] [-w] [-d data] [-p] [-R] [-o] [-r path] [-L] [-c file path] [-m path,opt] ",argv[0]);
              TraceString("       [-t msecs] lifetime of the process in msec default is 0");
              TraceString("       [-s PID] Status of all tasks in the process with this PID");
              TraceString("       [-S Name] Status of all tasks in the process with this name pattern");
              TraceString("       [-x PID] various status information of the process with this PID");
              TraceString("       [-f file] [-e] trace error memory content to TTFIS or file with option -f /media/AAM_dev_sda1/Errmemfile.pro");
             TraceString("        [-w] clear error memory content ");
              TraceString("       [-d data] set system time via OSAL -> -d 20.02.2019-12:53:32 ");
              TraceString("       [-L] trace current Linux configuration parameter");
              TraceString("       [-p] show size of data types");  
              TraceString("       [-R] trace registry device content ");
              TraceString("       [-o] trace OSAL processes ");
              TraceString("       [-c] override registry with path like /media/sf_ccstg/64Bit/debug.reg ");
              TraceString("       [-r /LOCAL_MACHINE/SOFTWARE...] trace registry device content for specific Path");
              TraceString("       [-m] remount with file path like /dev/media/AAM_dev_sda1,ro ");
              TraceString("       [-n] start OSAL PRM Instance in context of osalutilprc for test purposes");
              TraceString("       [-q] generate DBUS message for system call for test purposes");
              TraceString("       [-M] generate memory status of the system");
             break;
         default:
              TraceString("Check command option with %s -h ",argv[0]);
             break;
      }
   }
   TraceString("Process will stay alive for %d msec",msecs);
 
   OSAL_s32ThreadWait(msecs);

   OSAL_vProcessExit();
}


#ifdef __cplusplus
}
#endif

/************************************************************************
|end of file Main.cpp
|-----------------------------------------------------------------------*/
