/*****************************************************************************
| FILE:         resethandler.cpp
| PROJECT:      Platform
| SW-COMPONENT: OSAL
|-----------------------------------------------------------------------------
| DESCRIPTION:  This is the implementation file for the OSAL
|               (Operating System Abstraction Layer) 
|
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2017 Bosch GmbH
| HISTORY:      
| Date      | Modification               | Author
| 15.03.17  | Initial revision           | MRK2HI
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/
#ifndef ANDROID

/************************************************************************
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/
#include <errno.h>
#include <mqueue.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>
#include <sys/reboot.h>
#include "resethdr.h"

/************************************************************************
|defines and macros (scope: module-local)
|-----------------------------------------------------------------------*/
//#define DEBUG_RSTINFOSRV

/************************************************************************
|typedefs (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: module-local)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototype (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|function implementation (scope: module-local)
|-----------------------------------------------------------------------*/
void server_error(const char *format, ...)
{
    char buffer[256];
    char temp[256];
    /* Let satisfy lint. */
    va_list args;
    int errmem = open("/dev/errmem", O_WRONLY);
    memset(buffer,0,256);

    if (errmem != -1)
    {
        va_start(args, format);
        vsnprintf(temp, 256, format, args);
        va_end(args);
        sprintf(buffer, "resetinfoserver: %s\n", temp);
        if(write(errmem, buffer, strlen(buffer))){}
        close(errmem);
    }
}

struct option longopts[3] = {
        {"pid",required_argument, 0, 'p'},
        {"pidns",required_argument, 0, 'n'},
        {"execpath",required_argument, 0, 'e'}
  };


int main(int argc, char *argv[])
{
   int ret = 0;
   struct status_msg msg;
   mqd_t mqdes;
   struct mq_attr attr = { 0 };
   int opt, indexptr = 0;
   
#ifdef DEBUG_RSTINFOSRV
   char line[256];
   int i,j=0;
   snprintf(line,256,"/proc/%d/cmdline",getpid());
   int fd = open(line,O_RDONLY);
   memset(line,0,256);
   if (fd != -1) 
   {
      if(read(fd, line,256) == -1){}
      for(i=0;i<256;i++)
      {
         if(line[i] == '\0')line[i]=' ';
         if(line[i] == ' ')j++;
         else j=0;
         if(j>3)
         {
            line[i] = '\0';
            break;
         }
      }
      line[255] = '\0';
      close(fd);
   } 
   server_error("Server started with %s!",line);
#endif	
    /* check for nspid option  */
   while ((opt = getopt_long(argc, argv, "n:e:p",longopts, &indexptr)) != -1) 
   {
      switch (opt)
      {
         case 'n':// check process namespace
             if(optarg)
             {
                 snprintf(msg.pidnamespace, SHORT_STRING, "%s",optarg);
                 server_error("NameSpace PID %s",optarg);
             }
             else
             {
                if(longopts[indexptr].flag)
                {
                   server_error("%s %d %d %d %s ",longopts[indexptr].name,longopts[indexptr].has_arg,*longopts[indexptr].flag,longopts[indexptr].val,optarg);
                }
                else
                {
                   server_error("%s %d %d %d %s",longopts[indexptr].name,longopts[indexptr].has_arg,0,longopts[indexptr].val,optarg);
                }
             }
            break;
         case 'p':// check process ID
             if(optarg)
             {
                  server_error("PID %s",optarg);
             }
             else
             {
                if(longopts[indexptr].flag)
                {
                   server_error("%s %d %d %d %s ",longopts[indexptr].name,longopts[indexptr].has_arg,*longopts[indexptr].flag,longopts[indexptr].val,optarg);
                }
                else
                {
                   server_error("%s %d %d %d %s",longopts[indexptr].name,longopts[indexptr].has_arg,0,longopts[indexptr].val,optarg);
                }
             }
            break;
         case 'e':// executable path
             if(optarg)
             {
                 server_error("Executable %s",optarg);
             }
             else
             {
                if(longopts[indexptr].flag)
                {
                   server_error("%s %d %d %d %s ",longopts[indexptr].name,longopts[indexptr].has_arg,*longopts[indexptr].flag,longopts[indexptr].val,optarg);
                }
                else
                {
                   server_error("%s %d %d %d %s",longopts[indexptr].name,longopts[indexptr].has_arg,0,longopts[indexptr].val,optarg);
                }
             }
            break;
          default:
               server_error("unknown parameter %s is given");
               if(longopts[indexptr].flag)
               {
                  server_error("%s %d %d %d %s ",longopts[indexptr].name,longopts[indexptr].has_arg,*longopts[indexptr].flag,longopts[indexptr].val,optarg);
               }
               else
               {
                  server_error("%s %d %d %d %s",longopts[indexptr].name,longopts[indexptr].has_arg,0,longopts[indexptr].val,optarg);
               }
            break;
      }
   }

   attr.mq_maxmsg = MQ_SIZE_MAX;
   attr.mq_msgsize = sizeof(struct status_msg);
   mqdes = mq_open(MQ_NAME,
                   O_WRONLY | O_NONBLOCK,
                   S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH,
                   &attr);

   if (mqdes < 0)
   {
      server_error("Unable to open message queue (%s) -> reseting system",
                   strerror(errno));
      reboot(RB_AUTOBOOT);
      goto exit;
   }
   else
   {
      snprintf(msg.app_name, APP_NAME_MAX_SIZE, "%s", argv[1]);
      snprintf(msg.service_result, SHORT_STRING, "%s", getenv("SERVICE_RESULT"));
      snprintf(msg.exit_status, SHORT_STRING, "%s", getenv("EXIT_STATUS"));
      snprintf(msg.exit_code, SHORT_STRING, "%s", getenv("EXIT_CODE"));

      ret = mq_send(mqdes, (char *)&msg, sizeof(msg), 0);
      if(ret == -1)
	  {
        server_error("Send: %s %s %s %s %s %s",
                    msg.app_name,
                    msg.service_result,
                    msg.exit_status,
                    msg.exit_code,
                    msg.pidnamespace,
                    ret);
        reboot(RB_AUTOBOOT);
      }
	  else
	  {
#ifdef DEBUG_RSTINFOSRV
         server_error("Send: %s %s %s %s %s ",
                    msg.app_name,
                    msg.service_result,
                    msg.exit_status,
                    msg.exit_code,
                    msg.pidnamespace);
#endif
	  }
   }
#ifdef DEBUG_RSTINFOSRV
   server_error("Server ends !");
#endif

exit:
    mq_close(mqdes);
    return ret;
}

#endif
