/************************************************************************
| FILE:         resethdr.h
| PROJECT:      Platform
| SW-COMPONENT: OSAL IO
|------------------------------------------------------------------------
| DESCRIPTION:  This is the interface for the resethandling process
|
|
|------------------------------------------------------------------------
| COPYRIGHT:    (c) 2005 Blaupunkt GmbH
| HISTORY:      
| Date      | Modification               | Author
| 15.03.17  | Initial revision           | MRK2HI
| --.--.--  | ----------------           | -------, -----
|
|************************************************************************
|
|************************************************************************/

#if !defined (RESETHDR_HEADER)
   #define RESETHDR_HEADER

/************************************************************************ 
| includes of component-internal interfaces
| (scope: component-local)
|-----------------------------------------------------------------------*/ 
     
#ifdef __cplusplus
extern "C" {
#endif

/************************************************************************ 
|defines and macros (scope: global) 
|-----------------------------------------------------------------------*/
#define APP_NAME_MAX_SIZE   4096
#define SHORT_STRING        64
#define MQ_SIZE_MAX         25
#define MQ_NAME             "/reset_status_mq"

/************************************************************************ 
|typedefs and struct defs (scope: global) 
|-----------------------------------------------------------------------*/
struct status_msg {
    char app_name[APP_NAME_MAX_SIZE];
    char service_result[SHORT_STRING];
    char exit_status[SHORT_STRING];
    char exit_code[SHORT_STRING];
    char pidnamespace[SHORT_STRING];
};

/************************************************************************ 
|function prototypes (scope: global) 
|-----------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#else
#error resethdr.h included several times
#endif 
