

#ifndef __OSAL_DIRECT_INTERFACE_H__
#define __OSAL_DIRECT_INTERFACE_H__

// #define MAX_MESSAGE_SIZE 1024*10
#define SUCCESS 0


/**
*  This class is to be used as a direct interface to an OSAL-Application.
*  
*  It can be used to link OSAL_IF-Based applications together with
*  an OSAL_PURE-based Application to get the communication not
*  via socket or an other external line but directly by
*  calling a OSAL-Function.
* 
*  Espacially this will be used to get the WinCE-HMI running on
*  PDA connected to navigation running on PDA.
*
*  @author CM-DI/ESP4 - Tobias Steinmann
*  @date   2005-11-01
*/
class OSALDirectInterface : public OSALInterface  
{
public:
    OSALDirectInterface();
    virtual ~OSALDirectInterface();
    virtual bool bInit(bool bEnableLog);
    virtual bool bEnd();

    virtual int s32MsgQueueWait(OSAL_tMQueueHandle uiHandle, tU32 u32BufSize, tU32 u32TimeOut, unsigned char*pu8MsgBuf,tU32 &u32Prio);
    virtual int s32MsgQueuePost(OSAL_tMQueueHandle uiHandle, tU32 u32MsgSize, unsigned char* ps8Msg, tU32 u32Prio);
    virtual int s32MsgQueueClose(OSAL_tMQueueHandle uiHandle);
    virtual int s32MsgQueueOpen(const char* szQueueName,tU32 u32Access,OSAL_tMQueueHandle& uiHandle);
    virtual int s32MsgQueueCreate(const char* szQueueName,tU32 u32MaxMsgs,tU32 s32MaxLength, tU32 u32Access, OSAL_tMQueueHandle& uiHandle);
    virtual int s32MsgQueueDelete(const char* szQueueName);

    virtual int s32MsgPoolCreate(tU32 u32PoolSize);
    virtual int s32MsgPoolDelete();
    virtual int s32MsgPoolClose();
    virtual int s32MsgPoolOpen();

    virtual OSAL_tShMemHandle hSharedMemoryCreate   (const char* szName, int access, unsigned int u32Size);
    virtual OSAL_tShMemHandle hSharedMemoryOpen     (const char* szName, int access);
    virtual int  s32SharedMemoryClose  (OSAL_tShMemHandle handle);
    virtual int  s32SharedMemoryDelete (const char *szName);

    virtual void *pvSharedMemoryMap     ( OSAL_tShMemHandle handle, 
        int access, 
        unsigned int length, 
        unsigned int offset  );

    virtual int s32SharedMemoryUnmap    (void * sharedMemory, unsigned int size);


    virtual OSAL_tIODescriptor s32IOOpen(tU32 u32Access, const char* szFileName);
    virtual OSAL_tIODescriptor s32IOCreate(tU32 u32Access, const char* szFileName);
    virtual int s32IOClose(OSAL_tIODescriptor fd);
    virtual int s32IOCtrl(OSAL_tIODescriptor fd, tS32 s32Fun, tS32 s32Size, unsigned char *ps8Arg);
    virtual int s32IOCtrl(OSAL_tIODescriptor fd, tS32 s32Fun, intptr_t iArg);
    virtual int s32IORemove(const char* szFileName);
    virtual int s32IORead(OSAL_tIODescriptor fd, tU32 u32BufSize, unsigned char* pu8Buf);
    virtual int s32IOWrite(OSAL_tIODescriptor fd, tU32 u32Size, unsigned char* pu8Buf);

    /* OSAL-IO-Funktionen */
    virtual int s32IOEngFct (const char *device, tS32 s32Fun, unsigned char *ps8Arg, tS32 s32ArgSize);
    virtual int s32IOFakeExclAccess         (const char *device);
    virtual int s32IOReleaseFakedExclAccess (const char *device);

    virtual int s32MiniSPMInitiateShutdown();

    /* OSAL Util-IO Funktionen */
    virtual int s32FSeek(OSAL_tIODescriptor fd,int offset, int origin);
    virtual int s32FTell(OSAL_tIODescriptor fd);
    virtual int s32FGetpos(OSAL_tIODescriptor fd,intptr_t *ptr);
    virtual int s32FSetpos(OSAL_tIODescriptor fd,const intptr_t *ptr);
    virtual int s32FGetSize(OSAL_tIODescriptor fd);
    virtual int s32CreateDir(OSAL_tIODescriptor fd,const char* szDirectory);
    virtual int s32RemoveDir(OSAL_tIODescriptor fd,const char* szDirectory);
    virtual intptr_t prOpenDir(const char* szDirectory);
    virtual intptr_t prReadDir(OSAL_tIODescriptor pDir);
    virtual int s32CloseDir(OSAL_tIODescriptor pDir);

};

#endif // __OSAL_DIRECT_INTERFACE_H__
