#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "OSALInterface.h"
#include "OSALDirectInterface.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

OSALDirectInterface::OSALDirectInterface()
{
}


OSALDirectInterface::~OSALDirectInterface()
{
}

int OSALDirectInterface::s32MsgQueueCreate( const char* szQueueName,
                                           tU32 u32MaxMsgs, 
                                           tU32 u32MaxLength, 
                                           tU32 u32Access, 
                                           OSAL_tMQueueHandle& uiHandle )
{
    return OSAL_s32MessageQueueCreate( szQueueName,
        u32MaxMsgs,
        u32MaxLength,
        (OSAL_tenAccess) u32Access,
        &uiHandle );
}

int OSALDirectInterface::s32MsgQueueDelete(const char* szQueueName)
{
    return OSAL_s32MessageQueueDelete(szQueueName);
}

int OSALDirectInterface::s32MsgQueueOpen(const char* szQueueName,
                                         tU32 u32Access,
                                         OSAL_tMQueueHandle& uiHandle)
{
    return OSAL_s32MessageQueueOpen( szQueueName, 
        (OSAL_tenAccess) u32Access, 
        (OSAL_tMQueueHandle *)&uiHandle );
}

int OSALDirectInterface::s32MsgQueueClose(OSAL_tMQueueHandle uiHandle)
{
    return OSAL_s32MessageQueueClose(uiHandle);
}

int OSALDirectInterface::s32MsgPoolOpen()
{
    return OSAL_s32MessagePoolOpen();
}

int OSALDirectInterface::s32MsgPoolClose()
{
    return OSAL_s32MessagePoolClose();
}

int OSALDirectInterface::s32MsgQueuePost( OSAL_tMQueueHandle uiHandle,
                                         tU32 u32MsgSize, 
                                         unsigned char *pu8Msg, 
                                         tU32 u32Prio)
{
#if 1
    tS32 s32RetVal = 0;
    OSAL_trMessage message;
    // create message in message pool
    s32RetVal = OSAL_s32MessageCreate(&message, u32MsgSize , OSAL_EN_MEMORY_SHARED);
    if (s32RetVal == OSAL_OK)
    {
        // Adresse bestimmen
        tPU8 pointer = OSAL_pu8MessageContentGet(message, OSAL_EN_READWRITE);
        // Nachricht kopieren
        memcpy(pointer, pu8Msg, u32MsgSize);
        // OSAL_s32MessageQueuePost aufrufen
        s32RetVal = OSAL_s32MessageQueuePost(uiHandle, (tPCU8) &message, sizeof(OSAL_trMessage), u32Prio);
    }
    return s32RetVal;
#else
    return OSAL_s32MessageQueuePost(uiHandle, pu8Msg, u32MsgSize, u32Prio);
#endif
}

int OSALDirectInterface::s32MsgQueueWait( OSAL_tMQueueHandle uiHandle, 
                                         tU32 u32BufSize, 
                                         tU32 u32TimeOut, 
                                         unsigned char *pu8MsgBuf,
                                         tU32 &u32Prio )
{
#if 0
    return OSAL_s32MessageQueueWait( uiHandle,
        pu8MsgBuf,
        u32BufSize,
        &u32Prio,
        u32TimeOut );
#else
    // Gre speichern
    OSAL_trMessage message = {(OSAL_tenMemoryLocation)0,0};
    tS32 s32BytesReceived = 0;
    // OSAL_s32MessageQueueWait aufrufen
    tS32 s32RetVal = OSAL_s32MessageQueueWait( uiHandle,
        (tU8*)&message,
        sizeof(OSAL_trMessage),
        (tPU32)&u32Prio,
        u32TimeOut );
    //  if message was received
    if (s32RetVal > 0)
    {
        // determine size of message data
        tU32 u32Size = OSAL_u32GetMessageSize(message);
        // is buffer big enough?
        if (u32Size < u32BufSize)
        {
            tPU8 pointer = OSAL_pu8MessageContentGet(message, OSAL_EN_READWRITE);
            // save msg size
            s32BytesReceived = u32Size;            
            // copy message data
            memcpy(pu8MsgBuf, pointer, u32Size);
            // delete message
            OSAL_s32MessageDelete(message);
        }
    }
    return s32BytesReceived;
#endif
}

bool OSALDirectInterface::bInit(bool bEnableLog)
{
   ((void)bEnableLog);
   return true;
}

bool OSALDirectInterface::bEnd()
{
    return true;
}



OSAL_tShMemHandle  OSALDirectInterface::hSharedMemoryCreate( const char* szName, int access, tU32 u32Size )
{
   ((void)szName);
   ((void)access);
   ((void)u32Size);
    return -1;
}

OSAL_tShMemHandle  OSALDirectInterface::hSharedMemoryOpen( const char* szName, int access )
{
   ((void)szName);
   ((void)access);
    return -1;
}

int  OSALDirectInterface::s32SharedMemoryClose( OSAL_tShMemHandle handle )
{
   ((void)handle);
   return -1;
}

int  OSALDirectInterface::s32SharedMemoryDelete (const char *szName)
{
   ((void)szName);
   return -1;
}

void *OSALDirectInterface::pvSharedMemoryMap( OSAL_tShMemHandle handle,
                                                  int access, 
                                                  tU32 length, 
                                                  tU32 offset  )
{
   ((void)handle);
   ((void)access);
   ((void)length);
   ((void)offset);
    return 0;
}

int OSALDirectInterface::s32SharedMemoryUnmap    (void * sharedMemory, tU32 size)
{
   ((void)sharedMemory);
   ((void)size);
    return -1;
}



OSAL_tIODescriptor OSALDirectInterface::s32IOOpen( tU32 u32Access, const char* szFileName )
{
   ((void)u32Access);
   ((void)szFileName);
    return -1;
}

OSAL_tIODescriptor OSALDirectInterface::s32IOCreate( tU32 u32Access, const char* szFileName )
{
   ((void)u32Access);
   ((void)szFileName);
    return -1;
}

int OSALDirectInterface::s32IOClose(OSAL_tIODescriptor s32Descriptor)
{
   ((void)s32Descriptor);
   return -1;
}

int OSALDirectInterface::s32IOCtrl(OSAL_tIODescriptor s32Descriptor, tS32 s32Fun, tS32 s32Size, unsigned char *ps8Arg)
{
   ((void)s32Descriptor);
   ((void)s32Fun);
   ((void)s32Size);
   ((void)ps8Arg);
   return -1;
}

int OSALDirectInterface::s32IOCtrl(OSAL_tIODescriptor s32Descriptor, tS32 s32Fun, intptr_t arg)
{
   ((void)s32Descriptor);
   ((void)s32Fun);
   ((void)arg);
   return -1;
}

int OSALDirectInterface::s32IORemove(const char* szFileName)
{
   ((void)szFileName);
   return -1;
}

int OSALDirectInterface::s32IORead(OSAL_tIODescriptor s32Descriptor, tU32 u32BufSize, unsigned char* pu8Buf)
{
   ((void)s32Descriptor);
   ((void)u32BufSize);
   ((void)pu8Buf);
   return -1;
}

int OSALDirectInterface::s32IOWrite(OSAL_tIODescriptor s32Descriptor, tU32 u32Size, unsigned char* pu8Buf)
{
   ((void)s32Descriptor);
   ((void)u32Size);
   ((void)pu8Buf);
   return -1;
}

int OSALDirectInterface::s32MsgPoolCreate(tU32 u32PoolSize)
{
   ((void)u32PoolSize);
   return -1;
}

int OSALDirectInterface::s32MsgPoolDelete()
{
    return -1;
}

int OSALDirectInterface::s32IOEngFct ( const char *device, 
                                      tS32 s32Fun, 
                                      unsigned char *ps8Arg, 
                                      tS32 s32ArgSize)
{
   ((void)device);
   ((void)s32Fun);
   ((void)ps8Arg);
   ((void)s32ArgSize);
   return -1;
}

int OSALDirectInterface::s32IOFakeExclAccess (const char *device)
{
   ((void)device);
   return -1;
}

int OSALDirectInterface::s32IOReleaseFakedExclAccess (const char *device)
{
   ((void)device);
   return -1;
}

int OSALDirectInterface::s32MiniSPMInitiateShutdown()
{
    return -1;
}

int OSALDirectInterface::s32FSeek(OSAL_tIODescriptor fd,int offset, int origin)
{
    return OSALUTIL_s32FSeek(fd, offset, origin);
}

int OSALDirectInterface::s32FTell(OSAL_tIODescriptor fd)
{
    return OSALUTIL_s32FTell(fd);
}

int OSALDirectInterface::s32FGetpos( OSAL_tIODescriptor fd, intptr_t *ptr )
{
    return OSALUTIL_s32FGetpos( fd, ptr);
}

int OSALDirectInterface::s32FSetpos( OSAL_tIODescriptor fd, const intptr_t *ptr )
{
   // const_cast is necessary due to messed up OSAL interface.
   // "const tPS32" is NOT the same as "const tS32*" but means "tS32* const"
   // meaning "you may modify the pointed to memory but not the pointer"
   return OSALUTIL_s32FSetpos( (OSAL_tIODescriptor)fd, const_cast<intptr_t *>(ptr));
}

int OSALDirectInterface::s32FGetSize(OSAL_tIODescriptor fd)
{
    return OSALUTIL_s32FGetSize(fd);
}

int OSALDirectInterface::s32CreateDir(OSAL_tIODescriptor fd,const char* szDirectory)
{
    return OSALUTIL_s32CreateDir(fd, (tCString) szDirectory);
}

int OSALDirectInterface::s32RemoveDir(OSAL_tIODescriptor fd,const char* szDirectory)
{
    return (int)OSALUTIL_s32RemoveDir(fd, (tCString) szDirectory);
}

intptr_t OSALDirectInterface::prOpenDir(const char* szDirectory)
{
    return (intptr_t)OSALUTIL_prOpenDir((tCString)szDirectory);
}

intptr_t OSALDirectInterface::prReadDir(intptr_t pDir)
{
    return (intptr_t)OSALUTIL_prReadDir((OSAL_trIOCtrlDir*) pDir);
}

int OSALDirectInterface::s32CloseDir(intptr_t pDir)
{
    return OSALUTIL_s32CloseDir((OSAL_trIOCtrlDir*) pDir);
}
